/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Path;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.jmrit.blockboss.BlockBossLogic;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.jmrit.signalling.SignallingGuiTools;
import jmri.util.ColorUtil;
import jmri.util.MathUtil;
import jmri.util.QuickPromptUtil;
import jmri.util.swing.JCBHandle;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePointView
extends LayoutTrackView {
    protected NamedBeanHandle<SignalHead> signalEastHeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalWestHeadNamed = null;
    private NamedBeanHandle<SignalMast> eastBoundSignalMastNamed = null;
    private NamedBeanHandle<SignalMast> westBoundSignalMastNamed = null;
    private NamedBeanHandle<Sensor> eastBoundSensorNamed = null;
    private NamedBeanHandle<Sensor> westBoundSensorNamed = null;
    private final PositionablePoint positionablePoint;
    public String trackSegment1Name = "";
    public String trackSegment2Name = "";
    int xClick = 0;
    int yClick = 0;
    private JPopupMenu popup = null;
    private boolean active = true;
    JDialog editLink = null;
    JComboBox<String> linkPointsBox;
    JComboBox<JCBHandle<LayoutEditor>> editorCombo;
    private ArrayList<PositionablePoint> pointList;
    private static final Logger log = LoggerFactory.getLogger(PositionablePointView.class);

    public PositionablePointView(@Nonnull PositionablePoint point, Point2D c, @Nonnull LayoutEditor layoutEditor) {
        super(point, c, layoutEditor);
        this.positionablePoint = point;
    }

    public PositionablePoint getPoint() {
        return this.positionablePoint;
    }

    public String toString() {
        String result = "PositionalablePoint";
        switch (this.getType()) {
            case ANCHOR: {
                result = "Anchor";
                break;
            }
            case END_BUMPER: {
                result = "End Bumper";
                break;
            }
            case EDGE_CONNECTOR: {
                result = "Edge Connector";
                break;
            }
            default: {
                result = "Unknown type (" + (Object)((Object)this.getType()) + ")";
            }
        }
        return String.valueOf(result) + " '" + this.getName() + "'";
    }

    public PositionablePoint.PointType getType() {
        return this.positionablePoint.getType();
    }

    public void setType(PositionablePoint.PointType newType) {
        this.positionablePoint.setType(newType);
        if (this.getType() != newType) {
            switch (newType) {
                default: {
                    this.setTypeAnchor();
                    break;
                }
                case END_BUMPER: {
                    this.setTypeEndBumper();
                    break;
                }
                case EDGE_CONNECTOR: {
                    this.setTypeEdgeConnector();
                }
            }
            this.layoutEditor.repaint();
        }
    }

    private void setTypeAnchor() {
        this.setIdent(this.layoutEditor.getFinder().uniqueName("A", 1));
        this.positionablePoint.setTypeAnchor();
        if (this.getConnect1() != null) {
            TrackSegmentView ctv1 = this.layoutEditor.getTrackSegmentView(this.getConnect1());
            if (this.getConnect1().getConnect1() == this.positionablePoint) {
                ctv1.setArrowEndStart(false);
                ctv1.setBumperEndStart(false);
            }
            if (this.getConnect1().getConnect2() == this.positionablePoint) {
                ctv1.setArrowEndStop(false);
                ctv1.setBumperEndStop(false);
            }
        }
        if (this.getConnect2() != null) {
            TrackSegmentView ctv2 = this.layoutEditor.getTrackSegmentView(this.getConnect2());
            if (this.getConnect2().getConnect1() == this.positionablePoint) {
                ctv2.setArrowEndStart(false);
                ctv2.setBumperEndStart(false);
            }
            if (this.getConnect2().getConnect2() == this.positionablePoint) {
                ctv2.setArrowEndStop(false);
                ctv2.setBumperEndStop(false);
            }
        }
    }

    private void setTypeEndBumper() {
        this.setIdent(this.layoutEditor.getFinder().uniqueName("EB", 1));
        this.positionablePoint.setTypeEndBumper();
        if (this.getConnect1() != null) {
            TrackSegmentView ctv1 = this.layoutEditor.getTrackSegmentView(this.getConnect1());
            if (this.getConnect1().getConnect1() == this.positionablePoint) {
                ctv1.setArrowEndStart(false);
                ctv1.setBumperEndStart(true);
            }
            if (this.getConnect1().getConnect2() == this.positionablePoint) {
                ctv1.setArrowEndStop(false);
                ctv1.setBumperEndStop(true);
            }
        }
    }

    private void setTypeEdgeConnector() {
        this.setIdent(this.layoutEditor.getFinder().uniqueName("EC", 1));
        this.positionablePoint.setTypeEdgeConnector();
        if (this.getConnect1() != null) {
            TrackSegmentView ctv1 = this.layoutEditor.getTrackSegmentView(this.getConnect1());
            if (this.getConnect1().getConnect1() == this.positionablePoint) {
                ctv1.setBumperEndStart(false);
            }
            if (this.getConnect1().getConnect2() == this.positionablePoint) {
                ctv1.setBumperEndStop(false);
            }
        }
    }

    public TrackSegment getConnect1() {
        return this.positionablePoint.getConnect1();
    }

    public TrackSegment getConnect2() {
        return this.positionablePoint.getConnect2();
    }

    public String getLinkedEditorName() {
        return this.positionablePoint.getLinkedEditorName();
    }

    public LayoutEditor getLinkedEditor() {
        return this.positionablePoint.getLinkedEditor();
    }

    public PositionablePoint getLinkedPoint() {
        return this.positionablePoint.getLinkedPoint();
    }

    public void removeLinkedPoint() {
        this.positionablePoint.removeLinkedPoint();
    }

    public String getLinkedPointId() {
        return this.positionablePoint.getLinkedPointId();
    }

    public void setLinkedPoint(PositionablePoint p) {
        this.positionablePoint.setLinkedPoint(p);
    }

    @Override
    public void scaleCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.granulize(MathUtil.multiply(this.getCoordsCenter(), (Point2D)factor), 1.0));
    }

    @Override
    public void translateCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.add(this.getCoordsCenter(), factor));
    }

    @Override
    public void rotateCoords(double angleDEG) {
    }

    @Override
    public Rectangle2D getBounds() {
        Point2D c = this.getCoordsCenter();
        return new Rectangle2D.Double(c.getX() - 0.5, c.getY() - 0.5, 1.0, 1.0);
    }

    @CheckReturnValue
    protected LayoutEditor getLayoutEditor() {
        return this.layoutEditor;
    }

    @CheckReturnValue
    @Nonnull
    public String getEastBoundSignal() {
        SignalHead h = this.getEastBoundSignalHead();
        if (h != null) {
            return h.getDisplayName();
        }
        return "";
    }

    @CheckForNull
    @CheckReturnValue
    public SignalHead getEastBoundSignalHead() {
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 64 || dir == 32 || dir == 96) {
                if (this.signalEastHeadNamed != null) {
                    return this.signalEastHeadNamed.getBean();
                }
                return null;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 32 || linkDir == 64 || linkDir == 96)) {
                return this.getLinkedPoint().getEastBoundSignalHead();
            }
        }
        if (this.signalEastHeadNamed != null) {
            return this.signalEastHeadNamed.getBean();
        }
        return null;
    }

    public void setEastBoundSignal(String signalName) {
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 64 || dir == 32 || dir == 96) {
                this.setEastBoundSignalName(signalName);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 32 || linkDir == 64 || linkDir == 96) {
                    this.getLinkedPoint().setEastBoundSignal(signalName);
                } else {
                    this.setEastBoundSignalName(signalName);
                }
            } else {
                this.setEastBoundSignalName(signalName);
            }
        } else {
            this.setEastBoundSignalName(signalName);
        }
    }

    private void setEastBoundSignalName(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalEastHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalEastHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @CheckReturnValue
    @Nonnull
    public String getWestBoundSignal() {
        SignalHead h = this.getWestBoundSignalHead();
        if (h != null) {
            return h.getDisplayName();
        }
        return "";
    }

    @CheckForNull
    @CheckReturnValue
    public SignalHead getWestBoundSignalHead() {
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                if (this.signalWestHeadNamed != null) {
                    return this.signalWestHeadNamed.getBean();
                }
                return null;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 128 || linkDir == 16 || linkDir == 144)) {
                return this.getLinkedPoint().getWestBoundSignalHead();
            }
        }
        if (this.signalWestHeadNamed != null) {
            return this.signalWestHeadNamed.getBean();
        }
        return null;
    }

    public void setWestBoundSignal(String signalName) {
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                this.setWestBoundSignalName(signalName);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 128 || linkDir == 16 || linkDir == 144) {
                    this.getLinkedPoint().setWestBoundSignal(signalName);
                } else {
                    this.setWestBoundSignalName(signalName);
                }
            } else {
                this.setWestBoundSignalName(signalName);
            }
        } else {
            this.setWestBoundSignalName(signalName);
        }
    }

    private void setWestBoundSignalName(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalWestHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalWestHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @CheckReturnValue
    @Nonnull
    public String getEastBoundSensorName() {
        if (this.eastBoundSensorNamed != null) {
            return this.eastBoundSensorNamed.getName();
        }
        return "";
    }

    @CheckReturnValue
    public Sensor getEastBoundSensor() {
        if (this.eastBoundSensorNamed != null) {
            return this.eastBoundSensorNamed.getBean();
        }
        return null;
    }

    public void setEastBoundSensor(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.eastBoundSensorNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.eastBoundSensorNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.eastBoundSensorNamed = null;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getWestBoundSensorName() {
        if (this.westBoundSensorNamed != null) {
            return this.westBoundSensorNamed.getName();
        }
        return "";
    }

    @CheckReturnValue
    public Sensor getWestBoundSensor() {
        if (this.westBoundSensorNamed != null) {
            return this.westBoundSensorNamed.getBean();
        }
        return null;
    }

    public void setWestBoundSensor(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.westBoundSensorNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.westBoundSensorNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.westBoundSensorNamed = null;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getEastBoundSignalMastName() {
        if (this.getEastBoundSignalMastNamed() != null) {
            return this.getEastBoundSignalMastNamed().getName();
        }
        return "";
    }

    @CheckReturnValue
    public SignalMast getEastBoundSignalMast() {
        if (this.getEastBoundSignalMastNamed() != null) {
            return this.getEastBoundSignalMastNamed().getBean();
        }
        return null;
    }

    @CheckReturnValue
    private NamedBeanHandle<SignalMast> getEastBoundSignalMastNamed() {
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 32 || dir == 64 || dir == 96) {
                return this.eastBoundSignalMastNamed;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 32 || linkDir == 64 || linkDir == 96)) {
                return this.getLinkedPoint().getEastBoundSignalMastNamed();
            }
        }
        return this.eastBoundSignalMastNamed;
    }

    public void setEastBoundSignalMast(String signalMast) {
        SignalMast mast = null;
        if (signalMast != null && !signalMast.isEmpty()) {
            mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
            if (mast == null) {
                log.error("{}.setEastBoundSignalMast({}); Unable to find Signal Mast", (Object)this.getName(), (Object)signalMast);
                return;
            }
        } else {
            this.eastBoundSignalMastNamed = null;
            return;
        }
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 64 || dir == 32 || dir == 96) {
                this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 32 || linkDir == 64 || linkDir == 96) {
                    this.getLinkedPoint().setEastBoundSignalMast(signalMast);
                } else {
                    this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
                }
            } else {
                this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            }
        } else {
            this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getWestBoundSignalMastName() {
        if (this.getWestBoundSignalMastNamed() != null) {
            return this.getWestBoundSignalMastNamed().getName();
        }
        return "";
    }

    @CheckReturnValue
    public SignalMast getWestBoundSignalMast() {
        if (this.getWestBoundSignalMastNamed() != null) {
            return this.getWestBoundSignalMastNamed().getBean();
        }
        return null;
    }

    @CheckReturnValue
    private NamedBeanHandle<SignalMast> getWestBoundSignalMastNamed() {
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                return this.westBoundSignalMastNamed;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 128 || linkDir == 16 || linkDir == 144)) {
                return this.getLinkedPoint().getWestBoundSignalMastNamed();
            }
        }
        return this.westBoundSignalMastNamed;
    }

    public void setWestBoundSignalMast(String signalMast) {
        SignalMast mast = null;
        if (signalMast != null && !signalMast.isEmpty()) {
            mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
            if (mast == null) {
                log.error("{}.setWestBoundSignalMast({}); Unable to find Signal Mast", (Object)this.getName(), (Object)signalMast);
                return;
            }
        } else {
            this.westBoundSignalMastNamed = null;
            return;
        }
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 128 || linkDir == 16 || linkDir == 144) {
                    this.getLinkedPoint().setWestBoundSignalMast(signalMast);
                } else {
                    this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
                }
            } else {
                this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            }
        } else {
            this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
    }

    public void removeBeanReference(NamedBean nb) {
        if (nb == null) {
            return;
        }
        if (nb instanceof SignalMast) {
            if (nb.equals(this.getWestBoundSignalMast())) {
                this.setWestBoundSignalMast(null);
            } else if (nb.equals(this.getEastBoundSignalMast())) {
                this.setEastBoundSignalMast(null);
            }
        } else if (nb instanceof Sensor) {
            if (nb.equals(this.getWestBoundSensor())) {
                this.setWestBoundSignalMast(null);
            } else if (nb.equals(this.getEastBoundSensor())) {
                this.setEastBoundSignalMast(null);
            }
        } else if (nb instanceof SignalHead) {
            if (nb.equals(this.getWestBoundSignalHead())) {
                this.setWestBoundSignal(null);
            }
            if (nb.equals(this.getEastBoundSignalHead())) {
                this.setEastBoundSignal(null);
            }
        }
    }

    public boolean setTrackConnection(@Nonnull TrackSegment track) {
        return this.replaceTrackConnection(null, track);
    }

    public boolean removeTrackConnection(@Nonnull TrackSegment track) {
        return this.replaceTrackConnection(track, null);
    }

    public boolean replaceTrackConnection(@CheckForNull TrackSegment oldTrack, @CheckForNull TrackSegment newTrack) {
        boolean result = false;
        if (newTrack == null) {
            if (oldTrack != null) {
                result = true;
                if (this.getConnect1() == oldTrack) {
                    this.positionablePoint.setConnect1(null);
                    this.reCheckBlockBoundary();
                    this.removeLinkedPoint();
                    this.positionablePoint.setConnect1(this.getConnect2());
                    this.positionablePoint.setConnect2Actual(null);
                } else if (this.getConnect2() == oldTrack) {
                    this.positionablePoint.setConnect2Actual(null);
                    this.reCheckBlockBoundary();
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
            if (!result) {
                log.error("{}.replaceTrackConnection({}, {}); Attempt to remove non-existant track connection", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), "null"});
            }
        } else if (this.getConnect1() != newTrack && this.getConnect2() != newTrack) {
            result = true;
            if (this.getConnect1() == oldTrack) {
                this.positionablePoint.setConnect1(newTrack);
            } else if (this.getType() == PositionablePoint.PointType.ANCHOR && this.getConnect2() == oldTrack) {
                this.positionablePoint.setConnect2Actual(newTrack);
                if (this.getConnect1().getLayoutBlock() == this.getConnect2().getLayoutBlock()) {
                    this.westBoundSignalMastNamed = null;
                    this.eastBoundSignalMastNamed = null;
                    this.setWestBoundSensor("");
                    this.setEastBoundSensor("");
                }
            } else {
                log.error("{}.replaceTrackConnection({}, {}); Attempt to assign more than allowed number of connections", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), newTrack.getName()});
                result = false;
            }
        } else {
            log.warn("{}.replaceTrackConnection({}, {}); Already connected", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), newTrack.getName()});
            result = false;
        }
        return result;
    }

    void removeSML(SignalMast signalMast) {
        if (signalMast == null) {
            return;
        }
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && InstanceManager.getDefault(SignalMastLogicManager.class).isSignalMastUsed(signalMast)) {
            SignallingGuiTools.removeSignalMastLogic(null, signalMast);
        }
    }

    protected int maxWidth() {
        return 5;
    }

    protected int maxHeight() {
        return 5;
    }

    public void mousePressed(MouseEvent e) {
        this.xClick = e.getX();
        this.yClick = e.getY();
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    @Nonnull
    protected JPopupMenu showPopup(@Nonnull MouseEvent mouseEvent) {
        if (this.popup != null) {
            this.popup.removeAll();
        } else {
            this.popup = new JPopupMenu();
        }
        boolean blockBoundary = false;
        boolean addSensorsAndSignalMasksMenuItemsFlag = false;
        JMenuItem jmi = null;
        switch (this.getType()) {
            case ANCHOR: {
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Anchor"))) + this.getName());
                jmi.setEnabled(false);
                LayoutBlock block1 = null;
                if (this.getConnect1() != null) {
                    block1 = this.getConnect1().getLayoutBlock();
                }
                LayoutBlock block2 = block1;
                if (this.getConnect2() != null) {
                    block2 = this.getConnect2().getLayoutBlock();
                }
                if (block1 != null && block1 == block2) {
                    jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameBlock"))) + block1.getDisplayName());
                } else if (block1 != null && block2 != null && block1 != block2) {
                    jmi = this.popup.add(Bundle.getMessage("BlockDivider"));
                    jmi.setEnabled(false);
                    jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", 1))) + block1.getDisplayName());
                    jmi.setEnabled(false);
                    jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", 2))) + block2.getDisplayName());
                    jmi.setEnabled(false);
                    blockBoundary = true;
                }
                jmi.setEnabled(false);
                break;
            }
            case END_BUMPER: {
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("EndBumper"))) + this.getName());
                jmi.setEnabled(false);
                LayoutBlock blockEnd = null;
                if (this.getConnect1() != null) {
                    blockEnd = this.getConnect1().getLayoutBlock();
                }
                if (blockEnd == null) break;
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("BlockID"))) + blockEnd.getDisplayName());
                jmi.setEnabled(false);
                addSensorsAndSignalMasksMenuItemsFlag = true;
                break;
            }
            case EDGE_CONNECTOR: {
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("EdgeConnector"))) + this.getName());
                jmi.setEnabled(false);
                if (this.getLinkedEditor() != null) {
                    String linkName = String.valueOf(this.getLinkedEditorName()) + ":" + this.getLinkedPointId();
                    jmi = this.popup.add(Bundle.getMessage("LinkedToX", linkName));
                } else {
                    jmi = this.popup.add(Bundle.getMessage("EdgeNotLinked"));
                }
                jmi.setEnabled(false);
                LayoutBlock block1 = null;
                if (this.getConnect1() != null) {
                    block1 = this.getConnect1().getLayoutBlock();
                }
                LayoutBlock block2 = block1;
                if (this.getLinkedPoint() != null && this.getLinkedPoint().getConnect1() != null) {
                    block2 = this.getLinkedPoint().getConnect1().getLayoutBlock();
                }
                if (block1 != null && block1 == block2) {
                    jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameBlock"))) + block1.getDisplayName());
                    break;
                }
                if (block1 == null || block2 == null || block1 == block2) break;
                jmi = this.popup.add(Bundle.getMessage("BlockDivider"));
                jmi.setEnabled(false);
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", 1))) + block1.getDisplayName());
                jmi.setEnabled(false);
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", 2))) + block2.getDisplayName());
                jmi.setEnabled(false);
                blockBoundary = true;
                break;
            }
        }
        if (this.getConnect1() != null || this.getConnect2() != null) {
            JMenu connectionsMenu = new JMenu(Bundle.getMessage("Connections"));
            if (this.getConnect1() != null) {
                connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "1")) + this.getConnect1().getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorFindItems lf = PositionablePointView.this.layoutEditor.getFinder();
                        LayoutTrack lt = lf.findObjectByName(PositionablePointView.this.getConnect1().getName());
                        if (lt != null) {
                            LayoutTrackView ltv = PositionablePointView.this.layoutEditor.getLayoutTrackView(lt);
                            PositionablePointView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                            ltv.showPopup();
                        }
                    }
                });
            }
            if (this.getConnect2() != null) {
                connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "2")) + this.getConnect2().getName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorFindItems lf = PositionablePointView.this.layoutEditor.getFinder();
                        LayoutTrack lt = lf.findObjectByName(PositionablePointView.this.getConnect2().getName());
                        if (lt != null) {
                            LayoutTrackView ltv = PositionablePointView.this.layoutEditor.getLayoutTrackView(lt);
                            PositionablePointView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                            ltv.showPopup();
                        }
                    }
                });
            }
            this.popup.add(connectionsMenu);
        }
        if (this.getConnect1() != null) {
            this.popup.add(new JSeparator(0));
            JMenu decorationsMenu = new JMenu(Bundle.getMessage("DecorationMenuTitle"));
            decorationsMenu.setToolTipText(Bundle.getMessage("DecorationMenuToolTip"));
            this.popup.add(decorationsMenu);
            TrackSegmentView ctv1 = this.layoutEditor.getTrackSegmentView(this.getConnect1());
            if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
                JMenu arrowsMenu = new JMenu(Bundle.getMessage("ArrowsMenuTitle"));
                decorationsMenu.setToolTipText(Bundle.getMessage("ArrowsMenuToolTip"));
                decorationsMenu.add(arrowsMenu);
                JMenu arrowsCountMenu = new JMenu(Bundle.getMessage("DecorationStyleMenuTitle"));
                arrowsCountMenu.setToolTipText(Bundle.getMessage("DecorationStyleMenuToolTip"));
                arrowsMenu.add(arrowsCountMenu);
                JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
                arrowsCountMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    if (this.getConnect1().getConnect1() == this.positionablePoint) {
                        ctv1.setArrowEndStart(false);
                    }
                    if (this.getConnect1().getConnect2() == this.positionablePoint) {
                        ctv1.setArrowEndStop(false);
                    }
                    if (!ctv1.isArrowEndStart() && !ctv1.isArrowEndStop()) {
                        ctv1.setArrowStyle(0);
                    }
                });
                boolean etherEnd = this.getConnect1().getConnect1() == this.positionablePoint && ctv1.isArrowEndStart() || this.getConnect1().getConnect2() == this.positionablePoint && ctv1.isArrowEndStop();
                jcbmi.setSelected(ctv1.getArrowStyle() == 0 || !etherEnd);
                int i = 1;
                while (i < 6) {
                    jcbmi = this.loadArrowImageToJCBItem(i, arrowsCountMenu);
                    int n = i;
                    jcbmi.addActionListener(e3 -> {
                        if (this.getConnect1().getConnect1() == this.positionablePoint) {
                            ctv1.setArrowEndStart(true);
                        }
                        if (this.getConnect1().getConnect2() == this.positionablePoint) {
                            ctv1.setArrowEndStop(true);
                        }
                        ctv1.setArrowStyle(n);
                    });
                    jcbmi.setSelected(ctv1.getArrowStyle() == i && etherEnd);
                    ++i;
                }
                JMenu arrowsDirMenu = new JMenu(Bundle.getMessage("ArrowsDirectionMenuTitle"));
                arrowsDirMenu.setToolTipText(Bundle.getMessage("ArrowsDirectionMenuToolTip"));
                arrowsMenu.add(arrowsDirMenu);
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("DecorationNoneMenuItemTitle"));
                arrowsDirMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("DecorationNoneMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    ctv.setArrowDirIn(false);
                    ctv.setArrowDirOut(false);
                });
                jcbmi.setSelected(!ctv1.isArrowDirIn() && !ctv1.isArrowDirOut());
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("ArrowsDirectionInMenuItemTitle"));
                arrowsDirMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("ArrowsDirectionInMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    ctv.setArrowDirIn(true);
                    ctv.setArrowDirOut(false);
                });
                jcbmi.setSelected(ctv1.isArrowDirIn() && !ctv1.isArrowDirOut());
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("ArrowsDirectionOutMenuItemTitle"));
                arrowsDirMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("ArrowsDirectionOutMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    ctv.setArrowDirOut(true);
                    ctv.setArrowDirIn(false);
                });
                jcbmi.setSelected(!ctv1.isArrowDirIn() && ctv1.isArrowDirOut());
                jcbmi = new JCheckBoxMenuItem(Bundle.getMessage("ArrowsDirectionBothMenuItemTitle"));
                arrowsDirMenu.add(jcbmi);
                jcbmi.setToolTipText(Bundle.getMessage("ArrowsDirectionBothMenuItemToolTip"));
                jcbmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    ctv.setArrowDirIn(true);
                    ctv.setArrowDirOut(true);
                });
                jcbmi.setSelected(ctv1.isArrowDirIn() && ctv1.isArrowDirOut());
                jmi = arrowsMenu.add(new JMenuItem(Bundle.getMessage("DecorationColorMenuItemTitle")));
                jmi.setToolTipText(Bundle.getMessage("DecorationColorMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    Color newColor = JmriColorChooser.showDialog(null, "Choose a color", ctv.getArrowColor());
                    if (newColor != null && !newColor.equals(ctv.getArrowColor())) {
                        ctv.setArrowColor(newColor);
                    }
                });
                jmi.setForeground(ctv1.getArrowColor());
                jmi.setBackground(ColorUtil.contrast(ctv1.getArrowColor()));
                jmi = arrowsMenu.add(new JMenuItem(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLineWidthMenuItemTitle"))) + ctv1.getArrowLineWidth()));
                jmi.setToolTipText(Bundle.getMessage("DecorationLineWidthMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    int newValue = QuickPromptUtil.promptForInt(this.layoutEditor, Bundle.getMessage("DecorationLineWidthMenuItemTitle"), Bundle.getMessage("DecorationLineWidthMenuItemTitle"), ctv.getArrowLineWidth());
                    ctv.setArrowLineWidth(newValue);
                });
                jmi = arrowsMenu.add(new JMenuItem(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLengthMenuItemTitle"))) + ctv1.getArrowLength()));
                jmi.setToolTipText(Bundle.getMessage("DecorationLengthMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    int newValue = QuickPromptUtil.promptForInt(this.layoutEditor, Bundle.getMessage("DecorationLengthMenuItemTitle"), Bundle.getMessage("DecorationLengthMenuItemTitle"), ctv.getArrowLength());
                    ctv.setArrowLength(newValue);
                });
                jmi = arrowsMenu.add(new JMenuItem(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationGapMenuItemTitle"))) + ctv1.getArrowGap()));
                jmi.setToolTipText(Bundle.getMessage("DecorationGapMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    int newValue = QuickPromptUtil.promptForInt(this.layoutEditor, Bundle.getMessage("DecorationGapMenuItemTitle"), Bundle.getMessage("DecorationGapMenuItemTitle"), ctv.getArrowGap());
                    ctv.setArrowGap(newValue);
                });
            } else {
                JMenu endBumperMenu = new JMenu(Bundle.getMessage("EndBumperMenuTitle"));
                decorationsMenu.setToolTipText(Bundle.getMessage("EndBumperMenuToolTip"));
                decorationsMenu.add(endBumperMenu);
                JCheckBoxMenuItem enableCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("EndBumperEnableMenuItemTitle"));
                enableCheckBoxMenuItem.setToolTipText(Bundle.getMessage("EndBumperEnableMenuItemToolTip"));
                endBumperMenu.add(enableCheckBoxMenuItem);
                enableCheckBoxMenuItem.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    if (this.getConnect1().getConnect1() == this.positionablePoint) {
                        ctv.setBumperEndStart(enableCheckBoxMenuItem.isSelected());
                    }
                    if (this.getConnect1().getConnect2() == this.positionablePoint) {
                        ctv.setBumperEndStop(enableCheckBoxMenuItem.isSelected());
                    }
                });
                if (this.getConnect1().getConnect1() == this.positionablePoint) {
                    enableCheckBoxMenuItem.setSelected(ctv1.isBumperEndStart());
                }
                if (this.getConnect1().getConnect2() == this.positionablePoint) {
                    enableCheckBoxMenuItem.setSelected(ctv1.isBumperEndStop());
                }
                jmi = endBumperMenu.add(new JMenuItem(Bundle.getMessage("DecorationColorMenuItemTitle")));
                jmi.setToolTipText(Bundle.getMessage("DecorationColorMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    Color newColor = JmriColorChooser.showDialog(null, "Choose a color", ctv.getBumperColor());
                    if (newColor != null && !newColor.equals(ctv.getBumperColor())) {
                        ctv.setBumperColor(newColor);
                    }
                });
                jmi.setForeground(ctv1.getBumperColor());
                jmi.setBackground(ColorUtil.contrast(ctv1.getBumperColor()));
                jmi = endBumperMenu.add(new JMenuItem(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLineWidthMenuItemTitle"))) + ctv1.getBumperLineWidth()));
                jmi.setToolTipText(Bundle.getMessage("DecorationLineWidthMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage("DecorationLineWidthMenuItemTitle"), Bundle.getMessage("DecorationLineWidthMenuItemTitle"), ctv.getBumperLineWidth(), t -> {
                        if (t < 0 || t > 10) {
                            throw new IllegalArgumentException(Bundle.getMessage("DecorationLengthMenuItemRange", 10));
                        }
                        return true;
                    });
                    ctv.setBumperLineWidth(newValue);
                });
                jmi = endBumperMenu.add(new JMenuItem(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("DecorationLengthMenuItemTitle"))) + ctv1.getBumperLength()));
                jmi.setToolTipText(Bundle.getMessage("DecorationLengthMenuItemToolTip"));
                jmi.addActionListener(e3 -> {
                    TrackSegmentView ctv = this.layoutEditor.getTrackSegmentView(this.getConnect1());
                    int newValue = QuickPromptUtil.promptForInteger(this.layoutEditor, Bundle.getMessage("DecorationLengthMenuItemTitle"), Bundle.getMessage("DecorationLengthMenuItemTitle"), ctv.getBumperLength(), t -> {
                        if (t < 0 || t > 40) {
                            throw new IllegalArgumentException(Bundle.getMessage("DecorationLengthMenuItemRange", 40));
                        }
                        return true;
                    });
                    ctv.setBumperLength(newValue);
                });
            }
        }
        this.popup.add(new JSeparator(0));
        if (this.getType() == PositionablePoint.PointType.ANCHOR) {
            if (blockBoundary) {
                jmi = this.popup.add(new JMenuItem(Bundle.getMessage("CanNotMergeAtBlockBoundary")));
                jmi.setEnabled(false);
            } else if (this.getConnect1() != null && this.getConnect2() != null) {
                jmi = this.popup.add(new AbstractAction(Bundle.getMessage("MergeAdjacentTracks")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PositionablePoint pp_this = PositionablePointView.this.positionablePoint;
                        if (PositionablePointView.this.getConnect1() != null && PositionablePointView.this.getConnect2() != null) {
                            LayoutTrack newConnect2 = null;
                            HitPointType newType2 = HitPointType.TRACK;
                            if (PositionablePointView.this.getConnect2().getConnect1() == pp_this) {
                                newConnect2 = PositionablePointView.this.getConnect2().getConnect2();
                                newType2 = PositionablePointView.this.getConnect2().type2;
                            } else if (PositionablePointView.this.getConnect2().getConnect2() == pp_this) {
                                newConnect2 = PositionablePointView.this.getConnect2().getConnect1();
                                newType2 = PositionablePointView.this.getConnect2().type1;
                            } else {
                                log.error("Join: wrong getConnect2() error.");
                            }
                            if (newConnect2 == null) {
                                log.error("Merge: no 'other' connection to getConnect2().");
                            } else {
                                if (newConnect2 instanceof PositionablePoint) {
                                    PositionablePoint pp = (PositionablePoint)newConnect2;
                                    pp.replaceTrackConnection(PositionablePointView.this.getConnect2(), PositionablePointView.this.getConnect1());
                                } else {
                                    PositionablePointView.this.layoutEditor.setLink(newConnect2, newType2, PositionablePointView.this.getConnect1(), HitPointType.TRACK);
                                }
                                if (PositionablePointView.this.getConnect1().getConnect1() == pp_this) {
                                    PositionablePointView.this.getConnect1().setNewConnect1(newConnect2, newType2);
                                } else if (PositionablePointView.this.getConnect1().getConnect2() == pp_this) {
                                    PositionablePointView.this.getConnect1().setNewConnect2(newConnect2, newType2);
                                } else {
                                    log.error("Merge: no connection to connection 1.");
                                }
                            }
                            if (PositionablePointView.this.layoutEditor.selectedObject == PositionablePointView.this.getConnect2()) {
                                PositionablePointView.this.layoutEditor.selectedObject = null;
                            }
                            if (PositionablePointView.this.layoutEditor.prevSelectedObject == PositionablePointView.this.getConnect2()) {
                                PositionablePointView.this.layoutEditor.prevSelectedObject = null;
                            }
                            PositionablePointView.this.layoutEditor.removeLayoutTrackAndRedraw(PositionablePointView.this.getConnect2());
                            LayoutBlock block = PositionablePointView.this.getConnect2().getLayoutBlock();
                            if (block != null) {
                                block.decrementUse();
                                PositionablePointView.this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
                                block.updatePaths();
                            }
                            PositionablePointView.this.getConnect2().remove();
                            PositionablePointView.this.positionablePoint.setConnect2Actual(null);
                            if (PositionablePointView.this.layoutEditor.selectedObject == pp_this) {
                                PositionablePointView.this.layoutEditor.selectedObject = null;
                            }
                            if (PositionablePointView.this.layoutEditor.prevSelectedObject == pp_this) {
                                PositionablePointView.this.layoutEditor.prevSelectedObject = null;
                            }
                            PositionablePointView.this.clearPossibleSelection();
                            PositionablePointView.this.layoutEditor.removeLayoutTrackAndRedraw(pp_this);
                            pp_this.remove();
                            PositionablePointView.this.dispose();
                            PositionablePointView.this.layoutEditor.setDirty();
                            PositionablePointView.this.layoutEditor.redrawPanel();
                        } else {
                            log.error("Merge: missing connection(s).");
                        }
                    }
                });
            }
        }
        this.popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PositionablePointView.this.canRemove() && PositionablePointView.this.layoutEditor.removePositionablePoint(PositionablePointView.this.positionablePoint)) {
                    PositionablePointView.this.clearPossibleSelection();
                    PositionablePointView.this.remove();
                    PositionablePointView.this.dispose();
                }
            }
        });
        JMenu lineType = new JMenu(Bundle.getMessage("ChangeTo"));
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("Anchor")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionablePointView.this.setTypeAnchor();
            }
        }));
        jmi.setSelected(this.getType() == PositionablePoint.PointType.ANCHOR);
        if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR && this.getConnect2() != null) {
            jmi.setEnabled(false);
        }
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("EndBumper")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionablePointView.this.setTypeEndBumper();
            }
        }));
        jmi.setSelected(this.getType() == PositionablePoint.PointType.END_BUMPER);
        jmi = lineType.add(new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("EdgeConnector")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositionablePointView.this.setTypeEdgeConnector();
            }
        }));
        jmi.setSelected(this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR);
        this.popup.add(lineType);
        if (!blockBoundary && this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
            this.popup.add(new JSeparator(0));
            this.popup.add(new AbstractAction(Bundle.getMessage("EdgeEditLink")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositionablePointView.this.setLink();
                }
            });
        }
        if (blockBoundary) {
            this.popup.add(new JSeparator(0));
            if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
                this.popup.add(new AbstractAction(Bundle.getMessage("EdgeEditLink")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PositionablePointView.this.setLink();
                    }
                });
                this.popup.add(new AbstractAction(Bundle.getMessage("SetSignals")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PositionablePointView.this.layoutEditor.getLETools().setSignalsAtBlockBoundaryFromMenu(PositionablePointView.this.positionablePoint, PositionablePointView.this.getLayoutEditorToolBarPanel().signalIconEditor, PositionablePointView.this.getLayoutEditorToolBarPanel().signalFrame);
                    }
                });
            } else {
                AbstractAction ssaa = new AbstractAction(Bundle.getMessage("SetSignals")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PositionablePointView.this.layoutEditor.getLETools().setSignalsAtBlockBoundaryFromMenu(PositionablePointView.this.positionablePoint, PositionablePointView.this.getLayoutEditorToolBarPanel().signalIconEditor, PositionablePointView.this.getLayoutEditorToolBarPanel().signalFrame);
                    }
                };
                JMenu jm = new JMenu(Bundle.getMessage("SignalHeads"));
                if (this.layoutEditor.getLETools().addBlockBoundarySignalHeadInfoToMenu(this.positionablePoint, jm).booleanValue()) {
                    jm.add(ssaa);
                    this.popup.add(jm);
                } else {
                    this.popup.add(ssaa);
                }
            }
            addSensorsAndSignalMasksMenuItemsFlag = true;
        }
        if (addSensorsAndSignalMasksMenuItemsFlag) {
            this.popup.add(new AbstractAction(Bundle.getMessage("SetSignalMasts")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PositionablePointView.this.layoutEditor.getLETools().setSignalMastsAtBlockBoundaryFromMenu(PositionablePointView.this.positionablePoint);
                }
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("SetSensors")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PositionablePointView.this.layoutEditor.getLETools().setSensorsAtBlockBoundaryFromMenu(PositionablePointView.this.positionablePoint, PositionablePointView.this.getLayoutEditorToolBarPanel().sensorIconEditor, PositionablePointView.this.getLayoutEditorToolBarPanel().sensorFrame);
                }
            });
        }
        this.layoutEditor.setShowAlignmentMenu(this.popup);
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        return this.popup;
    }

    private void clearPossibleSelection() {
        if (this.layoutEditor.getLayoutTrackSelection().contains(this.positionablePoint)) {
            this.layoutEditor.clearSelectionGroups();
        }
    }

    @Override
    public boolean canRemove() {
        ArrayList<String> itemList = new ArrayList<String>();
        TrackSegment ts1 = this.getConnect1();
        TrackSegment ts2 = this.getConnect2();
        if (ts1 != null) {
            itemList.addAll(this.getSegmentReferences(ts1));
        }
        if (ts2 != null) {
            for (String item : this.getSegmentReferences(ts2)) {
                if (itemList.contains(item)) continue;
                itemList.add(item);
            }
        }
        if (!itemList.isEmpty()) {
            String typeName = "";
            switch (this.getType()) {
                case ANCHOR: {
                    typeName = "Anchor";
                    break;
                }
                case END_BUMPER: {
                    typeName = "EndBumper";
                    break;
                }
                case EDGE_CONNECTOR: {
                    typeName = "EdgeConnector";
                    break;
                }
                default: {
                    typeName = "Unknown type (" + (Object)((Object)this.getType()) + ")";
                }
            }
            this.displayRemoveWarningDialog(itemList, typeName);
        }
        return itemList.isEmpty();
    }

    public ArrayList<String> getSegmentReferences(TrackSegment ts) {
        ArrayList<String> items = new ArrayList<String>();
        HitPointType type1 = ts.getType1();
        LayoutTrack conn1 = ts.getConnect1();
        items.addAll(ts.getPointReferences(type1, conn1));
        HitPointType type2 = ts.getType2();
        LayoutTrack conn2 = ts.getConnect2();
        items.addAll(ts.getPointReferences(type2, conn2));
        return items;
    }

    void dispose() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
        this.popup = null;
        this.removeLinkedPoint();
    }

    private void remove() {
        this.active = false;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected int getConnect1Dir() {
        int result = 0;
        TrackSegment ts1 = this.getConnect1();
        if (ts1 != null) {
            Point2D p1 = ts1.getConnect1() == this.positionablePoint ? this.layoutEditor.getCoords(ts1.getConnect2(), ts1.getType2()) : this.layoutEditor.getCoords(ts1.getConnect1(), ts1.getType1());
            result = Path.computeDirection(this.getCoordsCenter(), p1);
        }
        return result;
    }

    void setLink() {
        if (this.getConnect1() == null || this.getConnect1().getLayoutBlock() == null) {
            log.error("{}.setLink(); Can not set link until we have a connecting track with a block assigned", (Object)this.getName());
            return;
        }
        this.editLink = new JDialog();
        this.editLink.setTitle(Bundle.getMessage("EdgeEditLinkFrom", this.getConnect1().getLayoutBlock().getDisplayName()));
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JButton done = new JButton(Bundle.getMessage("ButtonDone"));
        done.addActionListener(a -> this.updateLink());
        container.add((Component)this.getLinkPanel(), "North");
        container.add((Component)done, "South");
        container.revalidate();
        this.editLink.add(container);
        JRootPane rootPane = SwingUtilities.getRootPane(done);
        rootPane.setDefaultButton(done);
        this.editLink.pack();
        this.editLink.setModal(false);
        this.editLink.setVisible(true);
    }

    public JPanel getLinkPanel() {
        this.editorCombo = new JComboBox();
        SortedSet<LayoutEditor> panels = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
        this.editorCombo.addItem(new JCBHandle("None"));
        for (LayoutEditor p : panels) {
            JCBHandle<LayoutEditor> h = new JCBHandle<LayoutEditor>(p);
            this.editorCombo.addItem(h);
            if (p != this.getLinkedEditor()) continue;
            this.editorCombo.setSelectedItem(h);
        }
        ActionListener selectPanelListener = a -> this.updatePointBox();
        this.editorCombo.addActionListener(selectPanelListener);
        JPanel selectorPanel = new JPanel();
        selectorPanel.add(new JLabel(Bundle.getMessage("SelectPanel")));
        selectorPanel.add(this.editorCombo);
        this.linkPointsBox = new JComboBox();
        this.updatePointBox();
        selectorPanel.add(new JLabel(Bundle.getMessage("ConnectingTo")));
        selectorPanel.add(this.linkPointsBox);
        return selectorPanel;
    }

    void updatePointBox() {
        this.linkPointsBox.removeAllItems();
        this.pointList = new ArrayList();
        if (this.editorCombo.getSelectedIndex() == 0) {
            this.linkPointsBox.setEnabled(false);
            return;
        }
        this.linkPointsBox.setEnabled(true);
        LayoutEditor le = this.editorCombo.getItemAt(this.editorCombo.getSelectedIndex()).item();
        for (PositionablePoint p : le.getPositionablePoints()) {
            if (p.getType() != PositionablePoint.PointType.EDGE_CONNECTOR) continue;
            if (p.getLinkedPoint() == this.positionablePoint) {
                this.pointList.add(p);
                this.linkPointsBox.addItem(p.getName());
                this.linkPointsBox.setSelectedItem(p.getName());
                continue;
            }
            if (p.getLinkedPoint() != null || p == this.positionablePoint || p.getConnect1() == null || p.getConnect1().getLayoutBlock() == null || p.getConnect1().getLayoutBlock() == this.getConnect1().getLayoutBlock()) continue;
            this.pointList.add(p);
            this.linkPointsBox.addItem(p.getName());
        }
        this.editLink.pack();
    }

    public void updateLink() {
        if (this.editorCombo.getSelectedIndex() == 0 || this.linkPointsBox.getSelectedIndex() == -1) {
            if (this.getLinkedPoint() != null && this.getConnect2() != null) {
                SignalHead sh;
                String removeremote = null;
                String removelocal = null;
                if (this.getConnect1Dir() == 64 || this.getConnect1Dir() == 32) {
                    removeremote = this.getLinkedPoint().getEastBoundSignal();
                    removelocal = this.getWestBoundSignal();
                    this.getLinkedPoint().setEastBoundSignal("");
                } else {
                    removeremote = this.getLinkedPoint().getWestBoundSignal();
                    removelocal = this.getEastBoundSignal();
                    this.getLinkedPoint().setWestBoundSignal("");
                }
                if (!removeremote.isEmpty()) {
                    sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(removeremote);
                    this.getLinkedEditor().removeSignalHead(sh);
                    BlockBossLogic.getStoppedObject(removeremote);
                }
                if (!removelocal.isEmpty()) {
                    sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(removelocal);
                    this.layoutEditor.removeSignalHead(sh);
                    BlockBossLogic.getStoppedObject(removelocal);
                }
            }
            this.setLinkedPoint(null);
        } else {
            this.setLinkedPoint(this.pointList.get(this.linkPointsBox.getSelectedIndex()));
        }
        this.editLink.setVisible(false);
    }

    @Override
    protected HitPointType findHitPointType(Point2D hitPoint, boolean useRectangles, boolean requireUnconnected) {
        Point2D p;
        double distance;
        HitPointType result = HitPointType.NONE;
        Rectangle2D r = this.layoutEditor.layoutEditorControlCircleRectAt(hitPoint);
        Point2D minPoint = MathUtil.zeroPoint2D;
        double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        double minDistance = Double.POSITIVE_INFINITY;
        if ((!requireUnconnected || this.getConnect1() == null || this.getType() == PositionablePoint.PointType.ANCHOR && this.getConnect2() == null) && (distance = MathUtil.distance(p = this.getCoordsCenter(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.POS_POINT;
        }
        if (useRectangles && !r.contains(minPoint) || !useRectangles && minDistance > circleRadius) {
            result = HitPointType.NONE;
        }
        return result;
    }

    @Override
    public Point2D getCoordsForConnectionType(HitPointType connectionType) {
        Point2D result = this.getCoordsCenter();
        if (connectionType != HitPointType.POS_POINT) {
            log.error("{}.getCoordsForConnectionType({}); Invalid Connection Type", (Object)this.getName(), (Object)connectionType);
        }
        return result;
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        TrackSegment result = null;
        if (connectionType == HitPointType.POS_POINT) {
            result = this.getConnect1();
            if (result == null) {
                result = this.getConnect2();
            }
        } else {
            String errString = MessageFormat.format("{0}.getConnection({1}); Invalid Connection Type", new Object[]{this.getName(), connectionType});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        return result;
    }

    @Override
    public void setConnection(HitPointType connectionType, LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); unexpected type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        if (connectionType != HitPointType.POS_POINT) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid Connection Type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
    }

    @Override
    public boolean isDisconnected(HitPointType connectionType) {
        boolean result = false;
        if (connectionType == HitPointType.POS_POINT) {
            result = this.getConnect1() == null || this.getConnect2() == null;
        } else {
            log.error("{}.isDisconnected({}); Invalid Connection Type", (Object)this.getName(), (Object)connectionType);
        }
        return result;
    }

    @Override
    protected void drawDecorations(Graphics2D g2) {
        log.trace("PositionablePointView::drawDecorations");
    }

    @Override
    protected void draw1(Graphics2D g2, boolean isMain, boolean isBlock) {
        log.trace("PositionablePointView::draw1");
    }

    @Override
    protected void draw2(Graphics2D g2, boolean isMain, float railDisplacement) {
        log.trace("PositionablePointView::draw2");
    }

    @Override
    protected void highlightUnconnected(Graphics2D g2, HitPointType specificType) {
        log.trace("PositionablePointView::highlightUnconnected");
        if ((specificType == HitPointType.NONE || specificType == HitPointType.POS_POINT) && (this.getConnect1() == null || this.getType() == PositionablePoint.PointType.ANCHOR && this.getConnect2() == null)) {
            g2.fill(this.trackControlCircleAt(this.getCoordsCenter()));
        }
    }

    @Override
    protected void drawEditControls(Graphics2D g2) {
        log.trace("PositionablePointView::drawEditControls c1:{} c2:{} {}", new Object[]{this.getConnect1(), this.getConnect2(), this.getType()});
        TrackSegment ts1 = this.getConnect1();
        if (ts1 == null) {
            g2.setColor(Color.red);
        } else {
            TrackSegment ts2 = null;
            if (this.getType() == PositionablePoint.PointType.ANCHOR) {
                ts2 = this.getConnect2();
            } else if (this.getType() == PositionablePoint.PointType.EDGE_CONNECTOR && this.getLinkedPoint() != null) {
                ts2 = this.getLinkedPoint().getConnect1();
            }
            if (this.getType() != PositionablePoint.PointType.END_BUMPER && ts2 == null) {
                g2.setColor(Color.yellow);
            } else {
                g2.setColor(Color.green);
            }
        }
        log.trace("      at {} in {} draw {}", new Object[]{this.getCoordsCenter(), g2.getColor(), this.layoutEditor.layoutEditorControlRectAt(this.getCoordsCenter())});
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(this.getCoordsCenter()));
    }

    @Override
    protected void drawTurnoutControls(Graphics2D g2) {
        log.trace("PositionablePointView::drawTurnoutControls");
    }

    @Override
    public void reCheckBlockBoundary() {
        if (this.getType() == PositionablePoint.PointType.END_BUMPER) {
            return;
        }
        if (this.getConnect1() == null && this.getConnect2() == null) {
            if (this.westBoundSignalMastNamed != null) {
                this.removeSML(this.getWestBoundSignalMast());
            }
            if (this.eastBoundSignalMastNamed != null) {
                this.removeSML(this.getEastBoundSignalMast());
            }
            this.westBoundSignalMastNamed = null;
            this.eastBoundSignalMastNamed = null;
            this.setWestBoundSensor("");
            this.setEastBoundSensor("");
        } else if (this.getConnect1() != null && this.getConnect2() != null && this.getConnect1().getLayoutBlock() == this.getConnect2().getLayoutBlock()) {
            if (this.westBoundSignalMastNamed != null) {
                this.removeSML(this.getWestBoundSignalMast());
            }
            if (this.eastBoundSignalMastNamed != null) {
                this.removeSML(this.getEastBoundSignalMast());
            }
            this.westBoundSignalMastNamed = null;
            this.eastBoundSignalMastNamed = null;
            this.setWestBoundSensor("");
            this.setEastBoundSensor("");
        }
    }

    @Override
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        return this.positionablePoint.getLayoutConnectivity();
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        if (this.getConnect1() == null || this.getType() == PositionablePoint.PointType.ANCHOR && this.getConnect2() == null) {
            result.add(HitPointType.POS_POINT);
        }
        return result;
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return true;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        String blk2;
        TrackSegment ts2;
        TrackSegment ts1 = this.getConnect1();
        String blk1 = null;
        List<Set<String>> TrackNameSets = null;
        Set<String> TrackNameSet = null;
        if (ts1 != null && !(blk1 = ts1.getBlockName()).isEmpty()) {
            TrackNameSets = blockNamesToTrackNameSetsMap.get(blk1);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)blk1);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(blk1, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                log.debug("*    Add track ''{}'' to trackNameSet for block ''{}''", (Object)this.getName(), (Object)blk1);
                TrackNameSet.add(this.getName());
                TrackNameSets.add(TrackNameSet);
            }
            if (this.getConnect1() != null) {
                this.getConnect1().collectContiguousTracksNamesInBlockNamed(blk1, TrackNameSet);
            }
        }
        if (this.getType() == PositionablePoint.PointType.ANCHOR && (ts2 = this.getConnect2()) != null && !(blk2 = ts2.getBlockName()).isEmpty()) {
            TrackNameSet = null;
            TrackNameSets = blockNamesToTrackNameSetsMap.get(blk2);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)blk2);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(blk2, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet();
                log.debug("*    Add track ''{}'' to TrackNameSet for block ''{}''", (Object)this.getName(), (Object)blk2);
                TrackNameSets.add(TrackNameSet);
                TrackNameSet.add(this.getName());
            }
            if (this.getConnect2() != null) {
                this.getConnect2().collectContiguousTracksNamesInBlockNamed(blk2, TrackNameSet);
            }
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName())) {
            String blk2;
            TrackSegment ts2;
            String blk1;
            TrackSegment ts1 = this.getConnect1();
            if (ts1 != null && (blk1 = ts1.getBlockName()).equals(blockName)) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                if (this.getConnect1() != null) {
                    this.getConnect1().collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
            }
            if (this.getType() == PositionablePoint.PointType.ANCHOR && (ts2 = this.getConnect2()) != null && (blk2 = ts2.getBlockName()).equals(blockName)) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                if (this.getConnect2() != null) {
                    this.getConnect2().collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
    }
}

