/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.signalling.SignallingGuiTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePoint
extends LayoutTrack {
    private PointType type = PointType.NONE;
    private TrackSegment connect1 = null;
    private TrackSegment connect2 = null;
    protected NamedBeanHandle<SignalHead> signalEastHeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalWestHeadNamed = null;
    private NamedBeanHandle<SignalMast> eastBoundSignalMastNamed = null;
    private NamedBeanHandle<SignalMast> westBoundSignalMastNamed = null;
    private NamedBeanHandle<Sensor> eastBoundSensorNamed = null;
    private NamedBeanHandle<Sensor> westBoundSensorNamed = null;
    private PositionablePoint linkedPoint;
    public String trackSegment1Name = "";
    public String trackSegment2Name = "";
    private boolean active = true;
    private static final Logger log = LoggerFactory.getLogger(PositionablePoint.class);

    public PositionablePoint(String id, PointType t, LayoutEditor models) {
        super(id, models);
        if (t == PointType.ANCHOR || t == PointType.END_BUMPER || t == PointType.EDGE_CONNECTOR) {
            this.type = t;
        } else {
            log.error("Illegal type of PositionablePoint - {}", (Object)t);
            this.type = PointType.ANCHOR;
        }
    }

    public String toString() {
        String result = "PositionalablePoint";
        switch (this.type) {
            case ANCHOR: {
                result = "Anchor";
                break;
            }
            case END_BUMPER: {
                result = "End Bumper";
                break;
            }
            case EDGE_CONNECTOR: {
                result = "Edge Connector";
                break;
            }
            default: {
                result = "Unknown type (" + (Object)((Object)this.type) + ")";
            }
        }
        return String.valueOf(result) + " '" + this.getName() + "'";
    }

    public PointType getType() {
        return this.type;
    }

    public void setType(PointType newType) {
        if (this.type != newType) {
            switch (newType) {
                default: {
                    this.setTypeAnchor();
                    break;
                }
                case END_BUMPER: {
                    this.setTypeEndBumper();
                    break;
                }
                case EDGE_CONNECTOR: {
                    this.setTypeEdgeConnector();
                }
            }
            log.debug("temporary - repaint was removed here, needs to be rescoped");
        }
    }

    void setTypeAnchor() {
        this.setIdent(this.models.getFinder().uniqueName("A", 1));
        this.type = PointType.ANCHOR;
        if (this.connect1 != null) {
            if (this.connect1.getConnect1() == this) {
                log.info("Elided handling of connect1 in setTypeAnchor");
            }
            if (this.connect1.getConnect2() == this) {
                log.info("Elided handling of connect1 in setTypeAnchor");
            }
        }
        if (this.connect2 != null) {
            if (this.connect2.getConnect1() == this) {
                log.info("Elided handling of connect2 in setTypeAnchor");
            }
            if (this.connect2.getConnect2() == this) {
                log.info("Elided handling of connect2 in setTypeAnchor");
            }
        }
    }

    void setTypeEndBumper() {
        this.setIdent(this.models.getFinder().uniqueName("EB", 1));
        this.type = PointType.END_BUMPER;
        if (this.connect1 != null) {
            if (this.connect1.getConnect1() == this) {
                log.info("Elided handling of connect1 in setTypeEndBumper");
            }
            if (this.connect1.getConnect2() == this) {
                log.info("Elided handling of connect2 in setTypeEndBumper");
            }
        }
    }

    void setTypeEdgeConnector() {
        this.setIdent(this.models.getFinder().uniqueName("EC", 1));
        this.type = PointType.EDGE_CONNECTOR;
        if (this.connect1 != null) {
            if (this.connect1.getConnect1() == this) {
                log.info("Elided handling of connect1 in setTypeEdgeConnector");
            }
            if (this.connect1.getConnect2() == this) {
                log.info("Elided handling of connect2 in setTypeEdgeConnector");
            }
        }
    }

    public TrackSegment getConnect1() {
        return this.connect1;
    }

    public void setConnect1(TrackSegment trk) {
        this.connect1 = trk;
    }

    public TrackSegment getConnect2() {
        if (this.type == PointType.EDGE_CONNECTOR && this.getLinkedPoint() != null) {
            return this.getLinkedPoint().getConnect1();
        }
        return this.connect2;
    }

    public TrackSegment getConnect2Actual() {
        return this.connect2;
    }

    public void setConnect2Actual(TrackSegment trk) {
        this.connect2 = trk;
    }

    public String getLinkedEditorName() {
        if (this.getLinkedEditor() != null) {
            return this.getLinkedEditor().getLayoutName();
        }
        return "";
    }

    public PositionablePoint getLinkedPoint() {
        return this.linkedPoint;
    }

    public String getLinkedPointId() {
        if (this.linkedPoint != null) {
            return this.linkedPoint.getId();
        }
        return "";
    }

    public void setLinkedPoint(PositionablePoint p) {
        if (p == this.linkedPoint) {
            return;
        }
        if (this.linkedPoint != null) {
            PositionablePoint oldLinkedPoint = this.linkedPoint;
            this.linkedPoint = null;
            if (oldLinkedPoint.getLinkedPoint() != null) {
                oldLinkedPoint.setLinkedPoint(null);
            }
            if (oldLinkedPoint.getConnect1() != null) {
                TrackSegment ts = oldLinkedPoint.getConnect1();
                oldLinkedPoint.getLayoutEditor().getLEAuxTools().setBlockConnectivityChanged();
                ts.updateBlockInfo();
                log.info("temporary - repaint was removed here, needs to be rescoped");
            }
            if (this.getConnect1() != null) {
                this.models.getLEAuxTools().setBlockConnectivityChanged();
                this.getConnect1().updateBlockInfo();
                log.info("temporary - repaint was removed here, needs to be rescoped");
            }
        }
        this.linkedPoint = p;
        if (p != null) {
            p.setLinkedPoint(this);
            if (this.getConnect1() != null) {
                this.models.getLEAuxTools().setBlockConnectivityChanged();
                this.getConnect1().updateBlockInfo();
                log.info("temporary - repaint was removed here, needs to be rescoped");
            }
        }
    }

    @CheckReturnValue
    public LayoutEditor getLinkedEditor() {
        if (this.getLinkedPoint() != null) {
            return this.getLinkedPoint().getLayoutEditor();
        }
        return null;
    }

    @CheckReturnValue
    protected LayoutEditor getLayoutEditor() {
        return this.models;
    }

    @CheckReturnValue
    @Nonnull
    public String getEastBoundSignal() {
        SignalHead h = this.getEastBoundSignalHead();
        if (h != null) {
            return h.getDisplayName();
        }
        return "";
    }

    @CheckForNull
    @CheckReturnValue
    public SignalHead getEastBoundSignalHead() {
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 64 || dir == 32 || dir == 96) {
                if (this.signalEastHeadNamed != null) {
                    return this.signalEastHeadNamed.getBean();
                }
                return null;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 32 || linkDir == 64 || linkDir == 96)) {
                return this.getLinkedPoint().getEastBoundSignalHead();
            }
        }
        if (this.signalEastHeadNamed != null) {
            return this.signalEastHeadNamed.getBean();
        }
        return null;
    }

    public void setEastBoundSignal(String signalName) {
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 64 || dir == 32 || dir == 96) {
                this.setEastBoundSignalName(signalName);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 32 || linkDir == 64 || linkDir == 96) {
                    this.getLinkedPoint().setEastBoundSignal(signalName);
                } else {
                    this.setEastBoundSignalName(signalName);
                }
            } else {
                this.setEastBoundSignalName(signalName);
            }
        } else {
            this.setEastBoundSignalName(signalName);
        }
    }

    private void setEastBoundSignalName(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalEastHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalEastHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @CheckReturnValue
    @Nonnull
    public String getWestBoundSignal() {
        SignalHead h = this.getWestBoundSignalHead();
        if (h != null) {
            return h.getDisplayName();
        }
        return "";
    }

    @CheckForNull
    @CheckReturnValue
    public SignalHead getWestBoundSignalHead() {
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                if (this.signalWestHeadNamed != null) {
                    return this.signalWestHeadNamed.getBean();
                }
                return null;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 128 || linkDir == 16 || linkDir == 144)) {
                return this.getLinkedPoint().getWestBoundSignalHead();
            }
        }
        if (this.signalWestHeadNamed != null) {
            return this.signalWestHeadNamed.getBean();
        }
        return null;
    }

    public void setWestBoundSignal(String signalName) {
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                this.setWestBoundSignalName(signalName);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 128 || linkDir == 16 || linkDir == 144) {
                    this.getLinkedPoint().setWestBoundSignal(signalName);
                } else {
                    this.setWestBoundSignalName(signalName);
                }
            } else {
                this.setWestBoundSignalName(signalName);
            }
        } else {
            this.setWestBoundSignalName(signalName);
        }
    }

    private void setWestBoundSignalName(@CheckForNull String signalHead) {
        if (signalHead == null || signalHead.isEmpty()) {
            this.signalWestHeadNamed = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalHead);
        this.signalWestHeadNamed = head != null ? InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead, head) : null;
    }

    @CheckReturnValue
    @Nonnull
    public String getEastBoundSensorName() {
        if (this.eastBoundSensorNamed != null) {
            return this.eastBoundSensorNamed.getName();
        }
        return "";
    }

    @CheckReturnValue
    public Sensor getEastBoundSensor() {
        if (this.eastBoundSensorNamed != null) {
            return this.eastBoundSensorNamed.getBean();
        }
        return null;
    }

    public void setEastBoundSensor(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.eastBoundSensorNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.eastBoundSensorNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.eastBoundSensorNamed = null;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getWestBoundSensorName() {
        if (this.westBoundSensorNamed != null) {
            return this.westBoundSensorNamed.getName();
        }
        return "";
    }

    @CheckReturnValue
    public Sensor getWestBoundSensor() {
        if (this.westBoundSensorNamed != null) {
            return this.westBoundSensorNamed.getBean();
        }
        return null;
    }

    public void setWestBoundSensor(String sensorName) {
        if (sensorName == null || sensorName.isEmpty()) {
            this.westBoundSensorNamed = null;
            return;
        }
        try {
            Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
            this.westBoundSensorNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.westBoundSensorNamed = null;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getEastBoundSignalMastName() {
        if (this.getEastBoundSignalMastNamed() != null) {
            return this.getEastBoundSignalMastNamed().getName();
        }
        return "";
    }

    @CheckReturnValue
    public SignalMast getEastBoundSignalMast() {
        if (this.getEastBoundSignalMastNamed() != null) {
            return this.getEastBoundSignalMastNamed().getBean();
        }
        return null;
    }

    @CheckReturnValue
    public NamedBeanHandle<SignalMast> getEastBoundSignalMastNamed() {
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 32 || dir == 64 || dir == 96) {
                return this.eastBoundSignalMastNamed;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 32 || linkDir == 64 || linkDir == 96)) {
                return this.getLinkedPoint().getEastBoundSignalMastNamed();
            }
        }
        return this.eastBoundSignalMastNamed;
    }

    public void setEastBoundSignalMast(String signalMast) {
        SignalMast mast = null;
        if (signalMast != null && !signalMast.isEmpty()) {
            mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
            if (mast == null) {
                log.error("{}.setEastBoundSignalMast({}); Unable to find Signal Mast", (Object)this.getName(), (Object)signalMast);
                return;
            }
        } else {
            this.eastBoundSignalMastNamed = null;
            return;
        }
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 64 || dir == 32 || dir == 96) {
                this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 32 || linkDir == 64 || linkDir == 96) {
                    this.getLinkedPoint().setEastBoundSignalMast(signalMast);
                } else {
                    this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
                }
            } else {
                this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            }
        } else {
            this.eastBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
    }

    @CheckReturnValue
    @Nonnull
    public String getWestBoundSignalMastName() {
        if (this.getWestBoundSignalMastNamed() != null) {
            return this.getWestBoundSignalMastNamed().getName();
        }
        return "";
    }

    @CheckReturnValue
    public SignalMast getWestBoundSignalMast() {
        if (this.getWestBoundSignalMastNamed() != null) {
            return this.getWestBoundSignalMastNamed().getBean();
        }
        return null;
    }

    @CheckReturnValue
    public NamedBeanHandle<SignalMast> getWestBoundSignalMastNamed() {
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int linkDir;
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                return this.westBoundSignalMastNamed;
            }
            if (this.getLinkedPoint() != null && ((linkDir = this.getLinkedPoint().getConnect1Dir()) == 128 || linkDir == 16 || linkDir == 144)) {
                return this.getLinkedPoint().getWestBoundSignalMastNamed();
            }
        }
        return this.westBoundSignalMastNamed;
    }

    public void setWestBoundSignalMast(String signalMast) {
        SignalMast mast = null;
        if (signalMast != null && !signalMast.isEmpty()) {
            mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast);
            if (mast == null) {
                log.error("{}.setWestBoundSignalMast({}); Unable to find Signal Mast", (Object)this.getName(), (Object)signalMast);
                return;
            }
        } else {
            this.westBoundSignalMastNamed = null;
            return;
        }
        if (this.getType() == PointType.EDGE_CONNECTOR) {
            int dir = this.getConnect1Dir();
            if (dir == 128 || dir == 16 || dir == 144) {
                this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            } else if (this.getLinkedPoint() != null) {
                int linkDir = this.getLinkedPoint().getConnect1Dir();
                if (linkDir == 128 || linkDir == 16 || linkDir == 144) {
                    this.getLinkedPoint().setWestBoundSignalMast(signalMast);
                } else {
                    this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
                }
            } else {
                this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
            }
        } else {
            this.westBoundSignalMastNamed = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalMast, mast);
        }
    }

    public void removeBeanReference(NamedBean nb) {
        if (nb == null) {
            return;
        }
        if (nb instanceof SignalMast) {
            if (nb.equals(this.getWestBoundSignalMast())) {
                this.setWestBoundSignalMast(null);
            } else if (nb.equals(this.getEastBoundSignalMast())) {
                this.setEastBoundSignalMast(null);
            }
        } else if (nb instanceof Sensor) {
            if (nb.equals(this.getWestBoundSensor())) {
                this.setWestBoundSignalMast(null);
            } else if (nb.equals(this.getEastBoundSensor())) {
                this.setEastBoundSignalMast(null);
            }
        } else if (nb instanceof SignalHead) {
            if (nb.equals(this.getWestBoundSignalHead())) {
                this.setWestBoundSignal(null);
            }
            if (nb.equals(this.getEastBoundSignalHead())) {
                this.setEastBoundSignal(null);
            }
        }
    }

    @Override
    public void setObjects(LayoutEditor p) {
        if (this.type == PointType.EDGE_CONNECTOR) {
            this.connect1 = p.getFinder().findTrackSegmentByName(this.trackSegment1Name);
            if (this.getConnect2() != null && this.getLinkedEditor() != null) {
                TrackSegment ts = this.getConnect2();
                this.getLinkedEditor().getLEAuxTools().setBlockConnectivityChanged();
                ts.updateBlockInfo();
            }
        } else {
            this.connect1 = p.getFinder().findTrackSegmentByName(this.trackSegment1Name);
            this.connect2 = p.getFinder().findTrackSegmentByName(this.trackSegment2Name);
        }
        log.trace("PositionablePoint:setObjects {}: {} and {} {}", new Object[]{this.trackSegment1Name, this.connect1, this.trackSegment1Name, this.connect1});
    }

    public boolean setTrackConnection(@Nonnull TrackSegment track) {
        return this.replaceTrackConnection(null, track);
    }

    public boolean removeTrackConnection(@Nonnull TrackSegment track) {
        return this.replaceTrackConnection(track, null);
    }

    public boolean replaceTrackConnection(@CheckForNull TrackSegment oldTrack, @CheckForNull TrackSegment newTrack) {
        boolean result = false;
        if (newTrack == null) {
            if (oldTrack != null) {
                result = true;
                if (this.connect1 == oldTrack) {
                    this.connect1 = null;
                    this.reCheckBlockBoundary();
                    this.removeLinkedPoint();
                    this.connect1 = this.connect2;
                    this.connect2 = null;
                } else if (this.connect2 == oldTrack) {
                    this.connect2 = null;
                    this.reCheckBlockBoundary();
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
            if (!result) {
                log.error("{}.replaceTrackConnection({}, {}); Attempt to remove non-existant track connection", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), "null"});
            }
        } else if (this.connect1 != newTrack && this.connect2 != newTrack) {
            result = true;
            if (this.connect1 == oldTrack) {
                this.connect1 = newTrack;
            } else if (this.type == PointType.ANCHOR && this.connect2 == oldTrack) {
                this.connect2 = newTrack;
                if (this.connect1.getLayoutBlock() == this.connect2.getLayoutBlock()) {
                    this.westBoundSignalMastNamed = null;
                    this.eastBoundSignalMastNamed = null;
                    this.setWestBoundSensor("");
                    this.setEastBoundSensor("");
                }
            } else {
                log.error("{}.replaceTrackConnection({}, {}); Attempt to assign more than allowed number of connections", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), newTrack.getName()});
                result = false;
            }
        } else {
            log.warn("{}.replaceTrackConnection({}, {}); Already connected", new Object[]{this.getName(), oldTrack == null ? "null" : oldTrack.getName(), newTrack.getName()});
            result = false;
        }
        return result;
    }

    void removeSML(SignalMast signalMast) {
        if (signalMast == null) {
            return;
        }
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && InstanceManager.getDefault(SignalMastLogicManager.class).isSignalMastUsed(signalMast)) {
            SignallingGuiTools.removeSignalMastLogic(null, signalMast);
        }
    }

    @Override
    public boolean canRemove() {
        ArrayList<String> itemList = new ArrayList<String>();
        TrackSegment ts1 = this.getConnect1();
        TrackSegment ts2 = this.getConnect2();
        if (ts1 != null) {
            itemList.addAll(this.getSegmentReferences(ts1));
        }
        if (ts2 != null) {
            for (String item : this.getSegmentReferences(ts2)) {
                if (itemList.contains(item)) continue;
                itemList.add(item);
            }
        }
        if (!itemList.isEmpty()) {
            String typeName = "";
            switch (this.type) {
                case ANCHOR: {
                    typeName = "Anchor";
                    break;
                }
                case END_BUMPER: {
                    typeName = "EndBumper";
                    break;
                }
                case EDGE_CONNECTOR: {
                    typeName = "EdgeConnector";
                    break;
                }
                default: {
                    typeName = "Unknown type (" + (Object)((Object)this.type) + ")";
                }
            }
            this.models.displayRemoveWarning(this, itemList, typeName);
        }
        return itemList.isEmpty();
    }

    public ArrayList<String> getSegmentReferences(TrackSegment ts) {
        ArrayList<String> items = new ArrayList<String>();
        HitPointType type1 = ts.getType1();
        LayoutTrack conn1 = ts.getConnect1();
        items.addAll(ts.getPointReferences(type1, conn1));
        HitPointType type2 = ts.getType2();
        LayoutTrack conn2 = ts.getConnect2();
        items.addAll(ts.getPointReferences(type2, conn2));
        return items;
    }

    void removeLinkedPoint() {
        if (this.type == PointType.EDGE_CONNECTOR && this.getLinkedPoint() != null) {
            if (this.getConnect2() != null && this.getLinkedEditor() != null) {
                LayoutEditor oldLinkedEditor = this.getLinkedEditor();
                TrackSegment ts = this.getConnect2();
                this.getLinkedPoint().setLinkedPoint(null);
                log.info("temporary - repaint was removed here, needs to be rescoped");
                oldLinkedEditor.getLEAuxTools().setBlockConnectivityChanged();
                ts.updateBlockInfo();
            }
            this.linkedPoint = null;
        }
    }

    public void remove() {
        this.active = false;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected int getConnect1Dir() {
        int result = 0;
        TrackSegment ts1 = this.getConnect1();
        if (ts1 != null) {
            result = ts1.getConnect1() == this ? this.models.computeDirectionFromCenter(this, ts1.getConnect2(), ts1.getType2()) : this.models.computeDirectionFromCenter(this, ts1.getConnect1(), ts1.getType1());
        }
        return result;
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        TrackSegment result = null;
        if (connectionType == HitPointType.POS_POINT) {
            result = this.getConnect1();
            if (result == null) {
                result = this.getConnect2();
            }
        } else {
            String errString = MessageFormat.format("{0}.getConnection({1}); Invalid Connection Type", new Object[]{this.getName(), connectionType});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        return result;
    }

    @Override
    public void setConnection(HitPointType connectionType, LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); unexpected type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        if (connectionType != HitPointType.POS_POINT) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid Connection Type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
    }

    @Override
    public boolean isDisconnected(HitPointType connectionType) {
        boolean result = false;
        if (connectionType == HitPointType.POS_POINT) {
            result = this.getConnect1() == null || this.getConnect2() == null;
        } else {
            log.error("{}.isDisconnected({}); Invalid Connection Type", (Object)this.getName(), (Object)connectionType);
        }
        return result;
    }

    @Override
    public boolean isMainline() {
        boolean result = false;
        if (this.getConnect1() != null) {
            result = this.getConnect1().isMainline();
        }
        if (this.getType() == PointType.ANCHOR && this.getConnect2() != null) {
            result |= this.getConnect2().isMainline();
        }
        return result;
    }

    @Override
    public void reCheckBlockBoundary() {
        if (this.type == PointType.END_BUMPER) {
            return;
        }
        if (this.getConnect1() == null && this.getConnect2() == null) {
            if (this.westBoundSignalMastNamed != null) {
                this.removeSML(this.getWestBoundSignalMast());
            }
            if (this.eastBoundSignalMastNamed != null) {
                this.removeSML(this.getEastBoundSignalMast());
            }
            this.westBoundSignalMastNamed = null;
            this.eastBoundSignalMastNamed = null;
            this.setWestBoundSensor("");
            this.setEastBoundSensor("");
        } else if (this.getConnect1() != null && this.getConnect2() != null && this.getConnect1().getLayoutBlock() == this.getConnect2().getLayoutBlock()) {
            if (this.westBoundSignalMastNamed != null) {
                this.removeSML(this.getWestBoundSignalMast());
            }
            if (this.eastBoundSignalMastNamed != null) {
                this.removeSML(this.getEastBoundSignalMast());
            }
            this.westBoundSignalMastNamed = null;
            this.eastBoundSignalMastNamed = null;
            this.setWestBoundSensor("");
            this.setEastBoundSensor("");
        }
    }

    @Override
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        ArrayList<LayoutConnectivity> results = new ArrayList<LayoutConnectivity>();
        LayoutConnectivity lc = null;
        LayoutBlock blk1 = null;
        LayoutBlock blk2 = null;
        TrackSegment ts1 = this.getConnect1();
        if (this.getType() == PointType.ANCHOR) {
            TrackSegment ts2 = this.getConnect2();
            if (ts1 != null && ts2 != null) {
                blk1 = ts1.getLayoutBlock();
                blk2 = ts2.getLayoutBlock();
                if (blk1 != null && blk2 != null && blk1 != blk2) {
                    log.debug("Block boundary (''{}''<->''{}'') found at {}", new Object[]{blk1, blk2, this});
                    lc = new LayoutConnectivity(blk1, blk2);
                    lc.setDirection(this.models.computeDirection(ts1.getConnect1() == this ? ts1.getConnect2() : ts1.getConnect1(), ts1.getConnect1() == this ? ts1.getType2() : ts1.getType1(), ts2.getConnect1() == this ? ts2.getConnect2() : ts2.getConnect1(), ts2.getConnect1() == this ? ts2.getType2() : ts2.getType1()));
                    lc.setConnections(ts1, ts2, HitPointType.TRACK, this);
                    results.add(lc);
                }
            }
        } else if (this.getType() == PointType.EDGE_CONNECTOR) {
            TrackSegment ts2 = null;
            if (this.getLinkedPoint() != null) {
                ts2 = this.getLinkedPoint().getConnect1();
            }
            if (ts1 != null && ts2 != null) {
                blk1 = ts1.getLayoutBlock();
                blk2 = ts2.getLayoutBlock();
                if (blk1 != null && blk2 != null && blk1 != blk2) {
                    log.debug("Block boundary (''{}''<->''{}'') found at {}", new Object[]{blk1, blk2, this});
                    lc = new LayoutConnectivity(blk1, blk2);
                    int result = ts1.getConnect1() == this ? this.models.computeDirectionToCenter(ts1.getConnect2(), ts1.getType2(), this) : this.models.computeDirectionToCenter(ts1.getConnect1(), ts1.getType1(), this);
                    lc.setDirection(result);
                    lc.setConnections(ts1, ts2, HitPointType.TRACK, this);
                    results.add(lc);
                }
            }
        }
        return results;
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        if (this.getConnect1() == null || this.getType() == PointType.ANCHOR && this.getConnect2() == null) {
            result.add(HitPointType.POS_POINT);
        }
        return result;
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return true;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        String blk2;
        TrackSegment ts2;
        TrackSegment ts1 = this.getConnect1();
        String blk1 = null;
        List<Set<String>> TrackNameSets = null;
        Set<String> TrackNameSet = null;
        if (ts1 != null && !(blk1 = ts1.getBlockName()).isEmpty()) {
            TrackNameSets = blockNamesToTrackNameSetsMap.get(blk1);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)blk1);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(blk1, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                log.debug("*    Add track ''{}'' to trackNameSet for block ''{}''", (Object)this.getName(), (Object)blk1);
                TrackNameSet.add(this.getName());
                TrackNameSets.add(TrackNameSet);
            }
            if (this.connect1 != null) {
                this.connect1.collectContiguousTracksNamesInBlockNamed(blk1, TrackNameSet);
            }
        }
        if (this.getType() == PointType.ANCHOR && (ts2 = this.getConnect2()) != null && !(blk2 = ts2.getBlockName()).isEmpty()) {
            TrackNameSet = null;
            TrackNameSets = blockNamesToTrackNameSetsMap.get(blk2);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)blk2);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(blk2, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet();
                log.debug("*    Add track ''{}'' to TrackNameSet for block ''{}''", (Object)this.getName(), (Object)blk2);
                TrackNameSets.add(TrackNameSet);
                TrackNameSet.add(this.getName());
            }
            if (this.connect2 != null) {
                this.connect2.collectContiguousTracksNamesInBlockNamed(blk2, TrackNameSet);
            }
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName())) {
            String blk2;
            TrackSegment ts2;
            String blk1;
            TrackSegment ts1 = this.getConnect1();
            if (ts1 != null && (blk1 = ts1.getBlockName()).equals(blockName)) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                if (this.connect1 != null) {
                    this.connect1.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
            }
            if (this.getType() == PointType.ANCHOR && (ts2 = this.getConnect2()) != null && (blk2 = ts2.getBlockName()).equals(blockName)) {
                if (TrackNameSet.add(this.getName())) {
                    log.debug("*    Add track ''{}''for block ''{}''", (Object)this.getName(), (Object)blockName);
                }
                if (this.connect2 != null) {
                    this.connect2.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
    }

    public static enum PointType {
        NONE,
        ANCHOR,
        END_BUMPER,
        EDGE_CONNECTOR;

    }
}

