/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.JmriException;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurntableEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurntableView
extends LayoutTrackView {
    private final LayoutTurntableEditor editor;
    private final LayoutTurntable turntable;
    public String tLayoutBlockName = "";
    private JPopupMenu popupMenu = null;
    private JPopupMenu rayPopup = null;
    private boolean active = true;
    private static final Logger log = LoggerFactory.getLogger(LayoutTurntableView.class);

    public LayoutTurntableView(@Nonnull LayoutTurntable turntable, @Nonnull Point2D c, @Nonnull LayoutEditor layoutEditor) {
        super(turntable, c, layoutEditor);
        this.turntable = turntable;
        this.editor = new LayoutTurntableEditor(layoutEditor);
    }

    public final LayoutTurntable getTurntable() {
        return this.turntable;
    }

    public String toString() {
        return "LayoutTurntable " + this.getName();
    }

    public double getRadius() {
        return this.turntable.getRadius();
    }

    public void setRadius(double r) {
        this.turntable.setRadius(r);
    }

    @Nonnull
    public String getBlockName() {
        return this.turntable.getBlockName();
    }

    public LayoutBlock getLayoutBlock() {
        return this.turntable.getLayoutBlock();
    }

    public void setLayoutBlock(@CheckForNull LayoutBlock newLayoutBlock) {
        this.turntable.setLayoutBlock(newLayoutBlock);
    }

    public void setLayoutBlockByName(@CheckForNull String name) {
        this.turntable.setLayoutBlockByName(name);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D.Double result = new Rectangle2D.Double(this.getCoordsCenter().getX(), this.getCoordsCenter().getY(), 0.0, 0.0);
        int k = 0;
        while (k < this.getNumberRays()) {
            result.add(this.getRayCoordsOrdered(k));
            ++k;
        }
        return result;
    }

    public LayoutTurntable.RayTrack addRay(double angle) {
        return this.turntable.addRay(angle);
    }

    public TrackSegment getRayConnectIndexed(int index) {
        return this.turntable.getRayConnectIndexed(index);
    }

    public TrackSegment getRayConnectOrdered(int i) {
        return this.turntable.getRayConnectOrdered(i);
    }

    public void setRayConnect(TrackSegment ts, int index) {
        this.turntable.setRayConnect(ts, index);
    }

    public List<LayoutTurntable.RayTrack> getRayTrackList() {
        return this.turntable.getRayTrackList();
    }

    public int getNumberRays() {
        return this.turntable.getNumberRays();
    }

    public int getRayIndex(int i) {
        return this.turntable.getRayIndex(i);
    }

    public double getRayAngle(int i) {
        return this.turntable.getRayAngle(i);
    }

    public void setRayTurnout(int index, String turnoutName, int state) {
        this.turntable.setRayTurnout(index, turnoutName, state);
    }

    public String getRayTurnoutName(int i) {
        return this.turntable.getRayTurnoutName(i);
    }

    public Turnout getRayTurnout(int i) {
        return this.turntable.getRayTurnout(i);
    }

    public int getRayTurnoutState(int i) {
        return this.turntable.getRayTurnoutState(i);
    }

    public boolean isRayDisabled(int i) {
        return this.turntable.isRayDisabled(i);
    }

    public void setRayDisabled(int i, boolean boo) {
        this.turntable.setRayDisabled(i, boo);
    }

    public boolean isRayDisabledWhenOccupied(int i) {
        return this.turntable.isRayDisabledWhenOccupied(i);
    }

    public void setRayDisabledWhenOccupied(int i, boolean boo) {
        this.turntable.setRayDisabledWhenOccupied(i, boo);
    }

    public Point2D getRayCoordsIndexed(int index) {
        Point2D result = MathUtil.zeroPoint2D;
        double rayRadius = this.getRadius() + 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        for (LayoutTurntable.RayTrack rt : this.turntable.rayTrackList) {
            if (rt.getConnectionIndex() != index) continue;
            double angle = Math.toRadians(rt.getAngle());
            result = new Point2D.Double(this.getCoordsCenter().getX() + rayRadius * Math.sin(angle), this.getCoordsCenter().getY() - rayRadius * Math.cos(angle));
            break;
        }
        return result;
    }

    public Point2D getRayCoordsOrdered(int i) {
        LayoutTurntable.RayTrack rt;
        Point2D result = MathUtil.zeroPoint2D;
        if (i < this.turntable.rayTrackList.size() && (rt = this.turntable.rayTrackList.get(i)) != null) {
            double angle = Math.toRadians(rt.getAngle());
            double rayRadius = this.getRadius() + 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
            result = new Point2D.Double(this.getCoordsCenter().getX() + rayRadius * Math.sin(angle), this.getCoordsCenter().getY() - rayRadius * Math.cos(angle));
        }
        return result;
    }

    public void setRayCoordsIndexed(double x, double y, int index) {
        boolean found = false;
        for (LayoutTurntable.RayTrack rt : this.turntable.rayTrackList) {
            if (rt.getConnectionIndex() != index) continue;
            double angle = Math.atan2(x - this.getCoordsCenter().getX(), y - this.getCoordsCenter().getY());
            angle = MathUtil.wrapPM360(180.0 - Math.toDegrees(angle));
            rt.setAngle(angle);
            found = true;
            break;
        }
        if (!found) {
            log.error("{}.setRayCoordsIndexed({}, {}, {}); Attempt to move a non-existant ray track", new Object[]{this.getName(), x, y, index});
        }
    }

    public void setRayCoordsIndexed(Point2D point, int index) {
        this.setRayCoordsIndexed(point.getX(), point.getY(), index);
    }

    @Override
    public Point2D getCoordsForConnectionType(HitPointType connectionType) {
        Point2D result = this.getCoordsCenter();
        if (HitPointType.TURNTABLE_CENTER != connectionType) {
            if (HitPointType.isTurntableRayHitType(connectionType)) {
                result = this.getRayCoordsIndexed(connectionType.turntableTrackIndex());
            } else {
                log.error("{}.getCoordsForConnectionType({}); Invalid connection type", (Object)this.getName(), (Object)connectionType);
            }
        }
        return result;
    }

    @Override
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        TrackSegment result = null;
        if (!HitPointType.isTurntableRayHitType(connectionType)) {
            String errString = MessageFormat.format("{0}.getCoordsForConnectionType({1}); Invalid connection type", new Object[]{this.getName(), connectionType});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        result = this.getRayConnectIndexed(connectionType.turntableTrackIndex());
        return result;
    }

    @Override
    public void setConnection(HitPointType connectionType, LayoutTrack o, HitPointType type) throws JmriException {
        if (type != HitPointType.TRACK && type != HitPointType.NONE) {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        if (HitPointType.isTurntableRayHitType(connectionType)) {
            if (o != null && !(o instanceof TrackSegment)) {
                String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid object: {4}", new Object[]{this.getName(), connectionType, o.getName(), type, o.getClass().getName()});
                log.error("will throw {}", (Object)errString);
                throw new JmriException(errString);
            }
        } else {
            String errString = MessageFormat.format("{0}.setConnection({1}, {2}, {3}); Invalid connection type", new Object[]{this.getName(), connectionType, o == null ? "null" : o.getName(), type});
            log.error("will throw {}", (Object)errString);
            throw new JmriException(errString);
        }
        this.setRayConnect((TrackSegment)o, connectionType.turntableTrackIndex());
    }

    public boolean isMainlineIndexed(int index) {
        boolean result = false;
        for (LayoutTurntable.RayTrack rt : this.turntable.rayTrackList) {
            TrackSegment ts;
            if (rt.getConnectionIndex() != index || (ts = rt.getConnect()) == null) continue;
            result = ts.isMainline();
            break;
        }
        return result;
    }

    public boolean isMainlineOrdered(int i) {
        TrackSegment ts;
        LayoutTurntable.RayTrack rt;
        boolean result = false;
        if (i < this.turntable.rayTrackList.size() && (rt = this.turntable.rayTrackList.get(i)) != null && (ts = rt.getConnect()) != null) {
            result = ts.isMainline();
        }
        return result;
    }

    @Override
    public void scaleCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.granulize(MathUtil.multiply(this.getCoordsCenter(), (Point2D)factor), 1.0));
        this.setRadius(this.getRadius() * Math.hypot(xFactor, yFactor));
    }

    @Override
    public void translateCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.add(this.getCoordsCenter(), factor));
    }

    @Override
    public void rotateCoords(double angleDEG) {
        this.turntable.rayTrackList.forEach(rayTrack -> rayTrack.setAngle(rayTrack.getAngle() + angleDEG));
    }

    @Override
    protected HitPointType findHitPointType(Point2D hitPoint, boolean useRectangles, boolean requireUnconnected) {
        Point2D p;
        double distance;
        HitPointType result = HitPointType.NONE;
        Rectangle2D r = this.layoutEditor.layoutEditorControlCircleRectAt(hitPoint);
        Point2D minPoint = MathUtil.zeroPoint2D;
        double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        double minDistance = Double.POSITIVE_INFINITY;
        if (!requireUnconnected && (distance = MathUtil.distance(p = this.getCoordsCenter(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.TURNTABLE_CENTER;
        }
        int k = 0;
        while (k < this.getNumberRays()) {
            if ((!requireUnconnected || this.getRayConnectOrdered(k) == null) && (distance = MathUtil.distance(p = this.getRayCoordsOrdered(k), hitPoint)) < minDistance) {
                minDistance = distance;
                minPoint = p;
                result = HitPointType.turntableTrackIndexedValue(k);
            }
            ++k;
        }
        if (useRectangles && !r.contains(minPoint) || !useRectangles && minDistance > circleRadius) {
            result = HitPointType.NONE;
        }
        return result;
    }

    public boolean isTurnoutControlled() {
        return this.turntable.isTurnoutControlled();
    }

    public void setTurnoutControlled(boolean boo) {
        this.turntable.setTurnoutControlled(boo);
    }

    @Override
    @Nonnull
    protected JPopupMenu showPopup(@Nonnull MouseEvent mouseEvent) {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        } else {
            this.popupMenu = new JPopupMenu();
        }
        JMenuItem jmi = this.popupMenu.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Turntable"))) + this.getName());
        jmi.setEnabled(false);
        LayoutBlock lb = this.getLayoutBlock();
        if (lb == null) {
            jmi = this.popupMenu.add(Bundle.getMessage("NoBlock"));
        } else {
            String displayName = lb.getDisplayName();
            jmi = this.popupMenu.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameBlock"))) + displayName);
        }
        jmi.setEnabled(false);
        if (!this.turntable.rayTrackList.isEmpty()) {
            JMenu connectionsMenu = new JMenu(Bundle.getMessage("Connections"));
            this.turntable.rayTrackList.forEach(rt -> {
                TrackSegment ts = rt.getConnect();
                if (ts != null) {
                    final TrackSegmentView tsv = this.layoutEditor.getTrackSegmentView(ts);
                    connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "" + rt.getConnectionIndex())) + ts.getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutTurntableView.this.layoutEditor.setSelectionRect(tsv.getBounds());
                            tsv.showPopup();
                        }
                    });
                }
            });
            this.popupMenu.add(connectionsMenu);
        }
        this.popupMenu.add(new JSeparator(0));
        this.popupMenu.add(new AbstractAction(Bundle.getMessage("ButtonEdit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutTurntableView.this.editor.editLayoutTrack(LayoutTurntableView.this);
            }
        });
        this.popupMenu.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LayoutTurntableView.this.layoutEditor.removeTurntable(LayoutTurntableView.this.turntable)) {
                    LayoutTurntableView.this.remove();
                    LayoutTurntableView.this.dispose();
                }
            }
        });
        this.layoutEditor.setShowAlignmentMenu(this.popupMenu);
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        return this.popupMenu;
    }

    protected void showRayPopUp(MouseEvent e, int index) {
        if (this.rayPopup != null) {
            this.rayPopup.removeAll();
        } else {
            this.rayPopup = new JPopupMenu();
        }
        for (final LayoutTurntable.RayTrack rt : this.turntable.rayTrackList) {
            if (rt.getConnectionIndex() != index) continue;
            JMenuItem jmi = this.rayPopup.add("Turntable Ray " + index);
            jmi.setEnabled(false);
            this.rayPopup.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Connected"))) + rt.getConnect().getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutEditorFindItems lf = LayoutTurntableView.this.layoutEditor.getFinder();
                    LayoutTrack lt = lf.findObjectByName(rt.getConnect().getName());
                    if (lt != null) {
                        LayoutTrackView ltv = LayoutTurntableView.this.layoutEditor.getLayoutTrackView(lt);
                        LayoutTurntableView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                        ltv.showPopup();
                    }
                }
            });
            if (rt.getTurnout() != null) {
                String info = rt.getTurnout().getDisplayName();
                String stateString = this.getTurnoutStateString(rt.getTurnoutState());
                if (!stateString.isEmpty()) {
                    info = String.valueOf(info) + " (" + stateString + ")";
                }
                jmi = this.rayPopup.add(info);
                jmi.setEnabled(false);
                this.rayPopup.add(new JSeparator(0));
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(Bundle.getMessage("Disabled"));
                cbmi.setSelected(rt.isDisabled());
                this.rayPopup.add(cbmi);
                cbmi.addActionListener(e2 -> {
                    JCheckBoxMenuItem o = (JCheckBoxMenuItem)e2.getSource();
                    rt.setDisabled(o.isSelected());
                });
                cbmi = new JCheckBoxMenuItem(Bundle.getMessage("DisabledWhenOccupied"));
                cbmi.setSelected(rt.isDisabledWhenOccupied());
                this.rayPopup.add(cbmi);
                cbmi.addActionListener(e3 -> {
                    JCheckBoxMenuItem o = (JCheckBoxMenuItem)e3.getSource();
                    rt.setDisabledWhenOccupied(o.isSelected());
                });
            }
            this.rayPopup.show(e.getComponent(), e.getX(), e.getY());
            break;
        }
    }

    public void setPosition(int index) {
        this.turntable.setPosition(index);
    }

    public int getPosition() {
        return this.turntable.getPosition();
    }

    public void deleteRay(LayoutTurntable.RayTrack rayTrack) {
        TrackSegment t = null;
        if (this.turntable.rayTrackList == null) {
            log.error("{}.deleteRay(null); rayTrack is null", (Object)this.getName());
        } else {
            t = rayTrack.getConnect();
            this.getRayTrackList().remove(rayTrack.getConnectionIndex());
            rayTrack.dispose();
        }
        if (t != null) {
            this.layoutEditor.removeTrackSegment(t);
        }
        this.layoutEditor.redrawPanel();
        this.layoutEditor.setDirty();
    }

    public void dispose() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
        this.popupMenu = null;
        this.turntable.rayTrackList.forEach(rt -> rt.dispose());
    }

    public void remove() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    protected void drawDecorations(Graphics2D g2) {
    }

    @Override
    protected void draw1(Graphics2D g2, boolean isMain, boolean isBlock) {
        log.trace("LayoutTurntable:draw1 at {}", (Object)this.getCoordsCenter());
        float trackWidth = 2.0f;
        float halfTrackWidth = trackWidth / 2.0f;
        double diameter = 2.0 * this.getRadius();
        if (isBlock && isMain) {
            double radius2 = Math.max(this.getRadius() / 4.0, (double)(trackWidth * 2.0f));
            double diameter2 = radius2 * 2.0;
            Stroke stroke = g2.getStroke();
            Color color = g2.getColor();
            g2.setStroke(new BasicStroke(trackWidth, 0, 1));
            g2.setColor(this.layoutEditor.getDefaultTrackColorColor());
            g2.draw(new Ellipse2D.Double(this.getCoordsCenter().getX() - this.getRadius(), this.getCoordsCenter().getY() - this.getRadius(), diameter, diameter));
            g2.draw(new Ellipse2D.Double(this.getCoordsCenter().getX() - radius2, this.getCoordsCenter().getY() - radius2, diameter2, diameter2));
            g2.setStroke(stroke);
            g2.setColor(color);
        }
        int j = 0;
        while (j < this.getNumberRays()) {
            boolean main = false;
            Color color = null;
            TrackSegment ts = this.getRayConnectOrdered(j);
            if (ts != null) {
                main = ts.isMainline();
            }
            if (isBlock) {
                if (ts == null) {
                    g2.setColor(this.layoutEditor.getDefaultTrackColorColor());
                } else {
                    LayoutBlock lb = ts.getLayoutBlock();
                    if (lb != null) {
                        color = g2.getColor();
                        this.setColorForTrackBlock(g2, lb);
                    }
                }
            }
            Point2D pt2 = this.getRayCoordsOrdered(j);
            Point2D delta = MathUtil.normalize(MathUtil.subtract(pt2, this.getCoordsCenter()), this.getRadius());
            Point2D pt1 = MathUtil.add(this.getCoordsCenter(), delta);
            if (main == isMain) {
                g2.draw(new Line2D.Double(pt1, pt2));
            }
            if (isMain && this.isTurnoutControlled() && this.getPosition() == j) {
                if (isBlock) {
                    LayoutBlock lb = this.getLayoutBlock();
                    if (lb != null) {
                        color = color == null ? g2.getColor() : color;
                        this.setColorForTrackBlock(g2, lb);
                    } else {
                        g2.setColor(this.layoutEditor.getDefaultTrackColorColor());
                    }
                }
                delta = MathUtil.normalize(delta, this.getRadius() - (double)halfTrackWidth);
                pt1 = MathUtil.subtract(this.getCoordsCenter(), delta);
                g2.draw(new Line2D.Double(pt1, pt2));
            }
            if (color != null) {
                g2.setColor(color);
            }
            ++j;
        }
    }

    @Override
    protected void draw2(Graphics2D g2, boolean isMain, float railDisplacement) {
        log.trace("LayoutTurntable:draw2 at {}", (Object)this.getCoordsCenter());
        float trackWidth = 2.0f;
        float halfTrackWidth = trackWidth / 2.0f;
        int j = 0;
        while (j < this.getNumberRays()) {
            boolean main = false;
            TrackSegment ts = this.getRayConnectOrdered(j);
            if (ts != null) {
                main = ts.isMainline();
            }
            Point2D pt2 = this.getRayCoordsOrdered(j);
            Point2D vDelta = MathUtil.normalize(MathUtil.subtract(pt2, this.getCoordsCenter()), this.getRadius());
            Point2D vDeltaO = MathUtil.normalize(MathUtil.orthogonal(vDelta), railDisplacement);
            Point2D pt1 = MathUtil.add(this.getCoordsCenter(), vDelta);
            Point2D pt1L = MathUtil.subtract(pt1, vDeltaO);
            Point2D pt1R = MathUtil.add(pt1, vDeltaO);
            Point2D pt2L = MathUtil.subtract(pt2, vDeltaO);
            Point2D pt2R = MathUtil.add(pt2, vDeltaO);
            if (main == isMain) {
                log.trace("   draw main at {} {}, {} {}", new Object[]{pt1L, pt2L, pt1R, pt2R});
                g2.draw(new Line2D.Double(pt1L, pt2L));
                g2.draw(new Line2D.Double(pt1R, pt2R));
            }
            if (isMain && this.isTurnoutControlled() && this.getPosition() == j) {
                vDelta = MathUtil.normalize(vDelta, this.getRadius() - (double)halfTrackWidth);
                pt1 = MathUtil.subtract(this.getCoordsCenter(), vDelta);
                pt1L = MathUtil.subtract(pt1, vDeltaO);
                pt1R = MathUtil.add(pt1, vDeltaO);
                log.trace("   draw not main at {} {}, {} {}", new Object[]{pt1L, pt2L, pt1R, pt2R});
                g2.draw(new Line2D.Double(pt1L, pt2L));
                g2.draw(new Line2D.Double(pt1R, pt2R));
            }
            ++j;
        }
    }

    @Override
    protected void highlightUnconnected(Graphics2D g2, HitPointType specificType) {
        log.trace("LayoutTurntable:highlightUnconnected");
        int j = 0;
        while (j < this.getNumberRays()) {
            if ((specificType == HitPointType.NONE || specificType == HitPointType.turntableTrackIndexedValue(j)) && this.getRayConnectOrdered(j) == null) {
                Point2D pt = this.getRayCoordsOrdered(j);
                log.trace("   draw at {} {}, {} {}", (Object)pt);
                g2.fill(this.trackControlCircleAt(pt));
            }
            ++j;
        }
    }

    @Override
    protected void drawTurnoutControls(Graphics2D g2) {
        log.trace("LayoutTurntable:drawTurnoutControls");
        if (this.isTurnoutControlled()) {
            int j = 0;
            while (j < this.getNumberRays()) {
                LayoutTurntable.RayTrack rt;
                if (!(this.getPosition() == j || (rt = this.turntable.rayTrackList.get(j)).isDisabled() || rt.isDisabledWhenOccupied() && rt.isOccupied())) {
                    Point2D pt = this.getRayCoordsOrdered(j);
                    g2.draw(this.trackControlCircleAt(pt));
                }
                ++j;
            }
        }
    }

    @Override
    protected void drawEditControls(Graphics2D g2) {
        Point2D pt = this.getCoordsCenter();
        g2.setColor(this.layoutEditor.getDefaultTrackColorColor());
        g2.draw(this.trackControlCircleAt(pt));
        int j = 0;
        while (j < this.getNumberRays()) {
            pt = this.getRayCoordsOrdered(j);
            if (this.getRayConnectOrdered(j) == null) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.green);
            }
            g2.draw(this.layoutEditor.layoutEditorControlRectAt(pt));
            ++j;
        }
    }

    @Override
    protected void reCheckBlockBoundary() {
    }

    @Override
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        return null;
    }

    @Override
    public List<HitPointType> checkForFreeConnections() {
        ArrayList<HitPointType> result = new ArrayList<HitPointType>();
        int k = 0;
        while (k < this.getNumberRays()) {
            if (this.getRayConnectOrdered(k) == null) {
                result.add(HitPointType.turntableTrackIndexedValue(k));
            }
            ++k;
        }
        return result;
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return true;
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        HashMap<TrackSegment, String> blocksAndTracksMap = new HashMap<TrackSegment, String>();
        int k = 0;
        while (k < this.getNumberRays()) {
            TrackSegment ts = this.getRayConnectOrdered(k);
            if (ts != null) {
                String blockName = ts.getBlockName();
                blocksAndTracksMap.put(ts, blockName);
            }
            ++k;
        }
        for (Map.Entry entry : blocksAndTracksMap.entrySet()) {
            LayoutTrack theConnect = (LayoutTrack)entry.getKey();
            String theBlockName = (String)entry.getValue();
            Set<String> TrackNameSet = null;
            List<Set<String>> TrackNameSets = blockNamesToTrackNameSetsMap.get(theBlockName);
            if (TrackNameSets != null) {
                for (Set<String> checkTrackNameSet : TrackNameSets) {
                    if (!checkTrackNameSet.contains(this.getName())) continue;
                    TrackNameSet = checkTrackNameSet;
                    break;
                }
            } else {
                log.debug("*New block (''{}'') trackNameSets", (Object)theBlockName);
                TrackNameSets = new ArrayList<Set<String>>();
                blockNamesToTrackNameSetsMap.put(theBlockName, TrackNameSets);
            }
            if (TrackNameSet == null) {
                TrackNameSet = new LinkedHashSet<String>();
                TrackNameSets.add(TrackNameSet);
            }
            if (TrackNameSet.add(this.getName())) {
                log.debug("*    Add track ''{}'' to trackNameSet for block ''{}''", (Object)this.getName(), (Object)theBlockName);
            }
            theConnect.collectContiguousTracksNamesInBlockNamed(theBlockName, TrackNameSet);
        }
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        if (!TrackNameSet.contains(this.getName())) {
            int k = 0;
            while (k < this.getNumberRays()) {
                String blk;
                TrackSegment ts = this.getRayConnectOrdered(k);
                if (ts != null && !(blk = ts.getBlockName()).isEmpty() && blk.equals(blockName)) {
                    if (TrackNameSet.add(this.getName())) {
                        log.debug("*    Add track ''{}'' for block ''{}''", (Object)this.getName(), (Object)blockName);
                    }
                    ts.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
                }
                ++k;
            }
        }
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    public static class RayTrackVisuals {
        private double rayAngle = 0.0;

        public double getAngle() {
            return this.rayAngle;
        }

        public void setAngle(double an) {
            this.rayAngle = MathUtil.wrapPM360(an);
        }

        public RayTrackVisuals(LayoutTurntable.RayTrack track) {
        }
    }
}

