/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurnoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutEditorToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutEditorTools;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.blockRoutingTable.LayoutBlockRouteTableAction;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurnoutView
extends LayoutTrackView {
    public static final int UNKNOWN = 1;
    public static final int INCONSISTENT = 8;
    public static final int STATE_AC = 2;
    public static final int STATE_BD = 4;
    public static final int STATE_AD = 6;
    public static final int STATE_BC = 8;
    public static final double turnoutBXDefault = 20.0;
    public static final double turnoutCXDefault = 20.0;
    public static final double turnoutWidDefault = 10.0;
    public static final double xOverLongDefault = 30.0;
    public static final double xOverHWidDefault = 10.0;
    public static final double xOverShortDefault = 10.0;
    protected NamedBeanHandle<Turnout> namedTurnout = null;
    protected NamedBeanHandle<Turnout> secondNamedTurnout = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockA = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockB = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockC = null;
    protected NamedBeanHandle<LayoutBlock> namedLayoutBlockD = null;
    protected NamedBeanHandle<SignalHead> signalA1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalA2HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalA3HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalB1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalB2HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalC1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalC2HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalD1HeadNamed = null;
    protected NamedBeanHandle<SignalHead> signalD2HeadNamed = null;
    public Point2D dispB = new Point2D.Double(20.0, 0.0);
    public Point2D dispA = new Point2D.Double(20.0, 10.0);
    public Point2D pointA = new Point2D.Double(0.0, 0.0);
    public Point2D pointB = new Point2D.Double(40.0, 0.0);
    public Point2D pointC = new Point2D.Double(60.0, 20.0);
    public Point2D pointD = new Point2D.Double(20.0, 20.0);
    private int version = 1;
    private final boolean useBlockSpeed = false;
    protected LayoutTurnoutEditor editor;
    private final LayoutTurnout turnout;
    public String connectAName = "";
    public String connectBName = "";
    public String connectCName = "";
    public String connectDName = "";
    public String tBlockAName = "";
    public String tBlockBName = "";
    public String tBlockCName = "";
    public String tBlockDName = "";
    private JPopupMenu popup = null;
    ArrayList<JMenuItem> editAdditionalMenu = new ArrayList(0);
    ArrayList<JMenuItem> viewAdditionalMenu = new ArrayList(0);
    private static final Logger log = LoggerFactory.getLogger(LayoutTurnoutView.class);

    public LayoutTurnoutView(@Nonnull LayoutTurnout turnout, @Nonnull Point2D c, double rot, @Nonnull LayoutEditor layoutEditor) {
        this(turnout, c, rot, 1.0, 1.0, layoutEditor);
    }

    public LayoutTurnoutView(@Nonnull LayoutTurnout turnout, @Nonnull Point2D c, double rot, double xFactor, double yFactor, @Nonnull LayoutEditor layoutEditor) {
        super(turnout, c, layoutEditor);
        this.turnout = turnout;
        this.setIdent(turnout.getName());
        int version = turnout.getVersion();
        if (turnout.getTurnoutType() == LayoutTurnout.TurnoutType.LH_TURNOUT) {
            this.dispB = new Point2D.Double(layoutEditor.getTurnoutBX(), 0.0);
            this.dispA = new Point2D.Double(layoutEditor.getTurnoutCX(), -layoutEditor.getTurnoutWid());
        } else if (turnout.getTurnoutType() == LayoutTurnout.TurnoutType.RH_TURNOUT) {
            this.dispB = new Point2D.Double(layoutEditor.getTurnoutBX(), 0.0);
            this.dispA = new Point2D.Double(layoutEditor.getTurnoutCX(), layoutEditor.getTurnoutWid());
        } else if (turnout.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            this.dispB = new Point2D.Double(layoutEditor.getTurnoutBX(), 0.5 * layoutEditor.getTurnoutWid());
            this.dispA = new Point2D.Double(layoutEditor.getTurnoutBX(), -0.5 * layoutEditor.getTurnoutWid());
        } else if (turnout.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
            if (version == 2) {
                super.setCoordsCenter(new Point2D.Double(layoutEditor.getXOverLong(), layoutEditor.getXOverHWid()));
                this.pointB = new Point2D.Double(layoutEditor.getXOverLong() * 2.0, 0.0);
                this.pointC = new Point2D.Double(layoutEditor.getXOverLong() * 2.0, layoutEditor.getXOverHWid() * 2.0);
                this.pointD = new Point2D.Double(0.0, layoutEditor.getXOverHWid() * 2.0);
                super.setCoordsCenter(c);
            } else {
                this.dispB = new Point2D.Double(layoutEditor.getXOverLong(), -layoutEditor.getXOverHWid());
                this.dispA = new Point2D.Double(layoutEditor.getXOverLong(), layoutEditor.getXOverHWid());
            }
        } else if (turnout.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
            if (version == 2) {
                super.setCoordsCenter(new Point2D.Double(layoutEditor.getXOverLong(), layoutEditor.getXOverHWid()));
                this.pointB = new Point2D.Double(layoutEditor.getXOverShort() + layoutEditor.getXOverLong(), 0.0);
                this.pointC = new Point2D.Double(layoutEditor.getXOverLong() * 2.0, layoutEditor.getXOverHWid() * 2.0);
                this.pointD = new Point2D.Double(this.getCoordsCenter().getX() - layoutEditor.getXOverShort(), layoutEditor.getXOverHWid() * 2.0);
                super.setCoordsCenter(c);
            } else {
                this.dispB = new Point2D.Double(layoutEditor.getXOverShort(), -layoutEditor.getXOverHWid());
                this.dispA = new Point2D.Double(layoutEditor.getXOverLong(), layoutEditor.getXOverHWid());
            }
        } else if (turnout.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
            if (version == 2) {
                super.setCoordsCenter(new Point2D.Double(layoutEditor.getXOverLong(), layoutEditor.getXOverHWid()));
                this.pointA = new Point2D.Double(this.getCoordsCenter().getX() - layoutEditor.getXOverShort(), 0.0);
                this.pointB = new Point2D.Double(layoutEditor.getXOverLong() * 2.0, 0.0);
                this.pointC = new Point2D.Double(layoutEditor.getXOverLong() + layoutEditor.getXOverShort(), layoutEditor.getXOverHWid() * 2.0);
                this.pointD = new Point2D.Double(0.0, layoutEditor.getXOverHWid() * 2.0);
                super.setCoordsCenter(c);
            } else {
                this.dispB = new Point2D.Double(layoutEditor.getXOverLong(), -layoutEditor.getXOverHWid());
                this.dispA = new Point2D.Double(layoutEditor.getXOverShort(), layoutEditor.getXOverHWid());
            }
        }
        this.rotateCoords(rot);
        Point2D.Double pt = new Point2D.Double(Math.round(this.dispB.getX() * xFactor), Math.round(this.dispB.getY() * yFactor));
        this.dispB = pt;
        pt = new Point2D.Double(Math.round(this.dispA.getX() * xFactor), Math.round(this.dispA.getY() * yFactor));
        this.dispA = pt;
        this.editor = new LayoutTurnoutEditor(layoutEditor);
    }

    public static boolean isTurnoutTypeTurnout(LayoutTurnout.TurnoutType type) {
        return LayoutTurnout.isTurnoutTypeTurnout(type);
    }

    public boolean isTurnoutTypeTurnout() {
        return this.turnout.isTurnoutTypeTurnout();
    }

    public static boolean isTurnoutTypeXover(LayoutTurnout.TurnoutType type) {
        return LayoutTurnout.isTurnoutTypeXover(type);
    }

    public boolean isTurnoutTypeXover() {
        return this.turnout.isTurnoutTypeXover();
    }

    public static boolean isTurnoutTypeSlip(LayoutTurnout.TurnoutType type) {
        return LayoutTurnout.isTurnoutTypeSlip(type);
    }

    public boolean isTurnoutTypeSlip() {
        return this.turnout.isTurnoutTypeSlip();
    }

    public static boolean hasEnteringSingleTrack(LayoutTurnout.TurnoutType type) {
        return LayoutTurnout.hasEnteringSingleTrack(type);
    }

    public boolean hasEnteringSingleTrack() {
        return LayoutTurnout.hasEnteringSingleTrack(this.getTurnoutType());
    }

    public static boolean hasEnteringDoubleTrack(LayoutTurnout.TurnoutType type) {
        return LayoutTurnout.hasEnteringDoubleTrack(type);
    }

    public boolean hasEnteringDoubleTrack() {
        return this.turnout.hasEnteringDoubleTrack();
    }

    public final LayoutTurnout getLayoutTurnout() {
        return this.turnout;
    }

    @Nonnull
    public String toString() {
        return "LayoutTurnout " + this.getName();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public boolean useBlockSpeed() {
        return false;
    }

    public String getTurnoutName() {
        return this.turnout.getTurnoutName();
    }

    public String getSecondTurnoutName() {
        return this.turnout.getSecondTurnoutName();
    }

    @Nonnull
    public String getBlockName() {
        return this.turnout.getBlockName();
    }

    @Nonnull
    public String getBlockBName() {
        return this.turnout.getBlockBName();
    }

    @Nonnull
    public String getBlockCName() {
        return this.turnout.getBlockCName();
    }

    @Nonnull
    public String getBlockDName() {
        return this.turnout.getBlockDName();
    }

    @CheckForNull
    public SignalHead getSignalHead(LayoutTurnout.Geometry loc) {
        return this.turnout.getSignalHead(loc);
    }

    @CheckForNull
    public SignalHead getSignalA1() {
        return this.turnout.getSignalA1();
    }

    @Nonnull
    public String getSignalA1Name() {
        return this.turnout.getSignalA1Name();
    }

    public void setSignalA1Name(@CheckForNull String signalHead) {
        this.turnout.setSignalA1Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalA2() {
        return this.turnout.getSignalA2();
    }

    @Nonnull
    public String getSignalA2Name() {
        return this.turnout.getSignalA2Name();
    }

    public void setSignalA2Name(@CheckForNull String signalHead) {
        this.turnout.setSignalA2Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalA3() {
        return this.turnout.getSignalA3();
    }

    @Nonnull
    public String getSignalA3Name() {
        return this.turnout.getSignalA3Name();
    }

    public void setSignalA3Name(@CheckForNull String signalHead) {
        this.turnout.setSignalA3Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalB1() {
        return this.turnout.getSignalB1();
    }

    @Nonnull
    public String getSignalB1Name() {
        return this.turnout.getSignalB1Name();
    }

    public void setSignalB1Name(@CheckForNull String signalHead) {
        this.turnout.setSignalB1Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalB2() {
        return this.turnout.getSignalB2();
    }

    @Nonnull
    public String getSignalB2Name() {
        return this.turnout.getSignalB2Name();
    }

    public void setSignalB2Name(@CheckForNull String signalHead) {
        this.turnout.setSignalB2Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalC1() {
        return this.turnout.getSignalC1();
    }

    @Nonnull
    public String getSignalC1Name() {
        return this.turnout.getSignalC1Name();
    }

    public void setSignalC1Name(@CheckForNull String signalHead) {
        this.turnout.setSignalC1Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalC2() {
        return this.turnout.getSignalC2();
    }

    @Nonnull
    public String getSignalC2Name() {
        return this.turnout.getSignalC2Name();
    }

    public void setSignalC2Name(@CheckForNull String signalHead) {
        this.turnout.setSignalC2Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalD1() {
        return this.turnout.getSignalD1();
    }

    @Nonnull
    public String getSignalD1Name() {
        return this.turnout.getSignalD1Name();
    }

    public void setSignalD1Name(@CheckForNull String signalHead) {
        this.turnout.setSignalD1Name(signalHead);
    }

    @CheckForNull
    public SignalHead getSignalD2() {
        return this.turnout.getSignalD2();
    }

    @Nonnull
    public String getSignalD2Name() {
        return this.turnout.getSignalD2Name();
    }

    public void setSignalD2Name(@CheckForNull String signalHead) {
        this.turnout.setSignalD2Name(signalHead);
    }

    public void removeBeanReference(@CheckForNull NamedBean nb) {
        this.turnout.removeBeanReference(nb);
    }

    @Override
    public boolean canRemove() {
        return this.turnout.canRemove();
    }

    @Nonnull
    public ArrayList<String> getBeanReferences(String pointName) {
        throw new IllegalArgumentException("should be called on LayoutTurnout");
    }

    @Nonnull
    public String getSignalAMastName() {
        return this.turnout.getSignalAMastName();
    }

    @CheckForNull
    public SignalMast getSignalAMast() {
        return this.turnout.getSignalAMast();
    }

    public void setSignalAMast(@CheckForNull String signalMast) {
        this.turnout.setSignalAMast(signalMast);
    }

    @Nonnull
    public String getSignalBMastName() {
        return this.turnout.getSignalBMastName();
    }

    @CheckForNull
    public SignalMast getSignalBMast() {
        return this.turnout.getSignalBMast();
    }

    public void setSignalBMast(@CheckForNull String signalMast) {
        this.turnout.setSignalBMast(signalMast);
    }

    @Nonnull
    public String getSignalCMastName() {
        return this.turnout.getSignalCMastName();
    }

    @CheckForNull
    public SignalMast getSignalCMast() {
        return this.turnout.getSignalCMast();
    }

    public void setSignalCMast(@CheckForNull String signalMast) {
        this.turnout.setSignalCMast(signalMast);
    }

    @Nonnull
    public String getSignalDMastName() {
        return this.turnout.getSignalDMastName();
    }

    @CheckForNull
    public SignalMast getSignalDMast() {
        return this.turnout.getSignalDMast();
    }

    public void setSignalDMast(@CheckForNull String signalMast) {
        this.turnout.setSignalDMast(signalMast);
    }

    @Nonnull
    public String getSensorAName() {
        return this.turnout.getSensorAName();
    }

    @CheckForNull
    public Sensor getSensorA() {
        return this.turnout.getSensorA();
    }

    public void setSensorA(@CheckForNull String sensorName) {
        this.turnout.setSensorA(sensorName);
    }

    @Nonnull
    public String getSensorBName() {
        return this.turnout.getSensorBName();
    }

    @CheckForNull
    public Sensor getSensorB() {
        return this.turnout.getSensorB();
    }

    public void setSensorB(@CheckForNull String sensorName) {
        this.turnout.setSensorB(sensorName);
    }

    @Nonnull
    public String getSensorCName() {
        return this.turnout.getSensorCName();
    }

    @CheckForNull
    public Sensor getSensorC() {
        return this.turnout.getSensorC();
    }

    public void setSensorC(@CheckForNull String sensorName) {
        this.turnout.setSensorC(sensorName);
    }

    @Nonnull
    public String getSensorDName() {
        return this.turnout.getSensorDName();
    }

    @CheckForNull
    public Sensor getSensorD() {
        return this.turnout.getSensorD();
    }

    public void setSensorD(@CheckForNull String sensorName) {
        this.turnout.setSensorD(sensorName);
    }

    public String getLinkedTurnoutName() {
        return this.turnout.getLinkedTurnoutName();
    }

    public void setLinkedTurnoutName(@Nonnull String s) {
        this.turnout.setSensorD(s);
    }

    public LayoutTurnout.LinkType getLinkType() {
        return this.turnout.getLinkType();
    }

    public void setLinkType(LayoutTurnout.LinkType ltype) {
        this.turnout.setLinkType(ltype);
    }

    public LayoutTurnout.TurnoutType getTurnoutType() {
        return this.turnout.getTurnoutType();
    }

    public LayoutTrack getConnectA() {
        return this.turnout.getConnectA();
    }

    public LayoutTrack getConnectB() {
        return this.turnout.getConnectB();
    }

    public LayoutTrack getConnectC() {
        return this.turnout.getConnectC();
    }

    public LayoutTrack getConnectD() {
        return this.turnout.getConnectD();
    }

    public Turnout getTurnout() {
        return this.turnout.getTurnout();
    }

    public int getContinuingSense() {
        return this.turnout.getContinuingSense();
    }

    public boolean isInContinuingSenseState() {
        return this.turnout.isInContinuingSenseState();
    }

    public void setTurnout(@Nonnull String tName) {
        this.turnout.setTurnout(tName);
    }

    public Turnout getSecondTurnout() {
        return this.turnout.getSecondTurnout();
    }

    public void setSecondTurnout(@Nonnull String tName) {
        this.turnout.setSecondTurnout(tName);
    }

    public void setSecondTurnoutInverted(boolean inverted) {
        this.turnout.setSecondTurnoutInverted(inverted);
    }

    public void setContinuingSense(int sense) {
        this.turnout.setContinuingSense(sense);
    }

    public void setDisabled(boolean state) {
        this.turnout.setDisabled(state);
        if (this.layoutEditor != null) {
            this.layoutEditor.redrawPanel();
        }
    }

    public boolean isDisabled() {
        return this.turnout.isDisabled();
    }

    public void setDisableWhenOccupied(boolean state) {
        this.turnout.setDisableWhenOccupied(state);
        if (this.layoutEditor != null) {
            this.layoutEditor.redrawPanel();
        }
    }

    public boolean isDisabledWhenOccupied() {
        return this.turnout.isDisabledWhenOccupied();
    }

    @Override
    @CheckForNull
    public LayoutTrack getConnection(HitPointType connectionType) throws JmriException {
        return this.turnout.getConnection(connectionType);
    }

    @Override
    public void setConnection(HitPointType connectionType, @CheckForNull LayoutTrack o, HitPointType type) throws JmriException {
        this.turnout.setConnection(connectionType, o, type);
    }

    public void setConnectA(@CheckForNull LayoutTrack o, HitPointType type) {
        this.turnout.setConnectA(o, type);
    }

    public void setConnectB(@CheckForNull LayoutTrack o, HitPointType type) {
        this.turnout.setConnectB(o, type);
    }

    public void setConnectC(@CheckForNull LayoutTrack o, HitPointType type) {
        this.turnout.setConnectC(o, type);
    }

    public void setConnectD(@CheckForNull LayoutTrack o, HitPointType type) {
        this.turnout.setConnectD(o, type);
    }

    public LayoutBlock getLayoutBlock() {
        return this.turnout.getLayoutBlock();
    }

    public LayoutBlock getLayoutBlockB() {
        return this.turnout.getLayoutBlockB();
    }

    public LayoutBlock getLayoutBlockC() {
        return this.turnout.getLayoutBlockC();
    }

    public LayoutBlock getLayoutBlockD() {
        return this.turnout.getLayoutBlockD();
    }

    @Nonnull
    public Point2D getCoordsA() {
        if (this.isTurnoutTypeXover()) {
            if (this.version == 2) {
                return this.pointA;
            }
            return MathUtil.subtract(this.getCoordsCenter(), this.dispA);
        }
        if (this.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            return MathUtil.subtract(this.getCoordsCenter(), MathUtil.midPoint(this.dispB, this.dispA));
        }
        return MathUtil.subtract(this.getCoordsCenter(), this.dispB);
    }

    @Nonnull
    public Point2D getCoordsB() {
        if (this.version == 2 && this.isTurnoutTypeXover()) {
            return this.pointB;
        }
        return MathUtil.add(this.getCoordsCenter(), this.dispB);
    }

    @Nonnull
    public Point2D getCoordsC() {
        if (this.version == 2 && this.isTurnoutTypeXover()) {
            return this.pointC;
        }
        return MathUtil.add(this.getCoordsCenter(), this.dispA);
    }

    @Nonnull
    public Point2D getCoordsD() {
        if (this.version == 2 && this.isTurnoutTypeXover()) {
            return this.pointD;
        }
        return MathUtil.subtract(this.getCoordsCenter(), this.dispB);
    }

    @Override
    @Nonnull
    public Point2D getCoordsForConnectionType(HitPointType connectionType) {
        Point2D result = this.getCoordsCenter();
        switch (connectionType) {
            case TURNOUT_CENTER: {
                break;
            }
            case TURNOUT_A: {
                result = this.getCoordsA();
                break;
            }
            case TURNOUT_B: {
                result = this.getCoordsB();
                break;
            }
            case TURNOUT_C: {
                result = this.getCoordsC();
                break;
            }
            case TURNOUT_D: {
                result = this.getCoordsD();
                break;
            }
            default: {
                log.error("{}.getCoordsForConnectionType({}); Invalid Connection Type", (Object)this.getName(), (Object)connectionType);
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public Rectangle2D getBounds() {
        Point2D pointA = this.getCoordsA();
        Rectangle2D.Double result = new Rectangle2D.Double(pointA.getX(), pointA.getY(), 0.0, 0.0);
        result.add(this.getCoordsB());
        result.add(this.getCoordsC());
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            result.add(this.getCoordsD());
        }
        return result;
    }

    public void updateBlockInfo() {
        this.turnout.updateBlockInfo();
    }

    protected void setUpDefaultSize() {
        double bX = this.dispB.getX() / this.layoutEditor.gContext.getXScale();
        double bY = this.dispB.getY() / this.layoutEditor.gContext.getYScale();
        double cX = this.dispA.getX() / this.layoutEditor.gContext.getXScale();
        double cY = this.dispA.getY() / this.layoutEditor.gContext.getYScale();
        double lenB = Math.hypot(bX, bY);
        double lenC = Math.hypot(cX, cY);
        double distBC = Math.hypot(bX - cX, bY - cY);
        if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_TURNOUT || this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_TURNOUT) {
            this.layoutEditor.setTurnoutBX(Math.round(lenB + 0.1));
            double xc = (bX * cX + bY * cY) / lenB;
            this.layoutEditor.setTurnoutCX(Math.round(xc + 0.1));
            this.layoutEditor.setTurnoutWid(Math.round(Math.sqrt(lenC * lenC - xc * xc) + 0.1));
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            double xx = Math.sqrt(lenB * lenB - 0.25 * (distBC * distBC));
            this.layoutEditor.setTurnoutBX(Math.round(xx + 0.1));
            this.layoutEditor.setTurnoutCX(Math.round(xx + 0.1));
            this.layoutEditor.setTurnoutWid(Math.round(distBC + 0.1));
        } else if (this.version == 2) {
            double aX = this.pointA.getX() / this.layoutEditor.gContext.getXScale();
            double aY = this.pointA.getY() / this.layoutEditor.gContext.getYScale();
            bX = this.pointB.getX() / this.layoutEditor.gContext.getXScale();
            bY = this.pointB.getY() / this.layoutEditor.gContext.getYScale();
            cX = this.pointC.getX() / this.layoutEditor.gContext.getXScale();
            cY = this.pointC.getY() / this.layoutEditor.gContext.getYScale();
            double lenAB = Math.hypot(bX - aX, bY - aY);
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                double lenBC = Math.hypot(bX - cX, bY - cY);
                this.layoutEditor.setXOverLong(Math.round(lenAB / 2.0));
                this.layoutEditor.setXOverHWid(Math.round(lenBC / 2.0));
                this.layoutEditor.setXOverShort(Math.round(0.5 * lenAB / 2.0));
            } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                this.layoutEditor.setXOverShort(Math.round(lenAB /= 3.0));
                this.layoutEditor.setXOverLong(Math.round(lenAB * 2.0));
                double opp = aY - bY;
                double ang = Math.asin(opp / (lenAB * 3.0));
                opp = Math.sin(ang) * lenAB;
                double adj = Math.cos(ang) * lenAB;
                double lenBC = Math.hypot((bX += adj) - cX, (bY += opp) - cY);
                this.layoutEditor.setXOverHWid(Math.round(lenBC / 2.0));
            } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                double dY = this.pointD.getY() / this.layoutEditor.gContext.getYScale();
                this.layoutEditor.setXOverShort(Math.round(lenAB /= 3.0));
                this.layoutEditor.setXOverLong(Math.round(lenAB * 2.0));
                double opp = dY - cY;
                double ang = Math.asin(opp / (lenAB * 3.0));
                opp = Math.sin(ang) * lenAB;
                double adj = Math.cos(ang) * lenAB;
                double lenBC = Math.hypot(bX - (cX += adj), bY - (cY += opp));
                this.layoutEditor.setXOverHWid(Math.round(lenBC / 2.0));
            }
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
            double lng = Math.sqrt(lenB * lenB - 0.25 * (distBC * distBC));
            this.layoutEditor.setXOverLong(Math.round(lng + 0.1));
            this.layoutEditor.setXOverHWid(Math.round(0.5 * distBC + 0.1));
            this.layoutEditor.setXOverShort(Math.round(0.5 * lng + 0.1));
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
            double distDC = Math.hypot(bX + cX, bY + cY);
            this.layoutEditor.setXOverShort(Math.round(0.25 * distDC + 0.1));
            this.layoutEditor.setXOverLong(Math.round(0.75 * distDC + 0.1));
            double hwid = Math.sqrt(lenC * lenC - 0.5625 * distDC * distDC);
            this.layoutEditor.setXOverHWid(Math.round(hwid + 0.1));
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
            double distDC = Math.hypot(bX + cX, bY + cY);
            this.layoutEditor.setXOverShort(Math.round(0.25 * distDC + 0.1));
            this.layoutEditor.setXOverLong(Math.round(0.75 * distDC + 0.1));
            double hwid = Math.sqrt(lenC * lenC - 0.0625 * distDC * distDC);
            this.layoutEditor.setXOverHWid(Math.round(hwid + 0.1));
        }
    }

    public void setLayoutBlock(LayoutBlock newLayoutBlock) {
        this.turnout.setLayoutBlock(newLayoutBlock);
        this.setTrackSegmentBlocks();
    }

    public void setLayoutBlockB(LayoutBlock newLayoutBlock) {
        this.turnout.setLayoutBlockB(newLayoutBlock);
        this.setTrackSegmentBlocks();
    }

    public void setLayoutBlockC(LayoutBlock newLayoutBlock) {
        this.turnout.setLayoutBlockC(newLayoutBlock);
        this.setTrackSegmentBlocks();
    }

    public void setLayoutBlockD(LayoutBlock newLayoutBlock) {
        this.turnout.setLayoutBlockD(newLayoutBlock);
        this.setTrackSegmentBlocks();
    }

    public void setLayoutBlockByName(@Nonnull String name) {
        this.turnout.setLayoutBlockByName(name);
    }

    public void setLayoutBlockBByName(@Nonnull String name) {
        this.turnout.setLayoutBlockByName(name);
    }

    public void setLayoutBlockCByName(@Nonnull String name) {
        this.turnout.setLayoutBlockByName(name);
    }

    public void setLayoutBlockDByName(@Nonnull String name) {
        this.turnout.setLayoutBlockByName(name);
    }

    void setTrackSegmentBlocks() {
        this.setTrackSegmentBlock(HitPointType.TURNOUT_A, false);
        this.setTrackSegmentBlock(HitPointType.TURNOUT_B, false);
        this.setTrackSegmentBlock(HitPointType.TURNOUT_C, false);
        if (this.hasEnteringDoubleTrack()) {
            this.setTrackSegmentBlock(HitPointType.TURNOUT_D, false);
        }
    }

    void setTrackSegmentBlock(HitPointType pointType, boolean isAutomatic) {
        Point2D pointCoord;
        TrackSegment trkSeg;
        LayoutBlock blockA = this.getLayoutBlock();
        LayoutBlock blockB = this.getLayoutBlock();
        LayoutBlock blockC = this.getLayoutBlock();
        LayoutBlock blockD = this.getLayoutBlock();
        LayoutBlock currBlk = blockA;
        switch (pointType) {
            case TURNOUT_A: 
            case SLIP_A: {
                if (this.signalA1HeadNamed != null) {
                    return;
                }
                if (this.signalA2HeadNamed != null) {
                    return;
                }
                if (this.signalA3HeadNamed != null) {
                    return;
                }
                if (this.getSignalAMast() != null) {
                    return;
                }
                if (this.getSensorA() != null) {
                    return;
                }
                trkSeg = (TrackSegment)this.getConnectA();
                pointCoord = this.getCoordsA();
                break;
            }
            case TURNOUT_B: 
            case SLIP_B: {
                if (this.signalB1HeadNamed != null) {
                    return;
                }
                if (this.signalB2HeadNamed != null) {
                    return;
                }
                if (this.getSignalBMast() != null) {
                    return;
                }
                if (this.getSensorB() != null) {
                    return;
                }
                trkSeg = (TrackSegment)this.getConnectB();
                pointCoord = this.getCoordsB();
                if (!this.isTurnoutTypeXover()) break;
                currBlk = blockB != null ? blockB : blockA;
                break;
            }
            case TURNOUT_C: 
            case SLIP_C: {
                if (this.signalC1HeadNamed != null) {
                    return;
                }
                if (this.signalC2HeadNamed != null) {
                    return;
                }
                if (this.getSignalCMast() != null) {
                    return;
                }
                if (this.getSensorC() != null) {
                    return;
                }
                trkSeg = (TrackSegment)this.getConnectC();
                pointCoord = this.getCoordsC();
                if (!this.isTurnoutTypeXover()) break;
                currBlk = blockC != null ? blockC : blockA;
                break;
            }
            case TURNOUT_D: 
            case SLIP_D: {
                if (this.signalD1HeadNamed != null) {
                    return;
                }
                if (this.signalD2HeadNamed != null) {
                    return;
                }
                if (this.getSignalDMast() != null) {
                    return;
                }
                if (this.getSensorD() != null) {
                    return;
                }
                trkSeg = (TrackSegment)this.getConnectD();
                pointCoord = this.getCoordsD();
                if (!this.isTurnoutTypeXover()) break;
                currBlk = blockD != null ? blockD : blockA;
                break;
            }
            default: {
                log.error("{}.setTrackSegmentBlock({}, {}); Invalid pointType", new Object[]{this.getName(), pointType, isAutomatic ? "AUTO" : "NON-AUTO"});
                return;
            }
        }
        if (trkSeg != null) {
            double chkSize = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
            double segLength = 0.0;
            if (!isAutomatic) {
                Point2D segCenter = this.getCoordsCenter();
                segLength = MathUtil.distance(pointCoord, segCenter) * 2.0;
            }
            if (segLength < chkSize) {
                log.debug("Set block:");
                log.debug("    seg: {}", (Object)trkSeg);
                log.debug("    cor: {}", (Object)pointCoord);
                log.debug("    blk: {}", (Object)(currBlk == null ? "null" : currBlk.getDisplayName()));
                log.debug("    len: {}", (Object)segLength);
                trkSeg.setLayoutBlock(currBlk);
                this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            }
        }
    }

    public boolean isMainlineA() {
        return this.turnout.isMainlineA();
    }

    public boolean isMainlineB() {
        return this.turnout.isMainlineB();
    }

    public boolean isMainlineC() {
        return this.turnout.isMainlineC();
    }

    public boolean isMainlineD() {
        return this.turnout.isMainlineD();
    }

    @Override
    protected HitPointType findHitPointType(@Nonnull Point2D hitPoint, boolean useRectangles, boolean requireUnconnected) {
        Point2D p;
        double distance;
        HitPointType result = HitPointType.NONE;
        Rectangle2D r = this.layoutEditor.layoutEditorControlCircleRectAt(hitPoint);
        Point2D minPoint = MathUtil.zeroPoint2D;
        double circleRadius = 3.0 * (double)this.layoutEditor.getTurnoutCircleSize();
        double minDistance = Double.POSITIVE_INFINITY;
        if (!requireUnconnected && (distance = MathUtil.distance(p = this.getCoordsCenter(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.TURNOUT_CENTER;
        }
        if ((!requireUnconnected || this.getConnectA() == null) && (distance = MathUtil.distance(p = this.getCoordsA(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.TURNOUT_A;
        }
        if ((!requireUnconnected || this.getConnectB() == null) && (distance = MathUtil.distance(p = this.getCoordsB(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.TURNOUT_B;
        }
        if ((!requireUnconnected || this.getConnectC() == null) && (distance = MathUtil.distance(p = this.getCoordsC(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.TURNOUT_C;
        }
        if (this.isTurnoutTypeXover() && (!requireUnconnected || this.getConnectD() == null) && (distance = MathUtil.distance(p = this.getCoordsD(), hitPoint)) < minDistance) {
            minDistance = distance;
            minPoint = p;
            result = HitPointType.TURNOUT_D;
        }
        if (useRectangles && !r.contains(minPoint) || !useRectangles && minDistance > circleRadius) {
            result = HitPointType.NONE;
        }
        return result;
    }

    @Override
    public void setCoordsCenter(@Nonnull Point2D p) {
        Point2D offset = MathUtil.subtract(p, this.getCoordsCenter());
        this.pointA = MathUtil.add(this.pointA, offset);
        this.pointB = MathUtil.add(this.pointB, offset);
        this.pointC = MathUtil.add(this.pointC, offset);
        this.pointD = MathUtil.add(this.pointD, offset);
        super.setCoordsCenter(p);
    }

    void reCalculateCenter() {
        super.setCoordsCenter(MathUtil.midPoint(this.pointA, this.pointC));
    }

    public void setCoordsA(@Nonnull Point2D p) {
        this.pointA = p;
        if (this.version == 2) {
            this.reCalculateCenter();
        }
        double x = this.getCoordsCenter().getX() - p.getX();
        double y = this.getCoordsCenter().getY() - p.getY();
        if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
            this.dispA = new Point2D.Double(x, y);
            double oldLength = MathUtil.length(this.dispB);
            double newLength = Math.hypot(x, y);
            this.dispB = MathUtil.multiply(this.dispB, newLength / oldLength);
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER || this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
            this.dispA = new Point2D.Double(x, y);
            double a = 0.0;
            double b = -y;
            double xi = 0.0;
            double yi = b;
            if (this.dispB.getX() + x != 0.0) {
                a = (this.dispB.getY() + y) / (this.dispB.getX() + x);
                b = -y + a * x;
                xi = -b / (a + 1.0 / a);
                yi = a * xi + b;
            }
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                x = xi - 0.333333 * (-x - xi);
                y = yi - 0.333333 * (-y - yi);
            } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                x = xi - 3.0 * (-x - xi);
                y = yi - 3.0 * (-y - yi);
            }
            this.dispB = new Point2D.Double(x, y);
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            double temX = this.dispB.getX() + this.dispA.getX();
            double temY = this.dispB.getY() + this.dispA.getY();
            double temXx = this.dispB.getX() - this.dispA.getX();
            double temYy = this.dispB.getY() - this.dispA.getY();
            double tan = Math.sqrt((temX * temX + temY * temY) / (temXx * temXx + temYy * temYy));
            double xx = x + y / tan;
            double yy = y - x / tan;
            this.dispA = new Point2D.Double(xx, yy);
            xx = x - y / tan;
            yy = y + x / tan;
            this.dispB = new Point2D.Double(xx, yy);
        } else {
            this.dispB = new Point2D.Double(x, y);
        }
    }

    public void setCoordsB(Point2D p) {
        this.pointB = p;
        double x = this.getCoordsCenter().getX() - p.getX();
        double y = this.getCoordsCenter().getY() - p.getY();
        this.dispB = new Point2D.Double(-x, -y);
        if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || this.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            double oldLength = MathUtil.length(this.dispA);
            double newLength = Math.hypot(x, y);
            this.dispA = MathUtil.multiply(this.dispA, newLength / oldLength);
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER || this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
            double a = 0.0;
            double b = y;
            double xi = 0.0;
            double yi = b;
            if (this.dispA.getX() - x != 0.0) {
                if (-this.dispA.getX() + x == 0.0) {
                    x -= 1.0E-10;
                }
                a = (this.dispA.getY() - y) / (this.dispA.getX() - x);
                b = y - a * x;
                xi = -b / (a + 1.0 / a);
                yi = a * xi + b;
            }
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                x = xi - 0.333333 * (x - xi);
                y = yi - 0.333333 * (y - yi);
            } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                x = xi - 3.0 * (x - xi);
                y = yi - 3.0 * (y - yi);
            }
            this.dispA = new Point2D.Double(x, y);
        }
    }

    public void setCoordsC(Point2D p) {
        this.pointC = p;
        if (this.version == 2) {
            this.reCalculateCenter();
        }
        double x = this.getCoordsCenter().getX() - p.getX();
        double y = this.getCoordsCenter().getY() - p.getY();
        this.dispA = new Point2D.Double(-x, -y);
        if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || this.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            double oldLength = MathUtil.length(this.dispB);
            double newLength = Math.hypot(x, y);
            this.dispB = MathUtil.multiply(this.dispB, newLength / oldLength);
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER || this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
            double a = 0.0;
            double b = -y;
            double xi = 0.0;
            double yi = b;
            if (this.dispB.getX() + x != 0.0) {
                if (-this.dispB.getX() + x == 0.0) {
                    x -= 1.0E-10;
                }
                a = (-this.dispB.getY() + y) / (-this.dispB.getX() + x);
                b = -y + a * x;
                xi = -b / (a + 1.0 / a);
                yi = a * xi + b;
            }
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                x = xi - 0.333333 * (-x - xi);
                y = yi - 0.333333 * (-y - yi);
            } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                x = xi - 3.0 * (-x - xi);
                y = yi - 3.0 * (-y - yi);
            }
            this.dispB = new Point2D.Double(-x, -y);
        }
    }

    public void setCoordsD(Point2D p) {
        this.pointD = p;
        double x = this.getCoordsCenter().getX() - p.getX();
        double y = this.getCoordsCenter().getY() - p.getY();
        this.dispB = new Point2D.Double(x, y);
        if (this.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
            double oldLength = MathUtil.length(this.dispA);
            double newLength = Math.hypot(x, y);
            this.dispA = MathUtil.multiply(this.dispA, newLength / oldLength);
        } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER || this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
            double a = 0.0;
            double b = y;
            double xi = 0.0;
            double yi = b;
            if (this.dispA.getX() + x != 0.0) {
                a = (this.dispA.getY() + y) / (this.dispA.getX() + x);
                b = -y + a * x;
                xi = -b / (a + 1.0 / a);
                yi = a * xi + b;
            }
            if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                x = xi - 0.333333 * (-x - xi);
                y = yi - 0.333333 * (-y - yi);
            } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                x = xi - 3.0 * (-x - xi);
                y = yi - 3.0 * (-y - yi);
            }
            this.dispA = new Point2D.Double(x, y);
        }
    }

    @Override
    public void scaleCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.granulize(MathUtil.multiply(this.getCoordsCenter(), (Point2D)factor), 1.0));
        this.dispA = MathUtil.granulize(MathUtil.multiply(this.dispA, (Point2D)factor), 1.0);
        this.dispB = MathUtil.granulize(MathUtil.multiply(this.dispB, (Point2D)factor), 1.0);
        this.pointA = MathUtil.granulize(MathUtil.multiply(this.pointA, (Point2D)factor), 1.0);
        this.pointB = MathUtil.granulize(MathUtil.multiply(this.pointB, (Point2D)factor), 1.0);
        this.pointC = MathUtil.granulize(MathUtil.multiply(this.pointC, (Point2D)factor), 1.0);
        this.pointD = MathUtil.granulize(MathUtil.multiply(this.pointD, (Point2D)factor), 1.0);
    }

    @Override
    public void translateCoords(double xFactor, double yFactor) {
        Point2D.Double factor = new Point2D.Double(xFactor, yFactor);
        super.setCoordsCenter(MathUtil.add(this.getCoordsCenter(), factor));
        this.pointA = MathUtil.add(this.pointA, factor);
        this.pointB = MathUtil.add(this.pointB, factor);
        this.pointC = MathUtil.add(this.pointC, factor);
        this.pointD = MathUtil.add(this.pointD, factor);
    }

    @Override
    public void rotateCoords(double angleDEG) {
        double rotRAD = Math.toRadians(angleDEG);
        double sineRot = Math.sin(rotRAD);
        double cosineRot = Math.cos(rotRAD);
        Point2D center_temp = this.getCoordsCenter();
        super.setCoordsCenter(MathUtil.zeroPoint2D);
        this.dispA = this.rotatePoint(this.dispA, sineRot, cosineRot);
        this.dispB = this.rotatePoint(this.dispB, sineRot, cosineRot);
        super.setCoordsCenter(center_temp);
        this.pointA = this.rotatePoint(this.pointA, sineRot, cosineRot);
        this.pointB = this.rotatePoint(this.pointB, sineRot, cosineRot);
        this.pointC = this.rotatePoint(this.pointC, sineRot, cosineRot);
        this.pointD = this.rotatePoint(this.pointD, sineRot, cosineRot);
    }

    public double getRotationDEG() {
        double result = 0.0;
        switch (this.getTurnoutType()) {
            case RH_TURNOUT: 
            case LH_TURNOUT: 
            case WYE_TURNOUT: {
                result = 90.0 - MathUtil.computeAngleDEG(this.getCoordsA(), this.getCoordsCenter());
                break;
            }
            case DOUBLE_XOVER: 
            case RH_XOVER: 
            case LH_XOVER: {
                result = 90.0 - MathUtil.computeAngleDEG(this.getCoordsA(), this.getCoordsB());
                break;
            }
        }
        return result;
    }

    public void toggleTurnout() {
        this.turnout.toggleTurnout();
    }

    public void setState(int state) {
        this.turnout.setState(state);
    }

    public int getState() {
        return this.turnout.getState();
    }

    private boolean isOccupied() {
        return this.turnout.isOccupied();
    }

    @Override
    @Nonnull
    protected JPopupMenu showPopup(@CheckForNull MouseEvent mouseEvent) {
        if (this.popup != null) {
            this.popup.removeAll();
        } else {
            this.popup = new JPopupMenu();
        }
        if (this.layoutEditor.isEditable()) {
            String stateString;
            String label = "";
            switch (this.getTurnoutType()) {
                case RH_TURNOUT: {
                    label = Bundle.getMessage("RightTurnout");
                    break;
                }
                case LH_TURNOUT: {
                    label = Bundle.getMessage("LeftTurnout");
                    break;
                }
                case WYE_TURNOUT: {
                    label = Bundle.getMessage("WYETurnout");
                    break;
                }
                case DOUBLE_XOVER: {
                    label = Bundle.getMessage("DoubleCrossover");
                    break;
                }
                case RH_XOVER: {
                    label = Bundle.getMessage("RightCrossover");
                    break;
                }
                case LH_XOVER: {
                    label = Bundle.getMessage("LeftCrossover");
                    break;
                }
            }
            JMenuItem jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", label)) + this.getName());
            jmi.setEnabled(false);
            if (this.getTurnout() == null) {
                jmi = this.popup.add(Bundle.getMessage("NoTurnout"));
            } else {
                stateString = this.getTurnoutStateString(this.getTurnout().getKnownState());
                stateString = String.format(" (%s)", stateString);
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("BeanNameTurnout")) + ": " + this.getTurnoutName() + stateString);
            }
            jmi.setEnabled(false);
            if (this.getSecondTurnout() != null) {
                stateString = this.getTurnoutStateString(this.getSecondTurnout().getKnownState());
                stateString = String.format(" (%s)", stateString);
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("Supporting", Bundle.getMessage("BeanNameTurnout"))) + ": " + this.getSecondTurnoutName() + stateString);
            }
            jmi.setEnabled(false);
            if (this.getBlockName().isEmpty()) {
                jmi = this.popup.add(Bundle.getMessage("NoBlock"));
                jmi.setEnabled(false);
            } else {
                jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameBlock"))) + this.getLayoutBlock().getDisplayName());
                jmi.setEnabled(false);
                if (this.isTurnoutTypeXover()) {
                    if (this.getLayoutBlockB() != null && this.getLayoutBlockB() != this.getLayoutBlock()) {
                        jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "B"))) + this.getLayoutBlockB().getDisplayName());
                        jmi.setEnabled(false);
                    }
                    if (this.getLayoutBlockC() != null && this.getLayoutBlockC() != this.getLayoutBlock()) {
                        jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "C"))) + this.getLayoutBlockC().getDisplayName());
                        jmi.setEnabled(false);
                    }
                    if (this.getLayoutBlockD() != null && this.getLayoutBlockD() != this.getLayoutBlock()) {
                        jmi = this.popup.add(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("Block_ID", "D"))) + this.getLayoutBlockD().getDisplayName());
                        jmi.setEnabled(false);
                    }
                }
            }
            if (this.getConnectA() != null || this.getConnectB() != null || this.getConnectC() != null || this.getConnectD() != null) {
                JMenu connectionsMenu = new JMenu(Bundle.getMessage("Connections"));
                if (this.getConnectA() != null) {
                    connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "A")) + this.getConnectA().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutTurnoutView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutTurnoutView.this.getConnectA().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutTurnoutView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutTurnoutView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectB() != null) {
                    connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "B")) + this.getConnectB().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutTurnoutView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutTurnoutView.this.getConnectB().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutTurnoutView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutTurnoutView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectC() != null) {
                    connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "C")) + this.getConnectC().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutTurnoutView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutTurnoutView.this.getConnectC().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutTurnoutView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutTurnoutView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                if (this.getConnectD() != null) {
                    connectionsMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("MakeLabel", "D")) + this.getConnectD().getName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorFindItems lf = LayoutTurnoutView.this.layoutEditor.getFinder();
                            LayoutTrack lt = lf.findObjectByName(LayoutTurnoutView.this.getConnectD().getName());
                            if (lt != null) {
                                LayoutTrackView ltv = LayoutTurnoutView.this.layoutEditor.getLayoutTrackView(lt);
                                LayoutTurnoutView.this.layoutEditor.setSelectionRect(ltv.getBounds());
                                ltv.showPopup();
                            }
                        }
                    });
                }
                this.popup.add(connectionsMenu);
            }
            this.popup.add(new JSeparator(0));
            JCheckBoxMenuItem hiddenCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("Hidden"));
            hiddenCheckBoxMenuItem.setSelected(this.isHidden());
            this.popup.add(hiddenCheckBoxMenuItem);
            hiddenCheckBoxMenuItem.addActionListener(e1 -> {
                JCheckBoxMenuItem o = (JCheckBoxMenuItem)e1.getSource();
                this.setHidden(o.isSelected());
            });
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(Bundle.getMessage("Disabled"));
            cbmi.setSelected(this.isDisabled());
            this.popup.add(cbmi);
            cbmi.addActionListener(e2 -> {
                JCheckBoxMenuItem o = (JCheckBoxMenuItem)e2.getSource();
                this.setDisabled(o.isSelected());
            });
            cbmi = new JCheckBoxMenuItem(Bundle.getMessage("DisabledWhenOccupied"));
            if (this.getTurnout() == null || this.getBlockName().isEmpty()) {
                cbmi.setEnabled(false);
            }
            cbmi.setSelected(this.isDisabledWhenOccupied());
            this.popup.add(cbmi);
            cbmi.addActionListener(e3 -> {
                JCheckBoxMenuItem o = (JCheckBoxMenuItem)e3.getSource();
                this.setDisableWhenOccupied(o.isSelected());
            });
            JMenuItem rotateItem = new JMenuItem(String.valueOf(Bundle.getMessage("Rotate_", String.format("%.1f", this.getRotationDEG()))) + "...");
            this.popup.add(rotateItem);
            rotateItem.addActionListener(event -> {
                boolean entering = true;
                boolean error = false;
                String newAngle = "";
                while (entering) {
                    error = false;
                    newAngle = JOptionPane.showInputDialog(this.layoutEditor, (Object)Bundle.getMessage("MakeLabel", Bundle.getMessage("EnterRotation")));
                    if (newAngle.isEmpty()) {
                        return;
                    }
                    double rot = 0.0;
                    try {
                        rot = Double.parseDouble(newAngle);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(this.layoutEditor, String.valueOf(Bundle.getMessage("Error3")) + " " + e1, Bundle.getMessage("ErrorTitle"), 0);
                        error = true;
                        newAngle = "";
                    }
                    if (error) continue;
                    entering = false;
                    if (rot == 0.0) continue;
                    this.rotateCoords(rot);
                    this.layoutEditor.redrawPanel();
                }
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("UseSizeAsDefault")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutTurnoutView.this.setUpDefaultSize();
                }
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("ButtonEdit")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutTurnoutView.this.editor.editLayoutTrack(LayoutTurnoutView.this);
                }
            });
            this.popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LayoutTurnoutView.this.canRemove() && LayoutTurnoutView.this.layoutEditor.removeLayoutTurnout(LayoutTurnoutView.this.turnout)) {
                        LayoutTurnoutView.this.remove();
                        LayoutTurnoutView.this.dispose();
                    }
                }
            });
            if (this.getTurnout() != null) {
                AbstractAction ssaa = new AbstractAction(Bundle.getMessage("SetSignals")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayoutEditorTools tools = LayoutTurnoutView.this.layoutEditor.getLETools();
                        LayoutEditorToolBarPanel letbp = LayoutTurnoutView.this.getLayoutEditorToolBarPanel();
                        if (LayoutTurnoutView.this.isTurnoutTypeXover()) {
                            tools.setSignalsAtXoverTurnoutFromMenu(LayoutTurnoutView.this.turnout, letbp.signalIconEditor, letbp.signalFrame);
                        } else if (LayoutTurnoutView.this.getLinkType() == LayoutTurnout.LinkType.NO_LINK) {
                            tools.setSignalsAtTurnoutFromMenu(LayoutTurnoutView.this.turnout, letbp.signalIconEditor, letbp.signalFrame);
                        } else if (LayoutTurnoutView.this.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                            tools.setSignalsAtThroatToThroatTurnoutsFromMenu(LayoutTurnoutView.this.turnout, LayoutTurnoutView.this.getLinkedTurnoutName(), letbp.signalIconEditor, letbp.signalFrame);
                        } else if (LayoutTurnoutView.this.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) {
                            tools.setSignalsAt3WayTurnoutFromMenu(LayoutTurnoutView.this.getTurnoutName(), LayoutTurnoutView.this.getLinkedTurnoutName(), letbp.signalIconEditor, letbp.signalFrame);
                        } else if (LayoutTurnoutView.this.getLinkType() == LayoutTurnout.LinkType.SECOND_3_WAY) {
                            tools.setSignalsAt3WayTurnoutFromMenu(LayoutTurnoutView.this.getLinkedTurnoutName(), LayoutTurnoutView.this.getTurnoutName(), letbp.signalIconEditor, letbp.signalFrame);
                        }
                    }
                };
                JMenu jm = new JMenu(Bundle.getMessage("SignalHeads"));
                if (this.layoutEditor.getLETools().addLayoutTurnoutSignalHeadInfoToMenu(this.getTurnoutName(), this.getLinkedTurnoutName(), jm).booleanValue()) {
                    jm.add(ssaa);
                    this.popup.add(jm);
                } else {
                    this.popup.add(ssaa);
                }
            }
            if (!this.getBlockName().isEmpty()) {
                final String[] boundaryBetween = this.getBlockBoundaries();
                boolean blockBoundaries = false;
                int i = 0;
                while (i < 4) {
                    if (boundaryBetween[i] != null) {
                        blockBoundaries = true;
                    }
                    ++i;
                }
                if (blockBoundaries) {
                    this.popup.add(new AbstractAction(Bundle.getMessage("SetSignalMasts")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutTurnoutView.this.layoutEditor.getLETools().setSignalMastsAtTurnoutFromMenu(LayoutTurnoutView.this.turnout, boundaryBetween);
                        }
                    });
                    this.popup.add(new AbstractAction(Bundle.getMessage("SetSensors")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LayoutEditorToolBarPanel letbp = LayoutTurnoutView.this.getLayoutEditorToolBarPanel();
                            LayoutTurnoutView.this.layoutEditor.getLETools().setSensorsAtTurnoutFromMenu(LayoutTurnoutView.this.turnout, boundaryBetween, letbp.sensorIconEditor, letbp.sensorFrame);
                        }
                    });
                }
                if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                    HashMap<String, LayoutBlock> map = new HashMap<String, LayoutBlock>();
                    if (!this.getBlockName().isEmpty()) {
                        map.put(this.getBlockName(), this.getLayoutBlock());
                    }
                    if (!this.getBlockBName().isEmpty()) {
                        map.put(this.getBlockBName(), this.getLayoutBlockB());
                    }
                    if (!this.getBlockCName().isEmpty()) {
                        map.put(this.getBlockCName(), this.getLayoutBlockC());
                    }
                    if (!this.getBlockDName().isEmpty()) {
                        map.put(this.getBlockDName(), this.getLayoutBlockD());
                    }
                    if (blockBoundaries) {
                        if (map.size() == 1) {
                            this.popup.add(new AbstractAction(Bundle.getMessage("ViewBlockRouting")){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction("ViewRouting", LayoutTurnoutView.this.getLayoutBlock());
                                    routeTableAction.actionPerformed(e);
                                }
                            });
                        } else if (map.size() > 1) {
                            JMenu viewRouting = new JMenu(Bundle.getMessage("ViewBlockRouting"));
                            for (Map.Entry entry : map.entrySet()) {
                                String blockName = (String)entry.getKey();
                                LayoutBlock layoutBlock = (LayoutBlock)entry.getValue();
                                viewRouting.add(new AbstractActionImpl(blockName, this.getBlockBName(), layoutBlock));
                            }
                            this.popup.add(viewRouting);
                        }
                    }
                }
            }
            this.setAdditionalEditPopUpMenu(this.popup);
            this.layoutEditor.setShowAlignmentMenu(this.popup);
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (!this.viewAdditionalMenu.isEmpty()) {
            this.setAdditionalViewPopUpMenu(this.popup);
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        return this.popup;
    }

    public String[] getBlockBoundaries() {
        return this.turnout.getBlockBoundaries();
    }

    public ArrayList<LayoutBlock> getProtectedBlocks(NamedBean bean) {
        return this.turnout.getProtectedBlocks(bean);
    }

    protected void removeSML(SignalMast signalMast) {
        this.turnout.removeSML(signalMast);
    }

    public void dispose() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
        this.popup = null;
    }

    public void remove() {
        this.turnout.remove();
    }

    public boolean isActive() {
        return this.turnout.isActive();
    }

    public void addEditPopUpMenu(JMenuItem menu) {
        if (!this.editAdditionalMenu.contains(menu)) {
            this.editAdditionalMenu.add(menu);
        }
    }

    public void addViewPopUpMenu(JMenuItem menu) {
        if (!this.viewAdditionalMenu.contains(menu)) {
            this.viewAdditionalMenu.add(menu);
        }
    }

    public void setAdditionalEditPopUpMenu(JPopupMenu popup) {
        if (this.editAdditionalMenu.isEmpty()) {
            return;
        }
        popup.addSeparator();
        for (JMenuItem mi : this.editAdditionalMenu) {
            popup.add(mi);
        }
    }

    public void setAdditionalViewPopUpMenu(JPopupMenu popup) {
        if (this.viewAdditionalMenu.isEmpty()) {
            return;
        }
        popup.addSeparator();
        for (JMenuItem mi : this.viewAdditionalMenu) {
            popup.add(mi);
        }
    }

    @Override
    protected void drawDecorations(Graphics2D g2) {
    }

    @Override
    protected void draw1(Graphics2D g2, boolean isMain, boolean isBlock) {
        LayoutTurnout.TurnoutType type;
        Color color;
        if (isBlock && this.getLayoutBlock() == null) {
            return;
        }
        Point2D pA = this.getCoordsA();
        Point2D pB = this.getCoordsB();
        Point2D pC = this.getCoordsC();
        Point2D pD = this.getCoordsD();
        boolean mainlineA = this.isMainlineA();
        boolean mainlineB = this.isMainlineB();
        boolean mainlineC = this.isMainlineC();
        boolean mainlineD = this.isMainlineD();
        boolean drawUnselectedLeg = this.layoutEditor.isTurnoutDrawUnselectedLeg();
        Color colorA = color = g2.getColor();
        Color colorB = color;
        Color colorC = color;
        Color colorD = color;
        if (isBlock) {
            LayoutBlock lb = this.getLayoutBlock();
            colorA = lb == null ? color : lb.getBlockColor();
            lb = this.getLayoutBlockB();
            colorB = lb == null ? color : lb.getBlockColor();
            lb = this.getLayoutBlockC();
            colorC = lb == null ? color : lb.getBlockColor();
            lb = this.getLayoutBlockD();
            colorD = lb == null ? color : lb.getBlockColor();
        }
        Point2D pM = this.getCoordsCenter();
        Point2D pABM = MathUtil.midPoint(pA, pB);
        Point2D pAM = MathUtil.lerp(pA, pABM, 0.625);
        Point2D pAMP = MathUtil.midPoint(pAM, pABM);
        Point2D pBM = MathUtil.lerp(pB, pABM, 0.625);
        Point2D pBMP = MathUtil.midPoint(pBM, pABM);
        Point2D pCDM = MathUtil.midPoint(pC, pD);
        Point2D pCM = MathUtil.lerp(pC, pCDM, 0.625);
        Point2D pCMP = MathUtil.midPoint(pCM, pCDM);
        Point2D pDM = MathUtil.lerp(pD, pCDM, 0.625);
        Point2D pDMP = MathUtil.midPoint(pDM, pCDM);
        Point2D pAF = MathUtil.midPoint(pAM, pM);
        Point2D pBF = MathUtil.midPoint(pBM, pM);
        Point2D pCF = MathUtil.midPoint(pCM, pM);
        Point2D pDF = MathUtil.midPoint(pDM, pM);
        int state = 1;
        if (this.layoutEditor.isAnimating()) {
            state = this.getState();
        }
        if ((type = this.getTurnoutType()) == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
            if (state != 4 && state != 8) {
                if (isMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, pABM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pAF, pM));
                    }
                }
                if (isMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, pABM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pBF, pM));
                    }
                }
                if (isMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(pC, pCDM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pCF, pM));
                    }
                }
                if (isMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(pD, pCDM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pDF, pM));
                    }
                }
            }
            if (state != 2 && state != 8) {
                if (isMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, pAM));
                    g2.draw(new Line2D.Double(pAM, pM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pAMP, pABM));
                    }
                }
                if (isMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, pBM));
                    g2.draw(new Line2D.Double(pBM, pM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pBMP, pABM));
                    }
                }
                if (isMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(pC, pCM));
                    g2.draw(new Line2D.Double(pCM, pM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pCMP, pCDM));
                    }
                }
                if (isMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(pD, pDM));
                    g2.draw(new Line2D.Double(pDM, pM));
                    if (!isBlock || drawUnselectedLeg) {
                        g2.draw(new Line2D.Double(pDMP, pCDM));
                    }
                }
            }
            if (state == 8) {
                if (isMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, pAM));
                }
                if (isMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, pBM));
                }
                if (isMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(pC, pCM));
                }
                if (isMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(pD, pDM));
                }
                if (!isBlock || drawUnselectedLeg) {
                    if (isMain == mainlineA) {
                        g2.setColor(colorA);
                        g2.draw(new Line2D.Double(pAF, pM));
                    }
                    if (isMain == mainlineC) {
                        g2.setColor(colorC);
                        g2.draw(new Line2D.Double(pCF, pM));
                    }
                    if (isMain == mainlineB) {
                        g2.setColor(colorB);
                        g2.draw(new Line2D.Double(pBF, pM));
                    }
                    if (isMain == mainlineD) {
                        g2.setColor(colorD);
                        g2.draw(new Line2D.Double(pDF, pM));
                    }
                }
            }
        } else if (type == LayoutTurnout.TurnoutType.RH_XOVER || type == LayoutTurnout.TurnoutType.LH_XOVER) {
            pAF = MathUtil.midPoint(pABM, pM);
            pBF = MathUtil.midPoint(pABM, pM);
            pCF = MathUtil.midPoint(pCDM, pM);
            pDF = MathUtil.midPoint(pCDM, pM);
            if (state != 4 && state != 8) {
                if (isMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, pABM));
                }
                if (isMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pABM, pB));
                }
                if (isMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(pC, pCDM));
                }
                if (isMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(pCDM, pD));
                }
                if (!isBlock || drawUnselectedLeg) {
                    if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                        if (isMain == mainlineA) {
                            g2.setColor(colorA);
                            g2.draw(new Line2D.Double(pAF, pM));
                        }
                        if (isMain == mainlineC) {
                            g2.setColor(colorC);
                            g2.draw(new Line2D.Double(pCF, pM));
                        }
                    } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                        if (isMain == mainlineB) {
                            g2.setColor(colorB);
                            g2.draw(new Line2D.Double(pBF, pM));
                        }
                        if (isMain == mainlineD) {
                            g2.setColor(colorD);
                            g2.draw(new Line2D.Double(pDF, pM));
                        }
                    }
                }
            }
            if (state != 2 && state != 8) {
                if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                    if (isMain == mainlineA) {
                        g2.setColor(colorA);
                        g2.draw(new Line2D.Double(pA, pABM));
                        g2.draw(new Line2D.Double(pABM, pM));
                    }
                    if ((!isBlock || drawUnselectedLeg) && isMain == mainlineB) {
                        g2.setColor(colorB);
                        g2.draw(new Line2D.Double(pBM, pB));
                    }
                    if (isMain == mainlineC) {
                        g2.setColor(colorC);
                        g2.draw(new Line2D.Double(pC, pCDM));
                        g2.draw(new Line2D.Double(pCDM, pM));
                    }
                    if ((!isBlock || drawUnselectedLeg) && isMain == mainlineD) {
                        g2.setColor(colorD);
                        g2.draw(new Line2D.Double(pDM, pD));
                    }
                } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                    if ((!isBlock || drawUnselectedLeg) && isMain == mainlineA) {
                        g2.setColor(colorA);
                        g2.draw(new Line2D.Double(pA, pAM));
                    }
                    if (isMain == mainlineB) {
                        g2.setColor(colorB);
                        g2.draw(new Line2D.Double(pB, pABM));
                        g2.draw(new Line2D.Double(pABM, pM));
                    }
                    if ((!isBlock || drawUnselectedLeg) && isMain == mainlineC) {
                        g2.setColor(colorC);
                        g2.draw(new Line2D.Double(pC, pCM));
                    }
                    if (isMain == mainlineD) {
                        g2.setColor(colorD);
                        g2.draw(new Line2D.Double(pD, pCDM));
                        g2.draw(new Line2D.Double(pCDM, pM));
                    }
                }
            }
            if (state == 8) {
                if (isMain == mainlineA) {
                    g2.setColor(colorA);
                    g2.draw(new Line2D.Double(pA, pAM));
                }
                if (isMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pB, pBM));
                }
                if (isMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(pC, pCM));
                }
                if (isMain == mainlineD) {
                    g2.setColor(colorD);
                    g2.draw(new Line2D.Double(pD, pDM));
                }
                if (!isBlock || drawUnselectedLeg) {
                    if (this.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                        if (isMain == mainlineA) {
                            g2.setColor(colorA);
                            g2.draw(new Line2D.Double(pAF, pM));
                        }
                        if (isMain == mainlineC) {
                            g2.setColor(colorC);
                            g2.draw(new Line2D.Double(pCF, pM));
                        }
                    } else if (this.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                        if (isMain == mainlineB) {
                            g2.setColor(colorB);
                            g2.draw(new Line2D.Double(pBF, pM));
                        }
                        if (isMain == mainlineD) {
                            g2.setColor(colorD);
                            g2.draw(new Line2D.Double(pDF, pM));
                        }
                    }
                }
            }
        } else if (this.isTurnoutTypeSlip()) {
            log.error("{}.draw1(...); slips should be being drawn by LayoutSlip sub-class", (Object)this.getName());
        } else {
            if (isMain == mainlineA) {
                g2.setColor(colorA);
                g2.draw(new Line2D.Double(pA, pM));
            }
            if (state == 1 || this.getContinuingSense() == state && state != 8) {
                if (isMain == mainlineB) {
                    g2.setColor(colorB);
                    g2.draw(new Line2D.Double(pM, pB));
                }
            } else if ((!isBlock || drawUnselectedLeg) && isMain == mainlineB) {
                g2.setColor(colorB);
                g2.draw(new Line2D.Double(MathUtil.twoThirdsPoint(pM, pB), pB));
            }
            if (state == 1 || this.getContinuingSense() != state && state != 8) {
                if (isMain == mainlineC) {
                    g2.setColor(colorC);
                    g2.draw(new Line2D.Double(pM, pC));
                }
            } else if ((!isBlock || drawUnselectedLeg) && isMain == mainlineC) {
                g2.setColor(colorC);
                g2.draw(new Line2D.Double(MathUtil.twoThirdsPoint(pM, pC), pC));
            }
        }
    }

    @Override
    protected void draw2(Graphics2D g2, boolean isMain, float railDisplacement) {
        LayoutTurnout.TurnoutType type = this.getTurnoutType();
        Point2D pA = this.getCoordsA();
        Point2D pB = this.getCoordsB();
        Point2D pC = this.getCoordsC();
        Point2D pD = this.getCoordsD();
        Point2D pM = this.getCoordsCenter();
        Point2D vAM = MathUtil.normalize(MathUtil.subtract(pM, pA));
        Point2D vAMo = MathUtil.orthogonal(MathUtil.normalize(vAM, railDisplacement));
        Point2D pAL = MathUtil.subtract(pA, vAMo);
        Point2D pAR = MathUtil.add(pA, vAMo);
        Point2D vBM = MathUtil.normalize(MathUtil.subtract(pB, pM));
        double dirBM_DEG = MathUtil.computeAngleDEG(vBM);
        Point2D vBMo = MathUtil.normalize(MathUtil.orthogonal(vBM), railDisplacement);
        Point2D pBL = MathUtil.subtract(pB, vBMo);
        Point2D pBR = MathUtil.add(pB, vBMo);
        Point2D pMR = MathUtil.add(pM, vBMo);
        Point2D vCM = MathUtil.normalize(MathUtil.subtract(pC, pM));
        double dirCM_DEG = MathUtil.computeAngleDEG(vCM);
        Point2D vCMo = MathUtil.normalize(MathUtil.orthogonal(vCM), railDisplacement);
        Point2D pCL = MathUtil.subtract(pC, vCMo);
        Point2D pCR = MathUtil.add(pC, vCMo);
        Point2D pML = MathUtil.subtract(pM, vBMo);
        double deltaBMC_DEG = MathUtil.absDiffAngleDEG(dirBM_DEG, dirCM_DEG);
        double deltaBMC_RAD = Math.toRadians(deltaBMC_DEG);
        double hypotF = (double)railDisplacement / Math.sin(deltaBMC_RAD / 2.0);
        Point2D vDisF = MathUtil.normalize(MathUtil.add(vAM, vCM), hypotF);
        if (type == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            vDisF = MathUtil.normalize(vAM, hypotF);
        }
        Point2D pF = MathUtil.add(pM, vDisF);
        Point2D pFR = MathUtil.add(pF, MathUtil.multiply(vBMo, 2.0));
        Point2D pFL = MathUtil.subtract(pF, MathUtil.multiply(vCMo, 2.0));
        Point2D vDisAP = MathUtil.normalize(vAM, hypotF);
        Point2D pAP = MathUtil.subtract(pM, vDisAP);
        Point2D pAPR = MathUtil.add(pAP, vAMo);
        Point2D pAPL = MathUtil.subtract(pAP, vAMo);
        boolean mainlineA = this.isMainlineA();
        boolean mainlineB = this.isMainlineB();
        boolean mainlineC = this.isMainlineC();
        boolean mainlineD = this.isMainlineD();
        int state = 1;
        if (this.layoutEditor.isAnimating()) {
            state = this.getState();
        }
        switch (type) {
            case RH_TURNOUT: {
                if (isMain == mainlineA) {
                    g2.draw(new Line2D.Double(pAL, pML));
                    g2.draw(new Line2D.Double(pAR, pAPR));
                }
                if (isMain == mainlineB) {
                    g2.draw(new Line2D.Double(pML, pBL));
                    g2.draw(new Line2D.Double(pF, pBR));
                    if (this.getContinuingSense() == state) {
                        g2.draw(new Line2D.Double(pAPR, pF));
                    }
                }
                if (isMain != mainlineC) break;
                g2.draw(new Line2D.Double(pF, pCL));
                g2.draw(new Line2D.Double(pFR, pCR));
                GeneralPath path = new GeneralPath();
                path.moveTo(pAPR.getX(), pAPR.getY());
                path.quadTo(pMR.getX(), pMR.getY(), pFR.getX(), pFR.getY());
                path.lineTo(pCR.getX(), pCR.getY());
                g2.draw(path);
                if (this.getContinuingSense() == state) break;
                path = new GeneralPath();
                path.moveTo(pAPL.getX(), pAPL.getY());
                path.quadTo(pML.getX(), pML.getY(), pF.getX(), pF.getY());
                g2.draw(path);
                break;
            }
            case LH_TURNOUT: {
                if (isMain == mainlineA) {
                    g2.draw(new Line2D.Double(pAR, pMR));
                    g2.draw(new Line2D.Double(pAL, pAPL));
                }
                if (isMain == mainlineB) {
                    g2.draw(new Line2D.Double(pMR, pBR));
                    g2.draw(new Line2D.Double(pF, pBL));
                    if (this.getContinuingSense() == state) {
                        g2.draw(new Line2D.Double(pAPL, pF));
                    }
                }
                if (isMain != mainlineC) break;
                g2.draw(new Line2D.Double(pF, pCR));
                GeneralPath path = new GeneralPath();
                path.moveTo(pAPL.getX(), pAPL.getY());
                path.quadTo(pML.getX(), pML.getY(), pFL.getX(), pFL.getY());
                path.lineTo(pCL.getX(), pCL.getY());
                g2.draw(path);
                if (this.getContinuingSense() == state) break;
                path = new GeneralPath();
                path.moveTo(pAPR.getX(), pAPR.getY());
                path.quadTo(pMR.getX(), pMR.getY(), pF.getX(), pF.getY());
                g2.draw(path);
                break;
            }
            case WYE_TURNOUT: {
                GeneralPath path;
                if (isMain == mainlineA) {
                    g2.draw(new Line2D.Double(pAL, pAPL));
                    g2.draw(new Line2D.Double(pAR, pAPR));
                }
                if (isMain == mainlineB) {
                    g2.draw(new Line2D.Double(pF, pBL));
                    path = new GeneralPath();
                    path.moveTo(pAPR.getX(), pAPR.getY());
                    path.quadTo(pMR.getX(), pMR.getY(), pFR.getX(), pFR.getY());
                    path.lineTo(pBR.getX(), pBR.getY());
                    g2.draw(path);
                    if (this.getContinuingSense() != state) {
                        path = new GeneralPath();
                        path.moveTo(pAPR.getX(), pAPR.getY());
                        path.quadTo(pMR.getX(), pMR.getY(), pF.getX(), pF.getY());
                        g2.draw(path);
                    }
                }
                if (isMain != mainlineC) break;
                pML = MathUtil.subtract(pM, vCMo);
                path = new GeneralPath();
                path.moveTo(pAPL.getX(), pAPL.getY());
                path.quadTo(pML.getX(), pML.getY(), pFL.getX(), pFL.getY());
                path.lineTo(pCL.getX(), pCL.getY());
                g2.draw(path);
                g2.draw(new Line2D.Double(pF, pCR));
                if (this.getContinuingSense() != state) break;
                path = new GeneralPath();
                path.moveTo(pAPL.getX(), pAPL.getY());
                path.quadTo(pML.getX(), pML.getY(), pF.getX(), pF.getY());
                g2.draw(path);
                break;
            }
            case DOUBLE_XOVER: {
                GeneralPath path;
                Point2D vAB = MathUtil.normalize(MathUtil.subtract(pB, pA), railDisplacement);
                double dirAB_DEG = MathUtil.computeAngleDEG(vAB);
                Point2D vABo = MathUtil.orthogonal(MathUtil.normalize(vAB, railDisplacement));
                pAL = MathUtil.subtract(pA, vABo);
                pAR = MathUtil.add(pA, vABo);
                pBL = MathUtil.subtract(pB, vABo);
                pBR = MathUtil.add(pB, vABo);
                Point2D vCD = MathUtil.normalize(MathUtil.subtract(pD, pC), railDisplacement);
                Point2D vCDo = MathUtil.orthogonal(MathUtil.normalize(vCD, railDisplacement));
                pCL = MathUtil.add(pC, vCDo);
                pCR = MathUtil.subtract(pC, vCDo);
                Point2D pDL = MathUtil.add(pD, vCDo);
                Point2D pDR = MathUtil.subtract(pD, vCDo);
                Point2D pABM = MathUtil.midPoint(pA, pB);
                Point2D pABL = MathUtil.midPoint(pAL, pBL);
                Point2D pABR = MathUtil.midPoint(pAR, pBR);
                Point2D pCDM = MathUtil.midPoint(pC, pD);
                Point2D pCDL = MathUtil.midPoint(pCL, pDL);
                Point2D pCDR = MathUtil.midPoint(pCR, pDR);
                double halfParallelDistance = MathUtil.distance(pABM, pCDM) / 2.0;
                Point2D pAM = MathUtil.subtract(pABM, MathUtil.normalize(vAB, halfParallelDistance));
                Point2D pAML = MathUtil.subtract(pAM, vABo);
                Point2D pAMR = MathUtil.add(pAM, vABo);
                Point2D pBM = MathUtil.add(pABM, MathUtil.normalize(vAB, halfParallelDistance));
                Point2D pBML = MathUtil.subtract(pBM, vABo);
                Point2D pBMR = MathUtil.add(pBM, vABo);
                Point2D pCM = MathUtil.subtract(pCDM, MathUtil.normalize(vCD, halfParallelDistance));
                Point2D pCML = MathUtil.subtract(pCM, vABo);
                Point2D pCMR = MathUtil.add(pCM, vABo);
                Point2D pDM = MathUtil.add(pCDM, MathUtil.normalize(vCD, halfParallelDistance));
                Point2D pDML = MathUtil.subtract(pDM, vABo);
                Point2D pDMR = MathUtil.add(pDM, vABo);
                Point2D vACM = MathUtil.normalize(MathUtil.subtract(pCM, pAM), railDisplacement);
                Point2D vACMo = MathUtil.orthogonal(vACM);
                Point2D vBDM = MathUtil.normalize(MathUtil.subtract(pDM, pBM), railDisplacement);
                Point2D vBDMo = MathUtil.orthogonal(vBDM);
                Point2D pBDR = MathUtil.add(pM, vACM);
                Point2D pBDL = MathUtil.subtract(pM, vACM);
                Point2D pVR = MathUtil.add(pBDL, vBDM);
                Point2D pKL = MathUtil.subtract(pBDL, vBDM);
                Point2D pKR = MathUtil.add(pBDR, vBDM);
                Point2D pVL = MathUtil.subtract(pBDR, vBDM);
                Point2D vACM2 = MathUtil.normalize(vACM, 2.0);
                Point2D vBDM2 = MathUtil.normalize(vBDM, 2.0);
                Point2D pKLtC = MathUtil.add(pKL, vACM2);
                Point2D pKLtD = MathUtil.add(pKL, vBDM2);
                Point2D pVLtA = MathUtil.subtract(pVL, vACM2);
                Point2D pVLtD = MathUtil.add(pVL, vBDM2);
                Point2D pKRtA = MathUtil.subtract(pKR, vACM2);
                Point2D pKRtB = MathUtil.subtract(pKR, vBDM2);
                Point2D pVRtB = MathUtil.subtract(pVR, vBDM2);
                Point2D pVRtC = MathUtil.add(pVR, vACM2);
                vCM = MathUtil.normalize(MathUtil.subtract(pCM, pM));
                dirCM_DEG = MathUtil.computeAngleDEG(vCM);
                double deltaBAC_DEG = MathUtil.absDiffAngleDEG(dirAB_DEG, dirCM_DEG);
                double deltaBAC_RAD = Math.toRadians(deltaBAC_DEG);
                hypotF = (double)railDisplacement / Math.sin(deltaBAC_RAD / 2.0);
                Point2D vACF = MathUtil.normalize(MathUtil.add(vACM, vAB), hypotF);
                Point2D pAFL = MathUtil.add(pAM, vACF);
                Point2D pCFR = MathUtil.subtract(pCM, vACF);
                Point2D vBDF = MathUtil.normalize(MathUtil.add(vBDM, vCD), hypotF);
                Point2D pBFL = MathUtil.add(pBM, vBDF);
                Point2D pDFR = MathUtil.subtract(pDM, vBDF);
                Point2D pAFR = MathUtil.add(MathUtil.add(pAFL, vACMo), vACMo);
                Point2D pBFR = MathUtil.subtract(MathUtil.subtract(pBFL, vBDMo), vBDMo);
                Point2D pCFL = MathUtil.subtract(MathUtil.subtract(pCFR, vACMo), vACMo);
                Point2D pDFL = MathUtil.add(MathUtil.add(pDFR, vBDMo), vBDMo);
                Point2D vABF = MathUtil.normalize(vAB, hypotF);
                pAP = MathUtil.subtract(pAM, vABF);
                pAPL = MathUtil.subtract(pAP, vABo);
                pAPR = MathUtil.add(pAP, vABo);
                Point2D pBP = MathUtil.add(pBM, vABF);
                Point2D pBPL = MathUtil.subtract(pBP, vABo);
                Point2D pBPR = MathUtil.add(pBP, vABo);
                Point2D vCDF = MathUtil.normalize(vCD, hypotF);
                Point2D pCP = MathUtil.subtract(pCM, vCDF);
                Point2D pCPL = MathUtil.add(pCP, vCDo);
                Point2D pCPR = MathUtil.subtract(pCP, vCDo);
                Point2D pDP = MathUtil.add(pDM, vCDF);
                Point2D pDPL = MathUtil.add(pDP, vCDo);
                Point2D pDPR = MathUtil.subtract(pDP, vCDo);
                Point2D vS = MathUtil.normalize(vABo, 2.0);
                Point2D pASL = MathUtil.add(pAPL, vS);
                Point2D pBSL = MathUtil.add(pBPL, vS);
                Point2D pCSR = MathUtil.subtract(pCPR, vS);
                Point2D pDSR = MathUtil.subtract(pDPR, vS);
                Point2D pAFS = MathUtil.subtract(pAFL, vS);
                Point2D pBFS = MathUtil.subtract(pBFL, vS);
                Point2D pCFS = MathUtil.add(pCFR, vS);
                Point2D pDFS = MathUtil.add(pDFR, vS);
                if (isMain == mainlineA) {
                    g2.draw(new Line2D.Double(pAL, pABL));
                    g2.draw(new Line2D.Double(pVRtB, pKLtD));
                    g2.draw(new Line2D.Double(pAFL, pABR));
                    g2.draw(new Line2D.Double(pAFL, pKL));
                    path = new GeneralPath();
                    path.moveTo(pAR.getX(), pAR.getY());
                    path.lineTo(pAPR.getX(), pAPR.getY());
                    path.quadTo(pAMR.getX(), pAMR.getY(), pAFR.getX(), pAFR.getY());
                    path.lineTo(pVR.getX(), pVR.getY());
                    g2.draw(path);
                    if (state != 2) {
                        path = new GeneralPath();
                        path.moveTo(pAPL.getX(), pAPL.getY());
                        path.quadTo(pAML.getX(), pAML.getY(), pAFL.getX(), pAFL.getY());
                        g2.draw(path);
                    } else {
                        g2.draw(new Line2D.Double(pAPR, pAFL));
                        path = new GeneralPath();
                        path.moveTo(pASL.getX(), pASL.getY());
                        path.quadTo(pAML.getX(), pAML.getY(), pAFS.getX(), pAFS.getY());
                    }
                }
                if (isMain == mainlineB) {
                    g2.draw(new Line2D.Double(pABL, pBL));
                    g2.draw(new Line2D.Double(pKLtC, pVLtA));
                    g2.draw(new Line2D.Double(pBFL, pABR));
                    g2.draw(new Line2D.Double(pBFL, pKL));
                    path = new GeneralPath();
                    path.moveTo(pBR.getX(), pBR.getY());
                    path.lineTo(pBPR.getX(), pBPR.getY());
                    path.quadTo(pBMR.getX(), pBMR.getY(), pBFR.getX(), pBFR.getY());
                    path.lineTo(pVL.getX(), pVL.getY());
                    g2.draw(path);
                    if (state != 2) {
                        path = new GeneralPath();
                        path.moveTo(pBPL.getX(), pBPL.getY());
                        path.quadTo(pBML.getX(), pBML.getY(), pBFL.getX(), pBFL.getY());
                        g2.draw(path);
                    } else {
                        g2.draw(new Line2D.Double(pBPR, pBFL));
                        path = new GeneralPath();
                        path.moveTo(pBSL.getX(), pBSL.getY());
                        path.quadTo(pBML.getX(), pBML.getY(), pBFS.getX(), pBFS.getY());
                    }
                }
                if (isMain == mainlineC) {
                    g2.draw(new Line2D.Double(pCR, pCDR));
                    g2.draw(new Line2D.Double(pKRtB, pVLtD));
                    g2.draw(new Line2D.Double(pCFR, pCDL));
                    g2.draw(new Line2D.Double(pCFR, pKR));
                    path = new GeneralPath();
                    path.moveTo(pCL.getX(), pCL.getY());
                    path.lineTo(pCPL.getX(), pCPL.getY());
                    path.quadTo(pCML.getX(), pCML.getY(), pCFL.getX(), pCFL.getY());
                    path.lineTo(pVL.getX(), pVL.getY());
                    g2.draw(path);
                    if (state != 2) {
                        path = new GeneralPath();
                        path.moveTo(pCPR.getX(), pCPR.getY());
                        path.quadTo(pCMR.getX(), pCMR.getY(), pCFR.getX(), pCFR.getY());
                        g2.draw(path);
                    } else {
                        g2.draw(new Line2D.Double(pCPL, pCFR));
                        path = new GeneralPath();
                        path.moveTo(pCSR.getX(), pCSR.getY());
                        path.quadTo(pCMR.getX(), pCMR.getY(), pCFS.getX(), pCFS.getY());
                    }
                }
                if (isMain != mainlineD) break;
                g2.draw(new Line2D.Double(pCDR, pDR));
                g2.draw(new Line2D.Double(pKRtA, pVRtC));
                g2.draw(new Line2D.Double(pDFR, pCDL));
                g2.draw(new Line2D.Double(pDFR, pKR));
                path = new GeneralPath();
                path.moveTo(pDL.getX(), pDL.getY());
                path.lineTo(pDPL.getX(), pDPL.getY());
                path.quadTo(pDML.getX(), pDML.getY(), pDFL.getX(), pDFL.getY());
                path.lineTo(pVR.getX(), pVR.getY());
                g2.draw(path);
                if (state != 2) {
                    path = new GeneralPath();
                    path.moveTo(pDPR.getX(), pDPR.getY());
                    path.quadTo(pDMR.getX(), pDMR.getY(), pDFR.getX(), pDFR.getY());
                    g2.draw(path);
                    break;
                }
                g2.draw(new Line2D.Double(pDPL, pDFR));
                path = new GeneralPath();
                path.moveTo(pDSR.getX(), pDSR.getY());
                path.quadTo(pDMR.getX(), pDMR.getY(), pDFS.getX(), pDFS.getY());
                break;
            }
            case RH_XOVER: {
                GeneralPath path;
                Point2D vAB = MathUtil.normalize(MathUtil.subtract(pB, pA), railDisplacement);
                double dirAB_DEG = MathUtil.computeAngleDEG(vAB);
                Point2D vABo = MathUtil.orthogonal(MathUtil.normalize(vAB, railDisplacement));
                pAL = MathUtil.subtract(pA, vABo);
                pAR = MathUtil.add(pA, vABo);
                pBL = MathUtil.subtract(pB, vABo);
                pBR = MathUtil.add(pB, vABo);
                Point2D vCD = MathUtil.normalize(MathUtil.subtract(pD, pC), railDisplacement);
                Point2D vCDo = MathUtil.orthogonal(MathUtil.normalize(vCD, railDisplacement));
                pCL = MathUtil.add(pC, vCDo);
                pCR = MathUtil.subtract(pC, vCDo);
                Point2D pDL = MathUtil.add(pD, vCDo);
                Point2D pDR = MathUtil.subtract(pD, vCDo);
                Point2D pABM = MathUtil.midPoint(pA, pB);
                Point2D pABL = MathUtil.subtract(pABM, vABo);
                Point2D pABR = MathUtil.add(pABM, vABo);
                Point2D pCDM = MathUtil.midPoint(pC, pD);
                Point2D pCDL = MathUtil.subtract(pCDM, vABo);
                Point2D pCDR = MathUtil.add(pCDM, vABo);
                Point2D vAC = MathUtil.normalize(MathUtil.subtract(pCDM, pABM), railDisplacement);
                Point2D vACo = MathUtil.orthogonal(MathUtil.normalize(vAC, railDisplacement));
                double dirAC_DEG = MathUtil.computeAngleDEG(vAC);
                double deltaBAC_DEG = MathUtil.absDiffAngleDEG(dirAB_DEG, dirAC_DEG);
                double deltaBAC_RAD = Math.toRadians(deltaBAC_DEG);
                Point2D pACL = MathUtil.subtract(pM, vACo);
                Point2D pACR = MathUtil.add(pM, vACo);
                hypotF = (double)railDisplacement / Math.sin(deltaBAC_RAD / 2.0);
                Point2D vF = MathUtil.normalize(MathUtil.add(vAB, vAC), hypotF);
                Point2D pABF = MathUtil.add(pABM, vF);
                Point2D pCDF = MathUtil.subtract(pCDM, vF);
                Point2D pABFP = MathUtil.add(MathUtil.add(pABF, vACo), vACo);
                Point2D pCDFP = MathUtil.subtract(MathUtil.subtract(pCDF, vACo), vACo);
                Point2D vABF = MathUtil.normalize(vAB, hypotF);
                pAP = MathUtil.subtract(pABM, vABF);
                pAPL = MathUtil.subtract(pAP, vABo);
                pAPR = MathUtil.add(pAP, vABo);
                Point2D pCP = MathUtil.add(pCDM, vABF);
                Point2D pCPL = MathUtil.add(pCP, vCDo);
                Point2D pCPR = MathUtil.subtract(pCP, vCDo);
                Point2D vS = MathUtil.normalize(vAB, 2.0);
                Point2D vSo = MathUtil.orthogonal(vS);
                Point2D pASL = MathUtil.add(pAPL, vSo);
                Point2D pCSR = MathUtil.subtract(pCPR, vSo);
                Point2D pABFS = MathUtil.subtract(pABF, vSo);
                Point2D pCDFS = MathUtil.add(pCDF, vSo);
                if (isMain == mainlineA) {
                    g2.draw(new Line2D.Double(pAL, pABL));
                    path = new GeneralPath();
                    path.moveTo(pAR.getX(), pAR.getY());
                    path.lineTo(pAPR.getX(), pAPR.getY());
                    path.quadTo(pABR.getX(), pABR.getY(), pABFP.getX(), pABFP.getY());
                    path.lineTo(pACR.getX(), pACR.getY());
                    g2.draw(path);
                    g2.draw(new Line2D.Double(pABF, pACL));
                    if (state != 2) {
                        path = new GeneralPath();
                        path.moveTo(pAPL.getX(), pAPL.getY());
                        path.quadTo(pABL.getX(), pABL.getY(), pABF.getX(), pABF.getY());
                        g2.draw(path);
                    } else {
                        g2.draw(new Line2D.Double(pAPR, pABF));
                        path = new GeneralPath();
                        path.moveTo(pASL.getX(), pASL.getY());
                        path.quadTo(pABL.getX(), pABL.getY(), pABFS.getX(), pABFS.getY());
                    }
                }
                if (isMain == mainlineB) {
                    g2.draw(new Line2D.Double(pABL, pBL));
                    g2.draw(new Line2D.Double(pABF, pBR));
                }
                if (isMain == mainlineC) {
                    g2.draw(new Line2D.Double(pCR, pCDR));
                    path = new GeneralPath();
                    path.moveTo(pCL.getX(), pCL.getY());
                    path.lineTo(pCPL.getX(), pCPL.getY());
                    path.quadTo(pCDL.getX(), pCDL.getY(), pCDFP.getX(), pCDFP.getY());
                    path.lineTo(pACL.getX(), pACL.getY());
                    g2.draw(path);
                    g2.draw(new Line2D.Double(pCDF, pACR));
                    if (state != 2) {
                        path = new GeneralPath();
                        path.moveTo(pCPR.getX(), pCPR.getY());
                        path.quadTo(pCDR.getX(), pCDR.getY(), pCDF.getX(), pCDF.getY());
                        g2.draw(path);
                    } else {
                        g2.draw(new Line2D.Double(pCPL, pCDF));
                        path = new GeneralPath();
                        path.moveTo(pCSR.getX(), pCSR.getY());
                        path.quadTo(pCDR.getX(), pCDR.getY(), pCDFS.getX(), pCDFS.getY());
                    }
                }
                if (isMain != mainlineD) break;
                g2.draw(new Line2D.Double(pCDR, pDR));
                g2.draw(new Line2D.Double(pCDF, pDL));
                break;
            }
            case LH_XOVER: {
                GeneralPath path;
                Point2D vBA = MathUtil.normalize(MathUtil.subtract(pA, pB), railDisplacement);
                double dirBA_DEG = MathUtil.computeAngleDEG(vBA);
                Point2D vBAo = MathUtil.orthogonal(MathUtil.normalize(vBA, railDisplacement));
                pBL = MathUtil.add(pB, vBAo);
                pBR = MathUtil.subtract(pB, vBAo);
                pAL = MathUtil.add(pA, vBAo);
                pAR = MathUtil.subtract(pA, vBAo);
                Point2D vDC = MathUtil.normalize(MathUtil.subtract(pC, pD), railDisplacement);
                Point2D vDCo = MathUtil.orthogonal(MathUtil.normalize(vDC, railDisplacement));
                Point2D pDL = MathUtil.subtract(pD, vDCo);
                Point2D pDR = MathUtil.add(pD, vDCo);
                pCL = MathUtil.subtract(pC, vDCo);
                pCR = MathUtil.add(pC, vDCo);
                Point2D pBAM = MathUtil.midPoint(pB, pA);
                Point2D pBAL = MathUtil.add(pBAM, vBAo);
                Point2D pBAR = MathUtil.subtract(pBAM, vBAo);
                Point2D pDCM = MathUtil.midPoint(pD, pC);
                Point2D pDCL = MathUtil.add(pDCM, vBAo);
                Point2D pDCR = MathUtil.subtract(pDCM, vBAo);
                Point2D vBD = MathUtil.normalize(MathUtil.subtract(pDCM, pBAM), railDisplacement);
                Point2D vBDo = MathUtil.orthogonal(MathUtil.normalize(vBD, railDisplacement));
                double dirBD_DEG = MathUtil.computeAngleDEG(vBD);
                double deltaABD_DEG = MathUtil.absDiffAngleDEG(dirBA_DEG, dirBD_DEG);
                double deltaABD_RAD = Math.toRadians(deltaABD_DEG);
                Point2D pBDL = MathUtil.add(pM, vBDo);
                Point2D pBDR = MathUtil.subtract(pM, vBDo);
                hypotF = (double)railDisplacement / Math.sin(deltaABD_RAD / 2.0);
                Point2D vF = MathUtil.normalize(MathUtil.add(vBA, vBD), hypotF);
                Point2D pBFL = MathUtil.add(pBAM, vF);
                Point2D pBF = MathUtil.subtract(pBFL, vBDo);
                Point2D pBFR = MathUtil.subtract(pBF, vBDo);
                Point2D pDFR = MathUtil.subtract(pDCM, vF);
                Point2D pDF = MathUtil.add(pDFR, vBDo);
                Point2D pDFL = MathUtil.add(pDF, vBDo);
                Point2D vBAF = MathUtil.normalize(vBA, hypotF);
                Point2D pBP = MathUtil.subtract(pBAM, vBAF);
                Point2D pBPL = MathUtil.add(pBP, vBAo);
                Point2D pBPR = MathUtil.subtract(pBP, vBAo);
                Point2D pDP = MathUtil.add(pDCM, vBAF);
                Point2D pDPL = MathUtil.subtract(pDP, vDCo);
                Point2D pDPR = MathUtil.add(pDP, vDCo);
                Point2D vS = MathUtil.normalize(vBA, 2.0);
                Point2D vSo = MathUtil.orthogonal(vS);
                Point2D pBSL = MathUtil.subtract(pBPL, vSo);
                Point2D pDSR = MathUtil.add(pDPR, vSo);
                Point2D pBAFS = MathUtil.add(pBFL, vSo);
                Point2D pDCFS = MathUtil.subtract(pDFR, vSo);
                if (isMain == mainlineA) {
                    g2.draw(new Line2D.Double(pBAL, pAL));
                    g2.draw(new Line2D.Double(pBFL, pAR));
                }
                if (isMain == mainlineB) {
                    g2.draw(new Line2D.Double(pBL, pBAL));
                    path = new GeneralPath();
                    path.moveTo(pBR.getX(), pBR.getY());
                    path.lineTo(pBPR.getX(), pBPR.getY());
                    path.quadTo(pBAR.getX(), pBAR.getY(), pBFR.getX(), pBFR.getY());
                    path.lineTo(pBDR.getX(), pBDR.getY());
                    g2.draw(path);
                    g2.draw(new Line2D.Double(pBFL, pBDL));
                    if (state != 2) {
                        path = new GeneralPath();
                        path.moveTo(pBPL.getX(), pBPL.getY());
                        path.quadTo(pBAL.getX(), pBAL.getY(), pBFL.getX(), pBFL.getY());
                        g2.draw(path);
                    } else {
                        g2.draw(new Line2D.Double(pBPR, pBFL));
                        path = new GeneralPath();
                        path.moveTo(pBSL.getX(), pBSL.getY());
                        path.quadTo(pBAL.getX(), pBAL.getY(), pBAFS.getX(), pBAFS.getY());
                    }
                }
                if (isMain == mainlineC) {
                    g2.draw(new Line2D.Double(pDCR, pCR));
                    g2.draw(new Line2D.Double(pDFR, pCL));
                }
                if (isMain != mainlineD) break;
                g2.draw(new Line2D.Double(pDR, pDCR));
                path = new GeneralPath();
                path.moveTo(pDL.getX(), pDL.getY());
                path.lineTo(pDPL.getX(), pDPL.getY());
                path.quadTo(pDCL.getX(), pDCL.getY(), pDFL.getX(), pDFL.getY());
                path.lineTo(pBDL.getX(), pBDL.getY());
                g2.draw(path);
                g2.draw(new Line2D.Double(pDFR, pBDR));
                if (state != 2) {
                    path = new GeneralPath();
                    path.moveTo(pDPR.getX(), pDPR.getY());
                    path.quadTo(pDCR.getX(), pDCR.getY(), pDFR.getX(), pDFR.getY());
                    g2.draw(path);
                    break;
                }
                g2.draw(new Line2D.Double(pDPL, pDFR));
                path = new GeneralPath();
                path.moveTo(pDSR.getX(), pDSR.getY());
                path.quadTo(pDCR.getX(), pDCR.getY(), pDCFS.getX(), pDCFS.getY());
                break;
            }
            case SINGLE_SLIP: 
            case DOUBLE_SLIP: {
                log.error("{}.draw2(...); slips should be being drawn by LayoutSlip sub-class", (Object)this.getName());
                break;
            }
            default: {
                log.error("{}.draw2(...); Unknown turnout type {}", (Object)this.getName(), (Object)type);
            }
        }
    }

    @Override
    protected void highlightUnconnected(Graphics2D g2, HitPointType specificType) {
        if ((specificType == HitPointType.NONE || specificType == HitPointType.TURNOUT_A) && this.getConnectA() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsA()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.TURNOUT_B) && this.getConnectB() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsB()));
        }
        if ((specificType == HitPointType.NONE || specificType == HitPointType.TURNOUT_C) && this.getConnectC() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsC()));
        }
        if (this.isTurnoutTypeXover() && (specificType == HitPointType.NONE || specificType == HitPointType.TURNOUT_D) && this.getConnectD() == null) {
            g2.fill(this.trackControlCircleAt(this.getCoordsD()));
        }
    }

    @Override
    protected void drawTurnoutControls(Graphics2D g2) {
        if (!(this.isDisabled() || this.isDisabledWhenOccupied() && this.isOccupied())) {
            Color foregroundColor = g2.getColor();
            if (this.getState() != this.getContinuingSense()) {
                g2.setColor(g2.getBackground());
            }
            if (this.layoutEditor.isTurnoutFillControlCircles()) {
                g2.fill(this.trackControlCircleAt(this.getCoordsCenter()));
            } else {
                g2.draw(this.trackControlCircleAt(this.getCoordsCenter()));
            }
            if (this.getState() != this.getContinuingSense()) {
                g2.setColor(foregroundColor);
            }
        }
    }

    @Override
    protected void drawEditControls(Graphics2D g2) {
        Point2D pt = this.getCoordsA();
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            if (this.getConnectA() == null) {
                g2.setColor(Color.magenta);
            } else {
                g2.setColor(Color.blue);
            }
        } else if (this.getConnectA() == null) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.green);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(pt));
        pt = this.getCoordsB();
        if (this.getConnectB() == null) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.green);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(pt));
        pt = this.getCoordsC();
        if (this.getConnectC() == null) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(Color.green);
        }
        g2.draw(this.layoutEditor.layoutEditorControlRectAt(pt));
        if (this.isTurnoutTypeXover() || this.isTurnoutTypeSlip()) {
            pt = this.getCoordsD();
            if (this.getConnectD() == null) {
                g2.setColor(Color.red);
            } else {
                g2.setColor(Color.green);
            }
            g2.draw(this.layoutEditor.layoutEditorControlRectAt(pt));
        }
    }

    protected int getConnectivityStateForLayoutBlocks(LayoutBlock currLayoutBlock, LayoutBlock prevLayoutBlock, LayoutBlock nextLayoutBlock, boolean suppress) {
        return this.turnout.getConnectivityStateForLayoutBlocks(currLayoutBlock, prevLayoutBlock, nextLayoutBlock, suppress);
    }

    @Override
    public void reCheckBlockBoundary() {
        this.turnout.reCheckBlockBoundary();
    }

    @Override
    protected List<LayoutConnectivity> getLayoutConnectivity() {
        return this.turnout.getLayoutConnectivity();
    }

    @Override
    @Nonnull
    public List<HitPointType> checkForFreeConnections() {
        return this.turnout.checkForFreeConnections();
    }

    @Override
    public boolean checkForUnAssignedBlocks() {
        return this.turnout.checkForUnAssignedBlocks();
    }

    @Override
    public void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> blockNamesToTrackNameSetsMap) {
        this.turnout.checkForNonContiguousBlocks(blockNamesToTrackNameSetsMap);
    }

    @Override
    public void collectContiguousTracksNamesInBlockNamed(@Nonnull String blockName, @Nonnull Set<String> TrackNameSet) {
        this.turnout.collectContiguousTracksNamesInBlockNamed(blockName, TrackNameSet);
    }

    @Override
    public void setAllLayoutBlocks(LayoutBlock layoutBlock) {
        this.turnout.setAllLayoutBlocks(layoutBlock);
    }

    private static class AbstractActionImpl
    extends AbstractAction {
        private final String blockName;
        private final LayoutBlock layoutBlock;

        public AbstractActionImpl(String name, String blockName, LayoutBlock layoutBlock) {
            super(name);
            this.blockName = blockName;
            this.layoutBlock = layoutBlock;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayoutBlockRouteTableAction routeTableAction = new LayoutBlockRouteTableAction(this.blockName, this.layoutBlock);
            routeTableAction.actionPerformed(e);
        }
    }
}

