/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import jmri.JmriException;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.util.ColorUtil;
import jmri.util.FileUtil;
import jmri.util.MathUtil;

public abstract class LayoutTrackView {
    private final LayoutTrack layoutTrack;
    protected final LayoutEditor layoutEditor;
    private Point2D center = new Point2D.Double(50.0, 50.0);
    protected Map<String, String> decorations = null;
    protected static final int NUM_ARROW_TYPES = 6;
    private boolean hidden = false;

    public LayoutTrackView(@Nonnull LayoutTrack track, @Nonnull LayoutEditor layoutEditor) {
        this.layoutTrack = track;
        this.layoutEditor = layoutEditor;
    }

    public LayoutTrackView(@Nonnull LayoutTrack track, @Nonnull Point2D c, @Nonnull LayoutEditor layoutEditor) {
        this.layoutTrack = track;
        this.layoutEditor = layoutEditor;
        this.center = c;
    }

    @Nonnull
    public final String getId() {
        return this.layoutTrack.getId();
    }

    @Nonnull
    public final String getName() {
        return this.layoutTrack.getName();
    }

    protected final void setIdent(@Nonnull String ident) {
        this.layoutTrack.setIdent(ident);
    }

    public LayoutTrack getLayoutTrack() {
        return this.layoutTrack;
    }

    public Point2D getCoordsCenter() {
        return this.center;
    }

    public void setCoordsCenter(@Nonnull Point2D p) {
        this.center = p;
    }

    public boolean hasDecorations() {
        return false;
    }

    public Map<String, String> getDecorations() {
        return this.decorations;
    }

    public void setDecorations(Map<String, String> decorations) {
        this.decorations = decorations;
    }

    @Nonnull
    public final LayoutEditorToolBarPanel getLayoutEditorToolBarPanel() {
        return this.layoutEditor.getLayoutEditorToolBarPanel();
    }

    public final Ellipse2D trackEditControlCircleAt(@Nonnull Point2D inPoint) {
        return this.trackControlCircleAt(inPoint);
    }

    public final Ellipse2D trackControlCircleAt(@Nonnull Point2D inPoint) {
        return new Ellipse2D.Double(inPoint.getX() - this.layoutEditor.circleRadius, inPoint.getY() - this.layoutEditor.circleRadius, this.layoutEditor.circleDiameter, this.layoutEditor.circleDiameter);
    }

    public final Rectangle2D trackControlCircleRectAt(@Nonnull Point2D inPoint) {
        return new Rectangle2D.Double(inPoint.getX() - this.layoutEditor.circleRadius, inPoint.getY() - this.layoutEditor.circleRadius, this.layoutEditor.circleDiameter, this.layoutEditor.circleDiameter);
    }

    protected final Color getColorForTrackBlock(@CheckForNull LayoutBlock layoutBlock, boolean forceBlockTrackColor) {
        Color result = ColorUtil.CLEAR;
        if (layoutBlock != null) {
            result = forceBlockTrackColor ? layoutBlock.getBlockTrackColor() : layoutBlock.getBlockColor();
        }
        return result;
    }

    protected final Color getColorForTrackBlock(@CheckForNull LayoutBlock lb) {
        return this.getColorForTrackBlock(lb, false);
    }

    protected final Color setColorForTrackBlock(Graphics2D g2, @CheckForNull LayoutBlock layoutBlock, boolean forceBlockTrackColor) {
        Color result = this.getColorForTrackBlock(layoutBlock, forceBlockTrackColor);
        g2.setColor(result);
        return result;
    }

    protected final Color setColorForTrackBlock(Graphics2D g2, @CheckForNull LayoutBlock lb) {
        return this.setColorForTrackBlock(g2, lb, false);
    }

    protected abstract void draw1(Graphics2D var1, boolean var2, boolean var3);

    protected abstract void draw2(Graphics2D var1, boolean var2, float var3);

    protected final void drawHidden(Graphics2D g2) {
    }

    protected final void drawLayoutTrackText(Graphics2D g) {
        int x = (int)this.center.getX();
        int y = (int)this.center.getY();
        String name = this.getName();
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        g.drawString(name, x -= metrics.stringWidth(name) / 2, y += metrics.getHeight() / 2);
    }

    public JCheckBoxMenuItem loadArrowImageToJCBItem(int n, JMenu arrowsCountMenu) {
        ImageIcon imageIcon = new ImageIcon(FileUtil.findURL("program:resources/icons/decorations/ArrowStyle" + n + ".png"));
        JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(imageIcon);
        arrowsCountMenu.add(jcbmi);
        jcbmi.setToolTipText(Bundle.getMessage("DecorationStyleMenuToolTip"));
        return jcbmi;
    }

    protected abstract void highlightUnconnected(Graphics2D var1, HitPointType var2);

    protected final void highlightUnconnected(Graphics2D g2) {
        this.highlightUnconnected(g2, HitPointType.NONE);
    }

    protected abstract void drawEditControls(Graphics2D var1);

    protected abstract void drawTurnoutControls(Graphics2D var1);

    protected abstract void drawDecorations(Graphics2D var1);

    public final boolean isHidden() {
        return this.hidden;
    }

    public final void setHidden(boolean hide) {
        if (this.hidden != hide) {
            this.hidden = hide;
            if (this.layoutEditor != null) {
                this.layoutEditor.redrawPanel();
            }
        }
    }

    public final String getTurnoutStateString(int turnoutState) {
        String result = "";
        result = turnoutState == 2 ? Bundle.getMessage("TurnoutStateClosed") : (turnoutState == 4 ? Bundle.getMessage("TurnoutStateThrown") : Bundle.getMessage("BeanStateUnknown"));
        return result;
    }

    public abstract boolean canRemove();

    public final void displayRemoveWarningDialog(List<String> itemList, String typeKey) {
        itemList.sort(null);
        StringBuilder msg = new StringBuilder(Bundle.getMessage("MakeLabel", Bundle.getMessage("DeleteTrackItem", Bundle.getMessage(typeKey))));
        for (String item : itemList) {
            msg.append("\n    " + item);
        }
        JOptionPane.showMessageDialog(this.layoutEditor, msg.toString(), Bundle.getMessage("WarningTitle"), 2);
    }

    public abstract void scaleCoords(double var1, double var3);

    public abstract void translateCoords(double var1, double var3);

    public abstract void rotateCoords(double var1);

    protected final Point2D rotatePoint(@Nonnull Point2D p, double sineRot, double cosineRot) {
        double cX = this.center.getX();
        double cY = this.center.getY();
        double deltaX = p.getX() - cX;
        double deltaY = p.getY() - cY;
        double x = cX + cosineRot * deltaX - sineRot * deltaY;
        double y = cY + sineRot * deltaX + cosineRot * deltaY;
        return new Point2D.Double(x, y);
    }

    protected abstract HitPointType findHitPointType(@Nonnull Point2D var1, boolean var2, boolean var3);

    protected final HitPointType findHitPointType(@Nonnull Point2D p) {
        return this.findHitPointType(p, false, false);
    }

    protected final HitPointType findHitPointType(@Nonnull Point2D p, boolean useRectangles) {
        return this.findHitPointType(p, useRectangles, false);
    }

    public abstract Point2D getCoordsForConnectionType(HitPointType var1);

    public abstract Rectangle2D getBounds();

    @Nonnull
    protected abstract JPopupMenu showPopup(@Nonnull MouseEvent var1);

    @Nonnull
    protected final JPopupMenu showPopup(Point2D where) {
        return this.showPopup(new MouseEvent(this.layoutEditor.getTargetPanel(), 500, System.currentTimeMillis(), 0, (int)where.getX(), (int)where.getY(), 0, true));
    }

    @Nonnull
    protected final JPopupMenu showPopup() {
        Point2D where = MathUtil.multiply(this.getCoordsCenter(), this.layoutEditor.getZoom());
        return this.showPopup(where);
    }

    public abstract LayoutTrack getConnection(HitPointType var1) throws JmriException;

    public abstract void setConnection(HitPointType var1, LayoutTrack var2, HitPointType var3) throws JmriException;

    protected abstract void reCheckBlockBoundary();

    protected abstract List<LayoutConnectivity> getLayoutConnectivity();

    public boolean isDisconnected(HitPointType connectionType) {
        throw new IllegalArgumentException("should have called in Object instead of View (temporary)");
    }

    @Nonnull
    public abstract List<HitPointType> checkForFreeConnections();

    public abstract boolean checkForUnAssignedBlocks();

    public abstract void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> var1);

    public abstract void collectContiguousTracksNamesInBlockNamed(@Nonnull String var1, @Nonnull Set<String> var2);

    public abstract void setAllLayoutBlocks(LayoutBlock var1);
}

