/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LayoutTrack {
    protected final LayoutEditor models;
    private String ident = "";
    private static final Logger log = LoggerFactory.getLogger(LayoutTrack.class);

    public LayoutTrack(@Nonnull String ident, @Nonnull LayoutEditor models) {
        this.ident = ident;
        this.models = models;
    }

    @Nonnull
    public final String getId() {
        return this.ident;
    }

    @Nonnull
    public final String getName() {
        return this.ident;
    }

    protected final void setIdent(@Nonnull String ident) {
        this.ident = ident;
    }

    public abstract boolean isMainline();

    public final String getTurnoutStateString(int turnoutState) {
        String result = "";
        result = turnoutState == 2 ? Bundle.getMessage("TurnoutStateClosed") : (turnoutState == 4 ? Bundle.getMessage("TurnoutStateThrown") : Bundle.getMessage("BeanStateUnknown"));
        return result;
    }

    public abstract boolean canRemove();

    public abstract void setObjects(@Nonnull LayoutEditor var1);

    public abstract LayoutTrack getConnection(HitPointType var1) throws JmriException;

    public abstract void setConnection(HitPointType var1, LayoutTrack var2, HitPointType var3) throws JmriException;

    protected abstract void reCheckBlockBoundary();

    protected abstract List<LayoutConnectivity> getLayoutConnectivity();

    public boolean isDisconnected(HitPointType connectionType) {
        boolean result = false;
        if (HitPointType.isConnectionHitType(connectionType)) {
            try {
                result = this.getConnection(connectionType) == null;
            }
            catch (JmriException e) {
                log.error("Unexpected exception", (Throwable)e);
            }
        }
        return result;
    }

    @Nonnull
    public abstract List<HitPointType> checkForFreeConnections();

    public abstract boolean checkForUnAssignedBlocks();

    public abstract void checkForNonContiguousBlocks(@Nonnull HashMap<String, List<Set<String>>> var1);

    public abstract void collectContiguousTracksNamesInBlockNamed(@Nonnull String var1, @Nonnull Set<String> var2);

    public abstract void setAllLayoutBlocks(LayoutBlock var1);
}

