/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.UserPreferencesManager;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.MultiIconEditor;
import jmri.jmrit.display.layoutEditor.MultiSensorIconFrame;
import jmri.swing.NamedBeanComboBox;
import jmri.util.MathUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutEditorToolBarPanel
extends JPanel {
    protected final LayoutEditor layoutEditor;
    protected JLabel turnoutLabel = new JLabel();
    protected JRadioButton turnoutRHButton = new JRadioButton(Bundle.getMessage("RightHandAbbreviation"));
    protected JRadioButton turnoutLHButton = new JRadioButton(Bundle.getMessage("LeftHandAbbreviation"));
    protected JRadioButton turnoutWYEButton = new JRadioButton(Bundle.getMessage("WYEAbbreviation"));
    protected JRadioButton doubleXoverButton = new JRadioButton(Bundle.getMessage("DoubleCrossoverAbbreviation"));
    protected JRadioButton rhXoverButton = new JRadioButton(Bundle.getMessage("RightCrossover"));
    protected JRadioButton lhXoverButton = new JRadioButton(Bundle.getMessage("LeftCrossover"));
    protected JRadioButton layoutSingleSlipButton = new JRadioButton(Bundle.getMessage("LayoutSingleSlip"));
    protected JRadioButton layoutDoubleSlipButton = new JRadioButton(Bundle.getMessage("LayoutDoubleSlip"));
    protected FlowLayout leftRowLayout = new FlowLayout(0, 5, 0);
    protected FlowLayout centerRowLayout = new FlowLayout(1, 5, 0);
    protected FlowLayout rightRowLayout = new FlowLayout(2, 5, 0);
    protected NamedBeanComboBox<Turnout> turnoutNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.turnoutManagerInstance(), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JLabel turnoutNameLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("Name")));
    protected JPanel turnoutNamePanel = new JPanel(this.leftRowLayout);
    protected JPanel extraTurnoutPanel = new JPanel(this.leftRowLayout);
    protected NamedBeanComboBox<Turnout> extraTurnoutNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.turnoutManagerInstance(), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JComboBox<String> rotationComboBox = null;
    protected JPanel rotationPanel = new JPanel(this.leftRowLayout);
    protected JLabel trackLabel = new JLabel();
    protected JRadioButton levelXingButton = new JRadioButton(Bundle.getMessage("LevelCrossing"));
    protected JRadioButton trackButton = new JRadioButton(Bundle.getMessage("TrackSegment"));
    protected JPanel trackSegmentPropertiesPanel = new JPanel(this.leftRowLayout);
    protected JCheckBox mainlineTrack = new JCheckBox(Bundle.getMessage("MainlineBox"));
    protected JCheckBox dashedLine = new JCheckBox(Bundle.getMessage("Dashed"));
    protected JLabel blockLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BlockID")));
    protected NamedBeanComboBox<Block> blockIDComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JCheckBox highlightBlockCheckBox = new JCheckBox(Bundle.getMessage("HighlightSelectedBlockTitle"));
    protected JLabel blockSensorLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BlockSensorName")));
    protected NamedBeanComboBox<Sensor> blockSensorComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JRadioButton endBumperButton = new JRadioButton(Bundle.getMessage("EndBumper"));
    protected JRadioButton anchorButton = new JRadioButton(Bundle.getMessage("Anchor"));
    protected JRadioButton edgeButton = new JRadioButton(Bundle.getMessage("EdgeConnector"));
    protected JLabel labelsLabel = new JLabel();
    protected JRadioButton textLabelButton = new JRadioButton(Bundle.getMessage("TextLabel"));
    protected JTextField textLabelTextField = new JTextField(12);
    protected JRadioButton memoryButton = new JRadioButton(Bundle.getMessage("BeanNameMemory"));
    protected NamedBeanComboBox<Memory> textMemoryComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(MemoryManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JRadioButton blockContentsButton = new JRadioButton(Bundle.getMessage("BlockContentsLabel"));
    protected NamedBeanComboBox<Block> blockContentsComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JRadioButton multiSensorButton = new JRadioButton(String.valueOf(Bundle.getMessage("MultiSensor")) + "...");
    protected JRadioButton signalMastButton = new JRadioButton(Bundle.getMessage("SignalMastIcon"));
    protected NamedBeanComboBox<SignalMast> signalMastComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalMastManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JRadioButton sensorButton = new JRadioButton(Bundle.getMessage("SensorIcon"));
    protected NamedBeanComboBox<Sensor> sensorComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JRadioButton signalButton = new JRadioButton(Bundle.getMessage("SignalIcon"));
    protected NamedBeanComboBox<SignalHead> signalHeadComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalHeadManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected JRadioButton iconLabelButton = new JRadioButton(Bundle.getMessage("IconLabel"));
    protected JRadioButton shapeButton = new JRadioButton(Bundle.getMessage("LayoutShape"));
    protected JButton changeIconsButton = new JButton(String.valueOf(Bundle.getMessage("ChangeIcons")) + "...");
    protected MultiIconEditor sensorIconEditor = null;
    protected JFrame sensorFrame = null;
    protected MultiIconEditor signalIconEditor = null;
    protected JFrame signalFrame = null;
    protected MultiIconEditor iconEditor = null;
    protected JFrame iconFrame = null;
    protected MultiSensorIconFrame multiSensorFrame = null;
    protected JPanel zoomPanel = new JPanel();
    protected JLabel zoomLabel = new JLabel("x1");
    protected JPanel locationPanel = new JPanel();
    protected JPopupMenu locationPopupMenu = new JPopupMenu();
    protected JLabel xLabel = new JLabel("00");
    protected JLabel yLabel = new JLabel("00");
    protected JPanel blockPropertiesPanel = null;
    protected boolean toolBarIsWide = true;
    protected ButtonGroup itemGroup = null;
    private LocationFormat locationFormat = LocationFormat.ePIXELS;
    private Point2D lastLocation = MathUtil.zeroPoint2D();
    final Map<JRadioButton, String> quickKeyMap = new LinkedHashMap<JRadioButton, String>(){
        {
            this.put(LayoutEditorToolBarPanel.this.turnoutRHButton, Bundle.getMessage("TurnoutRH_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.turnoutLHButton, Bundle.getMessage("TurnoutLH_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.turnoutWYEButton, Bundle.getMessage("TurnoutWYE_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.doubleXoverButton, Bundle.getMessage("DoubleXover_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.rhXoverButton, Bundle.getMessage("RHXover_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.lhXoverButton, Bundle.getMessage("LHXover_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.layoutSingleSlipButton, Bundle.getMessage("LayoutSingleSlip_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.layoutDoubleSlipButton, Bundle.getMessage("LayoutDoubleSlip_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.levelXingButton, Bundle.getMessage("LevelXing_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.trackButton, Bundle.getMessage("TrackSegment_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.endBumperButton, Bundle.getMessage("EndBumper_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.anchorButton, Bundle.getMessage("Anchor_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.edgeButton, Bundle.getMessage("Edge_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.textLabelButton, Bundle.getMessage("TextLabel_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.memoryButton, Bundle.getMessage("Memory_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.blockContentsButton, Bundle.getMessage("BlockContents_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.multiSensorButton, Bundle.getMessage("MultiSensor_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.sensorButton, Bundle.getMessage("Sensor_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.signalMastButton, Bundle.getMessage("SignalMast_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.signalButton, Bundle.getMessage("Signal_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.iconLabelButton, Bundle.getMessage("IconLabel_QuickKeys"));
            this.put(LayoutEditorToolBarPanel.this.shapeButton, Bundle.getMessage("Shape_QuickKeys"));
        }
    };
    private static final Logger log = LoggerFactory.getLogger(LayoutEditorToolBarPanel.class);

    public LayoutEditorToolBarPanel(@Nonnull LayoutEditor layoutEditor) {
        this.layoutEditor = layoutEditor;
        this.setupComponents();
        this.layoutComponents();
    }

    protected void setupComponents() {
        this.itemGroup = new ButtonGroup();
        this.itemGroup.add(this.turnoutRHButton);
        this.itemGroup.add(this.turnoutLHButton);
        this.itemGroup.add(this.turnoutWYEButton);
        this.itemGroup.add(this.doubleXoverButton);
        this.itemGroup.add(this.rhXoverButton);
        this.itemGroup.add(this.lhXoverButton);
        this.itemGroup.add(this.levelXingButton);
        this.itemGroup.add(this.layoutSingleSlipButton);
        this.itemGroup.add(this.layoutDoubleSlipButton);
        this.itemGroup.add(this.endBumperButton);
        this.itemGroup.add(this.anchorButton);
        this.itemGroup.add(this.edgeButton);
        this.itemGroup.add(this.trackButton);
        this.itemGroup.add(this.multiSensorButton);
        this.itemGroup.add(this.sensorButton);
        this.itemGroup.add(this.signalButton);
        this.itemGroup.add(this.signalMastButton);
        this.itemGroup.add(this.textLabelButton);
        this.itemGroup.add(this.memoryButton);
        this.itemGroup.add(this.blockContentsButton);
        this.itemGroup.add(this.iconLabelButton);
        this.itemGroup.add(this.shapeButton);
        ActionListener selectionListAction = event -> {
            Component i;
            boolean e = this.turnoutRHButton.isSelected() || this.turnoutLHButton.isSelected() || this.turnoutWYEButton.isSelected() || this.doubleXoverButton.isSelected() || this.rhXoverButton.isSelected() || this.lhXoverButton.isSelected() || this.layoutSingleSlipButton.isSelected() || this.layoutDoubleSlipButton.isSelected();
            log.debug("turnoutPropertiesPanel is {}", (Object)(e ? "enabled" : "disabled"));
            this.turnoutNamePanel.setEnabled(e);
            Component[] componentArray = this.turnoutNamePanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = componentArray[n2];
                i.setEnabled(e);
                ++n2;
            }
            this.rotationPanel.setEnabled(e);
            componentArray = this.rotationPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                i = componentArray[n2];
                i.setEnabled(e);
                ++n2;
            }
            e = this.layoutSingleSlipButton.isSelected() || this.layoutDoubleSlipButton.isSelected();
            log.debug("extraTurnoutPanel is {}", (Object)(e ? "enabled" : "disabled"));
            componentArray = this.extraTurnoutPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                i = componentArray[n2];
                i.setEnabled(e);
                ++n2;
            }
            e = this.trackButton.isSelected();
            log.debug("trackSegmentPropertiesPanel is {}", (Object)(e ? "enabled" : "disabled"));
            componentArray = this.trackSegmentPropertiesPanel.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                i = componentArray[n2];
                i.setEnabled(e);
                ++n2;
            }
            e = this.turnoutRHButton.isSelected() || this.turnoutLHButton.isSelected() || this.turnoutWYEButton.isSelected() || this.doubleXoverButton.isSelected() || this.rhXoverButton.isSelected() || this.lhXoverButton.isSelected() || this.layoutSingleSlipButton.isSelected() || this.layoutDoubleSlipButton.isSelected() || this.levelXingButton.isSelected() || this.trackButton.isSelected();
            log.debug("blockPanel is {}", (Object)(e ? "enabled" : "disabled"));
            if (this.blockPropertiesPanel != null) {
                componentArray = this.blockPropertiesPanel.getComponents();
                n = componentArray.length;
                n2 = 0;
                while (n2 < n) {
                    i = componentArray[n2];
                    i.setEnabled(e);
                    ++n2;
                }
                if (e) {
                    this.blockPropertiesPanel.setBackground(Color.lightGray);
                } else {
                    this.blockPropertiesPanel.setBackground(new Color(238, 238, 238));
                }
            } else {
                this.blockLabel.setEnabled(e);
                this.blockIDComboBox.setEnabled(e);
                this.blockSensorLabel.setEnabled(e);
                this.blockSensorLabel.setEnabled(e);
                this.blockSensorComboBox.setEnabled(e);
            }
            this.textLabelTextField.setEnabled(this.textLabelButton.isSelected());
            this.textMemoryComboBox.setEnabled(this.memoryButton.isSelected());
            this.blockContentsComboBox.setEnabled(this.blockContentsButton.isSelected());
            this.signalMastComboBox.setEnabled(this.signalMastButton.isSelected());
            this.sensorComboBox.setEnabled(this.sensorButton.isSelected());
            this.signalHeadComboBox.setEnabled(this.signalButton.isSelected());
            e = this.sensorButton.isSelected() || this.signalButton.isSelected() || this.iconLabelButton.isSelected();
            log.debug("changeIconsButton is {}", (Object)(e ? "enabled" : "disabled"));
            this.changeIconsButton.setEnabled(e);
        };
        this.turnoutRHButton.addActionListener(selectionListAction);
        this.turnoutLHButton.addActionListener(selectionListAction);
        this.turnoutWYEButton.addActionListener(selectionListAction);
        this.doubleXoverButton.addActionListener(selectionListAction);
        this.rhXoverButton.addActionListener(selectionListAction);
        this.lhXoverButton.addActionListener(selectionListAction);
        this.levelXingButton.addActionListener(selectionListAction);
        this.layoutSingleSlipButton.addActionListener(selectionListAction);
        this.layoutDoubleSlipButton.addActionListener(selectionListAction);
        this.endBumperButton.addActionListener(selectionListAction);
        this.anchorButton.addActionListener(selectionListAction);
        this.edgeButton.addActionListener(selectionListAction);
        this.trackButton.addActionListener(selectionListAction);
        this.multiSensorButton.addActionListener(selectionListAction);
        this.sensorButton.addActionListener(selectionListAction);
        this.signalButton.addActionListener(selectionListAction);
        this.signalMastButton.addActionListener(selectionListAction);
        this.textLabelButton.addActionListener(selectionListAction);
        this.memoryButton.addActionListener(selectionListAction);
        this.blockContentsButton.addActionListener(selectionListAction);
        this.iconLabelButton.addActionListener(selectionListAction);
        this.shapeButton.addActionListener(selectionListAction);
        this.turnoutRHButton.setSelected(true);
        this.turnoutRHButton.setToolTipText(Bundle.getMessage("RHToolTip"));
        this.turnoutLHButton.setToolTipText(Bundle.getMessage("LHToolTip"));
        this.turnoutWYEButton.setToolTipText(Bundle.getMessage("WYEToolTip"));
        this.doubleXoverButton.setToolTipText(Bundle.getMessage("DoubleCrossoverToolTip"));
        this.rhXoverButton.setToolTipText(Bundle.getMessage("RHCrossoverToolTip"));
        this.lhXoverButton.setToolTipText(Bundle.getMessage("LHCrossoverToolTip"));
        this.layoutSingleSlipButton.setToolTipText(Bundle.getMessage("SingleSlipToolTip"));
        this.layoutDoubleSlipButton.setToolTipText(Bundle.getMessage("DoubleSlipToolTip"));
        this.turnoutNamePanel.add(this.turnoutNameLabel);
        LayoutEditor.setupComboBox(this.turnoutNameComboBox, false, true, false);
        this.turnoutNameComboBox.setToolTipText(Bundle.getMessage("TurnoutNameToolTip"));
        this.turnoutNamePanel.add(this.turnoutNameComboBox);
        this.turnoutNameComboBox.addPopupMenuListener(this.layoutEditor.newTurnoutComboBoxPopupMenuListener(this.turnoutNameComboBox));
        LayoutEditor.setupComboBox(this.extraTurnoutNameComboBox, false, true, false);
        this.extraTurnoutNameComboBox.setToolTipText(Bundle.getMessage("SecondTurnoutNameToolTip"));
        this.extraTurnoutNameComboBox.addPopupMenuListener(this.layoutEditor.newTurnoutComboBoxPopupMenuListener(this.extraTurnoutNameComboBox));
        JLabel extraTurnoutLabel = new JLabel(Bundle.getMessage("SecondName"));
        extraTurnoutLabel.setEnabled(false);
        this.extraTurnoutPanel.add(extraTurnoutLabel);
        this.extraTurnoutPanel.add(this.extraTurnoutNameComboBox);
        this.extraTurnoutPanel.setEnabled(false);
        String[] angleStrings = new String[]{"-180", "-135", "-90", "-45", "0", "+45", "+90", "+135", "+180"};
        this.rotationComboBox = new JComboBox<String>(angleStrings);
        this.rotationComboBox.setEditable(true);
        this.rotationComboBox.setSelectedIndex(4);
        this.rotationComboBox.setMaximumRowCount(9);
        this.rotationComboBox.setToolTipText(Bundle.getMessage("RotationToolTip"));
        JLabel rotationLabel = new JLabel(Bundle.getMessage("Rotation"));
        this.rotationPanel.add(rotationLabel);
        this.rotationPanel.add(this.rotationComboBox);
        this.zoomPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("ZoomLabel"))));
        this.zoomPanel.add(this.zoomLabel);
        Dimension coordSize = this.xLabel.getPreferredSize();
        coordSize.width *= 2;
        this.xLabel.setPreferredSize(coordSize);
        this.yLabel.setPreferredSize(coordSize);
        this.locationPanel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("Location"))));
        this.locationPanel.add(new JLabel("{x:"));
        this.locationPanel.add(this.xLabel);
        this.locationPanel.add(new JLabel(", y:"));
        this.locationPanel.add(this.yLabel);
        this.locationPanel.add(new JLabel("}    "));
        this.locationPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    LayoutEditorToolBarPanel.this.locationPopupMenu.show(LayoutEditorToolBarPanel.this.locationPanel, me.getX(), me.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    LayoutEditorToolBarPanel.this.locationPopupMenu.show(LayoutEditorToolBarPanel.this.locationPanel, me.getX(), me.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    LayoutEditorToolBarPanel.this.locationPopupMenu.show(LayoutEditorToolBarPanel.this.locationPanel, me.getX(), me.getY());
                }
            }
        });
        this.levelXingButton.setToolTipText(Bundle.getMessage("LevelCrossingToolTip"));
        this.trackButton.setToolTipText(Bundle.getMessage("TrackSegmentToolTip"));
        this.trackSegmentPropertiesPanel.add(this.mainlineTrack);
        this.mainlineTrack.setSelected(false);
        this.mainlineTrack.setEnabled(false);
        this.mainlineTrack.setToolTipText(Bundle.getMessage("MainlineCheckBoxTip"));
        this.trackSegmentPropertiesPanel.add(this.dashedLine);
        this.dashedLine.setSelected(false);
        this.dashedLine.setEnabled(false);
        this.dashedLine.setToolTipText(Bundle.getMessage("DashedCheckBoxTip"));
        LayoutEditor.setupComboBox(this.blockIDComboBox, false, true, true);
        this.blockIDComboBox.setToolTipText(Bundle.getMessage("BlockIDToolTip"));
        this.highlightBlockCheckBox.setToolTipText(Bundle.getMessage("HighlightSelectedBlockToolTip"));
        this.highlightBlockCheckBox.addActionListener(event -> this.layoutEditor.setHighlightSelectedBlock(this.highlightBlockCheckBox.isSelected()));
        this.highlightBlockCheckBox.setSelected(this.layoutEditor.getHighlightSelectedBlock());
        this.blockIDComboBox.addActionListener(event -> {
            LayoutBlock lb;
            String newName;
            if (this.layoutEditor.getHighlightSelectedBlock()) {
                this.layoutEditor.highlightBlockInComboBox(this.blockIDComboBox);
            }
            if ((newName = this.blockIDComboBox.getSelectedItemDisplayName()) == null) {
                newName = "";
            }
            if ((lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(newName)) != null) {
                String sensorName = lb.getOccupancySensorName();
                if (!sensorName.isEmpty()) {
                    this.blockSensorComboBox.setSelectedItem(lb.getOccupancySensor());
                } else {
                    this.blockSensorComboBox.setSelectedItem(null);
                }
            } else {
                this.blockSensorComboBox.setSelectedItem(null);
            }
        });
        LayoutEditor.setupComboBox(this.blockSensorComboBox, false, true, false);
        this.blockSensorComboBox.setToolTipText(Bundle.getMessage("OccupancySensorToolTip"));
        this.endBumperButton.setToolTipText(Bundle.getMessage("EndBumperToolTip"));
        this.anchorButton.setToolTipText(Bundle.getMessage("AnchorToolTip"));
        this.edgeButton.setToolTipText(Bundle.getMessage("EdgeConnectorToolTip"));
        this.textLabelButton.setToolTipText(Bundle.getMessage("TextLabelToolTip"));
        this.textLabelTextField.setToolTipText(Bundle.getMessage("TextToolTip"));
        this.textLabelTextField.setEnabled(false);
        this.memoryButton.setToolTipText(Bundle.getMessage("MemoryButtonToolTip", Bundle.getMessage("Memory")));
        LayoutEditor.setupComboBox(this.textMemoryComboBox, true, false, false);
        this.textMemoryComboBox.setToolTipText(Bundle.getMessage("MemoryToolTip"));
        this.blockContentsButton.setToolTipText(Bundle.getMessage("BlockContentsButtonToolTip"));
        LayoutEditor.setupComboBox(this.blockContentsComboBox, true, false, false);
        this.blockContentsComboBox.setToolTipText(Bundle.getMessage("BlockContentsButtonToolTip"));
        this.blockContentsComboBox.addActionListener(event -> {
            if (this.layoutEditor.getHighlightSelectedBlock()) {
                this.layoutEditor.highlightBlockInComboBox(this.blockContentsComboBox);
            }
        });
        this.multiSensorButton.setToolTipText(Bundle.getMessage("MultiSensorToolTip"));
        this.signalMastButton.setToolTipText(Bundle.getMessage("SignalMastButtonToolTip"));
        LayoutEditor.setupComboBox(this.signalMastComboBox, true, false, false);
        this.sensorButton.setToolTipText(Bundle.getMessage("SensorButtonToolTip"));
        LayoutEditor.setupComboBox(this.sensorComboBox, true, false, false);
        this.sensorComboBox.setToolTipText(Bundle.getMessage("SensorIconToolTip"));
        this.sensorIconEditor = new MultiIconEditor(4);
        this.sensorIconEditor.setIcon(0, Bundle.getMessage("MakeLabel", Bundle.getMessage("SensorStateActive")), "resources/icons/smallschematics/tracksegments/circuit-occupied.gif");
        this.sensorIconEditor.setIcon(1, Bundle.getMessage("MakeLabel", Bundle.getMessage("SensorStateInactive")), "resources/icons/smallschematics/tracksegments/circuit-empty.gif");
        this.sensorIconEditor.setIcon(2, Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanStateInconsistent")), "resources/icons/smallschematics/tracksegments/circuit-error.gif");
        this.sensorIconEditor.setIcon(3, Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanStateUnknown")), "resources/icons/smallschematics/tracksegments/circuit-error.gif");
        this.sensorIconEditor.complete();
        this.signalButton.setToolTipText(Bundle.getMessage("SignalButtonToolTip"));
        LayoutEditor.setupComboBox(this.signalHeadComboBox, true, false, false);
        this.signalHeadComboBox.setToolTipText(Bundle.getMessage("SignalIconToolTip"));
        this.signalIconEditor = new MultiIconEditor(10);
        this.signalIconEditor.setIcon(0, "Red:", "resources/icons/smallschematics/searchlights/left-red-short.gif");
        this.signalIconEditor.setIcon(1, "Flash red:", "resources/icons/smallschematics/searchlights/left-flashred-short.gif");
        this.signalIconEditor.setIcon(2, "Yellow:", "resources/icons/smallschematics/searchlights/left-yellow-short.gif");
        this.signalIconEditor.setIcon(3, "Flash yellow:", "resources/icons/smallschematics/searchlights/left-flashyellow-short.gif");
        this.signalIconEditor.setIcon(4, "Green:", "resources/icons/smallschematics/searchlights/left-green-short.gif");
        this.signalIconEditor.setIcon(5, "Flash green:", "resources/icons/smallschematics/searchlights/left-flashgreen-short.gif");
        this.signalIconEditor.setIcon(6, "Dark:", "resources/icons/smallschematics/searchlights/left-dark-short.gif");
        this.signalIconEditor.setIcon(7, "Held:", "resources/icons/smallschematics/searchlights/left-held-short.gif");
        this.signalIconEditor.setIcon(8, "Lunar", "resources/icons/smallschematics/searchlights/left-lunar-short-marker.gif");
        this.signalIconEditor.setIcon(9, "Flash Lunar", "resources/icons/smallschematics/searchlights/left-flashlunar-short-marker.gif");
        this.signalIconEditor.complete();
        this.sensorFrame = new JFrame(Bundle.getMessage("EditSensorIcons"));
        this.sensorFrame.getContentPane().add((Component)new JLabel(Bundle.getMessage("IconChangeInfo")), "North");
        this.sensorFrame.getContentPane().add(this.sensorIconEditor);
        this.sensorFrame.pack();
        this.signalFrame = new JFrame(Bundle.getMessage("EditSignalIcons"));
        this.signalFrame.getContentPane().add((Component)new JLabel(Bundle.getMessage("IconChangeInfo")), "North");
        this.signalFrame.getContentPane().add(this.signalIconEditor);
        this.signalFrame.pack();
        this.signalFrame.setVisible(false);
        this.iconLabelButton.setToolTipText(Bundle.getMessage("IconLabelToolTip"));
        this.shapeButton.setToolTipText(Bundle.getMessage("LayoutShapeToolTip"));
        this.changeIconsButton.addActionListener(event -> {
            if (this.sensorButton.isSelected()) {
                this.sensorFrame.setVisible(true);
            } else if (this.signalButton.isSelected()) {
                this.signalFrame.setVisible(true);
            } else if (this.iconLabelButton.isSelected()) {
                this.iconFrame.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ChangeIconNotApplied"), Bundle.getMessage("ChangeIcons"), 1);
            }
        });
        this.changeIconsButton.setToolTipText(Bundle.getMessage("ChangeIconToolTip"));
        this.changeIconsButton.setEnabled(false);
        this.iconEditor = new MultiIconEditor(1);
        this.iconEditor.setIcon(0, "", "resources/icons/smallschematics/tracksegments/block.gif");
        this.iconEditor.complete();
        this.iconFrame = new JFrame(Bundle.getMessage("EditIcon"));
        this.iconFrame.getContentPane().add(this.iconEditor);
        this.iconFrame.pack();
    }

    public LocationFormat getLocationFormat() {
        return this.locationFormat;
    }

    public void setLocationFormat(LocationFormat locationFormat) {
        if (this.locationFormat != locationFormat) {
            switch (locationFormat) {
                default: {
                    Dimension coordSize = new JLabel("10000").getPreferredSize();
                    this.xLabel.setPreferredSize(coordSize);
                    this.yLabel.setPreferredSize(coordSize);
                    break;
                }
                case eMETRIC_CM: {
                    Dimension coordSize = new JLabel(this.getMetricCMText(10005)).getPreferredSize();
                    this.xLabel.setPreferredSize(coordSize);
                    this.yLabel.setPreferredSize(coordSize);
                    this.layoutEditor.gContext.setGridSize(10);
                    this.layoutEditor.gContext.setGridSize2nd(10);
                    break;
                }
                case eENGLISH_FEET_INCHES: {
                    Dimension coordSize = new JLabel(this.getEnglishFeetInchesText(100008)).getPreferredSize();
                    this.xLabel.setPreferredSize(coordSize);
                    this.yLabel.setPreferredSize(coordSize);
                    this.layoutEditor.gContext.setGridSize(16);
                    this.layoutEditor.gContext.setGridSize2nd(12);
                }
            }
            this.locationFormat = locationFormat;
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> {
                String windowFrameRef = this.layoutEditor.getWindowFrameRef();
                prefsMgr.setProperty(windowFrameRef, "LocationFormat", locationFormat.name());
            });
            this.setLocationText(this.lastLocation);
        }
    }

    public void setLocationText(Point2D p) {
        int x = (int)p.getX();
        int y = (int)p.getY();
        String xText = Integer.toString(x);
        String yText = Integer.toString(y);
        if (this.locationFormat.equals((Object)LocationFormat.eENGLISH_FEET_INCHES)) {
            xText = this.getEnglishFeetInchesText(x);
            yText = this.getEnglishFeetInchesText(y);
        } else if (this.locationFormat.equals((Object)LocationFormat.eMETRIC_CM)) {
            xText = this.getMetricCMText(x);
            yText = this.getMetricCMText(y);
        }
        this.xLabel.setText(xText);
        this.yLabel.setText(yText);
        this.lastLocation = p;
    }

    private String getEnglishFeetInchesText(int v) {
        String result = "";
        int denom = 16;
        int ipf = 12;
        int feet = v / (ipf * denom);
        int inches = v / denom % ipf;
        int numer = v % denom;
        int gcd = MathUtil.gcd(numer, denom);
        numer /= gcd;
        denom /= gcd;
        if (feet > 0) {
            result = String.format("%d'", feet);
        }
        boolean inchesFlag = false;
        if (v == 0 || inches > 0) {
            result = String.valueOf(result) + String.format(" %d", inches);
            inchesFlag = true;
        }
        if (numer > 0) {
            result = String.valueOf(result) + String.format(" %d/%d", numer, denom);
            inchesFlag = true;
        }
        if (inchesFlag) {
            result = String.valueOf(result) + "\"";
        }
        return result;
    }

    private String getMetricCMText(int v) {
        return String.format("%d.%d cm", v / 10, v % 10);
    }

    protected void layoutComponents() {
        log.error("layoutComponents called in LayoutEditorToolBarPanel base class");
    }

    public void keyPressed(@Nonnull KeyEvent event) {
        if (this.layoutEditor.isEditable() && !event.isMetaDown() && !event.isAltDown() && !event.isControlDown() && event.getID() == 401) {
            char keyChar = event.getKeyChar();
            String keyString = String.valueOf(keyChar);
            log.trace("KeyEvent.getKeyChar() == {}", (Object)KeyEvent.getKeyText(keyChar));
            JRadioButton lastRadioButton = null;
            for (Map.Entry<JRadioButton, String> entry : this.quickKeyMap.entrySet()) {
                JRadioButton thisRadioButton = entry.getKey();
                if (!thisRadioButton.isSelected()) continue;
                lastRadioButton = thisRadioButton;
                log.trace("lastRadioButton is {}", (Object)lastRadioButton.getText());
                break;
            }
            AbstractButton firstRadioButton = null;
            AbstractButton nextRadioButton = null;
            boolean foundLast = false;
            for (Map.Entry<JRadioButton, String> entry : this.quickKeyMap.entrySet()) {
                String quickKeys = entry.getValue();
                if (!keyString.equals(" ") && !StringUtils.containsAny((CharSequence)keyString, (CharSequence)quickKeys)) continue;
                JRadioButton thisRadioButton = entry.getKey();
                log.trace("Matched keyString to {}", (Object)thisRadioButton.getText());
                if (foundLast) {
                    nextRadioButton = thisRadioButton;
                    break;
                }
                if (lastRadioButton == thisRadioButton) {
                    foundLast = true;
                    continue;
                }
                if (firstRadioButton != null) continue;
                firstRadioButton = thisRadioButton;
            }
            if (nextRadioButton == null) {
                nextRadioButton = firstRadioButton;
            }
            if (nextRadioButton != null) {
                nextRadioButton.setSelected(true);
            }
        }
    }

    public static enum LocationFormat {
        ePIXELS,
        eMETRIC_CM,
        eENGLISH_FEET_INCHES;

    }
}

