/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutModels;
import jmri.jmrit.display.layoutEditor.LayoutShape;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayoutEditorFindItems {
    private final LayoutModels layoutModels;
    private static final Logger log = LoggerFactory.getLogger(LayoutEditorFindItems.class);

    public LayoutEditorFindItems(LayoutModels models) {
        this.layoutModels = models;
    }

    public TrackSegment findTrackSegmentByName(String name) {
        if (!name.isEmpty()) {
            for (TrackSegment t : this.layoutModels.getTrackSegments()) {
                if (!t.getId().equals(name)) continue;
                return t;
            }
        }
        return null;
    }

    public PositionablePoint findPositionablePointByName(String name) {
        if (!name.isEmpty()) {
            for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                if (!p.getId().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    public PositionablePoint findPositionablePointAtTrackSegments(TrackSegment tr1, TrackSegment tr2) {
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if ((p.getConnect1() != tr1 || p.getConnect2() != tr2) && (p.getConnect1() != tr2 || p.getConnect2() != tr1)) continue;
            return p;
        }
        return null;
    }

    public PositionablePoint findPositionableLinkPoint(LayoutBlock blk1) {
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if (p.getType() != PositionablePoint.PointType.EDGE_CONNECTOR || (p.getConnect1() == null || p.getConnect1().getLayoutBlock() != blk1) && (p.getConnect2() == null || p.getConnect2().getLayoutBlock() != blk1)) continue;
            return p;
        }
        return null;
    }

    public ArrayList<TrackSegment> findTrackSegmentByBlock(String name) {
        if (name.isEmpty()) {
            return null;
        }
        ArrayList<TrackSegment> ts = new ArrayList<TrackSegment>();
        for (TrackSegment t : this.layoutModels.getTrackSegments()) {
            if (!t.getBlockName().equals(name)) continue;
            ts.add(t);
        }
        return ts;
    }

    public PositionablePoint findPositionablePointByEastBoundSignal(String signalName) {
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if (!p.getEastBoundSignal().equals(signalName)) continue;
            return p;
        }
        return null;
    }

    public PositionablePoint findPositionablePointByWestBoundSignal(String signalName) {
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if (!p.getWestBoundSignal().equals(signalName)) continue;
            return p;
        }
        return null;
    }

    public PositionablePoint findPositionablePointByWestBoundBean(NamedBean bean) {
        block4: {
            block5: {
                block3: {
                    if (!(bean instanceof SignalMast)) break block3;
                    for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                        if (p.getWestBoundSignalMast() != bean) continue;
                        return p;
                    }
                    break block4;
                }
                if (!(bean instanceof Sensor)) break block5;
                for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                    if (p.getWestBoundSensor() != bean) continue;
                    return p;
                }
                break block4;
            }
            if (!(bean instanceof SignalHead)) break block4;
            for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                if (!p.getWestBoundSignal().equals(bean.getSystemName())) continue;
                return p;
            }
        }
        return null;
    }

    public PositionablePoint findPositionablePointByEastBoundBean(NamedBean bean) {
        block4: {
            block5: {
                block3: {
                    if (!(bean instanceof SignalMast)) break block3;
                    for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                        if (p.getEastBoundSignalMast() != bean) continue;
                        return p;
                    }
                    break block4;
                }
                if (!(bean instanceof Sensor)) break block5;
                for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                    if (p.getEastBoundSensor() != bean) continue;
                    return p;
                }
                break block4;
            }
            if (!(bean instanceof SignalHead)) break block4;
            for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                if (!p.getEastBoundSignal().equals(bean.getSystemName())) continue;
                return p;
            }
        }
        return null;
    }

    public PositionablePoint findPositionablePointByWestBoundSignalMast(String signalMastName) {
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if (!p.getWestBoundSignalMastName().equals(signalMastName)) continue;
            return p;
        }
        return null;
    }

    public PositionablePoint findPositionablePointByBean(NamedBean bean) {
        block5: {
            block6: {
                block4: {
                    if (!(bean instanceof SignalMast)) break block4;
                    for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                        if (p.getWestBoundSignalMast() != bean && p.getEastBoundSignalMast() != bean) continue;
                        return p;
                    }
                    break block5;
                }
                if (!(bean instanceof Sensor)) break block6;
                for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                    if (p.getWestBoundSensor() != bean && p.getEastBoundSensor() != bean) continue;
                    return p;
                }
                break block5;
            }
            if (!(bean instanceof SignalHead)) break block5;
            for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
                if (p.getEastBoundSignal().equals(bean.getSystemName()) || p.getWestBoundSignal().equals(bean.getSystemName())) {
                    return p;
                }
                if (bean.getUserName() == null || !p.getEastBoundSignal().equals(bean.getSystemName()) && !p.getWestBoundSignal().equals(bean.getSystemName())) continue;
                return p;
            }
        }
        return null;
    }

    @CheckReturnValue
    public LayoutTurnout findLayoutTurnoutBySignalMast(String signalMastName) throws IllegalArgumentException {
        return this.findLayoutTurnoutByBean(InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMastName));
    }

    @CheckReturnValue
    public LayoutTurnout findLayoutTurnoutByBean(@CheckForNull NamedBean bean) {
        block12: {
            List<LayoutTurnout> layoutTurnouts;
            block14: {
                block13: {
                    block11: {
                        layoutTurnouts = this.layoutModels.getLayoutTurnouts();
                        if (!(bean instanceof SignalMast)) break block11;
                        for (LayoutTurnout t : layoutTurnouts) {
                            if (t.getSignalAMast() != bean && t.getSignalBMast() != bean && t.getSignalCMast() != bean && t.getSignalDMast() != bean) continue;
                            return t;
                        }
                        break block12;
                    }
                    if (!(bean instanceof Sensor)) break block13;
                    for (LayoutTurnout t : layoutTurnouts) {
                        if (t.getSensorA() != bean && t.getSensorB() != bean && t.getSensorC() != bean && t.getSensorD() != bean) continue;
                        return t;
                    }
                    break block12;
                }
                if (!(bean instanceof SignalHead)) break block14;
                for (LayoutTurnout t : layoutTurnouts) {
                    if (t.getSignalA1Name().equals(bean.getSystemName()) || t.getSignalA2Name().equals(bean.getSystemName()) || t.getSignalA3Name().equals(bean.getSystemName())) {
                        return t;
                    }
                    if (t.getSignalB1Name().equals(bean.getSystemName()) || t.getSignalB2Name().equals(bean.getSystemName())) {
                        return t;
                    }
                    if (t.getSignalC1Name().equals(bean.getSystemName()) || t.getSignalC2Name().equals(bean.getSystemName())) {
                        return t;
                    }
                    if (t.getSignalD1Name().equals(bean.getSystemName()) || t.getSignalD2Name().equals(bean.getSystemName())) {
                        return t;
                    }
                    if (bean.getUserName() == null) continue;
                    if (t.getSignalA1Name().equals(bean.getUserName()) || t.getSignalA2Name().equals(bean.getUserName()) || t.getSignalA3Name().equals(bean.getUserName())) {
                        return t;
                    }
                    if (t.getSignalB1Name().equals(bean.getUserName()) || t.getSignalB2Name().equals(bean.getUserName())) {
                        return t;
                    }
                    if (t.getSignalC1Name().equals(bean.getUserName()) || t.getSignalC2Name().equals(bean.getUserName())) {
                        return t;
                    }
                    if (!t.getSignalD1Name().equals(bean.getUserName()) && !t.getSignalD2Name().equals(bean.getUserName())) continue;
                    return t;
                }
                break block12;
            }
            if (!(bean instanceof Turnout)) break block12;
            for (LayoutTurnout t : layoutTurnouts) {
                if (!bean.equals(t.getTurnout())) continue;
                return t;
            }
        }
        return null;
    }

    @CheckReturnValue
    public LayoutTurnout findLayoutTurnoutBySensor(String sensorName) throws IllegalArgumentException {
        return this.findLayoutTurnoutByBean(InstanceManager.sensorManagerInstance().provideSensor(sensorName));
    }

    public LevelXing findLevelXingBySignalMast(String signalMastName) throws IllegalArgumentException {
        return this.findLevelXingByBean(InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMastName));
    }

    public LevelXing findLevelXingBySensor(String sensorName) throws IllegalArgumentException {
        return this.findLevelXingByBean(InstanceManager.sensorManagerInstance().provideSensor(sensorName));
    }

    public LevelXing findLevelXingByBean(NamedBean bean) {
        block5: {
            List<LevelXing> levelXings;
            block6: {
                block4: {
                    levelXings = this.layoutModels.getLevelXings();
                    if (!(bean instanceof SignalMast)) break block4;
                    for (LevelXing l : levelXings) {
                        if (l.getSignalAMast() != bean && l.getSignalBMast() != bean && l.getSignalCMast() != bean && l.getSignalDMast() != bean) continue;
                        return l;
                    }
                    break block5;
                }
                if (!(bean instanceof Sensor)) break block6;
                for (LevelXing l : levelXings) {
                    if (l.getSensorA() != bean && l.getSensorB() != bean && l.getSensorC() != bean && l.getSensorD() != bean) continue;
                    return l;
                }
                break block5;
            }
            if (!(bean instanceof SignalHead)) break block5;
            for (LevelXing l : levelXings) {
                if (l.getSignalAName().equals(bean.getSystemName()) || l.getSignalBName().equals(bean.getSystemName()) || l.getSignalCName().equals(bean.getSystemName()) || l.getSignalDName().equals(bean.getSystemName())) {
                    return l;
                }
                if (bean.getUserName() == null || !l.getSignalAName().equals(bean.getUserName()) && !l.getSignalBName().equals(bean.getUserName()) && !l.getSignalCName().equals(bean.getUserName()) && !l.getSignalDName().equals(bean.getUserName())) continue;
                return l;
            }
        }
        return null;
    }

    public LayoutSlip findLayoutSlipByBean(NamedBean bean) {
        block13: {
            List<LayoutSlip> layoutSlips;
            block15: {
                block14: {
                    block12: {
                        layoutSlips = this.layoutModels.getLayoutSlips();
                        if (!(bean instanceof SignalMast)) break block12;
                        for (LayoutSlip l : layoutSlips) {
                            if (l.getSignalAMast() != bean && l.getSignalBMast() != bean && l.getSignalCMast() != bean && l.getSignalDMast() != bean) continue;
                            return l;
                        }
                        break block13;
                    }
                    if (!(bean instanceof Sensor)) break block14;
                    for (LayoutSlip l : layoutSlips) {
                        if (l.getSensorA() != bean && l.getSensorB() != bean && l.getSensorC() != bean && l.getSensorD() != bean) continue;
                        return l;
                    }
                    break block13;
                }
                if (!(bean instanceof SignalHead)) break block15;
                for (LayoutSlip l : layoutSlips) {
                    if (l.getSignalA1Name().equals(bean.getSystemName()) || l.getSignalA2Name().equals(bean.getSystemName()) || l.getSignalA3Name().equals(bean.getSystemName())) {
                        return l;
                    }
                    if (l.getSignalB1Name().equals(bean.getSystemName()) || l.getSignalB2Name().equals(bean.getSystemName())) {
                        return l;
                    }
                    if (l.getSignalC1Name().equals(bean.getSystemName()) || l.getSignalC2Name().equals(bean.getSystemName())) {
                        return l;
                    }
                    if (l.getSignalD1Name().equals(bean.getSystemName()) || l.getSignalD2Name().equals(bean.getSystemName())) {
                        return l;
                    }
                    if (l.getSignalA1Name().equals(bean.getUserName()) || l.getSignalA2Name().equals(bean.getUserName()) || l.getSignalA3Name().equals(bean.getUserName())) {
                        return l;
                    }
                    if (bean.getUserName() == null) continue;
                    if (l.getSignalB1Name().equals(bean.getUserName()) || l.getSignalB2Name().equals(bean.getUserName())) {
                        return l;
                    }
                    if (l.getSignalC1Name().equals(bean.getUserName()) || l.getSignalC2Name().equals(bean.getUserName())) {
                        return l;
                    }
                    if (!l.getSignalD1Name().equals(bean.getUserName()) && !l.getSignalD2Name().equals(bean.getUserName())) continue;
                    return l;
                }
                break block13;
            }
            if (!(bean instanceof Turnout)) break block13;
            for (LayoutSlip l : layoutSlips) {
                if (bean.equals(l.getTurnout())) {
                    return l;
                }
                if (!bean.equals(l.getTurnoutB())) continue;
                return l;
            }
        }
        return null;
    }

    public LayoutSlip findLayoutSlipBySignalMast(String signalMastName) throws IllegalArgumentException {
        return this.findLayoutSlipByBean(InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(signalMastName));
    }

    public LayoutSlip findLayoutSlipBySensor(String sensorName) throws IllegalArgumentException {
        return this.findLayoutSlipByBean(InstanceManager.sensorManagerInstance().provideSensor(sensorName));
    }

    public PositionablePoint findPositionablePointByEastBoundSensor(String sensorName) {
        PositionablePoint result = null;
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if (!p.getEastBoundSensorName().equals(sensorName)) continue;
            result = p;
            break;
        }
        return result;
    }

    public PositionablePoint findPositionablePointByWestBoundSensor(String sensorName) {
        PositionablePoint result = null;
        for (PositionablePoint p : this.layoutModels.getPositionablePoints()) {
            if (!p.getWestBoundSensorName().equals(sensorName)) continue;
            result = p;
            break;
        }
        return result;
    }

    @CheckReturnValue
    public LayoutTurnout findLayoutTurnoutByName(String name) {
        LayoutTurnout result = null;
        if (name != null && !name.isEmpty()) {
            for (LayoutTurnout t : this.layoutModels.getLayoutTurnouts()) {
                if (!t.getName().equals(name)) continue;
                result = t;
                break;
            }
        }
        return result;
    }

    @CheckReturnValue
    public LayoutTurnout findLayoutTurnoutByTurnoutName(String turnoutName) {
        LayoutTurnout result = null;
        if (turnoutName != null && !turnoutName.isEmpty()) {
            for (LayoutTurnout t : this.layoutModels.getLayoutTurnouts()) {
                if (!t.getTurnoutName().equals(turnoutName)) continue;
                result = t;
            }
        }
        return result;
    }

    public LevelXing findLevelXingByName(String name) {
        LevelXing result = null;
        if (name != null && !name.isEmpty()) {
            for (LevelXing x : this.layoutModels.getLevelXings()) {
                if (!x.getId().equals(name)) continue;
                result = x;
                break;
            }
        }
        return result;
    }

    public LayoutSlip findLayoutSlipByName(String name) {
        LayoutSlip result = null;
        if (name != null && !name.isEmpty()) {
            for (LayoutSlip x : this.layoutModels.getLayoutSlips()) {
                if (!x.getName().equals(name)) continue;
                result = x;
                break;
            }
        }
        return result;
    }

    public LayoutTurntable findLayoutTurntableByName(String name) {
        LayoutTurntable result = null;
        if (name != null && !name.isEmpty()) {
            for (LayoutTurntable x : this.layoutModels.getLayoutTurntables()) {
                if (!x.getId().equals(name)) continue;
                result = x;
                break;
            }
        }
        return result;
    }

    public LayoutShape findLayoutShapeByName(String name) {
        LayoutShape result = null;
        if (name != null && !name.isEmpty()) {
            for (LayoutShape x : this.layoutModels.getLayoutShapes()) {
                if (!x.getName().equals(name)) continue;
                result = x;
                break;
            }
        }
        return result;
    }

    @Deprecated
    public LayoutTrack findObjectByTypeAndName(HitPointType type, String name) {
        if (name.isEmpty()) {
            return null;
        }
        switch (type) {
            case NONE: {
                return null;
            }
            case POS_POINT: {
                return this.findPositionablePointByName(name);
            }
            case TURNOUT_A: 
            case TURNOUT_B: 
            case TURNOUT_C: 
            case TURNOUT_D: {
                return this.findLayoutTurnoutByName(name);
            }
            case LEVEL_XING_A: 
            case LEVEL_XING_B: 
            case LEVEL_XING_C: 
            case LEVEL_XING_D: {
                return this.findLevelXingByName(name);
            }
            case SLIP_A: 
            case SLIP_B: 
            case SLIP_C: 
            case SLIP_D: {
                return this.findLayoutSlipByName(name);
            }
            case TRACK: {
                return this.findTrackSegmentByName(name);
            }
        }
        if (HitPointType.isTurntableRayHitType(type)) {
            return this.findLayoutTurntableByName(name);
        }
        log.error("did not find Object '{}' of type {}", (Object)name, (Object)type);
        return null;
    }

    public LayoutTrack findObjectByName(String name) {
        LayoutTrack result = null;
        if (name != null && !name.isEmpty()) {
            if (name.startsWith("TO")) {
                result = this.findLayoutTurnoutByName(name);
            } else if (name.startsWith("A") || name.startsWith("EB") || name.startsWith("EC") || name.matches("F\\d+-A-\\d+")) {
                result = this.findPositionablePointByName(name);
            } else if (name.startsWith("X")) {
                result = this.findLevelXingByName(name);
            } else if (name.startsWith("SL")) {
                result = this.findLayoutSlipByName(name);
            } else if (name.startsWith("TUR")) {
                result = this.findLayoutTurntableByName(name);
            } else if (name.startsWith("T") || name.matches("F\\d+-S-\\d+")) {
                result = this.findTrackSegmentByName(name);
            } else if (name.endsWith("-EB")) {
                result = this.findPositionablePointByName(name);
            } else {
                log.warn("findObjectByName({}): unknown type name prefix", (Object)name);
            }
            if (result == null) {
                log.debug("findObjectByName({}) returned null", (Object)name);
            }
        }
        return result;
    }

    public String uniqueName(String inPrefix, int inStartIndex) {
        String result;
        int idx = inStartIndex;
        while (true) {
            result = String.format("%s%d", inPrefix, idx);
            if (inPrefix.equals("S") && this.findLayoutShapeByName(result) == null || this.findObjectByName(result) == null) break;
            ++idx;
        }
        return result;
    }

    public String uniqueName(String inPrefix) {
        return this.uniqueName(inPrefix, 1);
    }
}

