/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.NamedBean;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTrackEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackSegmentEditor
extends LayoutTrackEditor {
    private TrackSegmentView trackSegmentView;
    private TrackSegment trackSegment;
    private JmriJFrame editTrackSegmentFrame = null;
    private final JComboBox<String> editTrackSegmentMainlineComboBox = new JComboBox();
    private final JComboBox<String> editTrackSegmentDashedComboBox = new JComboBox();
    private final JCheckBox editTrackSegmentHiddenCheckBox = new JCheckBox(Bundle.getMessage("HideTrack"));
    private final NamedBeanComboBox<Block> editTrackSegmentBlockNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JTextField editTrackSegmentArcTextField = new JTextField(5);
    private JButton editTrackSegmentSegmentEditBlockButton;
    private int editTrackSegmentMainlineTrackIndex;
    private int editTrackSegmentSideTrackIndex;
    private int editTrackSegmentDashedIndex;
    private int editTrackSegmentSolidIndex;
    private boolean editTrackSegmentOpen = false;
    private boolean editTrackSegmentNeedsRedraw = false;
    private static final Logger log = LoggerFactory.getLogger(TrackSegmentEditor.class);

    public TrackSegmentEditor(@Nonnull LayoutEditor layoutEditor) {
        super(layoutEditor);
    }

    @Override
    @InvokeOnGuiThread
    public void editLayoutTrack(@Nonnull LayoutTrackView layoutTrackView) {
        if (layoutTrackView instanceof TrackSegmentView) {
            this.trackSegmentView = (TrackSegmentView)layoutTrackView;
            this.trackSegment = this.trackSegmentView.getTrackSegment();
        } else {
            log.error("editLayoutTrack received type {} content {}", new Object[]{layoutTrackView.getClass(), layoutTrackView, new Exception("traceback")});
        }
        this.sensorList.clear();
        if (this.editTrackSegmentOpen) {
            this.editTrackSegmentFrame.setVisible(true);
        } else if (this.editTrackSegmentFrame == null) {
            this.editTrackSegmentFrame = new JmriJFrame(Bundle.getMessage("EditTrackSegment"), false, true);
            this.editTrackSegmentFrame.addHelpMenu("package.jmri.jmrit.display.EditTrackSegment", true);
            this.editTrackSegmentFrame.setLocation(50, 30);
            Container contentPane = this.editTrackSegmentFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel31 = new JPanel();
            panel31.setLayout(new FlowLayout());
            this.editTrackSegmentDashedComboBox.removeAllItems();
            this.editTrackSegmentDashedComboBox.addItem(Bundle.getMessage("Solid"));
            this.editTrackSegmentSolidIndex = 0;
            this.editTrackSegmentDashedComboBox.addItem(Bundle.getMessage("Dashed"));
            this.editTrackSegmentDashedIndex = 1;
            this.editTrackSegmentDashedComboBox.setToolTipText(Bundle.getMessage("DashedToolTip"));
            JLabel label31a = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("Style")));
            panel31.add(label31a);
            label31a.setLabelFor(this.editTrackSegmentDashedComboBox);
            panel31.add(this.editTrackSegmentDashedComboBox);
            contentPane.add(panel31);
            JPanel panel32 = new JPanel();
            panel32.setLayout(new FlowLayout());
            this.editTrackSegmentMainlineComboBox.removeAllItems();
            this.editTrackSegmentMainlineComboBox.addItem(Bundle.getMessage("Mainline"));
            this.editTrackSegmentMainlineTrackIndex = 0;
            this.editTrackSegmentMainlineComboBox.addItem(Bundle.getMessage("NotMainline"));
            this.editTrackSegmentSideTrackIndex = 1;
            this.editTrackSegmentMainlineComboBox.setToolTipText(Bundle.getMessage("MainlineToolTip"));
            this.editTrackSegmentMainlineComboBox.setName(Bundle.getMessage("Mainline"));
            panel32.add(this.editTrackSegmentMainlineComboBox);
            contentPane.add(panel32);
            JPanel panel33 = new JPanel();
            panel33.setLayout(new FlowLayout());
            this.editTrackSegmentHiddenCheckBox.setToolTipText(Bundle.getMessage("HiddenToolTip"));
            panel33.add(this.editTrackSegmentHiddenCheckBox);
            contentPane.add(panel33);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel blockNameLabel = new JLabel(Bundle.getMessage("BlockID"));
            panel2.add(blockNameLabel);
            blockNameLabel.setLabelFor(this.editTrackSegmentBlockNameComboBox);
            LayoutEditor.setupComboBox(this.editTrackSegmentBlockNameComboBox, false, true, true);
            this.editTrackSegmentBlockNameComboBox.setToolTipText(Bundle.getMessage("EditBlockNameHint"));
            panel2.add(this.editTrackSegmentBlockNameComboBox);
            contentPane.add(panel2);
            JPanel panel20 = new JPanel();
            panel20.setLayout(new FlowLayout());
            JLabel arcLabel = new JLabel(Bundle.getMessage("SetArcAngle"));
            panel20.add(arcLabel);
            arcLabel.setLabelFor(this.editTrackSegmentArcTextField);
            panel20.add(this.editTrackSegmentArcTextField);
            this.editTrackSegmentArcTextField.setToolTipText(Bundle.getMessage("SetArcAngleHint"));
            contentPane.add(panel20);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.editTrackSegmentSegmentEditBlockButton = new JButton(Bundle.getMessage("EditBlock", ""));
            panel5.add(this.editTrackSegmentSegmentEditBlockButton);
            this.editTrackSegmentSegmentEditBlockButton.addActionListener(this::editTrackSegmentEditBlockPressed);
            this.editTrackSegmentSegmentEditBlockButton.setToolTipText(Bundle.getMessage("EditBlockHint", ""));
            this.addDoneCancelButtons(panel5, this.editTrackSegmentFrame.getRootPane(), this::editTracksegmentDonePressed, this::editTrackSegmentCancelPressed);
            contentPane.add(panel5);
        }
        if (this.trackSegment.isMainline()) {
            this.editTrackSegmentMainlineComboBox.setSelectedIndex(this.editTrackSegmentMainlineTrackIndex);
        } else {
            this.editTrackSegmentMainlineComboBox.setSelectedIndex(this.editTrackSegmentSideTrackIndex);
        }
        if (this.trackSegmentView.isDashed()) {
            this.editTrackSegmentDashedComboBox.setSelectedIndex(this.editTrackSegmentDashedIndex);
        } else {
            this.editTrackSegmentDashedComboBox.setSelectedIndex(this.editTrackSegmentSolidIndex);
        }
        this.editTrackSegmentHiddenCheckBox.setSelected(this.trackSegmentView.isHidden());
        Block block = InstanceManager.getDefault(BlockManager.class).getBlock(this.trackSegment.getBlockName());
        this.editTrackSegmentBlockNameComboBox.getEditor().setItem(block);
        this.editTrackSegmentBlockNameComboBox.setEnabled(!this.hasNxSensorPairs(this.trackSegment.getLayoutBlock()));
        if (this.trackSegmentView.isArc() && this.trackSegmentView.isCircle()) {
            this.editTrackSegmentArcTextField.setText("" + this.trackSegmentView.getAngle());
            this.editTrackSegmentArcTextField.setEnabled(true);
        } else {
            this.editTrackSegmentArcTextField.setEnabled(false);
        }
        this.editTrackSegmentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TrackSegmentEditor.this.editTrackSegmentCancelPressed(null);
            }
        });
        this.editTrackSegmentFrame.pack();
        this.editTrackSegmentFrame.setVisible(true);
        this.editTrackSegmentOpen = true;
        this.showSensorMessage();
    }

    @InvokeOnGuiThread
    private void editTrackSegmentEditBlockPressed(ActionEvent a) {
        String newName = this.editTrackSegmentBlockNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (this.trackSegment.getBlockName().isEmpty() || !this.trackSegment.getBlockName().equals(newName)) {
            this.trackSegment.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editTrackSegmentNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.trackSegment.updateBlockInfo();
        }
        if (this.trackSegment.getLayoutBlock() == null) {
            JOptionPane.showMessageDialog(this.editTrackSegmentFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.trackSegment.getLayoutBlock().editLayoutBlock(this.editTrackSegmentFrame);
        this.layoutEditor.setDirty();
        this.editTrackSegmentNeedsRedraw = true;
    }

    @InvokeOnGuiThread
    private void editTracksegmentDonePressed(ActionEvent a) {
        String newName;
        boolean oldDashed = this.trackSegmentView.isDashed();
        this.trackSegmentView.setDashed(this.editTrackSegmentDashedComboBox.getSelectedIndex() == this.editTrackSegmentDashedIndex);
        boolean oldMainline = this.trackSegment.isMainline();
        this.trackSegment.setMainline(this.editTrackSegmentMainlineComboBox.getSelectedIndex() == this.editTrackSegmentMainlineTrackIndex);
        boolean oldHidden = this.trackSegmentView.isHidden();
        this.trackSegmentView.setHidden(this.editTrackSegmentHiddenCheckBox.isSelected());
        if (this.trackSegmentView.isArc()) {
            try {
                double newAngle = Double.parseDouble(this.editTrackSegmentArcTextField.getText());
                this.trackSegmentView.setAngle(newAngle);
                this.editTrackSegmentNeedsRedraw = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.editTrackSegmentArcTextField.setText("" + this.trackSegmentView.getAngle());
            }
        }
        if (oldDashed != this.trackSegmentView.isDashed() || oldMainline != this.trackSegment.isMainline() || oldHidden != this.trackSegmentView.isHidden()) {
            this.editTrackSegmentNeedsRedraw = true;
        }
        if ((newName = this.editTrackSegmentBlockNameComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (this.trackSegment.getBlockName().isEmpty() || !this.trackSegment.getBlockName().equals(newName)) {
            this.trackSegment.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editTrackSegmentNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.trackSegment.updateBlockInfo();
        }
        this.editTrackSegmentOpen = false;
        this.editTrackSegmentFrame.setVisible(false);
        this.editTrackSegmentFrame.dispose();
        this.editTrackSegmentFrame = null;
        if (this.editTrackSegmentNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.editTrackSegmentNeedsRedraw = false;
        }
        this.layoutEditor.setDirty();
    }

    @InvokeOnGuiThread
    private void editTrackSegmentCancelPressed(ActionEvent a) {
        this.editTrackSegmentOpen = false;
        this.editTrackSegmentFrame.setVisible(false);
        this.editTrackSegmentFrame.dispose();
        this.editTrackSegmentFrame = null;
        if (this.editTrackSegmentNeedsRedraw) {
            this.layoutEditor.setDirty();
            this.layoutEditor.redrawPanel();
            this.editTrackSegmentNeedsRedraw = false;
        }
    }
}

