/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InvokeOnGuiThread;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.util.JmriJFrame;

public class MoveSelectionDialog {
    private LayoutEditor layoutEditor = null;
    private JmriJFrame moveSelectionFrame = null;
    private boolean moveSelectionOpen = false;
    private final JTextField xMoveField = new JTextField(6);
    private final JTextField yMoveField = new JTextField(6);
    private JButton moveSelectionDone;
    private JButton moveSelectionCancel;

    public MoveSelectionDialog(@Nonnull LayoutEditor thePanel) {
        this.layoutEditor = thePanel;
    }

    @InvokeOnGuiThread
    public void moveSelection() {
        if (this.moveSelectionOpen) {
            this.moveSelectionFrame.setVisible(true);
            return;
        }
        if (this.moveSelectionFrame == null) {
            this.moveSelectionFrame = new JmriJFrame(Bundle.getMessage("TranslateSelection"));
            this.moveSelectionFrame.addHelpMenu("package.jmri.jmrit.display.TranslateSelection", true);
            this.moveSelectionFrame.setLocation(70, 30);
            Container theContentPane = this.moveSelectionFrame.getContentPane();
            theContentPane.setLayout(new BoxLayout(theContentPane, 3));
            JPanel panel31 = new JPanel();
            panel31.setLayout(new FlowLayout());
            JLabel xMoveLabel = new JLabel(Bundle.getMessage("XTranslateLabel"));
            panel31.add(xMoveLabel);
            xMoveLabel.setLabelFor(this.xMoveField);
            panel31.add(this.xMoveField);
            this.xMoveField.setName("XTranslateLabel");
            this.xMoveField.setToolTipText(Bundle.getMessage("XTranslateHint"));
            theContentPane.add(panel31);
            JPanel panel32 = new JPanel();
            panel32.setLayout(new FlowLayout());
            JLabel yMoveLabel = new JLabel(Bundle.getMessage("YTranslateLabel"));
            panel32.add(yMoveLabel);
            yMoveLabel.setLabelFor(this.yMoveField);
            panel32.add(this.yMoveField);
            this.yMoveField.setName("YTranslateLabel");
            this.yMoveField.setToolTipText(Bundle.getMessage("YTranslateHint"));
            theContentPane.add(panel32);
            JPanel panel33 = new JPanel();
            panel33.setLayout(new FlowLayout());
            JLabel message1Label = new JLabel(Bundle.getMessage("Message3Label"));
            panel33.add(message1Label);
            theContentPane.add(panel33);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.moveSelectionDone = new JButton(Bundle.getMessage("MoveSelection"));
            panel5.add(this.moveSelectionDone);
            this.moveSelectionDone.addActionListener(this::moveSelectionDonePressed);
            this.moveSelectionDone.setToolTipText(Bundle.getMessage("MoveSelectionHint"));
            this.moveSelectionCancel = new JButton(Bundle.getMessage("ButtonCancel"));
            panel5.add(this.moveSelectionCancel);
            this.moveSelectionCancel.addActionListener(event -> this.moveSelectionCancelPressed());
            this.moveSelectionCancel.setToolTipText(Bundle.getMessage("CancelHint", Bundle.getMessage("ButtonCancel")));
            theContentPane.add(panel5);
            JRootPane rootPane = SwingUtilities.getRootPane(this.moveSelectionDone);
            rootPane.setDefaultButton(this.moveSelectionDone);
        }
        this.xMoveField.setText("0");
        this.yMoveField.setText("0");
        this.moveSelectionFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MoveSelectionDialog.this.moveSelectionCancelPressed();
            }
        });
        this.moveSelectionFrame.pack();
        this.moveSelectionFrame.setVisible(true);
        this.moveSelectionOpen = true;
    }

    private void moveSelectionDonePressed(@Nonnull ActionEvent event) {
        String newText = "";
        float xTranslation = 0.0f;
        float yTranslation = 0.0f;
        newText = this.xMoveField.getText().trim();
        try {
            xTranslation = Float.parseFloat(newText);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.moveSelectionFrame, e);
            return;
        }
        newText = this.yMoveField.getText().trim();
        try {
            yTranslation = Float.parseFloat(newText);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.moveSelectionFrame, e);
            return;
        }
        this.layoutEditor.translate(xTranslation, yTranslation);
        this.moveSelectionCancelPressed();
    }

    private void moveSelectionCancelPressed() {
        this.moveSelectionOpen = false;
        this.moveSelectionFrame.setVisible(false);
        this.moveSelectionFrame.dispose();
        this.moveSelectionFrame = null;
    }

    private void showEntryErrorDialog(Component parentComponent, NumberFormatException e) {
        JOptionPane.showMessageDialog(parentComponent, String.format("%s: %s %s", Bundle.getMessage("EntryError"), e, Bundle.getMessage("TryAgain")), Bundle.getMessage("ErrorTitle"), 0);
    }
}

