/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurntableEditor;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.LevelXingView;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelXingEditor
extends LayoutTurntableEditor {
    private LevelXingView levelXingView;
    private LevelXing levelXing;
    private JmriJFrame editLevelXingFrame = null;
    private final JCheckBox editLevelXingHiddenCheckBox = new JCheckBox(Bundle.getMessage("HideCrossing"));
    private final NamedBeanComboBox<Block> editLevelXingBlock1NameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final NamedBeanComboBox<Block> editLevelXingBlock2NameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private JButton editLevelXingBlock1Button;
    private JButton editLevelXingBlock2Button;
    private boolean editLevelXingOpen = false;
    private boolean editLevelXingNeedsRedraw = false;
    private boolean editLevelXingNeedsBlockUpdate = false;
    private static final Logger log = LoggerFactory.getLogger(LevelXingEditor.class);

    public LevelXingEditor(@Nonnull LayoutEditor layoutEditor) {
        super(layoutEditor);
    }

    public void editLayoutTrack(LevelXingView levelXingView) {
        try {
            this.sensorList.clear();
            this.levelXingView = levelXingView;
            this.levelXing = this.levelXingView.getLevelXing();
            if (this.editLevelXingOpen) {
                this.editLevelXingFrame.setVisible(true);
            } else if (this.editLevelXingFrame == null) {
                this.editLevelXingFrame = new JmriJFrame(Bundle.getMessage("EditXing"), false, true);
                this.editLevelXingFrame.addHelpMenu("package.jmri.jmrit.display.EditLevelXing", true);
                this.editLevelXingFrame.setLocation(50, 30);
                Container contentPane = this.editLevelXingFrame.getContentPane();
                contentPane.setLayout(new BoxLayout(contentPane, 1));
                JPanel panel33 = new JPanel();
                panel33.setLayout(new FlowLayout());
                this.editLevelXingHiddenCheckBox.setToolTipText(Bundle.getMessage("HiddenToolTip"));
                panel33.add(this.editLevelXingHiddenCheckBox);
                contentPane.add(panel33);
                JPanel panel1 = new JPanel();
                panel1.setLayout(new FlowLayout());
                JLabel block1NameLabel = new JLabel(Bundle.getMessage("Block_ID", "AC"));
                panel1.add(block1NameLabel);
                block1NameLabel.setLabelFor(this.editLevelXingBlock1NameComboBox);
                panel1.add(this.editLevelXingBlock1NameComboBox);
                this.editLevelXingBlock1NameComboBox.setName("Block AC");
                LayoutEditor.setupComboBox(this.editLevelXingBlock1NameComboBox, false, true, true);
                this.editLevelXingBlock1NameComboBox.setToolTipText(Bundle.getMessage("EditBlockNameHint"));
                contentPane.add(panel1);
                JPanel panel2 = new JPanel();
                panel2.setLayout(new FlowLayout());
                JLabel block2NameLabel = new JLabel(Bundle.getMessage("Block_ID", "BD"));
                panel2.add(block2NameLabel);
                block2NameLabel.setLabelFor(this.editLevelXingBlock2NameComboBox);
                panel2.add(this.editLevelXingBlock2NameComboBox);
                this.editLevelXingBlock2NameComboBox.setName("Block BD");
                LayoutEditor.setupComboBox(this.editLevelXingBlock2NameComboBox, false, true, true);
                this.editLevelXingBlock2NameComboBox.setToolTipText(Bundle.getMessage("EditBlockNameHint"));
                contentPane.add(panel2);
                JPanel panel4 = new JPanel();
                panel4.setLayout(new FlowLayout());
                this.editLevelXingBlock1Button = new JButton(Bundle.getMessage("EditBlock", "AC"));
                panel4.add(this.editLevelXingBlock1Button);
                this.editLevelXingBlock1Button.addActionListener(this::editLevelXingBlockACPressed);
                this.editLevelXingBlock1Button.setToolTipText(Bundle.getMessage("EditBlockHint", ""));
                this.editLevelXingBlock2Button = new JButton(Bundle.getMessage("EditBlock", "BD"));
                panel4.add(this.editLevelXingBlock2Button);
                this.editLevelXingBlock2Button.addActionListener(this::editLevelXingBlockBDPressed);
                this.editLevelXingBlock2Button.setToolTipText(Bundle.getMessage("EditBlockHint", ""));
                contentPane.add(panel4);
                JPanel panel5 = new JPanel();
                panel5.setLayout(new FlowLayout());
                this.addDoneCancelButtons(panel5, this.editLevelXingFrame.getRootPane(), this::editLevelXingDonePressed, this::editLevelXingCancelPressed);
                contentPane.add(panel5);
            }
            this.editLevelXingHiddenCheckBox.setSelected(levelXingView.isHidden());
            BlockManager bm = InstanceManager.getDefault(BlockManager.class);
            this.editLevelXingBlock1NameComboBox.getEditor().setItem(bm.getBlock(this.levelXing.getBlockNameAC()));
            this.editLevelXingBlock2NameComboBox.getEditor().setItem(bm.getBlock(this.levelXing.getBlockNameBD()));
            this.editLevelXingBlock1NameComboBox.setEnabled(!this.hasNxSensorPairs(this.levelXing.getLayoutBlockAC()));
            this.editLevelXingBlock2NameComboBox.setEnabled(!this.hasNxSensorPairs(this.levelXing.getLayoutBlockBD()));
            this.editLevelXingFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    LevelXingEditor.this.editLevelXingCancelPressed(null);
                }
            });
            this.editLevelXingFrame.pack();
            this.editLevelXingFrame.setVisible(true);
            this.editLevelXingOpen = true;
            this.editLevelXingNeedsBlockUpdate = false;
            this.showSensorMessage();
        }
        catch (Throwable t) {
            log.error("temporary catch for test", t);
        }
    }

    private void editLevelXingBlockACPressed(ActionEvent a) {
        String newName = this.editLevelXingBlock1NameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.levelXing.getBlockNameAC().equals(newName)) {
            this.levelXing.setLayoutBlockAC(this.layoutEditor.provideLayoutBlock(newName));
            this.editLevelXingNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.editLevelXingNeedsBlockUpdate = true;
        }
        if (this.levelXing.getLayoutBlockAC() == null) {
            JOptionPane.showMessageDialog(this.editLevelXingFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.levelXing.getLayoutBlockAC().editLayoutBlock(this.editLevelXingFrame);
        this.editLevelXingNeedsRedraw = true;
    }

    private void editLevelXingBlockBDPressed(ActionEvent a) {
        String newName = this.editLevelXingBlock2NameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.levelXing.getBlockNameBD().equals(newName)) {
            this.levelXing.setLayoutBlockBD(this.layoutEditor.provideLayoutBlock(newName));
            this.editLevelXingNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.editLevelXingNeedsBlockUpdate = true;
        }
        if (this.levelXing.getLayoutBlockBD() == null) {
            JOptionPane.showMessageDialog(this.editLevelXingFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.levelXing.getLayoutBlockBD().editLayoutBlock(this.editLevelXingFrame);
        this.editLevelXingNeedsRedraw = true;
    }

    private void editLevelXingDonePressed(ActionEvent a) {
        String newName = this.editLevelXingBlock1NameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.levelXing.getBlockNameAC().equals(newName)) {
            this.levelXing.setLayoutBlockAC(this.layoutEditor.provideLayoutBlock(newName));
            this.editLevelXingNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.editLevelXingNeedsBlockUpdate = true;
        }
        if ((newName = this.editLevelXingBlock2NameComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (!this.levelXing.getBlockNameBD().equals(newName)) {
            this.levelXing.setLayoutBlockBD(this.layoutEditor.provideLayoutBlock(newName));
            this.editLevelXingNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.editLevelXingNeedsBlockUpdate = true;
        }
        boolean oldHidden = this.levelXingView.isHidden();
        this.levelXingView.setHidden(this.editLevelXingHiddenCheckBox.isSelected());
        if (oldHidden != this.levelXingView.isHidden()) {
            this.editLevelXingNeedsRedraw = true;
        }
        this.editLevelXingOpen = false;
        this.editLevelXingFrame.setVisible(false);
        this.editLevelXingFrame.dispose();
        this.editLevelXingFrame = null;
        if (this.editLevelXingNeedsBlockUpdate) {
            this.levelXing.updateBlockInfo();
        }
        if (this.editLevelXingNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLevelXingNeedsRedraw = false;
        }
    }

    private void editLevelXingCancelPressed(ActionEvent a) {
        this.editLevelXingOpen = false;
        this.editLevelXingFrame.setVisible(false);
        this.editLevelXingFrame.dispose();
        this.editLevelXingFrame = null;
        if (this.editLevelXingNeedsBlockUpdate) {
            this.levelXing.updateBlockInfo();
        }
        if (this.editLevelXingNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLevelXingNeedsRedraw = false;
        }
    }
}

