/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jmri.BlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurnoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutXOverEditor
extends LayoutTurnoutEditor {
    private static final Logger log = LoggerFactory.getLogger(LayoutXOverEditor.class);

    public LayoutXOverEditor(@Nonnull LayoutEditor layoutEditor) {
        super(layoutEditor);
    }

    @Override
    public void editLayoutTrack(@Nonnull LayoutTrackView layoutTrackView) {
        log.trace("LayoutXOverEditor.editLayoutTrack({}) of a {}", (Object)layoutTrackView, layoutTrackView.getClass());
        super.editLayoutTrack(layoutTrackView);
    }

    @Override
    protected void extendAddContinuingStateChoice(Container contentPane) {
    }

    @Override
    protected void extendBlockBCDSetup(Container contentPane) {
        JPanel panel21 = new JPanel();
        panel21.setLayout(new FlowLayout());
        TitledBorder borderblk2 = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        borderblk2.setTitle(String.valueOf(Bundle.getMessage("BeanNameBlock")) + " 2");
        panel21.setBorder(borderblk2);
        LayoutEditor.setupComboBox(this.editLayoutTurnoutBlockBNameComboBox, false, true, true);
        this.editLayoutTurnoutBlockBNameComboBox.setToolTipText(Bundle.getMessage("EditBlockBNameHint"));
        panel21.add(this.editLayoutTurnoutBlockBNameComboBox);
        this.editLayoutTurnoutBlockBButton = new JButton(Bundle.getMessage("CreateEdit"));
        panel21.add(this.editLayoutTurnoutBlockBButton);
        this.editLayoutTurnoutBlockBButton.addActionListener(this::editLayoutTurnoutEditBlockBPressed);
        this.editLayoutTurnoutBlockBButton.setToolTipText(Bundle.getMessage("EditBlockHint", "2"));
        contentPane.add(panel21);
        JPanel panel22 = new JPanel();
        panel22.setLayout(new FlowLayout());
        TitledBorder borderblk3 = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        borderblk3.setTitle(String.valueOf(Bundle.getMessage("BeanNameBlock")) + " 3");
        panel22.setBorder(borderblk3);
        LayoutEditor.setupComboBox(this.editLayoutTurnoutBlockCNameComboBox, false, true, true);
        this.editLayoutTurnoutBlockCNameComboBox.setToolTipText(Bundle.getMessage("EditBlockCNameHint"));
        panel22.add(this.editLayoutTurnoutBlockCNameComboBox);
        this.editLayoutTurnoutBlockCButton = new JButton(Bundle.getMessage("CreateEdit"));
        panel22.add(this.editLayoutTurnoutBlockCButton);
        this.editLayoutTurnoutBlockCButton.addActionListener(this::editLayoutTurnoutEditBlockCPressed);
        this.editLayoutTurnoutBlockCButton.setToolTipText(Bundle.getMessage("EditBlockHint", "3"));
        contentPane.add(panel22);
        JPanel panel23 = new JPanel();
        panel23.setLayout(new FlowLayout());
        TitledBorder borderblk4 = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
        borderblk4.setTitle(String.valueOf(Bundle.getMessage("BeanNameBlock")) + " 4");
        panel23.setBorder(borderblk4);
        LayoutEditor.setupComboBox(this.editLayoutTurnoutBlockDNameComboBox, false, true, true);
        this.editLayoutTurnoutBlockDNameComboBox.setToolTipText(Bundle.getMessage("EditBlockDNameHint"));
        panel23.add(this.editLayoutTurnoutBlockDNameComboBox);
        this.editLayoutTurnoutBlockDButton = new JButton(Bundle.getMessage("CreateEdit"));
        panel23.add(this.editLayoutTurnoutBlockDButton);
        this.editLayoutTurnoutBlockDButton.addActionListener(this::editLayoutTurnoutEditBlockDPressed);
        this.editLayoutTurnoutBlockDButton.setToolTipText(Bundle.getMessage("EditBlockHint", "4"));
        contentPane.add(panel23);
    }

    @Override
    protected void configureCheckBoxes(BlockManager bm) {
        this.editLayoutTurnoutBlockBNameComboBox.getEditor().setItem(bm.getBlock(this.layoutTurnout.getBlockBName()));
        this.editLayoutTurnoutBlockCNameComboBox.getEditor().setItem(bm.getBlock(this.layoutTurnout.getBlockCName()));
        this.editLayoutTurnoutBlockDNameComboBox.getEditor().setItem(bm.getBlock(this.layoutTurnout.getBlockDName()));
        this.editLayoutTurnoutBlockBNameComboBox.setEnabled(!this.hasNxSensorPairs(this.layoutTurnout.getLayoutBlockB()));
        this.editLayoutTurnoutBlockCNameComboBox.setEnabled(!this.hasNxSensorPairs(this.layoutTurnout.getLayoutBlockC()));
        this.editLayoutTurnoutBlockDNameComboBox.setEnabled(!this.hasNxSensorPairs(this.layoutTurnout.getLayoutBlockD()));
    }

    @Override
    protected void setUpForEdit() {
        this.editLayoutTurnoutFrame.setTitle(Bundle.getMessage("EditXover"));
        this.editLayoutTurnoutHiddenCheckBox.setText(Bundle.getMessage("HideXover"));
    }

    @Override
    protected void setUpContinuingSense() {
    }

    @Override
    protected void donePressedSecondTurnoutName(String newName) {
        if (this.layoutEditor.validatePhysicalTurnout(newName, this.editLayoutTurnoutFrame)) {
            this.layoutTurnout.setSecondTurnout(newName);
        } else {
            this.editLayoutTurnout2ndTurnoutCheckBox.setSelected(false);
            this.layoutTurnout.setSecondTurnout("");
            this.editLayoutTurnout2ndTurnoutComboBox.setSelectedItem(null);
        }
        this.editLayoutTurnoutNeedRedraw = true;
    }

    @Override
    protected void setContinuingRouteTurnoutState() {
    }

    @Override
    protected void checkBlock234Changed() {
        String newName = this.editLayoutTurnoutBlockBNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockBName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlockB(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        if ((newName = this.editLayoutTurnoutBlockCNameComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockCName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlockC(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        if ((newName = this.editLayoutTurnoutBlockDNameComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockDName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlockD(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
    }
}

