/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTrackEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTurnoutEditor
extends LayoutTrackEditor {
    protected LayoutTurnoutView layoutTurnoutView = null;
    protected LayoutTurnout layoutTurnout = null;
    protected JmriJFrame editLayoutTurnoutFrame = null;
    protected NamedBeanComboBox<Turnout> editLayoutTurnout1stTurnoutComboBox = null;
    protected NamedBeanComboBox<Turnout> editLayoutTurnout2ndTurnoutComboBox = null;
    protected JLabel editLayoutTurnout2ndTurnoutLabel = null;
    protected final NamedBeanComboBox<Block> editLayoutTurnoutBlockNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected final NamedBeanComboBox<Block> editLayoutTurnoutBlockBNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected final NamedBeanComboBox<Block> editLayoutTurnoutBlockCNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected final NamedBeanComboBox<Block> editLayoutTurnoutBlockDNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    protected final JComboBox<String> editLayoutTurnoutStateComboBox = new JComboBox();
    protected JCheckBox editLayoutTurnoutHiddenCheckBox = null;
    protected JButton editLayoutTurnoutBlockButton;
    protected JButton editLayoutTurnoutBlockBButton;
    protected JButton editLayoutTurnoutBlockCButton;
    protected JButton editLayoutTurnoutBlockDButton;
    protected final JCheckBox editLayoutTurnout2ndTurnoutCheckBox = new JCheckBox(Bundle.getMessage("SupportingTurnout"));
    protected final JCheckBox editLayoutTurnout2ndTurnoutInvertCheckBox = new JCheckBox(Bundle.getMessage("SecondTurnoutInvert"));
    protected boolean editLayoutTurnoutOpen = false;
    protected boolean editLayoutTurnoutNeedRedraw = false;
    protected boolean editLayoutTurnoutNeedsBlockUpdate = false;
    protected int editLayoutTurnoutClosedIndex;
    protected int editLayoutTurnoutThrownIndex;
    private static final Logger log = LoggerFactory.getLogger(LayoutTurnoutEditor.class);

    public LayoutTurnoutEditor(@Nonnull LayoutEditor layoutEditor) {
        super(layoutEditor);
    }

    @Override
    public void editLayoutTrack(@Nonnull LayoutTrackView layoutTrackView) {
        log.trace("LayoutTurnoutEditor.editLayoutTrack({}) of a {}", (Object)layoutTrackView, layoutTrackView.getClass());
        if (layoutTrackView instanceof LayoutTurnoutView) {
            this.layoutTurnoutView = (LayoutTurnoutView)layoutTrackView;
            this.layoutTurnout = this.layoutTurnoutView.getLayoutTurnout();
        } else {
            log.error("editLayoutTrack called with wrong type {}", (Object)this.layoutTurnout, (Object)new Exception("traceback"));
        }
        this.sensorList.clear();
        if (this.editLayoutTurnoutOpen) {
            this.editLayoutTurnoutFrame.setVisible(true);
        } else if (this.editLayoutTurnoutFrame == null) {
            this.editLayoutTurnoutFrame = new JmriJFrame(Bundle.getMessage("EditTurnout"), false, true);
            this.editLayoutTurnoutFrame.addHelpMenu("package.jmri.jmrit.display.EditLayoutTurnout", true);
            this.editLayoutTurnoutFrame.setLocation(50, 30);
            Container contentPane = this.editLayoutTurnoutFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel turnoutNameLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("BeanNameTurnout")));
            panel1.add(turnoutNameLabel);
            this.editLayoutTurnout1stTurnoutComboBox = new NamedBeanComboBox(InstanceManager.getDefault(TurnoutManager.class));
            this.editLayoutTurnout1stTurnoutComboBox.setToolTipText(Bundle.getMessage("EditTurnoutToolTip"));
            LayoutEditor.setupComboBox(this.editLayoutTurnout1stTurnoutComboBox, false, true, false);
            turnoutNameLabel.setLabelFor(this.editLayoutTurnout1stTurnoutComboBox);
            panel1.add(this.editLayoutTurnout1stTurnoutComboBox);
            contentPane.add(panel1);
            JPanel panel1a = new JPanel();
            panel1a.setLayout(new BoxLayout(panel1a, 1));
            this.editLayoutTurnout2ndTurnoutComboBox = new NamedBeanComboBox(InstanceManager.getDefault(TurnoutManager.class));
            this.editLayoutTurnout2ndTurnoutComboBox.setToolTipText(Bundle.getMessage("EditTurnoutToolTip"));
            LayoutEditor.setupComboBox(this.editLayoutTurnout2ndTurnoutComboBox, false, true, false);
            this.editLayoutTurnout2ndTurnoutCheckBox.addActionListener(e -> {
                boolean additionalEnabled = this.editLayoutTurnout2ndTurnoutCheckBox.isSelected();
                this.editLayoutTurnout2ndTurnoutLabel.setEnabled(additionalEnabled);
                this.editLayoutTurnout2ndTurnoutComboBox.setEnabled(additionalEnabled);
                this.editLayoutTurnout2ndTurnoutInvertCheckBox.setEnabled(additionalEnabled);
            });
            panel1a.add(this.editLayoutTurnout2ndTurnoutCheckBox);
            contentPane.add(panel1a);
            this.editLayoutTurnout2ndTurnoutLabel = new JLabel(Bundle.getMessage("Supporting", Bundle.getMessage("BeanNameTurnout")));
            this.editLayoutTurnout2ndTurnoutLabel.setEnabled(false);
            JPanel panel1b = new JPanel();
            panel1b.add(this.editLayoutTurnout2ndTurnoutLabel);
            this.editLayoutTurnout2ndTurnoutLabel.setLabelFor(this.editLayoutTurnout2ndTurnoutComboBox);
            panel1b.add(this.editLayoutTurnout2ndTurnoutComboBox);
            this.editLayoutTurnout2ndTurnoutInvertCheckBox.addActionListener(e -> this.layoutTurnout.setSecondTurnoutInverted(this.editLayoutTurnout2ndTurnoutInvertCheckBox.isSelected()));
            this.editLayoutTurnout2ndTurnoutInvertCheckBox.setEnabled(false);
            panel1b.add(this.editLayoutTurnout2ndTurnoutInvertCheckBox);
            contentPane.add(panel1b);
            this.extendAddContinuingStateChoice(contentPane);
            JPanel panel3a = new JPanel();
            panel3a.setLayout(new FlowLayout());
            this.editLayoutTurnoutHiddenCheckBox = new JCheckBox(Bundle.getMessage("HideTurnout"));
            this.editLayoutTurnoutHiddenCheckBox.setToolTipText(Bundle.getMessage("HiddenToolTip"));
            panel3a.add(this.editLayoutTurnoutHiddenCheckBox);
            contentPane.add(panel3a);
            TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black));
            border.setTitle(Bundle.getMessage("BeanNameBlock"));
            JPanel panel2 = new JPanel();
            panel2.setBorder(border);
            panel2.setLayout(new FlowLayout());
            panel2.add(this.editLayoutTurnoutBlockNameComboBox);
            LayoutEditor.setupComboBox(this.editLayoutTurnoutBlockNameComboBox, false, true, true);
            this.editLayoutTurnoutBlockNameComboBox.setToolTipText(Bundle.getMessage("EditBlockNameHint"));
            this.editLayoutTurnoutBlockButton = new JButton(Bundle.getMessage("CreateEdit"));
            panel2.add(this.editLayoutTurnoutBlockButton);
            this.editLayoutTurnoutBlockButton.setToolTipText(Bundle.getMessage("EditBlockHint", ""));
            this.editLayoutTurnoutBlockButton.addActionListener(this::editLayoutTurnoutEditBlockPressed);
            contentPane.add(panel2);
            this.extendBlockBCDSetup(contentPane);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.addDoneCancelButtons(panel5, this.editLayoutTurnoutFrame.getRootPane(), this::editLayoutTurnoutDonePressed, this::editLayoutTurnoutCancelPressed);
            contentPane.add(panel5);
        }
        this.setUpForEdit();
        this.editLayoutTurnoutHiddenCheckBox.setSelected(this.layoutTurnoutView.isHidden());
        ArrayList<Turnout> currentTurnouts = new ArrayList<Turnout>();
        currentTurnouts.add(this.layoutTurnout.getTurnout());
        currentTurnouts.add(this.layoutTurnout.getSecondTurnout());
        this.editLayoutTurnout1stTurnoutComboBox.setSelectedItem(this.layoutTurnout.getTurnout());
        this.editLayoutTurnout1stTurnoutComboBox.addPopupMenuListener(this.layoutEditor.newTurnoutComboBoxPopupMenuListener(this.editLayoutTurnout1stTurnoutComboBox, currentTurnouts));
        BlockManager bm = InstanceManager.getDefault(BlockManager.class);
        this.editLayoutTurnoutBlockNameComboBox.getEditor().setItem(bm.getBlock(this.layoutTurnout.getBlockName()));
        this.editLayoutTurnoutBlockNameComboBox.setEnabled(!this.hasNxSensorPairs(this.layoutTurnout.getLayoutBlock()));
        this.configureCheckBoxes(bm);
        boolean enable2nd = !this.layoutTurnout.getSecondTurnoutName().isEmpty();
        this.editLayoutTurnout2ndTurnoutCheckBox.setSelected(enable2nd);
        this.editLayoutTurnout2ndTurnoutInvertCheckBox.setEnabled(enable2nd);
        this.editLayoutTurnout2ndTurnoutLabel.setEnabled(enable2nd);
        this.editLayoutTurnout2ndTurnoutComboBox.setEnabled(enable2nd);
        if (enable2nd) {
            this.editLayoutTurnout2ndTurnoutInvertCheckBox.setSelected(this.layoutTurnout.isSecondTurnoutInverted());
            this.editLayoutTurnout2ndTurnoutComboBox.setSelectedItem(this.layoutTurnout.getSecondTurnout());
        } else {
            this.editLayoutTurnout2ndTurnoutInvertCheckBox.setSelected(false);
            this.editLayoutTurnout2ndTurnoutComboBox.setSelectedItem(null);
        }
        this.setUpContinuingSense();
        this.editLayoutTurnoutFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LayoutTurnoutEditor.this.editLayoutTurnoutCancelPressed(null);
            }
        });
        this.editLayoutTurnoutFrame.pack();
        this.editLayoutTurnoutFrame.setVisible(true);
        this.editLayoutTurnoutOpen = true;
        this.editLayoutTurnoutNeedsBlockUpdate = false;
        this.showSensorMessage();
    }

    protected void extendAddContinuingStateChoice(Container contentPane) {
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout());
        this.editLayoutTurnoutStateComboBox.removeAllItems();
        this.editLayoutTurnoutStateComboBox.addItem(InstanceManager.turnoutManagerInstance().getClosedText());
        this.editLayoutTurnoutClosedIndex = 0;
        this.editLayoutTurnoutStateComboBox.addItem(InstanceManager.turnoutManagerInstance().getThrownText());
        this.editLayoutTurnoutThrownIndex = 1;
        this.editLayoutTurnoutStateComboBox.setToolTipText(Bundle.getMessage("StateToolTip"));
        JLabel label3 = new JLabel(Bundle.getMessage("ContinuingState"));
        panel3.add(label3);
        label3.setLabelFor(this.editLayoutTurnoutStateComboBox);
        panel3.add(this.editLayoutTurnoutStateComboBox);
        contentPane.add(panel3);
    }

    protected void extendBlockBCDSetup(Container contentPane) {
    }

    protected void configureCheckBoxes(BlockManager bm) {
        this.editLayoutTurnout2ndTurnoutCheckBox.setText(Bundle.getMessage("ThrowTwoTurnouts"));
    }

    protected void setUpForEdit() {
        this.editLayoutTurnoutFrame.setTitle(Bundle.getMessage("EditTurnout"));
        this.editLayoutTurnoutHiddenCheckBox.setText(Bundle.getMessage("HideTurnout"));
    }

    protected void setUpContinuingSense() {
        if (this.layoutTurnout.getContinuingSense() == 2) {
            this.editLayoutTurnoutStateComboBox.setSelectedIndex(this.editLayoutTurnoutClosedIndex);
        } else {
            this.editLayoutTurnoutStateComboBox.setSelectedIndex(this.editLayoutTurnoutThrownIndex);
        }
    }

    private void editLayoutTurnoutEditBlockPressed(ActionEvent a) {
        String newName = this.editLayoutTurnoutBlockNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        if (this.layoutTurnout.getLayoutBlock() == null) {
            JOptionPane.showMessageDialog(this.editLayoutTurnoutFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutTurnout.getLayoutBlock().editLayoutBlock(this.editLayoutTurnoutFrame);
        this.editLayoutTurnoutNeedRedraw = true;
        this.layoutEditor.setDirty();
    }

    protected void editLayoutTurnoutEditBlockBPressed(ActionEvent a) {
        String newName = this.editLayoutTurnoutBlockBNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockBName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlockB(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        if (this.layoutTurnout.getLayoutBlockB() == null) {
            JOptionPane.showMessageDialog(this.editLayoutTurnoutFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutTurnout.getLayoutBlockB().editLayoutBlock(this.editLayoutTurnoutFrame);
        this.editLayoutTurnoutNeedRedraw = true;
        this.layoutEditor.setDirty();
    }

    protected void editLayoutTurnoutEditBlockCPressed(ActionEvent a) {
        String newName = this.editLayoutTurnoutBlockCNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockCName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlockC(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        if (this.layoutTurnout.getLayoutBlockC() == null) {
            JOptionPane.showMessageDialog(this.editLayoutTurnoutFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutTurnout.getLayoutBlockC().editLayoutBlock(this.editLayoutTurnoutFrame);
        this.editLayoutTurnoutNeedRedraw = true;
        this.layoutEditor.setDirty();
    }

    protected void editLayoutTurnoutEditBlockDPressed(ActionEvent a) {
        String newName = this.editLayoutTurnoutBlockDNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockDName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlockD(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        if (this.layoutTurnout.getLayoutBlockD() == null) {
            JOptionPane.showMessageDialog(this.editLayoutTurnoutFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutTurnout.getLayoutBlockD().editLayoutBlock(this.editLayoutTurnoutFrame);
        this.editLayoutTurnoutNeedRedraw = true;
        this.layoutEditor.setDirty();
    }

    private void editLayoutTurnoutDonePressed(ActionEvent a) {
        String newName = this.editLayoutTurnout1stTurnoutComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getTurnoutName().equals(newName)) {
            if (this.layoutEditor.validatePhysicalTurnout(newName, this.editLayoutTurnoutFrame)) {
                this.layoutTurnout.setTurnout(newName);
            } else {
                this.layoutTurnout.setTurnout("");
                this.editLayoutTurnout1stTurnoutComboBox.setSelectedItem(null);
            }
            this.editLayoutTurnoutNeedRedraw = true;
        }
        if (this.editLayoutTurnout2ndTurnoutCheckBox.isSelected()) {
            newName = this.editLayoutTurnout2ndTurnoutComboBox.getSelectedItemDisplayName();
            if (newName == null) {
                newName = "";
            }
            if (!this.layoutTurnout.getSecondTurnoutName().equals(newName)) {
                this.donePressedSecondTurnoutName(newName);
            }
        } else {
            this.layoutTurnout.setSecondTurnout("");
        }
        if (this.editLayoutTurnout2ndTurnoutCheckBox.isSelected()) {
            int t1state;
            Turnout turnout1 = this.layoutTurnout.getTurnout();
            LayoutTurnout layoutTurnout2 = null;
            int t2state = t1state = 2;
            if (this.layoutTurnout.isSecondTurnoutInverted()) {
                t2state = Turnout.invertTurnoutState(t2state);
            }
            LayoutEditorFindItems lf = this.layoutEditor.getFinder();
            Turnout turnout2 = this.layoutTurnout.getSecondTurnout();
            while (turnout2 != null && turnout1 != turnout2) {
                layoutTurnout2 = lf.findLayoutTurnoutByTurnoutName(turnout2.getSystemName());
                if (layoutTurnout2 == null) {
                    layoutTurnout2 = lf.findLayoutTurnoutByTurnoutName(turnout2.getUserName());
                }
                if (layoutTurnout2 == null) break;
                if (layoutTurnout2.isSecondTurnoutInverted()) {
                    t2state = Turnout.invertTurnoutState(t2state);
                }
                turnout2 = layoutTurnout2.getSecondTurnout();
            }
            if (turnout1 == turnout2 && t1state != t2state) {
                if (layoutTurnout2 != null) {
                    layoutTurnout2.setSecondTurnoutInverted(!layoutTurnout2.isSecondTurnoutInverted());
                    log.warn("layoutTurnout2.setSecondTurnoutInverted() infinite loop prevented.");
                } else {
                    this.layoutTurnout.setSecondTurnoutInverted(!this.layoutTurnout.isSecondTurnoutInverted());
                    log.warn("layoutTurnout.setSecondTurnoutInverted() infinite loop prevented.");
                }
            }
        }
        this.setContinuingRouteTurnoutState();
        newName = this.editLayoutTurnoutBlockNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutTurnout.getBlockName().equals(newName)) {
            this.layoutTurnoutView.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutTurnoutNeedRedraw = true;
            this.editLayoutTurnoutNeedsBlockUpdate = true;
        }
        this.checkBlock234Changed();
        boolean oldHidden = this.layoutTurnoutView.isHidden();
        this.layoutTurnoutView.setHidden(this.editLayoutTurnoutHiddenCheckBox.isSelected());
        if (oldHidden != this.layoutTurnoutView.isHidden()) {
            this.editLayoutTurnoutNeedRedraw = true;
        }
        this.editLayoutTurnoutOpen = false;
        this.editLayoutTurnoutFrame.setVisible(false);
        this.editLayoutTurnoutFrame.dispose();
        this.editLayoutTurnoutFrame = null;
        if (this.editLayoutTurnoutNeedsBlockUpdate) {
            this.layoutTurnout.updateBlockInfo();
            this.layoutTurnout.reCheckBlockBoundary();
        }
        if (this.editLayoutTurnoutNeedRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLayoutTurnoutNeedRedraw = false;
        }
    }

    protected void donePressedSecondTurnoutName(String newName) {
        this.layoutTurnout.setSecondTurnout(newName);
    }

    protected void setContinuingRouteTurnoutState() {
        log.info("LayoutTurnoutEditor#setContinuingRouteTurnoutState should have been overridden in class {} object {}", this.getClass(), (Object)this);
        if (this.layoutTurnout.getTurnoutType() == LayoutTurnout.TurnoutType.RH_TURNOUT || this.layoutTurnout.getTurnoutType() == LayoutTurnout.TurnoutType.LH_TURNOUT || this.layoutTurnout.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT) {
            this.layoutTurnout.setContinuingSense(2);
            if (this.editLayoutTurnoutStateComboBox.getSelectedIndex() == this.editLayoutTurnoutThrownIndex) {
                this.layoutTurnout.setContinuingSense(4);
            }
        }
    }

    protected void checkBlock234Changed() {
    }

    private void editLayoutTurnoutCancelPressed(ActionEvent a) {
        this.editLayoutTurnoutOpen = false;
        this.editLayoutTurnoutFrame.setVisible(false);
        this.editLayoutTurnoutFrame.dispose();
        this.editLayoutTurnoutFrame = null;
        if (this.editLayoutTurnoutNeedsBlockUpdate) {
            this.layoutTurnout.updateBlockInfo();
        }
        if (this.editLayoutTurnoutNeedRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLayoutTurnoutNeedRedraw = false;
        }
    }
}

