/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTurnoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutSlipView;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutSlipEditor
extends LayoutTurnoutEditor {
    private LayoutSlipView layoutSlipView = null;
    private LayoutSlip layoutSlip = null;
    private JmriJFrame editLayoutSlipFrame = null;
    private JButton editLayoutSlipBlockButton;
    private NamedBeanComboBox<Turnout> editLayoutSlipTurnoutAComboBox;
    private NamedBeanComboBox<Turnout> editLayoutSlipTurnoutBComboBox;
    private final JCheckBox editLayoutSlipHiddenBox = new JCheckBox(Bundle.getMessage("HideSlip"));
    private final NamedBeanComboBox<Block> editLayoutSlipBlockNameComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(BlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private boolean editLayoutSlipOpen = false;
    private boolean editLayoutSlipNeedsRedraw = false;
    private boolean editLayoutSlipNeedsBlockUpdate = false;
    private int testState = 1;
    private TestState testPanel;
    private static final Logger log = LoggerFactory.getLogger(LayoutSlipEditor.class);

    public LayoutSlipEditor(@Nonnull LayoutEditor layoutEditor) {
        super(layoutEditor);
    }

    @Override
    public void editLayoutTrack(@Nonnull LayoutTrackView layoutTrackView) {
        if (layoutTrackView instanceof LayoutSlipView) {
            this.layoutSlipView = (LayoutSlipView)layoutTrackView;
            this.layoutSlip = this.layoutSlipView.getSlip();
        } else {
            log.error("editLayoutTrack called with wrong type {}", (Object)layoutTrackView, (Object)new Exception("traceback"));
        }
        this.sensorList.clear();
        if (this.editLayoutSlipOpen) {
            this.editLayoutSlipFrame.setVisible(true);
        } else if (this.editLayoutSlipFrame == null) {
            this.editLayoutSlipFrame = new JmriJFrame(Bundle.getMessage("EditSlip"), false, true);
            this.editLayoutSlipFrame.addHelpMenu("package.jmri.jmrit.display.EditLayoutSlip", true);
            this.editLayoutSlipFrame.setLocation(50, 30);
            Container contentPane = this.editLayoutSlipFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel turnoutNameLabel = new JLabel(String.valueOf(Bundle.getMessage("BeanNameTurnout")) + " A");
            panel1.add(turnoutNameLabel);
            this.editLayoutSlipTurnoutAComboBox = new NamedBeanComboBox(InstanceManager.getDefault(TurnoutManager.class));
            this.editLayoutSlipTurnoutAComboBox.setToolTipText(Bundle.getMessage("EditTurnoutToolTip"));
            LayoutEditor.setupComboBox(this.editLayoutSlipTurnoutAComboBox, false, true, false);
            turnoutNameLabel.setLabelFor(this.editLayoutSlipTurnoutAComboBox);
            panel1.add(this.editLayoutSlipTurnoutAComboBox);
            contentPane.add(panel1);
            JPanel panel1a = new JPanel();
            panel1a.setLayout(new FlowLayout());
            JLabel turnoutBNameLabel = new JLabel(String.valueOf(Bundle.getMessage("BeanNameTurnout")) + " B");
            panel1a.add(turnoutBNameLabel);
            this.editLayoutSlipTurnoutBComboBox = new NamedBeanComboBox(InstanceManager.getDefault(TurnoutManager.class));
            this.editLayoutSlipTurnoutBComboBox.setToolTipText(Bundle.getMessage("EditTurnoutToolTip"));
            LayoutEditor.setupComboBox(this.editLayoutSlipTurnoutBComboBox, false, true, false);
            turnoutBNameLabel.setLabelFor(this.editLayoutSlipTurnoutBComboBox);
            panel1a.add(this.editLayoutSlipTurnoutBComboBox);
            contentPane.add(panel1a);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridLayout(0, 3, 2, 2));
            panel2.add(new Label("   "));
            panel2.add(new Label(String.valueOf(Bundle.getMessage("BeanNameTurnout")) + " A:"));
            panel2.add(new Label(String.valueOf(Bundle.getMessage("BeanNameTurnout")) + " B:"));
            for (Map.Entry<Integer, LayoutSlip.TurnoutState> ts : this.layoutSlip.getTurnoutStates().entrySet()) {
                SampleStates draw = new SampleStates(ts.getKey());
                draw.repaint();
                draw.setPreferredSize(new Dimension(40, 40));
                panel2.add(draw);
                panel2.add(ts.getValue().getComboA());
                panel2.add(ts.getValue().getComboB());
            }
            this.testPanel = new TestState();
            this.testPanel.setSize(40, 40);
            this.testPanel.setPreferredSize(new Dimension(40, 40));
            panel2.add(this.testPanel);
            JButton testButton = new JButton("Test");
            testButton.addActionListener(e -> this.toggleStateTest());
            panel2.add(testButton);
            contentPane.add(panel2);
            JPanel panel33 = new JPanel();
            panel33.setLayout(new FlowLayout());
            this.editLayoutSlipHiddenBox.setToolTipText(Bundle.getMessage("HiddenToolTip"));
            panel33.add(this.editLayoutSlipHiddenBox);
            contentPane.add(panel33);
            JPanel panel3 = new JPanel();
            panel3.setLayout(new FlowLayout());
            JLabel block1NameLabel = new JLabel(Bundle.getMessage("BlockID"));
            panel3.add(block1NameLabel);
            block1NameLabel.setLabelFor(this.editLayoutSlipBlockNameComboBox);
            panel3.add(this.editLayoutSlipBlockNameComboBox);
            LayoutEditor.setupComboBox(this.editLayoutSlipBlockNameComboBox, false, true, true);
            this.editLayoutSlipBlockNameComboBox.setToolTipText(Bundle.getMessage("EditBlockNameHint"));
            contentPane.add(panel3);
            JPanel panel4 = new JPanel();
            panel4.setLayout(new FlowLayout());
            this.editLayoutSlipBlockButton = new JButton(Bundle.getMessage("EditBlock", ""));
            panel4.add(this.editLayoutSlipBlockButton);
            this.editLayoutSlipBlockButton.addActionListener(this::editLayoutSlipEditBlockPressed);
            this.editLayoutSlipBlockButton.setToolTipText(Bundle.getMessage("EditBlockHint", ""));
            contentPane.add(panel4);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.addDoneCancelButtons(panel5, this.editLayoutSlipFrame.getRootPane(), this::editLayoutSlipDonePressed, this::editLayoutSlipCancelPressed);
            contentPane.add(panel5);
        }
        this.editLayoutSlipHiddenBox.setSelected(this.layoutSlipView.isHidden());
        ArrayList<Turnout> currentTurnouts = new ArrayList<Turnout>();
        currentTurnouts.add(this.layoutSlip.getTurnout());
        currentTurnouts.add(this.layoutSlip.getTurnoutB());
        this.editLayoutSlipTurnoutAComboBox.setSelectedItem(this.layoutSlip.getTurnout());
        this.editLayoutSlipTurnoutAComboBox.addPopupMenuListener(this.layoutEditor.newTurnoutComboBoxPopupMenuListener(this.editLayoutSlipTurnoutAComboBox, currentTurnouts));
        this.editLayoutSlipTurnoutBComboBox.setSelectedItem(this.layoutSlip.getTurnoutB());
        this.editLayoutSlipTurnoutBComboBox.addPopupMenuListener(this.layoutEditor.newTurnoutComboBoxPopupMenuListener(this.editLayoutSlipTurnoutBComboBox, currentTurnouts));
        BlockManager bm = InstanceManager.getDefault(BlockManager.class);
        this.editLayoutSlipBlockNameComboBox.getEditor().setItem(bm.getBlock(this.layoutSlip.getBlockName()));
        this.editLayoutSlipBlockNameComboBox.setEnabled(!this.hasNxSensorPairs(this.layoutSlip.getLayoutBlock()));
        this.editLayoutSlipFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LayoutSlipEditor.this.editLayoutSlipCancelPressed(null);
            }
        });
        this.editLayoutSlipFrame.pack();
        this.editLayoutSlipFrame.setVisible(true);
        this.editLayoutSlipOpen = true;
        this.editLayoutSlipNeedsBlockUpdate = false;
        this.showSensorMessage();
    }

    private void drawSlipState(Graphics2D g2, int state) {
        Point2D cenP = this.layoutSlipView.getCoordsCenter();
        Point2D A = MathUtil.subtract(this.layoutSlipView.getCoordsA(), cenP);
        Point2D B = MathUtil.subtract(this.layoutSlipView.getCoordsB(), cenP);
        Point2D C = MathUtil.subtract(this.layoutSlipView.getCoordsC(), cenP);
        Point2D D = MathUtil.subtract(this.layoutSlipView.getCoordsD(), cenP);
        Point2D.Double ctrP = new Point2D.Double(20.0, 20.0);
        A = MathUtil.add(MathUtil.normalize(A, 18.0), ctrP);
        B = MathUtil.add(MathUtil.normalize(B, 18.0), ctrP);
        C = MathUtil.add(MathUtil.normalize(C, 18.0), ctrP);
        D = MathUtil.add(MathUtil.normalize(D, 18.0), ctrP);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(2.0f, 0, 1));
        g2.draw(new Line2D.Double(A, MathUtil.oneThirdPoint(A, C)));
        g2.draw(new Line2D.Double(C, MathUtil.oneThirdPoint(C, A)));
        if (state == 2 || state == 4 || state == 1) {
            g2.draw(new Line2D.Double(A, MathUtil.oneThirdPoint(A, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, A)));
            this.drawSlipStatePart1A(g2, state, A, B, C, D);
        } else {
            g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, B)));
        }
        this.drawSlipStatePart2A(g2, state, A, B, C, D);
    }

    protected void drawSlipStatePart1A(Graphics2D g2, int state, Point2D A, Point2D B, Point2D C, Point2D D) {
    }

    protected void drawSlipStatePart1B(Graphics2D g2, int state, Point2D A, Point2D B, Point2D C, Point2D D) {
        g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, C)));
        g2.draw(new Line2D.Double(C, MathUtil.oneThirdPoint(C, B)));
    }

    protected void drawSlipStatePart2A(Graphics2D g2, int state, Point2D A, Point2D B, Point2D C, Point2D D) {
        g2.draw(new Line2D.Double(A, MathUtil.oneThirdPoint(A, D)));
        g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, A)));
        if (state == 6) {
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(A, D));
        } else if (state == 2) {
            g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, B)));
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(A, C));
        } else if (state == 4) {
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(B, D));
        } else if (state == 8) {
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(B, C));
        } else {
            g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, B)));
        }
    }

    protected void drawSlipStatePart2B(Graphics2D g2, int state, Point2D A, Point2D B, Point2D C, Point2D D) {
        if (state == 2) {
            g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, B)));
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(A, C));
        } else if (state == 4) {
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(B, D));
        } else if (state == 6) {
            g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, C)));
            g2.draw(new Line2D.Double(C, MathUtil.oneThirdPoint(C, B)));
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(A, D));
        } else if (state == 8) {
            g2.draw(new Line2D.Double(A, MathUtil.oneThirdPoint(A, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, A)));
            g2.setColor(Color.red);
            g2.draw(new Line2D.Double(B, C));
        } else {
            g2.draw(new Line2D.Double(B, MathUtil.oneThirdPoint(B, D)));
            g2.draw(new Line2D.Double(D, MathUtil.oneThirdPoint(D, B)));
        }
    }

    public void toggleStateTest() {
        switch (this.testState) {
            default: {
                this.testState = 6;
                break;
            }
            case 4: {
                if (this.layoutSlip.getSlipType() == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                    this.testState = 2;
                    break;
                }
                this.testState = 8;
                break;
            }
            case 6: {
                this.testState = 4;
                break;
            }
            case 8: {
                this.testState = 2;
            }
        }
        int turnAState = this.layoutSlip.getTurnoutStates().get(this.testState).getTestTurnoutAState();
        int turnBState = this.layoutSlip.getTurnoutStates().get(this.testState).getTestTurnoutBState();
        if (this.editLayoutSlipTurnoutAComboBox.getSelectedItem() != null) {
            ((Turnout)this.editLayoutSlipTurnoutAComboBox.getSelectedItem()).setCommandedState(turnAState);
        }
        if (this.editLayoutSlipTurnoutBComboBox.getSelectedItem() != null) {
            ((Turnout)this.editLayoutSlipTurnoutBComboBox.getSelectedItem()).setCommandedState(turnBState);
        }
        if (this.testPanel != null) {
            this.testPanel.repaint();
        }
    }

    private void editLayoutSlipEditBlockPressed(ActionEvent a) {
        String newName = this.editLayoutSlipBlockNameComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutSlip.getBlockName().equals(newName)) {
            this.layoutSlipView.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutSlipNeedsRedraw = true;
            this.editLayoutSlipNeedsBlockUpdate = true;
        }
        if (this.layoutSlip.getLayoutBlock() == null) {
            JOptionPane.showMessageDialog(this.editLayoutSlipFrame, Bundle.getMessage("Error1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.layoutSlip.getLayoutBlock().editLayoutBlock(this.editLayoutSlipFrame);
        this.editLayoutSlipNeedsRedraw = true;
        this.layoutEditor.setDirty();
    }

    private void editLayoutSlipDonePressed(ActionEvent a) {
        String newName = this.editLayoutSlipTurnoutAComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (!this.layoutSlip.getTurnoutName().equals(newName)) {
            if (this.layoutEditor.validatePhysicalTurnout(newName, this.editLayoutSlipFrame)) {
                this.layoutSlip.setTurnout(newName);
            } else {
                this.layoutSlip.setTurnout("");
            }
            this.editLayoutSlipNeedsRedraw = true;
        }
        if ((newName = this.editLayoutSlipTurnoutBComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (!this.layoutSlip.getTurnoutBName().equals(newName)) {
            if (this.layoutEditor.validatePhysicalTurnout(newName, this.editLayoutSlipFrame)) {
                this.layoutSlip.setTurnoutB(newName);
            } else {
                this.layoutSlip.setTurnoutB("");
            }
            this.editLayoutSlipNeedsRedraw = true;
        }
        if ((newName = this.editLayoutSlipBlockNameComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (!this.layoutSlip.getBlockName().equals(newName)) {
            this.layoutSlipView.setLayoutBlock(this.layoutEditor.provideLayoutBlock(newName));
            this.editLayoutSlipNeedsRedraw = true;
            this.layoutEditor.getLEAuxTools().setBlockConnectivityChanged();
            this.editLayoutSlipNeedsBlockUpdate = true;
        }
        for (LayoutSlip.TurnoutState ts : this.layoutSlip.getTurnoutStates().values()) {
            ts.updateStatesFromCombo();
        }
        boolean oldHidden = this.layoutSlipView.isHidden();
        this.layoutSlipView.setHidden(this.editLayoutSlipHiddenBox.isSelected());
        if (oldHidden != this.layoutSlipView.isHidden()) {
            this.editLayoutSlipNeedsRedraw = true;
        }
        this.editLayoutSlipOpen = false;
        this.editLayoutSlipFrame.setVisible(false);
        this.editLayoutSlipFrame.dispose();
        this.editLayoutSlipFrame = null;
        if (this.editLayoutSlipNeedsBlockUpdate) {
            this.layoutSlip.updateBlockInfo();
        }
        if (this.editLayoutSlipNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLayoutSlipNeedsRedraw = false;
        }
    }

    private void editLayoutSlipCancelPressed(ActionEvent a) {
        this.editLayoutSlipOpen = false;
        this.editLayoutSlipFrame.setVisible(false);
        this.editLayoutSlipFrame.dispose();
        this.editLayoutSlipFrame = null;
        if (this.editLayoutSlipNeedsBlockUpdate) {
            this.layoutSlip.updateBlockInfo();
        }
        if (this.editLayoutSlipNeedsRedraw) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
            this.editLayoutSlipNeedsRedraw = false;
        }
    }

    class SampleStates
    extends JPanel {
        int state;

        SampleStates(int state) {
            this.state = state;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g instanceof Graphics2D) {
                LayoutSlipEditor.this.drawSlipState((Graphics2D)g, this.state);
            }
        }
    }

    class TestState
    extends JPanel {
        TestState() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g instanceof Graphics2D) {
                LayoutSlipEditor.this.drawSlipState((Graphics2D)g, LayoutSlipEditor.this.testState);
            }
        }
    }
}

