/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor.LayoutEditorDialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.InvokeOnGuiThread;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.MathUtil;

public class EnterGridSizesDialog {
    private LayoutEditor layoutEditor = null;
    private JmriJFrame enterGridSizesFrame = null;
    private boolean enterGridSizesOpen = false;
    private boolean gridSizesChange = false;
    private final JTextField primaryGridSizeField = new JTextField(6);
    private final JTextField secondaryGridSizeField = new JTextField(6);
    private JButton gridSizesDone;
    private JButton gridSizesCancel;

    public EnterGridSizesDialog(@Nonnull LayoutEditor thePanel) {
        this.layoutEditor = thePanel;
    }

    @InvokeOnGuiThread
    public void enterGridSizes() {
        if (this.enterGridSizesOpen) {
            this.enterGridSizesFrame.setVisible(true);
            return;
        }
        if (this.enterGridSizesFrame == null) {
            this.enterGridSizesFrame = new JmriJFrame(Bundle.getMessage("SetGridSizes"));
            this.enterGridSizesFrame.addHelpMenu("package.jmri.jmrit.display.EnterGridSizes", true);
            this.enterGridSizesFrame.setLocation(70, 30);
            Container theContentPane = this.enterGridSizesFrame.getContentPane();
            theContentPane.setLayout(new BoxLayout(theContentPane, 3));
            JPanel panel3 = new JPanel();
            panel3.setLayout(new FlowLayout());
            JLabel primaryGridSizeLabel = new JLabel(Bundle.getMessage("PrimaryGridSize"));
            panel3.add(primaryGridSizeLabel);
            primaryGridSizeLabel.setLabelFor(this.primaryGridSizeField);
            panel3.add(this.primaryGridSizeField);
            this.primaryGridSizeField.setToolTipText(Bundle.getMessage("PrimaryGridSizeHint"));
            theContentPane.add(panel3);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel secondaryGridSizeLabel = new JLabel(Bundle.getMessage("SecondaryGridSize"));
            panel2.add(secondaryGridSizeLabel);
            secondaryGridSizeLabel.setLabelFor(this.secondaryGridSizeField);
            panel2.add(this.secondaryGridSizeField);
            this.secondaryGridSizeField.setName("SecondaryGridSize");
            this.secondaryGridSizeField.setToolTipText(Bundle.getMessage("SecondaryGridSizeHint"));
            theContentPane.add(panel2);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            this.gridSizesDone = new JButton(Bundle.getMessage("ButtonDone"));
            panel5.add(this.gridSizesDone);
            this.gridSizesDone.addActionListener(this::gridSizesDonePressed);
            this.gridSizesDone.setToolTipText(Bundle.getMessage("DoneHint", Bundle.getMessage("ButtonDone")));
            this.gridSizesCancel = new JButton(Bundle.getMessage("ButtonCancel"));
            panel5.add(this.gridSizesCancel);
            this.gridSizesCancel.addActionListener(this::gridSizesCancelPressed);
            this.gridSizesCancel.setToolTipText(Bundle.getMessage("CancelHint", Bundle.getMessage("ButtonCancel")));
            theContentPane.add(panel5);
            JRootPane rootPane = SwingUtilities.getRootPane(this.gridSizesDone);
            rootPane.setDefaultButton(this.gridSizesDone);
        }
        this.primaryGridSizeField.setText(Integer.toString(this.layoutEditor.gContext.getGridSize()));
        this.secondaryGridSizeField.setText(Integer.toString(this.layoutEditor.gContext.getGridSize2nd()));
        this.enterGridSizesFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                EnterGridSizesDialog.this.gridSizesCancelPressed(null);
            }
        });
        this.enterGridSizesFrame.pack();
        this.enterGridSizesFrame.setVisible(true);
        this.gridSizesChange = false;
        this.enterGridSizesOpen = true;
    }

    private void gridSizesDonePressed(@Nonnull ActionEvent event) {
        String newGridSize = "";
        float siz = 0.0f;
        newGridSize = this.secondaryGridSizeField.getText().trim();
        try {
            siz = Float.parseFloat(newGridSize);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.enterGridSizesFrame, e);
            return;
        }
        if ((double)siz < 5.0 || (double)siz > 100.0) {
            JOptionPane.showMessageDialog(this.enterGridSizesFrame, MessageFormat.format(Bundle.getMessage("Error2a"), String.format(" %s ", Float.valueOf(siz))), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        if (!MathUtil.equals(this.layoutEditor.gContext.getGridSize2nd(), siz)) {
            this.layoutEditor.gContext.setGridSize2nd((int)siz);
            this.gridSizesChange = true;
        }
        newGridSize = this.primaryGridSizeField.getText().trim();
        try {
            siz = Float.parseFloat(newGridSize);
        }
        catch (NumberFormatException e) {
            this.showEntryErrorDialog(this.enterGridSizesFrame, e);
            return;
        }
        if (siz < 5.0f || (double)siz > 100.0) {
            JOptionPane.showMessageDialog(this.enterGridSizesFrame, MessageFormat.format(Bundle.getMessage("Error2a"), String.format(" %s ", Float.valueOf(siz))), Bundle.getMessage("ErrorTitle"), 0);
        } else {
            if (!MathUtil.equals(this.layoutEditor.gContext.getGridSize(), siz)) {
                this.layoutEditor.gContext.setGridSize((int)siz);
                this.gridSizesChange = true;
            }
            this.gridSizesCancelPressed(null);
        }
    }

    private void gridSizesCancelPressed(ActionEvent event) {
        this.enterGridSizesOpen = false;
        this.enterGridSizesFrame.setVisible(false);
        this.enterGridSizesFrame.dispose();
        this.enterGridSizesFrame = null;
        if (this.gridSizesChange) {
            this.layoutEditor.redrawPanel();
            this.layoutEditor.setDirty();
        }
    }

    private void showEntryErrorDialog(Component parentComponent, NumberFormatException e) {
        JOptionPane.showMessageDialog(parentComponent, String.format("%s: %s %s", Bundle.getMessage("EntryError"), e, Bundle.getMessage("TryAgain")), Bundle.getMessage("ErrorTitle"), 0);
    }
}

