/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutTurntableView;
import jmri.jmrit.display.layoutEditor.PositionablePointView;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.util.ColorUtil;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LayoutEditorComponent
extends JComponent {
    private final LayoutEditor layoutEditor;
    protected static final RenderingHints antialiasing = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Rectangle2D clipBounds = null;
    private static final Logger log = LoggerFactory.getLogger(LayoutEditorComponent.class);

    protected LayoutEditorComponent(@Nonnull LayoutEditor LayoutEditor2) {
        this.layoutEditor = LayoutEditor2;
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.clipBounds != null && !this.clipBounds.isEmpty() && this.clipBounds.getWidth() > 0.0 && this.clipBounds.getHeight() > 0.0 && !this.clipBounds.equals(g2.getClipBounds())) {
                g2.setClip(this.clipBounds);
            }
            if (this.layoutEditor.getAntialiasingOn()) {
                g2.setRenderingHints(antialiasing);
            }
            if (this.layoutEditor.isEditable()) {
                if (this.layoutEditor.getDrawGrid()) {
                    this.drawPanelGrid(g2);
                }
                this.drawLayoutTracksHidden(g2);
            }
            this.drawShapes(g2, true);
            this.drawTrackSegmentsDashed(g2);
            this.drawLayoutTracksBallast(g2);
            this.drawLayoutTracksTies(g2);
            this.drawLayoutTracksRails(g2);
            this.drawLayoutTracksBlockLines(g2);
            this.drawPositionablePoints(g2, false);
            this.drawPositionablePoints(g2, true);
            this.drawShapes(g2, false);
            this.drawDecorations(g2);
            if (this.layoutEditor.isEditable()) {
                this.drawLayoutTrackEditControls(g2);
                this.drawShapeEditControls(g2);
                this.drawMemoryRects(g2);
                this.drawBlockContentsRects(g2);
                if (this.layoutEditor.allControlling()) {
                    this.drawTurnoutControls(g2);
                }
                this.drawSelectionRect(g2);
                this.highLightSelection(g2);
                this.drawTrackSegmentInProgress(g2);
                this.drawShapeInProgress(g2);
                if (this.layoutEditor.isDrawLayoutTracksLabel()) {
                    this.drawLayoutTracksLabel(g2);
                }
            } else if (this.layoutEditor.getTurnoutCircles() && this.layoutEditor.allControlling()) {
                this.drawTurnoutControls(g2);
            }
        } else {
            log.error("LayoutEditor drawing requires Graphics2D");
        }
    }

    private void drawPanelGrid(Graphics2D g2) {
        Point2D.Double stopPt;
        Point2D.Double startPt;
        int wideMod = this.layoutEditor.gContext.getGridSize() * this.layoutEditor.gContext.getGridSize2nd();
        int wideMin = this.layoutEditor.gContext.getGridSize() / 2;
        int minX = 0;
        int minY = 0;
        int maxX = (int)MathUtil.granulize(this.layoutEditor.gContext.getLayoutWidth(), (double)this.layoutEditor.gContext.getGridSize());
        int maxY = (int)MathUtil.granulize(this.layoutEditor.gContext.getLayoutHeight(), (double)this.layoutEditor.gContext.getGridSize());
        log.debug("drawPanelGrid: minX: {}, minY: {}, maxX: {}, maxY: {}", new Object[]{minX, minY, maxX, maxY});
        BasicStroke narrow = new BasicStroke(1.0f, 1, 1);
        BasicStroke wide = new BasicStroke(2.0f, 1, 1);
        g2.setColor(Color.gray);
        g2.setStroke(narrow);
        int y = minY;
        while (y <= maxY) {
            startPt = new Point2D.Double(minX, y);
            stopPt = new Point2D.Double(maxX, y);
            if (y % wideMod < wideMin) {
                g2.setStroke(wide);
                g2.draw(new Line2D.Double(startPt, stopPt));
                g2.setStroke(narrow);
            } else {
                g2.draw(new Line2D.Double(startPt, stopPt));
            }
            y += this.layoutEditor.gContext.getGridSize();
        }
        int x = minX;
        while (x <= maxX) {
            startPt = new Point2D.Double(x, minY);
            stopPt = new Point2D.Double(x, maxY);
            if (x % wideMod < wideMin) {
                g2.setStroke(wide);
                g2.draw(new Line2D.Double(startPt, stopPt));
                g2.setStroke(narrow);
            } else {
                g2.draw(new Line2D.Double(startPt, stopPt));
            }
            x += this.layoutEditor.gContext.getGridSize();
        }
    }

    private void drawLayoutTracksHidden(Graphics2D g2) {
        LayoutTrackDrawingOptions ltdo = this.layoutEditor.getLayoutTrackDrawingOptions();
        BasicStroke stroke = new BasicStroke(1.0f);
        BasicStroke dashedStroke = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{6.0f, 4.0f}, 0.0f);
        g2.setColor(ltdo.getSideRailColor());
        g2.setStroke(stroke);
        boolean main = false;
        boolean block = false;
        boolean hidden = true;
        boolean dashed = false;
        this.draw1(g2, main, block, hidden, dashed);
        g2.setStroke(dashedStroke);
        dashed = true;
        this.draw1(g2, main, block, hidden, true);
        main = true;
        g2.setColor(ltdo.getMainRailColor());
        g2.setStroke(stroke);
        dashed = false;
        this.draw1(g2, main, block, hidden, false);
        g2.setStroke(dashedStroke);
        dashed = true;
        this.draw1(g2, main, block, hidden, dashed);
    }

    private void drawTrackSegmentsDashed(Graphics2D g2) {
        float railDisplacement;
        float[] dashArray;
        int railWidth;
        LayoutTrackDrawingOptions ltdo = this.layoutEditor.getLayoutTrackDrawingOptions();
        boolean main = false;
        boolean block = false;
        boolean hidden = false;
        boolean dashed = true;
        if (ltdo.getSideRailCount() > 0) {
            railWidth = ltdo.getSideRailWidth();
            dashArray = new float[]{6.0f + (float)railWidth, 4.0f + (float)railWidth};
            g2.setStroke(new BasicStroke(railWidth, 1, 1, 10.0f, dashArray, 0.0f));
            g2.setColor(ltdo.getSideRailColor());
            if ((ltdo.getSideRailCount() & 1) == 1) {
                this.draw1(g2, main, block, hidden, dashed);
            }
            if (ltdo.getSideRailCount() >= 2) {
                railDisplacement = (float)railWidth + (float)ltdo.getSideRailGap() / 2.0f;
                this.draw2(g2, main, railDisplacement, dashed);
            }
        }
        if (ltdo.getMainRailCount() > 0) {
            main = true;
            railWidth = ltdo.getMainRailWidth();
            dashArray = new float[]{6.0f + (float)railWidth, 4.0f + (float)railWidth};
            g2.setStroke(new BasicStroke(railWidth, 1, 1, 10.0f, dashArray, 0.0f));
            g2.setColor(ltdo.getMainRailColor());
            if ((ltdo.getMainRailCount() & 1) == 1) {
                this.draw1(g2, main, block, hidden, dashed);
            }
            if (ltdo.getMainRailCount() >= 2) {
                railDisplacement = (float)railWidth + (float)ltdo.getSideRailGap() / 2.0f;
                this.draw2(g2, main, railDisplacement, dashed);
            }
        }
    }

    private void drawLayoutTracksBallast(Graphics2D g2) {
        LayoutTrackDrawingOptions ltdo = this.layoutEditor.getLayoutTrackDrawingOptions();
        boolean main = false;
        boolean block = false;
        boolean hidden = false;
        boolean dashed = false;
        int ballastWidth = ltdo.getSideBallastWidth();
        if (ballastWidth > 0) {
            g2.setStroke(new BasicStroke(ballastWidth, 1, 1));
            g2.setColor(ltdo.getSideBallastColor());
            this.draw1(g2, main, block, hidden, dashed);
        }
        if ((ballastWidth = ltdo.getMainBallastWidth()) > 0) {
            g2.setStroke(new BasicStroke(ballastWidth, 1, 1));
            g2.setColor(ltdo.getMainBallastColor());
            main = true;
            this.draw1(g2, main, block, hidden, dashed);
        }
    }

    private void drawLayoutTracksTies(Graphics2D g2) {
        LayoutTrackDrawingOptions ltdo = this.layoutEditor.getLayoutTrackDrawingOptions();
        int tieLength = ltdo.getSideTieLength();
        int tieWidth = ltdo.getSideTieWidth();
        int tieGap = ltdo.getSideTieGap();
        if (tieLength > 0 && tieWidth > 0 && tieGap > 0) {
            g2.setStroke(new BasicStroke(tieLength, 0, 2, 10.0f, new float[]{tieWidth, tieGap}, 0.0f));
            g2.setColor(ltdo.getSideTieColor());
            this.draw1(g2, false);
        }
        tieLength = ltdo.getMainTieLength();
        tieWidth = ltdo.getMainTieWidth();
        tieGap = ltdo.getMainTieGap();
        if (tieLength > 0 && tieWidth > 0 && tieGap > 0) {
            g2.setStroke(new BasicStroke(tieLength, 0, 2, 10.0f, new float[]{tieWidth, tieGap}, 0.0f));
            g2.setColor(ltdo.getMainTieColor());
            this.draw1(g2, true);
        }
    }

    private void drawLayoutTracksRails(Graphics2D g2) {
        float railDisplacement;
        LayoutTrackDrawingOptions ltdo = this.layoutEditor.getLayoutTrackDrawingOptions();
        int railWidth = ltdo.getSideRailWidth();
        Color railColor = ltdo.getSideRailColor();
        boolean main = false;
        boolean block = false;
        boolean hidden = false;
        boolean dashed = false;
        if (ltdo.getSideRailCount() > 1) {
            railDisplacement = (float)railWidth + (float)ltdo.getSideRailGap() / 2.0f;
            g2.setStroke(new BasicStroke(railWidth, 0, 1));
            g2.setColor(railColor);
            this.draw2(g2, main, railDisplacement);
        }
        if ((ltdo.getSideRailCount() & 1) == 1) {
            g2.setStroke(new BasicStroke(railWidth, 1, 1));
            g2.setColor(railColor);
            this.draw1(g2, main, block, hidden, dashed);
        }
        main = true;
        railWidth = ltdo.getMainRailWidth();
        railColor = ltdo.getMainRailColor();
        if (ltdo.getMainRailCount() > 1) {
            railDisplacement = (float)railWidth + (float)ltdo.getMainRailGap() / 2.0f;
            g2.setStroke(new BasicStroke(railWidth, 0, 1));
            g2.setColor(railColor);
            this.draw2(g2, main, railDisplacement);
        }
        if ((ltdo.getMainRailCount() & 1) == 1) {
            g2.setStroke(new BasicStroke(railWidth, 1, 1));
            g2.setColor(railColor);
            dashed = false;
            this.draw1(g2, main, block, hidden, dashed);
        }
    }

    private void drawLayoutTracksBlockLines(Graphics2D g2) {
        BasicStroke blockLineStroke;
        LayoutTrackDrawingOptions ltdo = this.layoutEditor.getLayoutTrackDrawingOptions();
        int blockLineWidth = ltdo.getSideBlockLineWidth();
        float[] dashArray = new float[]{6.0f + (float)blockLineWidth, 4.0f + (float)blockLineWidth};
        int dashPercentageX10 = ltdo.getSideBlockLineDashPercentageX10();
        if (dashPercentageX10 > 0) {
            float[] blockLineDashArray = new float[]{dashPercentageX10 + blockLineWidth, 10.0f - (float)dashPercentageX10 + (float)blockLineWidth};
            blockLineStroke = new BasicStroke(blockLineWidth, 1, 1, 10.0f, blockLineDashArray, 0.0f);
            g2.setStroke(blockLineStroke);
        } else {
            blockLineStroke = new BasicStroke(blockLineWidth, 1, 1);
            g2.setStroke(new BasicStroke(blockLineWidth, 1, 1, 10.0f, dashArray, 0.0f));
        }
        boolean main = false;
        boolean block = true;
        boolean hidden = false;
        boolean dashed = true;
        this.draw1(g2, main, block, hidden, dashed);
        g2.setStroke(blockLineStroke);
        dashed = false;
        this.draw1(g2, main, block, hidden, false);
        blockLineWidth = ltdo.getMainBlockLineWidth();
        dashArray = new float[]{6.0f + (float)blockLineWidth, 4.0f + (float)blockLineWidth};
        dashPercentageX10 = ltdo.getMainBlockLineDashPercentageX10();
        if (dashPercentageX10 > 0) {
            float[] blockLineDashArray = new float[]{dashPercentageX10 + blockLineWidth, 10 - dashPercentageX10 + blockLineWidth};
            blockLineStroke = new BasicStroke(blockLineWidth, 1, 1, 10.0f, blockLineDashArray, 0.0f);
            g2.setStroke(blockLineStroke);
        } else {
            blockLineStroke = new BasicStroke(blockLineWidth, 1, 1);
            g2.setStroke(new BasicStroke(blockLineWidth, 1, 1, 10.0f, dashArray, 0.0f));
        }
        main = true;
        dashed = true;
        this.draw1(g2, true, block, hidden, true);
        g2.setStroke(blockLineStroke);
        dashed = false;
        this.draw1(g2, main, block, hidden, dashed);
    }

    private void draw1(Graphics2D g2, boolean isMain, boolean isBlock, boolean isHidden) {
        this.draw1(g2, isMain, isBlock, isHidden, false);
    }

    private void draw1(Graphics2D g2, boolean isMain, boolean isBlock) {
        this.draw1(g2, isMain, isBlock, false);
    }

    private void draw1(Graphics2D g2, boolean isMain) {
        this.draw1(g2, isMain, false);
    }

    private void draw1(Graphics2D g2, boolean isMain, boolean isBlock, boolean isHidden, boolean isDashed) {
        for (LayoutTrackView layoutTrackView : this.layoutEditor.getLayoutTrackViews()) {
            if (layoutTrackView instanceof PositionablePointView || isHidden != layoutTrackView.isHidden()) continue;
            if (layoutTrackView instanceof TrackSegmentView) {
                if (((TrackSegmentView)layoutTrackView).isDashed() != isDashed) continue;
                layoutTrackView.draw1(g2, isMain, isBlock);
                continue;
            }
            if (isDashed) continue;
            layoutTrackView.draw1(g2, isMain, isBlock);
        }
    }

    private void drawPositionablePoints(Graphics2D g2, boolean isMain) {
        for (PositionablePointView positionablePointView : this.layoutEditor.getPositionablePointViews()) {
            positionablePointView.draw1(g2, isMain, false);
        }
    }

    private void draw2(Graphics2D g2, boolean isMain, float railDisplacement) {
        this.draw2(g2, isMain, railDisplacement, false);
    }

    private void draw2(Graphics2D g2, boolean isMain, float railDisplacement, boolean isDashed) {
        for (LayoutTrackView layoutTrackView : this.layoutEditor.getLayoutTrackViews()) {
            if (layoutTrackView instanceof TrackSegmentView) {
                if (((TrackSegmentView)layoutTrackView).isDashed() != isDashed) continue;
                layoutTrackView.draw2(g2, isMain, railDisplacement);
                continue;
            }
            if (isDashed) continue;
            layoutTrackView.draw2(g2, isMain, railDisplacement);
        }
    }

    private void drawDecorations(Graphics2D g2) {
        this.layoutEditor.getLayoutTrackViews().forEach(tr -> tr.drawDecorations(g2));
    }

    private void drawShapes(Graphics2D g2, boolean isBackground) {
        this.layoutEditor.getLayoutShapes().forEach(s -> {
            if (isBackground == s.getLevel() < 3) {
                s.draw(g2);
            }
        });
    }

    private void drawTrackSegmentInProgress(Graphics2D g2) {
        if (this.layoutEditor.isEditable() && this.layoutEditor.beginTrack != null && this.layoutEditor.getLayoutEditorToolBarPanel().trackButton.isSelected()) {
            g2.setColor(this.layoutEditor.defaultTrackColor);
            g2.setStroke(new BasicStroke(this.layoutEditor.gContext.getSidelineTrackWidth(), 0, 1));
            g2.draw(new Line2D.Double(this.layoutEditor.beginLocation, this.layoutEditor.currentLocation));
            Color highlightColor = ColorUtil.setAlpha(Color.red, 0.25);
            Color connectColor = ColorUtil.setAlpha(Color.green, 0.5);
            g2.setColor(highlightColor);
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            for (LayoutTrack lt : this.layoutEditor.getLayoutTracks()) {
                if (lt == this.layoutEditor.beginTrack) continue;
                LayoutTrackView ltv = this.layoutEditor.getLayoutTrackView(lt);
                if (lt == this.layoutEditor.foundTrack) {
                    ltv.highlightUnconnected(g2);
                    g2.setColor(connectColor);
                    ltv.highlightUnconnected(g2, this.layoutEditor.foundHitPointType);
                    g2.setColor(highlightColor);
                    continue;
                }
                ltv.highlightUnconnected(g2);
            }
        }
    }

    private void drawShapeInProgress(Graphics2D g2) {
        if (this.layoutEditor.getLayoutEditorToolBarPanel().shapeButton.isSelected() && this.layoutEditor.selectedObject != null) {
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f, 0, 1));
            g2.draw(new Line2D.Double(this.layoutEditor.beginLocation, this.layoutEditor.currentLocation));
        }
    }

    private void drawLayoutTrackEditControls(Graphics2D g2) {
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        this.layoutEditor.getLayoutTrackViews().forEach(tr -> tr.drawEditControls(g2));
    }

    private void drawShapeEditControls(Graphics2D g2) {
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        this.layoutEditor.getLayoutShapes().forEach(s -> s.drawEditControls(g2));
    }

    private void drawTurnoutControls(Graphics2D g2) {
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        g2.setColor(this.layoutEditor.turnoutCircleColor);
        g2.setBackground(this.layoutEditor.turnoutCircleThrownColor);
        boolean editable = this.layoutEditor.isEditable();
        this.layoutEditor.getLayoutTrackViews().forEach(tr -> {
            if (tr instanceof LayoutTurnoutView) {
                LayoutTurnoutView lt = (LayoutTurnoutView)tr;
                if (editable || !lt.isHidden() && !lt.isDisabled()) {
                    lt.drawTurnoutControls(g2);
                }
            } else if (tr instanceof LayoutTurntableView) {
                LayoutTurntableView lt = (LayoutTurntableView)tr;
                if (editable || !lt.isHidden()) {
                    lt.drawTurnoutControls(g2);
                }
            }
        });
    }

    private void drawSelectionRect(Graphics2D g2) {
        if (this.layoutEditor.selectionActive && this.layoutEditor.selectionWidth != 0.0 && this.layoutEditor.selectionHeight != 0.0) {
            Stroke stroke = g2.getStroke();
            Color color = g2.getColor();
            g2.setColor(new Color(204, 207, 88));
            g2.setStroke(new BasicStroke(3.0f, 0, 1));
            g2.draw(this.layoutEditor.getSelectionRect());
            g2.setColor(color);
            g2.setStroke(stroke);
        } else {
            this.layoutEditor.setSelectRect(null);
        }
    }

    private void drawMemoryRects(Graphics2D g2) {
        g2.setColor(this.layoutEditor.defaultTrackColor);
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        this.layoutEditor.getMemoryLabelList().forEach(l -> g2.draw(new Rectangle2D.Double(l.getX(), l.getY(), l.getSize().width, l.getSize().height)));
    }

    private void drawBlockContentsRects(Graphics2D g2) {
        g2.setColor(this.layoutEditor.defaultTrackColor);
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        this.layoutEditor.getBlockContentsLabelList().forEach(l -> g2.draw(new Rectangle2D.Double(l.getX(), l.getY(), l.getSize().width, l.getSize().height)));
    }

    private void highLightSelection(Graphics2D g) {
        Stroke stroke = g.getStroke();
        Color color = g.getColor();
        g.setColor(new Color(204, 207, 88));
        g.setStroke(new BasicStroke(2.0f));
        this.layoutEditor.getPositionalSelection().forEach(c -> g.drawRect(c.getX(), c.getY(), c.maxWidth(), c.maxHeight()));
        this.layoutEditor._layoutTrackSelection.stream().map(lt -> {
            LayoutTrackView ltv = this.layoutEditor.getLayoutTrackView((LayoutTrack)lt);
            Rectangle2D r = ltv.getBounds();
            if (r.isEmpty()) {
                r = MathUtil.inset(r, -4.0);
            }
            return r;
        }).forEachOrdered(g::draw);
        this.layoutEditor._layoutShapeSelection.stream().map(ls -> {
            Rectangle2D r = ls.getBounds();
            if (r.isEmpty()) {
                r = MathUtil.inset(r, -4.0);
            }
            return r;
        }).forEachOrdered(g::draw);
        g.setColor(color);
        g.setStroke(stroke);
    }

    private void drawLayoutTracksLabel(Graphics2D g) {
        g.setFont(new Font("Monospaced", 1, 12));
        g.setColor(Color.red);
        for (LayoutTrackView layoutTrackView : this.layoutEditor.getLayoutTrackViews()) {
            layoutTrackView.drawLayoutTrackText(g);
        }
    }

    @Override
    public Rectangle getBounds() {
        JComponent targetPanel = this.layoutEditor.getTargetPanel();
        Rectangle targetBounds = targetPanel.getBounds();
        Container parent = this.getParent();
        if (parent != null) {
            Rectangle parentBounds = parent.getBounds();
            Point2D.Double origin = new Point2D.Double(((RectangularShape)targetBounds).getX() - ((RectangularShape)parentBounds).getX(), ((RectangularShape)targetBounds).getY() - ((RectangularShape)parentBounds).getY());
            return new Rectangle((int)((Point2D)origin).getX(), (int)((Point2D)origin).getY(), (int)((RectangularShape)targetBounds).getWidth(), (int)((RectangularShape)targetBounds).getHeight());
        }
        return MathUtil.rectangle2DToRectangle(targetBounds);
    }

    @Override
    public Rectangle getBounds(Rectangle rv) {
        rv.setBounds(this.getBounds());
        return rv;
    }

    @Override
    public int getX() {
        Rectangle bounds = this.getBounds();
        return (int)bounds.getX();
    }

    @Override
    public int getY() {
        Rectangle bounds = this.getBounds();
        return (int)bounds.getY();
    }

    @Override
    public int getWidth() {
        Rectangle bounds = this.getBounds();
        return (int)bounds.getWidth();
    }

    @Override
    public int getHeight() {
        Rectangle bounds = this.getBounds();
        return (int)bounds.getHeight();
    }

    public void setClip(Rectangle2D clipBounds) {
        this.clipBounds = clipBounds;
    }
}

