/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.Block;
import jmri.BlockManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.InvokeOnGuiThread;
import jmri.JmriException;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Reporter;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.TransitManager;
import jmri.Turnout;
import jmri.UserPreferencesManager;
import jmri.configurexml.StoreXmlUserAction;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.dispatcher.DispatcherAction;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.AnalogClock2Display;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.PositionableJComponent;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ReporterIcon;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.SignalMastIcon;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.layoutEditor.BlockContentsIcon;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlip;
import jmri.jmrit.display.layoutEditor.LayoutDoubleSlipView;
import jmri.jmrit.display.layoutEditor.LayoutDoubleXOver;
import jmri.jmrit.display.layoutEditor.LayoutDoubleXOverView;
import jmri.jmrit.display.layoutEditor.LayoutEditorAuxTools;
import jmri.jmrit.display.layoutEditor.LayoutEditorChecks;
import jmri.jmrit.display.layoutEditor.LayoutEditorComponent;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.EnterGridSizesDialog;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.EnterReporterDialog;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.LayoutTrackDrawingOptionsDialog;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.MoveSelectionDialog;
import jmri.jmrit.display.layoutEditor.LayoutEditorDialogs.ScaleTrackDiagramDialog;
import jmri.jmrit.display.layoutEditor.LayoutEditorFindItems;
import jmri.jmrit.display.layoutEditor.LayoutEditorFloatingToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutEditorHorizontalToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutEditorToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutEditorTools;
import jmri.jmrit.display.layoutEditor.LayoutEditorVerticalToolBarPanel;
import jmri.jmrit.display.layoutEditor.LayoutEditorViewContext;
import jmri.jmrit.display.layoutEditor.LayoutLHTurnout;
import jmri.jmrit.display.layoutEditor.LayoutLHTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutLHXOver;
import jmri.jmrit.display.layoutEditor.LayoutLHXOverView;
import jmri.jmrit.display.layoutEditor.LayoutModels;
import jmri.jmrit.display.layoutEditor.LayoutRHTurnout;
import jmri.jmrit.display.layoutEditor.LayoutRHTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutRHXOver;
import jmri.jmrit.display.layoutEditor.LayoutRHXOverView;
import jmri.jmrit.display.layoutEditor.LayoutShape;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlip;
import jmri.jmrit.display.layoutEditor.LayoutSingleSlipView;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutSlipView;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackDrawingOptions;
import jmri.jmrit.display.layoutEditor.LayoutTrackView;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LayoutTurntableView;
import jmri.jmrit.display.layoutEditor.LayoutWye;
import jmri.jmrit.display.layoutEditor.LayoutWyeView;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.LevelXingView;
import jmri.jmrit.display.layoutEditor.MemoryIcon;
import jmri.jmrit.display.layoutEditor.MultiSensorIconFrame;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.PositionablePointView;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.jmrit.display.panelEditor.PanelEditor;
import jmri.jmrit.entryexit.AddEntryExitPairAction;
import jmri.swing.NamedBeanComboBox;
import jmri.util.ColorUtil;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.MathUtil;
import jmri.util.SystemType;
import jmri.util.ThreadingUtil;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriColorChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayoutEditor
extends PanelEditor
implements MouseWheelListener,
LayoutModels {
    private JmriJFrame floatingEditToolBoxFrame = null;
    private JScrollPane floatingEditContentScrollPane = null;
    private JPanel floatEditHelpPanel = null;
    private JPanel editToolBarContainerPanel = null;
    private JScrollPane editToolBarScrollPane = null;
    private JPanel helpBarPanel = null;
    private final JPanel helpBar = new JPanel();
    private final boolean editorUseOldLocSize;
    private LayoutEditorToolBarPanel leToolBarPanel = null;
    private boolean delayedPopupTrigger = false;
    private Point2D currentPoint = new Point2D.Double(100.0, 100.0);
    private Point2D dLoc = new Point2D.Double(0.0, 0.0);
    private int toolbarHeight = 100;
    private int toolbarWidth = 100;
    private TrackSegment newTrack = null;
    private boolean panelChanged = false;
    public static final double SIZE = 3.0;
    public static final double SIZE2 = 6.0;
    public Color turnoutCircleColor = Color.black;
    public Color turnoutCircleThrownColor = Color.black;
    private boolean turnoutFillControlCircles = false;
    private int turnoutCircleSize = 4;
    public double circleRadius = 3.0 * (double)this.getTurnoutCircleSize();
    public double circleDiameter = 2.0 * this.circleRadius;
    public boolean selectionActive = false;
    private double selectionX = 0.0;
    private double selectionY = 0.0;
    public double selectionWidth = 0.0;
    public double selectionHeight = 0.0;
    private JCheckBoxMenuItem editModeCheckBoxMenuItem = null;
    private JRadioButtonMenuItem toolBarSideTopButton = null;
    private JRadioButtonMenuItem toolBarSideLeftButton = null;
    private JRadioButtonMenuItem toolBarSideBottomButton = null;
    private JRadioButtonMenuItem toolBarSideRightButton = null;
    private JRadioButtonMenuItem toolBarSideFloatButton = null;
    private final JCheckBoxMenuItem wideToolBarCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("ToolBarWide"));
    private JCheckBoxMenuItem positionableCheckBoxMenuItem = null;
    private JCheckBoxMenuItem controlCheckBoxMenuItem = null;
    private JCheckBoxMenuItem animationCheckBoxMenuItem = null;
    private JCheckBoxMenuItem showHelpCheckBoxMenuItem = null;
    private JCheckBoxMenuItem showGridCheckBoxMenuItem = null;
    private JCheckBoxMenuItem autoAssignBlocksCheckBoxMenuItem = null;
    private JMenu scrollMenu = null;
    private JRadioButtonMenuItem scrollBothMenuItem = null;
    private JRadioButtonMenuItem scrollNoneMenuItem = null;
    private JRadioButtonMenuItem scrollHorizontalMenuItem = null;
    private JRadioButtonMenuItem scrollVerticalMenuItem = null;
    private JMenu tooltipMenu = null;
    private JRadioButtonMenuItem tooltipAlwaysMenuItem = null;
    private JRadioButtonMenuItem tooltipNoneMenuItem = null;
    private JRadioButtonMenuItem tooltipInEditMenuItem = null;
    private JRadioButtonMenuItem tooltipNotInEditMenuItem = null;
    private JCheckBoxMenuItem pixelsCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("Pixels"));
    private JCheckBoxMenuItem metricCMCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("MetricCM"));
    private JCheckBoxMenuItem englishFeetInchesCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("EnglishFeetInches"));
    private JCheckBoxMenuItem snapToGridOnAddCheckBoxMenuItem = null;
    private JCheckBoxMenuItem snapToGridOnMoveCheckBoxMenuItem = null;
    private JCheckBoxMenuItem antialiasingOnCheckBoxMenuItem = null;
    private JCheckBoxMenuItem drawLayoutTracksLabelCheckBoxMenuItem = null;
    private JCheckBoxMenuItem turnoutCirclesOnCheckBoxMenuItem = null;
    private JCheckBoxMenuItem turnoutDrawUnselectedLegCheckBoxMenuItem = null;
    private JCheckBoxMenuItem turnoutFillControlCirclesCheckBoxMenuItem = null;
    private JCheckBoxMenuItem hideTrackSegmentConstructionLinesCheckBoxMenuItem = null;
    private JCheckBoxMenuItem useDirectTurnoutControlCheckBoxMenuItem = null;
    private ButtonGroup turnoutCircleSizeButtonGroup = null;
    private boolean turnoutDrawUnselectedLeg = true;
    private boolean autoAssignBlocks = false;
    private final JMenu zoomMenu = new JMenu(Bundle.getMessage("MenuZoom"));
    private final JRadioButtonMenuItem zoom025Item = new JRadioButtonMenuItem("x 0.25");
    private final JRadioButtonMenuItem zoom05Item = new JRadioButtonMenuItem("x 0.5");
    private final JRadioButtonMenuItem zoom075Item = new JRadioButtonMenuItem("x 0.75");
    private final JRadioButtonMenuItem noZoomItem = new JRadioButtonMenuItem(Bundle.getMessage("NoZoom"));
    private final JRadioButtonMenuItem zoom15Item = new JRadioButtonMenuItem("x 1.5");
    private final JRadioButtonMenuItem zoom20Item = new JRadioButtonMenuItem("x 2.0");
    private final JRadioButtonMenuItem zoom30Item = new JRadioButtonMenuItem("x 3.0");
    private final JRadioButtonMenuItem zoom40Item = new JRadioButtonMenuItem("x 4.0");
    private final JRadioButtonMenuItem zoom50Item = new JRadioButtonMenuItem("x 5.0");
    private final JRadioButtonMenuItem zoom60Item = new JRadioButtonMenuItem("x 6.0");
    private final JRadioButtonMenuItem zoom70Item = new JRadioButtonMenuItem("x 7.0");
    private final JRadioButtonMenuItem zoom80Item = new JRadioButtonMenuItem("x 8.0");
    private final JMenuItem undoTranslateSelectionMenuItem = new JMenuItem(Bundle.getMessage("UndoTranslateSelection"));
    private final JMenuItem assignBlockToSelectionMenuItem = new JMenuItem(String.valueOf(Bundle.getMessage("AssignBlockToSelectionTitle")) + "...");
    private Point2D startDelta = new Point2D.Double(0.0, 0.0);
    public Object selectedObject = null;
    public Object prevSelectedObject = null;
    private HitPointType selectedHitPointType = HitPointType.NONE;
    public LayoutTrack foundTrack = null;
    public LayoutTrackView foundTrackView = null;
    private Point2D foundLocation = new Point2D.Double(0.0, 0.0);
    public HitPointType foundHitPointType = HitPointType.NONE;
    public LayoutTrack beginTrack = null;
    public Point2D beginLocation = new Point2D.Double(0.0, 0.0);
    private HitPointType beginHitPointType = HitPointType.NONE;
    public Point2D currentLocation = new Point2D.Double(0.0, 0.0);
    private List<AnalogClock2Display> clocks = new ArrayList<AnalogClock2Display>();
    private List<LocoIcon> markerImage = new ArrayList<LocoIcon>();
    private List<MultiSensorIcon> multiSensors = new ArrayList<MultiSensorIcon>();
    private List<PositionableLabel> backgroundImage = new ArrayList<PositionableLabel>();
    private List<PositionableLabel> labelImage = new ArrayList<PositionableLabel>();
    private List<SensorIcon> sensorImage = new ArrayList<SensorIcon>();
    private List<SignalHeadIcon> signalHeadImage = new ArrayList<SignalHeadIcon>();
    private List<BlockContentsIcon> blockContentsLabelList = new ArrayList<BlockContentsIcon>();
    private List<MemoryIcon> memoryLabelList = new ArrayList<MemoryIcon>();
    private List<SensorIcon> sensorList = new ArrayList<SensorIcon>();
    private List<SignalHeadIcon> signalList = new ArrayList<SignalHeadIcon>();
    private List<SignalMastIcon> signalMastList = new ArrayList<SignalMastIcon>();
    public final LayoutEditorViewContext gContext = new LayoutEditorViewContext();
    private final List<LayoutShape> layoutShapes = new ArrayList<LayoutShape>();
    private int numAnchors = 0;
    private int numEndBumpers = 0;
    private int numEdgeConnectors = 0;
    private int numTrackSegments = 0;
    private int numLevelXings = 0;
    private int numLayoutSlips = 0;
    private int numLayoutTurnouts = 0;
    private int numLayoutTurntables = 0;
    private int numShapes = 0;
    private LayoutEditorFindItems finder = new LayoutEditorFindItems(this);
    private Color mainlineTrackColor = Color.DARK_GRAY;
    private Color sidelineTrackColor = Color.DARK_GRAY;
    public Color defaultTrackColor = Color.DARK_GRAY;
    private Color defaultOccupiedTrackColor = Color.red;
    private Color defaultAlternativeTrackColor = Color.white;
    private Color defaultTextColor = Color.black;
    private String layoutName = "";
    private boolean animatingLayout = true;
    private boolean showHelpBar = true;
    private boolean drawGrid = true;
    private boolean snapToGridOnAdd = false;
    private boolean snapToGridOnMove = false;
    private boolean snapToGridInvert = false;
    private boolean antialiasingOn = false;
    private boolean drawLayoutTracksLabel = false;
    private boolean highlightSelectedBlockFlag = false;
    private boolean turnoutCirclesWithoutEditMode = false;
    private boolean tooltipsWithoutEditMode = false;
    private boolean tooltipsInEditMode = true;
    private double turnoutBX = 20.0;
    private double turnoutCX = 20.0;
    private double turnoutWid = 10.0;
    private double xOverLong = 30.0;
    private double xOverHWid = 10.0;
    private double xOverShort = 10.0;
    private boolean useDirectTurnoutControl = false;
    private boolean savedEditMode = true;
    private boolean savedPositionable = true;
    private boolean savedControlLayout = true;
    private boolean savedAnimatingLayout = true;
    private boolean savedShowHelpBar = true;
    private double minZoom = 0.25;
    private final double maxZoom = 8.0;
    private HashMap<String, Integer> stringsToVTCodes = new HashMap();
    private ToolBarSide toolBarSide = ToolBarSide.eTOP;
    private final LayoutEditorComponent layoutEditorComponent = new LayoutEditorComponent(this);
    private LayoutTrackDrawingOptions layoutTrackDrawingOptions = null;
    private JCheckBoxMenuItem skipTurnoutCheckBoxMenuItem = null;
    private AddEntryExitPairAction addEntryExitPairAction = null;
    private MouseWheelListener[] mouseWheelListeners;
    private boolean includedTurnoutSkipped = false;
    boolean openDispatcherOnLoad = false;
    private Rectangle2D undoRect;
    private boolean canUndoMoveSelection = false;
    private Point2D undoDelta = MathUtil.zeroPoint2D;
    private long whenReleased = 0L;
    private boolean awaitingIconChange = false;
    public List<Positionable> _positionableSelection = new ArrayList<Positionable>();
    public List<LayoutTrack> _layoutTrackSelection = new ArrayList<LayoutTrack>();
    public List<LayoutShape> _layoutShapeSelection = new ArrayList<LayoutShape>();
    private boolean noWarnGlobalDelete = false;
    int _prevNumSel = 0;
    private boolean isDragging = false;
    private boolean noWarnPositionablePoint = false;
    private boolean noWarnLayoutTurnout = false;
    private boolean noWarnLevelXing = false;
    private boolean noWarnSlip = false;
    private boolean noWarnTurntable = false;
    private JFileChooser inputFileChooser = null;
    private int multiLocX;
    private int multiLocY;
    private ConnectivityUtil conTools = null;
    private LayoutEditorTools tools = null;
    private LayoutEditorAuxTools auxTools = null;
    private LayoutEditorChecks layoutEditorChecks = null;
    private final List<LayoutTrack> layoutTrackList = new ArrayList<LayoutTrack>();
    private final List<LayoutTrackView> layoutTrackViewList = new ArrayList<LayoutTrackView>();
    private final Map<LayoutTrack, LayoutTrackView> trkToView = new HashMap<LayoutTrack, LayoutTrackView>();
    private final Map<LayoutTrackView, LayoutTrack> viewToTrk = new HashMap<LayoutTrackView, LayoutTrack>();
    List<NamedBeanUsageReport> usageReport;
    private static final Logger log = LoggerFactory.getLogger(LayoutEditor.class);

    @Nonnull
    public LayoutEditorToolBarPanel getLayoutEditorToolBarPanel() {
        return this.leToolBarPanel;
    }

    @Nonnull
    public List<SensorIcon> getSensorList() {
        return this.sensorList;
    }

    @Nonnull
    public List<PositionableLabel> getLabelImageList() {
        return this.labelImage;
    }

    @Nonnull
    public List<BlockContentsIcon> getBlockContentsLabelList() {
        return this.blockContentsLabelList;
    }

    @Nonnull
    public List<MemoryIcon> getMemoryLabelList() {
        return this.memoryLabelList;
    }

    @Nonnull
    public List<SignalHeadIcon> getSignalList() {
        return this.signalList;
    }

    @Nonnull
    public List<SignalMastIcon> getSignalMastList() {
        return this.signalMastList;
    }

    @Nonnull
    public LayoutEditorFindItems getFinder() {
        return this.finder;
    }

    public LayoutEditor() {
        this("My Layout");
    }

    public LayoutEditor(@Nonnull String name) {
        super(name);
        this.setSaveSize(true);
        this.layoutName = name;
        this.editorUseOldLocSize = InstanceManager.getDefault(GuiLafPreferencesManager.class).isEditorUseOldLocSize();
        this.initStringsToVTCodes();
        this.setupToolBar();
        this.setupMenuBar();
        super.setDefaultToolTip(new ToolTip(null, 0, 0, new Font("SansSerif", 0, 12), Color.black, new Color(215, 225, 255), Color.black));
        this.helpBar.setLayout(new BoxLayout(this.helpBar, 3));
        JTextArea helpTextArea1 = new JTextArea(Bundle.getMessage("Help1"));
        this.helpBar.add(helpTextArea1);
        JTextArea helpTextArea2 = new JTextArea(Bundle.getMessage("Help2"));
        this.helpBar.add(helpTextArea2);
        String helpText3 = "";
        switch (SystemType.getType()) {
            case 2: {
                helpText3 = Bundle.getMessage("Help3Mac");
                break;
            }
            case 4: 
            case 5: {
                helpText3 = Bundle.getMessage("Help3Win");
                break;
            }
            default: {
                helpText3 = Bundle.getMessage("Help3");
            }
        }
        JTextArea helpTextArea3 = new JTextArea(helpText3);
        this.helpBar.add(helpTextArea3);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.gContext.setWindowWidth(screenDim.width - 20);
        this.gContext.setWindowHeight(screenDim.height - 120);
        super.setTargetPanel(null, null);
        super.setTargetPanelSize(this.gContext.getWindowWidth(), this.gContext.getWindowHeight());
        this.setSize(screenDim.width, screenDim.height);
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.registerUser(this));
        if (!this.equals(InstanceManager.getDefault(EditorManager.class).get(name))) {
            log.warn("File contains a panel with the same name ({}) as an existing panel", (Object)name);
        }
        this.setFocusable(true);
        this.addKeyListener(this);
        this.resetDirty();
        this.auxTools = this.getLEAuxTools();
        SwingUtilities.invokeLater(() -> {
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> {
                String windowFrameRef = this.getWindowFrameRef();
                Object prefsProp = prefsMgr.getProperty(windowFrameRef, "toolBarSide");
                if (prefsProp != null) {
                    ToolBarSide newToolBarSide = ToolBarSide.getName((String)prefsProp);
                    this.setToolBarSide(newToolBarSide);
                }
                boolean prefsToolBarIsWide = prefsMgr.getSimplePreferenceState(String.valueOf(windowFrameRef) + ".toolBarThin");
                log.debug("{}.toolBarThin is {}", (Object)windowFrameRef, prefsProp);
                this.setToolBarWide(prefsToolBarIsWide);
                boolean prefsShowHelpBar = prefsMgr.getSimplePreferenceState(String.valueOf(windowFrameRef) + ".showHelpBar");
                this.setShowHelpBar(prefsShowHelpBar);
                boolean prefsAntialiasingOn = prefsMgr.getSimplePreferenceState(String.valueOf(windowFrameRef) + ".antialiasingOn");
                this.setAntialiasingOn(prefsAntialiasingOn);
                boolean prefsDrawLayoutTracksLabel = prefsMgr.getSimplePreferenceState(String.valueOf(windowFrameRef) + ".drawLayoutTracksLabel");
                this.setDrawLayoutTracksLabel(prefsDrawLayoutTracksLabel);
                boolean prefsHighlightSelectedBlockFlag = prefsMgr.getSimplePreferenceState(String.valueOf(windowFrameRef) + ".highlightSelectedBlock");
                this.setHighlightSelectedBlock(prefsHighlightSelectedBlockFlag);
            });
            List<Component> componentList = Arrays.asList(this._targetPanel.getComponents());
            if (!componentList.contains(this.layoutEditorComponent)) {
                try {
                    this._targetPanel.remove(this.layoutEditorComponent);
                    this._targetPanel.add((Component)this.layoutEditorComponent, (Object)3);
                    this._targetPanel.moveToFront(this.layoutEditorComponent);
                }
                catch (Exception e) {
                    log.warn("paintTargetPanelBefore: ", (Throwable)e);
                }
            }
        });
    }

    private void setupMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        fileMenu.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("MenuFileMnemonic")));
        menuBar.add(fileMenu);
        StoreXmlUserAction store = new StoreXmlUserAction(Bundle.getMessage("FileMenuItemStore"));
        int primary_modifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        store.putValue("AcceleratorKey", KeyStroke.getKeyStroke(this.stringsToVTCodes.get(Bundle.getMessage("MenuItemStoreAccelerator")), primary_modifier));
        fileMenu.add(store);
        fileMenu.addSeparator();
        JMenuItem deleteItem = new JMenuItem(Bundle.getMessage("DeletePanel"));
        fileMenu.add(deleteItem);
        deleteItem.addActionListener(event -> {
            if (this.deletePanel()) {
                this.dispose();
            }
        });
        this.setJMenuBar(menuBar);
        this.setupOptionMenu(menuBar);
        this.setupToolsMenu(menuBar);
        this.setupZoomMenu(menuBar);
        this.setupMarkerMenu(menuBar);
        this.setupDispatcherMenu(menuBar);
        this.addHelpMenu("package.jmri.jmrit.display.LayoutEditor", true);
    }

    @Override
    public void newPanelDefaults() {
        this.getLayoutTrackDrawingOptions().setMainRailWidth(2);
        this.getLayoutTrackDrawingOptions().setSideRailWidth(1);
        this.setBackgroundColor(this.defaultBackgroundColor);
        JmriColorChooser.addRecentColor(this.defaultTrackColor);
        JmriColorChooser.addRecentColor(this.defaultOccupiedTrackColor);
        JmriColorChooser.addRecentColor(this.defaultAlternativeTrackColor);
        JmriColorChooser.addRecentColor(this.defaultBackgroundColor);
        JmriColorChooser.addRecentColor(this.defaultTextColor);
    }

    private void setupToolBar() {
        boolean toolBarIsVertical;
        Container contentPane = this.getContentPane();
        if (this.editToolBarContainerPanel != null) {
            this.editToolBarContainerPanel.setVisible(false);
            contentPane.remove(this.editToolBarContainerPanel);
        }
        if (this.helpBarPanel != null) {
            contentPane.remove(this.helpBarPanel);
        }
        this.deletefloatingEditToolBoxFrame();
        if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT)) {
            this.createfloatingEditToolBoxFrame();
            this.createFloatingHelpPanel();
            return;
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = toolBarIsVertical = this.toolBarSide.equals((Object)ToolBarSide.eRIGHT) || this.toolBarSide.equals((Object)ToolBarSide.eLEFT);
        if (toolBarIsVertical) {
            this.leToolBarPanel = new LayoutEditorVerticalToolBarPanel(this);
            this.editToolBarScrollPane = new JScrollPane(this.leToolBarPanel);
            this.toolbarWidth = this.editToolBarScrollPane.getPreferredSize().width;
            this.toolbarHeight = screenDim.height;
        } else {
            this.leToolBarPanel = new LayoutEditorHorizontalToolBarPanel(this);
            this.editToolBarScrollPane = new JScrollPane(this.leToolBarPanel);
            this.toolbarWidth = screenDim.width;
            this.toolbarHeight = this.editToolBarScrollPane.getPreferredSize().height;
        }
        this.editToolBarContainerPanel = new JPanel();
        this.editToolBarContainerPanel.setLayout(new BoxLayout(this.editToolBarContainerPanel, 3));
        this.editToolBarContainerPanel.add(this.editToolBarScrollPane);
        this.editToolBarContainerPanel.setMinimumSize(new Dimension(this.toolbarWidth, this.toolbarHeight));
        this.editToolBarContainerPanel.setPreferredSize(new Dimension(this.toolbarWidth, this.toolbarHeight));
        this.helpBarPanel = new JPanel();
        this.helpBarPanel.add(this.helpBar);
        Component[] componentArray = this.helpBar.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextArea) {
                JTextArea j = (JTextArea)c;
                j.setSize(new Dimension(this.toolbarWidth, j.getSize().height));
                j.setLineWrap(toolBarIsVertical);
                j.setWrapStyleWord(toolBarIsVertical);
            }
            ++n2;
        }
        contentPane.setLayout(new BoxLayout(contentPane, toolBarIsVertical ? 2 : 3));
        switch (this.toolBarSide) {
            case eTOP: 
            case eLEFT: {
                contentPane.add((Component)this.editToolBarContainerPanel, 0);
                break;
            }
            case eBOTTOM: 
            case eRIGHT: {
                contentPane.add(this.editToolBarContainerPanel);
                break;
            }
        }
        if (toolBarIsVertical) {
            this.editToolBarContainerPanel.add(this.helpBarPanel);
        } else {
            contentPane.add(this.helpBarPanel);
        }
        this.helpBarPanel.setVisible(this.isEditable() && this.getShowHelpBar());
        this.editToolBarContainerPanel.setVisible(this.isEditable());
    }

    private void createfloatingEditToolBoxFrame() {
        if (this.isEditable() && this.floatingEditToolBoxFrame == null) {
            this.leToolBarPanel = new LayoutEditorFloatingToolBarPanel(this);
            this.floatingEditContentScrollPane = new JScrollPane(this.leToolBarPanel);
            this.floatingEditContentScrollPane.setHorizontalScrollBarPolicy(31);
            this.floatingEditContentScrollPane.setVerticalScrollBarPolicy(20);
            this.floatingEditToolBoxFrame = new JmriJFrame(Bundle.getMessage("ToolBox", this.getLayoutName()));
            this.floatingEditToolBoxFrame.setDefaultCloseOperation(1);
            this.floatingEditToolBoxFrame.setContentPane(this.floatingEditContentScrollPane);
            this.floatingEditToolBoxFrame.pack();
            this.floatingEditToolBoxFrame.setAlwaysOnTop(true);
            this.floatingEditToolBoxFrame.setVisible(true);
        }
    }

    private void deletefloatingEditToolBoxFrame() {
        if (this.floatingEditContentScrollPane != null) {
            this.floatingEditContentScrollPane.removeAll();
            this.floatingEditContentScrollPane = null;
        }
        if (this.floatingEditToolBoxFrame != null) {
            this.floatingEditToolBoxFrame.dispose();
            this.floatingEditToolBoxFrame = null;
        }
    }

    private void createFloatingHelpPanel() {
        if (this.leToolBarPanel instanceof LayoutEditorFloatingToolBarPanel) {
            LayoutEditorFloatingToolBarPanel leftbp = (LayoutEditorFloatingToolBarPanel)this.leToolBarPanel;
            this.floatEditHelpPanel = new JPanel();
            this.leToolBarPanel.add(this.floatEditHelpPanel);
            int tabSectionWidth = (int)leftbp.getPreferredSize().getWidth();
            Component[] componentArray = this.helpBar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JTextArea) {
                    JTextArea j = (JTextArea)c;
                    j.setSize(new Dimension(tabSectionWidth, j.getSize().height));
                    j.setLineWrap(true);
                    j.setWrapStyleWord(true);
                }
                ++n2;
            }
            this.floatEditHelpPanel.setMaximumSize(new Dimension(tabSectionWidth, Integer.MAX_VALUE));
            this.floatEditHelpPanel.add(this.helpBar);
            this.floatEditHelpPanel.setVisible(this.isEditable() && this.getShowHelpBar());
        }
    }

    @Override
    public void init(String name) {
    }

    @Override
    public void initView() {
        this.editModeCheckBoxMenuItem.setSelected(this.isEditable());
        this.positionableCheckBoxMenuItem.setSelected(this.allPositionable());
        this.controlCheckBoxMenuItem.setSelected(this.allControlling());
        if (this.isEditable()) {
            this.setAllShowToolTip(this.tooltipsInEditMode);
        } else {
            this.setAllShowToolTip(this.tooltipsWithoutEditMode);
        }
        this.scrollNoneMenuItem.setSelected(this._scrollState == 0);
        this.scrollBothMenuItem.setSelected(this._scrollState == 1);
        this.scrollHorizontalMenuItem.setSelected(this._scrollState == 2);
        this.scrollVerticalMenuItem.setSelected(this._scrollState == 3);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    @Override
    public void targetWindowClosingEvent(WindowEvent e) {
        boolean save = this.isDirty() || this.savedEditMode != this.isEditable() || this.savedPositionable != this.allPositionable() || this.savedControlLayout != this.allControlling() || this.savedAnimatingLayout != this.isAnimating() || this.savedShowHelpBar != this.getShowHelpBar();
        log.trace("Temp fix to disable CI errors: save = {}", (Object)save);
        this.targetWindowClosing();
    }

    public static void setupComboBox(@Nonnull NamedBeanComboBox<?> inComboBox, boolean inValidateMode, boolean inEnable, boolean inEditable) {
        log.debug("LE setupComboBox called");
        assert (inComboBox != null);
        inComboBox.setEnabled(inEnable);
        inComboBox.setEditable(inEditable);
        inComboBox.setValidatingInput(inValidateMode);
        inComboBox.setSelectedIndex(-1);
        inComboBox.setAllowNull(!inValidateMode);
        JComboBoxUtil.setupComboBoxMaxRows(inComboBox);
        inComboBox.setSelectedIndex(-1);
    }

    private void initStringsToVTCodes() {
        Field[] fields;
        Field[] fieldArray = fields = KeyEvent.class.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName();
            if (name.startsWith("VK")) {
                int code = 0;
                try {
                    code = field.getInt(null);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
                String key = name.substring(3);
                this.stringsToVTCodes.put(key, code);
            }
            ++n2;
        }
    }

    private boolean fixMacBugOn11(ActionEvent event) {
        boolean result = false;
        if (SystemType.isMacOSX() && event.getModifiers() != 0) {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2, 3);
            } else {
                int dot = version.indexOf(".");
                if (dot != -1) {
                    version = version.substring(0, dot);
                }
            }
            int vers = Integer.parseInt(version);
            result = vers == 11 || vers == 12;
        }
        return result;
    }

    private JMenu setupOptionMenu(@Nonnull JMenuBar menuBar) {
        assert (menuBar != null);
        JMenu optionMenu = new JMenu(Bundle.getMessage("MenuOptions"));
        optionMenu.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("OptionsMnemonic")));
        menuBar.add(optionMenu);
        this.editModeCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("EditMode"));
        optionMenu.add(this.editModeCheckBoxMenuItem);
        this.editModeCheckBoxMenuItem.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("EditModeMnemonic")));
        int primary_modifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.editModeCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(Bundle.getMessage("EditModeAccelerator")), primary_modifier));
        this.editModeCheckBoxMenuItem.addActionListener(event -> {
            if (this.fixMacBugOn11(event)) {
                this.editModeCheckBoxMenuItem.setSelected(!this.editModeCheckBoxMenuItem.isSelected());
                return;
            }
            this.setAllEditable(this.editModeCheckBoxMenuItem.isSelected());
            if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT)) {
                if (this.floatEditHelpPanel != null) {
                    this.floatEditHelpPanel.setVisible(this.isEditable() && this.getShowHelpBar());
                }
            } else {
                this.helpBarPanel.setVisible(this.isEditable() && this.getShowHelpBar());
            }
            if (this.isEditable()) {
                this.setAllShowToolTip(this.tooltipsInEditMode);
                if (this.highlightSelectedBlockFlag && !this.highlightBlockInComboBox(this.leToolBarPanel.blockIDComboBox)) {
                    this.highlightBlockInComboBox(this.leToolBarPanel.blockContentsComboBox);
                }
            } else {
                this.setAllShowToolTip(this.tooltipsWithoutEditMode);
                if (this.highlightSelectedBlockFlag) {
                    this.highlightBlock(null);
                }
            }
            this.awaitingIconChange = false;
        });
        this.editModeCheckBoxMenuItem.setSelected(this.isEditable());
        JMenu toolBarMenu = new JMenu(Bundle.getMessage("ToolBar"));
        optionMenu.add(toolBarMenu);
        JMenu toolBarSideMenu = new JMenu(Bundle.getMessage("ToolBarSide"));
        ButtonGroup toolBarSideGroup = new ButtonGroup();
        this.toolBarSideTopButton = new JRadioButtonMenuItem(Bundle.getMessage("ToolBarSideTop"));
        this.toolBarSideTopButton.addActionListener(event -> this.setToolBarSide(ToolBarSide.eTOP));
        this.toolBarSideTopButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eTOP));
        toolBarSideMenu.add(this.toolBarSideTopButton);
        toolBarSideGroup.add(this.toolBarSideTopButton);
        this.toolBarSideLeftButton = new JRadioButtonMenuItem(Bundle.getMessage("ToolBarSideLeft"));
        this.toolBarSideLeftButton.addActionListener(event -> this.setToolBarSide(ToolBarSide.eLEFT));
        this.toolBarSideLeftButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eLEFT));
        toolBarSideMenu.add(this.toolBarSideLeftButton);
        toolBarSideGroup.add(this.toolBarSideLeftButton);
        this.toolBarSideBottomButton = new JRadioButtonMenuItem(Bundle.getMessage("ToolBarSideBottom"));
        this.toolBarSideBottomButton.addActionListener(event -> this.setToolBarSide(ToolBarSide.eBOTTOM));
        this.toolBarSideBottomButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eBOTTOM));
        toolBarSideMenu.add(this.toolBarSideBottomButton);
        toolBarSideGroup.add(this.toolBarSideBottomButton);
        this.toolBarSideRightButton = new JRadioButtonMenuItem(Bundle.getMessage("ToolBarSideRight"));
        this.toolBarSideRightButton.addActionListener(event -> this.setToolBarSide(ToolBarSide.eRIGHT));
        this.toolBarSideRightButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eRIGHT));
        toolBarSideMenu.add(this.toolBarSideRightButton);
        toolBarSideGroup.add(this.toolBarSideRightButton);
        this.toolBarSideFloatButton = new JRadioButtonMenuItem(Bundle.getMessage("ToolBarSideFloat"));
        this.toolBarSideFloatButton.addActionListener(event -> this.setToolBarSide(ToolBarSide.eFLOAT));
        this.toolBarSideFloatButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eFLOAT));
        toolBarSideMenu.add(this.toolBarSideFloatButton);
        toolBarSideGroup.add(this.toolBarSideFloatButton);
        toolBarMenu.add(toolBarSideMenu);
        toolBarMenu.add(this.wideToolBarCheckBoxMenuItem);
        this.wideToolBarCheckBoxMenuItem.addActionListener(event -> this.setToolBarWide(this.wideToolBarCheckBoxMenuItem.isSelected()));
        this.wideToolBarCheckBoxMenuItem.setSelected(this.leToolBarPanel.toolBarIsWide);
        this.wideToolBarCheckBoxMenuItem.setEnabled(this.toolBarSide.equals((Object)ToolBarSide.eTOP) || this.toolBarSide.equals((Object)ToolBarSide.eBOTTOM));
        this.scrollMenu = new JMenu(Bundle.getMessage("ComboBoxScrollable"));
        optionMenu.add(this.scrollMenu);
        ButtonGroup scrollGroup = new ButtonGroup();
        this.scrollBothMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("ScrollBoth"));
        scrollGroup.add(this.scrollBothMenuItem);
        this.scrollMenu.add(this.scrollBothMenuItem);
        this.scrollBothMenuItem.setSelected(this._scrollState == 1);
        this.scrollBothMenuItem.addActionListener(event -> {
            this._scrollState = 1;
            this.setScroll(this._scrollState);
            this.redrawPanel();
        });
        this.scrollNoneMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("ScrollNone"));
        scrollGroup.add(this.scrollNoneMenuItem);
        this.scrollMenu.add(this.scrollNoneMenuItem);
        this.scrollNoneMenuItem.setSelected(this._scrollState == 0);
        this.scrollNoneMenuItem.addActionListener(event -> {
            this._scrollState = 0;
            this.setScroll(this._scrollState);
            this.redrawPanel();
        });
        this.scrollHorizontalMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("ScrollHorizontal"));
        scrollGroup.add(this.scrollHorizontalMenuItem);
        this.scrollMenu.add(this.scrollHorizontalMenuItem);
        this.scrollHorizontalMenuItem.setSelected(this._scrollState == 2);
        this.scrollHorizontalMenuItem.addActionListener(event -> {
            this._scrollState = 2;
            this.setScroll(this._scrollState);
            this.redrawPanel();
        });
        this.scrollVerticalMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("ScrollVertical"));
        scrollGroup.add(this.scrollVerticalMenuItem);
        this.scrollMenu.add(this.scrollVerticalMenuItem);
        this.scrollVerticalMenuItem.setSelected(this._scrollState == 3);
        this.scrollVerticalMenuItem.addActionListener(event -> {
            this._scrollState = 3;
            this.setScroll(this._scrollState);
            this.redrawPanel();
        });
        this.tooltipMenu = new JMenu(Bundle.getMessage("TooltipSubMenu"));
        optionMenu.add(this.tooltipMenu);
        ButtonGroup tooltipGroup = new ButtonGroup();
        this.tooltipNoneMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("TooltipNone"));
        tooltipGroup.add(this.tooltipNoneMenuItem);
        this.tooltipMenu.add(this.tooltipNoneMenuItem);
        this.tooltipNoneMenuItem.setSelected(!this.tooltipsInEditMode && !this.tooltipsWithoutEditMode);
        this.tooltipNoneMenuItem.addActionListener(event -> {
            this.tooltipsInEditMode = false;
            this.tooltipsWithoutEditMode = false;
            this.setAllShowToolTip(false);
        });
        this.tooltipAlwaysMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("TooltipAlways"));
        tooltipGroup.add(this.tooltipAlwaysMenuItem);
        this.tooltipMenu.add(this.tooltipAlwaysMenuItem);
        this.tooltipAlwaysMenuItem.setSelected(this.tooltipsInEditMode && this.tooltipsWithoutEditMode);
        this.tooltipAlwaysMenuItem.addActionListener(event -> {
            this.tooltipsInEditMode = true;
            this.tooltipsWithoutEditMode = true;
            this.setAllShowToolTip(true);
        });
        this.tooltipInEditMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("TooltipEdit"));
        tooltipGroup.add(this.tooltipInEditMenuItem);
        this.tooltipMenu.add(this.tooltipInEditMenuItem);
        this.tooltipInEditMenuItem.setSelected(this.tooltipsInEditMode && !this.tooltipsWithoutEditMode);
        this.tooltipInEditMenuItem.addActionListener(event -> {
            this.tooltipsInEditMode = true;
            this.tooltipsWithoutEditMode = false;
            this.setAllShowToolTip(this.isEditable());
        });
        this.tooltipNotInEditMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("TooltipNotEdit"));
        tooltipGroup.add(this.tooltipNotInEditMenuItem);
        this.tooltipMenu.add(this.tooltipNotInEditMenuItem);
        this.tooltipNotInEditMenuItem.setSelected(!this.tooltipsInEditMode && this.tooltipsWithoutEditMode);
        this.tooltipNotInEditMenuItem.addActionListener(event -> {
            this.tooltipsInEditMode = false;
            this.tooltipsWithoutEditMode = true;
            this.setAllShowToolTip(!this.isEditable());
        });
        this.showHelpCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("ShowEditHelp"));
        optionMenu.add(this.showHelpCheckBoxMenuItem);
        this.showHelpCheckBoxMenuItem.addActionListener(event -> {
            boolean newShowHelpBar = this.showHelpCheckBoxMenuItem.isSelected();
            this.setShowHelpBar(newShowHelpBar);
        });
        this.showHelpCheckBoxMenuItem.setSelected(this.getShowHelpBar());
        this.positionableCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("AllowRepositioning"));
        optionMenu.add(this.positionableCheckBoxMenuItem);
        this.positionableCheckBoxMenuItem.addActionListener(event -> this.setAllPositionable(this.positionableCheckBoxMenuItem.isSelected()));
        this.positionableCheckBoxMenuItem.setSelected(this.allPositionable());
        this.controlCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("AllowLayoutControl"));
        optionMenu.add(this.controlCheckBoxMenuItem);
        this.controlCheckBoxMenuItem.addActionListener(event -> {
            this.setAllControlling(this.controlCheckBoxMenuItem.isSelected());
            this.redrawPanel();
        });
        this.controlCheckBoxMenuItem.setSelected(this.allControlling());
        this.useDirectTurnoutControlCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("UseDirectTurnoutControl"));
        optionMenu.add(this.useDirectTurnoutControlCheckBoxMenuItem);
        this.useDirectTurnoutControlCheckBoxMenuItem.addActionListener(event -> this.setDirectTurnoutControl(this.useDirectTurnoutControlCheckBoxMenuItem.isSelected()));
        this.useDirectTurnoutControlCheckBoxMenuItem.setSelected(this.useDirectTurnoutControl);
        this.antialiasingOnCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("AntialiasingOn"));
        optionMenu.add(this.antialiasingOnCheckBoxMenuItem);
        this.antialiasingOnCheckBoxMenuItem.addActionListener(event -> {
            this.setAntialiasingOn(this.antialiasingOnCheckBoxMenuItem.isSelected());
            this.redrawPanel();
        });
        this.antialiasingOnCheckBoxMenuItem.setSelected(this.antialiasingOn);
        this.drawLayoutTracksLabelCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("DrawLayoutTracksLabel"));
        optionMenu.add(this.drawLayoutTracksLabelCheckBoxMenuItem);
        this.drawLayoutTracksLabelCheckBoxMenuItem.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("DrawLayoutTracksMnemonic")));
        this.drawLayoutTracksLabelCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(Bundle.getMessage("DrawLayoutTracksAccelerator")), primary_modifier));
        this.drawLayoutTracksLabelCheckBoxMenuItem.addActionListener(event -> {
            if (this.fixMacBugOn11(event)) {
                this.drawLayoutTracksLabelCheckBoxMenuItem.setSelected(!this.drawLayoutTracksLabelCheckBoxMenuItem.isSelected());
                return;
            }
            this.setDrawLayoutTracksLabel(this.drawLayoutTracksLabelCheckBoxMenuItem.isSelected());
            this.redrawPanel();
        });
        this.drawLayoutTracksLabelCheckBoxMenuItem.setSelected(this.drawLayoutTracksLabel);
        optionMenu.addSeparator();
        JMenuItem titleItem = new JMenuItem(String.valueOf(Bundle.getMessage("EditTitle")) + "...");
        optionMenu.add(titleItem);
        titleItem.addActionListener(event -> {
            String newName = (String)JOptionPane.showInputDialog(this.getTargetFrame(), Bundle.getMessage("MakeLabel", Bundle.getMessage("EnterTitle")), Bundle.getMessage("EditTitleMessageTitle"), -1, null, null, this.getLayoutName());
            if (newName != null && !newName.equals(this.getLayoutName())) {
                if (InstanceManager.getDefault(EditorManager.class).contains(newName)) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("CanNotRename"), Bundle.getMessage("PanelExist"), 0);
                } else {
                    this.setTitle(newName);
                    this.setLayoutName(newName);
                    this.getLayoutTrackDrawingOptions().setName(newName);
                    this.setDirty();
                    if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT) && this.isEditable()) {
                        this.deletefloatingEditToolBoxFrame();
                        this.createfloatingEditToolBoxFrame();
                        this.createFloatingHelpPanel();
                    }
                }
            }
        });
        JMenuItem backgroundColorMenuItem = new JMenuItem(Bundle.getMessage("SetBackgroundColor", "..."));
        optionMenu.add(backgroundColorMenuItem);
        backgroundColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("SetBackgroundColor", ""), this.defaultBackgroundColor);
            if (desiredColor != null && !this.defaultBackgroundColor.equals(desiredColor)) {
                this.defaultBackgroundColor = desiredColor;
                this.setBackgroundColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        JMenuItem textColorMenuItem = new JMenuItem(Bundle.getMessage("DefaultTextColor", "..."));
        optionMenu.add(textColorMenuItem);
        textColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("DefaultTextColor", ""), this.defaultTextColor);
            if (desiredColor != null && !this.defaultTextColor.equals(desiredColor)) {
                this.setDefaultTextColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        if (this.editorUseOldLocSize) {
            JMenuItem locationItem = new JMenuItem(Bundle.getMessage("SetLocation"));
            optionMenu.add(locationItem);
            locationItem.addActionListener(event -> {
                this.setCurrentPositionAndSize();
                log.debug("Bounds:{}, {}, {}, {}, {}, {}", new Object[]{this.gContext.getUpperLeftX(), this.gContext.getUpperLeftY(), this.gContext.getWindowWidth(), this.gContext.getWindowHeight(), this.gContext.getLayoutWidth(), this.gContext.getLayoutHeight()});
            });
        }
        JMenu optionsAddMenu = new JMenu(Bundle.getMessage("AddMenuTitle"));
        optionMenu.add(optionsAddMenu);
        JMenuItem backgroundItem = new JMenuItem(String.valueOf(Bundle.getMessage("AddBackground")) + "...");
        optionsAddMenu.add(backgroundItem);
        backgroundItem.addActionListener(event -> {
            this.addBackground();
            this.setDirty();
            this.redrawPanel();
        });
        JMenuItem clockItem = new JMenuItem(Bundle.getMessage("AddItem", Bundle.getMessage("FastClock")));
        optionsAddMenu.add(clockItem);
        clockItem.addActionListener(event -> {
            AnalogClock2Display c = this.addClock();
            this.unionToPanelBounds(c.getBounds());
            this.setDirty();
            this.redrawPanel();
        });
        JMenuItem turntableItem = new JMenuItem(Bundle.getMessage("AddTurntable"));
        optionsAddMenu.add(turntableItem);
        turntableItem.addActionListener(event -> {
            Point2D pt = this.windowCenter();
            if (this.selectionActive) {
                pt = MathUtil.midPoint(this.getSelectionRect());
            }
            this.addTurntable(pt);
            this.setDirty();
            this.redrawPanel();
        });
        JMenuItem reporterItem = new JMenuItem(String.valueOf(Bundle.getMessage("AddReporter")) + "...");
        optionsAddMenu.add(reporterItem);
        reporterItem.addActionListener(event -> {
            Point2D pt = this.windowCenter();
            if (this.selectionActive) {
                pt = MathUtil.midPoint(this.getSelectionRect());
            }
            EnterReporterDialog d = new EnterReporterDialog(this);
            d.enterReporter((int)pt.getX(), (int)pt.getY());
            this.setDirty();
            this.redrawPanel();
        });
        JMenu locationMenu = new JMenu(Bundle.getMessage("LocationMenuTitle"));
        optionMenu.add(locationMenu);
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> {
            String windowFrameRef = this.getWindowFrameRef();
            Object prefsProp = prefsMgr.getProperty(windowFrameRef, "LocationFormat");
            if (prefsProp != null) {
                this.getLayoutEditorToolBarPanel().setLocationFormat(LayoutEditorToolBarPanel.LocationFormat.valueOf((String)prefsProp));
            }
        });
        locationMenu.add(this.pixelsCheckBoxMenuItem);
        this.pixelsCheckBoxMenuItem.addActionListener(event -> {
            this.getLayoutEditorToolBarPanel().setLocationFormat(LayoutEditorToolBarPanel.LocationFormat.ePIXELS);
            this.selectLocationFormatCheckBoxMenuItem();
            this.redrawPanel();
        });
        locationMenu.add(this.metricCMCheckBoxMenuItem);
        this.metricCMCheckBoxMenuItem.addActionListener(event -> {
            this.getLayoutEditorToolBarPanel().setLocationFormat(LayoutEditorToolBarPanel.LocationFormat.eMETRIC_CM);
            this.selectLocationFormatCheckBoxMenuItem();
            this.redrawPanel();
        });
        locationMenu.add(this.englishFeetInchesCheckBoxMenuItem);
        this.englishFeetInchesCheckBoxMenuItem.addActionListener(event -> {
            this.getLayoutEditorToolBarPanel().setLocationFormat(LayoutEditorToolBarPanel.LocationFormat.eENGLISH_FEET_INCHES);
            this.selectLocationFormatCheckBoxMenuItem();
            this.redrawPanel();
        });
        this.selectLocationFormatCheckBoxMenuItem();
        JMenu gridMenu = new JMenu(Bundle.getMessage("GridMenuTitle"));
        optionMenu.add(gridMenu);
        this.showGridCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("ShowEditGrid"));
        this.showGridCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(Bundle.getMessage("ShowEditGridAccelerator")), primary_modifier));
        gridMenu.add(this.showGridCheckBoxMenuItem);
        this.showGridCheckBoxMenuItem.addActionListener(event -> {
            if (this.fixMacBugOn11(event)) {
                this.showGridCheckBoxMenuItem.setSelected(!this.showGridCheckBoxMenuItem.isSelected());
                return;
            }
            this.drawGrid = this.showGridCheckBoxMenuItem.isSelected();
            this.redrawPanel();
        });
        this.showGridCheckBoxMenuItem.setSelected(this.getDrawGrid());
        this.snapToGridOnAddCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("SnapToGridOnAdd"));
        this.snapToGridOnAddCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(Bundle.getMessage("SnapToGridOnAddAccelerator")), primary_modifier | 1));
        gridMenu.add(this.snapToGridOnAddCheckBoxMenuItem);
        this.snapToGridOnAddCheckBoxMenuItem.addActionListener(event -> {
            if (this.fixMacBugOn11(event)) {
                this.snapToGridOnAddCheckBoxMenuItem.setSelected(!this.snapToGridOnAddCheckBoxMenuItem.isSelected());
                return;
            }
            this.snapToGridOnAdd = this.snapToGridOnAddCheckBoxMenuItem.isSelected();
            this.redrawPanel();
        });
        this.snapToGridOnAddCheckBoxMenuItem.setSelected(this.snapToGridOnAdd);
        this.snapToGridOnMoveCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("SnapToGridOnMove"));
        this.snapToGridOnMoveCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(Bundle.getMessage("SnapToGridOnMoveAccelerator")), primary_modifier | 1));
        gridMenu.add(this.snapToGridOnMoveCheckBoxMenuItem);
        this.snapToGridOnMoveCheckBoxMenuItem.addActionListener(event -> {
            if (this.fixMacBugOn11(event)) {
                this.snapToGridOnMoveCheckBoxMenuItem.setSelected(!this.snapToGridOnMoveCheckBoxMenuItem.isSelected());
                return;
            }
            this.snapToGridOnMove = this.snapToGridOnMoveCheckBoxMenuItem.isSelected();
            this.redrawPanel();
        });
        this.snapToGridOnMoveCheckBoxMenuItem.setSelected(this.snapToGridOnMove);
        JMenuItem gridSizeItem = new JMenuItem(String.valueOf(Bundle.getMessage("SetGridSizes")) + "...");
        gridMenu.add(gridSizeItem);
        gridSizeItem.addActionListener(event -> {
            EnterGridSizesDialog d = new EnterGridSizesDialog(this);
            d.enterGridSizes();
        });
        JMenu trackMenu = new JMenu(Bundle.getMessage("TrackMenuTitle"));
        optionMenu.add(trackMenu);
        JMenuItem jmi = new JMenuItem(Bundle.getMessage("SetTrackDrawingOptions"));
        trackMenu.add(jmi);
        jmi.setToolTipText(Bundle.getMessage("SetTrackDrawingOptionsToolTip"));
        jmi.addActionListener(event -> {
            LayoutTrackDrawingOptionsDialog ltdod = new LayoutTrackDrawingOptionsDialog(this, true, this.getLayoutTrackDrawingOptions());
            ltdod.setVisible(true);
        });
        JMenu trkColourMenu = new JMenu(Bundle.getMessage("TrackColorSubMenu"));
        trackMenu.add(trkColourMenu);
        JMenuItem trackColorMenuItem = new JMenuItem(Bundle.getMessage("DefaultTrackColor"));
        trkColourMenu.add(trackColorMenuItem);
        trackColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("DefaultTrackColor"), this.defaultTrackColor);
            if (desiredColor != null && !this.defaultTrackColor.equals(desiredColor)) {
                this.setDefaultTrackColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        JMenuItem trackOccupiedColorMenuItem = new JMenuItem(Bundle.getMessage("DefaultOccupiedTrackColor"));
        trkColourMenu.add(trackOccupiedColorMenuItem);
        trackOccupiedColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("DefaultOccupiedTrackColor"), this.defaultOccupiedTrackColor);
            if (desiredColor != null && !this.defaultOccupiedTrackColor.equals(desiredColor)) {
                this.setDefaultOccupiedTrackColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        JMenuItem trackAlternativeColorMenuItem = new JMenuItem(Bundle.getMessage("DefaultAlternativeTrackColor"));
        trkColourMenu.add(trackAlternativeColorMenuItem);
        trackAlternativeColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("DefaultAlternativeTrackColor"), this.defaultAlternativeTrackColor);
            if (desiredColor != null && !this.defaultAlternativeTrackColor.equals(desiredColor)) {
                this.setDefaultAlternativeTrackColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        JMenuItem setAllTracksToDefaultColorsMenuItem = new JMenuItem(Bundle.getMessage("SetAllTracksToDefaultColors"));
        trkColourMenu.add(setAllTracksToDefaultColorsMenuItem);
        setAllTracksToDefaultColorsMenuItem.addActionListener(event -> {
            if (this.setAllTracksToDefaultColors() > 0) {
                this.setDirty();
                this.redrawPanel();
            }
        });
        this.autoAssignBlocksCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("AutoAssignBlock"));
        trackMenu.add(this.autoAssignBlocksCheckBoxMenuItem);
        this.autoAssignBlocksCheckBoxMenuItem.addActionListener(event -> {
            boolean bl = this.autoAssignBlocks = this.autoAssignBlocksCheckBoxMenuItem.isSelected();
        });
        this.autoAssignBlocksCheckBoxMenuItem.setSelected(this.autoAssignBlocks);
        this.hideTrackSegmentConstructionLinesCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("HideTrackConLines"));
        trackMenu.add(this.hideTrackSegmentConstructionLinesCheckBoxMenuItem);
        this.hideTrackSegmentConstructionLinesCheckBoxMenuItem.addActionListener(event -> {
            int show = 1;
            if (this.hideTrackSegmentConstructionLinesCheckBoxMenuItem.isSelected()) {
                show = 4;
            }
            for (TrackSegmentView tsv : this.getTrackSegmentViews()) {
                tsv.hideConstructionLines(show);
            }
            this.redrawPanel();
        });
        this.hideTrackSegmentConstructionLinesCheckBoxMenuItem.setSelected(this.autoAssignBlocks);
        JMenu turnoutOptionsMenu = new JMenu(Bundle.getMessage("TurnoutOptions"));
        optionMenu.add(turnoutOptionsMenu);
        this.animationCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("AllowTurnoutAnimation"));
        turnoutOptionsMenu.add(this.animationCheckBoxMenuItem);
        this.animationCheckBoxMenuItem.addActionListener(event -> {
            boolean mode = this.animationCheckBoxMenuItem.isSelected();
            this.setTurnoutAnimation(mode);
        });
        this.animationCheckBoxMenuItem.setSelected(true);
        this.turnoutCirclesOnCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("TurnoutCirclesOn"));
        turnoutOptionsMenu.add(this.turnoutCirclesOnCheckBoxMenuItem);
        this.turnoutCirclesOnCheckBoxMenuItem.addActionListener(event -> {
            this.turnoutCirclesWithoutEditMode = this.turnoutCirclesOnCheckBoxMenuItem.isSelected();
            this.redrawPanel();
        });
        this.turnoutCirclesOnCheckBoxMenuItem.setSelected(this.turnoutCirclesWithoutEditMode);
        JMenuItem turnoutCircleColorMenuItem = new JMenuItem(Bundle.getMessage("TurnoutCircleColor"));
        turnoutCircleColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("TurnoutCircleColor"), this.turnoutCircleColor);
            if (desiredColor != null && !this.turnoutCircleColor.equals(desiredColor)) {
                this.setTurnoutCircleColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        turnoutOptionsMenu.add(turnoutCircleColorMenuItem);
        JMenuItem turnoutCircleThrownColorMenuItem = new JMenuItem(Bundle.getMessage("TurnoutCircleThrownColor"));
        turnoutCircleThrownColorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("TurnoutCircleThrownColor"), this.turnoutCircleThrownColor);
            if (desiredColor != null && !this.turnoutCircleThrownColor.equals(desiredColor)) {
                this.setTurnoutCircleThrownColor(desiredColor);
                this.setDirty();
                this.redrawPanel();
            }
        });
        turnoutOptionsMenu.add(turnoutCircleThrownColorMenuItem);
        this.turnoutFillControlCirclesCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("TurnoutFillControlCircles"));
        turnoutOptionsMenu.add(this.turnoutFillControlCirclesCheckBoxMenuItem);
        this.turnoutFillControlCirclesCheckBoxMenuItem.addActionListener(event -> {
            this.turnoutFillControlCircles = this.turnoutFillControlCirclesCheckBoxMenuItem.isSelected();
            this.redrawPanel();
        });
        this.turnoutFillControlCirclesCheckBoxMenuItem.setSelected(this.turnoutFillControlCircles);
        JMenu turnoutCircleSizeMenu = new JMenu(Bundle.getMessage("TurnoutCircleSize"));
        this.turnoutCircleSizeButtonGroup = new ButtonGroup();
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "1", 1);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "2", 2);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "3", 3);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "4", 4);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "5", 5);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "6", 6);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "7", 7);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "8", 8);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "9", 9);
        this.addTurnoutCircleSizeMenuEntry(turnoutCircleSizeMenu, "10", 10);
        turnoutOptionsMenu.add(turnoutCircleSizeMenu);
        this.turnoutDrawUnselectedLegCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("TurnoutDrawUnselectedLeg"));
        turnoutOptionsMenu.add(this.turnoutDrawUnselectedLegCheckBoxMenuItem);
        this.turnoutDrawUnselectedLegCheckBoxMenuItem.addActionListener(event -> {
            this.turnoutDrawUnselectedLeg = this.turnoutDrawUnselectedLegCheckBoxMenuItem.isSelected();
            this.redrawPanel();
        });
        this.turnoutDrawUnselectedLegCheckBoxMenuItem.setSelected(this.turnoutDrawUnselectedLeg);
        return optionMenu;
    }

    private void selectLocationFormatCheckBoxMenuItem() {
        this.pixelsCheckBoxMenuItem.setSelected(this.getLayoutEditorToolBarPanel().getLocationFormat() == LayoutEditorToolBarPanel.LocationFormat.ePIXELS);
        this.metricCMCheckBoxMenuItem.setSelected(this.getLayoutEditorToolBarPanel().getLocationFormat() == LayoutEditorToolBarPanel.LocationFormat.eMETRIC_CM);
        this.englishFeetInchesCheckBoxMenuItem.setSelected(this.getLayoutEditorToolBarPanel().getLocationFormat() == LayoutEditorToolBarPanel.LocationFormat.eENGLISH_FEET_INCHES);
    }

    @Nonnull
    public LayoutTrackDrawingOptions getLayoutTrackDrawingOptions() {
        if (this.layoutTrackDrawingOptions == null) {
            this.layoutTrackDrawingOptions = new LayoutTrackDrawingOptions(this.getLayoutName());
            this.layoutTrackDrawingOptions.setMainBlockLineWidth(this.gContext.getMainlineTrackWidth());
            this.layoutTrackDrawingOptions.setSideBlockLineWidth(this.gContext.getSidelineTrackWidth());
            this.layoutTrackDrawingOptions.setMainRailWidth(this.gContext.getMainlineTrackWidth());
            this.layoutTrackDrawingOptions.setSideRailWidth(this.gContext.getSidelineTrackWidth());
            this.layoutTrackDrawingOptions.setMainRailColor(this.mainlineTrackColor);
            this.layoutTrackDrawingOptions.setSideRailColor(this.sidelineTrackColor);
            this.layoutTrackDrawingOptions.setBlockDefaultColor(this.defaultTrackColor);
            this.layoutTrackDrawingOptions.setBlockOccupiedColor(this.defaultOccupiedTrackColor);
            this.layoutTrackDrawingOptions.setBlockAlternativeColor(this.defaultAlternativeTrackColor);
        }
        return this.layoutTrackDrawingOptions;
    }

    public void setLayoutTrackDrawingOptions(LayoutTrackDrawingOptions ltdo) {
        this.layoutTrackDrawingOptions = ltdo;
        this.gContext.setMainlineBlockWidth(this.layoutTrackDrawingOptions.getMainBlockLineWidth());
        this.gContext.setSidelineBlockWidth(this.layoutTrackDrawingOptions.getSideBlockLineWidth());
        this.gContext.setMainlineTrackWidth(this.layoutTrackDrawingOptions.getMainRailWidth());
        this.gContext.setSidelineTrackWidth(this.layoutTrackDrawingOptions.getSideRailWidth());
        this.mainlineTrackColor = this.layoutTrackDrawingOptions.getMainRailColor();
        this.sidelineTrackColor = this.layoutTrackDrawingOptions.getSideRailColor();
        this.redrawPanel();
    }

    private void setupToolsMenu(@Nonnull JMenuBar menuBar) {
        JMenu toolsMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolsMenu.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("MenuToolsMnemonic")));
        menuBar.add(toolsMenu);
        this.getLEChecks().setupChecksMenu(toolsMenu);
        this.assignBlockToSelectionMenuItem.setToolTipText(Bundle.getMessage("AssignBlockToSelectionToolTip"));
        toolsMenu.add(this.assignBlockToSelectionMenuItem);
        this.assignBlockToSelectionMenuItem.addActionListener(event -> this.assignBlockToSelection());
        this.assignBlockToSelectionMenuItem.setEnabled(this._layoutTrackSelection.size() > 0);
        JMenuItem jmi = new JMenuItem(String.valueOf(Bundle.getMessage("ScaleTrackDiagram")) + "...");
        jmi.setToolTipText(Bundle.getMessage("ScaleTrackDiagramToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> {
            ScaleTrackDiagramDialog d = new ScaleTrackDiagramDialog(this);
            d.scaleTrackDiagram();
        });
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("TranslateSelection")) + "...");
        jmi.setToolTipText(Bundle.getMessage("TranslateSelectionToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> {
            if (!this.selectionActive || this.selectionWidth == 0.0 || this.selectionHeight == 0.0) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("Error12"), Bundle.getMessage("ErrorTitle"), 0);
            } else {
                MoveSelectionDialog d = new MoveSelectionDialog(this);
                d.moveSelection();
            }
        });
        this.undoTranslateSelectionMenuItem.setToolTipText(Bundle.getMessage("UndoTranslateSelectionToolTip"));
        toolsMenu.add(this.undoTranslateSelectionMenuItem);
        this.undoTranslateSelectionMenuItem.addActionListener(event -> this.undoMoveSelection());
        this.undoTranslateSelectionMenuItem.setEnabled(this.canUndoMoveSelection);
        jmi = new JMenuItem(Bundle.getMessage("RotateSelection90MenuItemTitle"));
        jmi.setToolTipText(Bundle.getMessage("RotateSelection90MenuItemToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.rotateSelection90());
        jmi = new JMenuItem(Bundle.getMessage("RotateLayout90MenuItemTitle"));
        jmi.setToolTipText(Bundle.getMessage("RotateLayout90MenuItemToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.rotateLayout90());
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("AlignLayoutToGridMenuItemTitle")) + "...");
        jmi.setToolTipText(Bundle.getMessage("AlignLayoutToGridMenuItemToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.alignLayoutToGrid());
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("AlignSelectionToGridMenuItemTitle")) + "...");
        jmi.setToolTipText(Bundle.getMessage("AlignSelectionToGridMenuItemToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.alignSelectionToGrid());
        jmi = new JMenuItem(Bundle.getMessage("ResetTurnoutSize"));
        jmi.setToolTipText(Bundle.getMessage("ResetTurnoutSizeToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.resetTurnoutSize());
        toolsMenu.addSeparator();
        this.skipTurnoutCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.getMessage("SkipInternalTurnout"));
        this.skipTurnoutCheckBoxMenuItem.setToolTipText(Bundle.getMessage("SkipInternalTurnoutToolTip"));
        toolsMenu.add(this.skipTurnoutCheckBoxMenuItem);
        this.skipTurnoutCheckBoxMenuItem.addActionListener(event -> this.setIncludedTurnoutSkipped(this.skipTurnoutCheckBoxMenuItem.isSelected()));
        this.skipTurnoutCheckBoxMenuItem.setSelected(this.isIncludedTurnoutSkipped());
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAtTurnout")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAtTurnoutToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAtTurnout(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAtBoundary")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAtBoundaryToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAtBlockBoundary(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAtXoverTurnout")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAtXoverTurnoutToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAtXoverTurnout(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAtLevelXing")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAtLevelXingToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAtLevelXing(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAtTToTTurnout")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAtTToTTurnoutToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAtThroatToThroatTurnouts(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAt3WayTurnout")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAt3WayTurnoutToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAt3WayTurnout(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("SignalsAtSlip")) + "...");
        jmi.setToolTipText(Bundle.getMessage("SignalsAtSlipToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> this.getLETools().setSignalsAtSlip(this.leToolBarPanel.signalIconEditor, this.leToolBarPanel.signalFrame));
        jmi = new JMenuItem(String.valueOf(Bundle.getMessage("EntryExitTitle")) + "...");
        jmi.setToolTipText(Bundle.getMessage("EntryExitToolTip"));
        toolsMenu.add(jmi);
        jmi.addActionListener(event -> {
            if (this.addEntryExitPairAction == null) {
                this.addEntryExitPairAction = new AddEntryExitPairAction("ENTRY EXIT", this);
            }
            this.addEntryExitPairAction.actionPerformed(event);
        });
    }

    public ToolBarSide getToolBarSide() {
        return this.toolBarSide;
    }

    public void setToolBarSide(ToolBarSide newToolBarSide) {
        if (!newToolBarSide.equals((Object)this.toolBarSide)) {
            this.toolBarSide = newToolBarSide;
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setProperty(this.getWindowFrameRef(), "toolBarSide", this.toolBarSide.getName()));
            this.toolBarSideTopButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eTOP));
            this.toolBarSideLeftButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eLEFT));
            this.toolBarSideBottomButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eBOTTOM));
            this.toolBarSideRightButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eRIGHT));
            this.toolBarSideFloatButton.setSelected(this.toolBarSide.equals((Object)ToolBarSide.eFLOAT));
            this.setupToolBar();
            if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT)) {
                if (this.editToolBarContainerPanel != null) {
                    this.editToolBarContainerPanel.setVisible(false);
                }
                if (this.floatEditHelpPanel != null) {
                    this.floatEditHelpPanel.setVisible(this.isEditable() && this.getShowHelpBar());
                }
            } else {
                if (this.floatingEditToolBoxFrame != null) {
                    this.deletefloatingEditToolBoxFrame();
                }
                this.editToolBarContainerPanel.setVisible(this.isEditable());
                if (this.getShowHelpBar()) {
                    this.helpBarPanel.setVisible(this.isEditable());
                    boolean editMode = this.isEditable();
                    this.setAllEditable(!editMode);
                    this.setAllEditable(editMode);
                }
            }
            this.wideToolBarCheckBoxMenuItem.setEnabled(this.toolBarSide.equals((Object)ToolBarSide.eTOP) || this.toolBarSide.equals((Object)ToolBarSide.eBOTTOM));
        }
    }

    private void setToolBarWide(boolean newToolBarIsWide) {
        if (this.leToolBarPanel.toolBarIsWide != newToolBarIsWide) {
            this.leToolBarPanel.toolBarIsWide = newToolBarIsWide;
            this.wideToolBarCheckBoxMenuItem.setSelected(this.leToolBarPanel.toolBarIsWide);
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSimplePreferenceState(String.valueOf(this.getWindowFrameRef()) + ".toolBarThin", !this.leToolBarPanel.toolBarIsWide));
            this.setupToolBar();
            if (this.getShowHelpBar()) {
                boolean editMode = this.isEditable();
                this.setAllEditable(!editMode);
                this.setAllEditable(editMode);
            } else {
                this.helpBarPanel.setVisible(this.isEditable() && this.getShowHelpBar());
            }
        }
    }

    private void setupZoomMenu(@Nonnull JMenuBar menuBar) {
        this.zoomMenu.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("MenuZoomMnemonic")));
        menuBar.add(this.zoomMenu);
        ButtonGroup zoomButtonGroup = new ButtonGroup();
        int primary_modifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuItem zoomInItem = new JMenuItem(Bundle.getMessage("ZoomIn"));
        zoomInItem.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("zoomInMnemonic")));
        String zoomInAccelerator = Bundle.getMessage("zoomInAccelerator");
        zoomInItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(zoomInAccelerator), primary_modifier));
        this.zoomMenu.add(zoomInItem);
        zoomInItem.addActionListener(event -> {
            double d = this.setZoom(this.getZoom() * 1.1);
        });
        JMenuItem zoomOutItem = new JMenuItem(Bundle.getMessage("ZoomOut"));
        zoomOutItem.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("zoomOutMnemonic")));
        String zoomOutAccelerator = Bundle.getMessage("zoomOutAccelerator");
        zoomOutItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(zoomOutAccelerator), primary_modifier));
        this.zoomMenu.add(zoomOutItem);
        zoomOutItem.addActionListener(event -> {
            double d = this.setZoom(this.getZoom() / 1.1);
        });
        JMenuItem zoomFitItem = new JMenuItem(Bundle.getMessage("ZoomToFit"));
        this.zoomMenu.add(zoomFitItem);
        zoomFitItem.addActionListener(event -> {
            double d = this.zoomToFit();
        });
        this.zoomMenu.addSeparator();
        this.zoomMenu.add(this.zoom025Item);
        this.zoom025Item.addActionListener(event -> {
            double d = this.setZoom(0.25);
        });
        zoomButtonGroup.add(this.zoom025Item);
        this.zoomMenu.add(this.zoom05Item);
        this.zoom05Item.addActionListener(event -> {
            double d = this.setZoom(0.5);
        });
        zoomButtonGroup.add(this.zoom05Item);
        this.zoomMenu.add(this.zoom075Item);
        this.zoom075Item.addActionListener(event -> {
            double d = this.setZoom(0.75);
        });
        zoomButtonGroup.add(this.zoom075Item);
        String zoomNoneAccelerator = Bundle.getMessage("zoomNoneAccelerator");
        this.noZoomItem.setAccelerator(KeyStroke.getKeyStroke(this.stringsToVTCodes.get(zoomNoneAccelerator), primary_modifier));
        this.zoomMenu.add(this.noZoomItem);
        this.noZoomItem.addActionListener(event -> {
            double d = this.setZoom(1.0);
        });
        zoomButtonGroup.add(this.noZoomItem);
        this.zoomMenu.add(this.zoom15Item);
        this.zoom15Item.addActionListener(event -> {
            double d = this.setZoom(1.5);
        });
        zoomButtonGroup.add(this.zoom15Item);
        this.zoomMenu.add(this.zoom20Item);
        this.zoom20Item.addActionListener(event -> {
            double d = this.setZoom(2.0);
        });
        zoomButtonGroup.add(this.zoom20Item);
        this.zoomMenu.add(this.zoom30Item);
        this.zoom30Item.addActionListener(event -> {
            double d = this.setZoom(3.0);
        });
        zoomButtonGroup.add(this.zoom30Item);
        this.zoomMenu.add(this.zoom40Item);
        this.zoom40Item.addActionListener(event -> {
            double d = this.setZoom(4.0);
        });
        zoomButtonGroup.add(this.zoom40Item);
        this.zoomMenu.add(this.zoom50Item);
        this.zoom50Item.addActionListener(event -> {
            double d = this.setZoom(5.0);
        });
        zoomButtonGroup.add(this.zoom50Item);
        this.zoomMenu.add(this.zoom60Item);
        this.zoom60Item.addActionListener(event -> {
            double d = this.setZoom(6.0);
        });
        zoomButtonGroup.add(this.zoom60Item);
        this.zoomMenu.add(this.zoom70Item);
        this.zoom70Item.addActionListener(event -> {
            double d = this.setZoom(7.0);
        });
        zoomButtonGroup.add(this.zoom70Item);
        this.zoomMenu.add(this.zoom80Item);
        this.zoom80Item.addActionListener(event -> {
            double d = this.setZoom(8.0);
        });
        zoomButtonGroup.add(this.zoom80Item);
        this.noZoomItem.setSelected(true);
        SwingUtilities.invokeLater(() -> {
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> {
                Object zoomProp = prefsMgr.getProperty(this.getWindowFrameRef(), "zoom");
                log.debug("{} zoom is {}", (Object)this.getWindowFrameRef(), zoomProp);
                if (zoomProp != null) {
                    this.setZoom((Double)zoomProp);
                }
            });
            JScrollPane scrollPane = this.getPanelScrollPane();
            if (scrollPane != null) {
                JScrollBar hsb = scrollPane.getHorizontalScrollBar();
                JScrollBar vsb = scrollPane.getVerticalScrollBar();
                vsb.setUnitIncrement(this.gContext.getGridSize());
                hsb.setUnitIncrement(this.gContext.getGridSize());
                vsb.addAdjustmentListener(this::scrollBarAdjusted);
                hsb.addAdjustmentListener(this::scrollBarAdjusted);
                MouseWheelListener[] mouseWheelListenerArray = this.mouseWheelListeners = scrollPane.getMouseWheelListeners();
                int n = this.mouseWheelListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    MouseWheelListener mwl = mouseWheelListenerArray[n2];
                    scrollPane.removeMouseWheelListener(mwl);
                    ++n2;
                }
                scrollPane.addMouseWheelListener(this);
            }
        });
    }

    public void scrollBarAdjusted(AdjustmentEvent event) {
        if (this.isEditable()) {
            PointerInfo mpi = MouseInfo.getPointerInfo();
            Point mouseLoc = mpi.getLocation();
            SwingUtilities.convertPointFromScreen(mouseLoc, this.getTargetPanel());
            double theZoom = this.getZoom();
            this.xLoc = (int)(mouseLoc.getX() / theZoom);
            this.yLoc = (int)(mouseLoc.getY() / theZoom);
            this.dLoc = new Point2D.Double(this.xLoc, this.yLoc);
            this.leToolBarPanel.setLocationText(this.dLoc);
        }
        this.adjustClip();
    }

    private void adjustScrollBars() {
        JScrollPane scrollPane = this.getPanelScrollPane();
        Rectangle scrollBounds = scrollPane.getViewportBorderBounds();
        Dimension targetPanelSize = this.getTargetPanelSize();
        JScrollBar horScroll = scrollPane.getHorizontalScrollBar();
        double oldX = horScroll.getValue();
        double oldMaxX = horScroll.getMaximum();
        double ratioX = oldMaxX < 1.0 ? 0.0 : oldX / oldMaxX;
        int panelWidth = (int)targetPanelSize.getWidth();
        int scrollWidth = (int)scrollBounds.getWidth();
        int newMaxX = Math.max(panelWidth - scrollWidth, 0);
        int newX = (int)((double)newMaxX * ratioX);
        horScroll.setMaximum(newMaxX);
        horScroll.setValue(newX);
        JScrollBar vertScroll = scrollPane.getVerticalScrollBar();
        double oldY = vertScroll.getValue();
        double oldMaxY = vertScroll.getMaximum();
        double ratioY = oldMaxY < 1.0 ? 0.0 : oldY / oldMaxY;
        int tempPanelHeight = (int)targetPanelSize.getHeight();
        int tempScrollHeight = (int)scrollBounds.getHeight();
        int newMaxY = Math.max(tempPanelHeight - tempScrollHeight, 0);
        int newY = (int)((double)newMaxY * ratioY);
        vertScroll.setMaximum(newMaxY);
        vertScroll.setValue(newY);
        this.adjustClip();
    }

    private void adjustClip() {
        JScrollPane scrollPane = this.getPanelScrollPane();
        Rectangle scrollBounds = scrollPane.getViewportBorderBounds();
        JScrollBar horScroll = scrollPane.getHorizontalScrollBar();
        int scrollX = horScroll.getValue();
        JScrollBar vertScroll = scrollPane.getVerticalScrollBar();
        int scrollY = vertScroll.getValue();
        Rectangle2D newClipRect = MathUtil.offset(scrollBounds, (double)scrollX - scrollBounds.getMinX(), (double)scrollY - scrollBounds.getMinY());
        newClipRect = MathUtil.scale(newClipRect, 1.0 / this.getZoom());
        newClipRect = MathUtil.granulize(newClipRect, 1.0);
        this.layoutEditorComponent.setClip(newClipRect);
        this.redrawPanel();
    }

    @Override
    public void mouseWheelMoved(@Nonnull MouseWheelEvent event) {
        if (event.isAltDown()) {
            Component component = (Component)event.getSource();
            Point eventPoint = event.getPoint();
            JComponent targetPanel = this.getTargetPanel();
            Point mousePoint = SwingUtilities.convertPoint(component, eventPoint, targetPanel);
            JScrollPane scrollPane = this.getPanelScrollPane();
            JViewport viewPort = scrollPane.getViewport();
            Point viewPosition = viewPort.getViewPosition();
            double zoom = this.getZoom();
            Point2D imageMousePoint = MathUtil.divide(mousePoint, zoom);
            Point2D imageViewPosition = MathUtil.divide(viewPosition, zoom);
            Point2D imageDelta = MathUtil.subtract(imageMousePoint, imageViewPosition);
            double amount = Math.pow(1.1, event.getScrollAmount());
            if ((double)event.getWheelRotation() < 0.0) {
                amount = 1.0 / amount;
            }
            double newZoom = this.setZoom(zoom * amount);
            amount = newZoom / zoom;
            Point2D newImageDelta = MathUtil.divide(imageDelta, amount);
            Point2D newImageViewPosition = MathUtil.subtract(imageMousePoint, newImageDelta);
            Point2D newViewPosition = MathUtil.multiply(newImageViewPosition, newZoom);
            newViewPosition = MathUtil.max(newViewPosition, MathUtil.zeroPoint2D);
            viewPort.setViewPosition(MathUtil.point2DToPoint(newViewPosition));
        } else {
            JScrollPane scrollPane = this.getPanelScrollPane();
            if (scrollPane != null) {
                if (scrollPane.getVerticalScrollBar().isVisible()) {
                    MouseWheelListener[] mouseWheelListenerArray = this.mouseWheelListeners;
                    int n = this.mouseWheelListeners.length;
                    int targetPanel = 0;
                    while (targetPanel < n) {
                        MouseWheelListener mwl = mouseWheelListenerArray[targetPanel];
                        mwl.mouseWheelMoved(event);
                        ++targetPanel;
                    }
                } else {
                    Container ancestor = SwingUtilities.getAncestorOfClass(JScrollPane.class, scrollPane);
                    if (ancestor != null) {
                        MouseWheelEvent mwe = new MouseWheelEvent(ancestor, event.getID(), event.getWhen(), event.getModifiersEx(), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getScrollType(), event.getScrollAmount(), event.getWheelRotation());
                        ancestor.dispatchEvent(mwe);
                    }
                }
            }
        }
    }

    private void selectZoomMenuItem(double zoomFactor) {
        int newZoomFactor = (int)MathUtil.granulize(zoomFactor, 100.0);
        this.noZoomItem.setSelected(newZoomFactor == 100);
        this.zoom20Item.setSelected(newZoomFactor == 200);
        this.zoom30Item.setSelected(newZoomFactor == 300);
        this.zoom40Item.setSelected(newZoomFactor == 400);
        this.zoom50Item.setSelected(newZoomFactor == 500);
        this.zoom60Item.setSelected(newZoomFactor == 600);
        this.zoom70Item.setSelected(newZoomFactor == 700);
        this.zoom80Item.setSelected(newZoomFactor == 800);
        newZoomFactor = (int)MathUtil.granulize(zoomFactor, 50.0);
        this.zoom05Item.setSelected(newZoomFactor == 50);
        this.zoom15Item.setSelected(newZoomFactor == 150);
        newZoomFactor = (int)MathUtil.granulize(zoomFactor, 25.0);
        this.zoom025Item.setSelected(newZoomFactor == 25);
        this.zoom075Item.setSelected(newZoomFactor == 75);
    }

    public double setZoom(double zoomFactor) {
        double newZoom = MathUtil.pin(zoomFactor, this.minZoom, 8.0);
        this.selectZoomMenuItem(newZoom);
        if (!MathUtil.equals(newZoom, this.getPaintScale())) {
            log.debug("zoom: {}", (Object)zoomFactor);
            this._paintScale = newZoom;
            this.resetTargetSize();
            this.adjustScrollBars();
            this.leToolBarPanel.zoomLabel.setText(String.format("x%1$,.2f", newZoom));
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setProperty(this.getWindowFrameRef(), "zoom", zoomFactor));
        }
        return this.getPaintScale();
    }

    public double getZoom() {
        return this.getPaintScale();
    }

    public double getMinZoom() {
        return this.minZoom;
    }

    public double getMaxZoom() {
        return 8.0;
    }

    private Rectangle2D calculateMinimumLayoutBounds() {
        Rectangle2D result = new Rectangle2D.Double();
        ArrayList<List<JComponent>> listOfListsOfComponents = new ArrayList<List<JComponent>>();
        listOfListsOfComponents.add(this.backgroundImage);
        listOfListsOfComponents.add(this.sensorImage);
        listOfListsOfComponents.add(this.signalHeadImage);
        listOfListsOfComponents.add(this.markerImage);
        listOfListsOfComponents.add(this.labelImage);
        listOfListsOfComponents.add(this.clocks);
        listOfListsOfComponents.add(this.multiSensors);
        listOfListsOfComponents.add(this.signalList);
        listOfListsOfComponents.add(this.memoryLabelList);
        listOfListsOfComponents.add(this.blockContentsLabelList);
        listOfListsOfComponents.add(this.sensorList);
        listOfListsOfComponents.add(this.signalMastList);
        for (List list : listOfListsOfComponents) {
            for (Component o : list) {
                result = ((RectangularShape)result).isEmpty() ? o.getBounds() : ((Rectangle2D)result).createUnion(o.getBounds());
            }
        }
        for (LayoutTrackView layoutTrackView : this.getLayoutTrackViews()) {
            result = ((RectangularShape)result).isEmpty() ? layoutTrackView.getBounds() : ((Rectangle2D)result).createUnion(layoutTrackView.getBounds());
        }
        for (LayoutShape layoutShape : this.layoutShapes) {
            result = ((RectangularShape)result).isEmpty() ? layoutShape.getBounds() : ((Rectangle2D)result).createUnion(layoutShape.getBounds());
        }
        result = MathUtil.inset(result, (double)(this.gContext.getGridSize() * this.gContext.getGridSize2nd()) / -2.0);
        return result;
    }

    private Rectangle2D resizePanelBounds(boolean forceFlag) {
        Rectangle2D panelBounds = this.getPanelBounds();
        Rectangle2D layoutBounds = this.calculateMinimumLayoutBounds();
        layoutBounds.add(MathUtil.zeroPoint2D);
        if (forceFlag) {
            panelBounds = layoutBounds;
        } else {
            panelBounds.add(layoutBounds);
        }
        panelBounds = panelBounds.createIntersection(MathUtil.zeroToInfinityRectangle2D);
        this.setPanelBounds(panelBounds);
        return panelBounds;
    }

    private double zoomToFit() {
        Rectangle2D layoutBounds = this.resizePanelBounds(true);
        JScrollPane scrollPane = this.getPanelScrollPane();
        Rectangle2D scrollBounds = scrollPane.getViewportBorderBounds();
        scrollBounds = scrollBounds.createIntersection(MathUtil.zeroToInfinityRectangle2D);
        double scaleWidth = (double)scrollPane.getWidth() / layoutBounds.getWidth();
        double scaleHeight = (double)scrollPane.getHeight() / layoutBounds.getHeight();
        double result = this.setZoom(Math.min(scaleWidth, scaleHeight));
        result = this.setZoom(result);
        scrollBounds = MathUtil.scale(layoutBounds, result);
        scrollBounds = scrollBounds.createIntersection(MathUtil.zeroToInfinityRectangle2D);
        scrollBounds.add(MathUtil.zeroPoint2D);
        scrollPane.scrollRectToVisible(MathUtil.rectangle2DToRectangle(scrollBounds));
        return result;
    }

    private Point2D windowCenter() {
        return MathUtil.divide(MathUtil.center(this.getBounds()), this.getZoom());
    }

    private void setupMarkerMenu(@Nonnull JMenuBar menuBar) {
        JMenu markerMenu = new JMenu(Bundle.getMessage("MenuMarker"));
        markerMenu.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("MenuMarkerMnemonic")));
        menuBar.add(markerMenu);
        markerMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("AddLoco")) + "..."){

            @Override
            public void actionPerformed(ActionEvent event) {
                LayoutEditor.this.locoMarkerFromInput();
            }
        });
        markerMenu.add(new AbstractAction(String.valueOf(Bundle.getMessage("AddLocoRoster")) + "..."){

            @Override
            public void actionPerformed(ActionEvent event) {
                LayoutEditor.this.locoMarkerFromRoster();
            }
        });
        markerMenu.add(new AbstractAction(Bundle.getMessage("RemoveMarkers")){

            @Override
            public void actionPerformed(ActionEvent event) {
                LayoutEditor.this.removeMarkers();
            }
        });
    }

    private void setupDispatcherMenu(@Nonnull JMenuBar menuBar) {
        JMenu dispMenu = new JMenu(Bundle.getMessage("MenuDispatcher"));
        dispMenu.setMnemonic(this.stringsToVTCodes.get(Bundle.getMessage("MenuDispatcherMnemonic")));
        dispMenu.add(new JMenuItem(new DispatcherAction(Bundle.getMessage("MenuItemOpen"))));
        menuBar.add(dispMenu);
        JMenuItem newTrainItem = new JMenuItem(Bundle.getMessage("MenuItemNewTrain"));
        dispMenu.add(newTrainItem);
        newTrainItem.addActionListener(event -> {
            if (InstanceManager.getDefault(TransitManager.class).getNamedBeanSet().size() <= 0) {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("jmri.jmrit.dispatcher.DispatcherBundle").getString("NoTransitsMessage"));
            } else {
                DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
                if (!df.getNewTrainActive()) {
                    df.getActiveTrainFrame().initiateTrain(event, null, null);
                    df.setNewTrainActive(true);
                } else {
                    df.getActiveTrainFrame().showActivateFrame(null);
                }
            }
        });
        menuBar.add(dispMenu);
    }

    public boolean isIncludedTurnoutSkipped() {
        return this.includedTurnoutSkipped;
    }

    public void setIncludedTurnoutSkipped(Boolean boo) {
        this.includedTurnoutSkipped = boo;
    }

    public boolean getOpenDispatcherOnLoad() {
        return this.openDispatcherOnLoad;
    }

    public void setOpenDispatcherOnLoad(Boolean boo) {
        this.openDispatcherOnLoad = boo;
    }

    @Override
    public void removeMarkers() {
        int i = this.markerImage.size();
        while (i > 0) {
            LocoIcon il = this.markerImage.get(i - 1);
            if (il != null && il.isActive()) {
                this.markerImage.remove(i - 1);
                il.remove();
                il.dispose();
                this.setDirty();
            }
            --i;
        }
        super.removeMarkers();
        this.redrawPanel();
    }

    private void assignBlockToSelection() {
        String newName = this.leToolBarPanel.blockIDComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        LayoutBlock b = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(newName);
        this._layoutTrackSelection.forEach(lt -> lt.setAllLayoutBlocks(b));
    }

    public boolean translateTrack(float xDel, float yDel) {
        Point2D.Double delta = new Point2D.Double(xDel, yDel);
        this.getLayoutTrackViews().forEach(ltv -> ltv.setCoordsCenter(MathUtil.add(ltv.getCoordsCenter(), delta)));
        this.resizePanelBounds(true);
        return true;
    }

    public boolean scaleTrack(float xFactor, float yFactor) {
        this.getLayoutTrackViews().forEach(ltv -> ltv.scaleCoords(xFactor, yFactor));
        this.gContext.setXScale(this.gContext.getXScale() * (double)xFactor);
        this.gContext.setYScale(this.gContext.getYScale() * (double)yFactor);
        this.resizePanelBounds(true);
        return true;
    }

    public int setAllTracksToDefaultColors() {
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        SortedSet lBList = lbm.getNamedBeanSet();
        int changed = 0;
        for (LayoutBlock lb : lBList) {
            lb.setBlockTrackColor(this.getDefaultTrackColorColor());
            lb.setBlockOccupiedColor(this.getDefaultOccupiedTrackColorColor());
            lb.setBlockExtraColor(this.getDefaultAlternativeTrackColorColor());
            ++changed;
        }
        log.info("Track Colors set to default values for {} layoutBlocks.", (Object)changed);
        return changed;
    }

    public void translate(float xTranslation, float yTranslation) {
        if (xTranslation != 0.0f || yTranslation != 0.0f) {
            Point2D.Double delta = new Point2D.Double(xTranslation, yTranslation);
            Rectangle2D selectionRect = this.getSelectionRect();
            this.undoRect = MathUtil.offset(selectionRect, delta);
            this.undoDelta = MathUtil.subtract(MathUtil.zeroPoint2D, delta);
            this.canUndoMoveSelection = true;
            this.undoTranslateSelectionMenuItem.setEnabled(this.canUndoMoveSelection);
            for (Positionable c : this._positionableSelection) {
                Point2D newPoint = MathUtil.add(c.getLocation(), delta);
                c.setLocation((int)newPoint.getX(), (int)newPoint.getY());
            }
            for (LayoutTrack lt : this._layoutTrackSelection) {
                LayoutTrackView ltv = this.getLayoutTrackView(lt);
                ltv.setCoordsCenter(MathUtil.add(ltv.getCoordsCenter(), delta));
            }
            for (LayoutShape ls : this._layoutShapeSelection) {
                ls.setCoordsCenter(MathUtil.add(ls.getCoordsCenter(), delta));
            }
            this.selectionX = this.undoRect.getX();
            this.selectionY = this.undoRect.getY();
            this.selectionWidth = this.undoRect.getWidth();
            this.selectionHeight = this.undoRect.getHeight();
            this.resizePanelBounds(false);
            this.setDirty();
            this.redrawPanel();
        }
    }

    void undoMoveSelection() {
        if (this.canUndoMoveSelection) {
            this._positionableSelection.forEach(c -> {
                Point2D newPoint = MathUtil.add(c.getLocation(), this.undoDelta);
                c.setLocation((int)newPoint.getX(), (int)newPoint.getY());
            });
            this._layoutTrackSelection.forEach(lt -> {
                LayoutTrackView ltv = this.getLayoutTrackView((LayoutTrack)lt);
                ltv.setCoordsCenter(MathUtil.add(ltv.getCoordsCenter(), this.undoDelta));
            });
            this._layoutShapeSelection.forEach(ls -> ls.setCoordsCenter(MathUtil.add(ls.getCoordsCenter(), this.undoDelta)));
            this.undoRect = MathUtil.offset(this.undoRect, this.undoDelta);
            this.selectionX = this.undoRect.getX();
            this.selectionY = this.undoRect.getY();
            this.selectionWidth = this.undoRect.getWidth();
            this.selectionHeight = this.undoRect.getHeight();
            this.resizePanelBounds(false);
            this.redrawPanel();
            this.canUndoMoveSelection = false;
            this.undoTranslateSelectionMenuItem.setEnabled(this.canUndoMoveSelection);
        }
    }

    public void rotateSelection90() {
        Rectangle2D bounds = this.getSelectionRect();
        Point2D center = MathUtil.midPoint(bounds);
        for (Positionable positionable : this._positionableSelection) {
            PositionableLabel positionableLabel;
            Rectangle cBounds = positionable.getBounds(new Rectangle());
            Point2D.Double oldBottomLeft = new Point2D.Double(cBounds.getMinX(), cBounds.getMaxY());
            Point2D newTopLeft = MathUtil.rotateDEG(oldBottomLeft, center, 90.0);
            boolean rotateFlag = true;
            if (positionable instanceof PositionableLabel && (positionableLabel = (PositionableLabel)positionable).isBackground()) {
                rotateFlag = false;
            }
            if (!rotateFlag) continue;
            positionable.rotate(positionable.getDegrees() + 90);
            positionable.setLocation((int)newTopLeft.getX(), (int)newTopLeft.getY());
        }
        for (LayoutTrack lt : this._layoutTrackSelection) {
            LayoutTrackView ltv = this.getLayoutTrackView(lt);
            ltv.setCoordsCenter(MathUtil.rotateDEG(ltv.getCoordsCenter(), center, 90.0));
            ltv.rotateCoords(90.0);
        }
        for (LayoutShape ls : this._layoutShapeSelection) {
            ls.setCoordsCenter(MathUtil.rotateDEG(ls.getCoordsCenter(), center, 90.0));
            ls.rotateCoords(90.0);
        }
        this.resizePanelBounds(true);
        this.setDirty();
        this.redrawPanel();
    }

    public void rotateLayout90() {
        Point2D newPoint;
        List<Positionable> positionables = new ArrayList<Positionable>(this.getContents());
        positionables.addAll(this.backgroundImage);
        positionables.addAll(this.blockContentsLabelList);
        positionables.addAll(this.labelImage);
        positionables.addAll(this.memoryLabelList);
        positionables.addAll(this.sensorImage);
        positionables.addAll(this.sensorList);
        positionables.addAll(this.signalHeadImage);
        positionables.addAll(this.signalList);
        positionables.addAll(this.signalMastList);
        positionables = positionables.stream().distinct().collect(Collectors.toList());
        Rectangle2D bounds = this.getPanelBounds();
        Point2D.Double lowerLeft = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        for (Positionable positionable : positionables) {
            Rectangle cBounds = positionable.getBounds(new Rectangle());
            Point2D newTopLeft = MathUtil.subtract(MathUtil.rotateDEG(positionable.getLocation(), lowerLeft, 90.0), lowerLeft);
            boolean reLocateFlag = true;
            if (positionable instanceof PositionableLabel) {
                try {
                    PositionableLabel positionableLabel = (PositionableLabel)positionable;
                    if (positionableLabel.isBackground()) {
                        reLocateFlag = false;
                    }
                    positionableLabel.rotate(positionableLabel.getDegrees() + 90);
                }
                catch (NullPointerException ex) {
                    log.warn("previously-ignored NPE", (Throwable)ex);
                }
            }
            if (!reLocateFlag) continue;
            try {
                positionable.setLocation((int)(newTopLeft.getX() - ((RectangularShape)cBounds).getHeight()), (int)newTopLeft.getY());
            }
            catch (NullPointerException ex) {
                log.warn("previously-ignored NPE", (Throwable)ex);
            }
        }
        for (LayoutTrackView ltv : this.getLayoutTrackViews()) {
            try {
                newPoint = MathUtil.subtract(MathUtil.rotateDEG(ltv.getCoordsCenter(), lowerLeft, 90.0), lowerLeft);
                ltv.setCoordsCenter(newPoint);
                ltv.rotateCoords(90.0);
            }
            catch (NullPointerException ex) {
                log.warn("previously-ignored NPE", (Throwable)ex);
            }
        }
        for (LayoutShape ls : this.layoutShapes) {
            newPoint = MathUtil.subtract(MathUtil.rotateDEG(ls.getCoordsCenter(), lowerLeft, 90.0), lowerLeft);
            ls.setCoordsCenter(newPoint);
            ls.rotateCoords(90.0);
        }
        this.resizePanelBounds(true);
        this.setDirty();
        this.redrawPanel();
    }

    public void alignLayoutToGrid() {
        List<Positionable> positionables = new ArrayList<Positionable>(this.getContents());
        positionables.addAll(this.backgroundImage);
        positionables.addAll(this.blockContentsLabelList);
        positionables.addAll(this.labelImage);
        positionables.addAll(this.memoryLabelList);
        positionables.addAll(this.sensorImage);
        positionables.addAll(this.sensorList);
        positionables.addAll(this.signalHeadImage);
        positionables.addAll(this.signalList);
        positionables.addAll(this.signalMastList);
        positionables = positionables.stream().distinct().collect(Collectors.toList());
        this.alignToGrid(positionables, this.getLayoutTracks(), this.layoutShapes);
    }

    public void alignSelectionToGrid() {
        this.alignToGrid(this._positionableSelection, this._layoutTrackSelection, this._layoutShapeSelection);
    }

    private void alignToGrid(List<Positionable> positionables, List<LayoutTrack> tracks, List<LayoutShape> shapes) {
        for (Positionable positionable : positionables) {
            Point2D newLocation = MathUtil.granulize(positionable.getLocation(), (double)this.gContext.getGridSize());
            positionable.setLocation((int)newLocation.getX(), (int)newLocation.getY());
        }
        for (LayoutTrack lt : tracks) {
            LayoutTrackView ltv = this.getLayoutTrackView(lt);
            ltv.setCoordsCenter(MathUtil.granulize(ltv.getCoordsCenter(), (double)this.gContext.getGridSize()));
            if (!(lt instanceof LayoutTurntable)) continue;
            LayoutTurntable tt = (LayoutTurntable)lt;
            LayoutTurntableView ttv = this.getLayoutTurntableView(tt);
            for (LayoutTurntable.RayTrack rt : tt.getRayTrackList()) {
                int rayIndex = rt.getConnectionIndex();
                ttv.setRayCoordsIndexed(MathUtil.granulize(ttv.getRayCoordsIndexed(rayIndex), (double)this.gContext.getGridSize()), rayIndex);
            }
        }
        for (LayoutShape ls : shapes) {
            ls.setCoordsCenter(MathUtil.granulize(ls.getCoordsCenter(), (double)this.gContext.getGridSize()));
            int idx = 0;
            while (idx < ls.getNumberPoints()) {
                ls.setPoint(idx, MathUtil.granulize(ls.getPoint(idx), (double)this.gContext.getGridSize()));
                ++idx;
            }
        }
        this.resizePanelBounds(true);
        this.setDirty();
        this.redrawPanel();
    }

    public void setCurrentPositionAndSize() {
        Dimension dim = this.getSize();
        this.gContext.setWindowHeight(dim.height);
        this.gContext.setWindowWidth(dim.width);
        dim = this.getTargetPanelSize();
        this.gContext.setLayoutWidth((int)((double)dim.width / this.getZoom()));
        this.gContext.setLayoutHeight((int)((double)dim.height / this.getZoom()));
        this.adjustScrollBars();
        Point pt = this.getLocationOnScreen();
        this.gContext.setUpperLeftY(pt.x);
        this.gContext.setUpperLeftY(pt.y);
        log.debug("setCurrentPositionAndSize Position - {},{} WindowSize - {},{} PanelSize - {},{}", new Object[]{this.gContext.getUpperLeftX(), this.gContext.getUpperLeftY(), this.gContext.getWindowWidth(), this.gContext.getWindowHeight(), this.gContext.getLayoutWidth(), this.gContext.getLayoutHeight()});
        this.setDirty();
    }

    private JRadioButtonMenuItem addButtonGroupMenuEntry(@Nonnull JMenu inMenu, ButtonGroup inButtonGroup, String inName, boolean inSelected, ActionListener inActionListener) {
        JRadioButtonMenuItem result = new JRadioButtonMenuItem(inName);
        if (inActionListener != null) {
            result.addActionListener(inActionListener);
        }
        if (inButtonGroup != null) {
            inButtonGroup.add(result);
        }
        result.setSelected(inSelected);
        inMenu.add(result);
        return result;
    }

    private void addTurnoutCircleSizeMenuEntry(@Nonnull JMenu inMenu, @Nonnull String inName, int inSize) {
        ActionListener a = event -> {
            if (this.getTurnoutCircleSize() != inSize) {
                this.setTurnoutCircleSize(inSize);
                this.setDirty();
                this.redrawPanel();
            }
        };
        this.addButtonGroupMenuEntry(inMenu, this.turnoutCircleSizeButtonGroup, inName, this.getTurnoutCircleSize() == inSize, a);
    }

    private void setOptionMenuTurnoutCircleSize() {
        String tcs = Integer.toString(this.getTurnoutCircleSize());
        Enumeration<AbstractButton> e = this.turnoutCircleSizeButtonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            String buttonName = button.getText();
            button.setSelected(buttonName.equals(tcs));
        }
    }

    @Override
    public void setScroll(int state) {
        if (this.isEditable()) {
            super.setScroll(1);
            this._scrollState = state;
        } else {
            super.setScroll(state);
        }
    }

    @Override
    public void setScroll(String value) {
        if (value != null) {
            super.setScroll(value);
        }
        this.scrollNoneMenuItem.setSelected(this._scrollState == 0);
        this.scrollBothMenuItem.setSelected(this._scrollState == 1);
        this.scrollHorizontalMenuItem.setSelected(this._scrollState == 2);
        this.scrollVerticalMenuItem.setSelected(this._scrollState == 3);
    }

    public void addTurntable(@Nonnull Point2D pt) {
        String name = this.finder.uniqueName("TUR", ++this.numLayoutTurntables);
        LayoutTurntable lt = new LayoutTurntable(name, this);
        LayoutTurntableView ltv = new LayoutTurntableView(lt, pt, this);
        this.addLayoutTrack(lt, ltv);
        lt.addRay(0.0);
        lt.addRay(90.0);
        lt.addRay(180.0);
        lt.addRay(270.0);
        this.setDirty();
    }

    @Override
    public void redrawPanel() {
        this.repaint();
    }

    public void setAwaitingIconChange() {
        this.awaitingIconChange = true;
    }

    public void resetAwaitingIconChange() {
        this.awaitingIconChange = false;
    }

    public void resetDirty() {
        this.setDirty(false);
        this.savedEditMode = this.isEditable();
        this.savedPositionable = this.allPositionable();
        this.savedControlLayout = this.allControlling();
        this.savedAnimatingLayout = this.isAnimating();
        this.savedShowHelpBar = this.getShowHelpBar();
    }

    public void setDirty(boolean val) {
        this.panelChanged = val;
    }

    @Override
    public void setDirty() {
        this.setDirty(true);
    }

    @Override
    public boolean isDirty() {
        return this.panelChanged;
    }

    @Nonnull
    private Point2D calcLocation(MouseEvent event, int dX, int dY) {
        this.xLoc = (int)((double)(event.getX() + dX) / this.getZoom());
        this.yLoc = (int)((double)(event.getY() + dY) / this.getZoom());
        this.dLoc = new Point2D.Double(this.xLoc, this.yLoc);
        return this.dLoc;
    }

    private Point2D calcLocation(MouseEvent event) {
        return this.calcLocation(event, 0, 0);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        List<Positionable> selections;
        LocoIcon lo;
        this._anchorX = this.xLoc;
        this._anchorY = this.yLoc;
        this._lastX = this._anchorX;
        this._lastY = this._anchorY;
        this.calcLocation(event);
        if (this.isEditable()) {
            boolean prevSelectionActive = this.selectionActive;
            this.selectionActive = false;
            this.leToolBarPanel.setLocationText(this.dLoc);
            if (event.isPopupTrigger()) {
                if (this.isMetaDown(event) || event.isAltDown()) {
                    this.delayedPopupTrigger = true;
                } else {
                    this.showEditPopUps(event);
                }
            }
            if (this.isMetaDown(event) || event.isAltDown()) {
                this.selectedObject = null;
                this.selectedHitPointType = HitPointType.NONE;
                if (this.findLayoutTracksHitPoint(this.dLoc)) {
                    this.selectedObject = this.foundTrack;
                    this.selectedHitPointType = this.foundHitPointType;
                    this.startDelta = MathUtil.subtract(this.foundLocation, this.dLoc);
                    this.foundTrack = null;
                    this.foundTrackView = null;
                } else {
                    this.selectedObject = this.checkMarkerPopUps(this.dLoc);
                    if (this.selectedObject != null) {
                        this.selectedHitPointType = HitPointType.MARKER;
                        this.startDelta = MathUtil.subtract(((LocoIcon)this.selectedObject).getLocation(), this.dLoc);
                    } else {
                        this.selectedObject = this.checkClockPopUps(this.dLoc);
                        if (this.selectedObject != null) {
                            this.selectedHitPointType = HitPointType.LAYOUT_POS_JCOMP;
                            this.startDelta = MathUtil.subtract(((PositionableJComponent)this.selectedObject).getLocation(), this.dLoc);
                        } else {
                            this.selectedObject = this.checkMultiSensorPopUps(this.dLoc);
                            if (this.selectedObject != null) {
                                this.selectedHitPointType = HitPointType.MULTI_SENSOR;
                                this.startDelta = MathUtil.subtract(((MultiSensorIcon)this.selectedObject).getLocation(), this.dLoc);
                            }
                        }
                    }
                    if (this.selectedObject == null) {
                        this.selectedObject = this.checkSensorIconPopUps(this.dLoc);
                        if (this.selectedObject == null) {
                            this.selectedObject = this.checkSignalHeadIconPopUps(this.dLoc);
                            if (this.selectedObject == null) {
                                this.selectedObject = this.checkLabelImagePopUps(this.dLoc);
                                if (this.selectedObject == null) {
                                    this.selectedObject = this.checkSignalMastIconPopUps(this.dLoc);
                                }
                            }
                        }
                        if (this.selectedObject != null) {
                            MemoryIcon pm;
                            this.selectedHitPointType = HitPointType.LAYOUT_POS_LABEL;
                            this.startDelta = MathUtil.subtract(((PositionableLabel)this.selectedObject).getLocation(), this.dLoc);
                            if (this.selectedObject instanceof MemoryIcon && (pm = (MemoryIcon)this.selectedObject).getPopupUtility().getFixedWidth() == 0) {
                                this.startDelta = new Point2D.Double((double)pm.getOriginalX() - this.dLoc.getX(), (double)pm.getOriginalY() - this.dLoc.getY());
                            }
                        } else {
                            this.selectedObject = this.checkBackgroundPopUps(this.dLoc);
                            if (this.selectedObject != null) {
                                this.selectedHitPointType = HitPointType.LAYOUT_POS_LABEL;
                                this.startDelta = MathUtil.subtract(((PositionableLabel)this.selectedObject).getLocation(), this.dLoc);
                            } else {
                                ListIterator<LayoutShape> listIterator = this.layoutShapes.listIterator(this.layoutShapes.size());
                                while (listIterator.hasPrevious()) {
                                    LayoutShape ls = listIterator.previous();
                                    this.selectedHitPointType = ls.findHitPointType(this.dLoc, true);
                                    if (!LayoutShape.isShapeHitPointType(this.selectedHitPointType)) continue;
                                    this.selectedObject = ls;
                                    this.currentLocation = this.beginLocation = this.dLoc;
                                    this.startDelta = MathUtil.zeroPoint2D;
                                    break;
                                }
                            }
                        }
                    }
                }
            } else if (event.isShiftDown() && this.leToolBarPanel.trackButton.isSelected() && !event.isPopupTrigger()) {
                this.selectedObject = null;
                if (this.findLayoutTracksHitPoint(this.dLoc, true)) {
                    this.beginTrack = this.foundTrack;
                    this.beginHitPointType = this.foundHitPointType;
                    this.currentLocation = this.beginLocation = this.foundLocation;
                } else {
                    this.beginTrack = null;
                }
            } else if (event.isShiftDown() && this.leToolBarPanel.shapeButton.isSelected() && !event.isPopupTrigger()) {
                this.selectedObject = null;
                for (LayoutShape ls : this.layoutShapes) {
                    this.selectedHitPointType = ls.findHitPointType(this.dLoc, true);
                    if (!HitPointType.isShapePointOffsetHitPointType(this.selectedHitPointType)) continue;
                    this.selectedObject = ls;
                    this.currentLocation = this.beginLocation = this.dLoc;
                    break;
                }
            } else if (!(event.isShiftDown() || event.isControlDown() || event.isPopupTrigger())) {
                this.selectedObject = null;
                if (this.allControlling()) {
                    this.checkControls(false);
                }
                this.selectionActive = true;
                this.selectionX = this.dLoc.getX();
                this.selectionY = this.dLoc.getY();
                this.selectionWidth = 0.0;
                this.selectionHeight = 0.0;
            }
            if (prevSelectionActive) {
                this.redrawPanel();
            }
        } else if (!(!this.allControlling() || this.isMetaDown(event) || event.isPopupTrigger() || event.isAltDown() || event.isShiftDown() || event.isControlDown())) {
            this.selectedObject = null;
            this.checkControls(true);
        } else if ((this.isMetaDown(event) || event.isAltDown()) && !event.isShiftDown() && !event.isControlDown()) {
            this.selectedObject = this.checkMarkerPopUps(this.dLoc);
            if (this.selectedObject != null) {
                this.selectedHitPointType = HitPointType.MARKER;
                this.startDelta = MathUtil.subtract(((LocoIcon)this.selectedObject).getLocation(), this.dLoc);
            }
        } else if (event.isPopupTrigger() && !event.isShiftDown() && (lo = this.checkMarkerPopUps(this.dLoc)) != null) {
            this.delayedPopupTrigger = true;
        }
        if (!event.isPopupTrigger() && (selections = this.getSelectedItems(event)).size() > 0) {
            selections.get(0).doMousePressed(event);
        }
        this.requestFocusInWindow();
    }

    private void checkControls(boolean useRectangles) {
        this.selectedObject = null;
        for (LayoutTrackView theTrackView : this.getLayoutTrackViews()) {
            this.selectedHitPointType = theTrackView.findHitPointType(this.dLoc, useRectangles);
            if (!HitPointType.isControlHitType(this.selectedHitPointType)) continue;
            this.selectedObject = theTrackView.getLayoutTrack();
            return;
        }
    }

    private boolean findLayoutTracksHitPoint(@Nonnull Point2D loc, boolean requireUnconnected) {
        return this.findLayoutTracksHitPoint(loc, requireUnconnected, null);
    }

    private boolean findLayoutTracksHitPoint(@Nonnull Point2D loc) {
        return this.findLayoutTracksHitPoint(loc, false, null);
    }

    private boolean findLayoutTracksHitPoint(@Nonnull Point2D loc, boolean requireUnconnected, @CheckForNull LayoutTrack avoid) {
        boolean result = false;
        this.foundTrack = null;
        this.foundTrackView = null;
        this.foundHitPointType = HitPointType.NONE;
        Optional<LayoutTrack> opt = this.getLayoutTracks().stream().filter(layoutTrack2 -> {
            if (layoutTrack2 != avoid && layoutTrack2 != this.selectedObject) {
                this.foundHitPointType = this.getLayoutTrackView((LayoutTrack)layoutTrack2).findHitPointType(loc, false, requireUnconnected);
            }
            return HitPointType.NONE != this.foundHitPointType;
        }).findFirst();
        LayoutTrack layoutTrack = null;
        if (opt.isPresent()) {
            layoutTrack = opt.get();
        }
        if (layoutTrack != null) {
            this.foundTrack = layoutTrack;
            this.foundTrackView = this.getLayoutTrackView(layoutTrack);
            this.foundLocation = this.foundTrackView.getCoordsForConnectionType(this.foundHitPointType);
            result = true;
        }
        return result;
    }

    private TrackSegment checkTrackSegmentPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        TrackSegment result = null;
        Rectangle2D r = this.layoutEditorControlCircleRectAt(loc);
        for (TrackSegmentView tsv : this.getTrackSegmentViews()) {
            if (!r.contains(tsv.getCentreSeg())) continue;
            result = tsv.getTrackSegment();
            break;
        }
        return result;
    }

    private PositionableLabel checkBackgroundPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        PositionableLabel result = null;
        int i = this.backgroundImage.size() - 1;
        while (i >= 0) {
            PositionableLabel b = this.backgroundImage.get(i);
            Rectangle r = b.getBounds();
            if (r.contains(loc)) {
                result = b;
                break;
            }
            --i;
        }
        return result;
    }

    private SensorIcon checkSensorIconPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        SensorIcon result = null;
        int i = this.sensorImage.size() - 1;
        while (i >= 0) {
            SensorIcon s = this.sensorImage.get(i);
            Rectangle r = s.getBounds();
            if (r.contains(loc)) {
                result = s;
            }
            --i;
        }
        return result;
    }

    private SignalHeadIcon checkSignalHeadIconPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        SignalHeadIcon result = null;
        int i = this.signalHeadImage.size() - 1;
        while (i >= 0) {
            SignalHeadIcon s = this.signalHeadImage.get(i);
            Rectangle r = s.getBounds();
            if (r.contains(loc)) {
                result = s;
                break;
            }
            --i;
        }
        return result;
    }

    private SignalMastIcon checkSignalMastIconPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        SignalMastIcon result = null;
        int i = this.signalMastList.size() - 1;
        while (i >= 0) {
            SignalMastIcon s = this.signalMastList.get(i);
            Rectangle r = s.getBounds();
            if (r.contains(loc)) {
                result = s;
                break;
            }
            --i;
        }
        return result;
    }

    private PositionableLabel checkLabelImagePopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        PositionableLabel result = null;
        int level = 0;
        int i = this.labelImage.size() - 1;
        while (i >= 0) {
            PositionableLabel s = this.labelImage.get(i);
            double x = s.getX();
            double y = s.getY();
            double w = 10.0;
            double h = 5.0;
            if (s.isIcon() || s.isRotated() || s.getPopupUtility().getOrientation() != 0) {
                w = s.maxWidth();
                h = s.maxHeight();
            } else if (s.isText()) {
                h = s.getFont().getSize();
                w = h * 2.0 * (double)s.getText().length() / 3.0;
            }
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
            if (r.contains(loc) && s.getDisplayLevel() >= level) {
                result = s;
                level = s.getDisplayLevel();
            }
            --i;
        }
        return result;
    }

    private AnalogClock2Display checkClockPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        AnalogClock2Display result = null;
        int i = this.clocks.size() - 1;
        while (i >= 0) {
            AnalogClock2Display s = this.clocks.get(i);
            Rectangle r = s.getBounds();
            if (r.contains(loc)) {
                result = s;
                break;
            }
            --i;
        }
        return result;
    }

    private MultiSensorIcon checkMultiSensorPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        MultiSensorIcon result = null;
        int i = this.multiSensors.size() - 1;
        while (i >= 0) {
            MultiSensorIcon s = this.multiSensors.get(i);
            Rectangle r = s.getBounds();
            if (r.contains(loc)) {
                result = s;
                break;
            }
            --i;
        }
        return result;
    }

    private LocoIcon checkMarkerPopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        LocoIcon result = null;
        int i = this.markerImage.size() - 1;
        while (i >= 0) {
            LocoIcon l = this.markerImage.get(i);
            Rectangle r = l.getBounds();
            if (r.contains(loc)) {
                result = l;
                break;
            }
            --i;
        }
        return result;
    }

    private LayoutShape checkLayoutShapePopUps(@Nonnull Point2D loc) {
        assert (loc != null);
        LayoutShape result = null;
        for (LayoutShape ls : this.layoutShapes) {
            this.selectedHitPointType = ls.findHitPointType(loc, true);
            if (!LayoutShape.isShapeHitPointType(this.selectedHitPointType)) continue;
            result = ls;
            break;
        }
        return result;
    }

    @Nonnull
    public Point2D getCoords(@Nonnull LayoutTrack trk, HitPointType connectionType) {
        assert (trk != null);
        return this.getCoords(this.getLayoutTrackView(trk), connectionType);
    }

    @Nonnull
    public Point2D getCoords(@Nonnull LayoutTrackView trkv, HitPointType connectionType) {
        assert (trkv != null);
        return trkv.getCoordsForConnectionType(connectionType);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        List<Positionable> selections;
        LayoutSlip sl;
        LayoutTrack t;
        super.setToolTip(null);
        this.calcLocation(event);
        this.snapToGridInvert = event.isAltDown();
        if (this.isEditable()) {
            PositionablePoint p;
            this.leToolBarPanel.setLocationText(this.dLoc);
            if (!event.isPopupTrigger() && !this.isMetaDown(event) && event.isShiftDown()) {
                this.currentPoint = new Point2D.Double(this.xLoc, this.yLoc);
                if (this.snapToGridOnAdd != this.snapToGridInvert) {
                    this.currentPoint = MathUtil.granulize(this.currentPoint, (double)this.gContext.getGridSize());
                    this.xLoc = (int)this.currentPoint.getX();
                    this.yLoc = (int)this.currentPoint.getY();
                    this.leToolBarPanel.setLocationText(this.currentPoint);
                }
                if (this.leToolBarPanel.turnoutRHButton.isSelected()) {
                    this.addLayoutTurnout(LayoutTurnout.TurnoutType.RH_TURNOUT);
                } else if (this.leToolBarPanel.turnoutLHButton.isSelected()) {
                    this.addLayoutTurnout(LayoutTurnout.TurnoutType.LH_TURNOUT);
                } else if (this.leToolBarPanel.turnoutWYEButton.isSelected()) {
                    this.addLayoutTurnout(LayoutTurnout.TurnoutType.WYE_TURNOUT);
                } else if (this.leToolBarPanel.doubleXoverButton.isSelected()) {
                    this.addLayoutTurnout(LayoutTurnout.TurnoutType.DOUBLE_XOVER);
                } else if (this.leToolBarPanel.rhXoverButton.isSelected()) {
                    this.addLayoutTurnout(LayoutTurnout.TurnoutType.RH_XOVER);
                } else if (this.leToolBarPanel.lhXoverButton.isSelected()) {
                    this.addLayoutTurnout(LayoutTurnout.TurnoutType.LH_XOVER);
                } else if (this.leToolBarPanel.levelXingButton.isSelected()) {
                    this.addLevelXing();
                } else if (this.leToolBarPanel.layoutSingleSlipButton.isSelected()) {
                    this.addLayoutSlip(LayoutTurnout.TurnoutType.SINGLE_SLIP);
                } else if (this.leToolBarPanel.layoutDoubleSlipButton.isSelected()) {
                    this.addLayoutSlip(LayoutTurnout.TurnoutType.DOUBLE_SLIP);
                } else if (this.leToolBarPanel.endBumperButton.isSelected()) {
                    this.addEndBumper();
                } else if (this.leToolBarPanel.anchorButton.isSelected()) {
                    this.addAnchor();
                } else if (this.leToolBarPanel.edgeButton.isSelected()) {
                    this.addEdgeConnector();
                } else if (this.leToolBarPanel.trackButton.isSelected()) {
                    if (this.beginTrack != null && this.foundTrack != null && this.beginTrack != this.foundTrack) {
                        this.addTrackSegment();
                        this._targetPanel.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    this.beginTrack = null;
                    this.foundTrack = null;
                    this.foundTrackView = null;
                } else if (this.leToolBarPanel.multiSensorButton.isSelected()) {
                    this.startMultiSensor();
                } else if (this.leToolBarPanel.sensorButton.isSelected()) {
                    this.addSensor();
                } else if (this.leToolBarPanel.signalButton.isSelected()) {
                    this.addSignalHead();
                } else if (this.leToolBarPanel.textLabelButton.isSelected()) {
                    this.addLabel();
                } else if (this.leToolBarPanel.memoryButton.isSelected()) {
                    this.addMemory();
                } else if (this.leToolBarPanel.blockContentsButton.isSelected()) {
                    this.addBlockContents();
                } else if (this.leToolBarPanel.iconLabelButton.isSelected()) {
                    this.addIcon();
                } else if (this.leToolBarPanel.shapeButton.isSelected()) {
                    if (this.selectedObject == null) {
                        this.addLayoutShape(this.currentPoint);
                        this._targetPanel.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        LayoutShape ls = (LayoutShape)this.selectedObject;
                        ls.addPoint(this.currentPoint, this.selectedHitPointType.shapePointIndex());
                    }
                } else if (this.leToolBarPanel.signalMastButton.isSelected()) {
                    this.addSignalMast();
                } else {
                    log.warn("No item selected in panel edit mode");
                }
                this.selectedObject = null;
                this.redrawPanel();
            } else if ((event.isPopupTrigger() || this.delayedPopupTrigger) && !this.isDragging) {
                this.selectedObject = null;
                this.selectedHitPointType = HitPointType.NONE;
                this.whenReleased = event.getWhen();
                this.showEditPopUps(event);
            } else if (!(this.selectedObject == null || this.selectedHitPointType != HitPointType.TURNOUT_CENTER || !this.allControlling() || this.isMetaDown(event) || event.isAltDown() || event.isPopupTrigger() || event.isShiftDown() || event.isControlDown())) {
                t = (LayoutTurnout)this.selectedObject;
                ((LayoutTurnout)t).toggleTurnout();
            } else if (!(this.selectedObject == null || this.selectedHitPointType != HitPointType.SLIP_LEFT && this.selectedHitPointType != HitPointType.SLIP_RIGHT || !this.allControlling() || this.isMetaDown(event) || event.isAltDown() || event.isPopupTrigger() || event.isShiftDown() || event.isControlDown())) {
                sl = (LayoutSlip)this.selectedObject;
                sl.toggleState(this.selectedHitPointType);
            } else if (!(this.selectedObject == null || !HitPointType.isTurntableRayHitType(this.selectedHitPointType) || !this.allControlling() || this.isMetaDown(event) || event.isAltDown() || event.isPopupTrigger() || event.isShiftDown() || event.isControlDown())) {
                t = (LayoutTurntable)this.selectedObject;
                ((LayoutTurntable)t).setPosition(this.selectedHitPointType.turntableTrackIndex());
            } else if (this.selectedObject != null && (this.selectedHitPointType == HitPointType.TURNOUT_CENTER || this.selectedHitPointType == HitPointType.SLIP_CENTER || this.selectedHitPointType == HitPointType.SLIP_LEFT || this.selectedHitPointType == HitPointType.SLIP_RIGHT) && this.allControlling() && this.isMetaDown(event) && !event.isAltDown() && !event.isShiftDown() && !event.isControlDown() && this.isDragging) {
                this.hitPointCheckLayoutTurnouts((LayoutTurnout)this.selectedObject);
            } else if (this.selectedObject != null && this.selectedHitPointType == HitPointType.POS_POINT && this.allControlling() && this.isMetaDown(event) && !event.isShiftDown() && !event.isControlDown() && this.isDragging && ((p = (PositionablePoint)this.selectedObject).getConnect1() == null || p.getConnect2() == null)) {
                this.checkPointOfPositionable(p);
            }
            if (this.leToolBarPanel.trackButton.isSelected() && this.beginTrack != null && this.foundTrack != null) {
                this._targetPanel.setCursor(Cursor.getPredefinedCursor(0));
                this.beginTrack = null;
                this.foundTrack = null;
                this.foundTrackView = null;
                this.redrawPanel();
            }
            this.createSelectionGroups();
        } else if (!(this.selectedObject == null || this.selectedHitPointType != HitPointType.TURNOUT_CENTER || !this.allControlling() || this.isMetaDown(event) || event.isAltDown() || event.isPopupTrigger() || event.isShiftDown() || this.delayedPopupTrigger)) {
            t = (LayoutTurnout)this.selectedObject;
            if (this.useDirectTurnoutControl) {
                ((LayoutTurnout)t).setState(2);
            } else {
                ((LayoutTurnout)t).toggleTurnout();
            }
        } else if (!(this.selectedObject == null || this.selectedHitPointType != HitPointType.SLIP_LEFT && this.selectedHitPointType != HitPointType.SLIP_RIGHT || !this.allControlling() || this.isMetaDown(event) || event.isAltDown() || event.isPopupTrigger() || event.isShiftDown() || this.delayedPopupTrigger)) {
            sl = (LayoutSlip)this.selectedObject;
            sl.toggleState(this.selectedHitPointType);
        } else if (!(this.selectedObject == null || !HitPointType.isTurntableRayHitType(this.selectedHitPointType) || !this.allControlling() || this.isMetaDown(event) || event.isAltDown() || event.isPopupTrigger() || event.isShiftDown() || this.delayedPopupTrigger)) {
            t = (LayoutTurntable)this.selectedObject;
            ((LayoutTurntable)t).setPosition(this.selectedHitPointType.turntableTrackIndex());
        } else if ((event.isPopupTrigger() || this.delayedPopupTrigger) && !this.isDragging) {
            LocoIcon lo = this.checkMarkerPopUps(this.dLoc);
            if (lo != null) {
                this.showPopUp(lo, event);
            } else {
                AnalogClock2Display c;
                if (this.findLayoutTracksHitPoint(this.dLoc)) {
                    switch (this.foundHitPointType) {
                        case TURNOUT_CENTER: {
                            if (this.useDirectTurnoutControl) {
                                LayoutTurnout t2 = (LayoutTurnout)this.foundTrack;
                                t2.setState(4);
                                break;
                            }
                            this.foundTrackView.showPopup(event);
                            break;
                        }
                        case LEVEL_XING_CENTER: 
                        case SLIP_LEFT: 
                        case SLIP_RIGHT: {
                            this.foundTrackView.showPopup(event);
                            break;
                        }
                    }
                }
                if ((c = this.checkClockPopUps(this.dLoc)) != null) {
                    this.showPopUp(c, event);
                } else {
                    SignalMastIcon sm = this.checkSignalMastIconPopUps(this.dLoc);
                    if (sm != null) {
                        this.showPopUp(sm, event);
                    } else {
                        PositionableLabel im = this.checkLabelImagePopUps(this.dLoc);
                        if (im != null) {
                            this.showPopUp(im, event);
                        }
                    }
                }
            }
        }
        if (!event.isPopupTrigger() && !this.isDragging && (selections = this.getSelectedItems(event)).size() > 0) {
            selections.get(0).doMouseReleased(event);
            this.whenReleased = event.getWhen();
        }
        if (event.isPopupTrigger() && this.isDragging && (selections = this.getSelectedItems(event)).size() > 0) {
            selections.get(0).doMouseDragged(event);
        }
        if (this.selectedObject != null) {
            this.prevSelectedObject = this.selectedObject;
            this.selectedObject = null;
        }
        this.beginTrack = null;
        this.foundTrack = null;
        this.foundTrackView = null;
        this.delayedPopupTrigger = false;
        if (this.isDragging) {
            this.resizePanelBounds(true);
            this.isDragging = false;
        }
        this.requestFocusInWindow();
    }

    private void showEditPopUps(@Nonnull MouseEvent event) {
        if (this.findLayoutTracksHitPoint(this.dLoc)) {
            if (HitPointType.isBezierHitType(this.foundHitPointType)) {
                this.getTrackSegmentView((TrackSegment)this.foundTrack).showBezierPopUp(event, this.foundHitPointType);
            } else if (HitPointType.isTurntableRayHitType(this.foundHitPointType)) {
                LayoutTurntable t = (LayoutTurntable)this.foundTrack;
                if (t.isTurnoutControlled()) {
                    LayoutTurntableView ltview = this.getLayoutTurntableView((LayoutTurntable)this.foundTrack);
                    ltview.showRayPopUp(event, this.foundHitPointType.turntableTrackIndex());
                }
            } else if (HitPointType.isPopupHitType(this.foundHitPointType)) {
                this.foundTrackView.showPopup(event);
            } else if (!HitPointType.isTurnoutHitType(this.foundHitPointType)) {
                log.warn("Unknown foundPointType:{}", (Object)this.foundHitPointType);
            }
        } else {
            TrackSegment ts = this.checkTrackSegmentPopUps(this.dLoc);
            if (ts != null) {
                TrackSegmentView tsv = this.getTrackSegmentView(ts);
                tsv.showPopup(event);
            } else {
                SensorIcon s = this.checkSensorIconPopUps(this.dLoc);
                if (s != null) {
                    this.showPopUp(s, event);
                } else {
                    LocoIcon lo = this.checkMarkerPopUps(this.dLoc);
                    if (lo != null) {
                        this.showPopUp(lo, event);
                    } else {
                        SignalHeadIcon sh = this.checkSignalHeadIconPopUps(this.dLoc);
                        if (sh != null) {
                            this.showPopUp(sh, event);
                        } else {
                            AnalogClock2Display c = this.checkClockPopUps(this.dLoc);
                            if (c != null) {
                                this.showPopUp(c, event);
                            } else {
                                MultiSensorIcon ms = this.checkMultiSensorPopUps(this.dLoc);
                                if (ms != null) {
                                    this.showPopUp(ms, event);
                                } else {
                                    PositionableLabel lb = this.checkLabelImagePopUps(this.dLoc);
                                    if (lb != null) {
                                        this.showPopUp(lb, event);
                                    } else {
                                        PositionableLabel b = this.checkBackgroundPopUps(this.dLoc);
                                        if (b != null) {
                                            this.showPopUp(b, event);
                                        } else {
                                            SignalMastIcon sm = this.checkSignalMastIconPopUps(this.dLoc);
                                            if (sm != null) {
                                                this.showPopUp(sm, event);
                                            } else {
                                                LayoutShape ls = this.checkLayoutShapePopUps(this.dLoc);
                                                if (ls != null) {
                                                    ls.showShapePopUp(event, this.selectedHitPointType);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void showPopUp(@Nonnull Positionable p, @Nonnull MouseEvent event) {
        assert (p != null);
        if (!((Component)((Object)p)).isVisible()) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        if (p.isEditable()) {
            if (this.showAlignPopup()) {
                this.setShowAlignmentMenu(popup);
                popup.add(new AbstractAction(Bundle.getMessage("ButtonDelete")){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        LayoutEditor.this.deleteSelectedItems();
                    }
                });
            } else {
                if (p.doViemMenu()) {
                    String objectType = p.getClass().getName();
                    objectType = objectType.substring(objectType.lastIndexOf(46) + 1);
                    JMenuItem jmi = popup.add(objectType);
                    jmi.setEnabled(false);
                    jmi = popup.add(p.getNameString());
                    jmi.setEnabled(false);
                    if (p.isPositionable()) {
                        this.setShowCoordinatesMenu(p, popup);
                    }
                    this.setDisplayLevelMenu(p, popup);
                    this.setPositionableMenu(p, popup);
                }
                boolean popupSet = false;
                popupSet |= p.setRotateOrthogonalMenu(popup);
                if (popupSet |= p.setRotateMenu(popup)) {
                    popup.addSeparator();
                    popupSet = false;
                }
                popupSet |= p.setEditIconMenu(popup);
                popupSet |= p.setTextEditMenu(popup);
                PositionablePopupUtil util = p.getPopupUtility();
                if (util != null) {
                    util.setFixedTextMenu(popup);
                    util.setTextMarginMenu(popup);
                    util.setTextBorderMenu(popup);
                    util.setTextFontMenu(popup);
                    util.setBackgroundMenu(popup);
                    util.setTextJustificationMenu(popup);
                    util.setTextOrientationMenu(popup);
                    popup.addSeparator();
                    util.propertyUtil(popup);
                    util.setAdditionalEditPopUpMenu(popup);
                    popupSet = true;
                }
                if (popupSet) {
                    popup.addSeparator();
                }
                p.setDisableControlMenu(popup);
                this.setShowAlignmentMenu(popup);
                p.showPopUp(popup);
                this.setShowToolTipMenu(p, popup);
                this.setRemoveMenu(p, popup);
                if (p.doViemMenu()) {
                    this.setHiddenMenu(p, popup);
                    this.setEditIdMenu(p, popup);
                }
            }
        } else {
            p.showPopUp(popup);
            PositionablePopupUtil util = p.getPopupUtility();
            if (util != null) {
                util.setAdditionalViewPopUpMenu(popup);
            }
        }
        popup.show((Component)((Object)p), p.getWidth() / 2 + (int)((this.getZoom() - 1.0) * (double)p.getX()), p.getHeight() / 2 + (int)((this.getZoom() - 1.0) * (double)p.getY()));
    }

    @Override
    public void mouseClicked(@Nonnull MouseEvent event) {
        this.calcLocation(event);
        this.snapToGridInvert = event.isAltDown();
        if (!(this.isMetaDown(event) || event.isPopupTrigger() || event.isAltDown() || this.awaitingIconChange || event.isShiftDown() || event.isControlDown())) {
            List<Positionable> selections = this.getSelectedItems(event);
            if (selections.size() > 0) {
                selections.get(0).doMouseClicked(event);
            }
        } else if (event.isPopupTrigger() && this.whenReleased != event.getWhen()) {
            if (this.isEditable()) {
                this.selectedObject = null;
                this.selectedHitPointType = HitPointType.NONE;
                this.showEditPopUps(event);
            } else {
                LocoIcon lo = this.checkMarkerPopUps(this.dLoc);
                if (lo != null) {
                    this.showPopUp(lo, event);
                }
            }
        }
        if (event.isControlDown() && !event.isPopupTrigger()) {
            if (this.findLayoutTracksHitPoint(this.dLoc)) {
                switch (this.foundHitPointType) {
                    case POS_POINT: 
                    case TURNOUT_CENTER: 
                    case LEVEL_XING_CENTER: 
                    case TURNTABLE_CENTER: 
                    case SLIP_LEFT: 
                    case SLIP_RIGHT: {
                        this.amendSelectionGroup(this.foundTrack);
                        break;
                    }
                }
            } else {
                SensorIcon s = this.checkSensorIconPopUps(this.dLoc);
                if (s != null) {
                    this.amendSelectionGroup(s);
                } else {
                    SignalHeadIcon sh = this.checkSignalHeadIconPopUps(this.dLoc);
                    if (sh != null) {
                        this.amendSelectionGroup(sh);
                    } else {
                        MultiSensorIcon ms = this.checkMultiSensorPopUps(this.dLoc);
                        if (ms != null) {
                            this.amendSelectionGroup(ms);
                        } else {
                            PositionableLabel lb = this.checkLabelImagePopUps(this.dLoc);
                            if (lb != null) {
                                this.amendSelectionGroup(lb);
                            } else {
                                PositionableLabel b = this.checkBackgroundPopUps(this.dLoc);
                                if (b != null) {
                                    this.amendSelectionGroup(b);
                                } else {
                                    SignalMastIcon sm = this.checkSignalMastIconPopUps(this.dLoc);
                                    if (sm != null) {
                                        this.amendSelectionGroup(sm);
                                    } else {
                                        LayoutShape ls = this.checkLayoutShapePopUps(this.dLoc);
                                        if (ls != null) {
                                            this.amendSelectionGroup(ls);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (this.selectionWidth == 0.0 || this.selectionHeight == 0.0) {
            this.clearSelectionGroups();
        }
        this.requestFocusInWindow();
    }

    private void checkPointOfPositionable(@Nonnull PositionablePoint p) {
        assert (p != null);
        TrackSegment t = p.getConnect1();
        if (t == null) {
            t = p.getConnect2();
        }
        if (t == null) {
            return;
        }
        this.beginTrack = p;
        this.beginHitPointType = HitPointType.POS_POINT;
        PositionablePointView pv = this.getPositionablePointView(p);
        Point2D loc = pv.getCoordsCenter();
        if (this.findLayoutTracksHitPoint(loc, true, p)) {
            switch (this.foundHitPointType) {
                case POS_POINT: {
                    PositionablePoint p2 = (PositionablePoint)this.foundTrack;
                    if (p2.getType() != PositionablePoint.PointType.ANCHOR || !p2.setTrackConnection(t)) break;
                    if (t.getConnect1() == p) {
                        t.setNewConnect1(p2, this.foundHitPointType);
                    } else {
                        t.setNewConnect2(p2, this.foundHitPointType);
                    }
                    p.removeTrackConnection(t);
                    if (p.getConnect1() != null || p.getConnect2() != null) break;
                    this.removePositionablePoint(p);
                    break;
                }
                case TURNOUT_A: 
                case TURNOUT_B: 
                case TURNOUT_C: 
                case TURNOUT_D: 
                case LEVEL_XING_A: 
                case LEVEL_XING_B: 
                case LEVEL_XING_C: 
                case LEVEL_XING_D: 
                case SLIP_A: 
                case SLIP_B: 
                case SLIP_C: 
                case SLIP_D: {
                    try {
                        if (this.foundTrack.getConnection(this.foundHitPointType) != null) break;
                        this.foundTrack.setConnection(this.foundHitPointType, t, HitPointType.TRACK);
                        if (t.getConnect1() == p) {
                            t.setNewConnect1(this.foundTrack, this.foundHitPointType);
                        } else {
                            t.setNewConnect2(this.foundTrack, this.foundHitPointType);
                        }
                        p.removeTrackConnection(t);
                        if (p.getConnect1() != null || p.getConnect2() != null) break;
                        this.removePositionablePoint(p);
                    }
                    catch (JmriException jmriException) {
                        log.debug("Unable to set location");
                    }
                    break;
                }
                default: {
                    if (HitPointType.isTurntableRayHitType(this.foundHitPointType)) {
                        LayoutTurntable tt = (LayoutTurntable)this.foundTrack;
                        int ray = this.foundHitPointType.turntableTrackIndex();
                        if (tt.getRayConnectIndexed(ray) != null) break;
                        tt.setRayConnect(t, ray);
                        if (t.getConnect1() == p) {
                            t.setNewConnect1(tt, this.foundHitPointType);
                        } else {
                            t.setNewConnect2(tt, this.foundHitPointType);
                        }
                        p.removeTrackConnection(t);
                        if (p.getConnect1() != null || p.getConnect2() != null) break;
                        this.removePositionablePoint(p);
                        break;
                    }
                    log.debug("No valid point, so will quit");
                    return;
                }
            }
            this.redrawPanel();
            if (t.getLayoutBlock() != null) {
                this.getLEAuxTools().setBlockConnectivityChanged();
            }
        }
        this.beginTrack = null;
    }

    private void hitPointCheckLayoutTurnouts(@Nonnull LayoutTurnout lt) {
        this.beginTrack = lt;
        LayoutTurnoutView ltv = this.getLayoutTurnoutView(lt);
        if (lt.getConnectA() == null) {
            this.beginHitPointType = lt instanceof LayoutSlip ? HitPointType.SLIP_A : HitPointType.TURNOUT_A;
            this.dLoc = ltv.getCoordsA();
            this.hitPointCheckLayoutTurnoutSubs(this.dLoc);
        }
        if (lt.getConnectB() == null) {
            this.beginHitPointType = lt instanceof LayoutSlip ? HitPointType.SLIP_B : HitPointType.TURNOUT_B;
            this.dLoc = ltv.getCoordsB();
            this.hitPointCheckLayoutTurnoutSubs(this.dLoc);
        }
        if (lt.getConnectC() == null) {
            this.beginHitPointType = lt instanceof LayoutSlip ? HitPointType.SLIP_C : HitPointType.TURNOUT_C;
            this.dLoc = ltv.getCoordsC();
            this.hitPointCheckLayoutTurnoutSubs(this.dLoc);
        }
        if (lt.getConnectD() == null && (lt.isTurnoutTypeXover() || lt.isTurnoutTypeSlip())) {
            this.beginHitPointType = lt instanceof LayoutSlip ? HitPointType.SLIP_D : HitPointType.TURNOUT_D;
            this.dLoc = ltv.getCoordsD();
            this.hitPointCheckLayoutTurnoutSubs(this.dLoc);
        }
        this.beginTrack = null;
        this.foundTrack = null;
        this.foundTrackView = null;
    }

    private void hitPointCheckLayoutTurnoutSubs(@Nonnull Point2D dLoc) {
        assert (dLoc != null);
        if (this.findLayoutTracksHitPoint(dLoc, true)) {
            switch (this.foundHitPointType) {
                case POS_POINT: {
                    PositionablePoint p2 = (PositionablePoint)this.foundTrack;
                    if ((p2.getConnect1() != null || p2.getConnect2() == null) && (p2.getConnect1() == null || p2.getConnect2() != null)) break;
                    TrackSegment t = p2.getConnect1();
                    if (t == null) {
                        t = p2.getConnect2();
                    }
                    if (t == null) {
                        return;
                    }
                    LayoutTurnout lt = (LayoutTurnout)this.beginTrack;
                    try {
                        if (lt.getConnection(this.beginHitPointType) == null) {
                            lt.setConnection(this.beginHitPointType, t, HitPointType.TRACK);
                            p2.removeTrackConnection(t);
                            if (t.getConnect1() == p2) {
                                t.setNewConnect1(lt, this.beginHitPointType);
                            } else {
                                t.setNewConnect2(lt, this.beginHitPointType);
                            }
                            this.removePositionablePoint(p2);
                        }
                        if (t.getLayoutBlock() == null) break;
                        this.getLEAuxTools().setBlockConnectivityChanged();
                    }
                    catch (JmriException jmriException) {
                        log.debug("Unable to set location");
                    }
                    break;
                }
                case TURNOUT_A: 
                case TURNOUT_B: 
                case TURNOUT_C: 
                case TURNOUT_D: 
                case SLIP_A: 
                case SLIP_B: 
                case SLIP_C: 
                case SLIP_D: {
                    LayoutTurnout ft = (LayoutTurnout)this.foundTrack;
                    this.addTrackSegment();
                    if (ft.getTurnoutType() == LayoutTurnout.TurnoutType.RH_TURNOUT || ft.getTurnoutType() == LayoutTurnout.TurnoutType.LH_TURNOUT) {
                        this.rotateTurnout(ft);
                    }
                    ((LayoutTurnoutView)this.foundTrackView).setTrackSegmentBlock(this.foundHitPointType, true);
                    break;
                }
                default: {
                    log.warn("Unexpected foundPointType {} in hitPointCheckLayoutTurnoutSubs", (Object)this.foundHitPointType);
                }
            }
        }
    }

    private void rotateTurnout(@Nonnull LayoutTurnout t) {
        Point2D xy2;
        Point2D diverg;
        Point2D c;
        assert (t != null);
        LayoutTurnoutView tv = this.getLayoutTurnoutView(t);
        LayoutTurnout be = (LayoutTurnout)this.beginTrack;
        LayoutTurnoutView bev = this.getLayoutTurnoutView(be);
        if (this.beginHitPointType == HitPointType.TURNOUT_A && (be.getConnectB() != null || be.getConnectC() != null) || this.beginHitPointType == HitPointType.TURNOUT_B && (be.getConnectA() != null || be.getConnectC() != null) || this.beginHitPointType == HitPointType.TURNOUT_C && (be.getConnectB() != null || be.getConnectA() != null)) {
            return;
        }
        if (be.getTurnoutType() != LayoutTurnout.TurnoutType.RH_TURNOUT && be.getTurnoutType() != LayoutTurnout.TurnoutType.LH_TURNOUT) {
            return;
        }
        if (this.foundHitPointType == HitPointType.TURNOUT_C && this.beginHitPointType == HitPointType.TURNOUT_C) {
            c = tv.getCoordsA();
            diverg = tv.getCoordsB();
            xy2 = MathUtil.subtract(c, diverg);
        } else if (this.foundHitPointType == HitPointType.TURNOUT_C && (this.beginHitPointType == HitPointType.TURNOUT_A || this.beginHitPointType == HitPointType.TURNOUT_B)) {
            c = tv.getCoordsCenter();
            diverg = tv.getCoordsC();
            xy2 = this.beginHitPointType == HitPointType.TURNOUT_A ? MathUtil.subtract(bev.getCoordsB(), bev.getCoordsA()) : MathUtil.subtract(bev.getCoordsA(), bev.getCoordsB());
        } else if (this.foundHitPointType == HitPointType.TURNOUT_B) {
            c = tv.getCoordsA();
            diverg = tv.getCoordsB();
            switch (this.beginHitPointType) {
                case TURNOUT_B: {
                    xy2 = MathUtil.subtract(bev.getCoordsA(), bev.getCoordsB());
                    break;
                }
                case TURNOUT_A: {
                    xy2 = MathUtil.subtract(bev.getCoordsB(), bev.getCoordsA());
                    break;
                }
                default: {
                    xy2 = MathUtil.subtract(bev.getCoordsCenter(), bev.getCoordsC());
                    break;
                }
            }
        } else if (this.foundHitPointType == HitPointType.TURNOUT_A) {
            c = tv.getCoordsA();
            diverg = tv.getCoordsB();
            switch (this.beginHitPointType) {
                case TURNOUT_A: {
                    xy2 = MathUtil.subtract(bev.getCoordsA(), bev.getCoordsB());
                    break;
                }
                case TURNOUT_B: {
                    xy2 = MathUtil.subtract(bev.getCoordsB(), bev.getCoordsA());
                    break;
                }
                default: {
                    xy2 = MathUtil.subtract(bev.getCoordsC(), bev.getCoordsCenter());
                    break;
                }
            }
        } else {
            return;
        }
        Point2D xy = MathUtil.subtract(diverg, c);
        double radius = Math.toDegrees(Math.atan2(xy.getY(), xy.getX()));
        double eRadius = Math.toDegrees(Math.atan2(xy2.getY(), xy2.getX()));
        bev.rotateCoords(radius - eRadius);
        Point2D conCord = bev.getCoordsA();
        Point2D tCord = tv.getCoordsC();
        if (this.foundHitPointType == HitPointType.TURNOUT_B) {
            tCord = tv.getCoordsB();
        }
        if (this.foundHitPointType == HitPointType.TURNOUT_A) {
            tCord = tv.getCoordsA();
        }
        switch (this.beginHitPointType) {
            case TURNOUT_A: {
                conCord = bev.getCoordsA();
                break;
            }
            case TURNOUT_B: {
                conCord = bev.getCoordsB();
                break;
            }
            case TURNOUT_C: {
                conCord = bev.getCoordsC();
                break;
            }
        }
        xy = MathUtil.subtract(conCord, tCord);
        Point2D offset = MathUtil.subtract(bev.getCoordsCenter(), xy);
        bev.setCoordsCenter(offset);
    }

    @Nonnull
    public List<Positionable> getPositionalSelection() {
        return this._positionableSelection;
    }

    @Nonnull
    public List<LayoutTrack> getLayoutTrackSelection() {
        return this._layoutTrackSelection;
    }

    @Nonnull
    public List<LayoutShape> getLayoutShapeSelection() {
        return this._layoutShapeSelection;
    }

    private void createSelectionGroups() {
        Rectangle2D selectionRect = this.getSelectionRect();
        this.getContents().forEach(o -> {
            if (selectionRect.contains(o.getLocation())) {
                log.trace("found item o of class {}", o.getClass());
                if (!this._positionableSelection.contains(o)) {
                    this._positionableSelection.add((Positionable)o);
                }
            }
        });
        this.getLayoutTracks().forEach(lt -> {
            LayoutTrackView ltv = this.getLayoutTrackView((LayoutTrack)lt);
            Point2D center = ltv.getCoordsCenter();
            if (selectionRect.contains(center) && !this._layoutTrackSelection.contains(lt)) {
                this._layoutTrackSelection.add((LayoutTrack)lt);
            }
        });
        this.assignBlockToSelectionMenuItem.setEnabled(this._layoutTrackSelection.size() > 0);
        this.layoutShapes.forEach(ls -> {
            if (selectionRect.intersects(ls.getBounds()) && !this._layoutShapeSelection.contains(ls)) {
                this._layoutShapeSelection.add((LayoutShape)ls);
            }
        });
        this.redrawPanel();
    }

    public void clearSelectionGroups() {
        this.selectionActive = false;
        this._positionableSelection.clear();
        this._layoutTrackSelection.clear();
        this.assignBlockToSelectionMenuItem.setEnabled(false);
        this._layoutShapeSelection.clear();
    }

    private void deleteSelectedItems() {
        if (!this.noWarnGlobalDelete) {
            int selectedValue = JOptionPane.showOptionDialog(this, Bundle.getMessage("Question6"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue == 1) {
                return;
            }
            if (selectedValue == 2) {
                this.noWarnGlobalDelete = true;
            }
        }
        this._positionableSelection.forEach(this::remove);
        this._layoutTrackSelection.forEach(lt -> {
            if (lt instanceof PositionablePoint) {
                boolean oldWarning = this.noWarnPositionablePoint;
                this.noWarnPositionablePoint = true;
                this.removePositionablePoint((PositionablePoint)lt);
                this.noWarnPositionablePoint = oldWarning;
            } else if (lt instanceof LevelXing) {
                boolean oldWarning = this.noWarnLevelXing;
                this.noWarnLevelXing = true;
                this.removeLevelXing((LevelXing)lt);
                this.noWarnLevelXing = oldWarning;
            } else if (lt instanceof LayoutSlip) {
                boolean oldWarning = this.noWarnSlip;
                this.noWarnSlip = true;
                this.removeLayoutSlip((LayoutSlip)lt);
                this.noWarnSlip = oldWarning;
            } else if (lt instanceof LayoutTurntable) {
                boolean oldWarning = this.noWarnTurntable;
                this.noWarnTurntable = true;
                this.removeTurntable((LayoutTurntable)lt);
                this.noWarnTurntable = oldWarning;
            } else if (lt instanceof LayoutTurnout) {
                boolean oldWarning = this.noWarnLayoutTurnout;
                this.noWarnLayoutTurnout = true;
                this.removeLayoutTurnout((LayoutTurnout)lt);
                this.noWarnLayoutTurnout = oldWarning;
            }
        });
        this.layoutShapes.removeAll(this._layoutShapeSelection);
        this.clearSelectionGroups();
        this.redrawPanel();
    }

    private void amendSelectionGroup(@Nonnull Positionable p) {
        assert (p != null);
        if (this._positionableSelection.contains(p)) {
            this._positionableSelection.remove(p);
        } else {
            this._positionableSelection.add(p);
        }
        this.redrawPanel();
    }

    public void amendSelectionGroup(@Nonnull LayoutTrack p) {
        assert (p != null);
        if (this._layoutTrackSelection.contains(p)) {
            this._layoutTrackSelection.remove(p);
        } else {
            this._layoutTrackSelection.add(p);
        }
        this.assignBlockToSelectionMenuItem.setEnabled(this._layoutTrackSelection.size() > 0);
        this.redrawPanel();
    }

    public void amendSelectionGroup(@Nonnull LayoutShape ls) {
        assert (ls != null);
        if (this._layoutShapeSelection.contains(ls)) {
            this._layoutShapeSelection.remove(ls);
        } else {
            this._layoutShapeSelection.add(ls);
        }
        this.redrawPanel();
    }

    public void alignSelection(boolean alignX) {
        Point2D p;
        Point2D minPoint = MathUtil.infinityPoint2D;
        Point2D maxPoint = MathUtil.zeroPoint2D;
        Point2D sumPoint = MathUtil.zeroPoint2D;
        int cnt = 0;
        for (Positionable comp : this._positionableSelection) {
            if (!this.getFlag(1, comp.isPositionable())) continue;
            p = MathUtil.pointToPoint2D(comp.getLocation());
            minPoint = MathUtil.min(minPoint, p);
            maxPoint = MathUtil.max(maxPoint, p);
            sumPoint = MathUtil.add(sumPoint, p);
            ++cnt;
        }
        for (LayoutTrack lt2 : this._layoutTrackSelection) {
            LayoutTrackView ltv = this.getLayoutTrackView(lt2);
            Point2D p2 = ltv.getCoordsCenter();
            minPoint = MathUtil.min(minPoint, p2);
            maxPoint = MathUtil.max(maxPoint, p2);
            sumPoint = MathUtil.add(sumPoint, p2);
            ++cnt;
        }
        for (LayoutShape ls2 : this._layoutShapeSelection) {
            p = ls2.getCoordsCenter();
            minPoint = MathUtil.min(minPoint, p);
            maxPoint = MathUtil.max(maxPoint, p);
            sumPoint = MathUtil.add(sumPoint, p);
            ++cnt;
        }
        Point2D avePoint = MathUtil.divide(sumPoint, cnt);
        int aveX = (int)avePoint.getX();
        int aveY = (int)avePoint.getY();
        for (Positionable comp : this._positionableSelection) {
            if (!this.getFlag(1, comp.isPositionable())) continue;
            if (alignX) {
                comp.setLocation(aveX, comp.getY());
                continue;
            }
            comp.setLocation(comp.getX(), aveY);
        }
        this._layoutTrackSelection.forEach(lt -> {
            LayoutTrackView ltv = this.getLayoutTrackView((LayoutTrack)lt);
            if (alignX) {
                ltv.setCoordsCenter(new Point2D.Double(aveX, ltv.getCoordsCenter().getY()));
            } else {
                ltv.setCoordsCenter(new Point2D.Double(ltv.getCoordsCenter().getX(), aveY));
            }
        });
        this._layoutShapeSelection.forEach(ls -> {
            if (alignX) {
                ls.setCoordsCenter(new Point2D.Double(aveX, ls.getCoordsCenter().getY()));
            } else {
                ls.setCoordsCenter(new Point2D.Double(ls.getCoordsCenter().getX(), aveY));
            }
        });
        this.redrawPanel();
    }

    private boolean showAlignPopup() {
        return this._positionableSelection.size() > 0 || this._layoutTrackSelection.size() > 0 || this._layoutShapeSelection.size() > 0;
    }

    public boolean setShowAlignmentMenu(@Nonnull JPopupMenu popup) {
        if (this.showAlignPopup()) {
            JMenu edit = new JMenu(Bundle.getMessage("EditAlignment"));
            edit.add(new AbstractAction(Bundle.getMessage("AlignX")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    LayoutEditor.this.alignSelection(true);
                }
            });
            edit.add(new AbstractAction(Bundle.getMessage("AlignY")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    LayoutEditor.this.alignSelection(false);
                }
            });
            popup.add(edit);
            return true;
        }
        return false;
    }

    @Override
    public void keyPressed(@Nonnull KeyEvent event) {
        if (event.getKeyCode() == 127) {
            this.deleteSelectedItems();
            return;
        }
        double deltaX = this.returnDeltaPositionX(event);
        double deltaY = this.returnDeltaPositionY(event);
        if (deltaX != 0.0 || deltaY != 0.0) {
            this.selectionX += deltaX;
            this.selectionY += deltaY;
            Point2D.Double delta = new Point2D.Double(deltaX, deltaY);
            this._positionableSelection.forEach(c -> {
                Point2D newPoint = c.getLocation();
                if (c instanceof MemoryIcon && c.getPopupUtility().getFixedWidth() == 0) {
                    MemoryIcon pm = (MemoryIcon)c;
                    newPoint = new Point2D.Double(pm.getOriginalX(), pm.getOriginalY());
                }
                newPoint = MathUtil.add(newPoint, delta);
                newPoint = MathUtil.max(MathUtil.zeroPoint2D, newPoint);
                c.setLocation(MathUtil.point2DToPoint(newPoint));
            });
            this._layoutTrackSelection.forEach(lt -> {
                LayoutTrackView ltv = this.getLayoutTrackView((LayoutTrack)lt);
                Point2D newPoint = MathUtil.add(ltv.getCoordsCenter(), delta);
                newPoint = MathUtil.max(MathUtil.zeroPoint2D, newPoint);
                this.getLayoutTrackView((LayoutTrack)lt).setCoordsCenter(newPoint);
            });
            this._layoutShapeSelection.forEach(ls -> {
                Point2D newPoint = MathUtil.add(ls.getCoordsCenter(), delta);
                newPoint = MathUtil.max(MathUtil.zeroPoint2D, newPoint);
                ls.setCoordsCenter(newPoint);
            });
            this.redrawPanel();
            return;
        }
        this.getLayoutEditorToolBarPanel().keyPressed(event);
    }

    private double returnDeltaPositionX(@Nonnull KeyEvent event) {
        double result = 0.0;
        double amount = event.isShiftDown() ? 5.0 : 1.0;
        switch (event.getKeyCode()) {
            case 37: {
                result = -amount;
                break;
            }
            case 39: {
                result = amount;
                break;
            }
        }
        return result;
    }

    private double returnDeltaPositionY(@Nonnull KeyEvent event) {
        double result = 0.0;
        double amount = event.isShiftDown() ? 5.0 : 1.0;
        switch (event.getKeyCode()) {
            case 38: {
                result = -amount;
                break;
            }
            case 40: {
                result = amount;
                break;
            }
        }
        return result;
    }

    @Override
    public void mouseMoved(@Nonnull MouseEvent event) {
        this.calcLocation(event);
        this.snapToGridInvert = event.isAltDown();
        if (this.isEditable()) {
            this.leToolBarPanel.setLocationText(this.dLoc);
        }
        List<Positionable> selections = this.getSelectedItems(event);
        Positionable selection = null;
        int numSel = selections.size();
        if (numSel > 0) {
            selection = selections.get(0);
        }
        if (selection != null && selection.getDisplayLevel() > 1 && selection.showToolTip()) {
            this.showToolTip(selection, event);
        } else {
            super.setToolTip(null);
        }
        if (numSel != this._prevNumSel) {
            this.redrawPanel();
            this._prevNumSel = numSel;
        }
        if (this.findLayoutTracksHitPoint(this.dLoc)) {
            if (HitPointType.isControlHitType(this.foundHitPointType)) {
                this._targetPanel.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this._targetPanel.setCursor(Cursor.getPredefinedCursor(1));
            }
            this.foundTrack = null;
            this.foundHitPointType = HitPointType.NONE;
        } else {
            this._targetPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseDragged(@Nonnull MouseEvent event) {
        block45: {
            block41: {
                block44: {
                    block42: {
                        block43: {
                            Point2D newPoint;
                            this.calcLocation(event);
                            if (!this.isDragging && this.xLoc == this.getAnchorX() && this.yLoc == this.getAnchorY()) {
                                return;
                            }
                            this.snapToGridInvert = event.isAltDown();
                            if (this.isEditable()) {
                                this.leToolBarPanel.setLocationText(this.dLoc);
                            }
                            this.currentPoint = MathUtil.add(this.dLoc, this.startDelta);
                            this.currentPoint = MathUtil.max(this.currentPoint, MathUtil.zeroPoint2D);
                            if (this.selectedObject != null && (this.isMetaDown(event) || event.isAltDown()) && this.selectedHitPointType == HitPointType.MARKER) {
                                PositionableLabel pl = (PositionableLabel)this.selectedObject;
                                pl.setLocation((int)this.currentPoint.getX(), (int)this.currentPoint.getY());
                                this.isDragging = true;
                                this.redrawPanel();
                                return;
                            }
                            if (!this.isEditable()) break block41;
                            if (this.selectedObject == null || !this.isMetaDown(event) || !this.allPositionable()) break block42;
                            if (this.snapToGridOnMove != this.snapToGridInvert) {
                                this.currentPoint = MathUtil.granulize(this.currentPoint, (double)this.gContext.getGridSize());
                                this.xLoc = (int)this.currentPoint.getX();
                                this.yLoc = (int)this.currentPoint.getY();
                                this.leToolBarPanel.setLocationText(this.currentPoint);
                            }
                            if (this._positionableSelection.size() <= 0 && this._layoutTrackSelection.size() <= 0 && this._layoutShapeSelection.size() <= 0) break block43;
                            Point2D.Double lastPoint = new Point2D.Double(this._lastX, this._lastY);
                            Point2D offset = MathUtil.subtract(this.currentPoint, lastPoint);
                            for (Positionable c : this._positionableSelection) {
                                if (c instanceof MemoryIcon && c.getPopupUtility().getFixedWidth() == 0) {
                                    MemoryIcon pm = (MemoryIcon)c;
                                    newPoint = new Point2D.Double(pm.getOriginalX(), pm.getOriginalY());
                                } else {
                                    newPoint = c.getLocation();
                                }
                                newPoint = MathUtil.add(newPoint, offset);
                                newPoint = MathUtil.max(newPoint, MathUtil.zeroPoint2D);
                                c.setLocation(MathUtil.point2DToPoint(newPoint));
                            }
                            for (LayoutTrack lt : this._layoutTrackSelection) {
                                LayoutTrackView ltv = this.getLayoutTrackView(lt);
                                Point2D center = ltv.getCoordsCenter();
                                newPoint = MathUtil.add(center, offset);
                                newPoint = MathUtil.max(newPoint, MathUtil.zeroPoint2D);
                                this.getLayoutTrackView(lt).setCoordsCenter(newPoint);
                            }
                            for (LayoutShape ls : this._layoutShapeSelection) {
                                Point2D center = ls.getCoordsCenter();
                                newPoint = MathUtil.add(center, offset);
                                newPoint = MathUtil.max(newPoint, MathUtil.zeroPoint2D);
                                ls.setCoordsCenter(newPoint);
                            }
                            this._lastX = this.xLoc;
                            this._lastY = this.yLoc;
                            break block44;
                        }
                        switch (this.selectedHitPointType) {
                            case POS_POINT: 
                            case TURNOUT_CENTER: 
                            case LEVEL_XING_CENTER: 
                            case TURNTABLE_CENTER: 
                            case SLIP_LEFT: 
                            case SLIP_RIGHT: {
                                this.getLayoutTrackView((LayoutTrack)this.selectedObject).setCoordsCenter(this.currentPoint);
                                this.isDragging = true;
                                break;
                            }
                            case TURNOUT_A: {
                                this.getLayoutTurnoutView((LayoutTurnout)this.selectedObject).setCoordsA(this.currentPoint);
                                break;
                            }
                            case TURNOUT_B: {
                                this.getLayoutTurnoutView((LayoutTurnout)this.selectedObject).setCoordsB(this.currentPoint);
                                break;
                            }
                            case TURNOUT_C: {
                                this.getLayoutTurnoutView((LayoutTurnout)this.selectedObject).setCoordsC(this.currentPoint);
                                break;
                            }
                            case TURNOUT_D: {
                                this.getLayoutTurnoutView((LayoutTurnout)this.selectedObject).setCoordsD(this.currentPoint);
                                break;
                            }
                            case LEVEL_XING_A: {
                                this.getLevelXingView((LevelXing)this.selectedObject).setCoordsA(this.currentPoint);
                                break;
                            }
                            case LEVEL_XING_B: {
                                this.getLevelXingView((LevelXing)this.selectedObject).setCoordsB(this.currentPoint);
                                break;
                            }
                            case LEVEL_XING_C: {
                                this.getLevelXingView((LevelXing)this.selectedObject).setCoordsC(this.currentPoint);
                                break;
                            }
                            case LEVEL_XING_D: {
                                this.getLevelXingView((LevelXing)this.selectedObject).setCoordsD(this.currentPoint);
                                break;
                            }
                            case SLIP_A: {
                                this.getLayoutSlipView((LayoutSlip)this.selectedObject).setCoordsA(this.currentPoint);
                                break;
                            }
                            case SLIP_B: {
                                this.getLayoutSlipView((LayoutSlip)this.selectedObject).setCoordsB(this.currentPoint);
                                break;
                            }
                            case SLIP_C: {
                                this.getLayoutSlipView((LayoutSlip)this.selectedObject).setCoordsC(this.currentPoint);
                                break;
                            }
                            case SLIP_D: {
                                this.getLayoutSlipView((LayoutSlip)this.selectedObject).setCoordsD(this.currentPoint);
                                break;
                            }
                            case LAYOUT_POS_LABEL: 
                            case MULTI_SENSOR: {
                                PositionableLabel pl = (PositionableLabel)this.selectedObject;
                                if (pl.isPositionable()) {
                                    pl.setLocation((int)this.currentPoint.getX(), (int)this.currentPoint.getY());
                                    this.isDragging = true;
                                    break;
                                }
                                break block44;
                            }
                            case LAYOUT_POS_JCOMP: {
                                PositionableJComponent c = (PositionableJComponent)this.selectedObject;
                                if (c.isPositionable()) {
                                    c.setLocation((int)this.currentPoint.getX(), (int)this.currentPoint.getY());
                                    this.isDragging = true;
                                    break;
                                }
                                break block44;
                            }
                            case TRACK_CIRCLE_CENTRE: {
                                TrackSegmentView tv = this.getTrackSegmentView((TrackSegment)this.selectedObject);
                                tv.reCalculateTrackSegmentAngle(this.currentPoint.getX(), this.currentPoint.getY());
                                break;
                            }
                            default: {
                                if (HitPointType.isBezierHitType(this.foundHitPointType)) {
                                    int index = this.selectedHitPointType.bezierPointIndex();
                                    this.getTrackSegmentView((TrackSegment)this.selectedObject).setBezierControlPoint(this.currentPoint, index);
                                    break;
                                }
                                if (this.selectedHitPointType == HitPointType.SHAPE_CENTER) {
                                    ((LayoutShape)this.selectedObject).setCoordsCenter(this.currentPoint);
                                    break;
                                }
                                if (HitPointType.isShapePointOffsetHitPointType(this.selectedHitPointType)) {
                                    int index = this.selectedHitPointType.shapePointIndex();
                                    ((LayoutShape)this.selectedObject).setPoint(index, this.currentPoint);
                                    break;
                                }
                                if (HitPointType.isTurntableRayHitType(this.selectedHitPointType)) {
                                    LayoutTurntable turn = (LayoutTurntable)this.selectedObject;
                                    LayoutTurntableView turnView = this.getLayoutTurntableView(turn);
                                    turnView.setRayCoordsIndexed(this.currentPoint.getX(), this.currentPoint.getY(), this.selectedHitPointType.turntableTrackIndex());
                                    break;
                                }
                                break block44;
                            }
                        }
                        break block44;
                    }
                    if (this.beginTrack != null && event.isShiftDown() && this.leToolBarPanel.trackButton.isSelected()) {
                        boolean needResetCursor;
                        this.currentLocation = new Point2D.Double(this.xLoc, this.yLoc);
                        boolean bl = needResetCursor = this.foundTrack != null;
                        if (this.findLayoutTracksHitPoint(this.currentLocation, true)) {
                            this._targetPanel.setCursor(Cursor.getPredefinedCursor(1));
                        } else if (needResetCursor) {
                            this._targetPanel.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    } else if (event.isShiftDown() && this.leToolBarPanel.shapeButton.isSelected() && this.selectedObject != null) {
                        this.currentLocation = new Point2D.Double(this.xLoc, this.yLoc);
                    } else if (this.selectionActive && !event.isShiftDown() && !this.isMetaDown(event)) {
                        this.selectionWidth = (double)this.xLoc - this.selectionX;
                        this.selectionHeight = (double)this.yLoc - this.selectionY;
                    }
                }
                this.redrawPanel();
                break block45;
            }
            Rectangle r = new Rectangle(event.getX(), event.getY(), 1, 1);
            ((JComponent)event.getSource()).scrollRectToVisible(r);
        }
    }

    @Override
    public void mouseEntered(@Nonnull MouseEvent event) {
        this._targetPanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void addAnchor() {
        this.addAnchor(this.currentPoint);
    }

    @Nonnull
    public PositionablePoint addAnchor(@Nonnull Point2D p) {
        assert (p != null);
        String name = this.finder.uniqueName("A", ++this.numAnchors);
        PositionablePoint o = new PositionablePoint(name, PositionablePoint.PointType.ANCHOR, this);
        PositionablePointView pv = new PositionablePointView(o, p, this);
        this.addLayoutTrack(o, pv);
        this.setDirty();
        return o;
    }

    public void addEndBumper() {
        String name = this.finder.uniqueName("EB", ++this.numEndBumpers);
        PositionablePoint o = new PositionablePoint(name, PositionablePoint.PointType.END_BUMPER, this);
        PositionablePointView pv = new PositionablePointView(o, this.currentPoint, this);
        this.addLayoutTrack(o, pv);
        this.setDirty();
    }

    public void addEdgeConnector() {
        String name = this.finder.uniqueName("EC", ++this.numEdgeConnectors);
        PositionablePoint o = new PositionablePoint(name, PositionablePoint.PointType.EDGE_CONNECTOR, this);
        PositionablePointView pv = new PositionablePointView(o, this.currentPoint, this);
        this.addLayoutTrack(o, pv);
        this.setDirty();
    }

    public void addTrackSegment() {
        LayoutBlock b;
        String name = this.finder.uniqueName("T", ++this.numTrackSegments);
        this.newTrack = new TrackSegment(name, this.beginTrack, this.beginHitPointType, this.foundTrack, this.foundHitPointType, this.leToolBarPanel.mainlineTrack.isSelected(), this);
        TrackSegmentView tsv = new TrackSegmentView(this.newTrack, this);
        this.addLayoutTrack(this.newTrack, tsv);
        this.setDirty();
        this.setLink(this.beginTrack, this.beginHitPointType, this.newTrack, HitPointType.TRACK);
        this.setLink(this.foundTrack, this.foundHitPointType, this.newTrack, HitPointType.TRACK);
        String newName = this.leToolBarPanel.blockIDComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if ((b = this.provideLayoutBlock(newName)) != null) {
            this.newTrack.setLayoutBlock(b);
            this.getLEAuxTools().setBlockConnectivityChanged();
            String sensorName = this.leToolBarPanel.blockSensorComboBox.getSelectedItemDisplayName();
            if (sensorName == null) {
                sensorName = "";
            }
            if (!sensorName.isEmpty()) {
                if (!this.validateSensor(sensorName, b, this)) {
                    b.setOccupancySensorName("");
                } else {
                    this.leToolBarPanel.blockSensorComboBox.setSelectedItem(b.getOccupancySensor());
                }
            }
            this.newTrack.updateBlockInfo();
        }
    }

    public void addLevelXing() {
        LayoutBlock b;
        String name = this.finder.uniqueName("X", ++this.numLevelXings);
        LevelXing o = new LevelXing(name, this);
        LevelXingView ov = new LevelXingView(o, this.currentPoint, this);
        this.addLayoutTrack(o, ov);
        this.setDirty();
        String newName = this.leToolBarPanel.blockIDComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if ((b = this.provideLayoutBlock(newName)) != null) {
            o.setLayoutBlockAC(b);
            o.setLayoutBlockBD(b);
            String sensorName = this.leToolBarPanel.blockSensorComboBox.getSelectedItemDisplayName();
            if (sensorName == null) {
                sensorName = "";
            }
            if (!sensorName.isEmpty()) {
                if (!this.validateSensor(sensorName, b, this)) {
                    b.setOccupancySensorName("");
                } else {
                    this.leToolBarPanel.blockSensorComboBox.setSelectedItem(b.getOccupancySensor());
                }
            }
        }
    }

    public void addLayoutSlip(LayoutTurnout.TurnoutType type) {
        String turnoutName;
        LayoutBlock b;
        LayoutSlipView ov;
        LayoutSlip o;
        double rot = 0.0;
        String s = this.leToolBarPanel.rotationComboBox.getEditor().getItem().toString().trim();
        if (s.isEmpty()) {
            rot = 0.0;
        } else {
            try {
                rot = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("Error3")) + " " + e, Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
        }
        String name = this.finder.uniqueName("SL", ++this.numLayoutSlips);
        switch (type) {
            case DOUBLE_SLIP: {
                LayoutDoubleSlip lds = new LayoutDoubleSlip(name, this);
                o = lds;
                ov = new LayoutDoubleSlipView(lds, this.currentPoint, rot, this);
                break;
            }
            case SINGLE_SLIP: {
                LayoutSingleSlip lss = new LayoutSingleSlip(name, this);
                o = lss;
                ov = new LayoutSingleSlipView(lss, this.currentPoint, rot, this);
                break;
            }
            default: {
                log.error("can't create slip {} with type {}", (Object)name, (Object)type);
                return;
            }
        }
        this.addLayoutTrack(o, ov);
        this.setDirty();
        String newName = this.leToolBarPanel.blockIDComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if ((b = this.provideLayoutBlock(newName)) != null) {
            ov.setLayoutBlock(b);
            String sensorName = this.leToolBarPanel.blockSensorComboBox.getSelectedItemDisplayName();
            if (sensorName == null) {
                sensorName = "";
            }
            if (!sensorName.isEmpty()) {
                if (!this.validateSensor(sensorName, b, this)) {
                    b.setOccupancySensorName("");
                } else {
                    this.leToolBarPanel.blockSensorComboBox.setSelectedItem(b.getOccupancySensor());
                }
            }
        }
        if ((turnoutName = this.leToolBarPanel.turnoutNameComboBox.getSelectedItemDisplayName()) == null) {
            turnoutName = "";
        }
        if (this.validatePhysicalTurnout(turnoutName, this)) {
            o.setTurnout(turnoutName);
            if (o.getTurnout().getSystemName().equals(turnoutName)) {
                this.leToolBarPanel.turnoutNameComboBox.setSelectedItem(o.getTurnout());
            }
        } else {
            o.setTurnout("");
            this.leToolBarPanel.turnoutNameComboBox.setSelectedItem(null);
            this.leToolBarPanel.turnoutNameComboBox.setSelectedIndex(-1);
        }
        if ((turnoutName = this.leToolBarPanel.extraTurnoutNameComboBox.getSelectedItemDisplayName()) == null) {
            turnoutName = "";
        }
        if (this.validatePhysicalTurnout(turnoutName, this)) {
            o.setTurnoutB(turnoutName);
            if (o.getTurnoutB().getSystemName().equals(turnoutName)) {
                this.leToolBarPanel.extraTurnoutNameComboBox.setSelectedItem(o.getTurnoutB());
            }
        } else {
            o.setTurnoutB("");
            this.leToolBarPanel.extraTurnoutNameComboBox.setSelectedItem(null);
            this.leToolBarPanel.extraTurnoutNameComboBox.setSelectedIndex(-1);
        }
    }

    public void addLayoutTurnout(LayoutTurnout.TurnoutType type) {
        LayoutBlock b;
        LayoutTurnoutView ov;
        LayoutTurnout o;
        double rot = 0.0;
        String s = this.leToolBarPanel.rotationComboBox.getEditor().getItem().toString().trim();
        if (s.isEmpty()) {
            rot = 0.0;
        } else {
            try {
                rot = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("Error3")) + " " + e, Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
        }
        String name = this.finder.uniqueName("TO", ++this.numLayoutTurnouts);
        switch (type) {
            case RH_TURNOUT: {
                LayoutRHTurnout lrht = new LayoutRHTurnout(name, this);
                o = lrht;
                ov = new LayoutRHTurnoutView(lrht, this.currentPoint, rot, this.gContext.getXScale(), this.gContext.getYScale(), this);
                break;
            }
            case LH_TURNOUT: {
                LayoutLHTurnout llht = new LayoutLHTurnout(name, this);
                o = llht;
                ov = new LayoutLHTurnoutView(llht, this.currentPoint, rot, this.gContext.getXScale(), this.gContext.getYScale(), this);
                break;
            }
            case WYE_TURNOUT: {
                LayoutWye lw = new LayoutWye(name, this);
                o = lw;
                ov = new LayoutWyeView(lw, this.currentPoint, rot, this.gContext.getXScale(), this.gContext.getYScale(), this);
                break;
            }
            case DOUBLE_XOVER: {
                LayoutDoubleXOver ldx = new LayoutDoubleXOver(name, this);
                o = ldx;
                ov = new LayoutDoubleXOverView(ldx, this.currentPoint, rot, this.gContext.getXScale(), this.gContext.getYScale(), this);
                break;
            }
            case RH_XOVER: {
                LayoutRHXOver lrx = new LayoutRHXOver(name, this);
                o = lrx;
                ov = new LayoutRHXOverView(lrx, this.currentPoint, rot, this.gContext.getXScale(), this.gContext.getYScale(), this);
                break;
            }
            case LH_XOVER: {
                LayoutLHXOver llx = new LayoutLHXOver(name, this);
                o = llx;
                ov = new LayoutLHXOverView(llx, this.currentPoint, rot, this.gContext.getXScale(), this.gContext.getYScale(), this);
                break;
            }
            case DOUBLE_SLIP: {
                LayoutDoubleSlip lds = new LayoutDoubleSlip(name, this);
                o = lds;
                ov = new LayoutDoubleSlipView(lds, this.currentPoint, rot, this);
                log.error("Found SINGLE_SLIP in addLayoutTurnout for element {}", (Object)name);
                break;
            }
            case SINGLE_SLIP: {
                LayoutSingleSlip lss = new LayoutSingleSlip(name, this);
                o = lss;
                ov = new LayoutSingleSlipView(lss, this.currentPoint, rot, this);
                log.error("Found SINGLE_SLIP in addLayoutTurnout for element {}", (Object)name);
                break;
            }
            default: {
                log.error("can't create LayoutTrack {} with type {}", (Object)name, (Object)type);
                return;
            }
        }
        this.addLayoutTrack(o, ov);
        this.setDirty();
        String newName = this.leToolBarPanel.blockIDComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if ((b = this.provideLayoutBlock(newName)) != null) {
            ov.setLayoutBlock(b);
            String sensorName = this.leToolBarPanel.blockSensorComboBox.getSelectedItemDisplayName();
            if (sensorName == null) {
                sensorName = "";
            }
            if (!sensorName.isEmpty()) {
                if (!this.validateSensor(sensorName, b, this)) {
                    b.setOccupancySensorName("");
                } else {
                    this.leToolBarPanel.blockSensorComboBox.setSelectedItem(b.getOccupancySensor());
                }
            }
        }
        o.setContinuingSense(2);
        String turnoutName = this.leToolBarPanel.turnoutNameComboBox.getSelectedItemDisplayName();
        if (turnoutName == null) {
            turnoutName = "";
        }
        if (this.validatePhysicalTurnout(turnoutName, this)) {
            o.setTurnout(turnoutName);
            if (o.getTurnout().getSystemName().equals(turnoutName)) {
                this.leToolBarPanel.turnoutNameComboBox.setSelectedItem(o.getTurnout());
            }
        } else {
            o.setTurnout("");
            this.leToolBarPanel.turnoutNameComboBox.setSelectedItem(null);
            this.leToolBarPanel.turnoutNameComboBox.setSelectedIndex(-1);
        }
    }

    public boolean validatePhysicalTurnout(@Nonnull String inTurnoutName, @CheckForNull Component inOpenPane) {
        String uname;
        String sname;
        if (inTurnoutName.isEmpty()) {
            return false;
        }
        Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(inTurnoutName);
        if (t == null) {
            if (inOpenPane != null) {
                JOptionPane.showMessageDialog(inOpenPane, MessageFormat.format(Bundle.getMessage("Error8"), inTurnoutName), Bundle.getMessage("ErrorTitle"), 0);
            }
            return false;
        }
        log.debug("validatePhysicalTurnout('{}')", (Object)inTurnoutName);
        boolean result = true;
        for (LayoutTurnout lt : this.getLayoutTurnouts()) {
            t = lt.getTurnout();
            if (t != null) {
                sname = t.getSystemName();
                uname = t.getUserName();
                log.debug("{}: Turnout tested '{}' and '{}'.", new Object[]{lt.getName(), sname, uname});
                if (sname.equals(inTurnoutName) || uname != null && uname.equals(inTurnoutName)) {
                    result = false;
                    break;
                }
            }
            if (!lt.isTurnoutTypeXover() || (t = lt.getSecondTurnout()) == null) continue;
            sname = t.getSystemName();
            uname = t.getUserName();
            log.debug("{}: 2nd Turnout tested '{}' and '{}'.", new Object[]{lt.getName(), sname, uname});
            if (!sname.equals(inTurnoutName) && (uname == null || !uname.equals(inTurnoutName))) continue;
            result = false;
            break;
        }
        if (result) {
            for (LayoutSlip sl : this.getLayoutSlips()) {
                t = sl.getTurnout();
                if (t != null) {
                    sname = t.getSystemName();
                    uname = t.getUserName();
                    log.debug("{}: slip Turnout tested '{}' and '{}'.", new Object[]{sl.getName(), sname, uname});
                    if (sname.equals(inTurnoutName) || uname != null && uname.equals(inTurnoutName)) {
                        result = false;
                        break;
                    }
                }
                if ((t = sl.getTurnoutB()) == null) continue;
                sname = t.getSystemName();
                uname = t.getUserName();
                log.debug("{}: slip Turnout B tested '{}' and '{}'.", new Object[]{sl.getName(), sname, uname});
                if (!sname.equals(inTurnoutName) && (uname == null || !uname.equals(inTurnoutName))) continue;
                result = false;
                break;
            }
        }
        if (result) {
            block2: for (LayoutTurntable tt : this.getLayoutTurntables()) {
                for (LayoutTurntable.RayTrack ray : tt.getRayTrackList()) {
                    t = ray.getTurnout();
                    if (t == null) continue;
                    String sname2 = t.getSystemName();
                    String uname2 = t.getUserName();
                    log.debug("{}: Turntable turnout tested '{}' and '{}'.", new Object[]{ray.getTurnoutName(), sname2, uname2});
                    if (!sname2.equals(inTurnoutName) && (uname2 == null || !uname2.equals(inTurnoutName))) continue;
                    result = false;
                    continue block2;
                }
            }
        }
        if (!result && inOpenPane != null) {
            JOptionPane.showMessageDialog(inOpenPane, MessageFormat.format(Bundle.getMessage("Error4"), inTurnoutName), Bundle.getMessage("ErrorTitle"), 0);
        }
        return result;
    }

    public void setLink(@Nonnull LayoutTrack fromObject, HitPointType fromPointType, @Nonnull LayoutTrack toObject, HitPointType toPointType) {
        switch (fromPointType) {
            case POS_POINT: {
                if (toPointType == HitPointType.TRACK && fromObject instanceof PositionablePoint) {
                    ((PositionablePoint)fromObject).setTrackConnection((TrackSegment)toObject);
                    break;
                }
                log.error("Attempt to link a non-TRACK connection ('{}')to a Positionable Point ('{}')", (Object)toObject.getName(), (Object)fromObject.getName());
                break;
            }
            case TURNOUT_A: 
            case TURNOUT_B: 
            case TURNOUT_C: 
            case TURNOUT_D: 
            case LEVEL_XING_A: 
            case LEVEL_XING_B: 
            case LEVEL_XING_C: 
            case LEVEL_XING_D: 
            case SLIP_A: 
            case SLIP_B: 
            case SLIP_C: 
            case SLIP_D: {
                try {
                    fromObject.setConnection(fromPointType, toObject, toPointType);
                }
                catch (JmriException jmriException) {}
                break;
            }
            case TRACK: {
                log.error("Illegal request to set a Track Segment link");
                break;
            }
            default: {
                if (HitPointType.isTurntableRayHitType(fromPointType) && fromObject instanceof LayoutTurntable) {
                    if (toObject instanceof TrackSegment) {
                        ((LayoutTurntable)fromObject).setRayConnect((TrackSegment)toObject, fromPointType.turntableTrackIndex());
                        break;
                    }
                    log.warn("setLink found expected toObject type {} with fromPointType {} fromObject type {}", new Object[]{toObject.getClass(), fromPointType, fromObject.getClass(), new Exception("traceback")});
                    break;
                }
                log.warn("setLink found expected fromObject type {} with fromPointType {} toObject type {}", new Object[]{fromObject.getClass(), fromPointType, toObject.getClass(), new Exception("traceback")});
            }
        }
    }

    public LayoutBlock provideLayoutBlock(@Nonnull String inBlockName) {
        LayoutBlock result = null;
        LayoutBlock newBlk = null;
        if (inBlockName.isEmpty()) {
            if (this.autoAssignBlocks) {
                newBlk = InstanceManager.getDefault(LayoutBlockManager.class).createNewLayoutBlock();
                if (newBlk == null) {
                    log.error("provideLayoutBlock: Failure to auto-assign for empty LayoutBlock name");
                }
            } else {
                log.debug("provideLayoutBlock: no name given and not assigning auto block names");
            }
        } else {
            result = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(inBlockName);
            if (result == null) {
                Block checkBlock = InstanceManager.getDefault(BlockManager.class).getBlock(inBlockName);
                if (checkBlock == null) {
                    log.error("provideLayoutBlock: The block name '{}' does not return a block.", (Object)inBlockName);
                } else {
                    String checkUserName = checkBlock.getUserName();
                    if (checkUserName != null && checkUserName.equals(inBlockName)) {
                        newBlk = InstanceManager.getDefault(LayoutBlockManager.class).createNewLayoutBlock(null, inBlockName);
                        if (newBlk == null) {
                            log.error("provideLayoutBlock: Failure to create new LayoutBlock '{}'.", (Object)inBlockName);
                        }
                    } else {
                        String blkUserName = JOptionPane.showInputDialog(this.getTargetFrame(), Bundle.getMessage("BlkUserNameMsg"), Bundle.getMessage("BlkUserNameTitle"), -1);
                        if (blkUserName != null && !blkUserName.isEmpty()) {
                            Block checkDuplicate = (Block)InstanceManager.getDefault(BlockManager.class).getByUserName(blkUserName);
                            if (checkDuplicate != null) {
                                JOptionPane.showMessageDialog(this.getTargetFrame(), Bundle.getMessage("BlkUserNameInUse", blkUserName), Bundle.getMessage("ErrorTitle"), 0);
                            } else {
                                checkBlock.setUserName(blkUserName);
                                newBlk = InstanceManager.getDefault(LayoutBlockManager.class).createNewLayoutBlock(null, blkUserName);
                                if (newBlk == null) {
                                    log.error("provideLayoutBlock: Failure to create new LayoutBlock '{}' with a new user name.", (Object)blkUserName);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (newBlk != null) {
            newBlk.initializeLayoutBlock();
            newBlk.initializeLayoutBlockRouting();
            newBlk.setBlockTrackColor(this.defaultTrackColor);
            newBlk.setBlockOccupiedColor(this.defaultOccupiedTrackColor);
            newBlk.setBlockExtraColor(this.defaultAlternativeTrackColor);
            result = newBlk;
        }
        if (result != null) {
            result.addLayoutEditor(this);
            result.incrementUse();
            this.setDirty();
        }
        return result;
    }

    public boolean validateSensor(@Nonnull String sensorName, @Nonnull LayoutBlock blk, @Nonnull Component openFrame) {
        boolean result = false;
        if (!sensorName.isEmpty()) {
            Sensor s;
            result = blk.getOccupancySensorName().equals(sensorName) ? true : (s = blk.validateSensor(sensorName, openFrame)) != null;
        }
        return result;
    }

    public LayoutBlock getLayoutBlock(@Nonnull String blockID) {
        LayoutBlock blk = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(blockID);
        if (blk == null) {
            log.error("LayoutBlock '{}' not found when panel loaded", (Object)blockID);
            return null;
        }
        blk.addLayoutEditor(this);
        return blk;
    }

    private boolean remove(@Nonnull Object s) {
        SignalMast mast;
        SignalHead head;
        Sensor sensor;
        boolean found = false;
        if (this.backgroundImage.contains(s)) {
            this.backgroundImage.remove(s);
            found = true;
        }
        if (this.memoryLabelList.contains(s)) {
            this.memoryLabelList.remove(s);
            found = true;
        }
        if (this.blockContentsLabelList.contains(s)) {
            this.blockContentsLabelList.remove(s);
            found = true;
        }
        if (this.multiSensors.contains(s)) {
            this.multiSensors.remove(s);
            found = true;
        }
        if (this.clocks.contains(s)) {
            this.clocks.remove(s);
            found = true;
        }
        if (this.labelImage.contains(s)) {
            this.labelImage.remove(s);
            found = true;
        }
        if ((this.sensorImage.contains(s) || this.sensorList.contains(s)) && (sensor = ((SensorIcon)s).getSensor()) != null) {
            if (this.removeAttachedBean(sensor)) {
                this.sensorImage.remove(s);
                this.sensorList.remove(s);
                found = true;
            } else {
                return false;
            }
        }
        if ((this.signalHeadImage.contains(s) || this.signalList.contains(s)) && (head = ((SignalHeadIcon)s).getSignalHead()) != null) {
            if (this.removeAttachedBean(head)) {
                this.signalHeadImage.remove(s);
                this.signalList.remove(s);
                found = true;
            } else {
                return false;
            }
        }
        if (this.signalMastList.contains(s) && (mast = ((SignalMastIcon)s).getSignalMast()) != null) {
            if (this.removeAttachedBean(mast)) {
                this.signalMastList.remove(s);
                found = true;
            } else {
                return false;
            }
        }
        super.removeFromContents((Positionable)s);
        if (found) {
            this.setDirty();
            this.redrawPanel();
        }
        return found;
    }

    @Override
    public boolean removeFromContents(@Nonnull Positionable l) {
        return this.remove(l);
    }

    private String findBeanUsage(@Nonnull NamedBean bean) {
        LayoutSlip ls;
        LevelXing lx;
        LayoutTurnout lt;
        PositionablePoint pe;
        TrackSegment t2;
        TrackSegment t1;
        PositionablePoint pw;
        boolean found = false;
        StringBuilder sb = new StringBuilder();
        String msgKey = "DeleteReference";
        String beanKey = "None";
        String beanValue = bean.getDisplayName();
        if (bean instanceof SignalMast) {
            SignalMastLogic sml;
            beanKey = "BeanNameSignalMast";
            if (InstanceManager.getDefault(SignalMastLogicManager.class).isSignalMastUsed((SignalMast)bean) && (sml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic((SignalMast)bean)) != null && sml.useLayoutEditor(sml.getDestinationList().get(0))) {
                msgKey = "DeleteSmlReference";
            }
        } else if (bean instanceof Sensor) {
            beanKey = "BeanNameSensor";
        } else if (bean instanceof SignalHead) {
            beanKey = "BeanNameSignalHead";
        }
        if (!beanKey.equals("None")) {
            sb.append(Bundle.getMessage(msgKey, Bundle.getMessage(beanKey), beanValue));
        }
        if ((pw = this.finder.findPositionablePointByWestBoundBean(bean)) != null) {
            t1 = pw.getConnect1();
            t2 = pw.getConnect2();
            if (t1 != null) {
                if (t2 != null) {
                    sb.append(Bundle.getMessage("DeleteAtPoint1", t1.getBlockName()));
                    sb.append(Bundle.getMessage("DeleteAtPoint2", t2.getBlockName()));
                } else {
                    sb.append(Bundle.getMessage("DeleteAtPoint1", t1.getBlockName()));
                }
            }
            found = true;
        }
        if ((pe = this.finder.findPositionablePointByEastBoundBean(bean)) != null) {
            t1 = pe.getConnect1();
            t2 = pe.getConnect2();
            if (t1 != null) {
                if (t2 != null) {
                    sb.append(Bundle.getMessage("DeleteAtPoint1", t1.getBlockName()));
                    sb.append(Bundle.getMessage("DeleteAtPoint2", t2.getBlockName()));
                } else {
                    sb.append(Bundle.getMessage("DeleteAtPoint1", t1.getBlockName()));
                }
            }
            found = true;
        }
        if ((lt = this.finder.findLayoutTurnoutByBean(bean)) != null) {
            sb.append(Bundle.getMessage("DeleteAtOther", Bundle.getMessage("BeanNameTurnout"), lt.getTurnoutName()));
            found = true;
        }
        if ((lx = this.finder.findLevelXingByBean(bean)) != null) {
            sb.append(Bundle.getMessage("DeleteAtOther", Bundle.getMessage("LevelCrossing"), lx.getId()));
            found = true;
        }
        if ((ls = this.finder.findLayoutSlipByBean(bean)) != null) {
            sb.append(Bundle.getMessage("DeleteAtOther", Bundle.getMessage("Slip"), ls.getTurnoutName()));
            found = true;
        }
        if (!found) {
            return null;
        }
        return sb.toString();
    }

    private boolean removeAttachedBean(@Nonnull NamedBean bean) {
        String usage = this.findBeanUsage(bean);
        if (usage != null) {
            usage = String.format("<html>%s</html>", usage);
            int selectedValue = JOptionPane.showOptionDialog(this, usage, Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonCancel")}, Bundle.getMessage("ButtonYes"));
            if (selectedValue == 1) {
                return true;
            }
            if (selectedValue == 2) {
                return false;
            }
            if (bean instanceof Sensor) {
                return this.getLETools().removeSensorAssignment((Sensor)bean);
            }
            this.removeBeanRefs(bean);
        }
        return true;
    }

    private void removeBeanRefs(@Nonnull NamedBean bean) {
        LayoutSlip ls;
        LevelXing lx;
        LayoutTurnout lt;
        PositionablePoint pe;
        PositionablePoint pw = this.finder.findPositionablePointByWestBoundBean(bean);
        if (pw != null) {
            pw.removeBeanReference(bean);
        }
        if ((pe = this.finder.findPositionablePointByEastBoundBean(bean)) != null) {
            pe.removeBeanReference(bean);
        }
        if ((lt = this.finder.findLayoutTurnoutByBean(bean)) != null) {
            lt.removeBeanReference(bean);
        }
        if ((lx = this.finder.findLevelXingByBean(bean)) != null) {
            lx.removeBeanReference(bean);
        }
        if ((ls = this.finder.findLayoutSlipByBean(bean)) != null) {
            ls.removeBeanReference(bean);
        }
    }

    public boolean removePositionablePoint(@Nonnull PositionablePoint o) {
        if (o.getConnect1() != null || o.getConnect2() != null) {
            if (!this.noWarnPositionablePoint) {
                int selectedValue = JOptionPane.showOptionDialog(this, Bundle.getMessage("Question2"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
                if (selectedValue == 1) {
                    return false;
                }
                if (selectedValue == 2) {
                    this.noWarnPositionablePoint = true;
                }
            }
            if (this.selectedObject == o) {
                this.selectedObject = null;
            }
            if (this.prevSelectedObject == o) {
                this.prevSelectedObject = null;
            }
            TrackSegment t1 = o.getConnect1();
            TrackSegment t2 = o.getConnect2();
            if (t1 != null) {
                this.removeTrackSegment(t1);
            }
            if (t2 != null) {
                this.removeTrackSegment(t2);
            }
        }
        return this.removeLayoutTrackAndRedraw(o);
    }

    public boolean removeLayoutTurnout(@Nonnull LayoutTurnout o) {
        LayoutBlock b;
        TrackSegment t;
        if (!this.noWarnLayoutTurnout) {
            int selectedValue = JOptionPane.showOptionDialog(this, Bundle.getMessage("Question1r"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue == 1) {
                return false;
            }
            if (selectedValue == 2) {
                this.noWarnLayoutTurnout = true;
            }
        }
        if (this.selectedObject == o) {
            this.selectedObject = null;
        }
        if (this.prevSelectedObject == o) {
            this.prevSelectedObject = null;
        }
        if ((t = (TrackSegment)o.getConnectA()) != null) {
            this.substituteAnchor(this.getLayoutTurnoutView(o).getCoordsA(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectB()) != null) {
            this.substituteAnchor(this.getLayoutTurnoutView(o).getCoordsB(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectC()) != null) {
            this.substituteAnchor(this.getLayoutTurnoutView(o).getCoordsC(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectD()) != null) {
            this.substituteAnchor(this.getLayoutTurnoutView(o).getCoordsD(), o, t);
        }
        if ((b = o.getLayoutBlock()) != null) {
            b.decrementUse();
        }
        if (o.isTurnoutTypeXover() || o.isTurnoutTypeSlip()) {
            LayoutBlock b4;
            LayoutBlock b3;
            LayoutBlock b2 = o.getLayoutBlockB();
            if (b2 != null && b2 != b) {
                b2.decrementUse();
            }
            if ((b3 = o.getLayoutBlockC()) != null && b3 != b && b3 != b2) {
                b3.decrementUse();
            }
            if ((b4 = o.getLayoutBlockD()) != null && b4 != b && b4 != b2 && b4 != b3) {
                b4.decrementUse();
            }
        }
        return this.removeLayoutTrackAndRedraw(o);
    }

    private void substituteAnchor(@Nonnull Point2D loc, @Nonnull LayoutTrack o, @Nonnull TrackSegment t) {
        PositionablePoint p = this.addAnchor(loc);
        if (t.getConnect1() == o) {
            t.setNewConnect1(p, HitPointType.POS_POINT);
        }
        if (t.getConnect2() == o) {
            t.setNewConnect2(p, HitPointType.POS_POINT);
        }
        p.setTrackConnection(t);
    }

    public boolean removeLevelXing(@Nonnull LevelXing o) {
        LayoutBlock lbx;
        LayoutBlock lb;
        if (!this.noWarnLevelXing) {
            int selectedValue = JOptionPane.showOptionDialog(this, Bundle.getMessage("Question3r"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue == 1) {
                return false;
            }
            if (selectedValue == 2) {
                this.noWarnLevelXing = true;
            }
        }
        if (this.selectedObject == o) {
            this.selectedObject = null;
        }
        if (this.prevSelectedObject == o) {
            this.prevSelectedObject = null;
        }
        LevelXingView ov = this.getLevelXingView(o);
        TrackSegment t = (TrackSegment)o.getConnectA();
        if (t != null) {
            this.substituteAnchor(ov.getCoordsA(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectB()) != null) {
            this.substituteAnchor(ov.getCoordsB(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectC()) != null) {
            this.substituteAnchor(ov.getCoordsC(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectD()) != null) {
            this.substituteAnchor(ov.getCoordsD(), o, t);
        }
        if ((lb = o.getLayoutBlockAC()) != null) {
            lb.decrementUse();
        }
        if ((lbx = o.getLayoutBlockBD()) != null && lb != null && lbx != lb) {
            lb.decrementUse();
        }
        return this.removeLayoutTrackAndRedraw(o);
    }

    public boolean removeLayoutSlip(@Nonnull LayoutTurnout o) {
        LayoutBlock lb;
        TrackSegment t;
        if (!(o instanceof LayoutSlip)) {
            return false;
        }
        if (!this.noWarnSlip) {
            int selectedValue = JOptionPane.showOptionDialog(this, Bundle.getMessage("Question5r"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue == 1) {
                return false;
            }
            if (selectedValue == 2) {
                this.noWarnSlip = true;
            }
        }
        LayoutTurnoutView ov = this.getLayoutTurnoutView(o);
        if (this.selectedObject == o) {
            this.selectedObject = null;
        }
        if (this.prevSelectedObject == o) {
            this.prevSelectedObject = null;
        }
        if ((t = (TrackSegment)o.getConnectA()) != null) {
            this.substituteAnchor(ov.getCoordsA(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectB()) != null) {
            this.substituteAnchor(ov.getCoordsB(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectC()) != null) {
            this.substituteAnchor(ov.getCoordsC(), o, t);
        }
        if ((t = (TrackSegment)o.getConnectD()) != null) {
            this.substituteAnchor(ov.getCoordsD(), o, t);
        }
        if ((lb = o.getLayoutBlock()) != null) {
            lb.decrementUse();
        }
        return this.removeLayoutTrackAndRedraw(o);
    }

    public boolean removeTurntable(@Nonnull LayoutTurntable o) {
        if (!this.noWarnTurntable) {
            int selectedValue = JOptionPane.showOptionDialog(this, Bundle.getMessage("Question4r"), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYesPlus")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue == 1) {
                return false;
            }
            if (selectedValue == 2) {
                this.noWarnTurntable = true;
            }
        }
        if (this.selectedObject == o) {
            this.selectedObject = null;
        }
        if (this.prevSelectedObject == o) {
            this.prevSelectedObject = null;
        }
        LayoutTurntableView ov = this.getLayoutTurntableView(o);
        int j = 0;
        while (j < o.getNumberRays()) {
            TrackSegment t = ov.getRayConnectOrdered(j);
            if (t != null) {
                this.substituteAnchor(ov.getRayCoordsIndexed(j), o, t);
            }
            ++j;
        }
        return this.removeLayoutTrackAndRedraw(o);
    }

    public void removeTrackSegment(@Nonnull TrackSegment o) {
        PositionablePoint p;
        LayoutBlock block1 = null;
        LayoutBlock block2 = null;
        LayoutBlock block = o.getLayoutBlock();
        HitPointType type = o.getType1();
        if (type == HitPointType.POS_POINT) {
            p = (PositionablePoint)o.getConnect1();
            if (p != null) {
                p.removeTrackConnection(o);
                if (p.getConnect1() != null) {
                    block1 = p.getConnect1().getLayoutBlock();
                } else if (p.getConnect2() != null) {
                    block1 = p.getConnect2().getLayoutBlock();
                }
            }
        } else {
            block1 = this.getAffectedBlock(o.getConnect1(), type);
            this.disconnect(o.getConnect1(), type);
        }
        if ((type = o.getType2()) == HitPointType.POS_POINT) {
            p = (PositionablePoint)o.getConnect2();
            if (p != null) {
                p.removeTrackConnection(o);
                if (p.getConnect1() != null) {
                    block2 = p.getConnect1().getLayoutBlock();
                } else if (p.getConnect2() != null) {
                    block2 = p.getConnect2().getLayoutBlock();
                }
            }
        } else {
            block2 = this.getAffectedBlock(o.getConnect2(), type);
            this.disconnect(o.getConnect2(), type);
        }
        this.removeLayoutTrack(o);
        if (block != null) {
            block.decrementUse();
            this.getLEAuxTools().setBlockConnectivityChanged();
            block.updatePaths();
        }
        if (block1 != null && block1 != block) {
            block1.updatePaths();
        }
        if (block2 != null && block2 != block && block2 != block1) {
            block2.updatePaths();
        }
        this.setDirty();
        this.redrawPanel();
    }

    private void disconnect(@Nonnull LayoutTrack o, HitPointType type) {
        switch (type) {
            case TURNOUT_A: 
            case TURNOUT_B: 
            case TURNOUT_C: 
            case TURNOUT_D: 
            case LEVEL_XING_A: 
            case LEVEL_XING_B: 
            case LEVEL_XING_C: 
            case LEVEL_XING_D: 
            case SLIP_A: 
            case SLIP_B: 
            case SLIP_C: 
            case SLIP_D: {
                try {
                    o.setConnection(type, null, HitPointType.NONE);
                }
                catch (JmriException jmriException) {}
                break;
            }
            default: {
                if (!HitPointType.isTurntableRayHitType(type)) break;
                ((LayoutTurntable)o).setRayConnect(null, type.turntableTrackIndex());
            }
        }
    }

    public LayoutBlock getAffectedBlock(@Nonnull LayoutTrack track, HitPointType type) {
        LayoutBlock result = null;
        switch (type) {
            case TURNOUT_A: 
            case SLIP_A: {
                if (!(track instanceof LayoutTurnout)) break;
                LayoutTurnout lt = (LayoutTurnout)track;
                result = lt.getLayoutBlock();
                break;
            }
            case TURNOUT_B: 
            case SLIP_B: {
                if (!(track instanceof LayoutTurnout)) break;
                LayoutTurnout lt = (LayoutTurnout)track;
                result = lt.getLayoutBlockB();
                break;
            }
            case TURNOUT_C: 
            case SLIP_C: {
                if (!(track instanceof LayoutTurnout)) break;
                LayoutTurnout lt = (LayoutTurnout)track;
                result = lt.getLayoutBlockC();
                break;
            }
            case TURNOUT_D: 
            case SLIP_D: {
                if (!(track instanceof LayoutTurnout)) break;
                LayoutTurnout lt = (LayoutTurnout)track;
                result = lt.getLayoutBlockD();
                break;
            }
            case LEVEL_XING_A: 
            case LEVEL_XING_C: {
                if (!(track instanceof LevelXing)) break;
                LevelXing lx = (LevelXing)track;
                result = lx.getLayoutBlockAC();
                break;
            }
            case LEVEL_XING_B: 
            case LEVEL_XING_D: {
                if (!(track instanceof LevelXing)) break;
                LevelXing lx = (LevelXing)track;
                result = lx.getLayoutBlockBD();
                break;
            }
            case TRACK: {
                if (!(track instanceof TrackSegment)) break;
                TrackSegment ts = (TrackSegment)track;
                result = ts.getLayoutBlock();
                break;
            }
            default: {
                log.warn("Unhandled track type: {}", (Object)type);
            }
        }
        return result;
    }

    void addSensor() {
        String newName = this.leToolBarPanel.sensorComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (newName.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error10"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        SensorIcon l = new SensorIcon(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), (Editor)this);
        l.setIcon("SensorStateActive", this.leToolBarPanel.sensorIconEditor.getIcon(0));
        l.setIcon("SensorStateInactive", this.leToolBarPanel.sensorIconEditor.getIcon(1));
        l.setIcon("BeanStateInconsistent", this.leToolBarPanel.sensorIconEditor.getIcon(2));
        l.setIcon("BeanStateUnknown", this.leToolBarPanel.sensorIconEditor.getIcon(3));
        l.setSensor(newName);
        l.setDisplayLevel(10);
        this.leToolBarPanel.sensorComboBox.setSelectedItem(l.getSensor());
        this.setNextLocation(l);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    public void putSensor(@Nonnull SensorIcon l) {
        l.updateSize();
        l.setDisplayLevel(10);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    void addSignalHead() {
        String newName = this.leToolBarPanel.signalHeadComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        SignalHead mHead = null;
        if (!newName.isEmpty()) {
            mHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(newName);
            this.leToolBarPanel.signalHeadComboBox.setSelectedItem(mHead);
        }
        if (mHead == null) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("Error9"), newName), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        SignalHeadIcon l = new SignalHeadIcon(this);
        l.setSignalHead(newName);
        l.setIcon("SignalHeadStateRed", this.leToolBarPanel.signalIconEditor.getIcon(0));
        l.setIcon("SignalHeadStateFlashingRed", this.leToolBarPanel.signalIconEditor.getIcon(1));
        l.setIcon("SignalHeadStateYellow", this.leToolBarPanel.signalIconEditor.getIcon(2));
        l.setIcon("SignalHeadStateFlashingYellow", this.leToolBarPanel.signalIconEditor.getIcon(3));
        l.setIcon("SignalHeadStateGreen", this.leToolBarPanel.signalIconEditor.getIcon(4));
        l.setIcon("SignalHeadStateFlashingGreen", this.leToolBarPanel.signalIconEditor.getIcon(5));
        l.setIcon("SignalHeadStateDark", this.leToolBarPanel.signalIconEditor.getIcon(6));
        l.setIcon("SignalHeadStateHeld", this.leToolBarPanel.signalIconEditor.getIcon(7));
        l.setIcon("SignalHeadStateLunar", this.leToolBarPanel.signalIconEditor.getIcon(8));
        l.setIcon("SignalHeadStateFlashingLunar", this.leToolBarPanel.signalIconEditor.getIcon(9));
        this.unionToPanelBounds(l.getBounds());
        this.setNextLocation(l);
        this.setDirty();
        this.putSignal(l);
    }

    public void putSignal(@Nonnull SignalHeadIcon l) {
        l.updateSize();
        l.setDisplayLevel(9);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    @CheckForNull
    SignalHead getSignalHead(@Nonnull String name) {
        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
        if (sh == null) {
            sh = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(name);
        }
        if (sh == null) {
            log.warn("did not find a SignalHead named {}", (Object)name);
        }
        return sh;
    }

    public boolean containsSignalHead(@CheckForNull SignalHead head) {
        if (head != null) {
            for (SignalHeadIcon h : this.signalList) {
                if (h.getSignalHead() != head) continue;
                return true;
            }
        }
        return false;
    }

    public void removeSignalHead(@CheckForNull SignalHead head) {
        if (head != null) {
            for (SignalHeadIcon h : this.signalList) {
                if (h.getSignalHead() != head) continue;
                this.signalList.remove(h);
                h.remove();
                h.dispose();
                this.setDirty();
                this.redrawPanel();
                break;
            }
        }
    }

    void addSignalMast() {
        String newName = this.leToolBarPanel.signalMastComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        SignalMast mMast = null;
        if (!newName.isEmpty()) {
            mMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(newName);
            this.leToolBarPanel.signalMastComboBox.setSelectedItem(mMast);
        }
        if (mMast == null) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("Error9"), newName), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        SignalMastIcon l = new SignalMastIcon(this);
        l.setSignalMast(newName);
        this.unionToPanelBounds(l.getBounds());
        this.setNextLocation(l);
        this.setDirty();
        this.putSignalMast(l);
    }

    public void putSignalMast(@Nonnull SignalMastIcon l) {
        l.updateSize();
        l.setDisplayLevel(9);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    SignalMast getSignalMast(@Nonnull String name) {
        SignalMast sh = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(name);
        if (sh == null) {
            sh = InstanceManager.getDefault(SignalMastManager.class).getByUserName(name);
        }
        if (sh == null) {
            log.warn("did not find a SignalMast named {}", (Object)name);
        }
        return sh;
    }

    public boolean containsSignalMast(@Nonnull SignalMast mast) {
        for (SignalMastIcon h : this.signalMastList) {
            if (h.getSignalMast() != mast) continue;
            return true;
        }
        return false;
    }

    void addLabel() {
        String labelText = this.leToolBarPanel.textLabelTextField.getText();
        String string = labelText = labelText != null ? labelText.trim() : "";
        if (labelText.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error11"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        PositionableLabel l = super.addLabel(labelText);
        this.unionToPanelBounds(l.getBounds());
        this.setDirty();
        l.setForeground(this.defaultTextColor);
    }

    @Override
    public void putItem(@Nonnull Positionable l) throws Positionable.DuplicateIdException {
        super.putItem(l);
        if (l instanceof SensorIcon) {
            this.sensorImage.add((SensorIcon)l);
            this.sensorList.add((SensorIcon)l);
        } else if (l instanceof LocoIcon) {
            this.markerImage.add((LocoIcon)l);
        } else if (l instanceof SignalHeadIcon) {
            this.signalHeadImage.add((SignalHeadIcon)l);
            this.signalList.add((SignalHeadIcon)l);
        } else if (l instanceof SignalMastIcon) {
            this.signalMastList.add((SignalMastIcon)l);
        } else if (l instanceof MemoryIcon) {
            this.memoryLabelList.add((MemoryIcon)l);
        } else if (l instanceof BlockContentsIcon) {
            this.blockContentsLabelList.add((BlockContentsIcon)l);
        } else if (l instanceof AnalogClock2Display) {
            this.clocks.add((AnalogClock2Display)l);
        } else if (l instanceof MultiSensorIcon) {
            this.multiSensors.add((MultiSensorIcon)l);
        }
        if (l instanceof PositionableLabel) {
            if (((PositionableLabel)l).isBackground()) {
                this.backgroundImage.add((PositionableLabel)l);
            } else {
                this.labelImage.add((PositionableLabel)l);
            }
        }
        this.unionToPanelBounds(l.getBounds(new Rectangle()));
        this.setDirty();
    }

    void addMemory() {
        String uname;
        String memoryName = this.leToolBarPanel.textMemoryComboBox.getSelectedItemDisplayName();
        if (memoryName == null) {
            memoryName = "";
        }
        if (memoryName.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error11a"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        MemoryIcon l = new MemoryIcon(" ", this);
        l.setMemory(memoryName);
        Memory xMemory = l.getMemory();
        if (xMemory != null && !(uname = xMemory.getDisplayName()).equals(memoryName)) {
            this.leToolBarPanel.textMemoryComboBox.setSelectedItem(xMemory);
        }
        this.setNextLocation(l);
        l.setSize(l.getPreferredSize().width, l.getPreferredSize().height);
        l.setDisplayLevel(4);
        l.setForeground(this.defaultTextColor);
        this.unionToPanelBounds(l.getBounds());
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    void addBlockContents() {
        String uname;
        String newName = this.leToolBarPanel.blockContentsComboBox.getSelectedItemDisplayName();
        if (newName == null) {
            newName = "";
        }
        if (newName.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error11b"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        BlockContentsIcon l = new BlockContentsIcon(" ", this);
        l.setBlock(newName);
        Block xMemory = l.getBlock();
        if (xMemory != null && !(uname = xMemory.getDisplayName()).equals(newName)) {
            this.leToolBarPanel.blockContentsComboBox.setSelectedItem(xMemory);
        }
        this.setNextLocation(l);
        l.setSize(l.getPreferredSize().width, l.getPreferredSize().height);
        l.setDisplayLevel(4);
        l.setForeground(this.defaultTextColor);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    public void addReporter(@Nonnull Reporter reporter, int xx, int yy) {
        ReporterIcon l = new ReporterIcon(this);
        l.setReporter(reporter);
        l.setLocation(xx, yy);
        l.setSize(l.getPreferredSize().width, l.getPreferredSize().height);
        l.setDisplayLevel(4);
        this.unionToPanelBounds(l.getBounds());
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    void addIcon() {
        PositionableLabel l = new PositionableLabel(this.leToolBarPanel.iconEditor.getIcon(0), (Editor)this);
        this.setNextLocation(l);
        l.setDisplayLevel(3);
        this.unionToPanelBounds(l.getBounds());
        l.updateSize();
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    @Override
    public LocoIcon addLocoIcon(@Nonnull String name) {
        LocoIcon l = new LocoIcon(this);
        Point2D pt = this.windowCenter();
        if (this.selectionActive) {
            pt = MathUtil.midPoint(this.getSelectionRect());
        }
        l.setLocation((int)pt.getX(), (int)pt.getY());
        this.putLocoIcon(l, name);
        l.setPositionable(true);
        this.unionToPanelBounds(l.getBounds());
        return l;
    }

    @Override
    public void putLocoIcon(@Nonnull LocoIcon l, @Nonnull String name) {
        super.putLocoIcon(l, name);
        this.markerImage.add(l);
        this.unionToPanelBounds(l.getBounds());
    }

    public void addBackground() {
        if (this.inputFileChooser == null) {
            this.inputFileChooser = new JFileChooser(String.format("%s%sresources%sicons", System.getProperty("user.dir"), File.separator, File.separator));
            this.inputFileChooser.setFileFilter(new FileNameExtensionFilter("Graphics Files", "gif", "jpg", "png"));
        }
        this.inputFileChooser.rescanCurrentDirectory();
        int retVal = this.inputFileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        String name = this.inputFileChooser.getSelectedFile().getPath();
        name = FileUtil.getPortableFilename(name);
        PositionableLabel o = super.setUpBackground(name);
        this.backgroundImage.add(o);
        this.unionToPanelBounds(o.getBounds());
        this.setDirty();
    }

    @Nonnull
    private LayoutShape addLayoutShape(@Nonnull Point2D p) {
        String name = this.finder.uniqueName("S", ++this.numShapes);
        LayoutShape o = new LayoutShape(name, p, this);
        this.layoutShapes.add(o);
        this.unionToPanelBounds(o.getBounds());
        this.setDirty();
        return o;
    }

    public boolean removeLayoutShape(@Nonnull LayoutShape s) {
        boolean result = false;
        if (this.layoutShapes.contains(s)) {
            this.layoutShapes.remove(s);
            this.setDirty();
            result = true;
            this.redrawPanel();
        }
        return result;
    }

    void startMultiSensor() {
        this.multiLocX = this.xLoc;
        this.multiLocY = this.yLoc;
        if (this.leToolBarPanel.multiSensorFrame == null) {
            this.leToolBarPanel.multiSensorFrame = new MultiSensorIconFrame(this);
            this.leToolBarPanel.multiSensorFrame.initComponents();
            this.leToolBarPanel.multiSensorFrame.pack();
        }
        this.leToolBarPanel.multiSensorFrame.setVisible(true);
    }

    public void addMultiSensor(@Nonnull MultiSensorIcon l) {
        l.setLocation(this.multiLocX, this.multiLocY);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        this.leToolBarPanel.multiSensorFrame.dispose();
        this.leToolBarPanel.multiSensorFrame = null;
    }

    @Override
    public void setNextLocation(@Nonnull Positionable obj) {
        obj.setLocation(this.xLoc, this.yLoc);
    }

    @Nonnull
    public ConnectivityUtil getConnectivityUtil() {
        if (this.conTools == null) {
            this.conTools = new ConnectivityUtil(this);
        }
        return this.conTools;
    }

    @Nonnull
    public LayoutEditorTools getLETools() {
        if (this.tools == null) {
            this.tools = new LayoutEditorTools(this);
        }
        return this.tools;
    }

    @Override
    @Nonnull
    public LayoutEditorAuxTools getLEAuxTools() {
        if (this.auxTools == null) {
            this.auxTools = new LayoutEditorAuxTools(this);
        }
        return this.auxTools;
    }

    @Nonnull
    public LayoutEditorChecks getLEChecks() {
        if (this.layoutEditorChecks == null) {
            this.layoutEditorChecks = new LayoutEditorChecks(this);
        }
        return this.layoutEditorChecks;
    }

    @Override
    public boolean deletePanel() {
        if (!super.deletePanel()) {
            return false;
        }
        this.clearLayoutTracks();
        return true;
    }

    @Override
    public void setAllEditable(boolean editable) {
        int restoreScroll = this._scrollState;
        super.setAllEditable(editable);
        if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT)) {
            if (editable) {
                this.createfloatingEditToolBoxFrame();
                this.createFloatingHelpPanel();
            } else {
                this.deletefloatingEditToolBoxFrame();
            }
        } else {
            this.editToolBarContainerPanel.setVisible(editable);
        }
        this.setShowHidden(editable);
        if (editable) {
            this.setScroll(1);
            this._scrollState = restoreScroll;
        } else {
            this.setScroll(this._scrollState);
        }
        if (this.helpBarPanel != null) {
            if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT)) {
                if (this.floatEditHelpPanel != null) {
                    this.floatEditHelpPanel.setVisible(this.isEditable() && this.getShowHelpBar());
                }
            } else {
                this.helpBarPanel.setVisible(editable && this.getShowHelpBar());
            }
        }
        this.awaitingIconChange = false;
        this.editModeCheckBoxMenuItem.setSelected(editable);
        this.redrawPanel();
    }

    @Override
    public void setAllPositionable(boolean state) {
        super.setAllPositionable(state);
        this.markerImage.forEach(p -> p.setPositionable(true));
    }

    public void setTurnoutAnimation(boolean state) {
        if (this.animationCheckBoxMenuItem.isSelected() != state) {
            this.animationCheckBoxMenuItem.setSelected(state);
        }
        if (this.animatingLayout != state) {
            this.animatingLayout = state;
            this.redrawPanel();
        }
    }

    public boolean isAnimating() {
        return this.animatingLayout;
    }

    public boolean getScroll() {
        return this._scrollState != 0;
    }

    public String getDefaultTrackColor() {
        return ColorUtil.colorToColorName(this.defaultTrackColor);
    }

    @Nonnull
    public Color getDefaultTrackColorColor() {
        return this.defaultTrackColor;
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="coloToColorName only returns null if null passed to it")
    public String getDefaultOccupiedTrackColor() {
        return ColorUtil.colorToColorName(this.defaultOccupiedTrackColor);
    }

    @Nonnull
    public Color getDefaultOccupiedTrackColorColor() {
        return this.defaultOccupiedTrackColor;
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="coloToColorName only returns null if null passed to it")
    public String getDefaultAlternativeTrackColor() {
        return ColorUtil.colorToColorName(this.defaultAlternativeTrackColor);
    }

    @Nonnull
    public Color getDefaultAlternativeTrackColorColor() {
        return this.defaultAlternativeTrackColor;
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="coloToColorName only returns null if null passed to it")
    public String getDefaultTextColor() {
        return ColorUtil.colorToColorName(this.defaultTextColor);
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="coloToColorName only returns null if null passed to it")
    public String getTurnoutCircleColor() {
        return ColorUtil.colorToColorName(this.turnoutCircleColor);
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="coloToColorName only returns null if null passed to it")
    public String getTurnoutCircleThrownColor() {
        return ColorUtil.colorToColorName(this.turnoutCircleThrownColor);
    }

    public boolean isTurnoutFillControlCircles() {
        return this.turnoutFillControlCircles;
    }

    public int getTurnoutCircleSize() {
        return this.turnoutCircleSize;
    }

    public boolean isTurnoutDrawUnselectedLeg() {
        return this.turnoutDrawUnselectedLeg;
    }

    public String getLayoutName() {
        return this.layoutName;
    }

    public boolean getShowHelpBar() {
        return this.showHelpBar;
    }

    public boolean getDrawGrid() {
        return this.drawGrid;
    }

    public boolean getSnapOnAdd() {
        return this.snapToGridOnAdd;
    }

    public boolean getSnapOnMove() {
        return this.snapToGridOnMove;
    }

    public boolean getAntialiasingOn() {
        return this.antialiasingOn;
    }

    public boolean isDrawLayoutTracksLabel() {
        return this.drawLayoutTracksLabel;
    }

    public boolean getHighlightSelectedBlock() {
        return this.highlightSelectedBlockFlag;
    }

    public boolean getTurnoutCircles() {
        return this.turnoutCirclesWithoutEditMode;
    }

    public boolean getTooltipsNotEdit() {
        return this.tooltipsWithoutEditMode;
    }

    public boolean getTooltipsInEdit() {
        return this.tooltipsInEditMode;
    }

    public boolean getAutoBlockAssignment() {
        return this.autoAssignBlocks;
    }

    public void setLayoutDimensions(int windowWidth, int windowHeight, int windowX, int windowY, int panelWidth, int panelHeight) {
        this.setLayoutDimensions(windowWidth, windowHeight, windowX, windowY, panelWidth, panelHeight, false);
    }

    public void setLayoutDimensions(int windowWidth, int windowHeight, int windowX, int windowY, int panelWidth, int panelHeight, boolean merge) {
        this.gContext.setUpperLeftX(windowX);
        this.gContext.setUpperLeftY(windowY);
        this.setLocation(this.gContext.getUpperLeftX(), this.gContext.getUpperLeftY());
        this.gContext.setWindowWidth(windowWidth);
        this.gContext.setWindowHeight(windowHeight);
        this.setSize(windowWidth, windowHeight);
        Rectangle2D.Double panelBounds = new Rectangle2D.Double(0.0, 0.0, panelWidth, panelHeight);
        if (merge) {
            panelBounds.add(this.calculateMinimumLayoutBounds());
        }
        this.setPanelBounds(panelBounds);
    }

    @Nonnull
    public Rectangle2D getPanelBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.gContext.getLayoutWidth(), this.gContext.getLayoutHeight());
    }

    public void setPanelBounds(@Nonnull Rectangle2D newBounds) {
        newBounds = newBounds.createIntersection(MathUtil.zeroToInfinityRectangle2D);
        if (!this.getPanelBounds().equals(newBounds)) {
            this.gContext.setLayoutWidth((int)newBounds.getWidth());
            this.gContext.setLayoutHeight((int)newBounds.getHeight());
            this.resetTargetSize();
        }
        log.debug("setPanelBounds(({})", (Object)newBounds);
    }

    private void resetTargetSize() {
        int newTargetWidth = (int)((double)this.gContext.getLayoutWidth() * this.getZoom());
        int newTargetHeight = (int)((double)this.gContext.getLayoutHeight() * this.getZoom());
        Dimension targetPanelSize = this.getTargetPanelSize();
        int oldTargetWidth = (int)targetPanelSize.getWidth();
        int oldTargetHeight = (int)targetPanelSize.getHeight();
        if (newTargetWidth != oldTargetWidth || newTargetHeight != oldTargetHeight) {
            this.setTargetPanelSize(newTargetWidth, newTargetHeight);
            this.adjustScrollBars();
        }
    }

    @Nonnull
    public Rectangle2D unionToPanelBounds(@Nonnull Rectangle2D bounds) {
        Rectangle2D result = this.getPanelBounds();
        Rectangle2D b = MathUtil.inset(bounds, (double)(this.gContext.getGridSize() * this.gContext.getGridSize2nd()) / -2.0);
        b = b.createIntersection(MathUtil.zeroToInfinityRectangle2D);
        result.add(b);
        this.setPanelBounds(result);
        return result;
    }

    public void setDefaultTrackColor(@Nonnull Color color) {
        this.defaultTrackColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public void setDefaultOccupiedTrackColor(@Nonnull Color color) {
        this.defaultOccupiedTrackColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public void setDefaultAlternativeTrackColor(@Nonnull Color color) {
        this.defaultAlternativeTrackColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public void setTurnoutCircleColor(@CheckForNull Color color) {
        if (color == null) {
            this.turnoutCircleColor = this.getDefaultTrackColorColor();
        } else {
            this.turnoutCircleColor = color;
            JmriColorChooser.addRecentColor(color);
        }
    }

    public void setTurnoutCircleThrownColor(@CheckForNull Color color) {
        if (color == null) {
            this.turnoutCircleThrownColor = this.getDefaultTrackColorColor();
        } else {
            this.turnoutCircleThrownColor = color;
            JmriColorChooser.addRecentColor(color);
        }
    }

    @InvokeOnGuiThread
    public void setTurnoutFillControlCircles(boolean state) {
        if (this.turnoutFillControlCircles != state) {
            this.turnoutFillControlCircles = state;
            this.turnoutFillControlCirclesCheckBoxMenuItem.setSelected(this.turnoutFillControlCircles);
        }
    }

    public void setTurnoutCircleSize(int size) {
        this.turnoutCircleSize = size;
        this.circleRadius = 3.0 * (double)size;
        this.circleDiameter = 2.0 * this.circleRadius;
        this.setOptionMenuTurnoutCircleSize();
    }

    @InvokeOnGuiThread
    public void setTurnoutDrawUnselectedLeg(boolean state) {
        if (this.turnoutDrawUnselectedLeg != state) {
            this.turnoutDrawUnselectedLeg = state;
            this.turnoutDrawUnselectedLegCheckBoxMenuItem.setSelected(this.turnoutDrawUnselectedLeg);
        }
    }

    public void setDefaultTextColor(@Nonnull Color color) {
        this.defaultTextColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public void setDefaultBackgroundColor(@Nonnull Color color) {
        this.defaultBackgroundColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public void setLayoutName(@Nonnull String name) {
        this.layoutName = name;
    }

    @InvokeOnGuiThread
    public void setShowHelpBar(boolean state) {
        if (this.showHelpBar != state) {
            this.showHelpBar = state;
            if (this.showHelpCheckBoxMenuItem != null) {
                this.showHelpCheckBoxMenuItem.setSelected(this.showHelpBar);
            }
            if (this.toolBarSide.equals((Object)ToolBarSide.eFLOAT)) {
                if (this.floatEditHelpPanel != null) {
                    this.floatEditHelpPanel.setVisible(this.isEditable() && this.showHelpBar);
                }
            } else if (this.helpBarPanel != null) {
                this.helpBarPanel.setVisible(this.isEditable() && this.showHelpBar);
            }
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSimplePreferenceState(String.valueOf(this.getWindowFrameRef()) + ".showHelpBar", this.showHelpBar));
        }
    }

    @InvokeOnGuiThread
    public void setDrawGrid(boolean state) {
        if (this.drawGrid != state) {
            this.drawGrid = state;
            this.showGridCheckBoxMenuItem.setSelected(this.drawGrid);
        }
    }

    @InvokeOnGuiThread
    public void setSnapOnAdd(boolean state) {
        if (this.snapToGridOnAdd != state) {
            this.snapToGridOnAdd = state;
            this.snapToGridOnAddCheckBoxMenuItem.setSelected(this.snapToGridOnAdd);
        }
    }

    @InvokeOnGuiThread
    public void setSnapOnMove(boolean state) {
        if (this.snapToGridOnMove != state) {
            this.snapToGridOnMove = state;
            this.snapToGridOnMoveCheckBoxMenuItem.setSelected(this.snapToGridOnMove);
        }
    }

    @InvokeOnGuiThread
    public void setAntialiasingOn(boolean state) {
        if (this.antialiasingOn != state) {
            this.antialiasingOn = state;
            if (this.antialiasingOnCheckBoxMenuItem != null) {
                this.antialiasingOnCheckBoxMenuItem.setSelected(this.antialiasingOn);
            }
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSimplePreferenceState(String.valueOf(this.getWindowFrameRef()) + ".antialiasingOn", this.antialiasingOn));
        }
    }

    public void setDrawLayoutTracksLabel(boolean state) {
        if (this.drawLayoutTracksLabel != state) {
            this.drawLayoutTracksLabel = state;
            if (this.drawLayoutTracksLabelCheckBoxMenuItem != null) {
                this.drawLayoutTracksLabelCheckBoxMenuItem.setSelected(this.drawLayoutTracksLabel);
            }
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSimplePreferenceState(String.valueOf(this.getWindowFrameRef()) + ".drawLayoutTracksLabel", this.drawLayoutTracksLabel));
        }
    }

    public void setHighlightSelectedBlock(boolean state) {
        if (this.highlightSelectedBlockFlag != state) {
            this.highlightSelectedBlockFlag = state;
            if (this.leToolBarPanel.highlightBlockCheckBox != null) {
                this.leToolBarPanel.highlightBlockCheckBox.setSelected(this.highlightSelectedBlockFlag);
            }
            InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(prefsMgr -> prefsMgr.setSimplePreferenceState(String.valueOf(this.getWindowFrameRef()) + ".highlightSelectedBlock", this.highlightSelectedBlockFlag));
            ThreadingUtil.newThread(() -> {
                if (this.highlightSelectedBlockFlag) {
                    if (!this.highlightBlockInComboBox(this.leToolBarPanel.blockIDComboBox)) {
                        this.highlightBlockInComboBox(this.leToolBarPanel.blockContentsComboBox);
                    }
                } else {
                    Block block = (Block)this.leToolBarPanel.blockIDComboBox.getSelectedItem();
                    this.highlightBlock(null);
                    this.leToolBarPanel.blockIDComboBox.setSelectedItem(block);
                }
            }).start();
        }
    }

    public boolean highlightBlockInComboBox(@Nonnull NamedBeanComboBox<Block> inComboBox) {
        return this.highlightBlock((Block)inComboBox.getSelectedItem());
    }

    public boolean highlightBlock(@CheckForNull Block inBlock) {
        boolean result = false;
        if (this.leToolBarPanel.blockIDComboBox.getSelectedItem() != inBlock) {
            this.leToolBarPanel.blockIDComboBox.setSelectedItem(inBlock);
        }
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        SortedSet<Block> l = this.leToolBarPanel.blockIDComboBox.getManager().getNamedBeanSet();
        for (Block b : l) {
            LayoutBlock lb = lbm.getLayoutBlock(b);
            if (lb == null) continue;
            boolean enable = inBlock != null && b.equals(inBlock);
            lb.setUseExtraColor(enable);
            result |= enable;
        }
        return result;
    }

    public boolean highlightLayoutBlock(@Nonnull LayoutBlock inLayoutBlock) {
        return this.highlightBlock(inLayoutBlock.getBlock());
    }

    public void setTurnoutCircles(boolean state) {
        if (this.turnoutCirclesWithoutEditMode != state) {
            this.turnoutCirclesWithoutEditMode = state;
            if (this.turnoutCirclesOnCheckBoxMenuItem != null) {
                this.turnoutCirclesOnCheckBoxMenuItem.setSelected(this.turnoutCirclesWithoutEditMode);
            }
        }
    }

    public void setAutoBlockAssignment(boolean boo) {
        if (this.autoAssignBlocks != boo) {
            this.autoAssignBlocks = boo;
            if (this.autoAssignBlocksCheckBoxMenuItem != null) {
                this.autoAssignBlocksCheckBoxMenuItem.setSelected(this.autoAssignBlocks);
            }
        }
    }

    public void setTooltipsNotEdit(boolean state) {
        if (this.tooltipsWithoutEditMode != state) {
            this.tooltipsWithoutEditMode = state;
            this.setTooltipSubMenu();
        }
    }

    public void setTooltipsInEdit(boolean state) {
        if (this.tooltipsInEditMode != state) {
            this.tooltipsInEditMode = state;
            this.setTooltipSubMenu();
        }
    }

    private void setTooltipSubMenu() {
        if (this.tooltipNoneMenuItem != null) {
            this.tooltipNoneMenuItem.setSelected(!this.tooltipsInEditMode && !this.tooltipsWithoutEditMode);
            this.tooltipAlwaysMenuItem.setSelected(this.tooltipsInEditMode && this.tooltipsWithoutEditMode);
            this.tooltipInEditMenuItem.setSelected(this.tooltipsInEditMode && !this.tooltipsWithoutEditMode);
            this.tooltipNotInEditMenuItem.setSelected(!this.tooltipsInEditMode && this.tooltipsWithoutEditMode);
        }
    }

    public void setTurnoutBX(double bx) {
        this.turnoutBX = bx;
        this.setDirty();
    }

    public double getTurnoutBX() {
        return this.turnoutBX;
    }

    public void setTurnoutCX(double cx) {
        this.turnoutCX = cx;
        this.setDirty();
    }

    public double getTurnoutCX() {
        return this.turnoutCX;
    }

    public void setTurnoutWid(double wid) {
        this.turnoutWid = wid;
        this.setDirty();
    }

    public double getTurnoutWid() {
        return this.turnoutWid;
    }

    public void setXOverLong(double lg) {
        this.xOverLong = lg;
        this.setDirty();
    }

    public double getXOverLong() {
        return this.xOverLong;
    }

    public void setXOverHWid(double hwid) {
        this.xOverHWid = hwid;
        this.setDirty();
    }

    public double getXOverHWid() {
        return this.xOverHWid;
    }

    public void setXOverShort(double sh) {
        this.xOverShort = sh;
        this.setDirty();
    }

    public double getXOverShort() {
        return this.xOverShort;
    }

    private void resetTurnoutSize() {
        this.turnoutBX = 20.0;
        this.turnoutCX = 20.0;
        this.turnoutWid = 10.0;
        this.xOverLong = 30.0;
        this.xOverHWid = 10.0;
        this.xOverShort = 10.0;
        this.setDirty();
    }

    public void setDirectTurnoutControl(boolean boo) {
        this.useDirectTurnoutControl = boo;
        this.useDirectTurnoutControlCheckBoxMenuItem.setSelected(this.useDirectTurnoutControl);
    }

    public boolean getDirectTurnoutControl() {
        return this.useDirectTurnoutControl;
    }

    public void setConnections() {
        this.getLayoutTracks().forEach(lt -> lt.setObjects(this));
        this.getLEAuxTools().initializeBlockConnectivity();
        log.debug("Initializing Block Connectivity for {}", (Object)this.getLayoutName());
        this.resetDirty();
    }

    @Nonnull
    public Rectangle2D layoutEditorControlRectAt(@Nonnull Point2D inPoint) {
        return new Rectangle2D.Double(inPoint.getX() - 3.0, inPoint.getY() - 3.0, 6.0, 6.0);
    }

    @Nonnull
    public Rectangle2D layoutEditorControlCircleRectAt(@Nonnull Point2D inPoint) {
        return new Rectangle2D.Double(inPoint.getX() - this.circleRadius, inPoint.getY() - this.circleRadius, this.circleDiameter, this.circleDiameter);
    }

    @Override
    public void paintTargetPanel(@Nonnull Graphics g) {
    }

    @Nonnull
    public Rectangle2D getSelectionRect() {
        double selX = Math.min(this.selectionX, this.selectionX + this.selectionWidth);
        double selY = Math.min(this.selectionY, this.selectionY + this.selectionHeight);
        return new Rectangle2D.Double(selX, selY, Math.abs(this.selectionWidth), Math.abs(this.selectionHeight));
    }

    public void setSelectionRect(@Nonnull Rectangle2D selectionRect) {
        this.selectionX = selectionRect.getX();
        this.selectionY = selectionRect.getY();
        this.selectionWidth = selectionRect.getWidth();
        this.selectionHeight = selectionRect.getHeight();
        this._selectRect = MathUtil.rectangle2DToRectangle(selectionRect);
        selectionRect = MathUtil.scale(selectionRect, this.getZoom());
        JComponent targetPanel = this.getTargetPanel();
        Rectangle targetRect = targetPanel.getVisibleRect();
        Rectangle2D selRect2D = MathUtil.inset(selectionRect, (selectionRect.getWidth() - targetRect.getWidth()) / 2.0, (selectionRect.getHeight() - targetRect.getHeight()) / 2.0);
        Rectangle selRect = MathUtil.rectangle2DToRectangle(selRect2D = selRect2D.createIntersection(MathUtil.zeroToInfinityRectangle2D));
        if (!targetRect.contains(selRect)) {
            targetPanel.scrollRectToVisible(selRect);
        }
        this.clearSelectionGroups();
        this.selectionActive = true;
        this.createSelectionGroups();
    }

    public void setSelectRect(Rectangle rectangle) {
        this._selectRect = rectangle;
    }

    @Override
    @Nonnull
    public Stream<LayoutTrack> getLayoutTracksOfClass(Class<? extends LayoutTrack> layoutTrackClass) {
        return this.getLayoutTracks().stream().filter(layoutTrackClass::isInstance).map(layoutTrackClass::cast);
    }

    @Override
    @Nonnull
    public Stream<LayoutTrackView> getLayoutTrackViewsOfClass(Class<? extends LayoutTrackView> layoutTrackViewClass) {
        return this.getLayoutTrackViews().stream().filter(layoutTrackViewClass::isInstance).map(layoutTrackViewClass::cast);
    }

    @Override
    @Nonnull
    public List<PositionablePointView> getPositionablePointViews() {
        return this.getLayoutTrackViewsOfClass(PositionablePointView.class).map(PositionablePointView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<PositionablePoint> getPositionablePoints() {
        return this.getLayoutTracksOfClass(PositionablePoint.class).map(PositionablePoint.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public List<LayoutSlipView> getLayoutSlipViews() {
        return this.getLayoutTrackViewsOfClass(LayoutSlipView.class).map(LayoutSlipView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<LayoutSlip> getLayoutSlips() {
        return this.getLayoutTracksOfClass(LayoutSlip.class).map(LayoutSlip.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<TrackSegmentView> getTrackSegmentViews() {
        return this.getLayoutTrackViewsOfClass(TrackSegmentView.class).map(TrackSegmentView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<TrackSegment> getTrackSegments() {
        return this.getLayoutTracksOfClass(TrackSegment.class).map(TrackSegment.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public List<LayoutTurnoutView> getLayoutTurnoutViews() {
        return this.getLayoutTrackViews().stream().filter(o -> !(o instanceof LayoutSlipView) && o instanceof LayoutTurnoutView).map(LayoutTurnoutView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<LayoutTurnout> getLayoutTurnouts() {
        return this.getLayoutTracks().stream().filter(o -> !(o instanceof LayoutSlip) && o instanceof LayoutTurnout).map(LayoutTurnout.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<LayoutTurntable> getLayoutTurntables() {
        return this.getLayoutTracksOfClass(LayoutTurntable.class).map(LayoutTurntable.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public List<LayoutTurntableView> getLayoutTurntableViews() {
        return this.getLayoutTrackViewsOfClass(LayoutTurntableView.class).map(LayoutTurntableView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<LevelXing> getLevelXings() {
        return this.getLayoutTracksOfClass(LevelXing.class).map(LevelXing.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<LevelXingView> getLevelXingViews() {
        return this.getLayoutTrackViewsOfClass(LevelXingView.class).map(LevelXingView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public final List<LayoutTrack> getLayoutTracks() {
        return Collections.unmodifiableList(this.layoutTrackList);
    }

    @Nonnull
    public List<LayoutTurnoutView> getLayoutTurnoutAndSlipViews() {
        return this.getLayoutTrackViewsOfClass(LayoutTurnoutView.class).map(LayoutTurnoutView.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public List<LayoutTurnout> getLayoutTurnoutsAndSlips() {
        return this.getLayoutTracksOfClass(LayoutTurnout.class).map(LayoutTurnout.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nonnull
    public final List<LayoutTrackView> getLayoutTrackViews() {
        return Collections.unmodifiableList(this.layoutTrackViewList);
    }

    @Override
    public final LayoutTrackView getLayoutTrackView(LayoutTrack trk) {
        LayoutTrackView lv = this.trkToView.get(trk);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)trk, trk.getClass());
            throw new IllegalArgumentException("No View found: " + trk.getClass());
        }
        return lv;
    }

    @Override
    public final LevelXingView getLevelXingView(LevelXing xing) {
        LayoutTrackView lv = this.trkToView.get(xing);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)xing, xing.getClass());
            throw new IllegalArgumentException("No View found: " + xing.getClass());
        }
        if (lv instanceof LevelXingView) {
            return (LevelXingView)lv;
        }
        log.error("wrong type {} {} found {}", new Object[]{xing, xing.getClass(), lv});
        throw new IllegalArgumentException("Wrong type: " + xing.getClass());
    }

    @Override
    public final LayoutTurnoutView getLayoutTurnoutView(LayoutTurnout to) {
        LayoutTrackView lv = this.trkToView.get(to);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)to, to.getClass());
            throw new IllegalArgumentException("No View found: " + to);
        }
        if (lv instanceof LayoutTurnoutView) {
            return (LayoutTurnoutView)lv;
        }
        log.error("wrong type {} {} found {}", new Object[]{to, to.getClass(), lv});
        throw new IllegalArgumentException("Wrong type: " + to.getClass());
    }

    @Override
    public final LayoutTurntableView getLayoutTurntableView(LayoutTurntable to) {
        LayoutTrackView lv = this.trkToView.get(to);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)to, to.getClass());
            throw new IllegalArgumentException("No matching View found: " + to);
        }
        if (lv instanceof LayoutTurntableView) {
            return (LayoutTurntableView)lv;
        }
        log.error("wrong type {} {} found {}", new Object[]{to, to.getClass(), lv});
        throw new IllegalArgumentException("Wrong type: " + to.getClass());
    }

    public final LayoutSlipView getLayoutSlipView(LayoutSlip to) {
        LayoutTrackView lv = this.trkToView.get(to);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)to, to.getClass());
            throw new IllegalArgumentException("No matching View found: " + to);
        }
        if (lv instanceof LayoutSlipView) {
            return (LayoutSlipView)lv;
        }
        log.error("wrong type {} {} found {}", new Object[]{to, to.getClass(), lv});
        throw new IllegalArgumentException("Wrong type: " + to.getClass());
    }

    @Override
    public final TrackSegmentView getTrackSegmentView(TrackSegment to) {
        LayoutTrackView lv = this.trkToView.get(to);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)to, to.getClass());
            throw new IllegalArgumentException("No matching View found: " + to);
        }
        if (lv instanceof TrackSegmentView) {
            return (TrackSegmentView)lv;
        }
        log.error("wrong type {} {} found {}", new Object[]{to, to.getClass(), lv});
        throw new IllegalArgumentException("Wrong type: " + to.getClass());
    }

    @Override
    public final PositionablePointView getPositionablePointView(PositionablePoint to) {
        LayoutTrackView lv = this.trkToView.get(to);
        if (lv == null) {
            log.warn("No View found for {} class {}", (Object)to, to.getClass());
            throw new IllegalArgumentException("No matching View found: " + to);
        }
        if (lv instanceof PositionablePointView) {
            return (PositionablePointView)lv;
        }
        log.error("wrong type {} {} found {}", new Object[]{to, to.getClass(), lv});
        throw new IllegalArgumentException("Wrong type: " + to.getClass());
    }

    @Override
    public final void addLayoutTrack(@Nonnull LayoutTrack trk, @Nonnull LayoutTrackView v) {
        log.trace("addLayoutTrack {}", (Object)trk);
        if (this.layoutTrackList.contains(trk)) {
            log.warn("LayoutTrack {} already being maintained", (Object)trk.getName());
        }
        this.layoutTrackList.add(trk);
        this.layoutTrackViewList.add(v);
        this.trkToView.put(trk, v);
        this.viewToTrk.put(v, trk);
        this.unionToPanelBounds(v.getBounds());
    }

    public final boolean removeLayoutTrackAndRedraw(@Nonnull LayoutTrack trk) {
        log.trace("removeLayoutTrackAndRedraw {}", (Object)trk);
        if (this.layoutTrackList.contains(trk)) {
            this.removeLayoutTrack(trk);
            this.setDirty();
            this.redrawPanel();
            log.trace("removeLayoutTrackAndRedraw present {}", (Object)trk);
            return true;
        }
        log.trace("removeLayoutTrackAndRedraw absent {}", (Object)trk);
        return false;
    }

    @Override
    public final void removeLayoutTrack(@Nonnull LayoutTrack trk) {
        log.trace("removeLayoutTrack {}", (Object)trk);
        this.layoutTrackList.remove(trk);
        LayoutTrackView v = this.trkToView.get(trk);
        this.layoutTrackViewList.remove(v);
        this.trkToView.remove(trk);
        this.viewToTrk.remove(v);
    }

    private void clearLayoutTracks() {
        this.layoutTrackList.clear();
        this.layoutTrackViewList.clear();
        this.trkToView.clear();
        this.viewToTrk.clear();
    }

    @Override
    @Nonnull
    public List<LayoutShape> getLayoutShapes() {
        return this.layoutShapes;
    }

    public void sortLayoutShapesByLevel() {
        this.layoutShapes.sort((lhs, rhs) -> Integer.signum(lhs.getLevel() - rhs.getLevel()));
    }

    @Override
    public int computeDirection(LayoutTrack trk1, HitPointType h1, LayoutTrack trk2, HitPointType h2) {
        return Path.computeDirection(this.getCoords(trk1, h1), this.getCoords(trk2, h2));
    }

    @Override
    public int computeDirectionToCenter(@Nonnull LayoutTrack trk1, @Nonnull HitPointType h1, @Nonnull PositionablePoint p) {
        return Path.computeDirection(this.getCoords(trk1, h1), this.getPositionablePointView(p).getCoordsCenter());
    }

    @Override
    public int computeDirectionFromCenter(@Nonnull PositionablePoint p, @Nonnull LayoutTrack trk1, @Nonnull HitPointType h1) {
        return Path.computeDirection(this.getPositionablePointView(p).getCoordsCenter(), this.getCoords(trk1, h1));
    }

    @Override
    public boolean showAlignPopup(@Nonnull Positionable l) {
        return false;
    }

    @Override
    public void showToolTip(@Nonnull Positionable selection, @Nonnull MouseEvent event) {
        ToolTip tip = selection.getToolTip();
        String txt = tip.getText();
        if (txt != null && !txt.isEmpty()) {
            tip.setLocation(selection.getX() + selection.getWidth() / 2, selection.getY() + selection.getHeight());
            this.setToolTip(tip);
        }
    }

    @Override
    public void addToPopUpMenu(@Nonnull NamedBean nb, @Nonnull JMenuItem item, int menu) {
        block15: {
            block14: {
                if (nb == null || item == null) {
                    return;
                }
                List<PositionableLabel> theList = null;
                if (nb instanceof Sensor) {
                    theList = this.sensorList;
                } else if (nb instanceof SignalHead) {
                    theList = this.signalList;
                } else if (nb instanceof SignalMast) {
                    theList = this.signalMastList;
                } else if (nb instanceof Block) {
                    theList = this.blockContentsLabelList;
                } else if (nb instanceof Memory) {
                    theList = this.memoryLabelList;
                }
                if (theList == null) break block14;
                for (PositionableIcon positionableIcon : theList) {
                    PositionableLabel si = positionableIcon;
                    if (si.getNamedBean() != nb || si.getPopupUtility() == null) continue;
                    if (menu != 0) {
                        si.getPopupUtility().addEditPopUpMenu(item);
                    }
                    if (menu == 1) continue;
                    si.getPopupUtility().addViewPopUpMenu(item);
                }
                break block15;
            }
            if (!(nb instanceof Turnout)) break block15;
            for (LayoutTurnoutView layoutTurnoutView : this.getLayoutTurnoutAndSlipViews()) {
                if (!layoutTurnoutView.getTurnout().equals(nb)) continue;
                if (menu != 0) {
                    layoutTurnoutView.addEditPopUpMenu(item);
                }
                if (menu == 1) continue;
                layoutTurnoutView.addViewPopUpMenu(item);
            }
        }
    }

    @Override
    @Nonnull
    public String toString() {
        return String.format("LayoutEditor: %s", this.getLayoutName());
    }

    @Override
    public void vetoableChange(@Nonnull PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName())) {
            LayoutTurnout lt;
            StringBuilder message = new StringBuilder();
            message.append(Bundle.getMessage("VetoInUseLayoutEditorHeader", this.toString()));
            message.append("<ul>");
            boolean found = false;
            if (nb instanceof SignalHead) {
                LayoutSlip ls;
                LevelXing levelXing;
                PositionablePoint p;
                if (this.containsSignalHead((SignalHead)nb)) {
                    found = true;
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSignalHeadIconFound"));
                    message.append("</li>");
                }
                if ((lt = this.finder.findLayoutTurnoutByBean(nb)) != null) {
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSignalHeadAssignedToTurnout", lt.getTurnoutName()));
                    message.append("</li>");
                }
                if ((p = this.finder.findPositionablePointByBean(nb)) != null) {
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSignalHeadAssignedToPoint"));
                    message.append("</li>");
                }
                if ((levelXing = this.finder.findLevelXingByBean(nb)) != null) {
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSignalHeadAssignedToLevelXing"));
                    message.append("</li>");
                }
                if ((ls = this.finder.findLayoutSlipByBean(nb)) != null) {
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSignalHeadAssignedToLayoutSlip", ls.getTurnoutName()));
                    message.append("</li>");
                }
            } else if (nb instanceof Turnout) {
                lt = this.finder.findLayoutTurnoutByBean(nb);
                if (lt != null) {
                    found = true;
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoTurnoutIconFound"));
                    message.append("</li>");
                }
                for (LayoutTurnout t : this.getLayoutTurnouts()) {
                    if (t.getLinkedTurnoutName() != null) {
                        String uname = nb.getUserName();
                        if (nb.getSystemName().equals(t.getLinkedTurnoutName()) || uname != null && uname.equals(t.getLinkedTurnoutName())) {
                            found = true;
                            message.append("<li>");
                            message.append(Bundle.getMessage("VetoLinkedTurnout", t.getTurnoutName()));
                            message.append("</li>");
                        }
                    }
                    if (!nb.equals(t.getSecondTurnout())) continue;
                    found = true;
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSecondTurnout", t.getTurnoutName()));
                    message.append("</li>");
                }
                LayoutSlip ls = this.finder.findLayoutSlipByBean(nb);
                if (ls != null) {
                    found = true;
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoSlipIconFound", ls.getDisplayName()));
                    message.append("</li>");
                }
                block1: for (LayoutTurntable layoutTurntable : this.getLayoutTurntables()) {
                    if (!layoutTurntable.isTurnoutControlled()) continue;
                    int i = 0;
                    while (i < layoutTurntable.getNumberRays()) {
                        if (nb.equals(layoutTurntable.getRayTurnout(i))) {
                            found = true;
                            message.append("<li>");
                            message.append(Bundle.getMessage("VetoRayTurntableControl", layoutTurntable.getId()));
                            message.append("</li>");
                            continue block1;
                        }
                        ++i;
                    }
                }
            }
            if (nb instanceof SignalMast) {
                String foundelsewhere;
                if (this.containsSignalMast((SignalMast)nb)) {
                    message.append("<li>");
                    message.append("As an Icon");
                    message.append("</li>");
                    found = true;
                }
                if ((foundelsewhere = this.findBeanUsage(nb)) != null) {
                    message.append(foundelsewhere);
                    found = true;
                }
            }
            if (nb instanceof Sensor) {
                Object foundelsewhere;
                int count = 0;
                for (SensorIcon si : this.sensorList) {
                    if (!nb.equals(si.getNamedBean())) continue;
                    ++count;
                    found = true;
                }
                if (count > 0) {
                    message.append("<li>");
                    message.append(String.format("As an Icon %s times", count));
                    message.append("</li>");
                }
                if ((foundelsewhere = this.findBeanUsage(nb)) != null) {
                    message.append((String)foundelsewhere);
                    found = true;
                }
            }
            if (nb instanceof Memory) {
                for (MemoryIcon si : this.memoryLabelList) {
                    if (!nb.equals(si.getMemory())) continue;
                    found = true;
                    message.append("<li>");
                    message.append(Bundle.getMessage("VetoMemoryIconFound"));
                    message.append("</li>");
                }
            }
            if (found) {
                message.append("</ul>");
                message.append(Bundle.getMessage("VetoReferencesWillBeRemoved"));
                throw new PropertyVetoException(message.toString(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            PositionableLabel i;
            Iterator<PositionableLabel> icon;
            if (nb instanceof SignalHead) {
                this.removeSignalHead((SignalHead)nb);
                this.removeBeanRefs(nb);
            }
            if (nb instanceof Turnout) {
                LayoutTurnout lt = this.finder.findLayoutTurnoutByBean(nb);
                if (lt != null) {
                    lt.setTurnout("");
                }
                for (LayoutTurnout t : this.getLayoutTurnouts()) {
                    if (t.getLinkedTurnoutName() != null && (t.getLinkedTurnoutName().equals(nb.getSystemName()) || nb.getUserName() != null && t.getLinkedTurnoutName().equals(nb.getUserName()))) {
                        t.setLinkedTurnoutName("");
                    }
                    if (!nb.equals(t.getSecondTurnout())) continue;
                    t.setSecondTurnout("");
                }
                for (LayoutSlip sl : this.getLayoutSlips()) {
                    if (nb.equals(sl.getTurnout())) {
                        sl.setTurnout("");
                    }
                    if (!nb.equals(sl.getTurnoutB())) continue;
                    sl.setTurnoutB("");
                }
                for (LayoutTurntable lx : this.getLayoutTurntables()) {
                    if (!lx.isTurnoutControlled()) continue;
                    int i2 = 0;
                    while (i2 < lx.getNumberRays()) {
                        if (nb.equals(lx.getRayTurnout(i2))) {
                            lx.setRayTurnout(i2, null, 1);
                        }
                        ++i2;
                    }
                }
            }
            if (nb instanceof SignalMast) {
                this.removeBeanRefs(nb);
                if (this.containsSignalMast((SignalMast)nb)) {
                    icon = this.signalMastList.iterator();
                    while (icon.hasNext()) {
                        i = (SignalMastIcon)icon.next();
                        if (!((SignalMastIcon)i).getSignalMast().equals(nb)) continue;
                        icon.remove();
                        super.removeFromContents(i);
                    }
                    this.setDirty();
                    this.redrawPanel();
                }
            }
            if (nb instanceof Sensor) {
                this.removeBeanRefs(nb);
                icon = this.sensorImage.iterator();
                while (icon.hasNext()) {
                    i = (SensorIcon)icon.next();
                    if (!nb.equals(((SensorIcon)i).getSensor())) continue;
                    icon.remove();
                    super.removeFromContents(i);
                }
                this.setDirty();
                this.redrawPanel();
            }
            if (nb instanceof Memory) {
                icon = this.memoryLabelList.iterator();
                while (icon.hasNext()) {
                    i = (MemoryIcon)icon.next();
                    if (!nb.equals(((jmri.jmrit.display.MemoryIcon)i).getMemory())) continue;
                    icon.remove();
                    super.removeFromContents(i);
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this.leToolBarPanel.sensorFrame != null) {
            this.leToolBarPanel.sensorFrame.dispose();
            this.leToolBarPanel.sensorFrame = null;
        }
        if (this.leToolBarPanel.signalFrame != null) {
            this.leToolBarPanel.signalFrame.dispose();
            this.leToolBarPanel.signalFrame = null;
        }
        if (this.leToolBarPanel.iconFrame != null) {
            this.leToolBarPanel.iconFrame.dispose();
            this.leToolBarPanel.iconFrame = null;
        }
        super.dispose();
    }

    public TurnoutComboBoxPopupMenuListener newTurnoutComboBoxPopupMenuListener(NamedBeanComboBox<Turnout> comboBox) {
        return new TurnoutComboBoxPopupMenuListener(comboBox, new ArrayList<Turnout>());
    }

    public TurnoutComboBoxPopupMenuListener newTurnoutComboBoxPopupMenuListener(NamedBeanComboBox<Turnout> comboBox, List<Turnout> currentTurnouts) {
        return new TurnoutComboBoxPopupMenuListener(comboBox, currentTurnouts);
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        this.usageReport = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            this.usageReport = super.getUsageReport(bean);
            this.findTurnoutUsage(bean);
            this.findPositionalUsage(bean);
            this.findXingWhereUsed(bean);
            this.findSegmentWhereUsed(bean);
        }
        return this.usageReport;
    }

    void findTurnoutUsage(NamedBean bean) {
        for (LayoutTurnout turnout : this.getLayoutTurnoutsAndSlips()) {
            String data = this.getUsageData(turnout);
            if (bean.equals(turnout.getTurnout())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnout", data));
            }
            if (bean.equals(turnout.getSecondTurnout())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnout2", data));
            }
            if (this.isLBLockUsed(bean, turnout.getLayoutBlock())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutBlock", data));
            }
            if (turnout.hasEnteringDoubleTrack()) {
                if (this.isLBLockUsed(bean, turnout.getLayoutBlockB())) {
                    this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutBlock", data));
                }
                if (this.isLBLockUsed(bean, turnout.getLayoutBlockC())) {
                    this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutBlock", data));
                }
                if (this.isLBLockUsed(bean, turnout.getLayoutBlockD())) {
                    this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutBlock", data));
                }
            }
            if (bean.equals(turnout.getSensorA())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSensor", data));
            }
            if (bean.equals(turnout.getSensorB())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSensor", data));
            }
            if (bean.equals(turnout.getSensorC())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSensor", data));
            }
            if (bean.equals(turnout.getSensorD())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSensor", data));
            }
            if (bean.equals(turnout.getSignalAMast())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalMast", data));
            }
            if (bean.equals(turnout.getSignalBMast())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalMast", data));
            }
            if (bean.equals(turnout.getSignalCMast())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalMast", data));
            }
            if (bean.equals(turnout.getSignalDMast())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalMast", data));
            }
            if (bean.equals(turnout.getSignalA1())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalA2())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalA3())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalB1())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalB2())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalC1())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalC2())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (bean.equals(turnout.getSignalD1())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
            }
            if (!bean.equals(turnout.getSignalD2())) continue;
            this.usageReport.add(new NamedBeanUsageReport("LayoutEditorTurnoutSignalHead", data));
        }
    }

    void findPositionalUsage(NamedBean bean) {
        for (PositionablePoint point : this.getPositionablePoints()) {
            String data = this.getUsageData(point);
            if (bean.equals(point.getEastBoundSensor())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorPointSensor", data));
            }
            if (bean.equals(point.getWestBoundSensor())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorPointSensor", data));
            }
            if (bean.equals(point.getEastBoundSignalHead())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorPointSignalHead", data));
            }
            if (bean.equals(point.getWestBoundSignalHead())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorPointSignalHead", data));
            }
            if (bean.equals(point.getEastBoundSignalMast())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorPointSignalMast", data));
            }
            if (!bean.equals(point.getWestBoundSignalMast())) continue;
            this.usageReport.add(new NamedBeanUsageReport("LayoutEditorPointSignalMast", data));
        }
    }

    void findSegmentWhereUsed(NamedBean bean) {
        for (TrackSegment segment : this.getTrackSegments()) {
            if (!this.isLBLockUsed(bean, segment.getLayoutBlock())) continue;
            String data = this.getUsageData(segment);
            this.usageReport.add(new NamedBeanUsageReport("LayoutEditorSegmentBlock", data));
        }
    }

    void findXingWhereUsed(NamedBean bean) {
        for (LevelXing xing : this.getLevelXings()) {
            String data = this.getUsageData(xing);
            if (this.isLBLockUsed(bean, xing.getLayoutBlockAC())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorXingBlock", data));
            }
            if (this.isLBLockUsed(bean, xing.getLayoutBlockBD())) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorXingBlock", data));
            }
            if (this.isUsedInXing(bean, xing, LevelXing.Geometry.POINTA)) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorXingOther", data));
            }
            if (this.isUsedInXing(bean, xing, LevelXing.Geometry.POINTB)) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorXingOther", data));
            }
            if (this.isUsedInXing(bean, xing, LevelXing.Geometry.POINTC)) {
                this.usageReport.add(new NamedBeanUsageReport("LayoutEditorXingOther", data));
            }
            if (!this.isUsedInXing(bean, xing, LevelXing.Geometry.POINTD)) continue;
            this.usageReport.add(new NamedBeanUsageReport("LayoutEditorXingOther", data));
        }
    }

    String getUsageData(LayoutTrack track) {
        LayoutTrackView trackView = this.getLayoutTrackView(track);
        Point2D point = trackView.getCoordsCenter();
        if (trackView instanceof TrackSegmentView) {
            TrackSegmentView segmentView = (TrackSegmentView)trackView;
            point = new Point2D.Double(segmentView.getCentreSegX(), segmentView.getCentreSegY());
        }
        return String.format("%s :: x=%d, y=%d", track.getClass().getSimpleName(), Math.round(point.getX()), Math.round(point.getY()));
    }

    boolean isLBLockUsed(NamedBean bean, LayoutBlock lblock) {
        boolean result = false;
        if (lblock != null && bean.equals(lblock.getBlock())) {
            result = true;
        }
        return result;
    }

    boolean isUsedInXing(NamedBean bean, LevelXing xing, LevelXing.Geometry point) {
        boolean result = false;
        if (bean.equals(xing.getSensor(point))) {
            result = true;
        }
        if (bean.equals(xing.getSignalHead(point))) {
            result = true;
        }
        if (bean.equals(xing.getSignalMast(point))) {
            result = true;
        }
        return result;
    }

    private static enum ToolBarSide {
        eTOP("top"),
        eLEFT("left"),
        eBOTTOM("bottom"),
        eRIGHT("right"),
        eFLOAT("float");

        private final String name;
        private static final Map<String, ToolBarSide> ENUM_MAP;

        static {
            ConcurrentHashMap<String, ToolBarSide> map = new ConcurrentHashMap<String, ToolBarSide>();
            ToolBarSide[] toolBarSideArray = ToolBarSide.values();
            int n = toolBarSideArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolBarSide instance = toolBarSideArray[n2];
                map.put(instance.getName(), instance);
                ++n2;
            }
            ENUM_MAP = Collections.unmodifiableMap(map);
        }

        private ToolBarSide(String name) {
            this.name = name;
        }

        public static ToolBarSide getName(@CheckForNull String name) {
            return ENUM_MAP.get(name);
        }

        public String getName() {
            return this.name;
        }
    }

    class TurnoutComboBoxPopupMenuListener
    implements PopupMenuListener {
        private final NamedBeanComboBox<Turnout> comboBox;
        private final List<Turnout> currentTurnouts;

        public TurnoutComboBoxPopupMenuListener(NamedBeanComboBox<Turnout> comboBox, List<Turnout> currentTurnouts) {
            this.comboBox = comboBox;
            this.currentTurnouts = currentTurnouts;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            log.debug("PopupMenuWillBecomeVisible");
            HashSet l = new HashSet();
            this.comboBox.getManager().getNamedBeanSet().forEach(turnout -> {
                if (!this.currentTurnouts.contains(turnout) && !LayoutEditor.this.validatePhysicalTurnout(turnout.getDisplayName(), null)) {
                    l.add(turnout);
                }
            });
            this.comboBox.setExcludedItems(l);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            log.debug("PopupMenuWillBecomeInvisible");
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent event) {
            log.debug("PopupMenuCanceled");
        }
    }
}

