/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import jmri.Path;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutConnectivity {
    public static final int NONE = 0;
    public static final int XOVER_BOUNDARY_AB = 1;
    public static final int XOVER_BOUNDARY_CD = 2;
    public static final int XOVER_BOUNDARY_AC = 3;
    public static final int XOVER_BOUNDARY_BD = 4;
    public static final int XOVER_BOUNDARY_AD = 1;
    public static final int XOVER_BOUNDARY_BC = 2;
    private LayoutBlock block1 = null;
    private LayoutBlock block2 = null;
    private int direction = 0;
    private TrackSegment track1 = null;
    private LayoutTrack connect2 = null;
    private HitPointType typeConnect2 = HitPointType.NONE;
    private LayoutTurnout xover = null;
    private int xoverBoundaryType = 0;
    private PositionablePoint anchor = null;
    private static final Logger log = LoggerFactory.getLogger(LayoutConnectivity.class);

    public LayoutConnectivity(LayoutBlock b1, LayoutBlock b2) {
        this.block1 = b1;
        if (this.block1 == null) {
            log.error("null block1 when creating Layout Connectivity");
        }
        this.block2 = b2;
        if (this.block2 == null) {
            log.error("null block2 when creating Layout Connectivity");
        }
    }

    public String toString() {
        String result = "between " + this.block1.getDisplayName() + " and " + this.block2.getDisplayName() + " in direction " + Path.decodeDirection(this.direction);
        if (this.track1 != null) {
            result = String.valueOf(result) + ", track: " + this.track1.getId();
        }
        if (this.connect2 != null) {
            result = String.valueOf(result) + ", connect2: " + this.connect2.getId() + ", type2: " + (Object)((Object)this.typeConnect2);
        }
        if (this.xover != null) {
            result = String.valueOf(result) + ", xover: " + this.xover.getId() + ", xoverBoundaryType: " + this.xoverBoundaryType;
        }
        return result;
    }

    public LayoutBlock getBlock1() {
        return this.block1;
    }

    public LayoutBlock getBlock2() {
        return this.block2;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getReverseDirection() {
        return Path.reverseDirection(this.direction);
    }

    public boolean setDirection(int dir) {
        if (dir == 16 || dir == 32 || dir == 64 || dir == 128 || dir == 144 || dir == 80 || dir == 160 || dir == 96) {
            this.direction = dir;
            return true;
        }
        this.direction = 0;
        return false;
    }

    public void setConnections(TrackSegment t, LayoutTrack o, HitPointType type, PositionablePoint p) {
        this.track1 = t;
        if (t == null) {
            log.error("null track1 when setting up LayoutConnectivity");
        }
        this.connect2 = o;
        if (o == null) {
            log.error("null connect track when setting up LayoutConnectivity");
        }
        this.typeConnect2 = type;
        this.anchor = p;
    }

    public void setXoverBoundary(LayoutTurnout t, int type) {
        this.xover = t;
        if (t == null) {
            log.error("null XOver when setting up LayoutConnectivity");
        }
        this.xoverBoundaryType = type;
    }

    public TrackSegment getTrackSegment() {
        return this.track1;
    }

    public LayoutTrack getConnectedObject() {
        return this.connect2;
    }

    public HitPointType getConnectedType() {
        return this.typeConnect2;
    }

    public LayoutTurnout getXover() {
        return this.xover;
    }

    public int getXoverBoundaryType() {
        return this.xoverBoundaryType;
    }

    public PositionablePoint getAnchor() {
        return this.anchor;
    }

    public boolean equals(Object o) {
        LayoutConnectivity lc;
        boolean result = false;
        if (!(!(o instanceof LayoutConnectivity) || this.block1 == null != ((lc = (LayoutConnectivity)o).getBlock1() == null) || this.block1 != null && !this.block1.equals(lc.getBlock1()) || this.block2 == null != (lc.getBlock2() == null) || this.block2 != null && !this.block2.equals(lc.getBlock2()) || this.direction != lc.getDirection() || this.track1 == null != (lc.getTrackSegment() == null) || this.track1 != null && !this.track1.equals(lc.getTrackSegment()) || this.connect2 == null != (lc.getConnectedObject() == null) || this.connect2 != null && !this.connect2.equals(lc.getConnectedObject()) || this.typeConnect2 != lc.getConnectedType() || this.xover == null != (lc.getXover() == null) || this.xover != null && !this.xover.equals(lc.getXover()) || this.anchor == null != (lc.getAnchor() == null) || this.anchor != null && !this.anchor.equals(lc.getAnchor()))) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.block1 != null ? this.block1.hashCode() : 0);
        hash = 37 * hash + (this.block2 != null ? this.block2.hashCode() : 0);
        hash = 37 * hash + this.direction;
        hash = 37 * hash + (this.track1 != null ? this.track1.hashCode() : 0);
        hash = 37 * hash + (this.connect2 != null ? this.connect2.hashCode() : 0);
        hash = 37 * hash + this.typeConnect2.hashCode();
        hash = 37 * hash + (this.xover != null ? this.xover.hashCode() : 0);
        hash = 37 * hash + (this.anchor != null ? this.anchor.hashCode() : 0);
        return hash;
    }
}

