/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import jmri.Block;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.Turnout;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LayoutBlockConnectivityTools {
    private static final int ttlSize = 50;
    String lastErrorMessage = "Unknown Error Occured";
    private static final Logger log = LoggerFactory.getLogger(LayoutBlockConnectivityTools.class);

    public boolean checkValidDest(NamedBean sourceBean, NamedBean destBean, Routing pathMethod) throws JmriException {
        if (log.isDebugEnabled()) {
            log.debug("check valid des with source/dest bean {} {}", (Object)sourceBean.getDisplayName(), (Object)destBean.getDisplayName());
        }
        LayoutBlock facingBlock = null;
        LayoutBlock protectingBlock = null;
        LayoutBlock destFacingBlock = null;
        List<LayoutBlock> destProtectBlock = null;
        SortedSet<LayoutEditor> layout = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        for (LayoutEditor layoutEditor : layout) {
            if (log.isDebugEnabled()) {
                log.debug("Layout name {}", (Object)layoutEditor.getLayoutName());
            }
            if (facingBlock == null) {
                facingBlock = lbm.getFacingBlockByNamedBean(sourceBean, layoutEditor);
            }
            if (protectingBlock == null) {
                protectingBlock = lbm.getProtectedBlockByNamedBean(sourceBean, layoutEditor);
            }
            if (destFacingBlock == null) {
                destFacingBlock = lbm.getFacingBlockByNamedBean(destBean, layoutEditor);
            }
            if (destProtectBlock == null) {
                destProtectBlock = lbm.getProtectingBlocksByNamedBean(destBean, layoutEditor);
            }
            if (destFacingBlock != null && facingBlock != null && protectingBlock != null) {
                return this.checkValidDest(facingBlock, protectingBlock, destFacingBlock, destProtectBlock, pathMethod);
            }
            log.debug("blocks not found");
        }
        if (log.isDebugEnabled()) {
            log.debug("No valid route from {} to {}", (Object)sourceBean.getDisplayName(), (Object)destBean.getDisplayName());
        }
        throw new JmriException("Blocks Not Found");
    }

    public List<LayoutBlock> getLayoutBlocks(NamedBean sourceBean, NamedBean destBean, boolean validateOnly, Routing pathMethod) throws JmriException {
        SortedSet<LayoutEditor> layout = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        LayoutBlock facingBlock = null;
        LayoutBlock protectingBlock = null;
        LayoutBlock destFacingBlock = null;
        for (LayoutEditor layoutEditor : layout) {
            if (log.isDebugEnabled()) {
                log.debug("Layout name {}", (Object)layoutEditor.getLayoutName());
            }
            if (facingBlock == null) {
                facingBlock = lbm.getFacingBlockByNamedBean(sourceBean, layoutEditor);
            }
            if (protectingBlock == null) {
                protectingBlock = lbm.getProtectedBlockByNamedBean(sourceBean, layoutEditor);
            }
            if (destFacingBlock == null) {
                destFacingBlock = lbm.getFacingBlockByNamedBean(destBean, layoutEditor);
            }
            if (destFacingBlock != null && facingBlock != null && protectingBlock != null) {
                return this.getLayoutBlocks(facingBlock, destFacingBlock, protectingBlock, validateOnly, pathMethod);
            }
            log.debug("blocks not found");
        }
        if (log.isDebugEnabled()) {
            log.debug("No valid route from {} to {}", (Object)sourceBean.getDisplayName(), (Object)destBean.getDisplayName());
        }
        throw new JmriException("Blocks Not Found");
    }

    public List<NamedBean> getBeansInPath(List<LayoutBlock> blocklist, LayoutEditor panel, Class<?> T) {
        ArrayList<NamedBean> beansInPath = new ArrayList<NamedBean>();
        if (blocklist.size() >= 2) {
            LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
            int x = 1;
            while (x < blocklist.size()) {
                LayoutBlock facingBlock = blocklist.get(x - 1);
                LayoutBlock protectingBlock = blocklist.get(x);
                NamedBean nb = null;
                if (T == null) {
                    nb = lbm.getFacingNamedBean(facingBlock.getBlock(), protectingBlock.getBlock(), panel);
                } else if (T.equals(SignalMast.class)) {
                    nb = lbm.getFacingSignalMast(facingBlock.getBlock(), protectingBlock.getBlock(), panel);
                } else if (T.equals(Sensor.class)) {
                    nb = lbm.getFacingSensor(facingBlock.getBlock(), protectingBlock.getBlock(), panel);
                } else if (T.equals(SignalHead.class)) {
                    nb = lbm.getFacingSignalHead(facingBlock.getBlock(), protectingBlock.getBlock());
                }
                if (nb != null) {
                    beansInPath.add(nb);
                }
                ++x;
            }
        }
        return beansInPath;
    }

    public boolean checkValidDest(LayoutBlock currentBlock, LayoutBlock nextBlock, LayoutBlock destBlock, LayoutBlock destProBlock, Routing pathMethod) throws JmriException {
        ArrayList<LayoutBlock> destList = new ArrayList<LayoutBlock>();
        if (destProBlock != null) {
            destList.add(destProBlock);
        }
        return this.checkValidDest(currentBlock, nextBlock, destBlock, destList, pathMethod);
    }

    public boolean checkValidDest(LayoutBlock currentBlock, LayoutBlock nextBlock, LayoutBlock destBlock, List<LayoutBlock> destBlockn1, Routing pathMethod) throws JmriException {
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        if (!lbm.isAdvancedRoutingEnabled()) {
            log.debug("Advanced routing has not been enabled therefore we cannot use this function");
            throw new JmriException("Advanced routing has not been enabled therefore we cannot use this function");
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug("faci {}", (Object)currentBlock.getDisplayName());
                log.debug("next {}", (Object)nextBlock.getDisplayName());
                log.debug("dest {}", (Object)destBlock.getDisplayName());
                for (LayoutBlock dp : destBlockn1) {
                    log.debug("dest + 1 {}", (Object)dp.getDisplayName());
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (destBlock != null && currentBlock != null && nextBlock != null) {
            if (!currentBlock.isRouteToDestValid(nextBlock.getBlock(), destBlock.getBlock())) {
                log.debug("Route to dest not valid");
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("dest {}", (Object)destBlock.getDisplayName());
            }
            if (!destBlockn1.isEmpty() && currentBlock == destBlockn1.get(0) && nextBlock == destBlock) {
                log.debug("Our dest protecting block is our current block and our protecting block is the same as our destination block");
                return false;
            }
            int proCount = 0;
            int desCount = 0;
            if (!destBlockn1.isEmpty()) {
                desCount = currentBlock.getBlockHopCount(destBlock.getBlock(), nextBlock.getBlock());
                proCount = currentBlock.getBlockHopCount(destBlockn1.get(0).getBlock(), nextBlock.getBlock());
                if (log.isDebugEnabled()) {
                    log.debug("dest {} protecting {}", (Object)desCount, (Object)proCount);
                }
            }
            if (proCount == -1 && desCount == -1) {
                log.debug("Dest and dest+1 are directly connected");
                return false;
            }
            if (proCount > desCount && proCount - 1 == desCount) {
                log.debug("Protecting is one hop away from destination and therefore valid.");
                return true;
            }
            if (pathMethod == Routing.SENSORTOSENSOR && destBlockn1.size() == 0) {
                pathMethod = Routing.NONE;
            }
            List<LayoutBlock> blockList = this.getLayoutBlocks(currentBlock, destBlock, nextBlock, true, pathMethod);
            if (log.isDebugEnabled()) {
                log.debug("checkValidDest blockList for {}", (Object)destBlock.getDisplayName());
                blockList.forEach(blk -> log.debug("  block = {}", (Object)blk.getDisplayName()));
            }
            for (LayoutBlock dp : destBlockn1) {
                log.debug("dp = {}", (Object)dp.getDisplayName());
                if (!blockList.contains(dp) || currentBlock == dp) continue;
                log.debug("Signal mast in the wrong direction");
                return false;
            }
            log.debug("Signal mast in the correct direction");
            return true;
        }
        if (destBlock == null) {
            throw new JmriException("Block in Destination Field returns as invalid");
        }
        if (currentBlock == null) {
            throw new JmriException("Block in Facing Field returns as invalid");
        }
        if (nextBlock == null) {
            throw new JmriException("Block in Protecting Field returns as invalid");
        }
        throw new JmriException("BlockIsNull");
    }

    private boolean checkValidDest(LayoutBlock facing, LayoutBlock protecting, FacingProtecting dest, Routing pathMethod) throws JmriException {
        if (facing == null || protecting == null || dest == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("facing : {} protecting : {} dest {}", new Object[]{protecting.getDisplayName(), dest.getBean().getDisplayName(), facing.getDisplayName()});
        }
        ArrayList<LayoutBlock> destList = new ArrayList<LayoutBlock>();
        dest.getProtectingBlocks().forEach(b -> destList.add(InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock((Block)b)));
        return this.checkValidDest(facing, protecting, InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(dest.getFacing()), destList, pathMethod);
    }

    public List<LayoutBlock> getLayoutBlocks(LayoutBlock sourceLayoutBlock, LayoutBlock destinationLayoutBlock, LayoutBlock protectingLayoutBlock, boolean validateOnly, Routing pathMethod) throws JmriException {
        this.lastErrorMessage = "Unknown Error Occured";
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        if (!lbm.isAdvancedRoutingEnabled()) {
            log.debug("Advanced routing has not been enabled therefore we cannot use this function");
            throw new JmriException("Advanced routing has not been enabled therefore we cannot use this function");
        }
        int directionOfTravel = sourceLayoutBlock.getNeighbourDirection(protectingLayoutBlock);
        Block currentBlock = sourceLayoutBlock.getBlock();
        Block destBlock = destinationLayoutBlock.getBlock();
        log.debug("Destination Block {} {}", (Object)destinationLayoutBlock.getDisplayName(), (Object)destBlock);
        Block nextBlock = protectingLayoutBlock.getBlock();
        if (log.isDebugEnabled()) {
            log.debug("s:{} p:{} d:{}", new Object[]{sourceLayoutBlock.getDisplayName(), protectingLayoutBlock.getDisplayName(), destinationLayoutBlock.getDisplayName()});
        }
        ArrayList<BlocksTested> blocksInRoute = new ArrayList<BlocksTested>();
        blocksInRoute.add(new BlocksTested(sourceLayoutBlock));
        if (!validateOnly) {
            if (!this.canLBlockBeUsed(protectingLayoutBlock)) {
                this.lastErrorMessage = "Block we are protecting is already occupied or reserved";
                log.debug("will throw {}", (Object)this.lastErrorMessage);
                throw new JmriException(this.lastErrorMessage);
            }
            blocksInRoute.add(new BlocksTested(protectingLayoutBlock));
            if (!this.canLBlockBeUsed(destinationLayoutBlock)) {
                this.lastErrorMessage = "Destination Block is already occupied or reserved";
                log.debug("will throw {}", (Object)this.lastErrorMessage);
                throw new JmriException(this.lastErrorMessage);
            }
        } else {
            blocksInRoute.add(new BlocksTested(protectingLayoutBlock));
        }
        if (destinationLayoutBlock == protectingLayoutBlock) {
            ArrayList<LayoutBlock> returnBlocks = new ArrayList<LayoutBlock>();
            blocksInRoute.forEach(blocksTested -> returnBlocks.add(blocksTested.getBlock()));
            return returnBlocks;
        }
        BlocksTested bt = (BlocksTested)blocksInRoute.get(blocksInRoute.size() - 1);
        int ttl = 1;
        List<Integer> offSet = new ArrayList<Integer>();
        while (ttl < 50) {
            log.debug("===== Ttl value = {} ======", (Object)ttl);
            log.debug("Looking for next block");
            int nextBlockIndex = this.findBestHop(currentBlock, nextBlock, destBlock, directionOfTravel, offSet, validateOnly, pathMethod);
            if (nextBlockIndex != -1) {
                LayoutBlock currentLBlock;
                bt.addIndex(nextBlockIndex);
                if (log.isDebugEnabled()) {
                    log.debug("block index returned {} Blocks in route size {}", (Object)nextBlockIndex, (Object)blocksInRoute.size());
                }
                if ((currentLBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(nextBlock)) == null) {
                    log.error("Unable to get block :{}: from instancemanager", (Object)nextBlock);
                    continue;
                }
                offSet.clear();
                directionOfTravel = currentLBlock.getRouteDirectionAtIndex(nextBlockIndex);
                currentBlock = nextBlock;
                nextBlock = currentLBlock.getRouteNextBlockAtIndex(nextBlockIndex);
                LayoutBlock nextLBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(nextBlock);
                if (log.isDebugEnabled()) {
                    log.debug("Blocks in route size {}", (Object)blocksInRoute.size());
                    log.debug("next: {} dest: {}", (Object)nextBlock.getDisplayName(), (Object)destBlock.getDisplayName());
                }
                if (nextBlock == currentBlock) {
                    nextBlock = currentLBlock.getRouteDestBlockAtIndex(nextBlockIndex);
                    log.debug("the next block to our destination we are looking for is directly connected to this one");
                } else if (protectingLayoutBlock != nextLBlock) {
                    if (nextLBlock != null) {
                        log.debug("Add block {}", (Object)nextLBlock.getDisplayName());
                    }
                    bt = new BlocksTested(nextLBlock);
                    blocksInRoute.add(bt);
                }
                if (nextBlock == destBlock) {
                    if (!validateOnly && !this.checkForLevelCrossing(destinationLayoutBlock)) {
                        throw new JmriException("Destination block is in conflict on a crossover");
                    }
                    ArrayList<LayoutBlock> returnBlocks = new ArrayList<LayoutBlock>();
                    blocksInRoute.forEach(blocksTested -> returnBlocks.add(blocksTested.getBlock()));
                    returnBlocks.add(destinationLayoutBlock);
                    if (log.isDebugEnabled()) {
                        log.debug("Adding destination Block {}", (Object)destinationLayoutBlock.getDisplayName());
                        log.debug("arrived at destination block");
                        log.debug("{} Return as Long", (Object)sourceLayoutBlock.getDisplayName());
                        returnBlocks.forEach(returnBlock -> log.debug("  return block {}", (Object)returnBlock.getDisplayName()));
                        log.debug("Finished List");
                    }
                    return returnBlocks;
                }
            } else {
                int birSize = blocksInRoute.size();
                log.debug("block in route size {}", (Object)birSize);
                if (birSize <= 2) {
                    log.debug("drop out here with ttl");
                    ttl = 51;
                } else {
                    if (log.isDebugEnabled()) {
                        int t = 0;
                        while (t < blocksInRoute.size()) {
                            log.debug("index {} block {}", (Object)t, (Object)((BlocksTested)blocksInRoute.get(t)).getBlock().getDisplayName());
                            ++t;
                        }
                        log.debug("To remove last block {}", (Object)((BlocksTested)blocksInRoute.get(birSize - 1)).getBlock().getDisplayName());
                    }
                    currentBlock = ((BlocksTested)blocksInRoute.get(birSize - 3)).getBlock().getBlock();
                    nextBlock = ((BlocksTested)blocksInRoute.get(birSize - 2)).getBlock().getBlock();
                    offSet = ((BlocksTested)blocksInRoute.get(birSize - 2)).getTestedIndexes();
                    bt = (BlocksTested)blocksInRoute.get(birSize - 2);
                    blocksInRoute.remove(birSize - 1);
                    --ttl;
                }
            }
            ++ttl;
        }
        if (ttl == 50) {
            this.lastErrorMessage = "ttlExpired";
        }
        throw new JmriException(this.lastErrorMessage);
    }

    private boolean canLBlockBeUsed(LayoutBlock lBlock) {
        if (lBlock == null) {
            return true;
        }
        if (lBlock.getUseExtraColor()) {
            return false;
        }
        if (lBlock.getBlock().getPermissiveWorking()) {
            return true;
        }
        return lBlock.getState() != 2;
    }

    int findBestHop(Block preBlock, Block currentBlock, Block destBlock, int direction, List<Integer> offSet, boolean validateOnly, Routing pathMethod) {
        int result = 0;
        LayoutBlock currentLBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(currentBlock);
        if (currentLBlock == null) {
            return -1;
        }
        ArrayList<Integer> blkIndexTested = new ArrayList<Integer>(5);
        if (log.isDebugEnabled()) {
            log.debug("In find best hop current {} previous {}", (Object)currentLBlock.getDisplayName(), (Object)preBlock.getDisplayName());
        }
        while (result != -1) {
            if (currentBlock == preBlock) {
                log.debug("At get ConnectedBlockRoute");
                result = currentLBlock.getConnectedBlockRouteIndex(destBlock, direction);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Off Set {}", offSet);
                }
                result = currentLBlock.getNextBestBlock(preBlock, destBlock, offSet, Metric.METRIC);
            }
            if (result != -1) {
                Block block = currentLBlock.getRouteNextBlockAtIndex(result);
                LayoutBlock lBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(block);
                Block blocktoCheck = block;
                if (block == currentBlock) {
                    log.debug("current block matches returned block therefore the next block is directly connected");
                    blocktoCheck = destBlock;
                }
                if (block == currentBlock && currentLBlock.getThroughPathIndex(preBlock, destBlock) == -1) {
                    this.lastErrorMessage = "block " + block.getDisplayName() + " is directly attached, however the route to the destination block " + destBlock.getDisplayName() + " can not be directly used";
                    log.debug("continue after {}", (Object)this.lastErrorMessage);
                } else if (validateOnly || this.checkForDoubleCrossover(preBlock, currentLBlock, blocktoCheck) && this.checkForLevelCrossing(currentLBlock) && this.canLBlockBeUsed(lBlock)) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} not occupied & not reserved but we need to check if the anchor point between the two contains a signal or not", (Object)block.getDisplayName());
                        log.debug("  current {} {}", (Object)currentBlock.getDisplayName(), (Object)block.getDisplayName());
                    }
                    NamedBean foundBean = null;
                    MDC.put((String)"loggingDisabled", (String)LayoutBlockManager.class.getName());
                    switch (pathMethod) {
                        case MASTTOMAST: {
                            foundBean = InstanceManager.getDefault(LayoutBlockManager.class).getFacingSignalMast(currentBlock, blocktoCheck);
                            break;
                        }
                        case HEADTOHEAD: {
                            foundBean = InstanceManager.getDefault(LayoutBlockManager.class).getFacingSignalHead(currentBlock, blocktoCheck);
                            break;
                        }
                        case SENSORTOSENSOR: {
                            foundBean = InstanceManager.getDefault(LayoutBlockManager.class).getFacingSensor(currentBlock, blocktoCheck, null);
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            foundBean = InstanceManager.getDefault(LayoutBlockManager.class).getFacingNamedBean(currentBlock, blocktoCheck, null);
                        }
                    }
                    MDC.remove((String)"loggingDisabled");
                    if (foundBean == null) {
                        log.debug("No object found so okay to return");
                        return result;
                    }
                    this.lastErrorMessage = "Signal " + foundBean.getDisplayName() + " already exists between blocks " + currentBlock.getDisplayName() + " and " + blocktoCheck.getDisplayName() + " in the same direction on this path";
                    log.debug("continue after {}", (Object)this.lastErrorMessage);
                } else {
                    this.lastErrorMessage = "block " + block.getDisplayName() + " found not to be not usable";
                    log.debug("continue after {}", (Object)this.lastErrorMessage);
                }
                if (blkIndexTested.contains(result)) {
                    this.lastErrorMessage = "No valid free path found";
                    return -1;
                }
                blkIndexTested.add(result);
                offSet.add(result);
                continue;
            }
            log.debug("At this point the getNextBextBlock() has returned a -1");
        }
        return -1;
    }

    private boolean checkForDoubleCrossover(Block prevBlock, LayoutBlock curBlock, Block nextBlock) {
        LayoutEditor le = curBlock.getMaxConnectedPanel();
        ConnectivityUtil ct = le.getConnectivityUtil();
        List<LayoutTrackExpectedState<LayoutTurnout>> turnoutList = ct.getTurnoutList(curBlock.getBlock(), prevBlock, nextBlock);
        for (LayoutTrackExpectedState<LayoutTurnout> layoutTurnoutLayoutTrackExpectedState : turnoutList) {
            Turnout t;
            LayoutTurnout lt = (LayoutTurnout)layoutTurnoutLayoutTrackExpectedState.getObject();
            if (lt.getTurnoutType() != LayoutTurnout.TurnoutType.DOUBLE_XOVER || layoutTurnoutLayoutTrackExpectedState.getExpectedState() != 4 || (t = lt.getTurnout()).getKnownState() != 4 || !(lt.getLayoutBlock() == curBlock || lt.getLayoutBlockC() == curBlock ? !this.canLBlockBeUsed(lt.getLayoutBlockB()) && !this.canLBlockBeUsed(lt.getLayoutBlockD()) : (lt.getLayoutBlockB() == curBlock || lt.getLayoutBlockD() == curBlock) && !this.canLBlockBeUsed(lt.getLayoutBlock()) && !this.canLBlockBeUsed(lt.getLayoutBlockC()))) continue;
            return false;
        }
        return true;
    }

    private boolean checkForLevelCrossing(LayoutBlock curBlock) {
        LayoutEditor lay = curBlock.getMaxConnectedPanel();
        for (LevelXing lx : lay.getLevelXings()) {
            if (lx.getLayoutBlockAC() != curBlock && lx.getLayoutBlockBD() != curBlock || lx.getLayoutBlockAC() == null || lx.getLayoutBlockBD() == null || lx.getLayoutBlockAC() == lx.getLayoutBlockBD() || !(lx.getLayoutBlockAC() == curBlock ? !this.canLBlockBeUsed(lx.getLayoutBlockBD()) : lx.getLayoutBlockBD() == curBlock && !this.canLBlockBeUsed(lx.getLayoutBlockAC()))) continue;
            return false;
        }
        return true;
    }

    public HashMap<NamedBean, List<NamedBean>> discoverValidBeanPairs(LayoutEditor editor, Class<?> T, Routing pathMethod) {
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        HashMap<NamedBean, List<NamedBean>> retPairs = new HashMap<NamedBean, List<NamedBean>>();
        List<FacingProtecting> beanList = this.generateBlocksWithBeans(editor, T);
        beanList.forEach(fp -> fp.getProtectingBlocks().stream().map(block -> {
            if (log.isDebugEnabled()) {
                try {
                    log.debug("\nSource {}", (Object)fp.getBean().getDisplayName());
                    log.debug("facing {}", (Object)fp.getFacing().getDisplayName());
                    log.debug("protecting {}", (Object)block.getDisplayName());
                }
                catch (NullPointerException nullPointerException) {}
            }
            return block;
        }).forEachOrdered(block -> {
            LayoutBlock lFacing = lbm.getLayoutBlock(fp.getFacing());
            LayoutBlock lProtecting = lbm.getLayoutBlock((Block)block);
            NamedBean source = fp.getBean();
            try {
                retPairs.put(source, this.discoverPairDest(source, lProtecting, lFacing, beanList, pathMethod));
            }
            catch (JmriException ex) {
                log.error("exception in retPairs.put", (Throwable)ex);
            }
        }));
        return retPairs;
    }

    public List<NamedBean> discoverPairDest(NamedBean source, LayoutEditor editor, Class<?> T, Routing pathMethod) throws JmriException {
        if (log.isDebugEnabled()) {
            log.debug("discover pairs from source {}", (Object)source.getDisplayName());
        }
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        LayoutBlock lFacing = lbm.getFacingBlockByNamedBean(source, editor);
        List<LayoutBlock> lProtecting = lbm.getProtectingBlocksByNamedBean(source, editor);
        ArrayList<NamedBean> ret = new ArrayList<NamedBean>();
        List<FacingProtecting> beanList = this.generateBlocksWithBeans(editor, T);
        for (LayoutBlock lb : lProtecting) {
            ret.addAll(this.discoverPairDest(source, lb, lFacing, beanList, pathMethod));
        }
        return ret;
    }

    List<NamedBean> discoverPairDest(NamedBean source, LayoutBlock lProtecting, LayoutBlock lFacing, List<FacingProtecting> blockList, Routing pathMethod) throws JmriException {
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        if (!lbm.isAdvancedRoutingEnabled()) {
            throw new JmriException("advanced routing not enabled");
        }
        if (!lbm.routingStablised()) {
            throw new JmriException("routing not stabilised");
        }
        ArrayList<NamedBean> validDestBean = new ArrayList<NamedBean>();
        for (FacingProtecting facingProtecting : blockList) {
            if (facingProtecting.getBean() == source) continue;
            NamedBean destObj = facingProtecting.getBean();
            if (log.isDebugEnabled()) {
                log.debug("looking for pair {} {}", (Object)source.getDisplayName(), (Object)destObj.getDisplayName());
            }
            try {
                if (!this.checkValidDest(lFacing, lProtecting, facingProtecting, pathMethod)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Valid pair {} {}", (Object)source.getDisplayName(), (Object)destObj.getDisplayName());
                }
                LayoutBlock ldstBlock = lbm.getLayoutBlock(facingProtecting.getFacing());
                try {
                    List<LayoutBlock> lblks = this.getLayoutBlocks(lFacing, ldstBlock, lProtecting, true, pathMethod);
                    if (log.isDebugEnabled()) {
                        log.debug("Adding block {} to paths, current size {}", (Object)destObj.getDisplayName(), (Object)lblks.size());
                    }
                    validDestBean.add(destObj);
                }
                catch (JmriException jmriException) {
                    log.debug("not a valid route through {} - {}", (Object)source.getDisplayName(), (Object)destObj.getDisplayName());
                }
            }
            catch (JmriException ex) {
                log.debug("caught exception in discoverPairsDest", (Throwable)ex);
            }
        }
        return validDestBean;
    }

    List<FacingProtecting> generateBlocksWithBeans(LayoutEditor editor, Class<?> T) {
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        ArrayList<FacingProtecting> beanList = new ArrayList<FacingProtecting>();
        for (LayoutBlock curLblk : lbm.getNamedBeanSet()) {
            Block curBlk = curLblk.getBlock();
            LayoutEditor useEdit = editor;
            if (editor == null) {
                useEdit = curLblk.getMaxConnectedPanel();
            }
            if (curBlk == null) continue;
            int noNeigh = curLblk.getNumberOfNeighbours();
            int x = 0;
            while (x < noNeigh) {
                List<LayoutBlock> lProBlk;
                Block blk = curLblk.getNeighbourAtIndex(x);
                ArrayList<Block> proBlk = new ArrayList<Block>();
                NamedBean bean = null;
                if (T == null) {
                    proBlk.add(blk);
                    bean = lbm.getFacingNamedBean(curBlk, blk, useEdit);
                } else if (T.equals(SignalMast.class)) {
                    bean = lbm.getFacingSignalMast(curBlk, blk, useEdit);
                    if (bean != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Get list of protecting blocks for {} facing {}", (Object)bean.getDisplayName(), (Object)curBlk.getDisplayName());
                        }
                        lProBlk = lbm.getProtectingBlocksByNamedBean(bean, useEdit);
                        for (LayoutBlock lb : lProBlk) {
                            if (lb == null) continue;
                            proBlk.add(lb.getBlock());
                        }
                    }
                } else if (T.equals(Sensor.class)) {
                    bean = lbm.getFacingSensor(curBlk, blk, useEdit);
                    if (bean != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Get list of protecting blocks for {}", (Object)bean.getDisplayName());
                        }
                        lProBlk = lbm.getProtectingBlocksByNamedBean(bean, useEdit);
                        for (LayoutBlock lb : lProBlk) {
                            if (lb == null) continue;
                            proBlk.add(lb.getBlock());
                        }
                    }
                } else {
                    log.error("Past bean type is unknown {}", T);
                }
                if (bean != null) {
                    FacingProtecting toadd = new FacingProtecting(curBlk, proBlk, bean);
                    boolean found = false;
                    for (FacingProtecting fp : beanList) {
                        if (!fp.equals(toadd)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        beanList.add(toadd);
                    }
                }
                ++x;
            }
            if (noNeigh != 1) continue;
            NamedBean bean = null;
            if (log.isDebugEnabled()) {
                log.debug("We have a dead end {}", (Object)curBlk.getDisplayName());
            }
            if (T == null) {
                bean = lbm.getNamedBeanAtEndBumper(curBlk, useEdit);
            } else if (T.equals(SignalMast.class)) {
                bean = lbm.getSignalMastAtEndBumper(curBlk, useEdit);
            } else if (T.equals(Sensor.class)) {
                bean = lbm.getSensorAtEndBumper(curBlk, useEdit);
            } else {
                log.error("Past bean type is unknown {}", T);
            }
            if (bean == null) continue;
            FacingProtecting toadd = new FacingProtecting(curBlk, null, bean);
            boolean found = false;
            for (FacingProtecting fp : beanList) {
                if (!fp.equals(toadd)) continue;
                found = true;
                break;
            }
            if (found) continue;
            beanList.add(toadd);
        }
        return beanList;
    }

    static class BlocksTested {
        LayoutBlock block;
        List<Integer> indexNumber = new ArrayList<Integer>();

        BlocksTested(LayoutBlock block) {
            this.block = block;
        }

        void addIndex(int x) {
            this.indexNumber.add(x);
        }

        int getLastIndex() {
            return this.indexNumber.get(this.indexNumber.size() - 1);
        }

        List<Integer> getTestedIndexes() {
            return this.indexNumber;
        }

        LayoutBlock getBlock() {
            return this.block;
        }
    }

    static class FacingProtecting {
        Block facing;
        List<Block> protectingBlocks;
        NamedBean bean;

        FacingProtecting(Block facing, List<Block> protecting, NamedBean bean) {
            this.facing = facing;
            this.protectingBlocks = protecting == null ? new ArrayList<Block>(0) : protecting;
            this.bean = bean;
        }

        Block getFacing() {
            return this.facing;
        }

        List<Block> getProtectingBlocks() {
            return this.protectingBlocks;
        }

        NamedBean getBean() {
            return this.bean;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FacingProtecting tmp = (FacingProtecting)obj;
            if (tmp.getBean() != this.bean) {
                return false;
            }
            if (tmp.getFacing() != this.facing) {
                return false;
            }
            return tmp.getProtectingBlocks().equals(this.protectingBlocks);
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.bean != null ? this.bean.hashCode() : 0);
            hash = 37 * hash + (this.facing != null ? this.facing.hashCode() : 0);
            hash = 37 * hash + (this.protectingBlocks != null ? this.protectingBlocks.hashCode() : 0);
            return hash;
        }
    }

    public static enum Metric {
        HOPCOUNT,
        METRIC,
        DISTANCE;

    }

    public static enum Routing {
        MASTTOMAST,
        HEADTOHEAD,
        SENSORTOSENSOR,
        ANY,
        NONE;

    }
}

