/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import jmri.BeanSetting;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Reportable;
import jmri.Reporter;
import jmri.Sensor;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.beantable.beanedit.BeanEditItem;
import jmri.jmrit.beantable.beanedit.BeanItemPanel;
import jmri.jmrit.beantable.beanedit.BlockEditAction;
import jmri.jmrit.display.layoutEditor.Bundle;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorAuxTools;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.MemoryIcon;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.roster.RosterEntry;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.MathUtil;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.SplitButtonColorChooserPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LayoutBlock
extends AbstractNamedBean
implements PropertyChangeListener {
    private final boolean enableAddRouteLogging = false;
    private final boolean enableUpdateRouteLogging = false;
    private boolean enableDeleteRouteLogging = false;
    private final boolean enableSearchRouteLogging = false;
    private static final List<Integer> updateReferences = new ArrayList<Integer>(500);
    private final List<Integer> actedUponUpdates = new ArrayList<Integer>(500);
    public static final int OCCUPIED = 2;
    public static final int EMPTY = 4;
    private int useCount = 0;
    private NamedBeanHandle<Sensor> occupancyNamedSensor = null;
    private NamedBeanHandle<Memory> namedMemory = null;
    private Block block = null;
    private final List<LayoutEditor> panels = new ArrayList<LayoutEditor>();
    private PropertyChangeListener mBlockListener = null;
    private int jmriblknum = 1;
    private boolean useExtraColor = false;
    private boolean suppressNameUpdate = false;
    private String occupancySensorName = "";
    private String memoryName = "";
    private int occupiedSense = 2;
    private Color blockTrackColor = Color.darkGray;
    private Color blockOccupiedColor = Color.red;
    private Color blockExtraColor = Color.white;
    private JmriJFrame editLayoutBlockFrame = null;
    private final JTextField sensorNameField = new JTextField(16);
    private final JTextField sensorDebounceInactiveField = new JTextField(5);
    private final JTextField sensorDebounceActiveField = new JTextField(5);
    private final JCheckBox sensorDebounceGlobalCheck = new JCheckBox(Bundle.getMessage("SensorUseGlobalDebounce"));
    private final NamedBeanComboBox<Memory> memoryComboBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(MemoryManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
    private final JTextField metricField = new JTextField(10);
    private final JComboBox<String> senseBox = new JComboBox();
    private int senseActiveIndex;
    private int senseInactiveIndex;
    private JColorChooser trackColorChooser = null;
    private JColorChooser occupiedColorChooser = null;
    private JColorChooser extraColorChooser = null;
    private final String[] working = new String[]{"Bi-Directional", "Receive Only", "Send Only"};
    protected List<JComboBox<String>> neighbourDir;
    boolean active = true;
    private boolean defaultMetric = true;
    static long time = 0L;
    private LayoutEditorAuxTools auxTools = null;
    private ConnectivityUtil connection = null;
    private boolean layoutConnectivity = true;
    public static final int RESERVED = 8;
    List<Adjacencies> neighbours = new ArrayList<Adjacencies>();
    List<ThroughPaths> throughPaths = new ArrayList<ThroughPaths>();
    List<Routes> routes = new ArrayList<Routes>();
    static final int ADDITION = 0;
    static final int UPDATE = 2;
    static final int REMOVAL = 4;
    static final int RXTX = 0;
    static final int RXONLY = 2;
    static final int TXONLY = 4;
    static final int NONE = 8;
    int metric = 100;
    List<ThroughPaths> activePaths;
    private static final Logger log = LoggerFactory.getLogger(LayoutBlock.class);

    public void enableDeleteRouteLog() {
        this.enableDeleteRouteLogging = false;
    }

    public void disableDeleteRouteLog() {
        this.enableDeleteRouteLogging = false;
    }

    public LayoutBlock(String sName, String uName) {
        super(sName, uName);
    }

    public void initializeLayoutBlock() {
        this.block = null;
        String userName = this.getUserName();
        if (userName != null && !userName.isEmpty()) {
            this.block = (Block)InstanceManager.getDefault(BlockManager.class).getByUserName(userName);
        }
        if (this.block == null) {
            String s;
            BlockManager bm = InstanceManager.getDefault(BlockManager.class);
            while (true) {
                if (this.jmriblknum > 50000) {
                    throw new IndexOutOfBoundsException("Run away prevented while trying to create a block");
                }
                s = "IB" + this.jmriblknum;
                ++this.jmriblknum;
                this.block = (Block)bm.getBySystemName(s);
                if (this.block != null) {
                    log.debug("System name is already used: {}", (Object)s);
                    continue;
                }
                this.block = bm.createNewBlock(s, null);
                if (this.block == null) {
                    log.debug("Null block returned: {}", (Object)s);
                    continue;
                }
                Block testGet = (Block)bm.getBySystemName(s);
                if (testGet != null && bm.getNamedBeanSet().contains(testGet)) break;
                log.debug("Registration failed: {}", (Object)s);
            }
            log.debug("Block is valid: {}", (Object)s);
            this.block.setUserName(this.getUserName());
        }
        this.mBlockListener = this::handleBlockChange;
        this.block.addPropertyChangeListener(this.mBlockListener, this.getUserName(), "Layout Block:" + this.getUserName());
        if (this.occupancyNamedSensor != null) {
            this.block.setNamedSensor(this.occupancyNamedSensor);
        }
    }

    public void initializeLayoutBlockRouting() {
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            return;
        }
        this.setBlockMetric();
        this.block.getPaths().stream().forEach(this::addAdjacency);
    }

    public String getId() {
        return this.getUserName();
    }

    public Color getBlockTrackColor() {
        return this.blockTrackColor;
    }

    public void setBlockTrackColor(Color color) {
        this.blockTrackColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBlockOccupiedColor() {
        return this.blockOccupiedColor;
    }

    public void setBlockOccupiedColor(Color color) {
        this.blockOccupiedColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public Color getBlockExtraColor() {
        return this.blockExtraColor;
    }

    public void setBlockExtraColor(Color color) {
        this.blockExtraColor = color;
        JmriColorChooser.addRecentColor(color);
    }

    public boolean getUseExtraColor() {
        return this.useExtraColor;
    }

    public void setUseExtraColor(boolean b) {
        this.useExtraColor = b;
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            this.stateUpdate();
        }
        if (this.getBlock() != null) {
            this.getBlock().setAllocated(b);
        }
    }

    public void incrementUse() {
        ++this.useCount;
    }

    public void decrementUse() {
        --this.useCount;
        if (this.useCount <= 0) {
            this.useCount = 0;
        }
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void addLayoutEditor(LayoutEditor panel) {
        if (!this.panels.contains(panel)) {
            this.panels.add(panel);
        }
    }

    public void deleteLayoutEditor(LayoutEditor panel) {
        if (this.panels.contains(panel)) {
            this.panels.remove(panel);
        }
    }

    public boolean isOnPanel(LayoutEditor panel) {
        return this.panels.contains(panel);
    }

    public void redrawLayoutBlockPanels() {
        this.panels.stream().forEach(LayoutEditor::redrawPanel);
        this.firePropertyChange("redraw", null, null);
    }

    public Sensor validateSensor(String sensorName, Component openFrame) {
        if (sensorName == null || sensorName.isEmpty()) {
            if (this.occupancyNamedSensor != null) {
                this.setOccupancySensorName(null);
            }
            return null;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(sensorName);
        if (s == null) {
            JOptionPane.showMessageDialog(openFrame, MessageFormat.format(Bundle.getMessage("Error7"), sensorName), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        NamedBeanHandle<Sensor> savedNamedSensor = this.occupancyNamedSensor;
        this.occupancyNamedSensor = null;
        LayoutBlock b = InstanceManager.getDefault(LayoutBlockManager.class).getBlockWithSensorAssigned(s);
        if (b != this) {
            if (b != null) {
                if (b.getUseCount() > 0) {
                    this.occupancyNamedSensor = savedNamedSensor;
                    JOptionPane.showMessageDialog(openFrame, MessageFormat.format(Bundle.getMessage("Error6"), sensorName, b.getId()), Bundle.getMessage("ErrorTitle"), 0);
                    return null;
                }
                b.setOccupancySensorName(null);
            }
            this.setOccupancySensorName(sensorName);
        }
        return s;
    }

    public Memory validateMemory(String memName, Component openFrame) {
        if (memName == null || memName.isEmpty()) {
            return null;
        }
        Memory m = InstanceManager.memoryManagerInstance().getMemory(memName);
        if (m == null) {
            JOptionPane.showMessageDialog(openFrame, MessageFormat.format(Bundle.getMessage("Error16"), memName), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        this.memoryName = memName;
        if (m != this.getMemory() && this.panels.size() > 0) {
            boolean updateall = false;
            boolean found = false;
            for (LayoutEditor panel : this.panels) {
                for (MemoryIcon memIcon : panel.getMemoryLabelList()) {
                    if (memIcon.getLayoutBlock() != this) continue;
                    if (!updateall && !found) {
                        int n = JOptionPane.showConfirmDialog(openFrame, "Would you like to update all memory icons on the panel linked to the block to use the new one?", "Update Memory Icons", 0);
                        found = true;
                        if (n == 0) {
                            updateall = true;
                        }
                    }
                    if (!updateall) continue;
                    memIcon.setMemory(this.memoryName);
                }
            }
        }
        return m;
    }

    public Color getBlockColor() {
        if (this.getOccupancy() == 2) {
            return this.blockOccupiedColor;
        }
        if (this.useExtraColor) {
            return this.blockExtraColor;
        }
        return this.blockTrackColor;
    }

    public Block getBlock() {
        return this.block;
    }

    public String getMemoryName() {
        if (this.namedMemory != null) {
            return this.namedMemory.getName();
        }
        return this.memoryName;
    }

    public Memory getMemory() {
        if (this.namedMemory == null) {
            this.setMemoryName(this.memoryName);
        }
        if (this.namedMemory != null) {
            return this.namedMemory.getBean();
        }
        return null;
    }

    public void setMemoryName(String name) {
        if (name == null || name.isEmpty()) {
            this.namedMemory = null;
            this.memoryName = "";
            return;
        }
        this.memoryName = name;
        Memory memory = InstanceManager.memoryManagerInstance().getMemory(name);
        if (memory != null) {
            this.namedMemory = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, memory);
        }
    }

    public void setMemory(Memory m, String name) {
        if (m == null) {
            this.namedMemory = null;
            this.memoryName = name == null ? "" : name;
            return;
        }
        this.namedMemory = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, m);
    }

    public String getOccupancySensorName() {
        if (this.occupancyNamedSensor == null && this.block != null) {
            this.occupancyNamedSensor = this.block.getNamedSensor();
        }
        if (this.occupancyNamedSensor != null) {
            return this.occupancyNamedSensor.getName();
        }
        return this.occupancySensorName;
    }

    public Sensor getOccupancySensor() {
        if (this.occupancyNamedSensor == null && this.block != null) {
            this.occupancyNamedSensor = this.block.getNamedSensor();
        }
        if (this.occupancyNamedSensor != null) {
            return this.occupancyNamedSensor.getBean();
        }
        return null;
    }

    public void setOccupancySensorName(String name) {
        if (name == null || name.isEmpty()) {
            if (this.occupancyNamedSensor != null) {
                this.occupancyNamedSensor.getBean().removePropertyChangeListener(this.mBlockListener);
            }
            this.occupancyNamedSensor = null;
            this.occupancySensorName = "";
            if (this.block != null) {
                this.block.setNamedSensor(null);
            }
            return;
        }
        this.occupancySensorName = name;
        Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(name);
        if (sensor != null) {
            this.occupancyNamedSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, sensor);
            if (this.block != null) {
                this.block.setNamedSensor(this.occupancyNamedSensor);
            }
        }
    }

    public int getOccupiedSense() {
        return this.occupiedSense;
    }

    public void setOccupiedSense(int sense) {
        this.occupiedSense = sense;
    }

    public int getOccupancy() {
        Sensor s;
        if (this.occupancyNamedSensor == null) {
            s = null;
            if (!this.occupancySensorName.isEmpty()) {
                s = InstanceManager.sensorManagerInstance().getSensor(this.occupancySensorName);
            }
            if (s == null) {
                if (this.block != null) {
                    return this.block.getState();
                }
                return 1;
            }
            this.occupancyNamedSensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.occupancySensorName, s);
            if (this.block != null) {
                this.block.setNamedSensor(this.occupancyNamedSensor);
            }
        }
        if ((s = this.getOccupancySensor()) == null) {
            return 1;
        }
        if (s.getKnownState() != this.occupiedSense) {
            return 4;
        }
        if (s.getKnownState() == this.occupiedSense) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getState() {
        return this.getOccupancy();
    }

    @Override
    public void setState(int i) {
        log.error("this state does nothing {}", (Object)this.getDisplayName());
    }

    public LayoutEditor getMaxConnectedPanel() {
        LayoutEditor result = null;
        if (this.block != null && this.panels.size() > 0) {
            int maxConnectivity = Integer.MIN_VALUE;
            for (LayoutEditor panel : this.panels) {
                List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
                if (maxConnectivity >= c.size()) continue;
                maxConnectivity = c.size();
                result = panel;
            }
        }
        return result;
    }

    public void updatePaths() {
        if (this.block != null && !this.panels.isEmpty()) {
            LayoutEditor panel = this.panels.get(0);
            List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
            if (this.panels.size() > 1) {
                int i = 1;
                while (i < this.panels.size()) {
                    if (c.size() < this.panels.get(i).getLEAuxTools().getConnectivityList(this).size()) {
                        panel = this.panels.get(i);
                        c = panel.getLEAuxTools().getConnectivityList(this);
                    }
                    ++i;
                }
                PositionablePoint point = panel.getFinder().findPositionableLinkPoint(this);
                if (point != null && point.getLinkedEditor() != null && this.panels.contains(point.getLinkedEditor())) {
                    c = panel.getLEAuxTools().getConnectivityList(this);
                    c.addAll(point.getLinkedEditor().getLEAuxTools().getConnectivityList(this));
                } else {
                    for (LayoutEditor tPanel : this.panels) {
                        int response;
                        if (tPanel == panel || !InstanceManager.getDefault(LayoutBlockManager.class).warn() || this.compareConnectivity(c, tPanel.getLEAuxTools().getConnectivityList(this)) || (response = JOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("Warn1"), this.getUserName(), tPanel.getLayoutName(), panel.getLayoutName()), Bundle.getMessage("WarningTitle"), 0, 3, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonOKPlus")}, Bundle.getMessage("ButtonOK"))) == 0) continue;
                        InstanceManager.getDefault(LayoutBlockManager.class).turnOffWarning();
                    }
                }
            }
            this.updateBlockPaths(c, panel);
        }
    }

    public void updatePathsUsingPanel(LayoutEditor panel) {
        if (panel == null) {
            log.error("Null panel in call to updatePathsUsingPanel");
            return;
        }
        List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
        this.updateBlockPaths(c, panel);
    }

    private void updateBlockPaths(List<LayoutConnectivity> c, LayoutEditor panel) {
        Path p2;
        this.auxTools = panel.getLEAuxTools();
        List<Path> paths = this.block.getPaths();
        boolean[] used = new boolean[c.size()];
        int[] need = new int[paths.size()];
        Arrays.fill(used, false);
        Arrays.fill(need, -1);
        int i = 0;
        while (i < paths.size()) {
            p2 = paths.get(i);
            int j = 0;
            while (j < c.size() && need[i] == -1) {
                LayoutConnectivity lc;
                if (!(used[j] || (lc = c.get(j)).getBlock1().getBlock() != p2.getBlock() && lc.getBlock2().getBlock() != p2.getBlock())) {
                    used[j] = true;
                    need[i] = j;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < paths.size()) {
            if (need[i] >= 0) {
                p2 = paths.get(i);
                LayoutConnectivity lc = c.get(need[i]);
                if (lc.getBlock1() == this) {
                    p2.setToBlockDirection(lc.getDirection());
                    p2.setFromBlockDirection(lc.getReverseDirection());
                } else {
                    p2.setToBlockDirection(lc.getReverseDirection());
                    p2.setFromBlockDirection(lc.getDirection());
                }
                ArrayList<BeanSetting> beans = new ArrayList<BeanSetting>(p2.getSettings());
                for (BeanSetting bean : beans) {
                    p2.removeSetting(bean);
                }
                this.auxTools.addBeanSettings(p2, lc, this);
            }
            ++i;
        }
        i = 0;
        while (i < paths.size()) {
            if (need[i] < 0) {
                this.block.removePath(paths.get(i));
                if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                    this.removeAdjacency(paths.get(i));
                }
            }
            ++i;
        }
        int j = 0;
        while (j < c.size()) {
            if (!used[j]) {
                LayoutConnectivity lc = c.get(j);
                Path newp = lc.getBlock1() == this ? new Path(lc.getBlock2().getBlock(), lc.getDirection(), lc.getReverseDirection()) : new Path(lc.getBlock1().getBlock(), lc.getReverseDirection(), lc.getDirection());
                this.block.addPath(newp);
                if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                    this.addAdjacency(newp);
                }
                this.auxTools.addBeanSettings(newp, lc, this);
            }
            ++j;
        }
        if (log.isDebugEnabled()) {
            this.block.getPaths().stream().forEach(p -> log.debug("From {} to {}", (Object)this.getDisplayName(), (Object)p.toString()));
        }
    }

    private boolean compareConnectivity(List<LayoutConnectivity> main, List<LayoutConnectivity> test) {
        boolean result = false;
        if (!main.isEmpty() && !test.isEmpty()) {
            result = true;
            for (LayoutConnectivity tc : test) {
                LayoutBlock tlb1 = tc.getBlock1();
                LayoutBlock tlb2 = tc.getBlock2();
                boolean found = false;
                for (LayoutConnectivity mc : main) {
                    LayoutBlock mlb1 = mc.getBlock1();
                    LayoutBlock mlb2 = mc.getBlock2();
                    if ((tlb1 != mlb1 || tlb2 != mlb2) && (tlb1 != mlb2 || tlb2 != mlb1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result = false;
                break;
            }
        } else if (main.isEmpty() && test.isEmpty()) {
            result = true;
        }
        return result;
    }

    void handleBlockChange(PropertyChangeEvent e) {
        Memory m = this.getMemory();
        if (m != null && this.block != null && !this.suppressNameUpdate) {
            Object val = this.block.getValue();
            if (val != null && !(val instanceof RosterEntry) && !(val instanceof Reportable)) {
                val = val.toString();
            }
            m.setValue(val);
        }
        if (e.getPropertyName().equals("UserName")) {
            this.setUserName(e.getNewValue().toString());
            InstanceManager.getDefault(NamedBeanHandleManager.class).renameBean(e.getOldValue().toString(), e.getNewValue().toString(), this);
        }
        this.redrawLayoutBlockPanels();
        if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            this.stateUpdate();
        }
    }

    private void deactivateBlock() {
        if (this.mBlockListener != null && this.block != null) {
            this.block.removePropertyChangeListener(this.mBlockListener);
        }
        this.mBlockListener = null;
    }

    public void setSuppressNameUpdate(boolean set) {
        this.suppressNameUpdate = set;
    }

    public void editLayoutBlock(Component callingPane) {
        LayoutBlockEditAction beanEdit = new LayoutBlockEditAction();
        if (this.block == null) {
            Block b;
            String userName = this.getUserName();
            if (userName != null && !userName.isEmpty() && (b = InstanceManager.getDefault(BlockManager.class).getBlock(userName)) != null) {
                beanEdit.setBean(b);
            }
        } else {
            beanEdit.setBean(this.block);
        }
        beanEdit.actionPerformed(null);
    }

    void blockEditDonePressed(ActionEvent a) {
        int m;
        Sensor s;
        boolean needsRedraw = false;
        String newName = NamedBean.normalizeUserName(this.sensorNameField.getText());
        if (!this.getOccupancySensorName().equals(newName)) {
            if (newName == null || newName.isEmpty()) {
                this.setOccupancySensorName(newName);
                this.sensorNameField.setText("");
                needsRedraw = true;
            } else {
                if (this.validateSensor(newName, this.editLayoutBlockFrame) == null) {
                    this.occupancyNamedSensor = null;
                    this.occupancySensorName = "";
                    this.sensorNameField.setText("");
                    return;
                }
                this.sensorNameField.setText(newName);
                needsRedraw = true;
            }
        }
        if ((s = this.getOccupancySensor()) != null) {
            String msg;
            if (this.sensorDebounceGlobalCheck.isSelected()) {
                s.setUseDefaultTimerSettings(true);
            } else {
                s.setUseDefaultTimerSettings(false);
                if (!this.sensorDebounceInactiveField.getText().trim().isEmpty()) {
                    s.setSensorDebounceGoingInActiveTimer(Long.parseLong(this.sensorDebounceInactiveField.getText().trim()));
                }
                if (!this.sensorDebounceActiveField.getText().trim().isEmpty()) {
                    s.setSensorDebounceGoingActiveTimer(Long.parseLong(this.sensorDebounceActiveField.getText().trim()));
                }
            }
            Reporter reporter = s.getReporter();
            if (reporter != null && this.block != null && JOptionPane.showConfirmDialog(this.editLayoutBlockFrame, msg = MessageFormat.format(Bundle.getMessage("BlockAssignReporter"), s.getDisplayName(), reporter.getDisplayName()), Bundle.getMessage("BlockAssignReporterTitle"), 0) == 0) {
                this.block.setReporter(reporter);
            }
        }
        int k = this.senseBox.getSelectedIndex();
        int oldSense = this.occupiedSense;
        this.occupiedSense = k == this.senseActiveIndex ? 2 : 4;
        if (oldSense != this.occupiedSense) {
            needsRedraw = true;
        }
        Color oldColor = this.blockTrackColor;
        this.blockTrackColor = this.trackColorChooser.getColor();
        if (oldColor != this.blockTrackColor) {
            needsRedraw = true;
        }
        oldColor = this.blockOccupiedColor;
        this.blockOccupiedColor = this.occupiedColorChooser.getColor();
        if (oldColor != this.blockOccupiedColor) {
            needsRedraw = true;
        }
        oldColor = this.blockExtraColor;
        this.blockExtraColor = this.extraColorChooser.getColor();
        if (oldColor != this.blockExtraColor) {
            needsRedraw = true;
        }
        if ((newName = this.memoryComboBox.getSelectedItemDisplayName()) == null) {
            newName = "";
        }
        if (!this.memoryName.equals(newName)) {
            this.setMemory(this.validateMemory(newName, this.editLayoutBlockFrame), newName);
            if (this.getMemory() == null) {
                this.memoryName = "";
                this.memoryComboBox.setSelectedItem(null);
                return;
            }
            this.memoryComboBox.setSelectedItem(this.getMemory());
            needsRedraw = true;
        }
        if ((m = Integer.parseInt(this.metricField.getText().trim())) != this.metric) {
            this.setBlockMetric(m);
        }
        if (this.neighbourDir != null) {
            int i = 0;
            while (i < this.neighbourDir.size()) {
                int neigh = this.neighbourDir.get(i).getSelectedIndex();
                this.neighbours.get(i).getBlock().removeBlockDenyList(this.block);
                this.block.removeBlockDenyList(this.neighbours.get(i).getBlock());
                switch (neigh) {
                    case 0: {
                        this.updateNeighbourPacketFlow(this.neighbours.get(i), 0);
                        break;
                    }
                    case 1: {
                        this.neighbours.get(i).getBlock().addBlockDenyList(this.block.getDisplayName());
                        this.updateNeighbourPacketFlow(this.neighbours.get(i), 4);
                        break;
                    }
                    case 2: {
                        this.block.addBlockDenyList(this.neighbours.get(i).getBlock().getDisplayName());
                        this.updateNeighbourPacketFlow(this.neighbours.get(i), 2);
                        break;
                    }
                }
                ++i;
            }
        }
        this.editLayoutBlockFrame.setVisible(false);
        this.editLayoutBlockFrame.dispose();
        this.editLayoutBlockFrame = null;
        if (needsRedraw) {
            this.redrawLayoutBlockPanels();
        }
    }

    void blockEditCancelPressed(ActionEvent a) {
        this.editLayoutBlockFrame.setVisible(false);
        this.editLayoutBlockFrame.dispose();
        this.editLayoutBlockFrame = null;
    }

    void remove() {
        this.deactivateBlock();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    void setBlockMetric() {
        if (!this.defaultMetric) {
            return;
        }
        LayoutEditor panel = this.getMaxConnectedPanel();
        if (panel == null) {
            return;
        }
        String userName = this.getUserName();
        if (userName == null) {
            log.info("From '{}': unable to get user name", (Object)this.getDisplayName());
            return;
        }
        ArrayList<TrackSegment> ts = panel.getFinder().findTrackSegmentByBlock(userName);
        int mainline = 0;
        int side = 0;
        for (TrackSegment t : ts) {
            if (t.isMainline()) {
                ++mainline;
                continue;
            }
            ++side;
        }
        this.metric = mainline > side ? 50 : (mainline < side ? 200 : 50);
        RoutingPacket update = new RoutingPacket(2, this.getBlock(), -1, this.metric, -1.0f, -1, this.getNextPacketID());
        this.firePropertyChange("routing", null, update);
    }

    public boolean useDefaultMetric() {
        return this.defaultMetric;
    }

    public void useDefaultMetric(boolean boo) {
        if (boo == this.defaultMetric) {
            return;
        }
        this.defaultMetric = boo;
        if (boo) {
            this.setBlockMetric();
        }
    }

    public void setBlockMetric(int m) {
        if (this.metric == m) {
            return;
        }
        this.metric = m;
        this.defaultMetric = false;
        RoutingPacket update = new RoutingPacket(2, this.getBlock(), -1, this.metric, -1.0f, -1, this.getNextPacketID());
        this.firePropertyChange("routing", null, update);
    }

    public int getBlockMetric() {
        return this.metric;
    }

    public void addAllThroughPaths() {
        if (this.block != null && this.panels.size() > 0) {
            LayoutEditor panel = this.panels.get(0);
            List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
            if (this.panels.size() > 1) {
                int i = 1;
                while (i < this.panels.size()) {
                    if (c.size() < this.panels.get(i).getLEAuxTools().getConnectivityList(this).size()) {
                        panel = this.panels.get(i);
                        c = panel.getLEAuxTools().getConnectivityList(this);
                    }
                    ++i;
                }
                for (LayoutEditor tPanel : this.panels) {
                    int response;
                    if (tPanel == panel || !InstanceManager.getDefault(LayoutBlockManager.class).warn() || this.compareConnectivity(c, tPanel.getLEAuxTools().getConnectivityList(this)) || (response = JOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("Warn1"), this.getUserName(), tPanel.getLayoutName(), panel.getLayoutName()), Bundle.getMessage("WarningTitle"), 0, 3, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonOKPlus")}, Bundle.getMessage("ButtonOK"))) == 0) continue;
                    InstanceManager.getDefault(LayoutBlockManager.class).turnOffWarning();
                }
            }
            this.auxTools = panel.getLEAuxTools();
            List<LayoutConnectivity> d = this.auxTools.getConnectivityList(this);
            ArrayList<LayoutBlock> attachedBlocks = new ArrayList<LayoutBlock>();
            for (LayoutConnectivity connectivity : d) {
                if (connectivity.getBlock1() != this) {
                    attachedBlocks.add(connectivity.getBlock1());
                    continue;
                }
                attachedBlocks.add(connectivity.getBlock2());
            }
            for (LayoutBlock attachedBlock : attachedBlocks) {
                for (LayoutBlock layoutBlock : attachedBlocks) {
                    this.addThroughPath(attachedBlock.getBlock(), layoutBlock.getBlock(), panel);
                }
            }
        }
    }

    private void addNeighbour(Block addBlock, int direction, int workingDirection) {
        boolean layoutConnectivityBefore = this.layoutConnectivity;
        if (this.getAdjacency(addBlock) != null) {
            this.addThroughPath(this.getAdjacency(addBlock));
        } else {
            Adjacencies adj = new Adjacencies(addBlock, direction, workingDirection);
            this.neighbours.add(adj);
            LayoutBlock blk = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(addBlock);
            LayoutEditor editor = this.getMaxConnectedPanel();
            if (editor != null && this.connection == null) {
                this.connection = editor.getConnectivityUtil();
            }
            Routes route = null;
            if (workingDirection == 0 || workingDirection == 2) {
                route = blk != null ? new Routes(addBlock, this.getBlock(), 1, direction, blk.getBlockMetric(), addBlock.getLengthMm()) : new Routes(addBlock, this.getBlock(), 1, direction, 0, 0.0f);
                this.routes.add(route);
            }
            if (blk != null) {
                boolean mutual = blk.informNeighbourOfAttachment(this, this.getBlock(), workingDirection);
                if (workingDirection == 0 || workingDirection == 2) {
                    blk.addPropertyChangeListener(this);
                } else {
                    blk.removePropertyChangeListener(this);
                }
                int neighwork = blk.getAdjacencyPacketFlow(this.getBlock());
                if (neighwork != -1) {
                    int newPacketFlow = this.determineAdjPacketFlow(workingDirection, neighwork);
                    adj.setPacketFlow(newPacketFlow);
                    if (newPacketFlow == 4) {
                        int j = this.routes.size() - 1;
                        while (j > -1) {
                            Routes ro = this.routes.get(j);
                            if (ro.getDestBlock() == addBlock && ro.getNextBlock() == this.getBlock()) {
                                adj.removeRouteAdvertisedToNeighbour(ro);
                                this.routes.remove(j);
                            }
                            --j;
                        }
                        RoutingPacket newUpdate = new RoutingPacket(4, addBlock, -1, -1, -1.0f, -1, this.getNextPacketID());
                        this.neighbours.forEach(adja -> adja.removeRouteAdvertisedToNeighbour(addBlock));
                        this.firePropertyChange("routing", null, newUpdate);
                    }
                } else {
                    return;
                }
                adj.setMutual(mutual);
                if (route != null) {
                    route.stateChange();
                }
                this.addThroughPath(this.getAdjacency(addBlock));
                if ((workingDirection == 0 || workingDirection == 4) && mutual) {
                    blk.informNeighbourOfValidRoutes(this.getBlock());
                }
            }
        }
        if (!layoutConnectivityBefore) {
            for (Adjacencies neighbour : this.neighbours) {
                this.addThroughPath(neighbour);
            }
        }
    }

    private boolean informNeighbourOfAttachment(LayoutBlock lBlock, Block block, int workingDirection) {
        Adjacencies adj = this.getAdjacency(block);
        if (adj == null) {
            return false;
        }
        if (!adj.isMutual()) {
            int newPacketFlow = this.determineAdjPacketFlow(adj.getPacketFlow(), workingDirection);
            adj.setPacketFlow(newPacketFlow);
            if (newPacketFlow != 4) {
                Routes r;
                RoutingPacket update;
                Routes neighRoute = this.getValidRoute(this.getBlock(), adj.getBlock());
                if (neighRoute == null) {
                    log.info("Null route so will bomb out");
                    return false;
                }
                if (neighRoute.getMetric() != adj.getMetric()) {
                    neighRoute.setMetric(adj.getMetric());
                    update = new RoutingPacket(2, adj.getBlock(), -1, adj.getMetric() + this.metric, -1.0f, -1, this.getNextPacketID());
                    this.firePropertyChange("routing", null, update);
                }
                if (neighRoute.getMetric() != (int)adj.getLength()) {
                    neighRoute.setLength(adj.getLength());
                    update = new RoutingPacket(2, adj.getBlock(), -1, -1, adj.getLength() + block.getLengthMm(), -1, this.getNextPacketID());
                    this.firePropertyChange("routing", null, update);
                }
                if ((r = this.getRouteByDestBlock(block)) != null) {
                    r.setMetric(lBlock.getBlockMetric());
                } else {
                    log.warn("No getRouteByDestBlock('{}')", (Object)block.getDisplayName());
                }
            }
            if (newPacketFlow == 0 || newPacketFlow == 2) {
                lBlock.addPropertyChangeListener(this);
            } else {
                lBlock.removePropertyChangeListener(this);
            }
            if (newPacketFlow == 4) {
                int j = this.routes.size() - 1;
                while (j > -1) {
                    Routes ro = this.routes.get(j);
                    if (ro.getDestBlock() == block && ro.getNextBlock() == this.getBlock()) {
                        adj.removeRouteAdvertisedToNeighbour(ro);
                        this.routes.remove(j);
                    }
                    --j;
                }
                j = this.throughPaths.size() - 1;
                while (j > -1) {
                    if (this.throughPaths.get(j).getDestinationBlock() == block) {
                        this.throughPaths.remove(j);
                    }
                    --j;
                }
                RoutingPacket newUpdate = new RoutingPacket(4, block, -1, -1, -1.0f, -1, this.getNextPacketID());
                this.neighbours.forEach(adja -> adja.removeRouteAdvertisedToNeighbour(block));
                this.firePropertyChange("routing", null, newUpdate);
            }
            adj.setMutual(true);
            this.addThroughPath(adj);
            if (newPacketFlow == 0 || newPacketFlow == 4) {
                this.informNeighbourOfValidRoutes(block);
            }
        }
        return true;
    }

    private int determineAdjPacketFlow(int our, int neigh) {
        if (our == 0 && neigh == 0) {
            return 0;
        }
        if (neigh == 2) {
            neigh = 4;
        } else if (neigh == 4) {
            neigh = 2;
        }
        if (our == neigh) {
            return our;
        }
        return 8;
    }

    private void informNeighbourOfValidRoutes(Block newblock) {
        ArrayList<Block> validFromPath = new ArrayList<Block>();
        for (ThroughPaths tp : this.throughPaths) {
            if (tp.getSourceBlock() == newblock) {
                validFromPath.add(tp.getDestinationBlock());
                continue;
            }
            if (tp.getDestinationBlock() != newblock) continue;
            validFromPath.add(tp.getSourceBlock());
        }
        LayoutBlock lBnewblock = null;
        Adjacencies adj = this.getAdjacency(newblock);
        if (adj.isMutual()) {
            lBnewblock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(newblock);
        }
        if (lBnewblock == null) {
            return;
        }
        for (Routes ro : new ArrayList<Routes>(this.routes)) {
            RoutingPacket update;
            if (ro.getNextBlock() == this.getBlock()) {
                if (!validFromPath.contains(ro.getDestBlock())) continue;
                update = new RoutingPacket(0, ro.getDestBlock(), ro.getHopCount() + 1, ro.getMetric() + this.metric, ro.getLength() + this.block.getLengthMm(), -1, this.getNextPacketID());
                lBnewblock.addRouteFromNeighbour(this, update);
                continue;
            }
            if (!validFromPath.contains(ro.getNextBlock()) || !adj.advertiseRouteToNeighbour(ro)) continue;
            adj.addRouteAdvertisedToNeighbour(ro);
            update = new RoutingPacket(0, ro.getDestBlock(), ro.getHopCount() + 1, ro.getMetric() + this.metric, ro.getLength() + this.block.getLengthMm(), -1, this.getNextPacketID());
            lBnewblock.addRouteFromNeighbour(this, update);
        }
    }

    private void addAdjacency(Path addPath) {
        Block destBlockToAdd = addPath.getBlock();
        int ourWorkingDirection = 0;
        if (destBlockToAdd == null) {
            log.error("Found null destination block for path from {}", (Object)this.getDisplayName());
            return;
        }
        if (this.getBlock().isBlockDenied(destBlockToAdd.getDisplayName())) {
            ourWorkingDirection = 2;
        } else if (destBlockToAdd.isBlockDenied(this.getBlock().getDisplayName())) {
            ourWorkingDirection = 4;
        }
        this.addNeighbour(addPath.getBlock(), addPath.getToBlockDirection(), ourWorkingDirection);
    }

    private void removeAdjacency(Path removedPath) {
        Block ablock = removedPath.getBlock();
        if (ablock != null) {
            LayoutBlock layoutBlock;
            if (this.enableDeleteRouteLogging) {
                log.info("From {} Adjacency to be removed {} {}", new Object[]{this.getDisplayName(), ablock.getDisplayName(), Path.decodeDirection(removedPath.getToBlockDirection())});
            }
            if ((layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(ablock)) != null) {
                this.removeAdjacency(layoutBlock);
            }
        } else {
            log.debug("removeAdjacency() removedPath.getBlock() is null");
        }
    }

    private void removeAdjacency(LayoutBlock layoutBlock) {
        if (this.enableDeleteRouteLogging) {
            log.info("From {} Adjacency to be removed {}", (Object)this.getDisplayName(), (Object)layoutBlock.getDisplayName());
        }
        Block removedBlock = layoutBlock.getBlock();
        List<Routes> tmpBlock = this.removeRouteReceivedFromNeighbour(removedBlock);
        int i = this.neighbours.size() - 1;
        while (i > -1) {
            if (this.neighbours.get(i).getBlock() == removedBlock) {
                LayoutBlock layoutBlockToNotify;
                layoutBlock.removePropertyChangeListener(this);
                if (this.enableDeleteRouteLogging) {
                    log.info("From {} block {} found and removed", (Object)this.getDisplayName(), (Object)removedBlock.getDisplayName());
                }
                if ((layoutBlockToNotify = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.neighbours.get(i).getBlock())) == null) {
                    log.error("Unable to notify neighbours for block {}", (Object)this.neighbours.get(i).getBlock());
                } else {
                    this.getAdjacency(this.neighbours.get(i).getBlock()).dispose();
                    this.neighbours.remove(i);
                    layoutBlockToNotify.notifiedNeighbourNoLongerMutual(this);
                }
            }
            --i;
        }
        i = this.throughPaths.size() - 1;
        while (i > -1) {
            if (this.throughPaths.get(i).getSourceBlock() == removedBlock) {
                if (this.getAdjacency(this.throughPaths.get(i).getSourceBlock()) == null) {
                    if (this.enableDeleteRouteLogging) {
                        log.info("remove {} to {}", (Object)this.throughPaths.get(i).getSourceBlock().getDisplayName(), (Object)this.throughPaths.get(i).getDestinationBlock().getDisplayName());
                    }
                    this.throughPaths.remove(i);
                }
            } else if (this.throughPaths.get(i).getDestinationBlock() == removedBlock && this.getAdjacency(this.throughPaths.get(i).getDestinationBlock()) == null) {
                if (this.enableDeleteRouteLogging) {
                    log.info("remove {} to {}", (Object)this.throughPaths.get(i).getSourceBlock().getDisplayName(), (Object)this.throughPaths.get(i).getDestinationBlock().getDisplayName());
                }
                this.throughPaths.remove(i);
            }
            --i;
        }
        if (this.enableDeleteRouteLogging) {
            log.info("From {} neighbour has been removed - Number of routes to this neighbour removed{}", (Object)this.getDisplayName(), (Object)tmpBlock.size());
        }
        this.notifyNeighboursOfRemoval(tmpBlock, removedBlock);
    }

    private void removeRouteFromNeighbour(LayoutBlock src, RoutingPacket update) {
        InstanceManager.getDefault(LayoutBlockManager.class).setLastRoutingChange();
        Block srcblk = src.getBlock();
        Block destblk = update.getBlock();
        String msgPrefix = "From " + this.getDisplayName() + " notify block " + srcblk.getDisplayName() + " ";
        if (this.enableDeleteRouteLogging) {
            log.info("{} remove route from neighbour called", (Object)msgPrefix);
        }
        if (InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(srcblk) == this) {
            if (this.enableDeleteRouteLogging) {
                log.info("From {} source block is the same as our block! {}", (Object)this.getDisplayName(), (Object)destblk.getDisplayName());
            }
            return;
        }
        if (this.enableDeleteRouteLogging) {
            log.info("{} (Direct Notification) neighbour {} has removed route to {}", new Object[]{msgPrefix, srcblk.getDisplayName(), destblk.getDisplayName()});
            log.info("{} routes in table {} Remove route from neighbour", (Object)msgPrefix, (Object)this.routes.size());
        }
        ArrayList<Routes> routesToRemove = new ArrayList<Routes>();
        int i = this.routes.size() - 1;
        while (i > -1) {
            Routes ro = this.routes.get(i);
            if (ro.getNextBlock() == srcblk && ro.getDestBlock() == destblk) {
                routesToRemove.add(new Routes(this.routes.get(i).getDestBlock(), this.routes.get(i).getNextBlock(), 0, 0, 0, 0.0f));
                if (this.enableDeleteRouteLogging) {
                    log.info("{} route to {} from block {} to be removed triggered by propertyChange", new Object[]{msgPrefix, ro.getDestBlock().getDisplayName(), ro.getNextBlock().getDisplayName()});
                }
                this.routes.remove(i);
            }
            --i;
        }
        this.notifyNeighboursOfRemoval(routesToRemove, srcblk);
    }

    private List<Routes> removeRouteReceivedFromNeighbour(Block removedBlock) {
        ArrayList<Routes> tmpBlock = new ArrayList<Routes>();
        int j = this.routes.size() - 1;
        while (j > -1) {
            Routes ro = this.routes.get(j);
            if (this.enableDeleteRouteLogging) {
                log.info("From {} route to check {} from Block {}", new Object[]{this.getDisplayName(), this.routes.get(j).getDestBlock().getDisplayName(), this.routes.get(j).getNextBlock().getDisplayName()});
            }
            if (ro.getDestBlock() == removedBlock) {
                if (this.enableDeleteRouteLogging) {
                    log.info("From {} route to {} from block {} to be removed triggered by adjancey removal as dest block has been removed", new Object[]{this.getDisplayName(), this.routes.get(j).getDestBlock().getDisplayName(), this.routes.get(j).getNextBlock().getDisplayName()});
                }
                if (!tmpBlock.contains(ro)) {
                    tmpBlock.add(ro);
                }
                this.routes.remove(j);
            } else if (ro.getNextBlock() == removedBlock) {
                if (this.enableDeleteRouteLogging) {
                    log.info("From {} route to {} from block {} to be removed triggered by adjancey removal", new Object[]{this.getDisplayName(), this.routes.get(j).getDestBlock().getDisplayName(), this.routes.get(j).getNextBlock().getDisplayName()});
                }
                if (!tmpBlock.contains(ro)) {
                    tmpBlock.add(ro);
                }
                this.routes.remove(j);
            }
            --j;
        }
        return tmpBlock;
    }

    private void updateNeighbourPacketFlow(Block neighbour, int flow) {
        Adjacencies neighAdj = this.getAdjacency(neighbour);
        if (flow == 2) {
            flow = 4;
        } else if (flow == 4) {
            flow = 2;
        }
        if (neighAdj.getPacketFlow() == flow) {
            return;
        }
        this.updateNeighbourPacketFlow(neighAdj, flow);
    }

    protected void updateNeighbourPacketFlow(Adjacencies neighbour, int flow) {
        if (neighbour.getPacketFlow() == flow) {
            return;
        }
        LayoutBlock neighLBlock = neighbour.getLayoutBlock();
        Runnable r = () -> neighLBlock.updateNeighbourPacketFlow(this.block, flow);
        Block neighBlock = neighbour.getBlock();
        int oldPacketFlow = neighbour.getPacketFlow();
        neighbour.setPacketFlow(flow);
        SwingUtilities.invokeLater(r);
        if (flow == 4) {
            neighBlock.addBlockDenyList(this.block);
            neighLBlock.removePropertyChangeListener(this);
            List<Routes> tmpBlock = this.removeRouteReceivedFromNeighbour(neighBlock);
            this.notifyNeighboursOfRemoval(tmpBlock, neighBlock);
            int i = this.throughPaths.size() - 1;
            while (i > -1) {
                if (this.throughPaths.get(i).getDestinationBlock() == neighBlock) {
                    this.throughPaths.remove(i);
                    this.firePropertyChange("through-path-removed", null, null);
                }
                --i;
            }
            if (oldPacketFlow == 2) {
                this.addThroughPath(neighbour);
            }
        } else if (flow == 2) {
            neighLBlock.addPropertyChangeListener(this);
            neighBlock.removeBlockDenyList(this.block);
            this.block.addBlockDenyList(neighBlock);
            int i = this.throughPaths.size() - 1;
            while (i > -1) {
                if (this.throughPaths.get(i).getSourceBlock() == neighBlock) {
                    this.throughPaths.remove(i);
                    this.firePropertyChange("through-path-removed", null, null);
                }
                --i;
            }
            if (oldPacketFlow == 4) {
                this.routes.add(new Routes(neighBlock, this.getBlock(), 1, neighbour.getDirection(), neighLBlock.getBlockMetric(), neighBlock.getLengthMm()));
                this.addThroughPath(neighbour);
            }
        } else if (flow == 0) {
            neighBlock.removeBlockDenyList(this.block);
            this.block.removeBlockDenyList(neighBlock);
            neighLBlock.addPropertyChangeListener(this);
            if (oldPacketFlow == 4) {
                this.routes.add(new Routes(neighBlock, this.getBlock(), 1, neighbour.getDirection(), neighLBlock.getBlockMetric(), neighBlock.getLengthMm()));
            }
            this.addThroughPath(neighbour);
        }
    }

    private void notifyNeighboursOfRemoval(List<Routes> routesToRemove, Block notifyingblk) {
        String msgPrefix = "From " + this.getDisplayName() + " notify block " + notifyingblk.getDisplayName() + " ";
        if (this.enableDeleteRouteLogging) {
            log.info("{} notifyNeighboursOfRemoval called for routes from {} ===", (Object)msgPrefix, (Object)notifyingblk.getDisplayName());
        }
        boolean notifyvalid = false;
        int i = this.neighbours.size() - 1;
        while (i > -1) {
            if (this.neighbours.get(i).getBlock() == notifyingblk) {
                notifyvalid = true;
            }
            --i;
        }
        if (this.enableDeleteRouteLogging) {
            log.info("{} The notifying block is still valid? {}", (Object)msgPrefix, (Object)notifyvalid);
        }
        int j = routesToRemove.size() - 1;
        while (j > -1) {
            boolean stillexist = false;
            Block destBlock = routesToRemove.get(j).getDestBlock();
            Block sourceBlock = routesToRemove.get(j).getNextBlock();
            RoutingPacket newUpdate = new RoutingPacket(4, destBlock, -1, -1, -1.0f, -1, this.getNextPacketID());
            if (this.enableDeleteRouteLogging) {
                log.info("From {} notify block {} checking {} from {}", new Object[]{this.getDisplayName(), notifyingblk.getDisplayName(), destBlock.getDisplayName(), sourceBlock.getDisplayName()});
            }
            ArrayList<Routes> validroute = new ArrayList<Routes>();
            List<Routes> destRoutes = this.getDestRoutes(destBlock);
            for (Routes r : destRoutes) {
                if (r.getNextBlock() == this.getBlock()) {
                    if (this.enableDeleteRouteLogging) {
                        log.info("{} The destBlock {} is our neighbour", (Object)msgPrefix, (Object)destBlock.getDisplayName());
                    }
                    validroute.add(new Routes(r.getDestBlock(), r.getNextBlock(), 0, 0, 0, 0.0f));
                    stillexist = true;
                    continue;
                }
                if (this.enableDeleteRouteLogging) {
                    log.info("{} we still have a route to {} via {} in our list", new Object[]{msgPrefix, destBlock.getDisplayName(), r.getNextBlock().getDisplayName()});
                }
                validroute.add(new Routes(destBlock, r.getNextBlock(), 0, 0, 0, 0.0f));
                stillexist = true;
            }
            if (stillexist) {
                if (this.enableDeleteRouteLogging) {
                    log.info("{}A Route still exists", (Object)msgPrefix);
                    log.info("{} the number of routes installed to block {} is {}", new Object[]{msgPrefix, destBlock.getDisplayName(), validroute.size()});
                }
                if (validroute.size() == 1) {
                    Object layoutBlock;
                    Block nextHop = ((Routes)validroute.get(0)).getNextBlock();
                    if (((Routes)validroute.get(0)).getNextBlock() != this.getBlock()) {
                        layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(nextHop);
                        if (this.enableDeleteRouteLogging) {
                            log.info("{} We only have a single valid route left to {} So will tell {} we no longer have it", new Object[]{msgPrefix, destBlock.getDisplayName(), ((AbstractNamedBean)layoutBlock).getDisplayName()});
                        }
                        if (layoutBlock != null) {
                            super.removeRouteFromNeighbour(this, newUpdate);
                        }
                        this.getAdjacency(nextHop).removeRouteAdvertisedToNeighbour(routesToRemove.get(j));
                    }
                    ArrayList<Block> validNeighboursToNotify = new ArrayList<Block>();
                    int i2 = this.neighbours.size() - 1;
                    while (i2 > -1) {
                        if (this.neighbours.get(i2).getBlock() != destBlock && this.neighbours.get(i2).getBlock() != nextHop && this.validThroughPath(notifyingblk, this.neighbours.get(i2).getBlock())) {
                            Block neighblock = this.neighbours.get(i2).getBlock();
                            if (this.enableDeleteRouteLogging) {
                                log.info("{} we could of potentially sent the route to {}", (Object)msgPrefix, (Object)neighblock.getDisplayName());
                            }
                            if (!this.validThroughPath(nextHop, neighblock)) {
                                if (this.enableDeleteRouteLogging) {
                                    log.info("{} there is no other valid path so will mark for removal", (Object)msgPrefix);
                                }
                                validNeighboursToNotify.add(neighblock);
                            } else if (this.enableDeleteRouteLogging) {
                                log.info("{} there is another valid path so will NOT mark for removal", (Object)msgPrefix);
                            }
                        }
                        --i2;
                    }
                    if (this.enableDeleteRouteLogging) {
                        log.info("{} the next block is our selves so we won't remove!", (Object)msgPrefix);
                        log.info("{} do we need to find out if we could of send the route to another neighbour such as?", (Object)msgPrefix);
                    }
                    for (Block value : validNeighboursToNotify) {
                        if (!this.validThroughPath(value, destBlock)) {
                            layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(value);
                            if (layoutBlock != null) {
                                super.removeRouteFromNeighbour(this, newUpdate);
                            }
                            this.getAdjacency(value).removeRouteAdvertisedToNeighbour(routesToRemove.get(j));
                            continue;
                        }
                        if (!this.enableDeleteRouteLogging) continue;
                        log.info("{}{} has a valid path to {}", new Object[]{msgPrefix, value.getDisplayName(), destBlock.getDisplayName()});
                    }
                } else {
                    if (this.enableDeleteRouteLogging) {
                        log.info("{} routes left to block {}", (Object)msgPrefix, (Object)destBlock.getDisplayName());
                    }
                    for (Routes item : validroute) {
                        if (this.validThroughPath(notifyingblk, item.getNextBlock())) {
                            if (this.enableDeleteRouteLogging) {
                                log.info("{} to {} Is a valid route", (Object)msgPrefix, (Object)item.getNextBlock().getDisplayName());
                            }
                            item.setMiscFlags(2);
                            continue;
                        }
                        if (this.enableDeleteRouteLogging) {
                            log.info("{} to {} Is not a valid route", (Object)msgPrefix, (Object)item.getNextBlock().getDisplayName());
                        }
                        item.setMiscFlags(1);
                    }
                    int i3 = 0;
                    while (i3 < validroute.size()) {
                        if (((Routes)validroute.get(i3)).getMiscFlags() == 2) {
                            Block nextblk = ((Routes)validroute.get(i3)).getNextBlock();
                            if (this.enableDeleteRouteLogging) {
                                log.info("{} route from {} has been flagged for removal", (Object)msgPrefix, (Object)nextblk.getDisplayName());
                            }
                            boolean leaveroute = false;
                            for (Routes value : validroute) {
                                if (value.getMiscFlags() != 1 || !this.validThroughPath(nextblk, value.getNextBlock())) continue;
                                if (this.enableDeleteRouteLogging) {
                                    log.info("{} we have a valid path from {} to {}", new Object[]{msgPrefix, nextblk.getDisplayName(), value.getNextBlock()});
                                }
                                leaveroute = true;
                            }
                            if (!leaveroute) {
                                LayoutBlock layoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(nextblk);
                                if (this.enableDeleteRouteLogging) {
                                    log.info("{}############ We need to send notification to {} to remove route ########### haven't found an example of this yet!", (Object)msgPrefix, (Object)nextblk.getDisplayName());
                                }
                                if (layoutBlock == null) {
                                    log.error("Unable to fetch block {}", (Object)nextblk);
                                } else {
                                    layoutBlock.removeRouteFromNeighbour(this, newUpdate);
                                    this.getAdjacency(nextblk).removeRouteAdvertisedToNeighbour(routesToRemove.get(j));
                                }
                            } else if (this.enableDeleteRouteLogging) {
                                log.info("{} a valid path through exists {} so we will not remove route.", (Object)msgPrefix, (Object)nextblk.getDisplayName());
                            }
                        }
                        ++i3;
                    }
                }
            } else {
                if (this.enableDeleteRouteLogging) {
                    log.info("{} We have no other routes to {} Therefore we will broadast this to our neighbours", (Object)msgPrefix, (Object)destBlock.getDisplayName());
                }
                for (Adjacencies adj : this.neighbours) {
                    adj.removeRouteAdvertisedToNeighbour(destBlock);
                }
                this.firePropertyChange("routing", null, newUpdate);
            }
            --j;
        }
        if (this.enableDeleteRouteLogging) {
            log.info("{} finshed check and notifying of removed routes from {} ===", (Object)msgPrefix, (Object)notifyingblk.getDisplayName());
        }
    }

    private void addThroughPath(Adjacencies adj) {
        Block newAdj = adj.getBlock();
        int packetFlow = adj.getPacketFlow();
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() == newAdj) continue;
            int neighPacketFlow = neighbour.getPacketFlow();
            if (packetFlow == 0 && neighPacketFlow == 0) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            if (packetFlow == 2 && neighPacketFlow == 4) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                continue;
            }
            if (packetFlow == 4 && neighPacketFlow == 2) {
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            if (packetFlow == 0 && neighPacketFlow == 4) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                continue;
            }
            if (packetFlow == 0 && neighPacketFlow == 2) {
                this.addThroughPath(newAdj, neighbour.getBlock());
                continue;
            }
            if (packetFlow == 2 && neighPacketFlow == 0) {
                this.addThroughPath(neighbour.getBlock(), newAdj);
                continue;
            }
            if (packetFlow != 4 || neighPacketFlow != 0) continue;
            this.addThroughPath(newAdj, neighbour.getBlock());
        }
    }

    private void addThroughPath(Block srcBlock, Block dstBlock) {
        if (this.block != null && this.panels.size() > 0) {
            LayoutEditor panel = this.panels.get(0);
            List<LayoutConnectivity> c = panel.getLEAuxTools().getConnectivityList(this);
            if (this.panels.size() > 1) {
                int i = 1;
                while (i < this.panels.size()) {
                    if (c.size() < this.panels.get(i).getLEAuxTools().getConnectivityList(this).size()) {
                        panel = this.panels.get(i);
                        c = panel.getLEAuxTools().getConnectivityList(this);
                    }
                    ++i;
                }
                for (LayoutEditor tPanel : this.panels) {
                    int response;
                    if (tPanel == panel || !InstanceManager.getDefault(LayoutBlockManager.class).warn() || this.compareConnectivity(c, tPanel.getLEAuxTools().getConnectivityList(this)) || (response = JOptionPane.showOptionDialog(null, MessageFormat.format(Bundle.getMessage("Warn1"), this.getUserName(), tPanel.getLayoutName(), panel.getLayoutName()), Bundle.getMessage("WarningTitle"), 0, 3, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonOKPlus")}, Bundle.getMessage("ButtonOK"))) == 0) continue;
                    InstanceManager.getDefault(LayoutBlockManager.class).turnOffWarning();
                }
            }
            this.addThroughPath(srcBlock, dstBlock, panel);
        }
    }

    private void addThroughPath(Block srcBlock, Block dstBlock, LayoutEditor panel) {
        List<LayoutTrackExpectedState<LayoutTurnout>> tmpdtos;
        List<LayoutTrackExpectedState<LayoutTurnout>> stod;
        this.layoutConnectivity = true;
        if (srcBlock == dstBlock) {
            return;
        }
        boolean add = true;
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getSourceBlock() != srcBlock || throughPath.getDestinationBlock() != dstBlock) continue;
            add = false;
        }
        if (!add) {
            return;
        }
        this.connection = panel.getConnectivityUtil();
        try {
            MDC.put((String)"loggingDisabled", (String)this.connection.getClass().getCanonicalName());
            stod = this.connection.getTurnoutList(this.block, srcBlock, dstBlock, true);
            MDC.remove((String)"loggingDisabled");
        }
        catch (NullPointerException ex) {
            MDC.remove((String)"loggingDisabled");
            return;
        }
        if (!this.connection.isTurnoutConnectivityComplete()) {
            this.layoutConnectivity = false;
        }
        try {
            MDC.put((String)"loggingDisabled", (String)this.connection.getClass().getName());
            tmpdtos = this.connection.getTurnoutList(this.block, dstBlock, srcBlock, true);
            MDC.remove((String)"loggingDisabled");
        }
        catch (NullPointerException ex) {
            MDC.remove((String)"loggingDisabled");
            return;
        }
        if (!this.connection.isTurnoutConnectivityComplete()) {
            this.layoutConnectivity = false;
        }
        if (stod.size() == tmpdtos.size()) {
            ArrayList<LayoutTrackExpectedState<LayoutTurnout>> dtos = new ArrayList<LayoutTrackExpectedState<LayoutTurnout>>();
            int i = tmpdtos.size();
            while (i > 0) {
                dtos.add(tmpdtos.get(i - 1));
                --i;
            }
            i = 0;
            while (i < dtos.size()) {
                if (((LayoutTrackExpectedState)dtos.get(i)).getObject() != stod.get(i).getObject()) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < dtos.size()) {
                int y;
                int x = stod.get(i).getExpectedState();
                if (x != (y = ((LayoutTrackExpectedState)dtos.get(i)).getExpectedState().intValue())) {
                    return;
                }
                if (x == 1) {
                    return;
                }
                ++i;
            }
            HashSet<LayoutTurnout> set = new HashSet<LayoutTurnout>();
            for (LayoutTrackExpectedState<LayoutTurnout> layoutTurnoutLayoutTrackExpectedState : stod) {
                boolean val = set.add((LayoutTurnout)layoutTurnoutLayoutTrackExpectedState.getObject());
                if (val) continue;
                return;
            }
            this.addThroughPathPostChecks(srcBlock, dstBlock, stod);
        } else {
            List<LayoutTrackExpectedState<LayoutTurnout>> maxt = stod.size() >= tmpdtos.size() ? stod : tmpdtos;
            HashSet<LayoutTrackExpectedState<LayoutTurnout>> set = new HashSet<LayoutTrackExpectedState<LayoutTurnout>>(maxt);
            if (set.size() == maxt.size()) {
                boolean allowAddition = false;
                for (LayoutTrackExpectedState<LayoutTurnout> layoutTurnoutLayoutTrackExpectedState : maxt) {
                    LayoutTurnout turn = (LayoutTurnout)layoutTurnoutLayoutTrackExpectedState.getObject();
                    if (turn.type != LayoutTurnout.TurnoutType.DOUBLE_XOVER) continue;
                    allowAddition = true;
                    if (layoutTurnoutLayoutTrackExpectedState.getExpectedState() == 2) {
                        layoutTurnoutLayoutTrackExpectedState.setExpectedState(4);
                        continue;
                    }
                    layoutTurnoutLayoutTrackExpectedState.setExpectedState(2);
                }
                if (allowAddition) {
                    this.addThroughPathPostChecks(srcBlock, dstBlock, maxt);
                }
            }
        }
    }

    private void addThroughPathPostChecks(Block srcBlock, Block dstBlock, List<LayoutTrackExpectedState<LayoutTurnout>> stod) {
        List<Path> paths = this.block.getPaths();
        Path srcPath = null;
        for (Path item : paths) {
            if (item.getBlock() != srcBlock) continue;
            srcPath = item;
        }
        Path dstPath = null;
        for (Path value : paths) {
            if (value.getBlock() != dstBlock) continue;
            dstPath = value;
        }
        ThroughPaths path = new ThroughPaths(srcBlock, srcPath, dstBlock, dstPath);
        path.setTurnoutList(stod);
        this.throughPaths.add(path);
        this.firePropertyChange("through-path-added", null, null);
        this.informNeighbourOfValidRoutes(srcBlock);
        this.informNeighbourOfValidRoutes(dstBlock);
    }

    void notifiedNeighbourNoLongerMutual(LayoutBlock srcBlock) {
        if (this.enableDeleteRouteLogging) {
            log.info("From {}Notification from neighbour that it is no longer our friend {}", (Object)this.getDisplayName(), (Object)srcBlock.getDisplayName());
        }
        Block blk = srcBlock.getBlock();
        int i = this.neighbours.size() - 1;
        while (i > -1) {
            if (this.neighbours.get(i).getBlock() == blk) {
                this.removeAdjacency(srcBlock);
                break;
            }
            --i;
        }
    }

    void stateUpdate() {
        RoutingPacket update = new RoutingPacket(2, this.getBlock(), -1, -1, -1.0f, this.getBlockStatus(), this.getNextPacketID());
        this.firePropertyChange("routing", null, update);
    }

    int getBlockStatus() {
        if (this.getOccupancy() == 2) {
            this.useExtraColor = false;
            return 2;
        }
        if (this.useExtraColor) {
            return 8;
        }
        if (this.getOccupancy() == 4) {
            return 4;
        }
        return 1;
    }

    String getBlockStatusString() {
        String result = "UNKNOWN";
        if (this.getOccupancy() == 2) {
            result = "OCCUPIED";
        } else if (this.useExtraColor) {
            result = "RESERVED";
        } else if (this.getOccupancy() == 4) {
            result = "EMPTY";
        }
        return result;
    }

    Integer getNextPacketID() {
        Integer lastID;
        if (updateReferences.isEmpty()) {
            lastID = 0;
        } else {
            int lastIDPos = updateReferences.size() - 1;
            lastID = updateReferences.get(lastIDPos) + 1;
        }
        if (lastID > 2000) {
            lastID = 0;
        }
        updateReferences.add(lastID);
        this.actedUponUpdates.add(lastID);
        if (updateReferences.size() > 500) {
            updateReferences.subList(0, 250).clear();
        }
        if (this.actedUponUpdates.size() > 500) {
            this.actedUponUpdates.subList(0, 250).clear();
        }
        return lastID;
    }

    boolean updatePacketActedUpon(Integer packetID) {
        return this.actedUponUpdates.contains(packetID);
    }

    public List<Block> getActiveNextBlocks(Block source) {
        ArrayList<Block> currentPath = new ArrayList<Block>();
        for (ThroughPaths path : this.throughPaths) {
            if (path.getSourceBlock() != source || !path.isPathActive()) continue;
            currentPath.add(path.getDestinationBlock());
        }
        return currentPath;
    }

    public Path getThroughPathSourcePathAtIndex(int i) {
        return this.throughPaths.get(i).getSourcePath();
    }

    public Path getThroughPathDestinationPathAtIndex(int i) {
        return this.throughPaths.get(i).getDestinationPath();
    }

    public boolean validThroughPath(Block sourceBlock, Block destinationBlock) {
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getSourceBlock() == sourceBlock && throughPath.getDestinationBlock() == destinationBlock) {
                return true;
            }
            if (throughPath.getSourceBlock() != destinationBlock || throughPath.getDestinationBlock() != sourceBlock) continue;
            return true;
        }
        return false;
    }

    public int getThroughPathIndex(Block sourceBlock, Block destinationBlock) {
        int i = 0;
        while (i < this.throughPaths.size()) {
            if (this.throughPaths.get(i).getSourceBlock() == sourceBlock && this.throughPaths.get(i).getDestinationBlock() == destinationBlock) {
                return i;
            }
            if (this.throughPaths.get(i).getSourceBlock() == destinationBlock && this.throughPaths.get(i).getDestinationBlock() == sourceBlock) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String decodePacketFlow(int value) {
        switch (value) {
            case 0: {
                return "Bi-Direction Operation";
            }
            case 2: {
                return "Uni-Directional - Trains can only exit to this block (RX) ";
            }
            case 4: {
                return "Uni-Directional - Trains can not be sent down this block (TX) ";
            }
            case 8: {
                return "None routing updates will be passed";
            }
        }
        log.warn("Unhandled packet flow value: {}", (Object)value);
        return "Unknown";
    }

    public void printValidThroughPaths() {
        log.info("Through paths for block {}", (Object)this.getDisplayName());
        log.info("Current Block, From Block, To Block");
        for (ThroughPaths tp : this.throughPaths) {
            String activeStr = "";
            if (tp.isPathActive()) {
                activeStr = ", *";
            }
            log.info("From {}, {}, {}{}", new Object[]{this.getDisplayName(), tp.getSourceBlock().getDisplayName(), tp.getDestinationBlock().getDisplayName(), activeStr});
        }
    }

    public void printAdjacencies() {
        log.info("Adjacencies for block {}", (Object)this.getDisplayName());
        log.info("Neighbour, Direction, mutual, relationship, metric");
        for (Adjacencies neighbour : this.neighbours) {
            log.info(" neighbor: {}, {}, {}, {}, {}", new Object[]{neighbour.getBlock().getDisplayName(), Path.decodeDirection(neighbour.getDirection()), neighbour.isMutual(), this.decodePacketFlow(neighbour.getPacketFlow()), neighbour.getMetric()});
        }
    }

    public void printRoutes() {
        log.info("Routes for block {}", (Object)this.getDisplayName());
        log.info("Destination, Next Block, Hop Count, Direction, State, Metric");
        for (Routes r : this.routes) {
            String nexthop = r.getNextBlock().getDisplayName();
            if (r.getNextBlock() == this.getBlock()) {
                nexthop = "Directly Connected";
            }
            String activeString = "";
            if (r.isRouteCurrentlyValid()) {
                activeString = ", *";
            }
            log.info(" neighbor: {}, {}, {}, {}, {}, {}{}", new Object[]{r.getDestBlock().getDisplayName(), nexthop, r.getHopCount(), Path.decodeDirection(r.getDirection()), r.getState(), r.getMetric(), activeString});
        }
    }

    public void printRoutes(String inBlockName) {
        log.info("Routes for block {}", (Object)this.getDisplayName());
        log.info("Our Block, Destination, Next Block, Hop Count, Direction, Metric");
        for (Routes route : this.routes) {
            if (!route.getDestBlock().getDisplayName().equals(inBlockName)) continue;
            log.info("From {}, {}, {}, {}, {}, {}", new Object[]{this.getDisplayName(), route.getDestBlock().getDisplayName(), route.getNextBlock().getDisplayName(), route.getHopCount(), Path.decodeDirection(route.getDirection()), route.getMetric()});
        }
    }

    public Block getNextBlock(Block destBlock, int direction) {
        int bestMetric = 965000;
        Block bestBlock = null;
        for (Routes r : this.routes) {
            if (r.getDestBlock() != destBlock || r.getDirection() != direction || r.getMetric() >= bestMetric) continue;
            bestMetric = r.getMetric();
            bestBlock = r.getNextBlock();
        }
        return bestBlock;
    }

    @CheckForNull
    public Block getNextBlock(Block previousBlock, Block destBlock) {
        int bestMetric = 965000;
        Block bestBlock = null;
        for (Routes r : this.routes) {
            if (r.getDestBlock() != destBlock || !this.validThroughPath(previousBlock, r.getNextBlock()) || r.getMetric() >= bestMetric) continue;
            bestMetric = r.getMetric();
            bestBlock = r.getNextBlock();
        }
        return bestBlock;
    }

    public int getConnectedBlockRouteIndex(Block destBlock, int direction) {
        int i = 0;
        while (i < this.routes.size()) {
            if (this.routes.get(i).getNextBlock() == this.getBlock()) {
                log.info("Found a block that is directly connected");
                if (this.routes.get(i).getDestBlock() == destBlock) {
                    log.info("In getConnectedBlockRouteIndex,  {}", (Object)Integer.toString(this.routes.get(i).getDirection() & direction));
                    if ((this.routes.get(i).getDirection() & direction) != 0) {
                        return i;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("From {}, {}, nexthop {}, {}, {}, {}", new Object[]{this.getDisplayName(), this.routes.get(i).getDestBlock().getDisplayName(), this.routes.get(i).getHopCount(), Path.decodeDirection(this.routes.get(i).getDirection()), this.routes.get(i).getState(), this.routes.get(i).getMetric()});
            }
            ++i;
        }
        return -1;
    }

    public int getNextBlockByIndex(Block destBlock, int direction, int offSet) {
        int i = offSet;
        while (i < this.routes.size()) {
            Routes ro = this.routes.get(i);
            if (ro.getDestBlock() == destBlock) {
                log.info("getNextBlockByIndex {}", (Object)Integer.toString(ro.getDirection() & direction));
                if ((ro.getDirection() & direction) != 0) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int getNextBlockByIndex(Block previousBlock, Block destBlock, int offSet) {
        int i = offSet;
        while (i < this.routes.size()) {
            Routes ro = this.routes.get(i);
            if (ro.getDestBlock() == destBlock) {
                if (this.validThroughPath(previousBlock, ro.getNextBlock())) {
                    log.debug("valid through path");
                    return i;
                }
                if (ro.getNextBlock() == this.getBlock()) {
                    log.debug("getNextBlock is this block therefore directly connected");
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int getNextBestBlock(Block previousBlock, Block destBlock, List<Integer> excludeBlock, LayoutBlockConnectivityTools.Metric routingMethod) {
        int i2;
        int bestCount = 965255;
        int bestIndex = -1;
        int lastValue = 0;
        ArrayList<Block> nextBlocks = new ArrayList<Block>(5);
        if (!excludeBlock.isEmpty() && excludeBlock.get(excludeBlock.size() - 1) < this.routes.size()) {
            lastValue = routingMethod == LayoutBlockConnectivityTools.Metric.METRIC ? this.routes.get(excludeBlock.get(excludeBlock.size() - 1)).getMetric() : this.routes.get(excludeBlock.get(excludeBlock.size() - 1)).getHopCount();
            for (int i2 : excludeBlock) {
                nextBlocks.add(this.routes.get(i2).getNextBlock());
            }
        }
        i2 = 0;
        while (i2 < this.routes.size()) {
            int currentValue;
            Routes ro;
            if (!excludeBlock.contains(i2) && !nextBlocks.contains((ro = this.routes.get(i2)).getNextBlock()) && (currentValue = routingMethod == LayoutBlockConnectivityTools.Metric.METRIC ? this.routes.get(i2).getMetric() : this.routes.get(i2).getHopCount()) >= lastValue && ro.getDestBlock() == destBlock) {
                if (this.validThroughPath(previousBlock, ro.getNextBlock())) {
                    if (routingMethod == LayoutBlockConnectivityTools.Metric.METRIC) {
                        if (ro.getMetric() < bestCount) {
                            bestIndex = i2;
                            bestCount = ro.getMetric();
                        }
                    } else if (ro.getHopCount() < bestCount) {
                        bestIndex = i2;
                        bestCount = ro.getHopCount();
                    }
                }
                if (ro.getNextBlock() == this.getBlock()) {
                    return i2;
                }
            }
            ++i2;
        }
        return bestIndex;
    }

    @CheckForNull
    Routes getRouteByDestBlock(Block blk) {
        int i = this.routes.size() - 1;
        while (i > -1) {
            if (this.routes.get(i).getDestBlock() == blk) {
                return this.routes.get(i);
            }
            --i;
        }
        return null;
    }

    @Nonnull
    List<Routes> getRouteByNeighbour(Block blk) {
        ArrayList<Routes> rtr = new ArrayList<Routes>();
        for (Routes route : this.routes) {
            if (route.getNextBlock() != blk) continue;
            rtr.add(route);
        }
        return rtr;
    }

    int getAdjacencyPacketFlow(Block blk) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != blk) continue;
            return neighbour.getPacketFlow();
        }
        return -1;
    }

    boolean isValidNeighbour(Block blk) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != blk) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == this) {
            log.debug("adding ourselves as a listener for some strange reason! Skipping");
            return;
        }
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block6 : switch (e.getPropertyName()) {
            case "routing": {
                if (!(e.getSource() instanceof LayoutBlock)) break;
                LayoutBlock sourceLayoutBlock = (LayoutBlock)e.getSource();
                RoutingPacket update = (RoutingPacket)e.getNewValue();
                int updateType = update.getPacketType();
                switch (updateType) {
                    case 0: {
                        this.addRouteFromNeighbour(sourceLayoutBlock, update);
                        break block6;
                    }
                    case 2: {
                        this.updateRoutingInfo(sourceLayoutBlock, update);
                        break block6;
                    }
                    case 4: {
                        InstanceManager.getDefault(LayoutBlockManager.class).setLastRoutingChange();
                        this.removeRouteFromNeighbour(sourceLayoutBlock, update);
                        break block6;
                    }
                }
                break;
            }
            default: {
                log.debug("Unhandled propertyChange({}): ", (Object)e);
            }
            case "through-path-added": 
            case "through-path-removed": 
            case "NewRoute": 
        }
    }

    @CheckForNull
    Routes getValidRoute(Block nxtBlock, Block dstBlock) {
        if (nxtBlock != null && dstBlock != null) {
            List<Routes> rtr = this.getRouteByNeighbour(nxtBlock);
            if (rtr.isEmpty()) {
                log.debug("From {}, no routes returned for getRouteByNeighbour({})", (Object)this.getDisplayName(), (Object)nxtBlock.getDisplayName());
                return null;
            }
            for (Routes rt : rtr) {
                if (rt.getDestBlock() != dstBlock) continue;
                log.debug("From {}, found dest {}.", (Object)this.getDisplayName(), (Object)dstBlock.getDisplayName());
                return rt;
            }
            log.debug("From {}, no routes to {}.", (Object)this.getDisplayName(), (Object)nxtBlock.getDisplayName());
        } else {
            log.warn("getValidRoute({}, {}", (Object)(nxtBlock != null ? nxtBlock.getDisplayName() : "<null>"), (Object)(dstBlock != null ? dstBlock.getDisplayName() : "<null>"));
        }
        return null;
    }

    public boolean isRouteToDestValid(Block protecting, Block destination) {
        if (protecting == destination) {
            log.debug("protecting and destination blocks are the same therefore we need to check if we have a valid neighbour");
            if (this.getAdjacency(protecting) != null) {
                return true;
            }
        } else if (this.getValidRoute(protecting, destination) != null) {
            return true;
        }
        return false;
    }

    List<Routes> getDestRoutes(Block dstBlock) {
        ArrayList<Routes> rtr = new ArrayList<Routes>();
        for (Routes route : this.routes) {
            if (route.getDestBlock() != dstBlock) continue;
            rtr.add(route);
        }
        return rtr;
    }

    List<Routes> getNextRoutes(Block nxtBlock) {
        ArrayList<Routes> rtr = new ArrayList<Routes>();
        for (Routes route : this.routes) {
            if (route.getNextBlock() != nxtBlock) continue;
            rtr.add(route);
        }
        return rtr;
    }

    void updateRoutingInfo(Routes route) {
        if (route.getHopCount() >= 254) {
            return;
        }
        Block destBlock = route.getDestBlock();
        RoutingPacket update = new RoutingPacket(2, destBlock, this.getBestRouteByHop(destBlock).getHopCount() + 1, this.getBestRouteByMetric(destBlock).getMetric() + this.metric, (float)this.getBestRouteByMetric(destBlock).getMetric() + this.block.getLengthMm(), -1, this.getNextPacketID());
        this.firePropertyChange("routing", null, update);
    }

    void updateRoutingInfo(LayoutBlock src, RoutingPacket update) {
        RoutingPacket newUpdate;
        List<Block> messageRecipients;
        RoutingPacket newUpdate2;
        List<Block> messageRecipients2;
        List<Routes> neighbourRoute;
        boolean forwardUpdate;
        Routes ro;
        Block srcblk = src.getBlock();
        Adjacencies adj = this.getAdjacency(srcblk);
        if (adj == null) {
            return;
        }
        if (this.updatePacketActedUpon(update.getPacketId()) && adj.updatePacketActedUpon(update.getPacketId())) {
            return;
        }
        Block updateBlock = update.getBlock();
        if (updateBlock == this.getBlock()) {
            return;
        }
        boolean neighbour = false;
        if (updateBlock == srcblk) {
            ro = this.getValidRoute(this.getBlock(), updateBlock);
            neighbour = true;
        } else {
            ro = this.getValidRoute(srcblk, updateBlock);
        }
        if (ro == null) {
            return;
        }
        this.actedUponUpdates.add(update.getPacketId());
        adj.addPacketReceivedFromNeighbour(update.getPacketId());
        int hopCount = update.getHopCount();
        int packetmetric = update.getMetric();
        int blockstate = update.getBlockState();
        float length = update.getLength();
        if (hopCount != -1) {
            if (ro.getHopCount() != hopCount) {
                ro.setHopCount(hopCount);
                ++hopCount;
            } else {
                hopCount = -1;
            }
        }
        if ((int)length != -1) {
            float oldLength = ro.getLength();
            if (!MathUtil.equals(oldLength, length)) {
                ro.setLength(length);
                forwardUpdate = true;
                if (ro != this.getBestRouteByLength(update.getBlock())) {
                    forwardUpdate = false;
                }
                if (neighbour) {
                    length = srcblk.getLengthMm();
                    adj.setLength(length);
                    if (forwardUpdate) {
                        neighbourRoute = this.getNextRoutes(srcblk);
                        for (Routes nRo : neighbourRoute) {
                            float updateLength = nRo.getLength();
                            updateLength = updateLength - oldLength + length;
                            nRo.setLength(updateLength);
                            messageRecipients2 = this.getThroughPathDestinationBySource(srcblk);
                            newUpdate2 = new RoutingPacket(2, nRo.getDestBlock(), -1, -1, updateLength + this.block.getLengthMm(), -1, this.getNextPacketID());
                            this.updateRoutesToNeighbours(messageRecipients2, nRo, newUpdate2);
                        }
                    }
                } else if (forwardUpdate) {
                    messageRecipients = this.getThroughPathSourceByDestination(srcblk);
                    newUpdate = new RoutingPacket(2, updateBlock, -1, -1, length + this.block.getLengthMm(), -1, update.getPacketId());
                    this.updateRoutesToNeighbours(messageRecipients, ro, newUpdate);
                }
                length += (float)this.metric;
            } else {
                length = -1.0f;
            }
        }
        if (packetmetric != -1) {
            int oldmetric = ro.getMetric();
            if (oldmetric != packetmetric) {
                ro.setMetric(packetmetric);
                forwardUpdate = true;
                if (ro != this.getBestRouteByMetric(update.getBlock())) {
                    forwardUpdate = false;
                }
                if (neighbour) {
                    packetmetric = src.getBlockMetric();
                    adj.setMetric(packetmetric);
                    if (forwardUpdate) {
                        neighbourRoute = this.getNextRoutes(srcblk);
                        for (Routes nRo : neighbourRoute) {
                            int updatemet = nRo.getMetric();
                            updatemet = updatemet - oldmetric + packetmetric;
                            nRo.setMetric(updatemet);
                            messageRecipients2 = this.getThroughPathDestinationBySource(srcblk);
                            newUpdate2 = new RoutingPacket(2, nRo.getDestBlock(), hopCount, updatemet + this.metric, -1.0f, -1, this.getNextPacketID());
                            this.updateRoutesToNeighbours(messageRecipients2, nRo, newUpdate2);
                        }
                    }
                } else if (forwardUpdate) {
                    messageRecipients = this.getThroughPathSourceByDestination(srcblk);
                    newUpdate = new RoutingPacket(2, updateBlock, hopCount, packetmetric + this.metric, -1.0f, -1, update.getPacketId());
                    this.updateRoutesToNeighbours(messageRecipients, ro, newUpdate);
                }
                packetmetric += this.metric;
            } else {
                packetmetric = -1;
            }
        }
        if (blockstate != -1) {
            boolean stateUpdated = false;
            List<Routes> rtr = this.getDestRoutes(updateBlock);
            for (Routes rt : rtr) {
                if (rt.getState() == blockstate) continue;
                stateUpdated = true;
                rt.stateChange();
            }
            if (stateUpdated) {
                RoutingPacket newUpdate3 = new RoutingPacket(2, updateBlock, -1, -1, -1.0f, blockstate, this.getNextPacketID());
                this.firePropertyChange("routing", null, newUpdate3);
            }
        }
        if (packetmetric != -1 || hopCount != -1 || length != -1.0f) {
            List<Block> messageRecipients3 = this.getThroughPathSourceByDestination(srcblk);
            RoutingPacket newUpdate4 = new RoutingPacket(2, updateBlock, hopCount, packetmetric, length, blockstate, update.getPacketId());
            this.updateRoutesToNeighbours(messageRecipients3, ro, newUpdate4);
        }
    }

    void updateRoutesToNeighbours(List<Block> messageRecipients, Routes ro, RoutingPacket update) {
        for (Block messageRecipient : messageRecipients) {
            Adjacencies adj = this.getAdjacency(messageRecipient);
            if (!adj.advertiseRouteToNeighbour(ro)) continue;
            adj.addRouteAdvertisedToNeighbour(ro);
            LayoutBlock recipient = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(messageRecipient);
            if (recipient == null) continue;
            recipient.updateRoutingInfo(this, update);
        }
    }

    Routes getBestRouteByMetric(Block dest) {
        int bestMetric = 965000;
        int bestIndex = -1;
        List<Routes> destRoutes = this.getDestRoutes(dest);
        int i = 0;
        while (i < destRoutes.size()) {
            if (destRoutes.get(i).getMetric() < bestMetric) {
                bestMetric = destRoutes.get(i).getMetric();
                bestIndex = i;
            }
            ++i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return destRoutes.get(bestIndex);
    }

    Routes getBestRouteByHop(Block dest) {
        int bestHopCount = 255;
        int bestIndex = -1;
        List<Routes> destRoutes = this.getDestRoutes(dest);
        int i = 0;
        while (i < destRoutes.size()) {
            if (destRoutes.get(i).getHopCount() < bestHopCount) {
                bestHopCount = destRoutes.get(i).getHopCount();
                bestIndex = i;
            }
            ++i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return destRoutes.get(bestIndex);
    }

    Routes getBestRouteByLength(Block dest) {
        int bestIndex = -1;
        List<Routes> destRoutes = this.getDestRoutes(dest);
        float bestLength = destRoutes.get(0).getLength();
        int i = 0;
        while (i < destRoutes.size()) {
            if (destRoutes.get(i).getLength() < bestLength) {
                bestLength = destRoutes.get(i).getLength();
                bestIndex = i;
            }
            ++i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return destRoutes.get(bestIndex);
    }

    void addRouteToNeighbours(Routes ro) {
        Block nextHop = ro.getNextBlock();
        ArrayList<LayoutBlock> validFromPath = new ArrayList<LayoutBlock>();
        int i = 0;
        while (i < this.throughPaths.size()) {
            LayoutBlock validBlock = null;
            if (this.throughPaths.get(i).getDestinationBlock() == nextHop && this.getAdjacency(this.throughPaths.get(i).getSourceBlock()).isMutual()) {
                validBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.throughPaths.get(i).getSourceBlock());
            }
            if (validBlock != null && !validFromPath.contains(validBlock)) {
                validFromPath.add(validBlock);
            }
            ++i;
        }
        RoutingPacket update = new RoutingPacket(0, ro.getDestBlock(), ro.getHopCount() + 1, ro.getMetric() + this.metric, ro.getLength() + this.getBlock().getLengthMm(), -1, this.getNextPacketID());
        for (LayoutBlock layoutBlock : validFromPath) {
            Adjacencies adj = this.getAdjacency(layoutBlock.getBlock());
            if (!adj.advertiseRouteToNeighbour(ro)) continue;
            adj.addRouteAdvertisedToNeighbour(ro);
            layoutBlock.addRouteFromNeighbour(this, update);
        }
    }

    void addRouteFromNeighbour(LayoutBlock src, RoutingPacket update) {
        InstanceManager.getDefault(LayoutBlockManager.class).setLastRoutingChange();
        Block destBlock = update.getBlock();
        Block srcblk = src.getBlock();
        if (destBlock == this.getBlock()) {
            return;
        }
        Adjacencies adj = this.getAdjacency(srcblk);
        if (adj == null) {
            return;
        }
        if (adj.getPacketFlow() == 4) {
            return;
        }
        int hopCount = update.getHopCount();
        int updatemetric = update.getMetric();
        float length = update.getLength();
        if (hopCount > 255) {
            return;
        }
        for (Routes ro : this.routes) {
            if (ro.getNextBlock() != srcblk || ro.getDestBlock() != destBlock) continue;
            this.updateRoutingInfo(src, update);
            return;
        }
        int direction = adj.getDirection();
        Routes route = new Routes(destBlock, srcblk, hopCount, direction, updatemetric, length);
        this.routes.add(route);
        this.addRouteToNeighbours(route);
    }

    public int getNeighbourDirection(LayoutBlock neigh) {
        if (neigh == null) {
            return 0;
        }
        Block neighbourBlock = neigh.getBlock();
        return this.getNeighbourDirection(neighbourBlock);
    }

    public int getNeighbourDirection(Block neighbourBlock) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != neighbourBlock) continue;
            return neighbour.getDirection();
        }
        return 0;
    }

    Adjacencies getAdjacency(Block blk) {
        for (Adjacencies neighbour : this.neighbours) {
            if (neighbour.getBlock() != blk) continue;
            return neighbour;
        }
        return null;
    }

    public int getNumberOfNeighbours() {
        return this.neighbours.size();
    }

    public Block getNeighbourAtIndex(int i) {
        return this.neighbours.get(i).getBlock();
    }

    public int getNeighbourDirection(int i) {
        return this.neighbours.get(i).getDirection();
    }

    public int getNeighbourMetric(int i) {
        return this.neighbours.get(i).getMetric();
    }

    public String getNeighbourPacketFlowAsString(int i) {
        return this.decodePacketFlow(this.neighbours.get(i).getPacketFlow());
    }

    public boolean isNeighbourMutual(int i) {
        return this.neighbours.get(i).isMutual();
    }

    int getNeighbourIndex(Adjacencies adj) {
        int i = 0;
        while (i < this.neighbours.size()) {
            if (this.neighbours.get(i) == adj) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNumberOfRoutes() {
        return this.routes.size();
    }

    public int getRouteDirectionAtIndex(int i) {
        return this.routes.get(i).getDirection();
    }

    public Block getRouteDestBlockAtIndex(int i) {
        return this.routes.get(i).getDestBlock();
    }

    public Block getRouteNextBlockAtIndex(int i) {
        return this.routes.get(i).getNextBlock();
    }

    public int getRouteHopCountAtIndex(int i) {
        return this.routes.get(i).getHopCount();
    }

    public float getRouteLengthAtIndex(int i) {
        return this.routes.get(i).getLength();
    }

    public int getRouteMetric(int i) {
        return this.routes.get(i).getMetric();
    }

    public int getRouteState(int i) {
        return this.routes.get(i).getState();
    }

    public boolean getRouteValid(int i) {
        return this.routes.get(i).isRouteCurrentlyValid();
    }

    public String getRouteStateAsString(int i) {
        int state = this.routes.get(i).getState();
        switch (state) {
            case 2: {
                return Bundle.getMessage("TrackOccupied");
            }
            case 8: {
                return Bundle.getMessage("StateReserved");
            }
            case 4: {
                return Bundle.getMessage("StateFree");
            }
        }
        return Bundle.getMessage("BeanStateUnknown");
    }

    int getRouteIndex(Routes r) {
        int i = 0;
        while (i < this.routes.size()) {
            if (this.routes.get(i) == r) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getBlockHopCount(Block destination, Block nextBlock) {
        if (destination == nextBlock && this.isValidNeighbour(nextBlock)) {
            return 1;
        }
        for (Routes route : this.routes) {
            if (route.getDestBlock() != destination || route.getNextBlock() != nextBlock) continue;
            return route.getHopCount();
        }
        return -1;
    }

    public int getBlockMetric(Block destination, Block nextBlock) {
        if (destination == nextBlock && this.isValidNeighbour(nextBlock)) {
            return 1;
        }
        for (Routes route : this.routes) {
            if (route.getDestBlock() != destination || route.getNextBlock() != nextBlock) continue;
            return route.getMetric();
        }
        return -1;
    }

    public float getBlockLength(Block destination, Block nextBlock) {
        if (destination == nextBlock && this.isValidNeighbour(nextBlock)) {
            return 1.0f;
        }
        for (Routes route : this.routes) {
            if (route.getDestBlock() != destination || route.getNextBlock() != nextBlock) continue;
            return route.getLength();
        }
        return -1.0f;
    }

    public int getNumberOfThroughPaths() {
        return this.throughPaths.size();
    }

    public Block getThroughPathSource(int i) {
        return this.throughPaths.get(i).getSourceBlock();
    }

    public Block getThroughPathDestination(int i) {
        return this.throughPaths.get(i).getDestinationBlock();
    }

    public Boolean isThroughPathActive(int i) {
        return this.throughPaths.get(i).isPathActive();
    }

    @Nonnull
    List<Block> getThroughPathSourceByDestination(Block dest) {
        ArrayList<Block> a = new ArrayList<Block>();
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getDestinationBlock() != dest) continue;
            a.add(throughPath.getSourceBlock());
        }
        return a;
    }

    @Nonnull
    List<Block> getThroughPathDestinationBySource(Block source) {
        ArrayList<Block> a = new ArrayList<Block>();
        for (ThroughPaths throughPath : this.throughPaths) {
            if (throughPath.getSourceBlock() != source) continue;
            a.add(throughPath.getDestinationBlock());
        }
        return a;
    }

    boolean checkIsRouteOnValidThroughPath(Routes r) {
        for (ThroughPaths t : this.throughPaths) {
            if (!t.isPathActive()) continue;
            if (t.getDestinationBlock() == r.getNextBlock()) {
                return true;
            }
            if (t.getSourceBlock() != r.getNextBlock()) continue;
            return true;
        }
        return false;
    }

    public void refreshValidRoutes() {
        int i = 0;
        while (i < this.throughPaths.size()) {
            ThroughPaths t = this.throughPaths.get(i);
            this.setRoutesValid(t.getDestinationBlock(), t.isPathActive());
            this.setRoutesValid(t.getSourceBlock(), t.isPathActive());
            this.firePropertyChange("path", null, i);
            ++i;
        }
    }

    void updateActiveThroughPaths(ThroughPaths tp, boolean active) {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList<ThroughPaths>();
        }
        if (active) {
            this.activePaths.add(tp);
            this.setRoutesValid(tp.getSourceBlock(), active);
            this.setRoutesValid(tp.getDestinationBlock(), active);
        } else {
            this.activePaths.remove(tp);
            boolean SourceInUse = false;
            boolean DestinationInUse = false;
            for (ThroughPaths activePath : this.activePaths) {
                Block testSour = activePath.getSourceBlock();
                Block testDest = activePath.getDestinationBlock();
                if (testSour == tp.getSourceBlock() || testDest == tp.getSourceBlock()) {
                    SourceInUse = true;
                }
                if (testSour != tp.getDestinationBlock() && testDest != tp.getDestinationBlock()) continue;
                DestinationInUse = true;
            }
            if (!SourceInUse) {
                this.setRoutesValid(tp.getSourceBlock(), active);
            }
            if (!DestinationInUse) {
                this.setRoutesValid(tp.getDestinationBlock(), active);
            }
        }
        int i = 0;
        while (i < this.throughPaths.size()) {
            if (tp == this.throughPaths.get(i)) {
                this.firePropertyChange("path", null, i);
            }
            ++i;
        }
    }

    void setRoutesValid(Block nxtHopActive, boolean state) {
        List<Routes> rtr = this.getRouteByNeighbour(nxtHopActive);
        rtr.forEach(rt -> rt.setValidCurrentRoute(state));
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Sensor && evt.getOldValue().equals(this.getOccupancySensor())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
            if (evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory())) {
                throw new PropertyVetoException(this.getDisplayName(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            if (evt.getOldValue() instanceof Sensor && evt.getOldValue().equals(this.getOccupancySensor())) {
                this.setOccupancySensorName(null);
            }
            if (evt.getOldValue() instanceof Memory && evt.getOldValue().equals(this.getMemory())) {
                this.setMemoryName(null);
            }
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getBlock())) {
                report.add(new NamedBeanUsageReport("LayoutBlockBlock"));
            }
            if (bean.equals(this.getMemory())) {
                report.add(new NamedBeanUsageReport("LayoutBlockMemory"));
            }
            if (bean.equals(this.getOccupancySensor())) {
                report.add(new NamedBeanUsageReport("LayoutBlockSensor"));
            }
            int i = 0;
            while (i < this.getNumberOfNeighbours()) {
                if (bean.equals(this.getNeighbourAtIndex(i))) {
                    report.add(new NamedBeanUsageReport("LayoutBlockNeighbor", "Neighbor"));
                }
                ++i;
            }
        }
        return report;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameLayoutBlock");
    }

    private class Adjacencies {
        Block adjBlock;
        LayoutBlock adjLayoutBlock;
        int direction;
        int packetFlow = 0;
        boolean mutualAdjacency = false;
        HashMap<Block, Routes> adjDestRoutes = new HashMap();
        List<Integer> actedUponUpdates = new ArrayList<Integer>(501);

        Adjacencies(Block block, int dir, int packetFlow) {
            this.adjBlock = block;
            this.direction = dir;
            this.packetFlow = packetFlow;
        }

        Block getBlock() {
            return this.adjBlock;
        }

        LayoutBlock getLayoutBlock() {
            return this.adjLayoutBlock;
        }

        int getDirection() {
            return this.direction;
        }

        void setMutual(boolean mut) {
            if (mut == this.mutualAdjacency) {
                return;
            }
            this.mutualAdjacency = mut;
            if (this.mutualAdjacency) {
                this.adjLayoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.adjBlock);
            }
        }

        boolean isMutual() {
            return this.mutualAdjacency;
        }

        int getPacketFlow() {
            return this.packetFlow;
        }

        void setPacketFlow(int flow) {
            if (flow != this.packetFlow) {
                int oldFlow = this.packetFlow;
                this.packetFlow = flow;
                LayoutBlock.this.firePropertyChange("neighbourpacketflow", oldFlow, this.packetFlow);
            }
        }

        void setMetric(int met) {
            LayoutBlock.this.firePropertyChange("neighbourmetric", null, LayoutBlock.this.getNeighbourIndex(this));
        }

        int getMetric() {
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlockMetric();
            }
            this.adjLayoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.adjBlock);
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlockMetric();
            }
            if (log.isDebugEnabled()) {
                log.debug("Layout Block {} returned as null", (Object)this.adjBlock.getDisplayName());
            }
            return -1;
        }

        void setLength(float len) {
            LayoutBlock.this.firePropertyChange("neighbourlength", null, LayoutBlock.this.getNeighbourIndex(this));
        }

        float getLength() {
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlock().getLengthMm();
            }
            this.adjLayoutBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.adjBlock);
            if (this.adjLayoutBlock != null) {
                return this.adjLayoutBlock.getBlock().getLengthMm();
            }
            if (log.isDebugEnabled()) {
                log.debug("Layout Block {} returned as null", (Object)this.adjBlock.getDisplayName());
            }
            return -1.0f;
        }

        void removeRouteAdvertisedToNeighbour(Routes removeRoute) {
            Block dest = removeRoute.getDestBlock();
            if (this.adjDestRoutes.get(dest) == removeRoute) {
                this.adjDestRoutes.remove(dest);
            }
        }

        void removeRouteAdvertisedToNeighbour(Block block) {
            this.adjDestRoutes.remove(block);
        }

        void addRouteAdvertisedToNeighbour(Routes addedRoute) {
            this.adjDestRoutes.put(addedRoute.getDestBlock(), addedRoute);
        }

        boolean advertiseRouteToNeighbour(Routes routeToAdd) {
            if (!this.isMutual()) {
                log.debug("In block {}: Neighbour is not mutual so will not advertise it (Routes {})", (Object)LayoutBlock.this.getDisplayName(), (Object)routeToAdd);
                return false;
            }
            Block dest = routeToAdd.getDestBlock();
            if (!this.adjDestRoutes.containsKey(dest)) {
                log.debug("In block {}: We are not currently advertising a route to the destination to neighbour: {}", (Object)LayoutBlock.this.getDisplayName(), (Object)dest.getDisplayName());
                return true;
            }
            if (routeToAdd.getHopCount() > 255) {
                log.debug("Hop count is gereater than 255 we will therefore do nothing with this route");
                return false;
            }
            Routes existingRoute = this.adjDestRoutes.get(dest);
            if (existingRoute.getMetric() > routeToAdd.getMetric()) {
                return true;
            }
            if (existingRoute.getHopCount() > routeToAdd.getHopCount()) {
                return true;
            }
            if (existingRoute == routeToAdd) {
                return false;
            }
            return false;
        }

        boolean updatePacketActedUpon(Integer packetID) {
            return this.actedUponUpdates.contains(packetID);
        }

        void addPacketReceivedFromNeighbour(Integer packetID) {
            this.actedUponUpdates.add(packetID);
            if (this.actedUponUpdates.size() > 500) {
                this.actedUponUpdates.subList(0, 250).clear();
            }
        }

        void dispose() {
            this.adjBlock = null;
            this.adjLayoutBlock = null;
            this.mutualAdjacency = false;
            this.adjDestRoutes = null;
            this.actedUponUpdates = null;
        }
    }

    protected class LayoutBlockEditAction
    extends BlockEditAction {
        protected LayoutBlockEditAction() {
        }

        @Override
        public String helpTarget() {
            return "package.jmri.jmrit.display.EditLayoutBlock";
        }

        @Override
        protected void initPanels() {
            super.initPanels();
            BeanItemPanel ld = this.layoutDetails();
            if (InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
                this.blockRoutingDetails();
            }
            this.setSelectedComponent(ld);
        }

        BeanItemPanel layoutDetails() {
            BeanItemPanel layout = new BeanItemPanel();
            layout.setName(Bundle.getMessage("LayoutEditor"));
            LayoutEditor.setupComboBox(LayoutBlock.this.memoryComboBox, false, true, false);
            layout.addItem(new BeanEditItem(new JLabel("" + LayoutBlock.this.useCount), Bundle.getMessage("UseCount"), null));
            layout.addItem(new BeanEditItem(LayoutBlock.this.memoryComboBox, Bundle.getMessage("BeanNameMemory"), Bundle.getMessage("MemoryVariableTip")));
            LayoutBlock.this.senseBox.removeAllItems();
            LayoutBlock.this.senseBox.addItem(Bundle.getMessage("SensorStateActive"));
            LayoutBlock.this.senseActiveIndex = 0;
            LayoutBlock.this.senseBox.addItem(Bundle.getMessage("SensorStateInactive"));
            LayoutBlock.this.senseInactiveIndex = 1;
            layout.addItem(new BeanEditItem(LayoutBlock.this.senseBox, Bundle.getMessage("OccupiedSense"), Bundle.getMessage("OccupiedSenseHint")));
            LayoutBlock.this.trackColorChooser = new JColorChooser(LayoutBlock.this.blockTrackColor);
            LayoutBlock.this.trackColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] trackColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            LayoutBlock.this.trackColorChooser.setChooserPanels(trackColorPanels);
            layout.addItem(new BeanEditItem(LayoutBlock.this.trackColorChooser, Bundle.getMessage("TrackColor"), Bundle.getMessage("TrackColorHint")));
            LayoutBlock.this.occupiedColorChooser = new JColorChooser(LayoutBlock.this.blockOccupiedColor);
            LayoutBlock.this.occupiedColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] occupiedColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            LayoutBlock.this.occupiedColorChooser.setChooserPanels(occupiedColorPanels);
            layout.addItem(new BeanEditItem(LayoutBlock.this.occupiedColorChooser, Bundle.getMessage("OccupiedColor"), Bundle.getMessage("OccupiedColorHint")));
            LayoutBlock.this.extraColorChooser = new JColorChooser(LayoutBlock.this.blockExtraColor);
            LayoutBlock.this.extraColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] extraColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            LayoutBlock.this.extraColorChooser.setChooserPanels(extraColorPanels);
            layout.addItem(new BeanEditItem(LayoutBlock.this.extraColorChooser, Bundle.getMessage("ExtraColor"), Bundle.getMessage("ExtraColorHint")));
            layout.setSaveItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName;
                    boolean needsRedraw = false;
                    int k = LayoutBlock.this.senseBox.getSelectedIndex();
                    int oldSense = LayoutBlock.this.occupiedSense;
                    if (k == LayoutBlock.this.senseActiveIndex) {
                        LayoutBlock.this.occupiedSense = 2;
                    } else {
                        LayoutBlock.this.occupiedSense = 4;
                    }
                    if (oldSense != LayoutBlock.this.occupiedSense) {
                        needsRedraw = true;
                    }
                    Color oldColor = LayoutBlock.this.blockTrackColor;
                    LayoutBlock.this.blockTrackColor = LayoutBlock.this.trackColorChooser.getColor();
                    if (oldColor != LayoutBlock.this.blockTrackColor) {
                        needsRedraw = true;
                        JmriColorChooser.addRecentColor(LayoutBlock.this.blockTrackColor);
                    }
                    oldColor = LayoutBlock.this.blockOccupiedColor;
                    LayoutBlock.this.blockOccupiedColor = LayoutBlock.this.occupiedColorChooser.getColor();
                    if (oldColor != LayoutBlock.this.blockOccupiedColor) {
                        needsRedraw = true;
                        JmriColorChooser.addRecentColor(LayoutBlock.this.blockOccupiedColor);
                    }
                    oldColor = LayoutBlock.this.blockExtraColor;
                    LayoutBlock.this.blockExtraColor = LayoutBlock.this.extraColorChooser.getColor();
                    if (oldColor != LayoutBlock.this.blockExtraColor) {
                        needsRedraw = true;
                        JmriColorChooser.addRecentColor(LayoutBlock.this.blockExtraColor);
                    }
                    if ((newName = LayoutBlock.this.memoryComboBox.getSelectedItemDisplayName()) == null) {
                        newName = "";
                    }
                    if (!LayoutBlock.this.memoryName.equals(newName)) {
                        LayoutBlock.this.setMemory(LayoutBlock.this.validateMemory(newName, LayoutBlock.this.editLayoutBlockFrame), newName);
                        if (LayoutBlock.this.getMemory() == null) {
                            LayoutBlock.this.memoryName = "";
                            LayoutBlock.this.memoryComboBox.setSelectedItem(null);
                            return;
                        }
                        LayoutBlock.this.memoryComboBox.setSelectedItem(LayoutBlock.this.getMemory());
                        needsRedraw = true;
                    }
                    if (needsRedraw) {
                        LayoutBlock.this.redrawLayoutBlockPanels();
                    }
                }
            });
            layout.setResetItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutBlock.this.memoryComboBox.setSelectedItem(LayoutBlock.this.getMemory());
                    LayoutBlock.this.trackColorChooser.setColor(LayoutBlock.this.blockTrackColor);
                    LayoutBlock.this.occupiedColorChooser.setColor(LayoutBlock.this.blockOccupiedColor);
                    LayoutBlock.this.extraColorChooser.setColor(LayoutBlock.this.blockExtraColor);
                    if (LayoutBlock.this.occupiedSense == 2) {
                        LayoutBlock.this.senseBox.setSelectedIndex(LayoutBlock.this.senseActiveIndex);
                    } else {
                        LayoutBlock.this.senseBox.setSelectedIndex(LayoutBlock.this.senseInactiveIndex);
                    }
                }
            });
            this.bei.add(layout);
            return layout;
        }

        BeanItemPanel blockRoutingDetails() {
            BeanItemPanel routing = new BeanItemPanel();
            routing.setName("Routing");
            routing.addItem(new BeanEditItem(LayoutBlock.this.metricField, "Block Metric", "set the cost for going over this block"));
            routing.addItem(new BeanEditItem(null, null, "Set the direction of the connection to the neighbouring block"));
            LayoutBlock.this.neighbourDir = new ArrayList<JComboBox<String>>(LayoutBlock.this.getNumberOfNeighbours());
            int i = 0;
            while (i < LayoutBlock.this.getNumberOfNeighbours()) {
                JComboBox<String> dir = new JComboBox<String>(LayoutBlock.this.working);
                routing.addItem(new BeanEditItem(dir, LayoutBlock.this.getNeighbourAtIndex(i).getDisplayName(), null));
                LayoutBlock.this.neighbourDir.add(dir);
                ++i;
            }
            routing.setResetItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayoutBlock.this.metricField.setText(Integer.toString(((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.metric));
                    int i = 0;
                    while (i < LayoutBlock.this.getNumberOfNeighbours()) {
                        JComboBox<String> dir = ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbourDir.get(i);
                        Block blk = ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i).getBlock();
                        if (LayoutBlock.this.block.isBlockDenied(blk)) {
                            dir.setSelectedIndex(2);
                        } else if (blk.isBlockDenied(LayoutBlock.this.block)) {
                            dir.setSelectedIndex(1);
                        } else {
                            dir.setSelectedIndex(0);
                        }
                        ++i;
                    }
                }
            });
            routing.setSaveItem(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int m = Integer.parseInt(LayoutBlock.this.metricField.getText().trim());
                    if (m != ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.metric) {
                        LayoutBlock.this.setBlockMetric(m);
                    }
                    if (((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbourDir != null) {
                        int i = 0;
                        while (i < ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbourDir.size()) {
                            int neigh = ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbourDir.get(i).getSelectedIndex();
                            ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i).getBlock().removeBlockDenyList(LayoutBlock.this.block);
                            LayoutBlock.this.block.removeBlockDenyList(((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i).getBlock());
                            switch (neigh) {
                                case 0: {
                                    LayoutBlock.this.updateNeighbourPacketFlow(((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i), 0);
                                    break;
                                }
                                case 1: {
                                    ((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i).getBlock().addBlockDenyList(LayoutBlock.this.block.getDisplayName());
                                    LayoutBlock.this.updateNeighbourPacketFlow(((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i), 4);
                                    break;
                                }
                                case 2: {
                                    LayoutBlock.this.block.addBlockDenyList(((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i).getBlock().getDisplayName());
                                    LayoutBlock.this.updateNeighbourPacketFlow(((LayoutBlockEditAction)LayoutBlockEditAction.this).LayoutBlock.this.neighbours.get(i), 2);
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                }
            });
            this.bei.add(routing);
            return routing;
        }
    }

    private class Routes
    implements PropertyChangeListener {
        int direction;
        Block destBlock;
        Block nextBlock;
        int hopCount;
        int routeMetric;
        float length;
        int miscflags = 0;
        boolean validCurrentRoute = false;

        public Routes(Block dstBlock, Block nxtBlock, int hop, int dir, int met, float len) {
            this.destBlock = dstBlock;
            this.nextBlock = nxtBlock;
            this.hopCount = hop;
            this.direction = dir;
            this.routeMetric = met;
            this.length = len;
            this.init();
        }

        final void init() {
            this.validCurrentRoute = LayoutBlock.this.checkIsRouteOnValidThroughPath(this);
            LayoutBlock.this.firePropertyChange("length", null, null);
            this.destBlock.addPropertyChangeListener(this);
        }

        public String toString() {
            return "Routes(dst:" + this.destBlock + ", nxt:" + this.nextBlock + ", hop:" + this.hopCount + ", dir:" + this.direction + ", met:" + this.routeMetric + ", len: " + this.length + ")";
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("state")) {
                this.stateChange();
            }
        }

        public Block getDestBlock() {
            return this.destBlock;
        }

        public Block getNextBlock() {
            return this.nextBlock;
        }

        public int getHopCount() {
            return this.hopCount;
        }

        public int getDirection() {
            return this.direction;
        }

        public int getMetric() {
            return this.routeMetric;
        }

        public float getLength() {
            return this.length;
        }

        public void setMetric(int met) {
            if (met == this.routeMetric) {
                return;
            }
            this.routeMetric = met;
            LayoutBlock.this.firePropertyChange("metric", null, LayoutBlock.this.getRouteIndex(this));
        }

        public void setHopCount(int hop) {
            if (this.hopCount == hop) {
                return;
            }
            this.hopCount = hop;
            LayoutBlock.this.firePropertyChange("hop", null, LayoutBlock.this.getRouteIndex(this));
        }

        public void setLength(float len) {
            if (len == this.length) {
                return;
            }
            this.length = len;
            LayoutBlock.this.firePropertyChange("length", null, LayoutBlock.this.getRouteIndex(this));
        }

        void stateChange() {
            LayoutBlock.this.firePropertyChange("state", null, LayoutBlock.this.getRouteIndex(this));
        }

        int getState() {
            LayoutBlock destLBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.destBlock);
            if (destLBlock != null) {
                return destLBlock.getBlockStatus();
            }
            if (log.isDebugEnabled()) {
                log.debug("Layout Block {} returned as null", (Object)this.destBlock.getDisplayName());
            }
            return -1;
        }

        void setValidCurrentRoute(boolean boo) {
            if (this.validCurrentRoute == boo) {
                return;
            }
            this.validCurrentRoute = boo;
            LayoutBlock.this.firePropertyChange("valid", null, LayoutBlock.this.getRouteIndex(this));
        }

        boolean isRouteCurrentlyValid() {
            return this.validCurrentRoute;
        }

        void setMiscFlags(int f) {
            this.miscflags = f;
        }

        int getMiscFlags() {
            return this.miscflags;
        }
    }

    private static class RoutingPacket {
        int packetType;
        Block block;
        int hopCount = -1;
        int packetMetric = -1;
        int blockstate = -1;
        float length = -1.0f;
        Integer packetRef = -1;

        RoutingPacket(int packetType, Block blk, int hopCount, int packetMetric, float length, int blockstate, Integer packetRef) {
            this.packetType = packetType;
            this.block = blk;
            this.hopCount = hopCount;
            this.packetMetric = packetMetric;
            this.blockstate = blockstate;
            this.packetRef = packetRef;
            this.length = length;
        }

        int getPacketType() {
            return this.packetType;
        }

        Block getBlock() {
            return this.block;
        }

        int getHopCount() {
            return this.hopCount;
        }

        int getMetric() {
            return this.packetMetric;
        }

        int getBlockState() {
            return this.blockstate;
        }

        float getLength() {
            return this.length;
        }

        Integer getPacketId() {
            return this.packetRef;
        }
    }

    private class ThroughPaths
    implements PropertyChangeListener {
        Block sourceBlock;
        Block destinationBlock;
        Path sourcePath;
        Path destinationPath;
        boolean pathActive = false;
        HashMap<Turnout, Integer> _turnouts = new HashMap();

        ThroughPaths(Block srcBlock, Path srcPath, Block destBlock, Path dstPath) {
            this.sourceBlock = srcBlock;
            this.destinationBlock = destBlock;
            this.sourcePath = srcPath;
            this.destinationPath = dstPath;
        }

        Block getSourceBlock() {
            return this.sourceBlock;
        }

        Block getDestinationBlock() {
            return this.destinationBlock;
        }

        Path getSourcePath() {
            return this.sourcePath;
        }

        Path getDestinationPath() {
            return this.destinationPath;
        }

        boolean isPathActive() {
            return this.pathActive;
        }

        void setTurnoutList(List<LayoutTrackExpectedState<LayoutTurnout>> turnouts) {
            if (!this._turnouts.isEmpty()) {
                Set<Turnout> en = this._turnouts.keySet();
                en.forEach(listTurnout -> listTurnout.removePropertyChangeListener(this));
            }
            if (turnouts.isEmpty()) {
                this.pathActive = true;
                LayoutBlock.this.setRoutesValid(this.sourceBlock, true);
                LayoutBlock.this.setRoutesValid(this.destinationBlock, true);
                return;
            }
            this._turnouts = new HashMap(turnouts.size());
            for (LayoutTrackExpectedState<LayoutTurnout> turnout : turnouts) {
                if (turnout.getObject() instanceof LayoutSlip) {
                    int slipState = turnout.getExpectedState();
                    LayoutSlip ls = (LayoutSlip)turnout.getObject();
                    int taState = ls.getTurnoutState(slipState);
                    this._turnouts.put(ls.getTurnout(), taState);
                    ls.getTurnout().addPropertyChangeListener(this, ls.getTurnoutName(), "Layout Block Routing");
                    int tbState = ls.getTurnoutBState(slipState);
                    this._turnouts.put(ls.getTurnoutB(), tbState);
                    ls.getTurnoutB().addPropertyChangeListener(this, ls.getTurnoutBName(), "Layout Block Routing");
                    continue;
                }
                LayoutTurnout lt = (LayoutTurnout)turnout.getObject();
                if (lt.getTurnout() != null) {
                    this._turnouts.put(lt.getTurnout(), turnout.getExpectedState());
                    lt.getTurnout().addPropertyChangeListener(this, lt.getTurnoutName(), "Layout Block Routing");
                    continue;
                }
                log.error("{} has no physical turnout allocated, block = {}", (Object)lt, (Object)LayoutBlock.this.block.getDisplayName());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                Turnout srcTurnout = (Turnout)e.getSource();
                int newVal = (Integer)e.getNewValue();
                int values = this._turnouts.get(srcTurnout);
                boolean allset = false;
                this.pathActive = false;
                if (newVal == values) {
                    allset = true;
                    if (this._turnouts.size() > 1) {
                        for (Map.Entry<Turnout, Integer> entry : this._turnouts.entrySet()) {
                            int state;
                            if (srcTurnout == entry.getKey() || (state = entry.getKey().getState()) == entry.getValue()) continue;
                            allset = false;
                            break;
                        }
                    }
                }
                LayoutBlock.this.updateActiveThroughPaths(this, allset);
                this.pathActive = allset;
            }
        }
    }
}

