/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

public enum HitPointType {
    NONE,
    POS_POINT,
    TURNOUT_A,
    TURNOUT_B,
    TURNOUT_C,
    TURNOUT_D,
    LEVEL_XING_A,
    LEVEL_XING_B,
    LEVEL_XING_C,
    LEVEL_XING_D,
    TRACK,
    TURNOUT_CENTER,
    LEVEL_XING_CENTER,
    TURNTABLE_CENTER,
    LAYOUT_POS_LABEL,
    LAYOUT_POS_JCOMP,
    MULTI_SENSOR,
    MARKER,
    TRACK_CIRCLE_CENTRE,
    UNUSED_19,
    SLIP_CENTER,
    SLIP_A,
    SLIP_B,
    SLIP_C,
    SLIP_D,
    SLIP_LEFT,
    SLIP_RIGHT,
    UNUSED_27,
    UNUSED_28,
    UNUSED_29,
    BEZIER_CONTROL_POINT_0,
    BEZIER_CONTROL_POINT_1,
    BEZIER_CONTROL_POINT_2,
    BEZIER_CONTROL_POINT_3,
    BEZIER_CONTROL_POINT_4,
    BEZIER_CONTROL_POINT_5,
    BEZIER_CONTROL_POINT_6,
    BEZIER_CONTROL_POINT_7,
    BEZIER_CONTROL_POINT_8,
    SHAPE_CENTER,
    SHAPE_POINT_0,
    SHAPE_POINT_1,
    SHAPE_POINT_2,
    SHAPE_POINT_3,
    SHAPE_POINT_4,
    SHAPE_POINT_5,
    SHAPE_POINT_6,
    SHAPE_POINT_7,
    SHAPE_POINT_8,
    SHAPE_POINT_9,
    TURNTABLE_RAY_0,
    TURNTABLE_RAY_1,
    TURNTABLE_RAY_2,
    TURNTABLE_RAY_3,
    TURNTABLE_RAY_4,
    TURNTABLE_RAY_5,
    TURNTABLE_RAY_6,
    TURNTABLE_RAY_7,
    TURNTABLE_RAY_8,
    TURNTABLE_RAY_9,
    TURNTABLE_RAY_10,
    TURNTABLE_RAY_11,
    TURNTABLE_RAY_12,
    TURNTABLE_RAY_13,
    TURNTABLE_RAY_14,
    TURNTABLE_RAY_15,
    TURNTABLE_RAY_16,
    TURNTABLE_RAY_17,
    TURNTABLE_RAY_18,
    TURNTABLE_RAY_19,
    TURNTABLE_RAY_20,
    TURNTABLE_RAY_21,
    TURNTABLE_RAY_22,
    TURNTABLE_RAY_23,
    TURNTABLE_RAY_24,
    TURNTABLE_RAY_25,
    TURNTABLE_RAY_26,
    TURNTABLE_RAY_27,
    TURNTABLE_RAY_28,
    TURNTABLE_RAY_29,
    TURNTABLE_RAY_30,
    TURNTABLE_RAY_31,
    TURNTABLE_RAY_32,
    TURNTABLE_RAY_33,
    TURNTABLE_RAY_34,
    TURNTABLE_RAY_35,
    TURNTABLE_RAY_36,
    TURNTABLE_RAY_37,
    TURNTABLE_RAY_38,
    TURNTABLE_RAY_39,
    TURNTABLE_RAY_40,
    TURNTABLE_RAY_41,
    TURNTABLE_RAY_42,
    TURNTABLE_RAY_43,
    TURNTABLE_RAY_44,
    TURNTABLE_RAY_45,
    TURNTABLE_RAY_46,
    TURNTABLE_RAY_47,
    TURNTABLE_RAY_48,
    TURNTABLE_RAY_49,
    TURNTABLE_RAY_50,
    TURNTABLE_RAY_51,
    TURNTABLE_RAY_52,
    TURNTABLE_RAY_53,
    TURNTABLE_RAY_54,
    TURNTABLE_RAY_55,
    TURNTABLE_RAY_56,
    TURNTABLE_RAY_57,
    TURNTABLE_RAY_58,
    TURNTABLE_RAY_59,
    TURNTABLE_RAY_60,
    TURNTABLE_RAY_61,
    TURNTABLE_RAY_62,
    TURNTABLE_RAY_63;

    public static final int NUM_SHAPE_POINTS = 10;
    public static final int NUM_BEZIER_CONTROL_POINTS = 9;

    protected static boolean isConnectionHitType(HitPointType hitType) {
        switch (hitType) {
            case POS_POINT: 
            case TURNOUT_A: 
            case TURNOUT_B: 
            case TURNOUT_C: 
            case TURNOUT_D: 
            case LEVEL_XING_A: 
            case LEVEL_XING_B: 
            case LEVEL_XING_C: 
            case LEVEL_XING_D: 
            case TRACK: 
            case SLIP_A: 
            case SLIP_B: 
            case SLIP_C: 
            case SLIP_D: {
                return true;
            }
            case NONE: 
            case TURNOUT_CENTER: 
            case LEVEL_XING_CENTER: 
            case TURNTABLE_CENTER: 
            case LAYOUT_POS_LABEL: 
            case LAYOUT_POS_JCOMP: 
            case MULTI_SENSOR: 
            case MARKER: 
            case TRACK_CIRCLE_CENTRE: 
            case SLIP_CENTER: 
            case SLIP_LEFT: 
            case SLIP_RIGHT: {
                return false;
            }
        }
        if (HitPointType.isBezierHitType(hitType)) {
            return false;
        }
        return HitPointType.isTurntableRayHitType(hitType);
    }

    protected static boolean isControlHitType(HitPointType hitType) {
        switch (hitType) {
            case TURNOUT_CENTER: 
            case SLIP_CENTER: 
            case SLIP_LEFT: 
            case SLIP_RIGHT: {
                return true;
            }
            case NONE: 
            case POS_POINT: 
            case TURNOUT_A: 
            case TURNOUT_B: 
            case TURNOUT_C: 
            case TURNOUT_D: 
            case LEVEL_XING_A: 
            case LEVEL_XING_B: 
            case LEVEL_XING_C: 
            case LEVEL_XING_D: 
            case TRACK: 
            case LEVEL_XING_CENTER: 
            case TURNTABLE_CENTER: 
            case LAYOUT_POS_LABEL: 
            case LAYOUT_POS_JCOMP: 
            case MULTI_SENSOR: 
            case MARKER: 
            case TRACK_CIRCLE_CENTRE: 
            case SLIP_A: 
            case SLIP_B: 
            case SLIP_C: 
            case SLIP_D: {
                return false;
            }
        }
        if (HitPointType.isBezierHitType(hitType)) {
            return false;
        }
        return HitPointType.isTurntableRayHitType(hitType);
    }

    protected static boolean isTurnoutHitType(HitPointType hitType) {
        return hitType.compareTo(TURNOUT_A) >= 0 && hitType.compareTo(TURNOUT_D) <= 0;
    }

    protected static boolean isSlipHitType(HitPointType hitType) {
        return hitType.compareTo(SLIP_A) >= 0 && hitType.compareTo(SLIP_RIGHT) <= 0;
    }

    protected static boolean isBezierHitType(HitPointType hitType) {
        return hitType.compareTo(BEZIER_CONTROL_POINT_0) >= 0 && hitType.compareTo(BEZIER_CONTROL_POINT_8) <= 0;
    }

    protected static boolean isLevelXingHitType(HitPointType hitType) {
        return hitType.compareTo(LEVEL_XING_A) >= 0 && hitType.compareTo(LEVEL_XING_D) <= 0;
    }

    protected static boolean isTurntableRayHitType(HitPointType hitType) {
        return hitType.compareTo(TURNTABLE_RAY_0) >= 0 && hitType.compareTo(TURNTABLE_RAY_63) <= 0;
    }

    protected static boolean isPopupHitType(HitPointType hitType) {
        switch (hitType) {
            case POS_POINT: 
            case TRACK: 
            case TURNOUT_CENTER: 
            case LEVEL_XING_CENTER: 
            case TURNTABLE_CENTER: 
            case TRACK_CIRCLE_CENTRE: 
            case SLIP_CENTER: 
            case SLIP_LEFT: 
            case SLIP_RIGHT: {
                return true;
            }
            case NONE: 
            case TURNOUT_A: 
            case TURNOUT_B: 
            case TURNOUT_C: 
            case TURNOUT_D: 
            case LEVEL_XING_A: 
            case LEVEL_XING_B: 
            case LEVEL_XING_C: 
            case LEVEL_XING_D: 
            case LAYOUT_POS_LABEL: 
            case LAYOUT_POS_JCOMP: 
            case MULTI_SENSOR: 
            case MARKER: 
            case SLIP_A: 
            case SLIP_B: 
            case SLIP_C: 
            case SLIP_D: {
                return false;
            }
        }
        if (HitPointType.isBezierHitType(hitType)) {
            return true;
        }
        return HitPointType.isTurntableRayHitType(hitType);
    }

    protected int turntableTrackIndex() {
        int result = this.ordinal() - TURNTABLE_RAY_0.ordinal();
        if (result < 0) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + "is not a valid TURNTABLE_RAY");
        }
        if (result > 63) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + "is not a valid TURNTABLE_RAY");
        }
        return result;
    }

    protected static HitPointType turntableTrackIndexedValue(int i) {
        if (i < 0 || i > 63) {
            throw new IllegalArgumentException(String.valueOf(i) + "is not a valid TURNTABLE_RAY index");
        }
        return HitPointType.values()[TURNTABLE_RAY_0.ordinal() + i];
    }

    protected static HitPointType[] turntableValues() {
        return new HitPointType[]{TURNTABLE_RAY_0, TURNTABLE_RAY_1, TURNTABLE_RAY_2, TURNTABLE_RAY_3, TURNTABLE_RAY_4, TURNTABLE_RAY_5, TURNTABLE_RAY_6, TURNTABLE_RAY_7, TURNTABLE_RAY_8, TURNTABLE_RAY_9, TURNTABLE_RAY_10, TURNTABLE_RAY_11, TURNTABLE_RAY_12, TURNTABLE_RAY_13, TURNTABLE_RAY_14, TURNTABLE_RAY_15, TURNTABLE_RAY_16, TURNTABLE_RAY_17, TURNTABLE_RAY_18, TURNTABLE_RAY_19, TURNTABLE_RAY_20, TURNTABLE_RAY_21, TURNTABLE_RAY_22, TURNTABLE_RAY_23, TURNTABLE_RAY_24, TURNTABLE_RAY_25, TURNTABLE_RAY_26, TURNTABLE_RAY_27, TURNTABLE_RAY_28, TURNTABLE_RAY_29, TURNTABLE_RAY_30, TURNTABLE_RAY_31, TURNTABLE_RAY_32, TURNTABLE_RAY_33, TURNTABLE_RAY_34, TURNTABLE_RAY_35, TURNTABLE_RAY_36, TURNTABLE_RAY_37, TURNTABLE_RAY_38, TURNTABLE_RAY_39, TURNTABLE_RAY_40, TURNTABLE_RAY_41, TURNTABLE_RAY_42, TURNTABLE_RAY_43, TURNTABLE_RAY_44, TURNTABLE_RAY_45, TURNTABLE_RAY_46, TURNTABLE_RAY_47, TURNTABLE_RAY_48, TURNTABLE_RAY_49, TURNTABLE_RAY_50, TURNTABLE_RAY_51, TURNTABLE_RAY_52, TURNTABLE_RAY_53, TURNTABLE_RAY_54, TURNTABLE_RAY_55, TURNTABLE_RAY_56, TURNTABLE_RAY_57, TURNTABLE_RAY_58, TURNTABLE_RAY_59, TURNTABLE_RAY_60, TURNTABLE_RAY_61, TURNTABLE_RAY_62, TURNTABLE_RAY_63};
    }

    protected int shapePointIndex() {
        int result = this.ordinal() - SHAPE_POINT_0.ordinal();
        if (result < 0) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + "is not a valid SHAPE_POINT");
        }
        if (result > 9) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + "is not a valid SHAPE_POINT");
        }
        return result;
    }

    protected static HitPointType shapePointIndexedValue(int i) {
        if (i < 0 || i > 9) {
            throw new IllegalArgumentException(String.valueOf(i) + "is not a valid SHAPE_POINT index");
        }
        return HitPointType.values()[SHAPE_POINT_0.ordinal() + i];
    }

    protected static HitPointType[] shapePointValues() {
        return new HitPointType[]{SHAPE_POINT_0, SHAPE_POINT_1, SHAPE_POINT_2, SHAPE_POINT_3, SHAPE_POINT_4, SHAPE_POINT_5, SHAPE_POINT_6, SHAPE_POINT_7, SHAPE_POINT_8, SHAPE_POINT_9};
    }

    protected static boolean isShapePointOffsetHitPointType(HitPointType t) {
        return t.compareTo(SHAPE_POINT_0) >= 0 && t.compareTo(SHAPE_POINT_9) <= 0;
    }

    protected int bezierPointIndex() {
        int result = this.ordinal() - BEZIER_CONTROL_POINT_0.ordinal();
        if (result < 0) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + "is not a valid BEZIER_CONTROL_POINT");
        }
        if (result > 8) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + "is not a valid BEZIER_CONTROL_POINT");
        }
        return result;
    }

    protected static HitPointType bezierPointIndexedValue(int i) {
        if (i < 0 || i > 8) {
            throw new IllegalArgumentException(String.valueOf(i) + "is not a valid BEZIER_CONTROL_POINT index");
        }
        return HitPointType.values()[BEZIER_CONTROL_POINT_0.ordinal() + i];
    }
}

