/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.blockboss.BlockBossLogic;
import jmri.jmrit.blockboss.BlockBossLogicProvider;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutConnectivity;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutEditorAuxTools;
import jmri.jmrit.display.layoutEditor.LayoutEditorTools;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackNode;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectivityUtil {
    private final LayoutEditor layoutEditor;
    private final LayoutEditorAuxTools auxTools;
    private final LayoutBlockManager layoutBlockManager;
    private final int TRACKNODE_CONTINUING = 0;
    private final int TRACKNODE_DIVERGING = 1;
    private final int TRACKNODE_DIVERGING_2ND_3WAY = 2;
    private final BlockBossLogicProvider blockBossLogicProvider;
    private TrackSegment trackSegment = null;
    private HitPointType prevConnectType = HitPointType.NONE;
    private LayoutTrack prevConnectTrack = null;
    private LayoutBlock currLayoutBlock = null;
    private LayoutBlock nextLayoutBlock = null;
    public static final int OVERALL = 0;
    public static final int CONTINUING = 1;
    public static final int DIVERGING = 2;
    private boolean turnoutConnectivity = true;
    private static final Logger log = LoggerFactory.getLogger(ConnectivityUtil.class);

    public ConnectivityUtil(LayoutEditor thePanel) {
        this.layoutEditor = thePanel;
        this.auxTools = this.layoutEditor.getLEAuxTools();
        this.layoutBlockManager = InstanceManager.getDefault(LayoutBlockManager.class);
        this.blockBossLogicProvider = InstanceManager.getDefault(BlockBossLogicProvider.class);
    }

    @Nonnull
    public List<LayoutTrackExpectedState<LayoutTurnout>> getTurnoutList(@CheckForNull Block currBlock, @CheckForNull Block prevBlock, @CheckForNull Block nextBlock) {
        return this.getTurnoutList(currBlock, prevBlock, nextBlock, false);
    }

    /*
     * Unable to fully structure code
     */
    @Nonnull
    public List<LayoutTrackExpectedState<LayoutTurnout>> getTurnoutList(@CheckForNull Block currBlock, @CheckForNull Block prevBlock, @CheckForNull Block nextBlock, boolean suppress) {
        result = new ArrayList<LayoutTrackExpectedState<LayoutTurnout>>();
        this.currLayoutBlock = null;
        currUserName = null;
        if (currBlock != null && (currUserName = currBlock.getUserName()) != null && !currUserName.isEmpty()) {
            this.currLayoutBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(currUserName);
        }
        prevLayoutBlock = null;
        if (prevBlock != null && (prevUserName = prevBlock.getUserName()) != null && !prevUserName.isEmpty()) {
            prevLayoutBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(prevUserName);
        }
        this.nextLayoutBlock = null;
        if (nextBlock != null && (nextUserName = nextBlock.getUserName()) != null && !nextUserName.isEmpty()) {
            this.nextLayoutBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(nextUserName);
        }
        this.turnoutConnectivity = true;
        if (prevLayoutBlock == null || this.nextLayoutBlock == null) {
            allTurnouts = this.getAllTurnoutsThisBlock(this.currLayoutBlock);
            for (LayoutTurnout lt : allTurnouts) {
                result.add(new LayoutTrackExpectedState<LayoutTurnout>(lt, lt.getConnectivityStateForLayoutBlocks(this.currLayoutBlock, prevLayoutBlock, this.nextLayoutBlock, true)));
            }
            return result;
        }
        cList = this.auxTools.getConnectivityList(this.currLayoutBlock);
        notFound = true;
        i = 0;
        while (i < cList.size() && notFound) {
            lc = cList.get(i);
            if (lc.getXover() != null && (lc.getBlock1() == this.currLayoutBlock && lc.getBlock2() == prevLayoutBlock || lc.getBlock1() == prevLayoutBlock && lc.getBlock2() == this.currLayoutBlock)) {
                xt = lc.getXover();
                setting = 4;
                this.trackSegment = null;
                this.prevConnectTrack = xt;
                switch (lc.getXoverBoundaryType()) {
                    case 1: {
                        setting = 2;
                        if ((TrackSegment)xt.getConnectA() != null && this.currLayoutBlock == ((TrackSegment)xt.getConnectA()).getLayoutBlock()) {
                            this.trackSegment = (TrackSegment)xt.getConnectA();
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            break;
                        }
                        if ((TrackSegment)xt.getConnectB() == null || this.currLayoutBlock != ((TrackSegment)xt.getConnectB()).getLayoutBlock()) break;
                        this.trackSegment = (TrackSegment)xt.getConnectB();
                        this.prevConnectType = HitPointType.TURNOUT_B;
                        break;
                    }
                    case 2: {
                        setting = 2;
                        if ((TrackSegment)xt.getConnectC() != null && this.currLayoutBlock == ((TrackSegment)xt.getConnectC()).getLayoutBlock()) {
                            this.trackSegment = (TrackSegment)xt.getConnectC();
                            this.prevConnectType = HitPointType.TURNOUT_C;
                            break;
                        }
                        if ((TrackSegment)xt.getConnectD() == null || this.currLayoutBlock != ((TrackSegment)xt.getConnectD()).getLayoutBlock()) break;
                        this.trackSegment = (TrackSegment)xt.getConnectD();
                        this.prevConnectType = HitPointType.TURNOUT_D;
                        break;
                    }
                    case 3: {
                        if ((TrackSegment)xt.getConnectA() != null && this.currLayoutBlock == ((TrackSegment)xt.getConnectA()).getLayoutBlock()) {
                            this.trackSegment = (TrackSegment)xt.getConnectA();
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            break;
                        }
                        if ((TrackSegment)xt.getConnectC() == null || this.currLayoutBlock != ((TrackSegment)xt.getConnectC()).getLayoutBlock()) break;
                        this.trackSegment = (TrackSegment)xt.getConnectC();
                        this.prevConnectType = HitPointType.TURNOUT_C;
                        break;
                    }
                    case 4: {
                        if ((TrackSegment)xt.getConnectB() != null && this.currLayoutBlock == ((TrackSegment)xt.getConnectB()).getLayoutBlock()) {
                            this.trackSegment = (TrackSegment)xt.getConnectB();
                            this.prevConnectType = HitPointType.TURNOUT_B;
                            break;
                        }
                        if ((TrackSegment)xt.getConnectD() == null || this.currLayoutBlock != ((TrackSegment)xt.getConnectD()).getLayoutBlock()) break;
                        this.trackSegment = (TrackSegment)xt.getConnectD();
                        this.prevConnectType = HitPointType.TURNOUT_D;
                        break;
                    }
                    default: {
                        ConnectivityUtil.log.error("Unhandled crossover boundary type: {}", (Object)lc.getXoverBoundaryType());
                    }
                }
                result.add(new LayoutTrackExpectedState<LayoutTurnout>(xt, setting));
                notFound = false;
            } else if (lc.getBlock1() == this.currLayoutBlock && lc.getBlock2() == prevLayoutBlock) {
                this.trackSegment = lc.getTrackSegment();
                if (lc.getConnectedType() == HitPointType.TRACK) {
                    this.prevConnectType = HitPointType.POS_POINT;
                    this.prevConnectTrack = lc.getAnchor();
                } else {
                    this.prevConnectType = lc.getConnectedType();
                    this.prevConnectTrack = lc.getConnectedObject();
                }
                notFound = false;
            } else if (lc.getBlock2() == this.currLayoutBlock && lc.getBlock1() == prevLayoutBlock) {
                cType = lc.getConnectedType();
                if (cType == HitPointType.TRACK) {
                    this.trackSegment = (TrackSegment)lc.getConnectedObject();
                    this.prevConnectType = HitPointType.POS_POINT;
                    this.prevConnectTrack = lc.getAnchor();
                } else if (HitPointType.isLevelXingHitType(cType)) {
                    this.setupOpposingTrackSegment((LevelXing)lc.getConnectedObject(), cType);
                } else if (HitPointType.isTurnoutHitType(cType)) {
                    result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)lc.getConnectedObject(), this.getTurnoutSetting((LayoutTurnout)lc.getConnectedObject(), cType, suppress)));
                } else if (HitPointType.isSlipHitType(cType)) {
                    result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)lc.getConnectedObject(), this.getTurnoutSetting((LayoutTurnout)lc.getConnectedObject(), cType, suppress)));
                }
                notFound = false;
            }
            ++i;
        }
        if (!notFound) ** GOTO lbl322
        if (prevBlock != null) {
            if (!suppress) {
                ConnectivityUtil.log.warn("Could not find connection between Blocks {} and {}", (Object)currUserName, (Object)prevBlock.getUserName());
            }
        } else if (!suppress) {
            ConnectivityUtil.log.warn("Could not find connection between Blocks {}, prevBock is null!", (Object)currUserName);
        }
        return result;
lbl-1000:
        // 1 sources

        {
            if (this.trackSegment.getConnect1() == this.prevConnectTrack && this.trackSegment.getType1() == this.prevConnectType) {
                cType = this.trackSegment.getType2();
                cObject = this.trackSegment.getConnect2();
            } else if (this.trackSegment.getConnect2() == this.prevConnectTrack && this.trackSegment.getType2() == this.prevConnectType) {
                cType = this.trackSegment.getType1();
                cObject = this.trackSegment.getConnect1();
            } else {
                if (!suppress) {
                    ConnectivityUtil.log.error("Connectivity error when searching turnouts in Block {}", (Object)this.currLayoutBlock.getDisplayName());
                    ConnectivityUtil.log.warn("Track segment connected to {{}, {}} and {{}, {}} but previous object was {{}, {}}", new Object[]{this.trackSegment.getConnect1(), this.trackSegment.getType1().name(), this.trackSegment.getConnect2(), this.trackSegment.getType2().name(), this.prevConnectTrack, this.prevConnectType});
                }
                this.trackSegment = null;
                break;
            }
            if (cType == HitPointType.POS_POINT) {
                if (((PositionablePoint)cObject).getType() == PositionablePoint.PointType.END_BUMPER) {
                    this.trackSegment = null;
                    continue;
                }
                if (((PositionablePoint)cObject).getType() != PositionablePoint.PointType.ANCHOR && ((PositionablePoint)cObject).getType() != PositionablePoint.PointType.EDGE_CONNECTOR) continue;
                this.trackSegment = ((PositionablePoint)cObject).getConnect1() == this.trackSegment ? ((PositionablePoint)cObject).getConnect2() : ((PositionablePoint)cObject).getConnect1();
                if (this.trackSegment == null || this.trackSegment.getLayoutBlock() != this.currLayoutBlock) {
                    this.trackSegment = null;
                    continue;
                }
                this.prevConnectType = cType;
                this.prevConnectTrack = cObject;
                continue;
            }
            if (HitPointType.isLevelXingHitType(cType)) {
                switch (ConnectivityUtil.$SWITCH_TABLE$jmri$jmrit$display$layoutEditor$HitPointType()[cType.ordinal()]) {
                    case 7: 
                    case 9: {
                        if (((LevelXing)cObject).getLayoutBlockAC() != this.currLayoutBlock) {
                            this.trackSegment = null;
                            break;
                        }
                        this.setupOpposingTrackSegment((LevelXing)cObject, cType);
                        break;
                    }
                    case 8: 
                    case 10: {
                        if (((LevelXing)cObject).getLayoutBlockBD() != this.currLayoutBlock) {
                            this.trackSegment = null;
                            break;
                        }
                        this.setupOpposingTrackSegment((LevelXing)cObject, cType);
                        break;
                    }
                    default: {
                        ConnectivityUtil.log.warn("Unhandled Level Crossing type: {}", (Object)cType);
                        break;
                    }
                }
                continue;
            }
            if (HitPointType.isTurnoutHitType(cType)) {
                lt = (LayoutTurnout)cObject;
                tType = lt.getTurnoutType();
                if (LayoutTurnout.isTurnoutTypeXover(tType)) {
                    switch (ConnectivityUtil.$SWITCH_TABLE$jmri$jmrit$display$layoutEditor$HitPointType()[cType.ordinal()]) {
                        case 3: {
                            if (lt.getLayoutBlock() != this.currLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockB() == this.nextLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockC() == this.nextLayoutBlock && tType != LayoutTurnout.TurnoutType.LH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockB() == this.currLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = (TrackSegment)lt.getConnectB();
                                this.prevConnectType = HitPointType.TURNOUT_B;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlockC() == this.currLayoutBlock && tType != LayoutTurnout.TurnoutType.LH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = (TrackSegment)lt.getConnectC();
                                this.prevConnectType = HitPointType.TURNOUT_C;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlock() == this.currLayoutBlock && this.currLayoutBlock == this.nextLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (!suppress) {
                                ConnectivityUtil.log.warn("Connectivity mismatch at A in turnout {}", (Object)lt.getTurnoutName());
                            }
                            this.trackSegment = null;
                            break;
                        }
                        case 4: {
                            if (lt.getLayoutBlockB() != this.currLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlock() == this.nextLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockD() == this.nextLayoutBlock && tType != LayoutTurnout.TurnoutType.RH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlock() == this.currLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = (TrackSegment)lt.getConnectA();
                                this.prevConnectType = HitPointType.TURNOUT_A;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlockD() == this.currLayoutBlock && tType != LayoutTurnout.TurnoutType.RH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = (TrackSegment)lt.getConnectD();
                                this.prevConnectType = HitPointType.TURNOUT_D;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlockB() == this.currLayoutBlock && this.currLayoutBlock == this.nextLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (!suppress) {
                                ConnectivityUtil.log.warn("Connectivity mismatch at B in turnout {}", (Object)lt.getTurnoutName());
                            }
                            this.trackSegment = null;
                            break;
                        }
                        case 5: {
                            if (lt.getLayoutBlockC() != this.currLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockD() == this.nextLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlock() == this.nextLayoutBlock && tType != LayoutTurnout.TurnoutType.LH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockD() == this.currLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = (TrackSegment)lt.getConnectD();
                                this.prevConnectType = HitPointType.TURNOUT_D;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlock() == this.currLayoutBlock && tType != LayoutTurnout.TurnoutType.LH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = (TrackSegment)lt.getConnectA();
                                this.prevConnectType = HitPointType.TURNOUT_A;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlockC() == this.currLayoutBlock && this.currLayoutBlock == this.nextLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (!suppress) {
                                ConnectivityUtil.log.warn("Connectivity mismatch at C in turnout {}", (Object)lt.getTurnoutName());
                            }
                            this.trackSegment = null;
                            break;
                        }
                        case 6: {
                            if (lt.getLayoutBlockD() != this.currLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockC() == this.nextLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockB() == this.nextLayoutBlock && tType != LayoutTurnout.TurnoutType.RH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = null;
                                break;
                            }
                            if (lt.getLayoutBlockC() == this.currLayoutBlock) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 2));
                                this.trackSegment = (TrackSegment)lt.getConnectC();
                                this.prevConnectType = HitPointType.TURNOUT_C;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlockB() == this.currLayoutBlock && tType != LayoutTurnout.TurnoutType.RH_XOVER) {
                                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, 4));
                                this.trackSegment = (TrackSegment)lt.getConnectB();
                                this.prevConnectType = HitPointType.TURNOUT_B;
                                this.prevConnectTrack = cObject;
                                break;
                            }
                            if (lt.getLayoutBlockD() == this.currLayoutBlock && this.currLayoutBlock == this.nextLayoutBlock) {
                                this.trackSegment = null;
                                break;
                            }
                            if (!suppress) {
                                ConnectivityUtil.log.warn("Connectivity mismatch at D in turnout {}", (Object)lt.getTurnoutName());
                            }
                            this.trackSegment = null;
                            break;
                        }
                        default: {
                            ConnectivityUtil.log.warn("Unhandled crossover type: {}", (Object)cType);
                            break;
                        }
                    }
                    continue;
                }
                if (!LayoutTurnout.isTurnoutTypeTurnout(tType)) continue;
                if (lt.getLayoutBlock() != this.currLayoutBlock) {
                    this.trackSegment = null;
                    continue;
                }
                result.add(new LayoutTrackExpectedState<LayoutTurnout>((LayoutTurnout)cObject, this.getTurnoutSetting(lt, cType, suppress)));
                continue;
            }
            if (HitPointType.isSlipHitType(cType)) {
                ls = (LayoutSlip)cObject;
                if (cType == HitPointType.SLIP_A && ls.getLayoutBlock() != this.currLayoutBlock || cType == HitPointType.SLIP_B && ls.getLayoutBlockB() != this.currLayoutBlock || cType == HitPointType.SLIP_C && ls.getLayoutBlockC() != this.currLayoutBlock || cType == HitPointType.SLIP_D && ls.getLayoutBlockD() != this.currLayoutBlock) {
                    this.trackSegment = null;
                    continue;
                }
                result.add(new LayoutTrackExpectedState<LayoutSlip>(ls, this.getTurnoutSetting(ls, cType, suppress)));
                continue;
            }
            if (!HitPointType.isTurntableRayHitType(cType)) continue;
            this.trackSegment = null;
lbl322:
            // 14 sources

            ** while (this.trackSegment != null)
        }
lbl323:
        // 2 sources

        return result;
    }

    @Nonnull
    public List<Block> getConnectedBlocks(@Nonnull Block block) {
        ArrayList<Block> result = new ArrayList<Block>();
        List<LayoutConnectivity> cList = this.auxTools.getConnectivityList(this.currLayoutBlock);
        for (LayoutConnectivity lc : cList) {
            if (lc.getBlock1().getBlock() == block) {
                result.add(lc.getBlock2().getBlock());
                continue;
            }
            if (lc.getBlock2().getBlock() != block) continue;
            result.add(lc.getBlock1().getBlock());
        }
        return result;
    }

    @Nonnull
    public List<PositionablePoint> getAnchorBoundariesThisBlock(@Nonnull Block block) {
        ArrayList<PositionablePoint> result = new ArrayList<PositionablePoint>();
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        for (PositionablePoint p : this.layoutEditor.getPositionablePoints()) {
            if (p.getConnect2() == null || p.getConnect1() == null || p.getConnect2().getLayoutBlock() == null || p.getConnect1().getLayoutBlock() == null || (p.getConnect1().getLayoutBlock() != lBlock || p.getConnect2().getLayoutBlock() == lBlock) && (p.getConnect1().getLayoutBlock() == lBlock || p.getConnect2().getLayoutBlock() != lBlock)) continue;
            result.add(p);
        }
        return result;
    }

    @Nonnull
    public List<LevelXing> getLevelCrossingsThisBlock(@Nonnull Block block) {
        ArrayList<LevelXing> result = new ArrayList<LevelXing>();
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        for (LevelXing x : this.layoutEditor.getLevelXings()) {
            boolean found = false;
            if (x.getLayoutBlockAC() == lBlock || x.getLayoutBlockBD() == lBlock) {
                found = true;
            } else if (x.getConnectA() != null && ((TrackSegment)x.getConnectA()).getLayoutBlock() == lBlock) {
                found = true;
            } else if (x.getConnectB() != null && ((TrackSegment)x.getConnectB()).getLayoutBlock() == lBlock) {
                found = true;
            } else if (x.getConnectC() != null && ((TrackSegment)x.getConnectC()).getLayoutBlock() == lBlock) {
                found = true;
            } else if (x.getConnectD() != null && ((TrackSegment)x.getConnectD()).getLayoutBlock() == lBlock) {
                found = true;
            }
            if (!found) continue;
            if (x.getConnectA() != null && ((TrackSegment)x.getConnectA()).getLayoutBlock() != null && x.getConnectB() != null && ((TrackSegment)x.getConnectB()).getLayoutBlock() != null && x.getConnectC() != null && ((TrackSegment)x.getConnectC()).getLayoutBlock() != null && x.getConnectD() != null && ((TrackSegment)x.getConnectD()).getLayoutBlock() != null && x.getLayoutBlockAC() != null && x.getLayoutBlockBD() != null) {
                result.add(x);
                continue;
            }
            log.error("Missing connection or block assignment at Level Crossing in Block {}", (Object)block.getDisplayName());
        }
        return result;
    }

    @Nonnull
    public List<LayoutTurnout> getLayoutTurnoutsThisBlock(@Nonnull Block block) {
        ArrayList<LayoutTurnout> result = new ArrayList<LayoutTurnout>();
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        for (LayoutTurnout t : this.layoutEditor.getLayoutTurnouts()) {
            if (t.getBlockName().equals(userName) || t.getBlockBName().equals(userName) || t.getBlockCName().equals(userName) || t.getBlockDName().equals(userName)) {
                result.add(t);
                continue;
            }
            if (t.getConnectA() != null && ((TrackSegment)t.getConnectA()).getLayoutBlock() == lBlock) {
                result.add(t);
                continue;
            }
            if (t.getConnectB() != null && ((TrackSegment)t.getConnectB()).getLayoutBlock() == lBlock) {
                result.add(t);
                continue;
            }
            if (t.getConnectC() != null && ((TrackSegment)t.getConnectC()).getLayoutBlock() == lBlock) {
                result.add(t);
                continue;
            }
            if (t.getConnectD() == null || ((TrackSegment)t.getConnectD()).getLayoutBlock() != lBlock) continue;
            result.add(t);
        }
        for (LayoutTurnout ls : this.layoutEditor.getLayoutTurnouts()) {
            if (ls.getBlockName().equals(userName)) {
                result.add(ls);
                continue;
            }
            if (ls.getConnectA() != null && ((TrackSegment)ls.getConnectA()).getLayoutBlock() == lBlock) {
                result.add(ls);
                continue;
            }
            if (ls.getConnectB() != null && ((TrackSegment)ls.getConnectB()).getLayoutBlock() == lBlock) {
                result.add(ls);
                continue;
            }
            if (ls.getConnectC() != null && ((TrackSegment)ls.getConnectC()).getLayoutBlock() == lBlock) {
                result.add(ls);
                continue;
            }
            if (ls.getConnectD() == null || ((TrackSegment)ls.getConnectD()).getLayoutBlock() != lBlock) continue;
            result.add(ls);
        }
        if (log.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder("Turnouts for Block ");
            txt.append(block.getUserName()).append(" - ");
            int k = 0;
            while (k < result.size()) {
                if (k > 0) {
                    txt.append(", ");
                }
                if (((LayoutTurnout)result.get(k)).getTurnout() != null) {
                    txt.append(((LayoutTurnout)result.get(k)).getTurnout().getSystemName());
                } else {
                    txt.append("???");
                }
                ++k;
            }
            log.error("Turnouts for Block {}", (Object)txt.toString());
        }
        return result;
    }

    public boolean layoutTurnoutHasRequiredSignals(@Nonnull LayoutTurnout t) {
        switch (t.getLinkType()) {
            case NO_LINK: {
                if (t.isTurnoutTypeTurnout()) {
                    return !t.getSignalA1Name().isEmpty() && !t.getSignalB1Name().isEmpty() && !t.getSignalC1Name().isEmpty();
                }
                if (t.isTurnoutTypeSlip()) {
                    if (!(t.getSignalA1Name().isEmpty() || t.getSignalA2Name().isEmpty() || t.getSignalB1Name().isEmpty() || t.getSignalC1Name().isEmpty() || t.getSignalD1Name().isEmpty() || t.getSignalD2Name().isEmpty())) {
                        if (t.getTurnoutType() == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                            return true;
                        }
                        if (t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP && !t.getSignalB2Name().isEmpty() && !t.getSignalC2Name().isEmpty()) {
                            return true;
                        }
                    }
                    return false;
                }
                return !t.getSignalA1Name().isEmpty() && !t.getSignalB1Name().isEmpty() && !t.getSignalC1Name().isEmpty() && !t.getSignalD1Name().isEmpty();
            }
            case FIRST_3_WAY: {
                return !t.getSignalA1Name().isEmpty() && !t.getSignalC1Name().isEmpty();
            }
            case SECOND_3_WAY: 
            case THROAT_TO_THROAT: {
                return !t.getSignalB1Name().isEmpty() && !t.getSignalC1Name().isEmpty();
            }
        }
        return false;
    }

    @CheckReturnValue
    @CheckForNull
    public SignalHead getSignalHeadAtAnchor(@CheckForNull PositionablePoint p, @CheckForNull Block block, boolean facing) {
        if (p == null || block == null) {
            log.error("null arguments in call to getSignalHeadAtAnchor");
            return null;
        }
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        if (p.getConnect1().getLayoutBlock() == lBlock && p.getConnect2().getLayoutBlock() != lBlock) {
            if (LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect2(), p) && facing || !LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect2(), p) && !facing) {
                return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(p.getWestBoundSignal());
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(p.getEastBoundSignal());
        }
        if (p.getConnect1().getLayoutBlock() != lBlock && p.getConnect2().getLayoutBlock() == lBlock) {
            if (LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect1(), p) && facing || !LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect1(), p) && !facing) {
                return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(p.getWestBoundSignal());
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(p.getEastBoundSignal());
        }
        return null;
    }

    @CheckReturnValue
    @CheckForNull
    public SignalMast getSignalMastAtAnchor(@CheckForNull PositionablePoint p, @CheckForNull Block block, boolean facing) {
        if (p == null || block == null) {
            log.error("null arguments in call to getSignalHeadAtAnchor");
            return null;
        }
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        if (p.getConnect1().getLayoutBlock() == lBlock && p.getConnect2().getLayoutBlock() != lBlock) {
            if (LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect2(), p) && facing || !LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect2(), p) && !facing) {
                return InstanceManager.getDefault(SignalMastManager.class).getSignalMast(p.getWestBoundSignalMastName());
            }
            return InstanceManager.getDefault(SignalMastManager.class).getSignalMast(p.getEastBoundSignalMastName());
        }
        if (p.getConnect1().getLayoutBlock() != lBlock && p.getConnect2().getLayoutBlock() == lBlock) {
            if (LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect1(), p) && facing || !LayoutEditorTools.isAtWestEndOfAnchor(this.layoutEditor, p.getConnect1(), p) && !facing) {
                return InstanceManager.getDefault(SignalMastManager.class).getSignalMast(p.getWestBoundSignalMastName());
            }
            return InstanceManager.getDefault(SignalMastManager.class).getSignalMast(p.getEastBoundSignalMastName());
        }
        return null;
    }

    public boolean layoutTurnoutHasSignalMasts(@Nonnull LayoutTurnout t) {
        String[] turnoutBlocks = t.getBlockBoundaries();
        boolean valid = true;
        if (turnoutBlocks[0] != null && t.getSignalAMastName().isEmpty()) {
            valid = false;
        }
        if (turnoutBlocks[1] != null && t.getSignalBMastName().isEmpty()) {
            valid = false;
        }
        if (turnoutBlocks[2] != null && t.getSignalCMastName().isEmpty()) {
            valid = false;
        }
        if (turnoutBlocks[3] != null && t.getSignalDMastName().isEmpty()) {
            valid = false;
        }
        return valid;
    }

    @CheckReturnValue
    @CheckForNull
    public SignalHead getSignalHeadAtLevelXing(@CheckForNull LevelXing x, @CheckForNull Block block, boolean facing) {
        if (x == null || block == null) {
            log.error("null arguments in call to getSignalHeadAtLevelXing");
            return null;
        }
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        if (x.getConnectA() == null || x.getConnectB() == null || x.getConnectC() == null || x.getConnectD() == null) {
            log.error("Missing track around level crossing near Block {}", (Object)block.getUserName());
            return null;
        }
        if (((TrackSegment)x.getConnectA()).getLayoutBlock() == lBlock) {
            if (facing) {
                return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalCName());
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalAName());
        }
        if (((TrackSegment)x.getConnectB()).getLayoutBlock() == lBlock) {
            if (facing) {
                return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalDName());
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalBName());
        }
        if (((TrackSegment)x.getConnectC()).getLayoutBlock() == lBlock) {
            if (facing) {
                return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalAName());
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalCName());
        }
        if (((TrackSegment)x.getConnectD()).getLayoutBlock() == lBlock) {
            if (facing) {
                return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalBName());
            }
            return InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(x.getSignalDName());
        }
        return null;
    }

    public boolean blockInternalToLevelXing(@CheckForNull LevelXing x, @CheckForNull Block block) {
        if (x == null || block == null) {
            return false;
        }
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        if (lBlock == null) {
            return false;
        }
        if (x.getConnectA() == null || x.getConnectB() == null || x.getConnectC() == null || x.getConnectD() == null) {
            return false;
        }
        if (x.getLayoutBlockAC() != lBlock && x.getLayoutBlockBD() != lBlock) {
            return false;
        }
        if (((TrackSegment)x.getConnectA()).getLayoutBlock() == lBlock) {
            return false;
        }
        if (((TrackSegment)x.getConnectB()).getLayoutBlock() == lBlock) {
            return false;
        }
        if (((TrackSegment)x.getConnectC()).getLayoutBlock() == lBlock) {
            return false;
        }
        return ((TrackSegment)x.getConnectD()).getLayoutBlock() != lBlock;
    }

    public int getDirectionFromAnchor(@Nonnull List<EntryPoint> mForwardEntryPoints, @Nonnull List<EntryPoint> mReverseEntryPoints, @Nonnull PositionablePoint p) {
        Block block1 = p.getConnect1().getLayoutBlock().getBlock();
        Block block2 = p.getConnect2().getLayoutBlock().getBlock();
        for (EntryPoint ep : mForwardEntryPoints) {
            if ((ep.getBlock() != block1 || ep.getFromBlock() != block2) && (ep.getBlock() != block2 || ep.getFromBlock() != block1)) continue;
            return 4;
        }
        for (EntryPoint ep : mReverseEntryPoints) {
            if ((ep.getBlock() != block1 || ep.getFromBlock() != block2) && (ep.getBlock() != block2 || ep.getFromBlock() != block1)) continue;
            return 8;
        }
        return 2;
    }

    public boolean isInternalLevelXingAC(@Nonnull LevelXing x, @Nonnull Block block) {
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        if (((TrackSegment)x.getConnectA()).getLayoutBlock() == lBlock && ((TrackSegment)x.getConnectC()).getLayoutBlock() == lBlock) {
            if (x.getLayoutBlockAC() == lBlock) {
                return true;
            }
            log.error("Panel blocking error at AC of Level Crossing in Block {}", (Object)block.getUserName());
            return false;
        }
        return false;
    }

    public boolean isInternalLevelXingBD(@Nonnull LevelXing x, @Nonnull Block block) {
        String userName = block.getUserName();
        LayoutBlock lBlock = null;
        if (userName != null && !userName.isEmpty()) {
            lBlock = (LayoutBlock)this.layoutBlockManager.getByUserName(userName);
        }
        if (((TrackSegment)x.getConnectB()).getLayoutBlock() == lBlock && ((TrackSegment)x.getConnectD()).getLayoutBlock() == lBlock) {
            if (x.getLayoutBlockBD() == lBlock) {
                return true;
            }
            log.error("Panel blocking error at BD of Level Crossing in Block {}", (Object)block.getDisplayName());
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addSensorToSignalHeadLogic(@CheckForNull String name, @CheckForNull SignalHead sh, int where) {
        BlockBossLogic bbLogic;
        block19: {
            int mode;
            block20: {
                block22: {
                    block21: {
                        if (sh == null) {
                            log.error("Null signal head on entry to addSensorToSignalHeadLogic");
                            return false;
                        }
                        if (name == null || name.isEmpty()) {
                            log.error("Null string for sensor name on entry to addSensorToSignalHeadLogic");
                            return false;
                        }
                        bbLogic = BlockBossLogic.getStoppedObject(sh.getSystemName());
                        mode = bbLogic.getMode();
                        if (mode != 1 && mode != 2 && mode != 3 && (mode != 4 || where != 0)) break block20;
                        if (bbLogic.getSensor1() != null && bbLogic.getSensor1().equals(name) || bbLogic.getSensor2() != null && bbLogic.getSensor2().equals(name) || bbLogic.getSensor3() != null && bbLogic.getSensor3().equals(name) || bbLogic.getSensor4() != null && bbLogic.getSensor4().equals(name) || bbLogic.getSensor5() != null && bbLogic.getSensor5().equals(name)) {
                            this.blockBossLogicProvider.register(bbLogic);
                            bbLogic.start();
                            return true;
                        }
                        if (bbLogic.getSensor1() != null) break block21;
                        bbLogic.setSensor1(name);
                        break block19;
                    }
                    if (bbLogic.getSensor2() != null) break block22;
                    bbLogic.setSensor2(name);
                    break block19;
                }
                if (bbLogic.getSensor3() == null) {
                    bbLogic.setSensor3(name);
                    break block19;
                } else if (bbLogic.getSensor4() == null) {
                    bbLogic.setSensor4(name);
                    break block19;
                } else {
                    if (bbLogic.getSensor5() != null) {
                        log.error("could not add sensor to SSL for signal head {} because there is no room in the SSL.", (Object)sh.getDisplayName());
                        this.blockBossLogicProvider.register(bbLogic);
                        bbLogic.start();
                        return false;
                    }
                    bbLogic.setSensor5(name);
                }
                break block19;
            }
            if (mode != 4) {
                log.error("SSL has not been set up for signal head {}. Could not add sensor - {}.", (Object)sh.getDisplayName(), (Object)name);
                return false;
            }
            switch (where) {
                case 2: {
                    if (bbLogic.getWatchedSensor2() != null && bbLogic.getWatchedSensor2().equals(name) || bbLogic.getWatchedSensor2Alt() != null && bbLogic.getWatchedSensor2Alt().equals(name)) {
                        this.blockBossLogicProvider.register(bbLogic);
                        bbLogic.start();
                        return true;
                    }
                    if (bbLogic.getWatchedSensor2() == null) {
                        bbLogic.setWatchedSensor2(name);
                        break;
                    }
                    if (bbLogic.getWatchedSensor2Alt() != null) {
                        log.error("could not add watched sensor to SSL for signal head {} because there is no room in the facing SSL diverging part.", (Object)sh.getSystemName());
                        this.blockBossLogicProvider.register(bbLogic);
                        bbLogic.start();
                        return false;
                    }
                    bbLogic.setWatchedSensor2Alt(name);
                    break;
                }
                case 1: {
                    if (bbLogic.getWatchedSensor1() != null && bbLogic.getWatchedSensor1().equals(name) || bbLogic.getWatchedSensor1Alt() != null && bbLogic.getWatchedSensor1Alt().equals(name)) {
                        this.blockBossLogicProvider.register(bbLogic);
                        bbLogic.start();
                        return true;
                    }
                    if (bbLogic.getWatchedSensor1() == null) {
                        bbLogic.setWatchedSensor1(name);
                        break;
                    }
                    if (bbLogic.getWatchedSensor1Alt() != null) {
                        log.error("could not add watched sensor to SSL for signal head {} because there is no room in the facing SSL continuing part.", (Object)sh.getSystemName());
                        this.blockBossLogicProvider.register(bbLogic);
                        bbLogic.start();
                        return false;
                    }
                    bbLogic.setWatchedSensor1Alt(name);
                    break;
                }
                default: {
                    log.error("could not add watched sensor to SSL for signal head {}because 'where' to place the sensor was not correctly designated.", (Object)sh.getSystemName());
                    this.blockBossLogicProvider.register(bbLogic);
                    bbLogic.start();
                    return false;
                }
            }
        }
        this.blockBossLogicProvider.register(bbLogic);
        bbLogic.start();
        return true;
    }

    public boolean removeSensorsFromSignalHeadLogic(@CheckForNull List<String> names, @CheckForNull SignalHead sh) {
        if (sh == null) {
            log.error("Null signal head on entry to removeSensorsFromSignalHeadLogic");
            return false;
        }
        if (names == null) {
            log.error("Null List of sensor names on entry to removeSensorsFromSignalHeadLogic");
            return false;
        }
        BlockBossLogic bbLogic = BlockBossLogic.getStoppedObject(sh.getSystemName());
        for (String name : names) {
            if (bbLogic.getSensor1() != null && bbLogic.getSensor1().equals(name)) {
                bbLogic.setSensor1(null);
            }
            if (bbLogic.getSensor2() != null && bbLogic.getSensor2().equals(name)) {
                bbLogic.setSensor2(null);
            }
            if (bbLogic.getSensor3() != null && bbLogic.getSensor3().equals(name)) {
                bbLogic.setSensor3(null);
            }
            if (bbLogic.getSensor4() != null && bbLogic.getSensor4().equals(name)) {
                bbLogic.setSensor4(null);
            }
            if (bbLogic.getSensor5() != null && bbLogic.getSensor5().equals(name)) {
                bbLogic.setSensor5(null);
            }
            if (bbLogic.getMode() != 4) continue;
            if (bbLogic.getWatchedSensor1() != null && bbLogic.getWatchedSensor1().equals(name)) {
                bbLogic.setWatchedSensor1(null);
            }
            if (bbLogic.getWatchedSensor1Alt() != null && bbLogic.getWatchedSensor1Alt().equals(name)) {
                bbLogic.setWatchedSensor1Alt(null);
            }
            if (bbLogic.getWatchedSensor2() != null && bbLogic.getWatchedSensor2().equals(name)) {
                bbLogic.setWatchedSensor2(null);
            }
            if (bbLogic.getWatchedSensor2Alt() == null || !bbLogic.getWatchedSensor2Alt().equals(name)) continue;
            bbLogic.setWatchedSensor2Alt(null);
        }
        if (bbLogic.getMode() == 0) {
            bbLogic.setMode(1);
        }
        this.blockBossLogicProvider.register(bbLogic);
        bbLogic.start();
        return true;
    }

    @CheckReturnValue
    @CheckForNull
    public TrackNode getNextNode(@CheckForNull TrackNode currentNode, int currentNodeType) {
        if (currentNode == null) {
            log.error("getNextNode called with a null Track Node");
            return null;
        }
        if (currentNode.reachedEndOfTrack()) {
            log.error("getNextNode - attempt to search past endBumper");
            return null;
        }
        return this.getTrackNode(currentNode.getNode(), currentNode.getNodeType(), currentNode.getTrackSegment(), currentNodeType);
    }

    @CheckReturnValue
    @CheckForNull
    public TrackNode getTrackNode(@Nonnull LayoutTrack currentNode, HitPointType currentNodeType, @CheckForNull TrackSegment currentTrackSegment, int currentNodeState) {
        LayoutTrack prevTrack = currentNode;
        TrackSegment nextTrackSegment = currentTrackSegment;
        block0 : switch (currentNodeType) {
            case POS_POINT: {
                if (currentNode instanceof PositionablePoint) {
                    PositionablePoint p = (PositionablePoint)currentNode;
                    if (p.getType() == PositionablePoint.PointType.END_BUMPER) {
                        log.warn("Attempt to search beyond end of track");
                        return null;
                    }
                    nextTrackSegment = p.getConnect1();
                    if (nextTrackSegment != null) break;
                    nextTrackSegment = p.getConnect2();
                    break;
                }
                log.warn("currentNodeType wrong for currentNode");
                break;
            }
            case TURNOUT_A: {
                LayoutTurnout lto;
                LayoutTurnout lt;
                if (currentNode instanceof LayoutTurnout) {
                    lt = (LayoutTurnout)currentNode;
                    if (lt.isTurnoutTypeTurnout()) {
                        if (lt.getLinkedTurnoutName() == null || lt.getLinkedTurnoutName().isEmpty()) {
                            if (lt.getContinuingSense() == 2) {
                                switch (currentNodeState) {
                                    case 0: {
                                        nextTrackSegment = (TrackSegment)lt.getConnectB();
                                        break block0;
                                    }
                                    case 1: {
                                        nextTrackSegment = (TrackSegment)lt.getConnectC();
                                        break block0;
                                    }
                                }
                                log.error("Bad currentNodeState when searching track-std. normal");
                                return null;
                            }
                            switch (currentNodeState) {
                                case 0: {
                                    nextTrackSegment = (TrackSegment)lt.getConnectC();
                                    break block0;
                                }
                                case 1: {
                                    nextTrackSegment = (TrackSegment)lt.getConnectB();
                                    break block0;
                                }
                            }
                            log.error("Bad currentNodeType argument when searching track-std reversed");
                            return null;
                        }
                        lto = this.layoutEditor.getFinder().findLayoutTurnoutByName(lt.getLinkedTurnoutName());
                        if (lt.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                            switch (currentNodeState) {
                                case 0: {
                                    if (lto.getContinuingSense() == 2) {
                                        nextTrackSegment = (TrackSegment)lto.getConnectB();
                                        break;
                                    }
                                    nextTrackSegment = (TrackSegment)lto.getConnectC();
                                    break;
                                }
                                case 1: {
                                    if (lto.getContinuingSense() == 2) {
                                        nextTrackSegment = (TrackSegment)lto.getConnectC();
                                        break;
                                    }
                                    nextTrackSegment = (TrackSegment)lto.getConnectB();
                                    break;
                                }
                                default: {
                                    log.error("Bad currentNodeType argument when searching track - THROAT_TO_THROAT");
                                    return null;
                                }
                            }
                            prevTrack = lto;
                            break;
                        }
                        if (lt.getLinkType() != LayoutTurnout.LinkType.FIRST_3_WAY) break;
                        switch (currentNodeState) {
                            case 0: {
                                nextTrackSegment = lto.getContinuingSense() == 2 ? (TrackSegment)lto.getConnectB() : (TrackSegment)lto.getConnectC();
                                prevTrack = lto;
                                break block0;
                            }
                            case 1: {
                                if (lt.getContinuingSense() == 2) {
                                    nextTrackSegment = (TrackSegment)lt.getConnectC();
                                    break block0;
                                }
                                nextTrackSegment = (TrackSegment)lt.getConnectB();
                                break block0;
                            }
                            case 2: {
                                nextTrackSegment = lto.getContinuingSense() == 2 ? (TrackSegment)lto.getConnectC() : (TrackSegment)lto.getConnectB();
                                prevTrack = lto;
                                break block0;
                            }
                        }
                        log.error("Bad currentNodeType argument when searching track - FIRST_3_WAY");
                        return null;
                    }
                    if (!lt.isTurnoutTypeXover()) break;
                    switch (currentNodeState) {
                        case 0: {
                            nextTrackSegment = (TrackSegment)lt.getConnectB();
                            break block0;
                        }
                        case 1: {
                            if (currentNodeType == HitPointType.TURNOUT_A && lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER) {
                                nextTrackSegment = (TrackSegment)lt.getConnectC();
                                break block0;
                            }
                            log.error("Request to follow not allowed switch setting at LH_XOVER or RH_OVER");
                            return null;
                        }
                    }
                    log.error("Bad currentNodeType argument when searching track- XOVER A");
                    return null;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case TURNOUT_B: 
            case TURNOUT_C: {
                LayoutTurnout lto;
                LayoutTurnout lt;
                if (currentNode instanceof LayoutTurnout) {
                    lt = (LayoutTurnout)currentNode;
                    if (lt.isTurnoutTypeTurnout()) {
                        if (lt.getLinkedTurnoutName() == null || lt.getLinkedTurnoutName().isEmpty() || lt.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) {
                            nextTrackSegment = (TrackSegment)lt.getConnectA();
                            break;
                        }
                        lto = this.layoutEditor.getFinder().findLayoutTurnoutByName(lt.getLinkedTurnoutName());
                        if (lt.getLinkType() == LayoutTurnout.LinkType.SECOND_3_WAY) {
                            nextTrackSegment = (TrackSegment)lto.getConnectA();
                        } else if (lt.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                            switch (currentNodeState) {
                                case 0: {
                                    if (lto.getContinuingSense() == 2) {
                                        nextTrackSegment = (TrackSegment)lto.getConnectB();
                                        break;
                                    }
                                    nextTrackSegment = (TrackSegment)lto.getConnectC();
                                    break;
                                }
                                case 1: {
                                    if (lto.getContinuingSense() == 2) {
                                        nextTrackSegment = (TrackSegment)lto.getConnectC();
                                        break;
                                    }
                                    nextTrackSegment = (TrackSegment)lto.getConnectB();
                                    break;
                                }
                                default: {
                                    log.error("Bad currentNodeType argument when searching track - THROAT_TO_THROAT - 2");
                                    return null;
                                }
                            }
                        }
                        prevTrack = lto;
                        break;
                    }
                    if (!lt.isTurnoutTypeXover()) break;
                    switch (currentNodeState) {
                        case 0: {
                            if (currentNodeType == HitPointType.TURNOUT_B) {
                                nextTrackSegment = (TrackSegment)lt.getConnectA();
                                break block0;
                            }
                            if (currentNodeType != HitPointType.TURNOUT_C) break block0;
                            nextTrackSegment = (TrackSegment)lt.getConnectD();
                            break block0;
                        }
                        case 1: {
                            if (currentNodeType == HitPointType.TURNOUT_C && lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER) {
                                nextTrackSegment = (TrackSegment)lt.getConnectA();
                                break block0;
                            }
                            if (currentNodeType == HitPointType.TURNOUT_B && lt.getTurnoutType() != LayoutTurnout.TurnoutType.RH_XOVER) {
                                nextTrackSegment = (TrackSegment)lt.getConnectD();
                                break block0;
                            }
                            log.error("Request to follow not allowed switch setting at LH_XOVER or RH_OVER");
                            return null;
                        }
                        default: {
                            log.error("Bad currentNodeType argument when searching track - XOVER B or C");
                            return null;
                        }
                    }
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case TURNOUT_D: {
                LayoutTurnout lt;
                if (currentNode instanceof LayoutTurnout) {
                    lt = (LayoutTurnout)currentNode;
                    if (lt.isTurnoutTypeXover()) {
                        switch (currentNodeState) {
                            case 0: {
                                nextTrackSegment = (TrackSegment)lt.getConnectC();
                                break block0;
                            }
                            case 1: {
                                if (lt.getTurnoutType() != LayoutTurnout.TurnoutType.RH_XOVER) {
                                    nextTrackSegment = (TrackSegment)lt.getConnectB();
                                    break block0;
                                }
                                log.error("Request to follow not allowed switch setting at LH_XOVER or RH_OVER");
                                return null;
                            }
                        }
                        log.error("Bad currentNodeType argument when searching track - XOVER D");
                        return null;
                    }
                    log.error("Bad traak node type - TURNOUT_D, but not a crossover turnout");
                    return null;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case LEVEL_XING_A: {
                if (currentNode instanceof LevelXing) {
                    nextTrackSegment = (TrackSegment)((LevelXing)currentNode).getConnectC();
                    break;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case LEVEL_XING_B: {
                if (currentNode instanceof LevelXing) {
                    nextTrackSegment = (TrackSegment)((LevelXing)currentNode).getConnectD();
                    break;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case LEVEL_XING_C: {
                if (currentNode instanceof LevelXing) {
                    nextTrackSegment = (TrackSegment)((LevelXing)currentNode).getConnectA();
                    break;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case LEVEL_XING_D: {
                if (currentNode instanceof LevelXing) {
                    nextTrackSegment = (TrackSegment)((LevelXing)currentNode).getConnectB();
                    break;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case SLIP_A: {
                LayoutSlip ls;
                if (currentNode instanceof LayoutSlip) {
                    ls = (LayoutSlip)currentNode;
                    if (currentNodeState == 0) {
                        nextTrackSegment = (TrackSegment)ls.getConnectC();
                        break;
                    }
                    if (currentNodeState != 1) break;
                    nextTrackSegment = (TrackSegment)ls.getConnectD();
                    break;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case SLIP_B: {
                LayoutSlip ls;
                if (currentNode instanceof LayoutSlip) {
                    ls = (LayoutSlip)currentNode;
                    if (currentNodeState == 0) {
                        nextTrackSegment = (TrackSegment)ls.getConnectD();
                        break;
                    }
                    if (currentNodeState == 1 && ls.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        nextTrackSegment = (TrackSegment)ls.getConnectC();
                        break;
                    }
                    log.error("Request to follow not allowed on a single slip");
                    return null;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case SLIP_C: {
                LayoutSlip ls;
                if (currentNode instanceof LayoutSlip) {
                    ls = (LayoutSlip)currentNode;
                    if (currentNodeState == 0) {
                        nextTrackSegment = (TrackSegment)ls.getConnectA();
                        break;
                    }
                    if (currentNodeState == 1 && ls.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        nextTrackSegment = (TrackSegment)ls.getConnectB();
                        break;
                    }
                    log.error("Request to follow not allowed on a single slip");
                    return null;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            case SLIP_D: {
                LayoutSlip ls;
                if (currentNode instanceof LayoutSlip) {
                    ls = (LayoutSlip)currentNode;
                    if (currentNodeState == 0) {
                        nextTrackSegment = (TrackSegment)ls.getConnectB();
                        break;
                    }
                    if (currentNodeState != 1) break;
                    nextTrackSegment = (TrackSegment)ls.getConnectA();
                    break;
                }
                log.error("currentNodeType wrong for currentNode");
                break;
            }
            default: {
                log.error("Unable to initiate 'getTrackNode'.  Probably bad input Track Node.");
                return null;
            }
        }
        if (nextTrackSegment == null) {
            log.error("Error nextTrackSegment is null!");
            return null;
        }
        LayoutTrack node = null;
        HitPointType nodeType = HitPointType.NONE;
        TrackSegment nodeTrackSegment = null;
        boolean hitEnd = false;
        boolean hasNode = false;
        while (!hasNode) {
            LayoutTrack nextLayoutTrack = null;
            HitPointType nextType = HitPointType.NONE;
            if (nextTrackSegment.getConnect1() == prevTrack) {
                nextLayoutTrack = nextTrackSegment.getConnect2();
                nextType = nextTrackSegment.getType2();
            } else if (nextTrackSegment.getConnect2() == prevTrack) {
                nextLayoutTrack = nextTrackSegment.getConnect1();
                nextType = nextTrackSegment.getType1();
            }
            if (nextLayoutTrack == null) {
                log.error("Error while following track {} looking for next node", (Object)nextTrackSegment.getName());
                return null;
            }
            if (nextType == HitPointType.POS_POINT) {
                PositionablePoint p = (PositionablePoint)nextLayoutTrack;
                if (p.getType() == PositionablePoint.PointType.END_BUMPER) {
                    hitEnd = true;
                    hasNode = true;
                    continue;
                }
                TrackSegment con1 = p.getConnect1();
                TrackSegment con2 = p.getConnect2();
                if (con1 == null || con2 == null) {
                    log.error("Breakin connectivity at Anchor Point when searching for track node");
                    return null;
                }
                if (con1.getLayoutBlock() == con2.getLayoutBlock()) {
                    if (con1 == nextTrackSegment) {
                        nextTrackSegment = con2;
                    } else if (con2 == nextTrackSegment) {
                        nextTrackSegment = con1;
                    } else {
                        log.error("Breakin connectivity at Anchor Point when searching for track node");
                        return null;
                    }
                    prevTrack = nextLayoutTrack;
                    continue;
                }
                node = nextLayoutTrack;
                nodeType = nextType;
                nodeTrackSegment = nextTrackSegment;
                hasNode = true;
                continue;
            }
            node = nextLayoutTrack;
            nodeType = nextType;
            nodeTrackSegment = nextTrackSegment;
            hasNode = true;
        }
        return new TrackNode(node, nodeType, nodeTrackSegment, hitEnd, currentNodeState);
    }

    @CheckReturnValue
    @CheckForNull
    public Block getExitBlockForTrackNode(@CheckForNull TrackNode node, @CheckForNull Block excludedBlock) {
        if (node == null || node.reachedEndOfTrack()) {
            return null;
        }
        Block block = null;
        switch (node.getNodeType()) {
            case POS_POINT: {
                PositionablePoint p = (PositionablePoint)node.getNode();
                block = p.getConnect1().getLayoutBlock().getBlock();
                if (block != node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = p.getConnect2().getLayoutBlock().getBlock();
                break;
            }
            case TURNOUT_A: {
                LayoutTurnout lt = (LayoutTurnout)node.getNode();
                Block tBlock = ((TrackSegment)lt.getConnectB()).getLayoutBlock().getBlock();
                if (tBlock != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                    block = tBlock;
                    break;
                }
                if (lt.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER || (tBlock = ((TrackSegment)lt.getConnectC()).getLayoutBlock().getBlock()) == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                block = tBlock;
                break;
            }
            case TURNOUT_B: {
                LayoutTurnout lt = (LayoutTurnout)node.getNode();
                Block tBlock = ((TrackSegment)lt.getConnectA()).getLayoutBlock().getBlock();
                if (tBlock != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                    block = tBlock;
                    break;
                }
                if (lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && lt.getTurnoutType() != LayoutTurnout.TurnoutType.DOUBLE_XOVER || (tBlock = ((TrackSegment)lt.getConnectD()).getLayoutBlock().getBlock()) == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                block = tBlock;
                break;
            }
            case TURNOUT_C: {
                Block tBlock;
                LayoutTurnout lt = (LayoutTurnout)node.getNode();
                if (lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && (tBlock = ((TrackSegment)lt.getConnectA()).getLayoutBlock().getBlock()) != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                    block = tBlock;
                }
                if (block != null || lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && lt.getTurnoutType() != LayoutTurnout.TurnoutType.DOUBLE_XOVER || (tBlock = ((TrackSegment)lt.getConnectD()).getLayoutBlock().getBlock()) == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                block = tBlock;
                break;
            }
            case TURNOUT_D: {
                Block tBlock;
                LayoutTurnout lt = (LayoutTurnout)node.getNode();
                if (lt.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && lt.getTurnoutType() != LayoutTurnout.TurnoutType.DOUBLE_XOVER || (tBlock = ((TrackSegment)lt.getConnectB()).getLayoutBlock().getBlock()) == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                block = tBlock;
                break;
            }
            case LEVEL_XING_A: {
                LevelXing x = (LevelXing)node.getNode();
                Block tBlock = ((TrackSegment)x.getConnectC()).getLayoutBlock().getBlock();
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = tBlock;
                break;
            }
            case LEVEL_XING_B: {
                LevelXing x = (LevelXing)node.getNode();
                Block tBlock = ((TrackSegment)x.getConnectD()).getLayoutBlock().getBlock();
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = tBlock;
                break;
            }
            case LEVEL_XING_C: {
                LevelXing x = (LevelXing)node.getNode();
                Block tBlock = ((TrackSegment)x.getConnectA()).getLayoutBlock().getBlock();
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = tBlock;
                break;
            }
            case LEVEL_XING_D: {
                LevelXing x = (LevelXing)node.getNode();
                Block tBlock = ((TrackSegment)x.getConnectB()).getLayoutBlock().getBlock();
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = tBlock;
                break;
            }
            case SLIP_A: {
                LayoutSlip ls = (LayoutSlip)node.getNode();
                Block tBlock = ((TrackSegment)ls.getConnectC()).getLayoutBlock().getBlock();
                if (tBlock != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                    block = tBlock;
                    break;
                }
                tBlock = ((TrackSegment)ls.getConnectD()).getLayoutBlock().getBlock();
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                block = tBlock;
                break;
            }
            case SLIP_B: {
                LayoutSlip ls = (LayoutSlip)node.getNode();
                Block tBlock = ((TrackSegment)ls.getConnectD()).getLayoutBlock().getBlock();
                if (ls.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                    if (tBlock != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                        block = tBlock;
                        break;
                    }
                    tBlock = ((TrackSegment)ls.getConnectC()).getLayoutBlock().getBlock();
                    if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                    block = tBlock;
                    break;
                }
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = tBlock;
                break;
            }
            case SLIP_C: {
                LayoutSlip ls = (LayoutSlip)node.getNode();
                Block tBlock = ((TrackSegment)ls.getConnectA()).getLayoutBlock().getBlock();
                if (ls.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                    if (tBlock != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                        block = tBlock;
                        break;
                    }
                    tBlock = ((TrackSegment)ls.getConnectB()).getLayoutBlock().getBlock();
                    if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                    block = tBlock;
                    break;
                }
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock()) break;
                block = tBlock;
                break;
            }
            case SLIP_D: {
                LayoutSlip ls = (LayoutSlip)node.getNode();
                Block tBlock = ((TrackSegment)ls.getConnectB()).getLayoutBlock().getBlock();
                if (tBlock != node.getTrackSegment().getLayoutBlock().getBlock() && tBlock != excludedBlock) {
                    block = tBlock;
                    break;
                }
                tBlock = ((TrackSegment)ls.getConnectA()).getLayoutBlock().getBlock();
                if (tBlock == node.getTrackSegment().getLayoutBlock().getBlock() || tBlock == excludedBlock) break;
                block = tBlock;
                break;
            }
        }
        return block;
    }

    private Integer getTurnoutSetting(@Nonnull LayoutTurnout layoutTurnout, HitPointType cType, boolean suppress) {
        this.prevConnectTrack = layoutTurnout;
        int setting = 4;
        LayoutTurnout.TurnoutType tType = layoutTurnout.getTurnoutType();
        if (layoutTurnout instanceof LayoutSlip) {
            setting = 1;
            LayoutSlip layoutSlip = (LayoutSlip)layoutTurnout;
            tType = layoutSlip.getTurnoutType();
            LayoutBlock layoutBlockA = ((TrackSegment)layoutSlip.getConnectA()).getLayoutBlock();
            LayoutBlock layoutBlockB = ((TrackSegment)layoutSlip.getConnectB()).getLayoutBlock();
            LayoutBlock layoutBlockC = ((TrackSegment)layoutSlip.getConnectC()).getLayoutBlock();
            LayoutBlock layoutBlockD = ((TrackSegment)layoutSlip.getConnectD()).getLayoutBlock();
            switch (cType) {
                case SLIP_A: {
                    if (this.nextLayoutBlock == layoutBlockC) {
                        this.prevConnectType = HitPointType.SLIP_C;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectC();
                        break;
                    }
                    if (this.nextLayoutBlock == layoutBlockD) {
                        this.prevConnectType = HitPointType.SLIP_D;
                        setting = 6;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectD();
                        break;
                    }
                    if (this.currLayoutBlock == layoutBlockC && this.currLayoutBlock != layoutBlockD) {
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                        setting = 2;
                        this.prevConnectType = HitPointType.SLIP_C;
                        break;
                    }
                    if (this.currLayoutBlock == layoutBlockD && this.currLayoutBlock != layoutBlockC) {
                        setting = 6;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                        this.prevConnectType = HitPointType.SLIP_D;
                        break;
                    }
                    if (layoutSlip.getConnectC() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectC(), layoutSlip)) {
                        this.prevConnectType = HitPointType.SLIP_C;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                        break;
                    }
                    if (layoutSlip.getConnectD() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectD(), layoutSlip)) {
                        this.prevConnectType = HitPointType.SLIP_D;
                        setting = 6;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                        break;
                    }
                    if (!suppress) {
                        log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                    }
                    this.trackSegment = null;
                    break;
                }
                case SLIP_B: {
                    if (this.nextLayoutBlock == layoutBlockD) {
                        this.prevConnectType = HitPointType.SLIP_D;
                        setting = 4;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectD();
                        break;
                    }
                    if (this.nextLayoutBlock == layoutBlockC && tType == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        this.prevConnectType = HitPointType.SLIP_C;
                        setting = 8;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectC();
                        break;
                    }
                    if (tType == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        if (this.currLayoutBlock == layoutBlockD && this.currLayoutBlock != layoutBlockC) {
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            setting = 4;
                            this.prevConnectType = HitPointType.SLIP_D;
                            break;
                        }
                        if (this.currLayoutBlock == layoutBlockC && this.currLayoutBlock != layoutBlockD) {
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                            setting = 8;
                            this.prevConnectType = HitPointType.SLIP_C;
                            break;
                        }
                        if (layoutSlip.getConnectD() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectD(), layoutSlip)) {
                            this.prevConnectType = HitPointType.SLIP_D;
                            setting = 4;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (layoutSlip.getConnectC() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectC(), layoutSlip)) {
                            this.prevConnectType = HitPointType.SLIP_C;
                            setting = 8;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                            break;
                        }
                        if (!suppress) {
                            log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                        }
                        this.trackSegment = null;
                        break;
                    }
                    if (this.currLayoutBlock == layoutBlockD) {
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                        setting = 4;
                        this.prevConnectType = HitPointType.SLIP_D;
                        break;
                    }
                    this.trackSegment = null;
                    break;
                }
                case SLIP_C: {
                    if (this.nextLayoutBlock == layoutBlockA) {
                        this.prevConnectType = HitPointType.SLIP_A;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectA();
                        break;
                    }
                    if (this.nextLayoutBlock == layoutBlockB && tType == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        this.prevConnectType = HitPointType.SLIP_B;
                        setting = 8;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectB();
                        break;
                    }
                    if (tType == LayoutTurnout.TurnoutType.DOUBLE_SLIP) {
                        if (this.currLayoutBlock == layoutBlockA && this.currLayoutBlock != layoutBlockB) {
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            setting = 2;
                            this.prevConnectType = HitPointType.SLIP_A;
                            break;
                        }
                        if (this.currLayoutBlock == layoutBlockB && this.currLayoutBlock != layoutBlockA) {
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                            setting = 8;
                            this.prevConnectType = HitPointType.SLIP_B;
                            break;
                        }
                        if (layoutSlip.getConnectA() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectA(), layoutSlip)) {
                            this.prevConnectType = HitPointType.SLIP_A;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            break;
                        }
                        if (layoutSlip.getConnectB() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectB(), layoutSlip)) {
                            this.prevConnectType = HitPointType.SLIP_B;
                            setting = 8;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                            break;
                        }
                        if (!suppress) {
                            log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                        }
                        this.trackSegment = null;
                        break;
                    }
                    if (this.currLayoutBlock == layoutBlockA) {
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                        setting = 2;
                        this.prevConnectType = HitPointType.SLIP_A;
                        break;
                    }
                    this.trackSegment = null;
                    break;
                }
                case SLIP_D: {
                    if (this.nextLayoutBlock == layoutBlockB) {
                        this.prevConnectType = HitPointType.SLIP_B;
                        setting = 4;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectB();
                        break;
                    }
                    if (this.nextLayoutBlock == layoutBlockA) {
                        this.prevConnectType = HitPointType.SLIP_A;
                        setting = 6;
                        this.trackSegment = (TrackSegment)layoutSlip.getConnectA();
                        break;
                    }
                    if (this.currLayoutBlock == layoutBlockB && this.currLayoutBlock != layoutBlockA) {
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                        setting = 4;
                        this.prevConnectType = HitPointType.SLIP_B;
                        break;
                    }
                    if (this.currLayoutBlock == layoutBlockA && this.currLayoutBlock != layoutBlockB) {
                        setting = 6;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                        this.prevConnectType = HitPointType.SLIP_A;
                        break;
                    }
                    if (layoutSlip.getConnectA() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectA(), layoutSlip)) {
                        this.prevConnectType = HitPointType.SLIP_A;
                        setting = 6;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                        break;
                    }
                    if (layoutSlip.getConnectB() != null && this.trackSegmentLeadsTo((TrackSegment)layoutSlip.getConnectB(), layoutSlip)) {
                        this.prevConnectType = HitPointType.SLIP_B;
                        setting = 4;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                        break;
                    }
                    if (!suppress) {
                        log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                    }
                    this.trackSegment = null;
                    break;
                }
            }
            if (this.trackSegment != null && this.trackSegment.getLayoutBlock() != this.currLayoutBlock) {
                this.trackSegment = null;
            } else if (this.trackSegment == null) {
                if (!suppress) {
                    log.warn("Connectivity not complete at {}", (Object)layoutSlip.getDisplayName());
                }
                this.turnoutConnectivity = false;
            }
        } else {
            switch (cType) {
                case TURNOUT_A: {
                    if (tType == LayoutTurnout.TurnoutType.LH_XOVER) {
                        this.prevConnectType = HitPointType.TURNOUT_B;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                        break;
                    }
                    if (this.nextLayoutBlock == layoutTurnout.getLayoutBlockB() || layoutTurnout.getConnectB() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectB()).getLayoutBlock()) {
                        this.prevConnectType = HitPointType.TURNOUT_B;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                        break;
                    }
                    if (this.nextLayoutBlock == layoutTurnout.getLayoutBlockC() || layoutTurnout.getConnectC() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectC()).getLayoutBlock()) {
                        this.prevConnectType = HitPointType.TURNOUT_C;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                        break;
                    }
                    if (layoutTurnout.getConnectB() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectB()).getLayoutBlock() && layoutTurnout.getConnectC() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectC()).getLayoutBlock()) {
                        this.prevConnectType = HitPointType.TURNOUT_B;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                        break;
                    }
                    if (layoutTurnout.getConnectC() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectC()).getLayoutBlock() && layoutTurnout.getConnectB() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectB()).getLayoutBlock()) {
                        this.prevConnectType = HitPointType.TURNOUT_C;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                        break;
                    }
                    if (layoutTurnout.getConnectB() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectB(), layoutTurnout)) {
                        this.prevConnectType = HitPointType.TURNOUT_B;
                        setting = 2;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                        break;
                    }
                    if (layoutTurnout.getConnectC() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectC(), layoutTurnout)) {
                        this.prevConnectType = HitPointType.TURNOUT_C;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                        break;
                    }
                    if (!suppress) {
                        log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                    }
                    this.trackSegment = null;
                    break;
                }
                case TURNOUT_B: {
                    if (tType == LayoutTurnout.TurnoutType.LH_XOVER || tType == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                        if (this.nextLayoutBlock == layoutTurnout.getLayoutBlock() || layoutTurnout.getConnectA() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectA()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                            break;
                        }
                        if (this.nextLayoutBlock == layoutTurnout.getLayoutBlockD() || layoutTurnout.getConnectD() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectD()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_D;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (layoutTurnout.getConnectA() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectA()).getLayoutBlock() && layoutTurnout.getConnectD() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectD()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            break;
                        }
                        if (layoutTurnout.getConnectD() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectD()).getLayoutBlock() && layoutTurnout.getConnectA() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectA()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_D;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (layoutTurnout.getConnectA() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectA(), layoutTurnout)) {
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            break;
                        }
                        if (layoutTurnout.getConnectD() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectD(), layoutTurnout)) {
                            this.prevConnectType = HitPointType.TURNOUT_D;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (!suppress) {
                            log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                        }
                        this.trackSegment = null;
                        break;
                    }
                    this.prevConnectType = HitPointType.TURNOUT_A;
                    setting = 2;
                    this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                    break;
                }
                case TURNOUT_C: {
                    if (tType == LayoutTurnout.TurnoutType.RH_XOVER || tType == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                        if (this.nextLayoutBlock == layoutTurnout.getLayoutBlockD() || layoutTurnout.getConnectD() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectD()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_D;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (this.nextLayoutBlock == layoutTurnout.getLayoutBlock() || layoutTurnout.getConnectA() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectA()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            break;
                        }
                        if (layoutTurnout.getConnectD() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectD()).getLayoutBlock() && layoutTurnout.getConnectA() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectA()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_D;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (layoutTurnout.getConnectA() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectA()).getLayoutBlock() && layoutTurnout.getConnectD() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectD()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            break;
                        }
                        if (layoutTurnout.getConnectD() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectD(), layoutTurnout)) {
                            this.prevConnectType = HitPointType.TURNOUT_D;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                            break;
                        }
                        if (layoutTurnout.getConnectA() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectA(), layoutTurnout)) {
                            this.prevConnectType = HitPointType.TURNOUT_A;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                            break;
                        }
                        if (!suppress) {
                            log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                        }
                        this.trackSegment = null;
                        break;
                    }
                    if (tType == LayoutTurnout.TurnoutType.LH_XOVER) {
                        this.prevConnectType = HitPointType.TURNOUT_D;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectD();
                        setting = 2;
                        break;
                    }
                    this.prevConnectType = HitPointType.TURNOUT_A;
                    this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                    break;
                }
                case TURNOUT_D: {
                    if (tType == LayoutTurnout.TurnoutType.LH_XOVER || tType == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                        if (this.nextLayoutBlock == layoutTurnout.getLayoutBlockC() || layoutTurnout.getConnectC() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectC()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_C;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                            break;
                        }
                        if (this.nextLayoutBlock == layoutTurnout.getLayoutBlockB() || layoutTurnout.getConnectB() != null && this.nextLayoutBlock == ((TrackSegment)layoutTurnout.getConnectB()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_B;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                            break;
                        }
                        if (layoutTurnout.getConnectC() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectC()).getLayoutBlock() && layoutTurnout.getConnectB() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectB()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_C;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                            break;
                        }
                        if (layoutTurnout.getConnectB() != null && this.currLayoutBlock == ((TrackSegment)layoutTurnout.getConnectB()).getLayoutBlock() && layoutTurnout.getConnectC() != null && this.currLayoutBlock != ((TrackSegment)layoutTurnout.getConnectC()).getLayoutBlock()) {
                            this.prevConnectType = HitPointType.TURNOUT_B;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                            break;
                        }
                        if (layoutTurnout.getConnectC() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectC(), layoutTurnout)) {
                            this.prevConnectType = HitPointType.TURNOUT_C;
                            setting = 2;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                            break;
                        }
                        if (layoutTurnout.getConnectB() != null && this.trackSegmentLeadsTo((TrackSegment)layoutTurnout.getConnectB(), layoutTurnout)) {
                            this.prevConnectType = HitPointType.TURNOUT_B;
                            this.trackSegment = (TrackSegment)layoutTurnout.getConnectB();
                            break;
                        }
                        if (!suppress) {
                            log.warn("Neither branch at {} leads to next Block {}", (Object)layoutTurnout, (Object)this.nextLayoutBlock);
                        }
                        this.trackSegment = null;
                        break;
                    }
                    if (tType == LayoutTurnout.TurnoutType.RH_XOVER) {
                        this.prevConnectType = HitPointType.TURNOUT_C;
                        this.trackSegment = (TrackSegment)layoutTurnout.getConnectC();
                        setting = 2;
                        break;
                    }
                    this.prevConnectType = HitPointType.TURNOUT_A;
                    this.trackSegment = (TrackSegment)layoutTurnout.getConnectA();
                    break;
                }
                default: {
                    log.warn("getTurnoutSetting() unknown cType: {}", (Object)cType);
                }
            }
            if (this.trackSegment != null && this.trackSegment.getLayoutBlock() != this.currLayoutBlock) {
                this.trackSegment = null;
            } else if (this.trackSegment == null) {
                if (!suppress) {
                    log.warn("Connectivity not complete at {}", (Object)layoutTurnout.getTurnoutName());
                }
                this.turnoutConnectivity = false;
            }
            if (layoutTurnout.getContinuingSense() != 2) {
                if (setting == 4) {
                    setting = 2;
                } else if (setting == 2) {
                    setting = 4;
                }
            }
        }
        return setting;
    }

    private boolean trackSegmentLeadsTo(@CheckForNull TrackSegment trackSegment, @CheckForNull LayoutTrack layoutTrack) {
        if (trackSegment == null || layoutTrack == null) {
            log.error("Null argument on entry to trackSegmentLeadsTo");
            return false;
        }
        TrackSegment curTrackSegment = trackSegment;
        LayoutTrack curLayoutTrack = layoutTrack;
        if (log.isDebugEnabled()) {
            log.info("trackSegmentLeadsTo({}, {}): entry", (Object)curTrackSegment.getName(), (Object)curLayoutTrack.getName());
        }
        ArrayList<TrackSegment> postTrackSegments = new ArrayList<TrackSegment>();
        ArrayList<LayoutTrack> postLayoutTracks = new ArrayList<LayoutTrack>();
        while (curTrackSegment != null) {
            if (curTrackSegment.getLayoutBlock() == this.nextLayoutBlock) {
                return true;
            }
            if (curTrackSegment.getLayoutBlock() == this.currLayoutBlock) {
                LayoutTurnout.TurnoutType tType;
                LayoutTrack conLayoutTrack;
                HitPointType conType;
                if (curTrackSegment.getConnect1() == curLayoutTrack) {
                    conType = curTrackSegment.getType2();
                    conLayoutTrack = curTrackSegment.getConnect2();
                } else if (curTrackSegment.getConnect2() == curLayoutTrack) {
                    conType = curTrackSegment.getType1();
                    conLayoutTrack = curTrackSegment.getConnect1();
                } else {
                    log.error("Connectivity error when following track {} in Block {}", (Object)curTrackSegment.getName(), (Object)this.currLayoutBlock.getUserName());
                    log.warn("{} not connected to {} (connects: {} & {})", new Object[]{curLayoutTrack.getName(), curTrackSegment.getName(), curTrackSegment.getConnect1Name(), curTrackSegment.getConnect2Name()});
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.info("In block {}, going from {} thru {} to {} (conType: {}), nextLayoutBlock: {}", new Object[]{this.currLayoutBlock.getUserName(), conLayoutTrack.getName(), curTrackSegment.getName(), curLayoutTrack.getName(), conType.name(), this.nextLayoutBlock.getId()});
                }
                if (conType == HitPointType.POS_POINT) {
                    if (((PositionablePoint)conLayoutTrack).getType() == PositionablePoint.PointType.END_BUMPER) {
                        if (log.isDebugEnabled()) {
                            log.info("end of line without reaching {}", (Object)this.nextLayoutBlock.getId());
                        }
                        curTrackSegment = null;
                    } else if (((PositionablePoint)conLayoutTrack).getType() == PositionablePoint.PointType.ANCHOR || ((PositionablePoint)conLayoutTrack).getType() == PositionablePoint.PointType.EDGE_CONNECTOR) {
                        curTrackSegment = ((PositionablePoint)conLayoutTrack).getConnect1() == curTrackSegment ? ((PositionablePoint)conLayoutTrack).getConnect2() : ((PositionablePoint)conLayoutTrack).getConnect1();
                        curLayoutTrack = conLayoutTrack;
                    }
                } else if (HitPointType.isLevelXingHitType(conType)) {
                    if (conType == HitPointType.LEVEL_XING_A || conType == HitPointType.LEVEL_XING_C) {
                        if (((LevelXing)conLayoutTrack).getLayoutBlockAC() != this.currLayoutBlock) {
                            if (((LevelXing)conLayoutTrack).getLayoutBlockAC() == this.nextLayoutBlock) {
                                return true;
                            }
                            curTrackSegment = null;
                        } else {
                            curTrackSegment = conType == HitPointType.LEVEL_XING_A ? (TrackSegment)((LevelXing)conLayoutTrack).getConnectC() : (TrackSegment)((LevelXing)conLayoutTrack).getConnectA();
                        }
                    } else if (((LevelXing)conLayoutTrack).getLayoutBlockBD() != this.currLayoutBlock) {
                        if (((LevelXing)conLayoutTrack).getLayoutBlockBD() == this.nextLayoutBlock) {
                            return true;
                        }
                        curTrackSegment = null;
                    } else {
                        curTrackSegment = conType == HitPointType.LEVEL_XING_B ? (TrackSegment)((LevelXing)conLayoutTrack).getConnectD() : (TrackSegment)((LevelXing)conLayoutTrack).getConnectB();
                    }
                    curLayoutTrack = conLayoutTrack;
                } else if (HitPointType.isTurnoutHitType(conType)) {
                    LayoutTurnout lt = (LayoutTurnout)conLayoutTrack;
                    tType = lt.getTurnoutType();
                    if (lt.isTurnoutTypeXover()) {
                        switch (conType) {
                            case TURNOUT_A: {
                                if (lt.getLayoutBlock() != this.currLayoutBlock) {
                                    if (lt.getLayoutBlock() == this.nextLayoutBlock) {
                                        return true;
                                    }
                                    curTrackSegment = null;
                                    break;
                                }
                                if (lt.getLayoutBlockB() == this.nextLayoutBlock || tType != LayoutTurnout.TurnoutType.LH_XOVER && lt.getLayoutBlockC() == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (lt.getLayoutBlockB() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectB();
                                    if (tType == LayoutTurnout.TurnoutType.LH_XOVER || lt.getLayoutBlockC() != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)lt.getConnectC());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                if (tType != LayoutTurnout.TurnoutType.LH_XOVER && lt.getLayoutBlockC() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectC();
                                    break;
                                }
                                curTrackSegment = null;
                                break;
                            }
                            case TURNOUT_B: {
                                if (lt.getLayoutBlockB() != this.currLayoutBlock) {
                                    if (lt.getLayoutBlockB() == this.nextLayoutBlock) {
                                        return true;
                                    }
                                    curTrackSegment = null;
                                    break;
                                }
                                if (lt.getLayoutBlock() == this.nextLayoutBlock || tType != LayoutTurnout.TurnoutType.RH_XOVER && lt.getLayoutBlockD() == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (lt.getLayoutBlock() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectA();
                                    if (tType == LayoutTurnout.TurnoutType.RH_XOVER || lt.getLayoutBlockD() != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)lt.getConnectD());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                if (tType != LayoutTurnout.TurnoutType.RH_XOVER && lt.getLayoutBlockD() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectD();
                                    break;
                                }
                                curTrackSegment = null;
                                break;
                            }
                            case TURNOUT_C: {
                                if (lt.getLayoutBlockC() != this.currLayoutBlock) {
                                    if (lt.getLayoutBlockC() == this.nextLayoutBlock) {
                                        return true;
                                    }
                                    curTrackSegment = null;
                                    break;
                                }
                                if (lt.getLayoutBlockD() == this.nextLayoutBlock || tType != LayoutTurnout.TurnoutType.LH_XOVER && lt.getLayoutBlock() == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (lt.getLayoutBlockD() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectD();
                                    if (tType == LayoutTurnout.TurnoutType.LH_XOVER || lt.getLayoutBlock() != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)lt.getConnectA());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                if (tType != LayoutTurnout.TurnoutType.LH_XOVER && lt.getLayoutBlock() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectA();
                                    break;
                                }
                                curTrackSegment = null;
                                break;
                            }
                            case TURNOUT_D: {
                                if (lt.getLayoutBlockD() != this.currLayoutBlock) {
                                    if (lt.getLayoutBlockD() == this.nextLayoutBlock) {
                                        return true;
                                    }
                                    curTrackSegment = null;
                                    break;
                                }
                                if (lt.getLayoutBlockC() == this.nextLayoutBlock || tType != LayoutTurnout.TurnoutType.RH_XOVER && lt.getLayoutBlockB() == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (lt.getLayoutBlockC() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectC();
                                    if (tType == LayoutTurnout.TurnoutType.RH_XOVER || lt.getLayoutBlockB() != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)lt.getConnectB());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                if (tType != LayoutTurnout.TurnoutType.RH_XOVER && lt.getLayoutBlockB() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectB();
                                    break;
                                }
                                curTrackSegment = null;
                                break;
                            }
                            default: {
                                log.warn("trackSegmentLeadsTo() unknown conType: {}", (Object)conType);
                            }
                        }
                        curLayoutTrack = conLayoutTrack;
                    } else if (LayoutTurnout.isTurnoutTypeTurnout(tType)) {
                        if (lt.getLayoutBlock() != this.currLayoutBlock) {
                            if (lt.getLayoutBlock() == this.nextLayoutBlock) {
                                return true;
                            }
                            curTrackSegment = null;
                        } else {
                            if (conType == HitPointType.TURNOUT_A) {
                                if (((TrackSegment)lt.getConnectB()).getLayoutBlock() == this.nextLayoutBlock || ((TrackSegment)lt.getConnectC()).getLayoutBlock() == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (((TrackSegment)lt.getConnectB()).getLayoutBlock() == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)lt.getConnectB();
                                    if (((TrackSegment)lt.getConnectC()).getLayoutBlock() == this.currLayoutBlock) {
                                        postTrackSegments.add((TrackSegment)lt.getConnectC());
                                        postLayoutTracks.add(conLayoutTrack);
                                    }
                                } else {
                                    curTrackSegment = (TrackSegment)lt.getConnectC();
                                }
                            } else {
                                curTrackSegment = (TrackSegment)lt.getConnectA();
                            }
                            curLayoutTrack = conLayoutTrack;
                        }
                    }
                } else if (HitPointType.isSlipHitType(conType)) {
                    LayoutSlip ls = (LayoutSlip)conLayoutTrack;
                    tType = ls.getTurnoutType();
                    if (ls.getLayoutBlock() != this.currLayoutBlock) {
                        if (ls.getLayoutBlock() == this.nextLayoutBlock) {
                            return true;
                        }
                        curTrackSegment = null;
                    } else {
                        LayoutBlock layoutBlockA = ((TrackSegment)ls.getConnectA()).getLayoutBlock();
                        LayoutBlock layoutBlockB = ((TrackSegment)ls.getConnectB()).getLayoutBlock();
                        LayoutBlock layoutBlockC = ((TrackSegment)ls.getConnectC()).getLayoutBlock();
                        LayoutBlock layoutBlockD = ((TrackSegment)ls.getConnectD()).getLayoutBlock();
                        switch (conType) {
                            case SLIP_A: {
                                if (layoutBlockC == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockD == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockC == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)ls.getConnectC();
                                    if (layoutBlockD != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)ls.getConnectD());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                curTrackSegment = (TrackSegment)ls.getConnectD();
                                break;
                            }
                            case SLIP_B: {
                                if (tType == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                                    curTrackSegment = (TrackSegment)ls.getConnectD();
                                    break;
                                }
                                if (layoutBlockC == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockD == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockC == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)ls.getConnectC();
                                    if (layoutBlockD != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)ls.getConnectD());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                curTrackSegment = (TrackSegment)ls.getConnectD();
                                break;
                            }
                            case SLIP_C: {
                                if (tType == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                                    curTrackSegment = (TrackSegment)ls.getConnectA();
                                    break;
                                }
                                if (layoutBlockA == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockB == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockB == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)ls.getConnectB();
                                    if (layoutBlockA != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)ls.getConnectA());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                if (layoutBlockA == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)ls.getConnectA();
                                    break;
                                }
                                log.debug("{} not connected to {} (connections: {} & {})", new Object[]{this.currLayoutBlock.getUserName(), ls.getName(), ls.getConnectA().getName(), ls.getConnectB().getName()});
                                break;
                            }
                            case SLIP_D: {
                                if (layoutBlockA == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockB == this.nextLayoutBlock) {
                                    return true;
                                }
                                if (layoutBlockB == this.currLayoutBlock) {
                                    curTrackSegment = (TrackSegment)ls.getConnectB();
                                    if (layoutBlockA != this.currLayoutBlock) break;
                                    postTrackSegments.add((TrackSegment)ls.getConnectA());
                                    postLayoutTracks.add(conLayoutTrack);
                                    break;
                                }
                                curTrackSegment = (TrackSegment)ls.getConnectA();
                                break;
                            }
                            default: {
                                log.warn("trackSegmentLeadsTo() unknown conType: {}", (Object)conType);
                            }
                        }
                        curLayoutTrack = conLayoutTrack;
                    }
                }
            } else {
                curTrackSegment = null;
            }
            if (curTrackSegment != null || postTrackSegments.size() <= 0) continue;
            curTrackSegment = (TrackSegment)postTrackSegments.get(0);
            curLayoutTrack = (LayoutTrack)postLayoutTracks.get(0);
            postTrackSegments.remove(0);
            postLayoutTracks.remove(0);
        }
        return false;
    }

    public boolean isTurnoutConnectivityComplete() {
        return this.turnoutConnectivity;
    }

    private void setupOpposingTrackSegment(@Nonnull LevelXing x, HitPointType cType) {
        switch (cType) {
            case LEVEL_XING_A: {
                this.trackSegment = (TrackSegment)x.getConnectC();
                this.prevConnectType = HitPointType.LEVEL_XING_C;
                break;
            }
            case LEVEL_XING_B: {
                this.trackSegment = (TrackSegment)x.getConnectD();
                this.prevConnectType = HitPointType.LEVEL_XING_D;
                break;
            }
            case LEVEL_XING_C: {
                this.trackSegment = (TrackSegment)x.getConnectA();
                this.prevConnectType = HitPointType.LEVEL_XING_A;
                break;
            }
            case LEVEL_XING_D: {
                this.trackSegment = (TrackSegment)x.getConnectB();
                this.prevConnectType = HitPointType.LEVEL_XING_B;
                break;
            }
        }
        if (this.trackSegment.getLayoutBlock() != this.currLayoutBlock) {
            this.trackSegment = null;
        } else {
            this.prevConnectTrack = x;
        }
    }

    @Nonnull
    public List<LayoutTurnout> getAllTurnoutsThisBlock(@Nonnull LayoutBlock currLayoutBlock) {
        return this.layoutEditor.getLayoutTracks().stream().filter(o -> o instanceof LayoutTurnout).map(LayoutTurnout.class::cast).filter(lt -> lt.getLayoutBlock() == currLayoutBlock || lt.getLayoutBlockB() == currLayoutBlock || lt.getLayoutBlockC() == currLayoutBlock || lt.getLayoutBlockD() == currLayoutBlock).map(LayoutTurnout.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }
}

