/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jmri.BasicRosterEntry;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockValueFile
extends XmlFile {
    private BlockManager blockManager = InstanceManager.getDefault(BlockManager.class);
    private static final String defaultFileName = String.valueOf(FileUtil.getUserFilesPath()) + "blockvalues.xml";
    private Element root = null;
    private static final Logger log = LoggerFactory.getLogger(BlockValueFile.class);

    public void readBlockValues() throws JDOMException, IOException {
        log.debug("entered readBlockValues");
        ArrayList blocks = new ArrayList(this.blockManager.getNamedBeanSet().size());
        this.blockManager.getNamedBeanSet().forEach(bean -> blocks.add(bean.getSystemName()));
        if (this.checkFile(defaultFileName)) {
            Element blockvalues;
            this.root = this.rootFromName(defaultFileName);
            if (this.root != null && blocks.size() > 0 && (blockvalues = this.root.getChild("blockvalues")) != null) {
                List blockList = blockvalues.getChildren("block");
                boolean allPoweredUp = true;
                for (PowerManager pm : InstanceManager.getList(PowerManager.class)) {
                    if (pm.getPower() == 2) continue;
                    allPoweredUp = false;
                }
                ArrayList<String> passes = new ArrayList<String>();
                passes.add("set");
                if (allPoweredUp) {
                    passes.add(0, "check");
                }
                block3: for (String pass : passes) {
                    for (Element bl : blockList) {
                        if (bl.getAttribute("systemname") == null) {
                            log.warn("unexpected null in systemName {} {}", (Object)bl, (Object)bl.getAttributes());
                            continue block3;
                        }
                        String sysName = bl.getAttribute("systemname").getValue();
                        Block b = (Block)this.blockManager.getBySystemName(sysName);
                        if (b == null) continue;
                        if (pass.equals("check") && b.getState() != 2) {
                            log.error("block {} is not occupied but has a saved value, not setting saved block values", (Object)b.getDisplayName());
                            return;
                        }
                        if (pass.equals("set")) {
                            RosterEntry re;
                            Object v = bl.getAttribute("value").getValue();
                            if (bl.getAttribute("valueClass") != null && bl.getAttribute("valueClass").getValue().equals("jmri.jmrit.roster.RosterEntry") && (re = Roster.getDefault().getEntryForId((String)v)) != null) {
                                v = re;
                            }
                            b.setValue(v);
                        }
                        if (!pass.equals("set")) continue;
                        int dd = 0;
                        Attribute a = bl.getAttribute("dir");
                        if (a != null) {
                            try {
                                dd = a.getIntValue();
                            }
                            catch (DataConversionException dataConversionException) {
                                log.error("failed to convert direction attribute");
                            }
                        }
                        b.setDirection(dd);
                    }
                }
            }
        }
    }

    public void writeBlockValues() throws IOException {
        log.debug("entered writeBlockValues");
        if (this.blockManager.getNamedBeanSet().size() > 0) {
            this.root = new Element("block_values");
            Document doc = BlockValueFile.newDocument(this.root, String.valueOf(this.dtdLocation) + "block-values.dtd");
            boolean valuesFound = false;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/blockValues.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            Element values = new Element("blockvalues");
            for (Block b : this.blockManager.getNamedBeanSet()) {
                if (b != null) {
                    Object o = b.getValue();
                    if (o == null) continue;
                    Element val = new Element("block");
                    val.setAttribute("systemname", b.getSystemName());
                    if (o instanceof RosterEntry) {
                        val.setAttribute("value", ((BasicRosterEntry)o).getId());
                        val.setAttribute("valueClass", "jmri.jmrit.roster.RosterEntry");
                    } else {
                        val.setAttribute("value", o.toString());
                    }
                    int v = b.getDirection();
                    if (v != 0) {
                        val.setAttribute("dir", "" + v);
                    }
                    values.addContent((Content)val);
                    valuesFound = true;
                    continue;
                }
                log.error("Block null in blockManager.getNamedBeanSet()");
            }
            this.root.addContent((Content)values);
            if (valuesFound) {
                try {
                    File file;
                    if (!this.checkFile(defaultFileName) && !(file = new File(defaultFileName)).createNewFile()) {
                        log.error("createNewFile failed");
                    }
                    this.writeXML(this.findFile(defaultFileName), doc);
                }
                catch (IOException ioe) {
                    log.error("While writing block value file ", (Throwable)ioe);
                    throw ioe;
                }
            }
        }
    }
}

