/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.layoutEditor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.swing.JOptionPane;
import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.Path;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.roster.RosterEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class BlockContentsIcon
extends jmri.jmrit.display.BlockContentsIcon {
    private LayoutBlock lBlock = null;
    private static final Logger log = LoggerFactory.getLogger(BlockContentsIcon.class);

    public BlockContentsIcon(String s, LayoutEditor panel) {
        super(s, (Editor)panel);
        log.debug("BlockContentsIcon ctor= {}", (Object)BlockContentsIcon.class.getName());
    }

    @Override
    public void setBlock(NamedBeanHandle<Block> m) {
        super.setBlock(m);
        if (this.getBlock() != null) {
            this.lBlock = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlock(this.getBlock());
        }
    }

    @Override
    protected void addRosterToIcon(RosterEntry roster) {
        int dirB;
        int dirA;
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() || this.lBlock == null) {
            super.addRosterToIcon(roster);
            return;
        }
        int paths = this.lBlock.getNumberOfThroughPaths();
        Block srcBlock = null;
        Block desBlock = null;
        int i = 0;
        while (i < paths) {
            if (this.lBlock.isThroughPathActive(i).booleanValue()) {
                srcBlock = this.lBlock.getThroughPathSource(i);
                desBlock = this.lBlock.getThroughPathDestination(i);
                break;
            }
            ++i;
        }
        if (srcBlock != null && desBlock != null) {
            dirA = this.lBlock.getNeighbourDirection(srcBlock);
            dirB = this.lBlock.getNeighbourDirection(desBlock);
        } else {
            dirA = 64;
            dirB = 128;
        }
        Object[] options = new Object[]{"Facing " + Path.decodeDirection(dirB), "Facing " + Path.decodeDirection(dirA), "Do Not Add"};
        int n = JOptionPane.showOptionDialog(this, "Would you like to assign loco " + roster.titleString() + " to this location", "Assign Loco", 1, 3, null, options, options[2]);
        if (n == 2) {
            return;
        }
        if (n == 0) {
            this.flipRosterIcon = true;
            this.getBlock().setDirection(dirB);
        } else {
            this.flipRosterIcon = false;
            this.getBlock().setDirection(dirA);
        }
        if (this.getBlock().getValue() == roster) {
            this.updateIconFromRosterVal(roster);
        } else {
            this.setValue(roster);
        }
    }
}

