/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape.configurexml;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.List;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.shape.PositionablePolygon;
import jmri.jmrit.display.controlPanelEditor.shape.configurexml.PositionableShapeXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePolygonXml
extends PositionableShapeXml {
    private static final Logger log = LoggerFactory.getLogger(PositionablePolygonXml.class);

    @Override
    public Element store(Object o) {
        PositionablePolygon p = (PositionablePolygon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("positionablePolygon");
        this.storeCommonAttributes(p, element);
        element.addContent((Content)this.storePath(p));
        element.setAttribute("class", "jmri.jmrit.display.controlPanelEditor.shape.configurexml.PositionablePolygonXml");
        return element;
    }

    protected Element storePath(PositionablePolygon p) {
        Element elem = new Element("path");
        PathIterator iter = p.getPathIterator(null);
        float[] coord = new float[6];
        while (!iter.isDone()) {
            int type = iter.currentSegment(coord);
            elem.addContent((Content)this.storeVertex(type, coord));
            iter.next();
        }
        return elem;
    }

    private Element storeVertex(int type, float[] coord) {
        Element elem = new Element("vertex");
        elem.setAttribute("type", String.valueOf(type));
        int i = 0;
        while (i < coord.length) {
            elem.setAttribute("idx" + i, String.valueOf(coord[i]));
            ++i;
        }
        return elem;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor ed = (Editor)o;
        GeneralPath path = new GeneralPath(0);
        Element elem = element.getChild("path");
        float[] coord = new float[6];
        List list = elem.getChildren("vertex");
        for (Element e : list) {
            int type = this.getInt(e, "type");
            int i = 0;
            while (i < coord.length) {
                coord[i] = this.getFloat(e, "idx" + i);
                ++i;
            }
            switch (type) {
                case 0: {
                    path.moveTo(coord[0], coord[1]);
                    break;
                }
                case 1: {
                    path.lineTo(coord[0], coord[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coord[0], coord[1], coord[2], coord[3]);
                    break;
                }
                case 3: {
                    path.curveTo(coord[0], coord[1], coord[2], coord[3], coord[4], coord[5]);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    log.warn("Unhandled type: {}", (Object)type);
                }
            }
        }
        PositionablePolygon ps = new PositionablePolygon(ed, path);
        try {
            ed.putItem(ps);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(ps, 10, element);
    }
}

