/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawCircle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawEllipse;
import jmri.jmrit.display.controlPanelEditor.shape.DrawFrame;
import jmri.jmrit.display.controlPanelEditor.shape.DrawPolygon;
import jmri.jmrit.display.controlPanelEditor.shape.DrawRectangle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawRoundRect;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeDrawer {
    private final Editor _editor;
    private DrawFrame _drawFrame;
    private PositionableShape _currentSelection;
    private static final Logger log = LoggerFactory.getLogger(ShapeDrawer.class);

    public ShapeDrawer(Editor ed) {
        this._editor = ed;
    }

    public JMenu makeMenu() {
        JMenu drawMenu = new JMenu(Bundle.getMessage("drawShapes"));
        JMenuItem shapeItem = new JMenuItem(Bundle.getMessage("drawSth", Bundle.getMessage("Rectangle")));
        drawMenu.add(shapeItem);
        shapeItem.addActionListener(event -> this.newRectangle());
        shapeItem = new JMenuItem(Bundle.getMessage("drawSth", Bundle.getMessage("roundRect")));
        drawMenu.add(shapeItem);
        shapeItem.addActionListener(event -> this.newRoundRectangle());
        shapeItem = new JMenuItem(Bundle.getMessage("drawSth", Bundle.getMessage("Polygon")));
        drawMenu.add(shapeItem);
        shapeItem.addActionListener(event -> this.newPolygon());
        shapeItem = new JMenuItem(Bundle.getMessage("drawSth", Bundle.getMessage("Circle")));
        drawMenu.add(shapeItem);
        shapeItem.addActionListener(event -> this.newCircle());
        shapeItem = new JMenuItem(Bundle.getMessage("drawSth", Bundle.getMessage("Ellipse")));
        drawMenu.add(shapeItem);
        shapeItem.addActionListener(event -> this.newEllipse());
        return drawMenu;
    }

    private void newRectangle() {
        if (this.makeNewShape()) {
            this._drawFrame = new DrawRectangle("newShape", "Rectangle", null, this._editor, true);
        }
    }

    private void newRoundRectangle() {
        if (this.makeNewShape()) {
            this._drawFrame = new DrawRoundRect("newShape", "roundRect", null, this._editor, true);
        }
    }

    private void newPolygon() {
        if (this.makeNewShape()) {
            this._drawFrame = new DrawPolygon("newShape", "Polygon", null, this._editor, true);
        }
    }

    private void newCircle() {
        if (this.makeNewShape()) {
            this._drawFrame = new DrawCircle("newShape", "Circle", null, this._editor, true);
        }
    }

    private void newEllipse() {
        if (this.makeNewShape()) {
            this._drawFrame = new DrawEllipse("newShape", "Ellipse", null, this._editor, true);
        }
    }

    protected boolean makeNewShape() {
        if (this._drawFrame != null) {
            int ans = JOptionPane.showConfirmDialog(this._drawFrame, Bundle.getMessage("cancelFrame", this._drawFrame.getTitle()), Bundle.getMessage("QuestionTitle"), 0, 3);
            if (ans == 0) {
                this._drawFrame.closingEvent(true);
                return true;
            }
            this._drawFrame.toFront();
            this._drawFrame.setVisible(true);
            return false;
        }
        return true;
    }

    protected boolean setDrawFrame(DrawFrame f) {
        if (f == null) {
            this._drawFrame = null;
            if (this._currentSelection != null) {
                this._currentSelection.removeHandles();
                this._currentSelection = null;
            }
            return true;
        }
        if (this.makeNewShape()) {
            this._drawFrame = f;
            this._currentSelection = this._drawFrame._shape;
            this._currentSelection.drawHandles();
            this._editor.deselectSelectionGroup();
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        if (this._drawFrame instanceof DrawPolygon) {
            ((DrawPolygon)this._drawFrame).drawShape(g);
        }
    }

    public boolean doMousePressed(MouseEvent event, Positionable pos) {
        log.debug("Mouse Pressed _drawFrame= {}, _currentSelection= {}", (Object)(this._drawFrame == null ? "null" : this._drawFrame.getTitle()), (Object)(this._currentSelection == null ? "null" : this._currentSelection.getClass().getName()));
        if (this._drawFrame != null) {
            if (this._drawFrame instanceof DrawPolygon && this._drawFrame._shape != null) {
                ((DrawPolygon)this._drawFrame).anchorPoint(event.getX(), event.getY());
            }
            return true;
        }
        if (pos instanceof PositionableShape && this._editor.isEditable()) {
            if (this._currentSelection != null) {
                this._currentSelection.removeHandles();
            }
            this._currentSelection = (PositionableShape)pos;
            this._currentSelection.drawHandles();
            return true;
        }
        if (this._currentSelection != null) {
            this._currentSelection.removeHandles();
            this._currentSelection = null;
        }
        return false;
    }

    public boolean doMouseReleased(Positionable selection, MouseEvent event, Editor ed) {
        log.debug("Mouse Released _drawFrame= {}", (Object)(this._drawFrame == null ? "null" : this._drawFrame.getTitle()));
        if (this._drawFrame != null && this._drawFrame._shape == null && this._drawFrame._create) {
            if (this._drawFrame instanceof DrawPolygon) {
                ((DrawPolygon)this._drawFrame).makeVertex(event, ed);
            } else {
                Rectangle r = ed.getSelectRect();
                if (r == null) {
                    return false;
                }
                PositionableShape shape = this._drawFrame.makeFigure(r, ed);
                shape.setWidth(r.width);
                shape.setHeight(r.height);
                shape.setLocation(r.x, r.y);
                shape.updateSize();
                this._drawFrame.closingEvent(false);
                this._drawFrame = shape.makeEditFrame(true);
                try {
                    ed.putItem(shape);
                }
                catch (Positionable.DuplicateIdException e) {
                    log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
                }
                return true;
            }
        }
        return false;
    }

    public boolean doMouseClicked(MouseEvent event, Editor ed) {
        PositionableShape shape;
        log.debug("Mouse Clicked _drawFrame= {}", (Object)(this._drawFrame == null ? "null" : this._drawFrame.getTitle()));
        if (this._drawFrame != null && this._drawFrame._create && this._drawFrame instanceof DrawPolygon && event.getClickCount() > 1 && (shape = this._drawFrame.makeFigure(null, ed)) != null) {
            Point pt = ((DrawPolygon)this._drawFrame).getStartPoint();
            shape.setLocation(pt.x, pt.y);
            shape.updateSize();
            this._drawFrame.closingEvent(false);
            this._drawFrame = shape.makeEditFrame(true);
            try {
                ed.putItem(shape);
            }
            catch (Positionable.DuplicateIdException e) {
                log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public boolean doMouseDragged(MouseEvent event) {
        log.debug("Mouse Dragged _drawFrame= {}, _currentSelection= {}", (Object)(this._drawFrame == null ? "null" : this._drawFrame.getTitle()), (Object)(this._currentSelection == null ? "null" : this._currentSelection.getClass().getName()));
        if (this._currentSelection == null && this._drawFrame instanceof DrawPolygon) {
            ((DrawPolygon)this._drawFrame).moveTo(event.getX(), event.getY());
            return true;
        }
        if (this._currentSelection != null) {
            return this._currentSelection.doHandleMove(event);
        }
        return false;
    }

    public boolean doMouseMoved(MouseEvent event) {
        if (this._drawFrame instanceof DrawPolygon) {
            ((DrawPolygon)this._drawFrame).moveTo(event.getX(), event.getY());
            return true;
        }
        return false;
    }

    public void add(boolean up) {
        if (this._drawFrame instanceof DrawPolygon) {
            ((DrawPolygon)this._drawFrame).addVertex(up);
        }
    }

    public void delete() {
        if (this._drawFrame instanceof DrawPolygon) {
            ((DrawPolygon)this._drawFrame).deleteVertex();
        }
    }
}

