/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJComponent;
import jmri.jmrit.display.controlPanelEditor.ControlPanelEditor;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawFrame;
import jmri.util.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PositionableShape
extends PositionableJComponent
implements PropertyChangeListener {
    private Shape _shape;
    protected Color _lineColor = Color.black;
    protected Color _fillColor = new Color(255, 255, 255, 0);
    protected int _lineWidth = 1;
    private int _degrees;
    protected AffineTransform _transform;
    private NamedBeanHandle<Sensor> _controlSensor = null;
    private int _saveLevel = 3;
    private int _changeLevel = 5;
    private boolean _doHide;
    private Rectangle[] _handles;
    protected int _hitIndex = -1;
    protected int _lastX;
    protected int _lastY;
    protected int _width;
    protected int _height;
    protected DrawFrame _editFrame;
    static final int TOP = 0;
    static final int RIGHT = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 3;
    static final int SIZE = 4;
    private static final Logger log = LoggerFactory.getLogger(PositionableShape.class);

    public PositionableShape(Editor editor) {
        super(editor);
        super.setName("Graphic");
        super.setShowToolTip(false);
        super.setDisplayLevel(3);
    }

    public PositionableShape(Editor editor, @Nonnull Shape shape) {
        this(editor);
        this.setShape(shape);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getShape().getPathIterator(at);
    }

    protected void setShape(@Nonnull Shape s) {
        this._shape = s;
    }

    @Nonnull
    protected Shape getShape() {
        if (this._shape == null) {
            this._shape = this.makeShape();
        }
        return this._shape;
    }

    public AffineTransform getTransform() {
        return this._transform;
    }

    public void setWidth(int w) {
        this._width = Math.max(w, 4);
        this.invalidateShape();
    }

    public void setHeight(int h) {
        this._height = Math.max(h, 4);
        this.invalidateShape();
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Nonnull
    protected abstract Shape makeShape();

    protected void invalidateShape() {
        this._shape = null;
    }

    public void setLineColor(Color c) {
        if (c != null) {
            this._lineColor = c;
        }
        this.invalidateShape();
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public void setFillColor(Color c) {
        if (c != null) {
            this._fillColor = c;
        }
        this.invalidateShape();
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public void setLineWidth(int w) {
        this._lineWidth = w;
        this.invalidateShape();
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    @Override
    public void rotate(int deg) {
        this._degrees = deg % 360;
        if (this._degrees == 0) {
            this._transform = null;
        } else {
            double rad = Math.toRadians(this._degrees);
            this._transform = new AffineTransform();
            this._transform.setToRotation(rad, this._width >>> 1, this._height >>> 1);
        }
        this.updateSize();
    }

    @Override
    public void paint(Graphics g) {
        if (!this.getEditor().isEditable() && !this.isVisible()) {
            return;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (SystemType.isMacOSX() || SystemType.isWindows()) {
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        }
        g2d.setClip(null);
        if (this._transform != null) {
            g2d.transform(this._transform);
        }
        if (this._fillColor != null) {
            g2d.setColor(this._fillColor);
            g2d.fill(this.getShape());
        }
        if (this._lineColor != null) {
            BasicStroke stroke = new BasicStroke(this._lineWidth, 0, 0, 10.0f);
            g2d.setColor(this._lineColor);
            g2d.setStroke(stroke);
            g2d.draw(this.getShape());
        }
        this.paintHandles(g2d);
    }

    protected void paintHandles(Graphics2D g2d) {
        if (this._editor.isEditable() && this._handles != null) {
            g2d.setColor(Editor.HIGHLIGHT_COLOR);
            g2d.setStroke(new BasicStroke(2.0f));
            Rectangle r = this.getBounds();
            r.x = -this._lineWidth / 2;
            r.y = -this._lineWidth / 2;
            r.width += this._lineWidth;
            r.height += this._lineWidth;
            g2d.draw(r);
            Rectangle[] rectangleArray = this._handles;
            int n = this._handles.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle handle = rectangleArray[n2];
                if (handle != null) {
                    g2d.setColor(Color.RED);
                    g2d.fill(handle);
                    g2d.setColor(Editor.HIGHLIGHT_COLOR);
                    g2d.draw(handle);
                }
                ++n2;
            }
        }
    }

    @Override
    public abstract Positionable deepClone();

    protected Positionable finishClone(PositionableShape pos) {
        pos._lineWidth = this._lineWidth;
        if (this._fillColor != null) {
            pos._fillColor = new Color(this._fillColor.getRed(), this._fillColor.getGreen(), this._fillColor.getBlue(), this._fillColor.getAlpha());
        }
        if (this._lineColor != null) {
            pos._lineColor = new Color(this._lineColor.getRed(), this._lineColor.getGreen(), this._lineColor.getBlue(), this._lineColor.getAlpha());
        }
        pos._doHide = this._doHide;
        pos._changeLevel = this._changeLevel;
        pos.setControlSensor(this.getSensorName());
        pos.setWidth(this._width);
        pos.setHeight(this._height);
        pos.invalidateShape();
        pos.rotate(this.getDegrees());
        return super.finishClone(pos);
    }

    @Override
    public Dimension getSize(Dimension rv) {
        return new Dimension(this.maxWidth(), this.maxHeight());
    }

    @Override
    public void updateSize() {
        Rectangle r = this.getShape().getBounds();
        this.setWidth(r.width);
        this.setHeight(r.height);
        this.setSize(r.width, r.height);
        this.getEditor().repaint();
    }

    @Override
    public int maxWidth() {
        return this.getSize().width;
    }

    @Override
    public int maxHeight() {
        return this.getSize().height;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setRotateMenu(JPopupMenu popup) {
        if (super.getDisplayLevel() > 1) {
            popup.add(CoordinateEdit.getRotateEditAction(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean setScaleMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public int getDegrees() {
        return this._degrees;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("property change: \"{}\"= {} for {} {}", new Object[]{evt.getPropertyName(), evt.getNewValue(), this.getSensorName(), this.hashCode()});
        }
        if (!this._editor.isEditable()) {
            if (evt.getPropertyName().equals("KnownState")) {
                switch ((Integer)evt.getNewValue()) {
                    case 2: {
                        if (this._doHide) {
                            this.setVisible(true);
                            break;
                        }
                        super.setDisplayLevel(this._changeLevel);
                        this.setVisible(true);
                        break;
                    }
                    case 4: {
                        if (this._doHide) {
                            this.setVisible(false);
                            break;
                        }
                        super.setDisplayLevel(this._saveLevel);
                        this.setVisible(true);
                        break;
                    }
                    default: {
                        super.setDisplayLevel(this._saveLevel);
                        this.setVisible(true);
                    }
                }
                ((ControlPanelEditor)this._editor).mouseMoved(new MouseEvent(this, 503, System.currentTimeMillis(), 0, this.getX(), this.getY(), 0, false));
                this.repaint();
                this._editor.getTargetPanel().revalidate();
            }
        } else {
            super.setDisplayLevel(this._saveLevel);
            this.setVisible(true);
        }
        if (log.isDebugEnabled()) {
            log.debug("_changeLevel= {} _saveLevel= {} displayLevel= {} _doHide= {} visible= {}", new Object[]{this._changeLevel, this._saveLevel, this.getDisplayLevel(), this._doHide, this.isVisible()});
        }
    }

    @Override
    public void setDisplayLevel(int l) {
        super.setDisplayLevel(l);
        this._saveLevel = l;
    }

    public String setControlSensor(String pName) {
        String msg = null;
        log.debug("setControlSensor: name= {}", (Object)pName);
        if (pName == null || pName.trim().isEmpty()) {
            this.removeListener();
            this._controlSensor = null;
            return null;
        }
        Optional<SensorManager> sensorManager = InstanceManager.getOptionalDefault(SensorManager.class);
        if (sensorManager.isPresent()) {
            Sensor sensor = sensorManager.get().getSensor(pName);
            Optional<NamedBeanHandleManager> nbhm = InstanceManager.getOptionalDefault(NamedBeanHandleManager.class);
            if (sensor != null) {
                nbhm.ifPresent(namedBeanHandleManager -> {
                    this._controlSensor = namedBeanHandleManager.getNamedBeanHandle(pName, sensor);
                    NamedBeanHandle<Sensor> namedBeanHandle = this._controlSensor;
                });
            } else {
                msg = Bundle.getMessage("badSensorName", pName);
            }
        } else {
            msg = Bundle.getMessage("NoSensorManager");
        }
        if (msg != null) {
            log.warn("{} for {} sensor", (Object)msg, (Object)Bundle.getMessage("VisibleSensor"));
        }
        return msg;
    }

    public Sensor getControlSensor() {
        if (this._controlSensor == null) {
            return null;
        }
        return this._controlSensor.getBean();
    }

    protected String getSensorName() {
        Sensor s = this.getControlSensor();
        if (s != null) {
            return s.getDisplayName();
        }
        return null;
    }

    public NamedBeanHandle<Sensor> getControlSensorHandle() {
        return this._controlSensor;
    }

    public boolean isHideOnSensor() {
        return this._doHide;
    }

    public void setHide(boolean h) {
        this._doHide = h;
        if (this._doHide) {
            this._changeLevel = this._saveLevel;
        }
    }

    public int getChangeLevel() {
        return this._changeLevel;
    }

    public void setChangeLevel(int l) {
        this._changeLevel = l;
    }

    public void setListener() {
        if (this._controlSensor != null) {
            this.getControlSensor().addPropertyChangeListener(this, this.getSensorName(), "PositionalShape");
        }
    }

    protected void removeListener() {
        if (this._controlSensor != null) {
            this.getControlSensor().removePropertyChangeListener(this);
        }
    }

    protected abstract DrawFrame makeEditFrame(boolean var1);

    protected DrawFrame getEditFrame() {
        return this._editFrame;
    }

    public void removeHandles() {
        this._handles = null;
        this.invalidateShape();
        this.repaint();
    }

    public void drawHandles() {
        this._handles = new Rectangle[4];
        int rectSize = 8;
        if (this._width < rectSize || this._height < rectSize) {
            rectSize = Math.min(this._width, this._height);
        }
        this._handles[1] = new Rectangle(this._width - rectSize, this._height / 2 - rectSize / 2, rectSize, rectSize);
        this._handles[3] = new Rectangle(0, this._height / 2 - rectSize / 2, rectSize, rectSize);
        this._handles[0] = new Rectangle(this._width / 2 - rectSize / 2, 0, rectSize, rectSize);
        this._handles[2] = new Rectangle(this._width / 2 - rectSize / 2, this._height - rectSize, rectSize, rectSize);
    }

    public Point getInversePoint(int x, int y) throws NoninvertibleTransformException {
        if (this._transform != null) {
            AffineTransform t = this._transform.createInverse();
            float[] pt = new float[]{x, y};
            t.transform(pt, 0, pt, 0, 1);
            return new Point(Math.round(pt[0]), Math.round(pt[1]));
        }
        return new Point(x, y);
    }

    @Override
    public void doMousePressed(MouseEvent event) {
        this._hitIndex = -1;
        if (!this._editor.isEditable()) {
            return;
        }
        if (this._handles != null) {
            Point pt;
            this._lastX = event.getX();
            this._lastY = event.getY();
            int x = this._lastX - this.getX();
            int y = this._lastY - this.getY();
            try {
                pt = this.getInversePoint(x, y);
            }
            catch (NoninvertibleTransformException nte) {
                log.error("Can't locate Hit Rectangles {}", (Object)nte.getMessage());
                return;
            }
            int i = 0;
            while (i < this._handles.length) {
                if (this._handles[i] != null && this._handles[i].contains(pt.x, pt.y)) {
                    this._hitIndex = i;
                }
                ++i;
            }
            log.debug("doMousePressed _hitIndex= {}", (Object)this._hitIndex);
        }
    }

    protected boolean doHandleMove(MouseEvent event) {
        if (this._hitIndex >= 0 && this._editor.isEditable()) {
            int deltaX = event.getX() - this._lastX;
            int deltaY = event.getY() - this._lastY;
            int height = this._height;
            int width = this._width;
            switch (this._hitIndex) {
                case 0: {
                    if (this._height - deltaY > 4) {
                        height = this._height - deltaY;
                        this._editor.moveItem(this, 0, deltaY);
                    } else {
                        height = 4;
                    }
                    this.setHeight(height);
                    break;
                }
                case 1: {
                    width = Math.max(4, this._width + deltaX);
                    this.setWidth(width);
                    break;
                }
                case 2: {
                    height = Math.max(4, this._height + deltaY);
                    this.setHeight(height);
                    break;
                }
                case 3: {
                    if (this._width - deltaX > 4) {
                        width = Math.max(4, this._width - deltaX);
                        this._editor.moveItem(this, deltaX, 0);
                    } else {
                        width = 4;
                    }
                    this.setWidth(width);
                    break;
                }
                default: {
                    log.warn("Unhandled dir: {}", (Object)this._hitIndex);
                }
            }
            if (this._editFrame != null) {
                this._editFrame.setDisplayWidth(this._width);
                this._editFrame.setDisplayHeight(this._height);
            }
            this.invalidateShape();
            this.updateSize();
            this.drawHandles();
            this.repaint();
            this._lastX = event.getX();
            this._lastY = event.getY();
            log.debug("doHandleMove _hitIndex= {}", (Object)this._hitIndex);
            return true;
        }
        return false;
    }
}

