/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawFrame;
import jmri.jmrit.display.controlPanelEditor.shape.PositionablePolygon;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawPolygon
extends DrawFrame {
    ArrayList<Point> _vertices = new ArrayList();
    int _curX;
    int _curY;
    private static final int NEAR = 4;
    private final boolean _editing;
    private static final Logger log = LoggerFactory.getLogger(DrawPolygon.class);

    public DrawPolygon(String which, String title, PositionableShape ps, Editor ed, boolean create) {
        super(which, title, ps, ed, create);
        this._editing = ps != null;
    }

    @Override
    protected JPanel makeParamsPanel() {
        JPanel panel = super.makeParamsPanel();
        int x = this.getX();
        int y = this.getY();
        PathIterator iter = this._shape.getPathIterator(null);
        float[] coord = new float[6];
        if (this._editing) {
            while (!iter.isDone()) {
                iter.currentSegment(coord);
                this._vertices.add(new Point(x + Math.round(coord[0]), y + Math.round(coord[1])));
                iter.next();
            }
        }
        ((PositionablePolygon)this._shape).editing(this._editing);
        this._shape.drawHandles();
        panel.add(Box.createVerticalGlue());
        panel.add(new JLabel(Bundle.getMessage("drawInstructions2c")));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        JButton addButton = new JButton(Bundle.getMessage("ButtonAddVertex"));
        addButton.addActionListener(a -> this.addVertex(false));
        p.add(addButton);
        p.add(Box.createHorizontalGlue());
        JButton deleteButton = new JButton(Bundle.getMessage("ButtonDeleteVertex"));
        deleteButton.addActionListener(a -> this.deleteVertex());
        p.add(deleteButton);
        p.add(Box.createHorizontalGlue());
        panel.add(p);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    @Override
    protected PositionableShape makeFigure(Rectangle r, Editor ed) {
        Point spt = this.getStartPoint();
        this._shape = new PositionablePolygon(ed, this.makePath(spt));
        log.debug("makeFigure {} vertices", (Object)this._vertices.size());
        if (this._vertices.size() < 2) {
            return null;
        }
        return this._shape;
    }

    protected void moveTo(int x, int y) {
        if (!this._editing) {
            this._curX = x;
            this._curY = y;
        }
    }

    protected void anchorPoint(int x, int y) {
        log.debug("anchorPoint ({}, {})", (Object)x, (Object)y);
        this._curX = x;
        this._curY = y;
        Point anchorPt = new Point(x, y);
        for (Point vertex : this._vertices) {
            if (!DrawPolygon.near(vertex, anchorPt)) continue;
            this._curX = x;
            this._curY = y;
            return;
        }
    }

    protected void drawShape(Graphics g) {
        if (!this._editing) {
            if (this._vertices.size() < 1 || !(g instanceof Graphics2D)) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            GeneralPath path = this.makePath(new Point(0, 0));
            path.lineTo(this._curX, this._curY);
            g2d.draw(path);
        }
    }

    protected void makeVertex(MouseEvent event, Editor ed) {
        log.debug("makeVertex point= ({}, {}), _editing= {}", new Object[]{event.getX(), event.getY(), this._editing});
        if (!this._editing) {
            Point pt = new Point(event.getX(), event.getY());
            int size = this._vertices.size();
            if (size == 0 || !DrawPolygon.near(this._vertices.get(size - 1), pt)) {
                this._vertices.add(pt);
            }
        }
    }

    protected boolean doHandleMove(int hitIndex, Point pt) {
        Point p = this._vertices.get(hitIndex);
        p.x += pt.x;
        p.y += pt.y;
        if (this._editing) {
            this._shape.setShape(this.makePath(this.getStartPoint()));
        }
        return false;
    }

    private GeneralPath makePath(Point pt) {
        GeneralPath path = new GeneralPath(0, this._vertices.size() + 1);
        path.moveTo(this._vertices.get((int)0).x - pt.x, this._vertices.get((int)0).y - pt.y);
        int i = 1;
        while (i < this._vertices.size()) {
            path.lineTo(this._vertices.get((int)i).x - pt.x, this._vertices.get((int)i).y - pt.y);
            ++i;
        }
        return path;
    }

    protected Point getStartPoint() {
        if (this._vertices.size() > 0) {
            int x = this._vertices.get((int)0).x;
            int y = this._vertices.get((int)0).y;
            int i = 1;
            while (i < this._vertices.size()) {
                x = Math.min(x, this._vertices.get((int)i).x);
                y = Math.min(y, this._vertices.get((int)i).y);
                ++i;
            }
            return new Point(x, y);
        }
        this._vertices.add(new Point(this._curX, this._curY));
        return new Point(this._curX, this._curY);
    }

    private static boolean near(Point p1, Point p2) {
        return Math.abs(p1.x - p2.x) < 4 && Math.abs(p1.y - p2.y) < 4;
    }

    @Override
    void setDisplayWidth(int w) {
    }

    @Override
    void setDisplayHeight(int h) {
    }

    protected void addVertex(boolean up) {
        if (this._editing) {
            Point newVertex;
            int hitIndex = this._shape._hitIndex;
            if (hitIndex < 0) {
                if (this._vertices.size() > 1) {
                    hitIndex = this._vertices.size() - 1;
                } else {
                    hitIndex = 0;
                    if (this._vertices.size() == 0) {
                        this._vertices.add(new Point(this._curX, this._curY));
                    }
                }
                this._shape._hitIndex = hitIndex;
                up = true;
            }
            Point r1 = this._vertices.get(hitIndex);
            if (up) {
                if (hitIndex == this._vertices.size() - 1) {
                    newVertex = new Point(r1.x + 20, r1.y + 20);
                } else {
                    Point r2 = this._vertices.get(hitIndex + 1);
                    newVertex = new Point((r1.x + r2.x) / 2, (r1.y + r2.y) / 2);
                }
                ++this._shape._hitIndex;
                ++hitIndex;
            } else if (hitIndex > 0) {
                Point r2 = this._vertices.get(hitIndex - 1);
                newVertex = new Point((r1.x + r2.x) / 2, (r1.y + r2.y) / 2);
            } else {
                newVertex = new Point(r1.x + 20, r1.y + 20);
            }
            this._vertices.add(hitIndex, newVertex);
            this._shape.setShape(this.makePath(this.getStartPoint()));
            this._shape.drawHandles();
            this._shape.updateSize();
        }
    }

    protected void deleteVertex() {
        if (this._editing) {
            if (this._vertices.size() <= 2) {
                return;
            }
            int hitIndex = this._shape._hitIndex;
            if (hitIndex < 0) {
                hitIndex = this._vertices.size() - 1;
            }
            this._vertices.remove(hitIndex);
            if (hitIndex > 0) {
                --this._shape._hitIndex;
            }
            this._shape.setShape(this.makePath(this.getStartPoint()));
            this._shape.drawHandles();
            this._shape.updateSize();
        }
    }
}

