/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor.shape;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.controlPanelEditor.shape.Bundle;
import jmri.jmrit.display.controlPanelEditor.shape.DrawFrame;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableCircle;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;

public class DrawCircle
extends DrawFrame {
    JTextField _diameterText;

    public DrawCircle(String which, String title, PositionableShape ps, Editor ed, boolean create) {
        super(which, title, ps, ed, create);
    }

    @Override
    protected JPanel makeParamsPanel() {
        JPanel panel = super.makeParamsPanel();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel pp = new JPanel();
        this._diameterText = new JTextField(6);
        this._diameterText.setText(Integer.toString(this._shape.getWidth()));
        this._diameterText.setHorizontalAlignment(4);
        pp.add(this._diameterText);
        this._diameterText.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DrawCircle.this.updateShape();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DrawCircle.this._shape.setWidth(DrawCircle.this.getInteger(DrawCircle.this._diameterText, DrawCircle.this._shape.getWidth()));
                DrawCircle.this.updateShape();
            }
        });
        this._diameterText.addActionListener(e -> {
            this._shape.setWidth(this.getInteger(this._diameterText, this._shape.getWidth()));
            this.updateShape();
        });
        pp.add(new JLabel(Bundle.getMessage("circleRadius")));
        p.add(pp);
        panel.add(p);
        return panel;
    }

    @Override
    protected PositionableShape makeFigure(Rectangle r, Editor ed) {
        if (r != null) {
            int dia = Math.max(r.width, r.height);
            Ellipse2D.Double rr = new Ellipse2D.Double(0.0, 0.0, dia, dia);
            this._shape = new PositionableCircle(ed, rr);
        }
        return this._shape;
    }

    @Override
    void setDisplayWidth(int w) {
        this._diameterText.setText(Integer.toString(w));
    }

    @Override
    void setDisplayHeight(int h) {
        this._diameterText.setText(Integer.toString(h));
    }
}

