/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Portal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalList
extends JList<Portal> {
    private final PortalListModel _portalListModel;
    private static final Logger log = LoggerFactory.getLogger(PortalList.class);

    PortalList(OBlock block, EditFrame parent) {
        this._portalListModel = new PortalListModel(block, parent);
        this.setModel(this._portalListModel);
        this.setCellRenderer(new PortalCellRenderer());
        this.setPreferredSize(new Dimension(300, 120));
        this.setVisibleRowCount(5);
    }

    void dataChange() {
        this._portalListModel.dataChange();
    }

    void setSelected(Portal portal) {
        List<Portal> list = this._portalListModel._homeBlock.getPortals();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).equals(portal)) {
                this.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        this.clearSelection();
    }

    private static class PortalCellRenderer
    extends JLabel
    implements ListCellRenderer<Portal> {
        private PortalCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Portal> list, Portal value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.getDescription();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    static class PortalListModel
    extends AbstractListModel<Portal>
    implements PropertyChangeListener {
        OBlock _homeBlock;
        private final EditFrame _parent;
        List<Portal> _list = new ArrayList<Portal>();

        PortalListModel(OBlock block, EditFrame parent) {
            this._homeBlock = block;
            this._parent = parent;
            this._homeBlock.addPropertyChangeListener(this);
            this.makeList();
        }

        private void makeList() {
            for (Portal p : this._list) {
                p.removePropertyChangeListener(this);
            }
            this._list = this._homeBlock.getPortals();
            for (Portal p : this._list) {
                p.addPropertyChangeListener(this);
            }
        }

        @Override
        public int getSize() {
            return this._homeBlock.getPortals().size();
        }

        @Override
        public Portal getElementAt(int index) {
            if (index < this.getSize()) {
                return this._homeBlock.getPortals().get(index);
            }
            return null;
        }

        public void dataChange() {
            this.fireContentsChanged(this, 0, 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object source = e.getSource();
            String property = e.getPropertyName();
            if (log.isDebugEnabled()) {
                log.debug("property = {} source= {}", (Object)property, (Object)source.getClass().getName());
            }
            if (source instanceof OBlock && property.equals("deleted")) {
                this._homeBlock.removePropertyChangeListener(this);
                this._parent.closingEvent(true);
            } else {
                this.makeList();
                this.fireContentsChanged(this, 0, 0);
                if (property.equals("signalChange") || property.equals("NameChange")) {
                    this._parent.clearListSelection();
                }
            }
        }
    }
}

