/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.picker.PickSinglePanel;
import jmri.util.PlaceWindow;

public class OpenPickListButton<T extends NamedBean> {
    private final JPanel _buttonPanel;
    private JFrame _pickFrame;
    private JButton _openPicklistButton;
    String[] _blurbLines;
    PickListModel<T> _model;
    Window _parent;

    OpenPickListButton(String[] blurbLines, PickListModel<T> model, Window parent, String buttonCaption) {
        this._model = model;
        this._blurbLines = blurbLines;
        this._buttonPanel = this.makePickListPanel(buttonCaption);
        this._parent = parent;
    }

    private JPanel makePickListPanel(String buttonCaption) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this._openPicklistButton = new JButton(buttonCaption);
        this._openPicklistButton.addActionListener(a -> {
            if (this._pickFrame == null) {
                this.openPickList();
            } else {
                this.closePickList();
            }
        });
        panel.add(this._openPicklistButton);
        buttonPanel.add(panel);
        return buttonPanel;
    }

    public JPanel getButtonPanel() {
        return this._buttonPanel;
    }

    void openPickList() {
        this._pickFrame = new JFrame();
        this._pickFrame.setTitle(this._model.getName());
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        Border padding = BorderFactory.createEmptyBorder(10, 5, 3, 5);
        content.setBorder(padding);
        JPanel blurb = new JPanel();
        blurb.setLayout(new BoxLayout(blurb, 1));
        String[] stringArray = this._blurbLines;
        int n = this._blurbLines.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            blurb.add(new JLabel(text, 0));
            ++n2;
        }
        blurb.add(Box.createVerticalStrut(5));
        JPanel panel = new JPanel();
        panel.add(blurb);
        content.add(panel);
        PickSinglePanel<T> pickPanel = new PickSinglePanel<T>(this._model);
        content.add(pickPanel);
        content.setToolTipText(Bundle.getMessage("ToolTipPickLists"));
        pickPanel.setToolTipText(Bundle.getMessage("ToolTipPickLists"));
        pickPanel.getTable().setToolTipText(Bundle.getMessage("ToolTipPickLists"));
        this._pickFrame.setContentPane(content);
        this._pickFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenPickListButton.this.closePickList();
            }
        });
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._parent, null, this._pickFrame);
        this._pickFrame.toFront();
        this._pickFrame.setVisible(true);
        this._pickFrame.pack();
        this._openPicklistButton.setText(Bundle.getMessage("ClosePicklist"));
    }

    public void closePickList() {
        if (this._pickFrame != null) {
            this._pickFrame.dispose();
            this._pickFrame = null;
            this._openPicklistButton.setText(Bundle.getMessage("OpenPicklist", this._model.getName()));
        }
    }
}

