/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.logix.OBlock;

public class LengthPanel
extends JPanel {
    private final OBlock _block;
    private float _length;
    private String _label;
    private final JTextField _lengthField;
    private final JToggleButton _units;
    private static final DecimalFormat _lenFormat = new DecimalFormat("###,##0.0");
    public static final String PATH_LENGTH = "pathLength";
    public static final String BLOCK_LENGTH = "blockLength";
    public static final String ENTRANCE_SPACE = "entranceSpace";

    LengthPanel(OBlock block, String label, String tip) {
        this._block = block;
        this._label = label;
        JPanel pp = new JPanel();
        this._lengthField = new JTextField();
        this._lengthField.setText(_lenFormat.format(0.0));
        pp.add(CircuitBuilder.makeTextBoxPanel(false, this._lengthField, this._label, true, tip));
        this._lengthField.setPreferredSize(new Dimension(100, this._lengthField.getPreferredSize().height));
        this._units = new JToggleButton("", !this._block.isMetric());
        this._units.setToolTipText(Bundle.getMessage("TooltipPathUnitButton"));
        this._units.addActionListener(event -> this.changeUnits());
        pp.add(this._units);
        this.add(pp);
    }

    protected void changeUnits() {
        String len = this._lengthField.getText();
        if (len == null || len.length() == 0) {
            if (this._block != null && this._block.isMetric()) {
                this._units.setText("cm");
            } else {
                this._units.setText("in");
            }
            return;
        }
        try {
            float f = Float.parseFloat(len.replace(',', '.'));
            if (this._units.isSelected()) {
                this._lengthField.setText(_lenFormat.format(f / 2.54f));
                this._units.setText("in");
            } else {
                this._lengthField.setText(_lenFormat.format(f * 2.54f));
                this._units.setText("cm");
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MustBeFloat", len), Bundle.getMessage("makePath"), 1);
        }
    }

    protected void setLength(float len) {
        this._length = len;
        if (this._units.isSelected()) {
            this._lengthField.setText(_lenFormat.format(len / 25.4f));
        } else {
            this._lengthField.setText(_lenFormat.format(len / 10.0f));
        }
    }

    protected float getLength() {
        String num = null;
        float f = -1.0f;
        try {
            num = this._lengthField.getText();
            if (num == null || num.length() == 0) {
                num = "0.0";
            }
            f = Float.parseFloat(num.replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {}
        if (this._label.equals(PATH_LENGTH) || this._label.equals(BLOCK_LENGTH)) {
            if (f < 0.0f) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("MustBeFloat", num), Bundle.getMessage("makePath"), 1);
            } else {
                this._length = this._units.isSelected() ? f * 25.4f : f * 10.0f;
            }
        } else {
            this._length = this._units.isSelected() ? f * 25.4f : f * 10.0f;
        }
        return this._length;
    }

    protected boolean isChanged(float len) {
        return (double)Math.abs(this.getLength() - len) > 0.5;
    }
}

