/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSourceDropEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Signal;
import jmri.SignalAppearanceMap;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrit.beantable.AbstractTableAction;
import jmri.jmrit.beantable.BeanTableFrame;
import jmri.jmrit.beantable.SignalHeadTableAction;
import jmri.jmrit.beantable.SignalMastTableAction;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.SignalMastIcon;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.LengthPanel;
import jmri.jmrit.display.controlPanelEditor.OpenPickListButton;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.display.controlPanelEditor.PortalList;
import jmri.jmrit.display.controlPanelEditor.SignalList;
import jmri.jmrit.display.controlPanelEditor.SignalPair;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSignalFrame
extends EditFrame {
    private PortalIcon _portalIcon;
    private JTextField _mastName;
    private PortalList _portalList;
    private SignalList _signalList;
    private LengthPanel _lengthPanel;
    private Portal _currentPortal;
    OpenPickListButton<SignalMast> _pickMast;
    OpenPickListButton<SignalHead> _pickHead;
    AbstractTableAction<SignalMast> _mastTableAction;
    AbstractTableAction<SignalHead> _headTableAction;
    JPanel _dndPanel;
    private IconDragJLabel _dragLabel;
    SignalHeadIcon _dragHeadIcon;
    private static final Logger log = LoggerFactory.getLogger(EditSignalFrame.class);

    public EditSignalFrame(String title, CircuitBuilder parent, OBlock block) {
        super(title, parent, block);
        this.checkCircuitIcons("BlockSignal");
        this.pack();
    }

    @Override
    protected JPanel makeContentPanel() {
        JPanel signalPanel = new JPanel();
        signalPanel.setLayout(new BoxLayout(signalPanel, 1));
        JPanel panel = new JPanel();
        panel.add(new JLabel(Bundle.getMessage("PortalTitle", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME))));
        signalPanel.add(panel);
        this._portalList = new PortalList(this._homeBlock, this);
        this._portalList.addListSelectionListener(new PortalListListener(this));
        signalPanel.add(new JScrollPane(this._portalList));
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        panel = new JPanel();
        panel.add(new JLabel(Bundle.getMessage("SignalTitle", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME))));
        signalPanel.add(panel);
        this._signalList = new SignalList(this._homeBlock, this);
        this._signalList.addListSelectionListener(new SignalListListener(this));
        signalPanel.add(new JScrollPane(this._signalList));
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        JButton clearButton = new JButton(Bundle.getMessage("buttonClearSelection"));
        clearButton.addActionListener(a -> {
            this._portalList.clearSelection();
            this._signalList.clearSelection();
            this._parent._editor.highlight(null);
            this._mastName.setText(null);
        });
        panel = new JPanel();
        panel.add(clearButton);
        signalPanel.add(panel);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        JPanel framingPanel = new JPanel();
        JPanel mastConfigPanel = new JPanel();
        mastConfigPanel.setBorder(BorderFactory.createEtchedBorder());
        mastConfigPanel.setLayout(new BoxLayout(mastConfigPanel, 1));
        panel = new JPanel();
        this._mastName = new JTextField();
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._mastName, "mastName", true, null));
        this._mastName.setPreferredSize(new Dimension(300, this._mastName.getPreferredSize().height));
        this._mastName.setToolTipText(Bundle.getMessage("ToolTipMastName", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME)));
        mastConfigPanel.add(panel);
        this._lengthPanel = new LengthPanel(this._homeBlock, "entranceSpace", "OffsetToolTip");
        this._lengthPanel.changeUnits();
        mastConfigPanel.add(this._lengthPanel);
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton(Bundle.getMessage("ButtonAddMast"));
        addButton.addActionListener(a -> {
            boolean bl = this.addMast();
        });
        addButton.setToolTipText(Bundle.getMessage("ToolTipAddMast", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME)));
        buttonPanel.add(addButton);
        JButton buttonRemove = new JButton(Bundle.getMessage("ButtonRemoveMast"));
        buttonRemove.addActionListener(a -> this.removeMast());
        buttonRemove.setToolTipText(Bundle.getMessage("ToolTipRemoveMast", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME)));
        buttonPanel.add(buttonRemove);
        mastConfigPanel.add(buttonPanel);
        framingPanel.add(mastConfigPanel);
        signalPanel.add(framingPanel);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel l = new JLabel(Bundle.getMessage("addSignalConfig"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("selectSignalMast"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("pressConfigure", Bundle.getMessage("ButtonAddMast")));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        l = new JLabel(Bundle.getMessage("addSignalIcon"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("positionMast"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        JPanel p = new JPanel();
        p.add(panel);
        signalPanel.add(p);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        panel = new JPanel();
        l = new JLabel(Bundle.getMessage("recommendMasts"));
        panel.add(l);
        signalPanel.add(panel);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        String[] blurbLines = new String[]{Bundle.getMessage("DragMast", Bundle.getMessage("mastName"))};
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this._pickMast = new OpenPickListButton<SignalMast>(blurbLines, PickListModel.signalMastPickModelInstance(), this, Bundle.getMessage("OpenPicklist", Bundle.getMessage("BeanNameSignalMast")));
        this._mastTableAction = new SignalMastTableAction(Bundle.getMessage("ButtonCreateMast"));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this._pickMast.getButtonPanel());
        JPanel pp = new JPanel();
        pp.setLayout(new FlowLayout());
        JButton buttonCreate = new JButton(Bundle.getMessage("ButtonCreateMast"));
        buttonCreate.addActionListener(this._mastTableAction);
        buttonCreate.setToolTipText(Bundle.getMessage("ToolTipAddToTable"));
        pp.add(buttonCreate);
        p.add(pp);
        panel.add(p);
        this._pickHead = new OpenPickListButton<SignalHead>(blurbLines, PickListModel.signalHeadPickModelInstance(), this, Bundle.getMessage("OpenPicklist", Bundle.getMessage("BeanNameSignalHead")));
        this._headTableAction = new SignalHeadTableAction(Bundle.getMessage("ButtonCreateHead"));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this._pickHead.getButtonPanel());
        pp = new JPanel();
        pp.setLayout(new FlowLayout());
        buttonCreate = new JButton(Bundle.getMessage("ButtonCreateHead"));
        buttonCreate.addActionListener(this._headTableAction);
        buttonCreate.setToolTipText(Bundle.getMessage("ToolTipAddToTable"));
        pp.add(buttonCreate);
        p.add(pp);
        panel.add(p);
        signalPanel.add(panel);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        l = new JLabel(Bundle.getMessage("modifySignal"));
        panel.add(l);
        signalPanel.add(panel);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        this._dndPanel = this.makeDndIconPanel();
        signalPanel.add(this._dndPanel);
        signalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        signalPanel.add(this.makeDoneButtonPanel());
        return signalPanel;
    }

    protected void setSelected(PositionableIcon icon) {
        if (!this.canEdit()) {
            return;
        }
        NamedBean mast = null;
        Portal portal = null;
        if (icon instanceof PortalIcon) {
            portal = ((PortalIcon)icon).getPortal();
        } else if (icon instanceof SignalMastIcon) {
            mast = ((SignalMastIcon)icon).getSignalMast();
        } else if (icon instanceof SignalHeadIcon) {
            mast = ((SignalHeadIcon)icon).getSignalHead();
        } else {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("setSelected portal= \"{}\" mast ={}", (Object)(portal != null ? portal.getName() : "null"), (Object)(mast != null ? mast.getDisplayName() : "null"));
        }
        this._portalIcon = null;
        if (portal != null) {
            mast = portal.getSignalProtectingBlock(this._homeBlock);
            if (mast != null) {
                this.setMastNameAndIcon(mast, portal);
            }
        } else if (mast != null) {
            OBlock protectedBlock;
            portal = this._parent.getSignalPortal(mast);
            if (portal != null && this._homeBlock.equals(protectedBlock = portal.getProtectedBlock(mast))) {
                this.setMastNameAndIcon(mast, portal);
            }
            this._portalList.setSelected(portal);
            this._signalList.setSelected(portal);
            this._parent._editor.highlight(icon);
        }
    }

    private void setMastNameAndIcon(NamedBean mast, Portal portal) {
        this._mastName.setText(mast.getDisplayName(NamedBean.DisplayOptions.DISPLAYNAME));
        this._parent._editor.highlight(null);
        List<PositionableIcon> siArray = this._parent.getSignalIconMap(mast);
        for (PositionableIcon si : siArray) {
            this._parent._editor.highlight(si);
        }
        List<PortalIcon> piArray = this._parent.getPortalIcons(portal);
        for (PortalIcon pi : piArray) {
            this._parent._editor.highlight(pi);
        }
    }

    private boolean replaceQuestion(@Nonnull NamedBean mast, @Nonnull Portal homePortal) {
        int answer;
        StringBuffer sb = new StringBuffer();
        Portal portal = this._parent.getSignalPortal(mast);
        OBlock blk = null;
        if (portal != null && (blk = portal.getProtectedBlock(mast)) != null && !blk.equals(this._homeBlock)) {
            sb.append(Bundle.getMessage("mastProtectsPortal", mast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME), blk.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME), portal.getName()));
            sb.append("\n");
        }
        NamedBean homeMast = homePortal.getSignalProtectingBlock(this._homeBlock);
        String mastName = mast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
        String homeName = this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
        if (homeMast != null) {
            if (homeMast.equals(mast)) {
                homePortal.setEntranceSpaceForBlock(this._homeBlock, this._lengthPanel.getLength());
                return false;
            }
            String homeMastName = homeMast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
            sb.append(Bundle.getMessage("mastProtectsPortal", homeMastName, homeName, homePortal.getName()));
            sb.append("\n");
            sb.append(Bundle.getMessage("replaceSignalMast", homeMast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME), mastName, homePortal.getName()));
        } else if (sb.length() > 0) {
            sb.append(Bundle.getMessage("noMast", homePortal.getName(), homeName));
            sb.append("\n");
            sb.append(Bundle.getMessage("setSignal", mastName));
            sb.append("\n");
            sb.append(Bundle.getMessage("attachMast", mastName, homeName, homePortal.getName()));
        }
        if (sb.length() > 0 && (answer = JOptionPane.showConfirmDialog(this, sb.toString(), Bundle.getMessage("configureSignal"), 0, 3)) != 0) {
            return false;
        }
        if (homeMast != null) {
            homePortal.setProtectSignal(null, 0.0f, blk);
        }
        this._parent.putSignalPortal(mast, null);
        return true;
    }

    private NamedBean getSignal() {
        String name = this._mastName.getText();
        if (name.trim().length() == 0) {
            return null;
        }
        Signal signal = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(name);
        if (signal == null) {
            signal = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        }
        return signal;
    }

    private void addMast(@Nonnull Portal portal, @Nonnull NamedBean newMast) {
        SignalMast mast;
        if (log.isDebugEnabled()) {
            log.debug("addMast \"{}\"", (Object)newMast.getDisplayName());
        }
        if (newMast instanceof SignalMast && (mast = (SignalMast)newMast).getAspect() == null) {
            mast.setAspect(mast.getValidAspects().get(0));
        }
        portal.setProtectSignal(newMast, this._lengthPanel.getLength(), this._homeBlock);
        this._parent.putSignalPortal(newMast, portal);
        this.setDragIcon(newMast);
    }

    private boolean addMast() {
        Portal portal = (Portal)this._portalList.getSelectedValue();
        String msg = null;
        if (portal != null) {
            NamedBean signal = this.getSignal();
            if (signal != null) {
                if (this.replaceQuestion(signal, portal)) {
                    this.addMast(portal, signal);
                }
            } else {
                String name = this._mastName.getText().trim();
                msg = name.length() == 0 ? Bundle.getMessage("selectSignalMast") : Bundle.getMessage("NotFound", name);
            }
        } else {
            msg = Bundle.getMessage("selectPortalProtection", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME));
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("configureSignal"), 1);
            return false;
        }
        return true;
    }

    private void removeMast() {
        Portal portal = (Portal)this._portalList.getSelectedValue();
        NamedBean oldMast = null;
        if (portal == null) {
            this._mastName.setText(null);
            return;
        }
        oldMast = portal.getSignalProtectingBlock(this._homeBlock);
        if (oldMast != null) {
            this._mastName.setText(null);
            portal.setProtectSignal(null, 0.0f, this._homeBlock);
            this._parent.putSignalPortal(oldMast, null);
        } else {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("noPortalProtection", this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME), portal.getName()), Bundle.getMessage("configureSignal"), 1);
        }
        this._mastName.setText(null);
    }

    private String checkMastForSave() {
        if (this._currentPortal == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        NamedBean selectedMast = this.getSignal();
        NamedBean currentMast = this._currentPortal.getSignalProtectingBlock(this._homeBlock);
        if (selectedMast == null) {
            if (currentMast != null) {
                String curMastName = currentMast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
                String curPortalName = this._currentPortal.getName();
                sb.append(Bundle.getMessage("mastProtectsPortal", curMastName, this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME), curPortalName));
                sb.append("\n");
                String name = this._mastName.getText();
                if (name.trim().length() > 0) {
                    sb.append(Bundle.getMessage("NotFound", name));
                    sb.append("\n");
                    String type = currentMast instanceof SignalMast ? Bundle.getMessage("BeanNameSignalMast") : Bundle.getMessage("BeanNameSignalHead");
                    sb.append(Bundle.getMessage("changeOrCancel", curMastName, name, type));
                } else {
                    sb.append(Bundle.getMessage("removeSignalMast", curMastName, curPortalName));
                }
            }
        } else {
            String selMastName = selectedMast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
            String curPortalName = this._currentPortal.getName();
            String homeName = this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
            if (!selectedMast.equals(currentMast)) {
                if (currentMast != null) {
                    OBlock blk;
                    Portal selectedPortal = this._parent.getSignalPortal(selectedMast);
                    if (selectedPortal != null && (blk = selectedPortal.getProtectedBlock(selectedMast)) != null) {
                        sb.append(Bundle.getMessage("mastProtectsPortal", selMastName, blk.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME), selectedPortal.getName()));
                        sb.append("\n");
                    }
                    String curMastName = currentMast.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME);
                    sb.append(Bundle.getMessage("mastProtectsPortal", curMastName, homeName, curPortalName));
                    sb.append("\n");
                    sb.append(Bundle.getMessage("replaceSignalMast", curMastName, selMastName, curPortalName));
                    sb.append("\n");
                    if (this._lengthPanel.isChanged(this._currentPortal.getEntranceSpaceForBlock(this._homeBlock))) {
                        sb.append(Bundle.getMessage("spaceChanged", selMastName, this._currentPortal.getName()));
                    }
                } else {
                    sb.append(Bundle.getMessage("noMast", curPortalName, homeName));
                    sb.append("\n");
                    sb.append(Bundle.getMessage("setSignal", selMastName));
                    sb.append("\n");
                    sb.append(Bundle.getMessage("attachMast", selMastName, homeName, this._currentPortal.getName()));
                }
            }
        }
        return sb.toString();
    }

    @Override
    protected void closingEvent(boolean close) {
        BeanTableFrame<Signal> frame;
        StringBuffer sb = new StringBuffer();
        String msg = this._parent.checkForPortals(this._homeBlock, "ItemTypeSignalMast");
        if (msg.length() > 0) {
            sb.append(msg);
            sb.append("\n");
        }
        if ((msg = this.checkMastForSave()).length() > 0) {
            sb.append(msg);
            sb.append("\n");
        }
        this.closingEvent(close, sb.toString());
        if (this._pickMast != null) {
            this._pickMast.closePickList();
        }
        if (this._pickHead != null) {
            this._pickHead.closePickList();
        }
        if (this._mastTableAction != null) {
            this._mastTableAction.dispose();
            frame = this._mastTableAction.getFrame();
            if (frame != null) {
                frame.dispose();
            }
        }
        if (this._headTableAction != null) {
            this._headTableAction.dispose();
            frame = this._headTableAction.getFrame();
            if (frame != null) {
                frame.dispose();
            }
        }
    }

    private void setDragIcon(NamedBean signal) {
        NamedIcon icon = null;
        if (signal != null) {
            if (signal instanceof SignalMast) {
                icon = this.setDragMastIcon((SignalMast)signal);
            } else if (signal instanceof SignalHead) {
                icon = this.setDragHeadIcon((SignalHead)signal);
            }
        }
        if (icon == null) {
            this._dragLabel.setText(Bundle.getMessage("noIcon"));
        } else {
            this._dragLabel.setText(null);
        }
        this._dragLabel.setIcon(icon);
        this._dndPanel.invalidate();
        this.invalidate();
        this.pack();
    }

    private NamedIcon setDragMastIcon(SignalMast mast) {
        String family = mast.getSignalSystem().getSystemName();
        SignalAppearanceMap appMap = mast.getAppearanceMap();
        Enumeration<String> e = mast.getAppearanceMap().getAspects();
        String s = appMap.getImageLink("Clear", family);
        if (s == null || s.equals("")) {
            s = appMap.getImageLink("Stop", family);
        }
        if (s == null || s.equals("")) {
            s = appMap.getImageLink(e.nextElement(), family);
        }
        if (s != null && !s.equals("")) {
            if (!s.contains("preference:")) {
                s = s.substring(s.indexOf("resources"));
            }
            return new NamedIcon(s, s);
        }
        log.error("SignalMast icon cannot be found for {}", (Object)mast.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
        return null;
    }

    private NamedIcon setDragHeadIcon(SignalHead mast) {
        HashMap<NamedBean, ArrayList<PositionableIcon>> icons;
        PositionableIcon pos;
        this._dragHeadIcon = null;
        List<PositionableIcon> iArray = this._parent.getSignalIconMap(mast);
        if (!iArray.isEmpty() && (pos = iArray.get(0)) instanceof SignalHeadIcon) {
            this._dragHeadIcon = (SignalHeadIcon)pos;
        }
        if (this._dragHeadIcon == null && (icons = this._parent.getSignalIconMap()) != null && !icons.isEmpty()) {
            for (List list : icons.values()) {
                PositionableIcon pos2;
                if (list.isEmpty() || !((pos2 = (PositionableIcon)list.get(0)) instanceof SignalHeadIcon)) continue;
                this._dragHeadIcon = (SignalHeadIcon)pos2;
                break;
            }
        }
        if (this._dragHeadIcon == null) {
            this._dragHeadIcon = new SignalHeadIcon(this._parent._editor);
            this._dragHeadIcon.setSignalHead(mast.getDisplayName());
            HashMap<String, HashMap<String, NamedIcon>> maps = ItemPalette.getFamilyMaps("SignalHead");
            if (maps.isEmpty()) {
                log.error("SignalHead icon cannot be found for {}", (Object)mast.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
            } else {
                Iterator<Object> iterator = maps.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    HashMap map = (HashMap)entry.getValue();
                    for (Map.Entry ent : map.entrySet()) {
                        this._dragHeadIcon.setIcon((String)ent.getKey(), new NamedIcon((NamedIcon)ent.getValue()));
                    }
                    this._dragHeadIcon.setFamily((String)entry.getKey());
                }
            }
        } else {
            this._dragHeadIcon = (SignalHeadIcon)this._dragHeadIcon.deepClone();
        }
        this._dragHeadIcon.setDisplayLevel(1);
        return (NamedIcon)this._dragHeadIcon.getIcon();
    }

    protected JPanel makeDndIconPanel() {
        JPanel dndPanel = new JPanel();
        dndPanel.setLayout(new BoxLayout(dndPanel, 1));
        JPanel p = new JPanel();
        JLabel l = new JLabel(Bundle.getMessage("dragIcon"));
        p.add(l);
        dndPanel.add(p);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("signal")));
        try {
            this._dragLabel = new IconDragJLabel(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"));
            this._dragLabel.setIcon(null);
            this._dragLabel.setText(Bundle.getMessage("noIcon"));
            this._dragLabel.setName(Bundle.getMessage("signal"));
            panel.add(this._dragLabel);
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
        }
        dndPanel.add(panel);
        dndPanel.setVisible(true);
        return dndPanel;
    }

    public class IconDragJLabel
    extends DragJLabel {
        NamedBean signal;

        public IconDragJLabel(DataFlavor flavor) {
            super(flavor);
        }

        @Override
        protected boolean okToDrag() {
            String msg;
            if (EditSignalFrame.this._currentPortal == null) {
                msg = Bundle.getMessage("selectPortalProtection", EditSignalFrame.this._homeBlock.getDisplayName(NamedBean.DisplayOptions.QUOTED_DISPLAYNAME));
            } else {
                String name;
                this.signal = EditSignalFrame.this.getSignal();
                msg = this.signal != null ? EditSignalFrame.this.checkMastForSave() : ((name = EditSignalFrame.this._mastName.getText().trim()).length() == 0 ? Bundle.getMessage("selectSignalMast") : Bundle.getMessage("NotFound", name));
            }
            if (msg.length() > 0) {
                JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("configureSignal"), 1);
                return false;
            }
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            PositionableIcon icon;
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return null;
            }
            if (this.signal == null || EditSignalFrame.this._currentPortal == null) {
                return null;
            }
            if (this.signal instanceof SignalMast) {
                icon = new SignalMastIcon(EditSignalFrame.this._parent._editor);
                ((SignalMastIcon)icon).setSignalMast(this.signal.getDisplayName());
            } else if (this.signal instanceof SignalHead) {
                icon = EditSignalFrame.this._dragHeadIcon;
            } else {
                log.error("Signal icon cannot be created for {}", (Object)this.signal.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
                return null;
            }
            EditSignalFrame.this._parent.getCircuitIcons(EditSignalFrame.this._homeBlock).add(icon);
            List<PositionableIcon> siArray = EditSignalFrame.this._parent.getSignalIconMap(this.signal);
            siArray.add(icon);
            EditSignalFrame.this._parent._editor.highlight(icon);
            icon.setLevel(9);
            log.debug("getTransferData for {}", (Object)this.signal.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
            return icon;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            EditSignalFrame.this.setMastNameAndIcon(this.signal, EditSignalFrame.this._currentPortal);
            log.debug("DragJLabel.dragDropEnd ");
        }
    }

    class PortalListListener
    implements ListSelectionListener {
        EditFrame _frame;

        PortalListListener(EditFrame parent) {
            this._frame = parent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Portal portal = (Portal)EditSignalFrame.this._portalList.getSelectedValue();
            if (log.isDebugEnabled()) {
                log.debug("PortalList: valueChanged: portal = {}, _currentPortal = {}", (Object)(portal == null ? "null" : portal.getName()), (Object)(EditSignalFrame.this._currentPortal == null ? "null" : EditSignalFrame.this._currentPortal.getName()));
            }
            NamedBean mast = null;
            if (portal != null) {
                String msg;
                mast = portal.getSignalProtectingBlock(EditSignalFrame.this._homeBlock);
                if (!portal.equals(EditSignalFrame.this._currentPortal) && (msg = EditSignalFrame.this.checkMastForSave()).length() > 0) {
                    StringBuffer sb = new StringBuffer(msg);
                    NamedBean bean = EditSignalFrame.this.getSignal();
                    sb.append("\n");
                    sb.append(Bundle.getMessage("saveChanges"));
                    int answer = JOptionPane.showConfirmDialog(this._frame, sb.toString(), Bundle.getMessage("configureSignal"), 0, 3);
                    if (answer == 0) {
                        if (bean != null) {
                            EditSignalFrame.this.addMast(EditSignalFrame.this._currentPortal, bean);
                        }
                        return;
                    }
                }
            }
            if (EditSignalFrame.this._portalIcon == null) {
                EditSignalFrame.this._parent._editor.highlight(null);
            }
            EditSignalFrame.this._currentPortal = portal;
            if (portal != null) {
                EditSignalFrame.this._lengthPanel.setLength(portal.getEntranceSpaceForBlock(EditSignalFrame.this._homeBlock));
                List<PortalIcon> piArray = EditSignalFrame.this._parent.getPortalIcons(portal);
                if (!piArray.isEmpty()) {
                    EditSignalFrame.this._portalIcon = piArray.get(0);
                }
            }
            if (mast != null) {
                EditSignalFrame.this.setMastNameAndIcon(mast, portal);
            } else {
                EditSignalFrame.this._parent._editor.highlight(null);
                EditSignalFrame.this._mastName.setText(null);
                if (portal != null) {
                    EditSignalFrame.this._parent._editor.highlight(EditSignalFrame.this._portalIcon);
                }
                EditSignalFrame.this._lengthPanel.setLength(0.0f);
            }
            EditSignalFrame.this._signalList.setSelected(portal);
            EditSignalFrame.this.setDragIcon(mast);
        }
    }

    class SignalListListener
    implements ListSelectionListener {
        EditFrame _frame;

        SignalListListener(EditFrame parent) {
            this._frame = parent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            NamedBean signal;
            SignalPair sp = (SignalPair)EditSignalFrame.this._signalList.getSelectedValue();
            if (log.isDebugEnabled()) {
                if (sp != null) {
                    log.debug("SignalList: valueChanged: portal = {}, signal = {}", (Object)sp._portal.getName(), (Object)sp._signal.getDisplayName());
                } else {
                    log.debug("SignalList: valueChanged: signalPair null");
                }
            }
            if (sp != null) {
                EditSignalFrame.this._portalList.setSelected(sp._portal);
                signal = sp._signal;
            } else {
                signal = null;
            }
            EditSignalFrame.this.setDragIcon(signal);
        }
    }
}

