/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.InstanceManager;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.display.controlPanelEditor.PortalList;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Portal;
import jmri.jmrit.logix.PortalManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditPortalFrame
extends EditFrame
implements ListSelectionListener {
    private PortalList _portalList;
    private JTextField _portalName;
    private Portal _currentPortal;
    private static final Logger log = LoggerFactory.getLogger(EditPortalFrame.class);

    public EditPortalFrame(String title, CircuitBuilder parent, OBlock block, Portal portal, PortalIcon icon) {
        this(title, parent, block);
        String name = portal.getName();
        this._portalName.setText(name);
        StringBuilder sb = new StringBuilder();
        if (icon != null) {
            this.setSelected(icon);
        } else {
            sb.append(Bundle.getMessage("portalHasNoIcon", name));
            sb.append("\n");
        }
        if (this._canEdit) {
            String msg = this._parent.checkForPortals(block, "BlockPaths");
            if (msg.length() > 0) {
                sb.append(msg);
                sb.append("\n");
                sb.append(Bundle.getMessage("portIconPosition1"));
                sb.append("\n");
                sb.append(Bundle.getMessage("portIconPosition2"));
                sb.append("\n");
            } else {
                msg = this._parent.checkForPortalIcons(block, "DirectionArrow");
                if (msg.length() > 0) {
                    sb.append(msg);
                    sb.append("\n");
                }
            }
        }
        if (sb.toString().length() > 0) {
            JOptionPane.showMessageDialog(this, sb.toString(), Bundle.getMessage("incompleteCircuit"), 1);
        }
    }

    public EditPortalFrame(String title, CircuitBuilder parent, OBlock block) {
        super(title, parent, block);
        this.pack();
        String msg = this._parent.checkForTrackIcons(block, "BlockPortals");
        if (msg.length() > 0) {
            this._canEdit = false;
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("incompleteCircuit"), 1);
        }
    }

    @Override
    protected JPanel makeContentPanel() {
        JPanel portalPanel = new JPanel();
        portalPanel.setLayout(new BoxLayout(portalPanel, 1));
        JPanel panel = new JPanel();
        panel.add(new JLabel(Bundle.getMessage("PortalTitle", this._homeBlock.getDisplayName())));
        portalPanel.add(panel);
        this._portalName = new JTextField();
        this._portalList = new PortalList(this._homeBlock, this);
        this._portalList.addListSelectionListener(this);
        portalPanel.add(new JScrollPane(this._portalList));
        JButton clearButton = new JButton(Bundle.getMessage("buttonClearSelection"));
        clearButton.addActionListener(a -> this.clearListSelection());
        panel = new JPanel();
        panel.add(clearButton);
        portalPanel.add(panel);
        portalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._portalName, "portalName", true, null));
        this._portalName.setPreferredSize(new Dimension(300, this._portalName.getPreferredSize().height));
        this._portalName.setToolTipText(Bundle.getMessage("TooltipPortalName"));
        portalPanel.add(panel);
        panel = new JPanel();
        JButton changeButton = new JButton(Bundle.getMessage("buttonChangeName"));
        changeButton.addActionListener(a -> this.changePortalName());
        changeButton.setToolTipText(Bundle.getMessage("ToolTipChangeName"));
        panel.add(changeButton);
        JButton deleteButton = new JButton(Bundle.getMessage("buttonDeletePortal"));
        deleteButton.addActionListener(a -> this.deletePortal());
        deleteButton.setToolTipText(Bundle.getMessage("ToolTipDeletePortal"));
        panel.add(deleteButton);
        portalPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        portalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        JLabel l = new JLabel(Bundle.getMessage("enterNameToDrag"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("dragNewIcon"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        l = new JLabel(Bundle.getMessage("selectPortal"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        l = new JLabel(Bundle.getMessage("portIconPosition1"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("portIconPosition2"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        JPanel p = new JPanel();
        p.add(panel);
        portalPanel.add(p);
        portalPanel.add(this.makeDndIconPanel());
        portalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        portalPanel.add(this.makeDoneButtonPanel());
        return portalPanel;
    }

    @Override
    protected void clearListSelection() {
        this._portalList.clearSelection();
        this._portalName.setText(null);
        this._parent._editor.highlight(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.askForNameChange()) {
            return;
        }
        Portal portal = (Portal)this._portalList.getSelectedValue();
        if (portal != null) {
            this._portalName.setText(portal.getName());
            this.hightLightIcon(portal);
            this._currentPortal = portal;
        } else {
            this._portalName.setText(null);
        }
    }

    private void hightLightIcon(Portal portal) {
        this._parent._editor.highlight(null);
        List<PortalIcon> piArray = this._parent.getPortalIcons(portal);
        for (PortalIcon pi : piArray) {
            this._parent._editor.highlight(pi);
        }
    }

    private boolean askForNameChange() {
        int answer;
        String name = this._portalName.getText();
        if (this._currentPortal != null && !this._currentPortal.getName().equals(name) && name.length() > 0 && (answer = JOptionPane.showConfirmDialog(this, Bundle.getMessage("changeOrCancel", this._currentPortal.getName(), name, Bundle.getMessage("BeanNamePortal")), Bundle.getMessage("makePortal"), 0, 3)) == 0) {
            this.setName(this._currentPortal, name);
            return true;
        }
        return false;
    }

    protected void setSelected(PortalIcon icon) {
        if (!this.canEdit()) {
            return;
        }
        Portal portal = icon.getPortal();
        if (portal != null) {
            if (!portal.equals(this._portalList.getSelectedValue())) {
                this._parent._editor.highlight(null);
            }
            List<PortalIcon> piArray = this._parent.getPortalIcons(portal);
            for (PortalIcon pi : piArray) {
                this._parent._editor.highlight(pi);
            }
        }
        this._portalList.setSelectedValue(portal, true);
    }

    private void changePortalName() {
        Portal portal = (Portal)this._portalList.getSelectedValue();
        String name = this._portalName.getText();
        if (portal == null || name == null || name.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("changePortalName", Bundle.getMessage("buttonChangeName")), Bundle.getMessage("makePortal"), 1);
            return;
        }
        this.setName(portal, name);
    }

    private void setName(Portal portal, String name) {
        String msg = portal.setName(name);
        if (msg == null) {
            this._portalList.dataChange();
            this.hightLightIcon(portal);
        } else {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("makePortal"), 1);
        }
    }

    private void deletePortal() {
        String name = this._portalName.getText();
        if (name == null || name.length() == 0) {
            return;
        }
        Portal portal = (Portal)this._portalList.getSelectedValue();
        if (portal == null) {
            PortalManager portalMgr = InstanceManager.getDefault(PortalManager.class);
            portal = portalMgr.getPortal(name);
        }
        if (portal == null) {
            return;
        }
        if (!this._suppressWarnings) {
            int val = JOptionPane.showOptionDialog(this, Bundle.getMessage("confirmPortalDelete", portal.getName()), Bundle.getMessage("WarningTitle"), 1, 3, null, new Object[]{Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonYesPlus"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
            if (val == 2) {
                return;
            }
            if (val == 1) {
                this._suppressWarnings = true;
            }
        }
        if (portal.dispose()) {
            this._portalList.dataChange();
            this._portalName.setText(null);
            OBlock oppBlock = portal.getOpposingBlock(this._homeBlock);
            ArrayList<PortalIcon> removeList = new ArrayList<PortalIcon>(this._parent.getPortalIcons(portal));
            for (PortalIcon icon : removeList) {
                this._parent.getCircuitIcons(oppBlock).remove(icon);
                icon.remove();
            }
        }
    }

    @Override
    protected void closingEvent(boolean close) {
        StringBuffer sb = new StringBuffer();
        String msg = this._parent.checkForPortals(this._homeBlock, "BlockPaths");
        if (msg.length() > 0) {
            sb.append(msg);
            sb.append("\n");
        }
        if (this._canEdit && (msg = this._parent.checkForPortalIcons(this._homeBlock, "BlockPaths")).length() > 0) {
            sb.append(msg);
            sb.append("\n");
        }
        this.closingEvent(close, sb.toString());
    }

    protected String checkPortalIcons(Portal portal, boolean moved, String key) {
        List<PortalIcon> iconMap = this._parent.getPortalIcons(portal);
        if (iconMap.isEmpty()) {
            return Bundle.getMessage("noPortalIcon", portal.getName(), Bundle.getMessage(key));
        }
        String name = portal.getName();
        boolean homeBlockCovered = false;
        boolean adjacentBlockCovered = false;
        OBlock adjacentBlock = null;
        for (PortalIcon icon : iconMap) {
            Portal p = icon.getPortal();
            if (p == null) {
                this._parent.deletePortalIcon(icon);
                log.error("Removed PortalIcon without Portal");
                continue;
            }
            OBlock fromBlock = portal.getFromBlock();
            OBlock toBlock = portal.getToBlock();
            if (!this._homeBlock.equals(fromBlock) && !this._homeBlock.equals(toBlock)) {
                log.error("HomeBlock \"{}\" does not know {}", (Object)this._homeBlock.getDisplayName(), (Object)portal.getDescription());
                return this.showIntersectMessage(this._homeBlock, portal, moved);
            }
            boolean homeCovered = this._parent.iconIntersectsBlock(icon, this._homeBlock);
            adjacentBlock = this._homeBlock.equals(fromBlock) ? toBlock : fromBlock;
            boolean adjacentCovered = adjacentBlock != null && this._parent.iconIntersectsBlock(icon, adjacentBlock);
            OBlock block = this.findAdjacentBlock(icon);
            if (adjacentBlock == null) {
                if (block != null) {
                    boolean valid = this._homeBlock.equals(fromBlock) ? portal.setToBlock(block, true) : portal.setFromBlock(block, true);
                    this._portalList.dataChange();
                    log.debug("Adjacent block change of null to {} is {} valid.", (Object)block.getDisplayName(), (Object)(valid ? "" : "NOT"));
                    adjacentBlock = block;
                    if (homeCovered) {
                        return null;
                    }
                    adjacentCovered = true;
                }
            } else if (block != null) {
                if (moved) {
                    int result;
                    if (!block.equals(adjacentBlock) && (result = JOptionPane.showConfirmDialog(this, Bundle.getMessage("repositionPortal", name, this._homeBlock.getDisplayName(), block.getDisplayName()), Bundle.getMessage("makePortal"), 0, 3)) == 0) {
                        boolean valid = this._homeBlock.equals(fromBlock) ? portal.setToBlock(block, true) : portal.setFromBlock(block, true);
                        this._portalList.dataChange();
                        log.debug("Adjacent block change of {} to {} is {} valid.", new Object[]{adjacentBlock.getDisplayName(), block.getDisplayName(), valid ? "" : "NOT"});
                        adjacentBlock = block;
                        if (homeCovered) {
                            return null;
                        }
                    }
                } else if (!block.equals(adjacentBlock)) {
                    log.error("Icon NOT moved, but Adjacent block change of {} to {}!", (Object)adjacentBlock.getDisplayName(), (Object)block.getDisplayName());
                }
                adjacentCovered = true;
            } else {
                adjacentCovered = false;
            }
            if (homeCovered) {
                homeBlockCovered = true;
            }
            if (adjacentCovered) {
                adjacentBlockCovered = true;
            }
            log.debug("checkPortalIcons for {} homeCovered= {} adjacentCovered= {}", new Object[]{name, homeBlockCovered, adjacentBlockCovered});
        }
        if (!homeBlockCovered) {
            return this.showIntersectMessage(this._homeBlock, portal, moved);
        }
        if (!adjacentBlockCovered) {
            return this.showIntersectMessage(adjacentBlock, portal, moved);
        }
        return null;
    }

    private String showIntersectMessage(OBlock block, Portal portal, boolean moved) {
        ArrayList<Positionable> list;
        String msg = null;
        msg = block == null ? Bundle.getMessage("icondNeedsAdjacent", portal.getDescription()) : ((list = this._parent.getCircuitIcons(block)).isEmpty() ? Bundle.getMessage("needIcons", block.getDisplayName(), Bundle.getMessage("BlockPortals")) : Bundle.getMessage("iconNotOnBlock", block.getDisplayName(), portal.getDescription()));
        if (moved) {
            JOptionPane.showMessageDialog(this, msg, Bundle.getMessage("makePortal"), 1);
        }
        return msg;
    }

    private OBlock findAdjacentBlock(PortalIcon icon) {
        OBlock block2;
        ArrayList<OBlock> neighbors = new ArrayList<OBlock>();
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);
        SortedSet oblocks = manager.getNamedBeanSet();
        for (OBlock block2 : oblocks) {
            if (block2.equals(this._homeBlock) || !this._parent.iconIntersectsBlock(icon, block2)) continue;
            neighbors.add(block2);
        }
        block2 = null;
        if (neighbors.size() == 1) {
            block2 = (OBlock)neighbors.get(0);
        } else if (neighbors.size() > 1) {
            block2 = (OBlock)neighbors.get(0);
            Object[] selects = new String[neighbors.size()];
            Iterator iter = neighbors.iterator();
            int i = 0;
            while (iter.hasNext()) {
                selects[i++] = ((OBlock)iter.next()).getDisplayName();
            }
            Object select = JOptionPane.showInputDialog(this, Bundle.getMessage("multipleBlockSelections", this._homeBlock.getDisplayName()), Bundle.getMessage("QuestionTitle"), 3, null, selects, null);
            if (select != null) {
                for (OBlock block2 : neighbors) {
                    if (((String)select).equals(block2.getDisplayName())) break;
                }
            }
        }
        return block2;
    }

    protected JPanel makeDndIconPanel() {
        JPanel dndPanel = new JPanel();
        dndPanel.setLayout(new BoxLayout(dndPanel, 1));
        JPanel p = new JPanel();
        JLabel l = new JLabel(Bundle.getMessage("dragIcon"));
        p.add(l);
        dndPanel.add(p);
        NamedIcon icon = this._parent._editor.getPortalIconMap().get("block");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), Bundle.getMessage("BeanNamePortal")));
        try {
            IconDragJLabel label = new IconDragJLabel(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable"));
            label.setIcon(icon);
            label.setName(Bundle.getMessage("BeanNamePortal"));
            panel.add(label);
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
        }
        dndPanel.add(panel);
        return dndPanel;
    }

    public class IconDragJLabel
    extends DragJLabel {
        boolean addSecondIcon;

        public IconDragJLabel(DataFlavor flavor) {
            super(flavor);
            this.addSecondIcon = false;
        }

        @Override
        protected boolean okToDrag() {
            String name = EditPortalFrame.this._portalName.getText();
            if (name == null || name.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("needPortalName"), Bundle.getMessage("makePortal"), 1);
                return false;
            }
            PortalManager portalMgr = InstanceManager.getDefault(PortalManager.class);
            Portal portal = portalMgr.getPortal(name);
            if (portal == null) {
                return true;
            }
            OBlock toBlock = portal.getToBlock();
            OBlock fromBlock = portal.getFromBlock();
            if (!EditPortalFrame.this._homeBlock.equals(fromBlock) && !EditPortalFrame.this._homeBlock.equals(toBlock)) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("portalNeedsBlock", name, fromBlock, toBlock), Bundle.getMessage("makePortal"), 1);
                return false;
            }
            List<PortalIcon> piArray = EditPortalFrame.this._parent.getPortalIcons(portal);
            for (PortalIcon pi : piArray) {
                EditPortalFrame.this._parent._editor.highlight(pi);
            }
            switch (piArray.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    PortalIcon i = piArray.get(0);
                    if (EditPortalFrame.this._parent.iconIntersectsBlock(i, toBlock) && EditPortalFrame.this._parent.iconIntersectsBlock(i, fromBlock)) {
                        JOptionPane.showMessageDialog(this, Bundle.getMessage("portalIconExists", name), Bundle.getMessage("makePortal"), 1);
                        return false;
                    }
                    if (this.addSecondIcon) {
                        return true;
                    }
                    int result = JOptionPane.showConfirmDialog(this, Bundle.getMessage("portalWant2Icons", name), Bundle.getMessage("makePortal"), 0, 3);
                    if (result != 0) break;
                    this.addSecondIcon = true;
                    return true;
                }
                default: {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("portalIconExists", name), Bundle.getMessage("makePortal"), 1);
                }
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return null;
            }
            String name = EditPortalFrame.this._portalName.getText();
            Portal portal = EditPortalFrame.this._homeBlock.getPortalByName(name);
            if (portal == null) {
                PortalManager portalMgr = InstanceManager.getDefault(PortalManager.class);
                portal = portalMgr.createNewPortal(name);
                portal.setFromBlock(EditPortalFrame.this._homeBlock, false);
                EditPortalFrame.this._portalList.dataChange();
            }
            this.addSecondIcon = false;
            PortalIcon icon = new PortalIcon(EditPortalFrame.this._parent._editor, portal);
            ArrayList<Positionable> group = EditPortalFrame.this._parent.getCircuitIcons(EditPortalFrame.this._homeBlock);
            group.add(icon);
            EditPortalFrame.this._parent.getPortalIcons(portal).add(icon);
            EditPortalFrame.this._parent._editor.setSelectionGroup(group);
            icon.setLevel(10);
            icon.setStatus("block");
            return icon;
        }
    }
}

