/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.display.controlPanelEditor.PortalList;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Portal;

public class EditPortalDirection
extends EditFrame
implements ActionListener,
ListSelectionListener {
    private PortalIcon _icon;
    private JRadioButton _toButton;
    private JRadioButton _fromButton;
    private HashMap<String, NamedIcon> _iconMap;
    private PortalList _portalList;

    public EditPortalDirection(String title, CircuitBuilder parent, OBlock block) {
        super(title, parent, block);
        this.checkCircuitIcons("DirectionArrow");
        this.pack();
    }

    private JPanel makeArrowPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), Bundle.getMessage("ArrowIconsTitle")));
        panel.add(Box.createHorizontalStrut(200));
        ButtonGroup group = new ButtonGroup();
        this._toButton = new JRadioButton(this._iconMap.get("toArrow"));
        this._toButton.setActionCommand("toArrow");
        this._toButton.addActionListener(this);
        group.add(this._toButton);
        panel.add(this._toButton);
        this._fromButton = new JRadioButton(this._iconMap.get("fromArrow"));
        this._fromButton.setActionCommand("fromArrow");
        this._fromButton.addActionListener(this);
        group.add(this._fromButton);
        panel.add(this._fromButton);
        JRadioButton _noButton = new JRadioButton(Bundle.getMessage("noIcon"), this._iconMap.get("hidden"));
        _noButton.setVerticalTextPosition(0);
        _noButton.setHorizontalTextPosition(0);
        _noButton.setActionCommand("hidden");
        _noButton.addActionListener(this);
        group.add(_noButton);
        panel.add(_noButton);
        return panel;
    }

    @Override
    protected JPanel makeContentPanel() {
        this._iconMap = PortalIcon.getPaletteMap();
        JPanel portalPanel = new JPanel();
        portalPanel.setLayout(new BoxLayout(portalPanel, 1));
        JPanel panel = new JPanel();
        panel.add(new JLabel(Bundle.getMessage("PortalTitle", this._homeBlock.getDisplayName())));
        portalPanel.add(panel);
        this._portalList = new PortalList(this._homeBlock, this);
        this._portalList.addListSelectionListener(this);
        portalPanel.add(new JScrollPane(this._portalList));
        portalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel l = new JLabel(Bundle.getMessage("PortalDirection1", this._homeBlock.getDisplayName()));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        l = new JLabel(Bundle.getMessage("PortalDirection2"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("PortalDirection3"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE));
        l = new JLabel(Bundle.getMessage("PortalDirection4"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("PortalDirection5"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        portalPanel.add(panel);
        portalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        panel.add(this.makeArrowPanel());
        portalPanel.add(panel);
        portalPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        portalPanel.add(this.makeDoneButtonPanel());
        return portalPanel;
    }

    @Override
    protected void clearListSelection() {
        this._portalList.clearSelection();
        this._parent._editor.highlight(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Portal portal = (Portal)this._portalList.getSelectedValue();
        if (portal != null) {
            List<PortalIcon> piArray = this._parent.getPortalIcons(portal);
            if (piArray.isEmpty()) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("portalHasNoIcon", portal.getName()), Bundle.getMessage("incompleteCircuit"), 1);
                this.clearListSelection();
            } else {
                for (PortalIcon icon : piArray) {
                    this.setPortalIcon(icon, false);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._icon == null) {
            return;
        }
        if ("toArrow".equals(e.getActionCommand())) {
            this._icon.setIcon("toArrow", this._iconMap.get("toArrow"));
            this._icon.setIcon("fromArrow", this._iconMap.get("fromArrow"));
            this._icon.setArrowOrientation(true);
            this._icon.setHideArrows(false);
        } else if ("fromArrow".equals(e.getActionCommand())) {
            this._icon.setIcon("toArrow", this._iconMap.get("fromArrow"));
            this._icon.setIcon("fromArrow", this._iconMap.get("toArrow"));
            this._icon.setArrowOrientation(false);
            this._icon.setHideArrows(false);
        } else if ("hidden".equals(e.getActionCommand())) {
            this._icon.setHideArrows(true);
            this._icon.setStatus("hidden");
            return;
        }
        this._icon.setStatus("toArrow");
    }

    protected void setPortalIcon(PortalIcon icon, boolean setValue) {
        if (!this.canEdit()) {
            return;
        }
        this._parent._editor.highlight(icon);
        if (this._icon != null) {
            this._icon.setStatus("block");
        }
        this._icon = icon;
        if (this._icon != null) {
            if (this._icon.getArrowHide()) {
                this._icon.setStatus("hidden");
            } else {
                OBlock toBlock = this._icon.getPortal().getToBlock();
                if (this._homeBlock.equals(toBlock)) {
                    this._icon.setStatus("toArrow");
                } else {
                    this._icon.setStatus("fromArrow");
                }
            }
            this._toButton.setIcon(this._icon.getIcon("toArrow"));
            this._fromButton.setIcon(this._icon.getIcon("fromArrow"));
            if (setValue) {
                this._portalList.setSelectedValue(this._icon.getPortal(), true);
            }
        }
    }

    @Override
    protected void closingEvent(boolean close) {
        StringBuffer sb = new StringBuffer();
        String msg = this._parent.checkForPortals(this._homeBlock, "BlockPaths");
        if (msg.length() > 0) {
            sb.append(msg);
            sb.append("\n");
            close = true;
        }
        if ((msg = this._parent.checkForPortalIcons(this._homeBlock, "DirectionArrow")).length() > 0) {
            sb.append(msg);
            sb.append("\n");
            close = true;
        }
        this.closingEvent(close, sb.toString());
    }
}

