/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.controlPanelEditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.BeanSetting;
import jmri.Path;
import jmri.Turnout;
import jmri.jmrit.display.IndicatorTrack;
import jmri.jmrit.display.IndicatorTurnoutIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.controlPanelEditor.Bundle;
import jmri.jmrit.display.controlPanelEditor.CircuitBuilder;
import jmri.jmrit.display.controlPanelEditor.EditFrame;
import jmri.jmrit.display.controlPanelEditor.LengthPanel;
import jmri.jmrit.display.controlPanelEditor.PortalIcon;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OPath;
import jmri.jmrit.logix.Portal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditCircuitPaths
extends EditFrame
implements ListSelectionListener {
    private ArrayList<Positionable> _pathGroup = new ArrayList();
    private ArrayList<Positionable> _savePathGroup = new ArrayList();
    private JTextField _pathName;
    private JList<OPath> _pathList;
    private PathListModel _pathListModel;
    private OPath _currentPath;
    private LengthPanel _lengthPanel;
    public static final String TEST_PATH = "TEST_PATH";
    private static final Logger log = LoggerFactory.getLogger(EditCircuitPaths.class);

    public EditCircuitPaths(String title, CircuitBuilder parent, OBlock block) {
        super(title, parent, block);
        this.checkCircuitIcons("BlockPaths");
        this.pack();
    }

    @Override
    protected JPanel makeContentPanel() {
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BoxLayout(pathPanel, 1));
        pathPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        JPanel panel = new JPanel();
        panel.add(new JLabel(Bundle.getMessage("PathTitle", this._homeBlock.getDisplayName())));
        pathPanel.add(panel);
        this._pathListModel = new PathListModel(this);
        this._pathList = new JList();
        this._pathList.setModel(this._pathListModel);
        this._pathList.addListSelectionListener(this);
        this._homeBlock.addPropertyChangeListener(this._pathListModel);
        this._pathList.setCellRenderer(new PathCellRenderer());
        this._pathList.setSelectionMode(0);
        pathPanel.add(new JScrollPane(this._pathList));
        pathPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton clearButton = new JButton(Bundle.getMessage("buttonClearSelection"));
        clearButton.addActionListener(a -> this.clearListSelection());
        clearButton.setToolTipText(Bundle.getMessage("ToolTipClearList"));
        panel.add(clearButton);
        pathPanel.add(panel);
        pathPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        this._pathName = new JTextField();
        panel.add(CircuitBuilder.makeTextBoxPanel(false, this._pathName, "pathName", true, "TooltipPathName"));
        this._pathName.setPreferredSize(new Dimension(300, this._pathName.getPreferredSize().height));
        pathPanel.add(panel);
        panel = new JPanel();
        JButton addButton = new JButton(Bundle.getMessage("buttonAddPath"));
        addButton.addActionListener(a -> this.addNewPath(true));
        addButton.setToolTipText(Bundle.getMessage("ToolTipAddPath"));
        panel.add(addButton);
        JButton changeButton = new JButton(Bundle.getMessage("buttonChangeName"));
        changeButton.addActionListener(a -> this.changePathName());
        changeButton.setToolTipText(Bundle.getMessage("ToolTipChangeName"));
        panel.add(changeButton);
        JButton deleteButton = new JButton(Bundle.getMessage("buttonDeletePath"));
        deleteButton.addActionListener(a -> this.deletePath());
        deleteButton.setToolTipText(Bundle.getMessage("ToolTipDeletePath"));
        panel.add(deleteButton);
        pathPanel.add(panel);
        pathPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        this._lengthPanel = new LengthPanel(this._homeBlock, "pathLength", "TooltipPathLength");
        pathPanel.add(this._lengthPanel);
        pathPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel l = new JLabel(Bundle.getMessage("enterNewPath"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("selectPathIcons"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("pressAddButton", Bundle.getMessage("buttonAddPath")));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        l = new JLabel(Bundle.getMessage("selectPath"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("editPathIcons"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        panel.add(Box.createVerticalStrut(STRUT_SIZE / 2));
        l = new JLabel(Bundle.getMessage("throwPathTO"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        l = new JLabel(Bundle.getMessage("holdShiftDown"));
        l.setAlignmentX(0.0f);
        panel.add(l);
        JPanel p = new JPanel();
        p.add(panel);
        pathPanel.add(p);
        pathPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        pathPanel.add(this.makeDoneButtonPanel());
        this._lengthPanel.changeUnits();
        return pathPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String msg;
        OPath path = this._pathList.getSelectedValue();
        if (log.isDebugEnabled()) {
            log.debug("valueChanged from _currentPath \"{}\" to path \"{}\"", (Object)(this._currentPath == null ? "null" : this._currentPath.getName()), (Object)(path == null ? "null" : path.getName()));
        }
        if ((msg = this.checkForSavePath()).length() > 0) {
            StringBuilder sb = new StringBuilder(msg);
            sb.append("\n");
            sb.append(Bundle.getMessage("saveChanges"));
            int answer = JOptionPane.showConfirmDialog(this, sb.toString(), Bundle.getMessage("makePath"), 0, 3);
            if (answer == 0) {
                this.addNewPath(false);
            }
        }
        this.clearPath(false);
        this._currentPath = path;
        if (path != null) {
            this._pathName.setText(path.getName());
            this._lengthPanel.setLength(path.getLengthMm());
            this._pathGroup = this.showPath(path);
            this.updatePath();
        } else {
            this._pathName.setText(null);
            this._lengthPanel.setLength(0.0f);
        }
        int oldState = this._homeBlock.getState();
        int newState = oldState | 0x10;
        this._homeBlock.pseudoPropertyChange("state", oldState, newState);
    }

    private ArrayList<Positionable> showPath(OPath path) {
        if (log.isDebugEnabled()) {
            log.debug("showPath  \"{}\"", (Object)path.getName());
        }
        path.setTurnouts(0, true, 0, false);
        ArrayList<Positionable> pathGp = this.makePathGroup(path);
        this._savePathGroup = new ArrayList();
        for (Positionable pos : pathGp) {
            this._savePathGroup.add(pos);
        }
        return pathGp;
    }

    private ArrayList<Positionable> makePathGroup(OPath path) {
        Portal fromPortal = path.getFromPortal();
        Portal toPortal = path.getToPortal();
        String name = path.getName();
        ArrayList<Positionable> list = this._parent.getCircuitIcons(this._homeBlock);
        ArrayList<Positionable> pathGroup = new ArrayList<Positionable>();
        for (Positionable pos : list) {
            if (pos instanceof IndicatorTrack) {
                ArrayList<String> paths = ((IndicatorTrack)pos).getPaths();
                if (paths == null) continue;
                for (String s : paths) {
                    if (!name.equals(s)) continue;
                    ((IndicatorTrack)pos).setControlling(true);
                    pathGroup.add(pos);
                }
                continue;
            }
            if (!(pos instanceof PortalIcon)) continue;
            PortalIcon icon = (PortalIcon)pos;
            Portal portal = icon.getPortal();
            if (portal.equals(fromPortal)) {
                pathGroup.add(icon);
                continue;
            }
            if (!portal.equals(toPortal)) continue;
            pathGroup.add(icon);
        }
        if (log.isDebugEnabled()) {
            log.debug("makePathGroup for path \"{}\" from CircuitGroup size {} pathGroup size {}", new Object[]{name, list.size(), pathGroup.size()});
        }
        return pathGroup;
    }

    private boolean okPath(Positionable pos) {
        if (pos instanceof PortalIcon) {
            Portal portal = ((PortalIcon)pos).getPortal();
            if (portal != null && (this._homeBlock.equals(portal.getFromBlock()) || this._homeBlock.equals(portal.getToBlock()))) {
                ((PortalIcon)pos).setStatus("path");
                return true;
            }
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("portalNotInCircuit"), this._homeBlock.getDisplayName()), Bundle.getMessage("badPath"), 2);
            return false;
        }
        ArrayList<Positionable> icons = this._parent.getCircuitIcons(this._homeBlock);
        if (!icons.contains(pos)) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("iconNotInCircuit"), this._homeBlock.getDisplayName()), Bundle.getMessage("badPath"), 2);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateSelections(boolean noShift, Positionable selection) {
        if (!this.canEdit()) {
            return;
        }
        if (noShift) {
            if (this._pathGroup.contains(selection)) {
                this._pathGroup.remove(selection);
                if (selection instanceof PortalIcon) {
                    ((PortalIcon)selection).setStatus("block");
                } else {
                    ((IndicatorTrack)selection).setStatus(4);
                    ((IndicatorTrack)selection).removePath(TEST_PATH);
                    log.debug("removePath TEST_PATH");
                }
            } else {
                if (!this.okPath(selection)) return;
                this._pathGroup.add(selection);
                if (selection instanceof IndicatorTrack) {
                    ((IndicatorTrack)selection).addPath(TEST_PATH);
                }
            }
        } else if (selection instanceof PortalIcon) {
            ((PortalIcon)selection).setStatus("block");
        }
        int oldState = this._homeBlock.getState();
        int newState = oldState | 0x10;
        this._homeBlock.pseudoPropertyChange("state", oldState, newState);
        log.debug("updateSelections ALLOCATED _homeBlock");
    }

    private void updatePath() {
        for (Positionable pos : this._pathGroup) {
            if (pos instanceof IndicatorTrack) {
                ((IndicatorTrack)pos).addPath(TEST_PATH);
                continue;
            }
            ((PortalIcon)pos).setStatus("path");
        }
        String name = this._pathName.getText();
        if (!(this._pathGroup.isEmpty() || name != null && name.length() != 0)) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("needPathName"), Bundle.getMessage("makePath"), 1);
        }
    }

    private String findErrors() {
        StringBuilder sb = new StringBuilder();
        List<Path> list = this._homeBlock.getPaths();
        if (list.isEmpty()) {
            sb.append(Bundle.getMessage("noPaths", this._homeBlock.getDisplayName()));
        } else {
            list.stream().filter(o -> o instanceof OPath).map(o -> (OPath)o).forEach(path -> {
                ArrayList<Positionable> pathGp = this.makePathGroup((OPath)path);
                if (pathGp.isEmpty()) {
                    sb.append(Bundle.getMessage("noPathIcons", path.getName()));
                    sb.append("\n");
                } else {
                    String msg = this.checkIcons(path.getName(), pathGp);
                    if (msg != null) {
                        sb.append(msg);
                        sb.append("\n");
                    }
                }
            });
        }
        return sb.toString();
    }

    private boolean pathIconsEqual(ArrayList<Positionable> pathGp1, ArrayList<Positionable> pathGp2) {
        if (pathGp1.size() != pathGp2.size()) {
            return false;
        }
        for (Positionable pos : pathGp1) {
            if (pathGp2.contains(pos)) continue;
            return false;
        }
        return true;
    }

    private String checkForSavePath() {
        String name = this._pathName.getText();
        StringBuilder sb = new StringBuilder();
        if (this._currentPath != null) {
            String curName = this._currentPath.getName();
            if (!this.pathIconsEqual(this._pathGroup, this._savePathGroup)) {
                sb.append(Bundle.getMessage("pathIconsChanged", curName));
                sb.append("\n");
            }
            if (this._lengthPanel.isChanged(this._currentPath.getLengthMm())) {
                sb.append(Bundle.getMessage("pathlengthChanged", curName));
                sb.append("\n");
            }
            if (name.length() > 0 && !name.equals(this._currentPath.getName())) {
                sb.append(Bundle.getMessage("changeName", name, curName));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    protected void clearListSelection() {
        this._pathList.clearSelection();
        this._lengthPanel.setLength(0.0f);
        this._pathName.setText(null);
    }

    private String checkIcons(String name, ArrayList<Positionable> pathGp) {
        Iterator<Positionable> it = pathGp.iterator();
        boolean hasTrack = false;
        boolean hasPortal = false;
        while (it.hasNext()) {
            Positionable pos = it.next();
            if (pos instanceof IndicatorTrack) {
                hasTrack = true;
                continue;
            }
            if (!(pos instanceof PortalIcon)) continue;
            hasPortal = true;
        }
        if (!hasTrack) {
            return Bundle.getMessage("noTrackIconsForPath", name);
        }
        if (!hasPortal) {
            return Bundle.getMessage("noPortalIconsForPath", name);
        }
        return null;
    }

    private OPath makeOPath(String name, ArrayList<Positionable> pathGp) {
        if (pathGp.isEmpty()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("noPathIcons", name), Bundle.getMessage("makePath"), 1);
            return null;
        }
        Iterator<Positionable> it = pathGp.iterator();
        ArrayList<BeanSetting> settings = new ArrayList<BeanSetting>();
        Portal fromPortal = null;
        Portal toPortal = null;
        boolean hasTrack = false;
        int portalIconCount = 0;
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Positionable pos = it.next();
            if (pos instanceof IndicatorTurnoutIcon) {
                Turnout t = ((IndicatorTurnoutIcon)pos).getTurnout();
                String turnoutName = t.getDisplayName();
                int state = t.getKnownState();
                if (state != 2 && state != 4) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(Bundle.getMessage("turnoutNotSet", turnoutName));
                    continue;
                }
                settings.add(new BeanSetting(t, turnoutName, state));
                hasTrack = true;
                continue;
            }
            if (pos instanceof PortalIcon) {
                if (toPortal == null) {
                    toPortal = ((PortalIcon)pos).getPortal();
                } else if (fromPortal == null) {
                    fromPortal = ((PortalIcon)pos).getPortal();
                }
                ++portalIconCount;
                continue;
            }
            if (!(pos instanceof IndicatorTrack)) continue;
            hasTrack = true;
        }
        if (!hasTrack) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(Bundle.getMessage("noTrackIconsForPath", name));
        }
        if (toPortal == null && fromPortal == null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(Bundle.getMessage("tooFewPortals"));
        }
        if (portalIconCount == 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(Bundle.getMessage("noPortalIconsForPath", name));
        }
        if (portalIconCount > 2) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(Bundle.getMessage("tooManyPortals"));
        }
        if (sb.length() > 0) {
            JOptionPane.showMessageDialog(this, sb.toString(), Bundle.getMessage("makePath"), 1);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("makeOPath for path \"{}\" from {} icons", (Object)name, (Object)pathGp.size());
        }
        return new OPath(name, this._homeBlock, fromPortal, toPortal, settings);
    }

    private void addNewPath(boolean prompt) {
        String name = this._pathName.getText();
        if (log.isDebugEnabled()) {
            log.debug("addPath({}) for path \"{}\"", (Object)prompt, (Object)name);
        }
        if (name == null || name.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("TooltipPathName"), Bundle.getMessage("makePath"), 1);
            return;
        }
        OPath otherPath = null;
        OPath newPath = this.makeOPath(name, this._pathGroup);
        if (newPath == null) {
            return;
        }
        for (OPath loopPath : this._homeBlock.getPaths().stream().filter(o -> o instanceof OPath).map(o -> (OPath)o).collect(Collectors.toList())) {
            if (!newPath.equals(loopPath)) continue;
            otherPath = loopPath;
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug("newPath= {}", (Object)newPath.toString());
            log.debug("otherPath= {}", (Object)(otherPath == null ? "null" : otherPath.toString()));
            log.debug("_currentPath= {}", (Object)(this._currentPath == null ? "null" : this._currentPath.toString()));
            log.debug("current path {} changed", (Object)(this.pathIconsEqual(this._pathGroup, this._savePathGroup) ? "not" : "IS"));
        }
        if (otherPath != null && !otherPath.equals(this._currentPath)) {
            ArrayList<Positionable> otherPathGrp = this.makePathGroup(otherPath);
            String otherName = otherPath.getName();
            StringBuilder sb = new StringBuilder(Bundle.getMessage("pathDefined", otherName));
            sb.append("\n");
            if (name.length() > 0 && !name.equals(otherName)) {
                sb.append(Bundle.getMessage("changeName", name, otherName));
                sb.append("\n");
            }
            if (!this.pathIconsEqual(this._pathGroup, otherPathGrp)) {
                sb.append(Bundle.getMessage("pathIconsChanged", otherName));
                sb.append("\n");
            }
            if (this._lengthPanel.isChanged(otherPath.getLengthMm())) {
                sb.append(Bundle.getMessage("pathlengthChanged", otherName));
                sb.append("\n");
            }
            if (sb.length() > 0 && prompt) {
                sb.append(Bundle.getMessage("saveChanges"));
                int result = JOptionPane.showConfirmDialog(this, sb.toString(), Bundle.getMessage("makePath"), 0, 3);
                if (result == 0) {
                    this._currentPath = otherPath;
                }
            } else {
                return;
            }
        }
        this.changePathNameInIcons(name, this._pathGroup);
        if (this._currentPath != null) {
            this._currentPath.setName(name);
            Portal toPortal = newPath.getToPortal();
            toPortal.addPath(this._currentPath);
            Portal fromPortal = newPath.getFromPortal();
            if (fromPortal != null) {
                fromPortal.addPath(this._currentPath);
            }
            this._currentPath.setToPortal(toPortal);
            this._currentPath.setFromPortal(fromPortal);
            this._currentPath.setLength(this._lengthPanel.getLength());
            this._currentPath.clearSettings();
            for (BeanSetting beanSetting : newPath.getSettings()) {
                this._currentPath.addSetting(beanSetting);
            }
            this._savePathGroup = this._pathGroup;
            log.debug("update _currentPath");
        } else {
            newPath.setLength(this._lengthPanel.getLength());
            this._homeBlock.addPath(newPath);
            log.debug("add newPath");
        }
    }

    private void changePathName() {
        String name = this._pathName.getText();
        if (name == null || name.trim().length() == 0 || this._currentPath == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("changePathName", Bundle.getMessage("buttonChangeName")), Bundle.getMessage("makePath"), 1);
            return;
        }
        OPath aPath = this._homeBlock.getPathByName(name);
        if (aPath != null) {
            if (name.equals(this._currentPath.getName())) {
                this._pathList.setSelectedValue(aPath, true);
                return;
            }
            JOptionPane.showMessageDialog(this, Bundle.getMessage("duplicatePathName", name, this._homeBlock.getDisplayName()), Bundle.getMessage("makePath"), 1);
            this.clearPath(false);
            this._pathName.setText(null);
            return;
        }
        this._currentPath.setName(name);
        if (!this.pathIconsEqual(this._pathGroup, this._savePathGroup)) {
            StringBuilder sb = new StringBuilder();
            sb.append(Bundle.getMessage("pathIconsChanged", name));
            sb.append("\n");
            sb.append(Bundle.getMessage("saveIcons"));
            int result = JOptionPane.showConfirmDialog(this, sb.toString(), Bundle.getMessage("makePath"), 0, 3);
            if (result == 0) {
                this.changePathNameInIcons(name, this._pathGroup);
                this._savePathGroup = this._pathGroup;
            } else {
                this.changePathNameInIcons(name, this._savePathGroup);
                this.clearPath(false);
                this._pathGroup = this._savePathGroup;
                this.updatePath();
            }
        } else {
            this.changePathNameInIcons(name, this._pathGroup);
        }
        this._pathList.setSelectedValue(this._currentPath, true);
    }

    private void changePathNameInIcons(String name, ArrayList<Positionable> pathGp) {
        log.debug("changePathNameInIcons for {}.  {} icons", (Object)name, (Object)pathGp.size());
        for (Positionable pos : this._parent.getCircuitIcons(this._homeBlock)) {
            if (pathGp.contains(pos)) {
                if (!(pos instanceof IndicatorTrack)) continue;
                ((IndicatorTrack)pos).addPath(name);
                continue;
            }
            if (!(pos instanceof IndicatorTrack)) continue;
            ((IndicatorTrack)pos).removePath(name);
        }
    }

    private void deletePath() {
        OPath path = this._pathList.getSelectedValue();
        if (path == null) {
            path = this._homeBlock.getPathByName(this._pathName.getText());
        }
        if (path == null) {
            return;
        }
        if (this._homeBlock.removeOPath(path)) {
            this.clearListSelection();
            this._pathListModel.dataChange();
        }
    }

    @Override
    protected void closingEvent(boolean close) {
        StringBuilder sb = new StringBuilder();
        String msg = this.checkForSavePath();
        if (msg.length() > 0) {
            sb.append(msg);
            sb.append("\n");
        }
        if ((msg = this.findErrors()).length() > 0) {
            sb.append(msg);
        }
        if (this.closingEvent(close, sb.toString())) {
            this._pathName.setText(null);
            this.clearPath(true);
            int oldState = this._homeBlock.getState();
            int newState = oldState | 0x10;
            this._homeBlock.pseudoPropertyChange("state", oldState, newState);
            this._homeBlock.removePropertyChangeListener(this._pathListModel);
        }
    }

    private void clearPath(boolean hidePortals) {
        if (this._pathGroup != null) {
            log.debug("clearPath deAllocate _pathGroup with {} icons", (Object)this._pathGroup.size());
            for (Positionable pos : this._pathGroup) {
                if (pos instanceof PortalIcon) {
                    PortalIcon pi = (PortalIcon)pos;
                    if (hidePortals) {
                        pi.setStatus("hidden");
                        continue;
                    }
                    pi.setStatus("block");
                    continue;
                }
                if (!(pos instanceof IndicatorTrack)) continue;
                ((IndicatorTrack)pos).removePath(TEST_PATH);
            }
            this._pathGroup.clear();
            int oldState = this._homeBlock.getState();
            int newState = oldState & 0xFFFFFFEF;
            this._homeBlock.pseudoPropertyChange("state", oldState, newState);
            this._currentPath = null;
        } else {
            log.debug("clearPath pathGroup null");
        }
    }

    private static class PathCellRenderer
    extends JLabel
    implements ListCellRenderer<OPath> {
        private PathCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends OPath> list, OPath value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.getDescription();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class PathListModel
    extends AbstractListModel<OPath>
    implements PropertyChangeListener {
        EditFrame _parent;

        PathListModel(EditFrame parent) {
            this._parent = parent;
        }

        @Override
        public int getSize() {
            return EditCircuitPaths.this._homeBlock.getPaths().size();
        }

        @Override
        public OPath getElementAt(int index) {
            return (OPath)EditCircuitPaths.this._homeBlock.getPaths().get(index);
        }

        public void dataChange() {
            this.fireContentsChanged(this, 0, 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("deleted")) {
                this._parent.closingEvent(true);
            }
            this.fireContentsChanged(this, 0, 0);
        }
    }
}

