/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import jmri.InstanceManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.SignalMastIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(SignalMastIconXml.class);

    @Override
    public Element store(Object o) {
        SignalMastIcon p = (SignalMastIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("signalmasticon");
        element.setAttribute("signalmast", p.getNamedSignalMast().getName());
        this.storeCommonAttributes(p, element);
        element.setAttribute("clickmode", "" + p.getClickMode());
        element.setAttribute("litmode", "" + p.getLitMode());
        element.setAttribute("degrees", String.valueOf(p.getDegrees()));
        element.setAttribute("scale", String.valueOf(p.getScale()));
        element.setAttribute("imageset", p.useIconSet());
        element.setAttribute("class", "jmri.jmrit.display.configurexml.SignalMastIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        SignalMast sh;
        Attribute attr;
        Editor ed = (Editor)o;
        SignalMastIcon l = new SignalMastIcon(ed);
        try {
            int rotation = 0;
            double scale = 1.0;
            attr = element.getAttribute("rotation");
            if (attr != null) {
                rotation = attr.getIntValue();
            }
            if ((attr = element.getAttribute("degrees")) != null) {
                rotation = attr.getIntValue();
            }
            l.rotate(rotation);
            attr = element.getAttribute("scale");
            String text = "Error attr null";
            if (attr != null) {
                scale = attr.getDoubleValue();
                text = attr.getValue();
            }
            l.setScale(scale);
            if (log.isDebugEnabled()) {
                log.debug("Load SignalMast rotation= {} scale= {} attr text= {}", new Object[]{rotation, scale, text});
            }
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert rotation or scale attribute");
        }
        if ((attr = element.getAttribute("signalmast")) == null) {
            log.error("incorrect information for signal mast; must use signalmast name");
            ed.loadFailed();
            return;
        }
        String name = attr.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Load SignalMast {}", (Object)name);
        }
        if ((sh = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(name)) != null) {
            l.setSignalMast(name);
        } else {
            log.error("SignalMast named '{}' not found.", (Object)attr.getValue());
            ed.loadFailed();
        }
        attr = element.getAttribute("imageset");
        if (attr != null) {
            l.useIconSet(attr.getValue());
        }
        if ((attr = element.getAttribute("imageset")) != null) {
            l.useIconSet(attr.getValue());
        }
        try {
            attr = element.getAttribute("clickmode");
            if (attr != null) {
                l.setClickMode(attr.getIntValue());
            }
        }
        catch (DataConversionException e) {
            log.error("Failed on clickmode attribute: {}", (Throwable)e);
        }
        try {
            attr = element.getAttribute("litmode");
            if (attr != null) {
                l.setLitMode(attr.getBooleanValue());
            }
        }
        catch (DataConversionException e) {
            log.error("Failed on litmode attribute: {}", (Throwable)e);
        }
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 9, element);
    }
}

