/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.HashMap;
import java.util.List;
import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHeadIconXml
extends PositionableLabelXml {
    static final HashMap<String, String> _nameMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(SignalHeadIconXml.class);

    public SignalHeadIconXml() {
        _nameMap.put("red", "SignalHeadStateRed");
        _nameMap.put("yellow", "SignalHeadStateYellow");
        _nameMap.put("green", "SignalHeadStateGreen");
        _nameMap.put("lunar", "SignalHeadStateLunar");
        _nameMap.put("held", "SignalHeadStateHeld");
        _nameMap.put("dark", "SignalHeadStateDark");
        _nameMap.put("flashred", "SignalHeadStateFlashingRed");
        _nameMap.put("flashyellow", "SignalHeadStateFlashingYellow");
        _nameMap.put("flashgreen", "SignalHeadStateFlashingGreen");
        _nameMap.put("flashlunar", "SignalHeadStateFlashingLunar");
    }

    @Override
    public Element store(Object o) {
        SignalHeadIcon p = (SignalHeadIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("signalheadicon");
        element.setAttribute("signalhead", p.getNamedSignalHead().getName());
        this.storeCommonAttributes(p, element);
        element.setAttribute("clickmode", "" + p.getClickMode());
        element.setAttribute("litmode", "" + p.getLitMode());
        Element elem = new Element("icons");
        NamedIcon icon = p.getIcon("SignalHeadStateHeld");
        if (icon != null) {
            elem.addContent((Content)this.storeIcon("held", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateDark")) != null) {
            elem.addContent((Content)this.storeIcon("dark", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateRed")) != null) {
            elem.addContent((Content)this.storeIcon("red", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateYellow")) != null) {
            elem.addContent((Content)this.storeIcon("yellow", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateGreen")) != null) {
            elem.addContent((Content)this.storeIcon("green", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateLunar")) != null) {
            elem.addContent((Content)this.storeIcon("lunar", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateFlashingRed")) != null) {
            elem.addContent((Content)this.storeIcon("flashred", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateFlashingYellow")) != null) {
            elem.addContent((Content)this.storeIcon("flashyellow", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateFlashingGreen")) != null) {
            elem.addContent((Content)this.storeIcon("flashgreen", icon));
        }
        if ((icon = p.getIcon("SignalHeadStateFlashingLunar")) != null) {
            elem.addContent((Content)this.storeIcon("flashlunar", icon));
        }
        element.addContent((Content)elem);
        elem = new Element("iconmaps");
        String family = p.getFamily();
        if (family != null) {
            elem.setAttribute("family", family);
        }
        element.addContent((Content)elem);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.SignalHeadIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor ed = (Editor)o;
        SignalHeadIcon l = new SignalHeadIcon(ed);
        Attribute attr = element.getAttribute("signalhead");
        if (attr == null) {
            log.error("incorrect information for signal head; must use signalhead name");
            ed.loadFailed();
            return;
        }
        String name = attr.getValue();
        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        if (sh == null) {
            log.error("SignalHead named '{}' not found.", (Object)attr.getValue());
            return;
        }
        l.setSignalHead(name);
        int rotation = 0;
        try {
            attr = element.getAttribute("rotate");
            rotation = attr.getIntValue();
        }
        catch (DataConversionException dataConversionException) {
        }
        catch (NullPointerException nullPointerException) {}
        List aspects = element.getChildren();
        if (aspects.size() > 0) {
            Element icons = element.getChild("icons");
            Element elem = element;
            if (icons != null) {
                aspects = icons.getChildren();
                elem = icons;
            }
            for (Element value : aspects) {
                String aspect = value.getName();
                NamedIcon icon = this.loadIcon(l, aspect, elem, "SignalHead \"" + name + "\": icon \"" + aspect + "\" ", ed);
                if (icon != null) {
                    l.setIcon(_nameMap.get(aspect), icon);
                    continue;
                }
                log.info("SignalHead \"{}\": icon \"{}\" removed", (Object)name, (Object)aspect);
            }
            log.debug("{} icons loaded for {}", (Object)aspects.size(), (Object)l.getNameString());
        } else {
            NamedIcon icon = this.loadSignalIcon("red", rotation, l, element, name, ed);
            if (icon != null) {
                l.setIcon("SignalHeadStateRed", icon);
            }
            if ((icon = this.loadSignalIcon("yellow", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateYellow", icon);
            }
            if ((icon = this.loadSignalIcon("green", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateGreen", icon);
            }
            if ((icon = this.loadSignalIcon("lunar", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateLunar", icon);
            }
            if ((icon = this.loadSignalIcon("held", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateHeld", icon);
            }
            if ((icon = this.loadSignalIcon("dark", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateDark", icon);
            }
            if ((icon = this.loadSignalIcon("flashred", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateFlashingRed", icon);
            }
            if ((icon = this.loadSignalIcon("flashyellow", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateFlashingYellow", icon);
            }
            if ((icon = this.loadSignalIcon("flashgreen", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateFlashingGreen", icon);
            }
            if ((icon = this.loadSignalIcon("flashlunar", rotation, l, element, name, ed)) != null) {
                l.setIcon("SignalHeadStateFlashingLunar", icon);
            }
        }
        Element elem = element.getChild("iconmaps");
        if (elem != null && (attr = elem.getAttribute("family")) != null) {
            l.setFamily(attr.getValue());
        }
        try {
            attr = element.getAttribute("clickmode");
            if (attr != null) {
                l.setClickMode(attr.getIntValue());
            }
        }
        catch (DataConversionException e) {
            log.error("Failed on clickmode attribute: ", (Throwable)e);
        }
        try {
            attr = element.getAttribute("litmode");
            if (attr != null) {
                l.setLitMode(attr.getBooleanValue());
            }
        }
        catch (DataConversionException e) {
            log.error("Failed on litmode attribute: ", (Throwable)e);
        }
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 9, element);
    }

    private NamedIcon loadSignalIcon(String aspect, int rotation, SignalHeadIcon l, Element element, String name, Editor ed) {
        String msg = "SignalHead \"" + name + "\": icon \"" + aspect + "\" ";
        NamedIcon icon = this.loadIcon(l, aspect, element, msg, ed);
        if (icon == null) {
            if (element.getAttribute(aspect) != null) {
                String iconName = element.getAttribute(aspect).getValue();
                icon = NamedIcon.getIconByName(iconName);
                if (icon == null && (icon = ed.loadFailed(msg, iconName)) == null) {
                    log.info("{} removed for url= {}", (Object)msg, (Object)iconName);
                }
                if (icon != null) {
                    icon.setRotation(rotation, l);
                }
            } else {
                log.info("did not load file aspect {} for SignalHead {}", (Object)aspect, (Object)name);
            }
        }
        if (icon == null) {
            log.info("SignalHead Icon \"{}\": icon \"{}\" removed", (Object)name, (Object)aspect);
        }
        return icon;
    }
}

