/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.RpsPositionIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpsPositionIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(RpsPositionIconXml.class);

    @Override
    public Element store(Object o) {
        RpsPositionIcon p = (RpsPositionIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("sensoricon");
        this.storeCommonAttributes(p, element);
        element.setAttribute("active", p.getActiveIcon().getURL());
        element.setAttribute("error", p.getErrorIcon().getURL());
        element.setAttribute("rotate", String.valueOf(p.getActiveIcon().getRotation()));
        element.setAttribute("momentary", p.getMomentary() ? "true" : "false");
        element.setAttribute("sxscale", "" + p.getXScale());
        element.setAttribute("syscale", "" + p.getYScale());
        element.setAttribute("sxorigin", "" + p.getXOrigin());
        element.setAttribute("syorigin", "" + p.getYOrigin());
        element.setAttribute("showid", p.isShowID() ? "true" : "false");
        if (p.getFilter() != null) {
            element.setAttribute("filter", p.getFilter());
        }
        element.addContent((Content)this.storeIcon("active", p.getActiveIcon()));
        element.addContent((Content)this.storeIcon("error", p.getErrorIcon()));
        element.setAttribute("class", "jmri.jmrit.display.configurexml.RpsPositionIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Attribute a;
        Editor ed = (Editor)o;
        RpsPositionIcon l = new RpsPositionIcon(ed);
        String name = element.getAttribute("active").getValue();
        NamedIcon active = NamedIcon.getIconByName(name);
        if (active == null && (active = ed.loadFailed("RpsPositionIcon: icon \"active\" ", name)) == null) {
            log.info("RpsPositionIcon: icon \"active\" removed for url= {}", (Object)name);
            return;
        }
        l.setActiveIcon(active);
        name = element.getAttribute("error").getValue();
        NamedIcon error = NamedIcon.getIconByName(name);
        if (error == null && (error = ed.loadFailed("RpsPositionIcon: icon \"error\" ", name)) == null) {
            log.info("RpsPositionIcon: \"error\" removed for url= {}", (Object)name);
            return;
        }
        l.setErrorIcon(error);
        try {
            a = element.getAttribute("rotate");
            if (a != null) {
                int rotation = element.getAttribute("rotate").getIntValue();
                active.setRotation(rotation, l);
                error.setRotation(rotation, l);
            }
        }
        catch (DataConversionException dataConversionException) {}
        if ((a = element.getAttribute("momentary")) != null && a.getValue().equals("true")) {
            l.setMomentary(true);
        } else {
            l.setMomentary(false);
        }
        a = element.getAttribute("showid");
        if (a != null && a.getValue().equals("true")) {
            l.setShowID(true);
        } else {
            l.setShowID(false);
        }
        a = element.getAttribute("filter");
        if (a != null) {
            l.setFilter(a.getValue());
        }
        double sxScale = 0.0;
        double syScale = 0.0;
        int sxOrigin = 0;
        int syOrigin = 0;
        try {
            sxScale = element.getAttribute("sxscale").getDoubleValue();
            syScale = element.getAttribute("syscale").getDoubleValue();
            sxOrigin = element.getAttribute("sxorigin").getIntValue();
            syOrigin = element.getAttribute("syorigin").getIntValue();
        }
        catch (NullPointerException nullPointerException) {
            log.error("missing transform attribute");
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert transform attributes");
        }
        l.setTransform(sxScale, syScale, sxOrigin, syOrigin);
        NamedIcon icon = this.loadIcon(l, "active", element, "RpsPositionIcon ", ed);
        if (icon != null) {
            l.setActiveIcon(icon);
        }
        if ((icon = this.loadIcon(l, "error", element, "RpsPositionIcon ", ed)) != null) {
            l.setErrorIcon(icon);
        }
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 10, element);
    }
}

