/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.awt.Color;
import java.awt.Font;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ToolTip;
import jmri.util.gui.GuiLafPreferencesManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionableLabelXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(PositionableLabelXml.class);

    @Override
    public Element store(Object o) {
        PositionableLabel p = (PositionableLabel)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("positionablelabel");
        this.storeCommonAttributes(p, element);
        if (p.isText()) {
            if (p.getUnRotatedText() != null) {
                element.setAttribute("text", p.getUnRotatedText());
            }
            this.storeTextInfo(p, element);
        }
        if (p.isIcon() && p.getIcon() != null) {
            element.setAttribute("icon", "yes");
            element.addContent((Content)this.storeIcon("icon", (NamedIcon)p.getIcon()));
        }
        element.setAttribute("class", "jmri.jmrit.display.configurexml.PositionableLabelXml");
        return element;
    }

    protected void storeTextInfo(Positionable p, Element element) {
        String just;
        PositionablePopupUtil util = p.getPopupUtility();
        GuiLafPreferencesManager manager = InstanceManager.getDefault(GuiLafPreferencesManager.class);
        String defaultFontName = manager.getDefaultFont().getFontName();
        String fontName = util.getFont().getFontName();
        if (!fontName.equals(defaultFontName)) {
            element.setAttribute("fontname", util.getFont().getFontName());
        }
        element.setAttribute("size", "" + util.getFontSize());
        element.setAttribute("style", "" + util.getFontStyle());
        element.setAttribute("red", "" + util.getForeground().getRed());
        element.setAttribute("green", "" + util.getForeground().getGreen());
        element.setAttribute("blue", "" + util.getForeground().getBlue());
        element.setAttribute("hasBackground", util.hasBackground() ? "yes" : "no");
        if (util.hasBackground()) {
            element.setAttribute("redBack", "" + util.getBackground().getRed());
            element.setAttribute("greenBack", "" + util.getBackground().getGreen());
            element.setAttribute("blueBack", "" + util.getBackground().getBlue());
        }
        if (util.getMargin() != 0) {
            element.setAttribute("margin", "" + util.getMargin());
        }
        if (util.getBorderSize() != 0) {
            element.setAttribute("borderSize", "" + util.getBorderSize());
            element.setAttribute("redBorder", "" + util.getBorderColor().getRed());
            element.setAttribute("greenBorder", "" + util.getBorderColor().getGreen());
            element.setAttribute("blueBorder", "" + util.getBorderColor().getBlue());
        }
        if (util.getFixedWidth() != 0) {
            element.setAttribute("fixedWidth", "" + util.getFixedWidth());
        }
        if (util.getFixedHeight() != 0) {
            element.setAttribute("fixedHeight", "" + util.getFixedHeight());
        }
        switch (util.getJustification()) {
            case 2: {
                just = "right";
                break;
            }
            case 4: {
                just = "centre";
                break;
            }
            default: {
                just = "left";
            }
        }
        element.setAttribute("justification", just);
        if (util.getOrientation() != 0) {
            String ori;
            switch (util.getOrientation()) {
                case 2: {
                    ori = "vertical_down";
                    break;
                }
                case 1: {
                    ori = "vertical_up";
                    break;
                }
                default: {
                    ori = "horizontal";
                }
            }
            element.setAttribute("orientation", ori);
        }
    }

    public void storeCommonAttributes(Positionable p, Element element) {
        String txt;
        if (p.getId() != null) {
            element.setAttribute("id", p.getId());
        }
        element.setAttribute("x", "" + p.getX());
        element.setAttribute("y", "" + p.getY());
        element.setAttribute("level", String.valueOf(p.getDisplayLevel()));
        element.setAttribute("forcecontroloff", !p.isControlling() ? "true" : "false");
        element.setAttribute("hidden", p.isHidden() ? "yes" : "no");
        element.setAttribute("positionable", p.isPositionable() ? "true" : "false");
        element.setAttribute("showtooltip", p.showToolTip() ? "true" : "false");
        element.setAttribute("editable", p.isEditable() ? "true" : "false");
        ToolTip tip = p.getToolTip();
        if (tip != null && (txt = tip.getText()) != null) {
            Element elem = new Element("tooltip").addContent(txt);
            element.addContent((Content)elem);
        }
        if (p.getDegrees() != 0) {
            element.setAttribute("degrees", "" + p.getDegrees());
        }
    }

    public Element storeIcon(String elemName, NamedIcon icon) {
        if (icon == null) {
            return null;
        }
        Element element = new Element(elemName);
        element.setAttribute("url", icon.getURL());
        element.setAttribute("degrees", String.valueOf(icon.getDegrees()));
        element.setAttribute("scale", String.valueOf(icon.getScale()));
        element.addContent((Content)new Element("rotation").addContent(String.valueOf(icon.getRotation())));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        block18: {
            l = null;
            editor = (Editor)o;
            if (element.getAttribute("icon") == null) break block18;
            name = element.getAttribute("icon").getValue();
            if (name.equals("yes")) {
                icon = this.getNamedIcon("icon", element, "PositionableLabel ", editor);
            } else {
                icon = NamedIcon.getIconByName(name);
                if (icon == null && (icon = editor.loadFailed("PositionableLabel", name)) == null) {
                    PositionableLabelXml.log.info("PositionableLabel icon removed for url= {}", (Object)name);
                    return;
                }
            }
            if (icon == null && !name.equals("yes")) {
                PositionableLabelXml.log.info("PositionableLabel icon removed for url= {}", (Object)name);
                return;
            }
            l = new PositionableLabel(icon, editor);
            try {
                a = element.getAttribute("rotate");
                if (a != null && icon != null) {
                    rotation = element.getAttribute("rotate").getIntValue();
                    icon.setRotation(rotation, l);
                }
            }
            catch (DataConversionException v0) {}
            if (!name.equals("yes")) ** GOTO lbl30
            nIcon = this.loadIcon(l, "icon", element, "PositionableLabel ", editor);
            if (nIcon != null) {
                l.updateIcon(nIcon);
            } else {
                PositionableLabelXml.log.info("PositionableLabel icon removed for url= {}", (Object)name);
                return;
lbl30:
                // 1 sources

                l.updateIcon(icon);
            }
        }
        if (element.getAttribute("text") != null) {
            if (l == null) {
                l = new PositionableLabel(element.getAttribute("text").getValue(), editor);
            }
            this.loadTextInfo(l, element);
        } else if (l == null) {
            PositionableLabelXml.log.error("PositionableLabel is null!");
            if (PositionableLabelXml.log.isDebugEnabled()) {
                attrs = element.getAttributes();
                PositionableLabelXml.log.debug("\tElement Has {} Attributes:", (Object)attrs.size());
                for (Attribute a : attrs) {
                    PositionableLabelXml.log.debug("\t\t{} = {}", (Object)a.getName(), (Object)a.getValue());
                }
                kids = element.getChildren();
                PositionableLabelXml.log.debug("\tElementHas {} children:", (Object)kids.size());
                for (Element e : kids) {
                    PositionableLabelXml.log.debug("\t\t{} = \"{}\"", (Object)e.getName(), (Object)e.getValue());
                }
            }
            editor.loadFailed();
            return;
        }
        try {
            editor.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            PositionableLabelXml.log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        this.loadCommonAttributes(l, 4, element);
    }

    protected void loadTextInfo(Positionable l, Element element) {
        int green;
        int blue;
        int red;
        PositionablePopupUtil util;
        if (log.isDebugEnabled()) {
            log.debug("loadTextInfo");
        }
        if ((util = l.getPopupUtility()) == null) {
            log.warn("PositionablePopupUtil is null! {}", (Object)element);
            return;
        }
        Attribute a = element.getAttribute("size");
        try {
            if (a != null) {
                util.setFontSize(a.getFloatValue());
            }
        }
        catch (DataConversionException dataConversionException) {
            log.warn("invalid size attribute value");
        }
        a = element.getAttribute("style");
        try {
            if (a != null) {
                int style = a.getIntValue();
                int drop = 0;
                switch (style) {
                    case 0: 
                    case 2: {
                        drop = 1;
                        break;
                    }
                }
                util.setFontStyle(style, drop);
            }
        }
        catch (DataConversionException dataConversionException) {
            log.warn("invalid style attribute value");
        }
        a = element.getAttribute("fontname");
        try {
            if (a != null) {
                util.setFont(new Font(a.getValue(), util.getFontStyle(), util.getFontSize()));
                util = l.getPopupUtility();
            }
        }
        catch (NullPointerException nullPointerException) {}
        try {
            red = element.getAttribute("red").getIntValue();
            blue = element.getAttribute("blue").getIntValue();
            green = element.getAttribute("green").getIntValue();
            util.setForeground(new Color(red, green, blue));
        }
        catch (DataConversionException dataConversionException) {
            log.warn("Could not parse color attributes!");
        }
        catch (NullPointerException nullPointerException) {}
        a = element.getAttribute("hasBackground");
        if (a != null) {
            util.setHasBackground("yes".equals(a.getValue()));
        } else {
            util.setHasBackground(true);
        }
        if (util.hasBackground()) {
            try {
                red = element.getAttribute("redBack").getIntValue();
                blue = element.getAttribute("blueBack").getIntValue();
                green = element.getAttribute("greenBack").getIntValue();
                util.setBackgroundColor(new Color(red, green, blue));
            }
            catch (DataConversionException dataConversionException) {
                log.warn("Could not parse background color attributes!");
            }
            catch (NullPointerException nullPointerException) {
                util.setHasBackground(false);
            }
        }
        int fixedWidth = 0;
        int fixedHeight = 0;
        try {
            fixedHeight = element.getAttribute("fixedHeight").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
            log.warn("Could not parse fixed Height attributes!");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            fixedWidth = element.getAttribute("fixedWidth").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
            log.warn("Could not parse fixed Width attribute!");
        }
        catch (NullPointerException nullPointerException) {}
        if (fixedWidth != 0 || fixedHeight != 0) {
            util.setFixedSize(fixedWidth, fixedHeight);
        }
        if (util.getFixedWidth() == 0 || util.getFixedHeight() == 0) {
            try {
                util.setMargin(element.getAttribute("margin").getIntValue());
            }
            catch (DataConversionException dataConversionException) {
                log.warn("Could not parse margin attribute!");
            }
            catch (NullPointerException nullPointerException) {}
        }
        try {
            util.setBorderSize(element.getAttribute("borderSize").getIntValue());
            int red2 = element.getAttribute("redBorder").getIntValue();
            int blue2 = element.getAttribute("blueBorder").getIntValue();
            int green2 = element.getAttribute("greenBorder").getIntValue();
            util.setBorderColor(new Color(red2, green2, blue2));
        }
        catch (DataConversionException dataConversionException) {
            log.warn("Could not parse border attributes!");
        }
        catch (NullPointerException nullPointerException) {}
        a = element.getAttribute("justification");
        if (a != null) {
            util.setJustification(a.getValue());
        } else {
            util.setJustification("left");
        }
        a = element.getAttribute("orientation");
        if (a != null) {
            util.setOrientation(a.getValue());
        } else {
            util.setOrientation("horizontal");
        }
        int deg = 0;
        try {
            a = element.getAttribute("degrees");
            if (a != null) {
                deg = a.getIntValue();
                l.rotate(deg);
            }
        }
        catch (DataConversionException dataConversionException) {
            log.warn("invalid 'degrees' value (non integer)");
        }
        if (deg == 0 && util.hasBackground()) {
            l.setOpaque(true);
        }
    }

    public void loadCommonAttributes(Positionable l, int defaultLevel, Element element) throws JmriConfigureXmlException {
        ToolTip tip;
        Element elem;
        if (element.getAttribute("id") != null) {
            try {
                l.setId(element.getAttribute("id").getValue());
            }
            catch (Positionable.DuplicateIdException e) {
                throw new JmriConfigureXmlException("Positionable id is not unique", e);
            }
        }
        try {
            l.setControlling(!element.getAttribute("forcecontroloff").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert positionable label forcecontroloff attribute");
        }
        catch (Exception exception) {}
        int x = 0;
        int y = 0;
        try {
            x = element.getAttribute("x").getIntValue();
            y = element.getAttribute("y").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert positional attribute");
        }
        l.setLocation(x, y);
        int level = defaultLevel;
        try {
            level = element.getAttribute("level").getIntValue();
        }
        catch (DataConversionException dataConversionException) {
            log.warn("Could not parse level attribute!");
        }
        catch (NullPointerException nullPointerException) {}
        l.setDisplayLevel(level);
        try {
            boolean value = element.getAttribute("hidden").getBooleanValue();
            l.setHidden(value);
            l.setVisible(!value);
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert positionable label hidden attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            l.setPositionable(element.getAttribute("positionable").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert positionable label positionable attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            l.setShowToolTip(element.getAttribute("showtooltip").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert positionable label showtooltip attribute");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            l.setEditable(element.getAttribute("editable").getBooleanValue());
        }
        catch (DataConversionException dataConversionException) {
            log.warn("unable to convert positionable label editable attribute");
        }
        catch (NullPointerException nullPointerException) {}
        Attribute a = element.getAttribute("degrees");
        if (a != null && l instanceof PositionableLabel) {
            try {
                int deg = a.getIntValue();
                ((PositionableLabel)l).setDegrees(deg);
            }
            catch (DataConversionException dataConversionException) {}
        }
        if ((elem = element.getChild("tooltip")) == null) {
            elem = element.getChild("toolTip");
        }
        if (elem != null && (tip = l.getToolTip()) != null) {
            tip.setText(elem.getText());
        }
    }

    public NamedIcon loadIcon(PositionableLabel l, String attrName, Element element, String name, Editor ed) {
        NamedIcon icon = this.getNamedIcon(attrName, element, name, ed);
        if (icon != null) {
            try {
                int deg = 0;
                double scale = 1.0;
                Element elem = element.getChild(attrName);
                if (elem != null) {
                    Attribute a = elem.getAttribute("degrees");
                    if (a != null) {
                        deg = a.getIntValue();
                    }
                    if ((a = elem.getAttribute("scale")) != null) {
                        scale = elem.getAttribute("scale").getDoubleValue();
                    }
                    icon.setLoad(deg, scale, l);
                    if (deg == 0) {
                        Element e;
                        a = elem.getAttribute("rotate");
                        if (a != null) {
                            int rotation = a.getIntValue();
                            if (scale == 1.0) {
                                icon.setRotation(rotation, l);
                            }
                        }
                        if ((e = elem.getChild("rotation")) != null) {
                            int rotation = Integer.parseInt(e.getText());
                            icon.setRotation(rotation, l);
                        }
                    }
                }
            }
            catch (DataConversionException dataConversionException) {}
        }
        return icon;
    }

    protected NamedIcon getNamedIcon(String childName, Element element, String name, Editor ed) {
        NamedIcon icon = null;
        Element elem = element.getChild(childName);
        if (elem != null) {
            String iconName = elem.getAttribute("url").getValue();
            icon = NamedIcon.getIconByName(iconName);
            if (icon == null && (icon = ed.loadFailed(name, iconName)) == null) {
                log.info("{} removed for url= {}", (Object)name, (Object)iconName);
            }
        } else {
            log.debug("getNamedIcon: child element \"{}\" not found in element {}", (Object)childName, (Object)element.getName());
        }
        return icon;
    }
}

