/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.MemoryComboIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryComboIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(MemoryComboIconXml.class);

    @Override
    public Element store(Object obj) {
        MemoryComboIcon memoryIcon = (MemoryComboIcon)obj;
        Element element = new Element("memoryComboIcon");
        Element elem = new Element("itemList");
        MemoryComboIcon.ComboModel model = memoryIcon.getComboModel();
        int i = 0;
        while (i < model.getSize()) {
            Element e = new Element("item");
            e.setAttribute("index", "" + i);
            e.addContent((String)model.getElementAt(i));
            elem.addContent((Content)e);
            ++i;
        }
        element.addContent((Content)elem);
        element.setAttribute("memory", memoryIcon.getNamedMemory().getName());
        this.storeCommonAttributes(memoryIcon, element);
        this.storeTextInfo(memoryIcon, element);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.MemoryComboIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor p = (Editor)o;
        Element elem = element.getChild("itemList");
        List list = elem.getChildren("item");
        String[] items = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            block7: {
                Element e = (Element)list.get(i);
                String item = e.getText();
                try {
                    int idx = e.getAttribute("index").getIntValue();
                    items[idx] = item;
                }
                catch (DataConversionException dataConversionException) {
                    log.error("failed to convert ComboBoxIcon index attribute");
                    if (items[i] != null) break block7;
                    items[i] = item;
                }
            }
            ++i;
        }
        MemoryComboIcon l = new MemoryComboIcon(p, items);
        this.loadTextInfo(l, element);
        Attribute attr = element.getAttribute("memory");
        if (attr == null) {
            log.error("incorrect information for a memory location; must use memory name");
            p.loadFailed();
            return;
        }
        String name = attr.getValue();
        Memory m = InstanceManager.memoryManagerInstance().getMemory(name);
        if (m == null) {
            log.error("Memory named '{}' not found.", (Object)attr.getValue());
            p.loadFailed();
            return;
        }
        l.setMemory(name);
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 5, element);
    }
}

