/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(LocoIconXml.class);

    @Override
    public Element store(Object o) {
        LocoIcon p = (LocoIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("locoicon");
        this.storeCommonAttributes(p, element);
        if (p.getUnRotatedText() != null) {
            element.setAttribute("text", p.getUnRotatedText());
        }
        this.storeTextInfo(p, element);
        element.setAttribute("icon", "yes");
        element.setAttribute("dockX", "" + p.getDockX());
        element.setAttribute("dockY", "" + p.getDockY());
        element.addContent((Content)this.storeIcon("icon", (NamedIcon)p.getIcon()));
        RosterEntry entry = p.getRosterEntry();
        if (entry != null) {
            element.setAttribute("rosterentry", entry.getId());
        }
        element.setAttribute("class", "jmri.jmrit.display.configurexml.LocoIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        NamedIcon icon;
        Editor ed = (Editor)o;
        LocoIcon l = new LocoIcon(ed);
        String textName = "error";
        try {
            textName = element.getAttribute("text").getValue();
        }
        catch (Exception e) {
            log.error("failed to get loco text attribute ex= {}", (Throwable)e);
        }
        String name = "error";
        try {
            name = element.getAttribute("icon").getValue();
        }
        catch (Exception e) {
            log.error("failed to get icon attribute ex= {}", (Throwable)e);
        }
        if (name.equals("yes")) {
            icon = this.loadIcon(l, "icon", element, "LocoIcon", ed);
        } else {
            icon = NamedIcon.getIconByName(name);
            if (icon == null && (icon = ed.loadFailed("LocoIcon", name)) == null) {
                log.info("LocoIcon icon removed for url= {}", (Object)name);
                return;
            }
        }
        l.updateIcon(icon);
        try {
            int x = element.getAttribute("dockX").getIntValue();
            int y = element.getAttribute("dockY").getIntValue();
            l.setDockingLocation(x, y);
        }
        catch (Exception e) {
            log.warn("failed to get docking location= {}", (Throwable)e);
        }
        String rosterId = null;
        try {
            rosterId = element.getAttribute("rosterentry").getValue();
            RosterEntry entry = Roster.getDefault().entryFromTitle(rosterId);
            l.setRosterEntry(entry);
        }
        catch (Exception e) {
            log.debug("no roster entry for {}, ex= {}", (Object)rosterId, (Object)e);
        }
        ed.putLocoIcon(l, textName);
        this.loadCommonAttributes(l, 10, element);
        this.loadTextInfo(l, element);
        l.init();
    }
}

