/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LightIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(LightIconXml.class);

    @Override
    public Element store(Object o) {
        LightIcon p = (LightIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("LightIcon");
        element.setAttribute("light", p.getLight().getSystemName());
        this.storeCommonAttributes(p, element);
        Element elem = new Element("icons");
        elem.addContent((Content)this.storeIcon("on", p.getOnIcon()));
        elem.addContent((Content)this.storeIcon("off", p.getOffIcon()));
        elem.addContent((Content)this.storeIcon("unknown", p.getUnknownIcon()));
        elem.addContent((Content)this.storeIcon("inconsistent", p.getInconsistentIcon()));
        element.addContent((Content)elem);
        element.setAttribute("class", "jmri.jmrit.display.configurexml.LightIconXml");
        return element;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        String name;
        Editor p = (Editor)o;
        LightIcon l = new LightIcon(p);
        try {
            name = element.getAttribute("light").getValue();
        }
        catch (NullPointerException nullPointerException) {
            log.error("incorrect information for light; must use light name");
            p.loadFailed();
            return;
        }
        l.setLight(name);
        Element icons = element.getChild("icons");
        if (icons == null) {
            if (log.isDebugEnabled()) {
                log.debug("Main element of Light {}has no icons", (Object)name);
            }
        } else {
            NamedIcon icon = this.loadIcon(l, "on", icons, "LightIcon \"" + name + "\": icon \"on\" ", p);
            if (icon == null) {
                log.info("LightIcon \"{}\": icon \"on\" removed", (Object)name);
                return;
            }
            l.setOnIcon(icon);
            icon = this.loadIcon(l, "off", icons, "LightIcon \"" + name + "\": icon \"off\" ", p);
            if (icon == null) {
                log.info("LightIcon \"{}\": icon \"off\" removed", (Object)name);
                return;
            }
            l.setOffIcon(icon);
            icon = this.loadIcon(l, "unknown", icons, "LightIcon \"" + name + "\": icon \"unknown\" ", p);
            if (icon == null) {
                log.info("LightIcon \"{}\": icon \"unknown\" removed", (Object)name);
                return;
            }
            l.setUnknownIcon(icon);
            icon = this.loadIcon(l, "inconsistent", icons, "LightIcon \"" + name + "\": icon \"inconsistent\" ", p);
            if (icon != null) {
                l.setInconsistentIcon(icon);
            } else {
                log.info("LightIcon \"{}\": icon \"inconsistent\" removed", (Object)name);
                return;
            }
        }
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        this.loadCommonAttributes(l, 8, element);
    }
}

