/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.IndicatorTrackIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.configurexml.PositionableLabelXml;
import jmri.jmrit.logix.OBlock;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorTrackIconXml
extends PositionableLabelXml {
    private static final Logger log = LoggerFactory.getLogger(IndicatorTrackIconXml.class);

    @Override
    public Element store(Object o) {
        IndicatorTrackIcon p = (IndicatorTrackIcon)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("indicatortrackicon");
        this.storeCommonAttributes(p, element);
        NamedBeanHandle<OBlock> b = p.getNamedOccBlock();
        if (b != null) {
            element.addContent((Content)IndicatorTrackIconXml.storeNamedBean("occupancyblock", b));
        }
        NamedBeanHandle<Sensor> s = p.getNamedOccSensor();
        if (b == null && s != null) {
            element.addContent((Content)IndicatorTrackIconXml.storeNamedBean("occupancysensor", s));
        }
        Element elem = new Element("showTrainName");
        String show = "no";
        if (p.showTrain()) {
            show = "yes";
        }
        elem.addContent(show);
        element.addContent((Content)elem);
        HashMap<String, NamedIcon> iconMap = p.getIconMap();
        Iterator<Map.Entry<String, NamedIcon>> it = iconMap.entrySet().iterator();
        elem = new Element("iconmap");
        String family = p.getFamily();
        if (family != null) {
            elem.setAttribute("family", family);
        }
        while (it.hasNext()) {
            Map.Entry<String, NamedIcon> entry = it.next();
            elem.addContent((Content)this.storeIcon(entry.getKey(), entry.getValue()));
        }
        element.addContent((Content)elem);
        elem = new Element("paths");
        ArrayList<String> paths = p.getPaths();
        if (paths != null) {
            for (String path : paths) {
                Element e = new Element("path");
                e.addContent(path);
                elem.addContent((Content)e);
            }
            element.addContent((Content)elem);
        }
        element.setAttribute("class", "jmri.jmrit.display.configurexml.IndicatorTrackIconXml");
        return element;
    }

    static Element storeNamedBean(String elemName, NamedBeanHandle<?> nb) {
        Element elem = new Element(elemName);
        elem.addContent(nb.getName());
        return elem;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Element name;
        Editor p = (Editor)o;
        IndicatorTrackIcon l = new IndicatorTrackIcon(p);
        Element elem = element.getChild("iconmap");
        if (elem != null) {
            Attribute attr;
            List status = elem.getChildren();
            if (status.size() > 0) {
                for (Element value : status) {
                    String msg = "IndicatorTrack \"" + l.getNameString() + "\" icon \"" + value.getName() + "\" ";
                    NamedIcon icon = this.loadIcon(l, value.getName(), elem, msg, p);
                    if (icon != null) {
                        l.setIcon(value.getName(), icon);
                        continue;
                    }
                    log.info("{} removed for url= {}", (Object)msg, (Object)value.getName());
                    return;
                }
            }
            if ((attr = elem.getAttribute("family")) != null) {
                l.setFamily(attr.getValue());
            }
        }
        if ((name = element.getChild("occupancyblock")) != null) {
            l.setOccBlock(name.getText());
        } else {
            name = element.getChild("occupancysensor");
            if (name != null) {
                l.setOccSensor(name.getText());
            }
        }
        l.setShowTrain(false);
        name = element.getChild("showTrainName");
        if (name != null && "yes".equals(name.getText())) {
            l.setShowTrain(true);
        }
        if ((elem = element.getChild("paths")) != null) {
            ArrayList<String> paths = new ArrayList<String>();
            List pth = elem.getChildren();
            for (Element value : pth) {
                paths.add(value.getText());
            }
            l.setPaths(paths);
        }
        l.displayState(l.getStatus());
        l.updateSize();
        try {
            p.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
        this.loadCommonAttributes(l, 7, element);
    }
}

