/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display.configurexml;

import java.awt.Color;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.display.AnalogClock2Display;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.util.ColorUtil;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogClock2DisplayXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(AnalogClock2DisplayXml.class);

    @Override
    public Element store(Object o) {
        AnalogClock2Display p = (AnalogClock2Display)o;
        if (!p.isActive()) {
            return null;
        }
        Element element = new Element("fastclock");
        if (p.getId() != null) {
            element.setAttribute("id", p.getId());
        }
        element.setAttribute("x", "" + p.getX());
        element.setAttribute("y", "" + p.getY());
        element.setAttribute("scale", "" + p.getScale());
        element.setAttribute("color", ColorUtil.colorToColorName(p.getColor()));
        String link = p.getURL();
        if (link != null && link.trim().length() > 0) {
            element.setAttribute("link", link);
        }
        element.setAttribute("class", "jmri.jmrit.display.configurexml.AnalogClock2DisplayXml");
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.error("Invalid method called");
        return false;
    }

    @Override
    public void load(Element element, Object o) throws JmriConfigureXmlException {
        Editor ed = (Editor)o;
        AnalogClock2Display l = new AnalogClock2Display(ed);
        int x = 0;
        int y = 0;
        double scale = 1.0;
        Color color = Color.black;
        try {
            if (element.getAttribute("id") != null) {
                try {
                    l.setId(element.getAttribute("id").getValue());
                }
                catch (Positionable.DuplicateIdException e) {
                    throw new JmriConfigureXmlException("Positionable id is not unique", e);
                }
            }
            x = element.getAttribute("x").getIntValue();
            y = element.getAttribute("y").getIntValue();
            if (element.getAttribute("scale") != null) {
                scale = element.getAttribute("scale").getDoubleValue();
            }
            try {
                if (element.getAttribute("color") != null) {
                    color = ColorUtil.stringToColor(element.getAttribute("color").getValue());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Invalid color {}; using black", (Object)element.getAttribute("color").getValue());
            }
        }
        catch (DataConversionException dataConversionException) {
            log.error("failed to convert positional attribute");
        }
        if (element.getAttribute("link") != null) {
            l.setULRL(element.getAttribute("link").getValue());
        }
        l.setOpaque(false);
        l.update();
        l.setLocation(x, y);
        if (scale != 1.0 && 10.0 > scale && scale > 0.1) {
            l.setScale(scale);
        }
        l.setColor(color);
        l.setDisplayLevel(10);
        try {
            ed.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            throw new JmriConfigureXmlException("Positionable id is not unique", e);
        }
    }
}

