/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.SlipIconAdder;
import jmri.jmrit.display.SlipTurnoutTextEdit;
import jmri.jmrit.picker.PickListModel;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlipTurnoutIcon
extends PositionableLabel
implements PropertyChangeListener {
    private NamedBeanHandle<Turnout> namedTurnoutWest = null;
    private NamedBeanHandle<Turnout> namedTurnoutWestLower = null;
    private NamedBeanHandle<Turnout> namedTurnoutEast = null;
    private NamedBeanHandle<Turnout> namedTurnoutEastLower = null;
    public static final int WEST = 1;
    public static final int EAST = 2;
    public static final int LOWERWEST = 4;
    public static final int LOWEREAST = 6;
    public static final int DOUBLESLIP = 0;
    public static final int SINGLESLIP = 2;
    public static final int THREEWAY = 4;
    public static final int SCISSOR = 8;
    int turnoutType = 0;
    boolean singleSlipRoute = false;
    static boolean LOWERWESTtoLOWEREAST = false;
    static boolean UPPERWESTtoUPPEREAST = true;
    String lowerWestToUpperEastLName = "resources/icons/smallschematics/tracksegments/os-slip-lower-west-upper-east.gif";
    NamedIcon lowerWestToUpperEast = new NamedIcon(this.lowerWestToUpperEastLName, this.lowerWestToUpperEastLName);
    String upperWestToLowerEastLName = "resources/icons/smallschematics/tracksegments/os-slip-upper-west-lower-east.gif";
    NamedIcon upperWestToLowerEast = new NamedIcon(this.upperWestToLowerEastLName, this.upperWestToLowerEastLName);
    String lowerWestToLowerEastLName = "resources/icons/smallschematics/tracksegments/os-slip-lower-west-lower-east.gif";
    NamedIcon lowerWestToLowerEast = new NamedIcon(this.lowerWestToLowerEastLName, this.lowerWestToLowerEastLName);
    String upperWestToUpperEastLName = "resources/icons/smallschematics/tracksegments/os-slip-upper-west-upper-east.gif";
    NamedIcon upperWestToUpperEast = new NamedIcon(this.upperWestToUpperEastLName, this.upperWestToUpperEastLName);
    String inconsistentLName = "resources/icons/smallschematics/tracksegments/os-slip-error-full.gif";
    NamedIcon inconsistent = new NamedIcon(this.inconsistentLName, this.inconsistentLName);
    String unknownLName = "resources/icons/smallschematics/tracksegments/os-slip-unknown-full.gif";
    NamedIcon unknown = new NamedIcon(this.unknownLName, this.unknownLName);
    private boolean tristate = false;
    JCheckBoxMenuItem tristateItem = null;
    String lowerWestToUpperEastText = Bundle.getMessage("LowerWestToUpperEast");
    String upperWestToLowerEastText = Bundle.getMessage("UpperWestToLowerEast");
    String lowerWestToLowerEastText = Bundle.getMessage("LowerWestToLowerEast");
    String upperWestToUpperEastText = Bundle.getMessage("UpperWestToUpperEast");
    SlipIconAdder _iconEditor;
    boolean firstStraight = false;
    HashMap<Turnout, Integer> _turnoutSetting = new HashMap();
    boolean busy = false;
    private static final Logger log = LoggerFactory.getLogger(SlipTurnoutIcon.class);

    public SlipTurnoutIcon(Editor editor) {
        super(new NamedIcon("resources/icons/smallschematics/tracksegments/os-slip-lower-west-upper-east.gif", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-upper-east.gif"), editor);
        this._control = true;
        this.displayState(this.turnoutState());
        this.setPopupUtility(null);
    }

    public void setTurnout(String pName, int turn) {
        if (InstanceManager.getNullableDefault(TurnoutManager.class) != null) {
            try {
                Turnout turnout = InstanceManager.turnoutManagerInstance().provideTurnout(pName);
                this.setTurnout(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, turnout), turn);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error("Turnout '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No TurnoutManager for this protocol, icon won't see changes");
        }
    }

    public void setTurnout(NamedBeanHandle<Turnout> to, int turn) {
        switch (turn) {
            case 1: {
                if (this.namedTurnoutWest != null) {
                    this.getTurnout(1).removePropertyChangeListener(this);
                }
                this.namedTurnoutWest = to;
                if (this.namedTurnoutWest == null) break;
                this.displayState(this.turnoutState());
                this.getTurnout(1).addPropertyChangeListener(this, this.namedTurnoutWest.getName(), "Panel Editor Turnout");
                break;
            }
            case 2: {
                if (this.namedTurnoutEast != null) {
                    this.getTurnout(2).removePropertyChangeListener(this);
                }
                this.namedTurnoutEast = to;
                if (this.namedTurnoutEast == null) break;
                this.displayState(this.turnoutState());
                this.getTurnout(2).addPropertyChangeListener(this, this.namedTurnoutEast.getName(), "Panel Editor Turnout");
                break;
            }
            case 4: {
                if (this.namedTurnoutWestLower != null) {
                    this.getTurnout(4).removePropertyChangeListener(this);
                }
                this.namedTurnoutWestLower = to;
                if (this.namedTurnoutWestLower == null) break;
                this.displayState(this.turnoutState());
                this.getTurnout(4).addPropertyChangeListener(this, this.namedTurnoutWestLower.getName(), "Panel Editor Turnout");
                break;
            }
            case 6: {
                if (this.namedTurnoutEastLower != null) {
                    this.getTurnout(6).removePropertyChangeListener(this);
                }
                this.namedTurnoutEastLower = to;
                if (this.namedTurnoutEastLower == null) break;
                this.displayState(this.turnoutState());
                this.getTurnout(6).addPropertyChangeListener(this, this.namedTurnoutEastLower.getName(), "Panel Editor Turnout");
                break;
            }
            default: {
                log.error("turn value {} should not have appeared", (Object)turn);
            }
        }
    }

    public void setTurnoutType(int slip) {
        this.turnoutType = slip;
    }

    public int getTurnoutType() {
        return this.turnoutType;
    }

    public boolean getSingleSlipRoute() {
        return this.singleSlipRoute;
    }

    public void setSingleSlipRoute(boolean route) {
        this.singleSlipRoute = route;
    }

    public Turnout getTurnout(int turn) {
        switch (turn) {
            case 2: {
                return this.namedTurnoutEast.getBean();
            }
            case 1: {
                return this.namedTurnoutWest.getBean();
            }
            case 6: {
                return this.namedTurnoutEastLower.getBean();
            }
            case 4: {
                return this.namedTurnoutWestLower.getBean();
            }
        }
        return null;
    }

    public NamedBeanHandle<Turnout> getNamedTurnout(int turn) {
        switch (turn) {
            case 2: {
                return this.namedTurnoutEast;
            }
            case 1: {
                return this.namedTurnoutWest;
            }
            case 6: {
                return this.namedTurnoutEastLower;
            }
            case 4: {
                return this.namedTurnoutWestLower;
            }
        }
        return null;
    }

    public NamedIcon getLowerWestToUpperEastIcon() {
        return this.lowerWestToUpperEast;
    }

    public void setLowerWestToUpperEastIcon(NamedIcon i) {
        this.lowerWestToUpperEast = i;
        this.displayState(this.turnoutState());
    }

    public NamedIcon getUpperWestToLowerEastIcon() {
        return this.upperWestToLowerEast;
    }

    public void setUpperWestToLowerEastIcon(NamedIcon i) {
        this.upperWestToLowerEast = i;
        this.displayState(this.turnoutState());
    }

    public NamedIcon getLowerWestToLowerEastIcon() {
        return this.lowerWestToLowerEast;
    }

    public void setLowerWestToLowerEastIcon(NamedIcon i) {
        this.lowerWestToLowerEast = i;
        this.displayState(this.turnoutState());
        if (this.turnoutType != 0) {
            this.setUpperWestToUpperEastIcon(i);
        }
    }

    public NamedIcon getUpperWestToUpperEastIcon() {
        return this.upperWestToUpperEast;
    }

    public void setUpperWestToUpperEastIcon(NamedIcon i) {
        this.upperWestToUpperEast = i;
        this.displayState(this.turnoutState());
    }

    public NamedIcon getInconsistentIcon() {
        return this.inconsistent;
    }

    public void setInconsistentIcon(NamedIcon i) {
        this.inconsistent = i;
        this.displayState(this.turnoutState());
    }

    public NamedIcon getUnknownIcon() {
        return this.unknown;
    }

    public void setUnknownIcon(NamedIcon i) {
        this.unknown = i;
        this.displayState(this.turnoutState());
    }

    @Override
    public int maxHeight() {
        return Math.max(Math.max(this.lowerWestToUpperEast != null ? this.lowerWestToUpperEast.getIconHeight() : 0, this.upperWestToLowerEast != null ? this.upperWestToLowerEast.getIconHeight() : 0), Math.max(Math.max(this.upperWestToUpperEast != null ? this.upperWestToUpperEast.getIconHeight() : 0, this.lowerWestToLowerEast != null ? this.lowerWestToLowerEast.getIconHeight() : 0), Math.max(this.unknown != null ? this.unknown.getIconHeight() : 0, this.inconsistent != null ? this.inconsistent.getIconHeight() : 0)));
    }

    @Override
    public int maxWidth() {
        return Math.max(Math.max(this.lowerWestToUpperEast != null ? this.lowerWestToUpperEast.getIconWidth() : 0, this.upperWestToLowerEast != null ? this.upperWestToLowerEast.getIconWidth() : 0), Math.max(Math.max(this.upperWestToUpperEast != null ? this.upperWestToUpperEast.getIconWidth() : 0, this.lowerWestToLowerEast != null ? this.lowerWestToLowerEast.getIconWidth() : 0), Math.max(this.unknown != null ? this.unknown.getIconWidth() : 0, this.inconsistent != null ? this.inconsistent.getIconWidth() : 0)));
    }

    int turnoutState() {
        if (this.namedTurnoutWest != null) {
            if (this.getTurnout(1).getKnownState() == 1) {
                return 1;
            }
            if (this.getTurnout(1).getKnownState() == 8) {
                return 8;
            }
        } else {
            return 1;
        }
        int state = this.getTurnout(1).getKnownState();
        if (this.namedTurnoutEast != null) {
            if (this.getTurnout(2).getKnownState() == 1) {
                return 1;
            }
            if (this.getTurnout(2).getKnownState() == 8) {
                return 8;
            }
            if (this.getTurnout(2).getKnownState() == 2) {
                state += this.getTurnout(2).getKnownState() + 1;
            }
            if (this.getTurnout(2).getKnownState() == 4) {
                state += this.getTurnout(2).getKnownState() + 3;
            }
        } else {
            return 1;
        }
        if (this.turnoutType == 8 && !this.singleSlipRoute) {
            if (this.namedTurnoutEastLower != null) {
                if (this.getTurnout(6).getKnownState() == 1) {
                    return 1;
                }
                if (this.getTurnout(6).getKnownState() == 8) {
                    return 8;
                }
            } else {
                return 1;
            }
            if (this.namedTurnoutWestLower != null) {
                if (this.getTurnout(4).getKnownState() == 1) {
                    return 1;
                }
                if (this.getTurnout(4).getKnownState() == 8) {
                    return 8;
                }
            } else {
                return 1;
            }
            if (this.getTurnout(6).getKnownState() != this.getTurnout(1).getKnownState()) {
                return 8;
            }
            if (this.getTurnout(4).getKnownState() != this.getTurnout(2).getKnownState()) {
                return 8;
            }
        }
        return state;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property change: {} {} is now {}", new Object[]{this.getNameString(), e.getPropertyName(), e.getNewValue()});
        }
        if (this.getTristate() && this.getTurnout(1).getFeedbackMode() != 1 && e.getPropertyName().equals("CommandedState")) {
            if (this.getTurnout(1).getCommandedState() != this.getTurnout(1).getKnownState() || this.getTurnout(2).getCommandedState() != this.getTurnout(2).getKnownState()) {
                int now = 8;
                this.displayState(now);
            }
            if (this.getTurnout(1).getCommandedState() == this.getTurnout(1).getKnownState() || this.getTurnout(2).getCommandedState() == this.getTurnout(2).getKnownState()) {
                this.displayState(this.turnoutState());
            }
        }
        if (e.getPropertyName().equals("KnownState")) {
            this.displayState(this.turnoutState());
        }
    }

    @Override
    public String getNameString() {
        String name = this.namedTurnoutWest == null ? Bundle.getMessage("NotConnected") : this.namedTurnoutWest.getName();
        if (this.namedTurnoutEast != null) {
            name = String.valueOf(name) + " " + this.namedTurnoutEast.getName();
        }
        if (this.getTurnoutType() == 8 && !this.getSingleSlipRoute()) {
            if (this.namedTurnoutWestLower != null) {
                name = String.valueOf(name) + " " + this.namedTurnoutWestLower.getName();
            }
            if (this.namedTurnoutEastLower != null) {
                name = String.valueOf(name) + " " + this.namedTurnoutEastLower.getName();
            }
        }
        return name;
    }

    public void setTristate(boolean set) {
        this.tristate = set;
    }

    public boolean getTristate() {
        return this.tristate;
    }

    void addTristateEntry(JPopupMenu popup) {
        this.tristateItem = new JCheckBoxMenuItem(Bundle.getMessage("Tristate"));
        this.tristateItem.setSelected(this.getTristate());
        popup.add(this.tristateItem);
        this.tristateItem.addActionListener(e -> this.setTristate(this.tristateItem.isSelected()));
    }

    @Override
    protected void rotateOrthogonal() {
        this.lowerWestToUpperEast.setRotation(this.lowerWestToUpperEast.getRotation() + 1, this);
        this.upperWestToLowerEast.setRotation(this.upperWestToLowerEast.getRotation() + 1, this);
        this.lowerWestToLowerEast.setRotation(this.lowerWestToLowerEast.getRotation() + 1, this);
        this.upperWestToUpperEast.setRotation(this.upperWestToUpperEast.getRotation() + 1, this);
        this.unknown.setRotation(this.unknown.getRotation() + 1, this);
        this.inconsistent.setRotation(this.inconsistent.getRotation() + 1, this);
        this.displayState(this.turnoutState());
        this.repaint();
    }

    @Override
    public void setScale(double s) {
        this.lowerWestToUpperEast.scale(s, this);
        this.upperWestToLowerEast.scale(s, this);
        this.lowerWestToLowerEast.scale(s, this);
        this.upperWestToUpperEast.scale(s, this);
        this.unknown.scale(s, this);
        this.inconsistent.scale(s, this);
        this.displayState(this.turnoutState());
    }

    @Override
    public void rotate(int deg) {
        this.lowerWestToUpperEast.rotate(deg, this);
        this.upperWestToLowerEast.rotate(deg, this);
        this.lowerWestToLowerEast.rotate(deg, this);
        this.upperWestToUpperEast.rotate(deg, this);
        this.unknown.rotate(deg, this);
        this.inconsistent.rotate(deg, this);
        this.displayState(this.turnoutState());
    }

    void displayState(int state) {
        log.debug("{} displayState {}", (Object)this.getNameString(), (Object)state);
        this.updateSize();
        block0 : switch (this.getTurnoutType()) {
            case 2: {
                if (this.singleSlipRoute && state == 9) {
                    state = 0;
                    break;
                }
                if (this.singleSlipRoute || state != 7) break;
                state = 0;
                break;
            }
            case 4: {
                if (state == 7 || state == 11) {
                    if (this.singleSlipRoute) {
                        state = 11;
                        break;
                    }
                    state = 9;
                    break;
                }
                if (state != 9 || this.singleSlipRoute) break;
                state = 11;
                break;
            }
            case 8: {
                switch (state) {
                    case 5: {
                        state = 9;
                        break block0;
                    }
                    case 7: {
                        state = 5;
                        break block0;
                    }
                    case 9: {
                        state = 11;
                        break block0;
                    }
                    case 11: {
                        state = 0;
                        break block0;
                    }
                }
                log.warn("Unhandled scissors state: {}", (Object)state);
                break;
            }
            case 0: {
                break;
            }
            default: {
                log.warn("Unhandled turnout type: {}", (Object)this.getTurnoutType());
            }
        }
        switch (state) {
            case 1: {
                if (this.isText()) {
                    super.setText(Bundle.getMessage("BeanStateUnknown"));
                }
                if (!this.isIcon()) break;
                super.setIcon(this.unknown);
                break;
            }
            case 5: {
                if (this.isText()) {
                    super.setText(this.upperWestToLowerEastText);
                }
                if (!this.isIcon()) break;
                super.setIcon(this.upperWestToLowerEast);
                break;
            }
            case 9: {
                if (this.isText()) {
                    super.setText(this.lowerWestToLowerEastText);
                }
                if (!this.isIcon()) break;
                super.setIcon(this.lowerWestToLowerEast);
                break;
            }
            case 7: {
                if (this.isText()) {
                    super.setText(this.upperWestToUpperEastText);
                }
                if (!this.isIcon()) break;
                super.setIcon(this.upperWestToUpperEast);
                break;
            }
            case 11: {
                if (this.isText()) {
                    super.setText(this.lowerWestToUpperEastText);
                }
                if (!this.isIcon()) break;
                super.setIcon(this.lowerWestToUpperEast);
                break;
            }
            default: {
                if (this.isText()) {
                    super.setText(Bundle.getMessage("BeanStateInconsistent"));
                }
                if (!this.isIcon()) break;
                super.setIcon(this.inconsistent);
            }
        }
    }

    public String getLWUEText() {
        return this.lowerWestToUpperEastText;
    }

    public String getUWLEText() {
        return this.upperWestToLowerEastText;
    }

    public String getLWLEText() {
        return this.lowerWestToLowerEastText;
    }

    public String getUWUEText() {
        return this.upperWestToUpperEastText;
    }

    public void setLWUEText(String txt) {
        this.lowerWestToUpperEastText = txt;
    }

    public void setUWLEText(String txt) {
        this.upperWestToLowerEastText = txt;
    }

    public void setLWLEText(String txt) {
        this.lowerWestToLowerEastText = txt;
    }

    public void setUWUEText(String txt) {
        this.upperWestToUpperEastText = txt;
    }

    @Override
    protected void edit() {
        if (this._iconEditor == null) {
            this._iconEditor = new SlipIconAdder();
        }
        this.makeIconEditorFrame(this, "SlipTOEditor", true, this._iconEditor);
        this._iconEditor.setPickList(PickListModel.turnoutPickModelInstance());
        this._iconEditor.setTurnoutType(this.getTurnoutType());
        switch (this.getTurnoutType()) {
            case 0: {
                this._iconEditor.setIcon(3, "LowerWestToUpperEast", this.getLowerWestToUpperEastIcon());
                this._iconEditor.setIcon(2, "UpperWestToLowerEast", this.getUpperWestToLowerEastIcon());
                this._iconEditor.setIcon(4, "LowerWestToLowerEast", this.getLowerWestToLowerEastIcon());
                this._iconEditor.setIcon(5, "UpperWestToUpperEast", this.getUpperWestToUpperEastIcon());
                break;
            }
            case 2: {
                this._iconEditor.setSingleSlipRoute(this.getSingleSlipRoute());
                this._iconEditor.setIcon(3, "LowerWestToUpperEast", this.getLowerWestToUpperEastIcon());
                this._iconEditor.setIcon(2, "UpperWestToLowerEast", this.getUpperWestToLowerEastIcon());
                this._iconEditor.setIcon(4, "Slip", this.getLowerWestToLowerEastIcon());
                break;
            }
            case 4: {
                this._iconEditor.setSingleSlipRoute(this.getSingleSlipRoute());
                this._iconEditor.setIcon(3, "Upper", this.getLowerWestToUpperEastIcon());
                this._iconEditor.setIcon(2, "Middle", this.getUpperWestToLowerEastIcon());
                this._iconEditor.setIcon(4, "Lower", this.getLowerWestToLowerEastIcon());
                break;
            }
            case 8: {
                this._iconEditor.setSingleSlipRoute(this.getSingleSlipRoute());
                this._iconEditor.setIcon(3, "LowerWestToUpperEast", this.getLowerWestToUpperEastIcon());
                this._iconEditor.setIcon(2, "UpperWestToLowerEast", this.getUpperWestToLowerEastIcon());
                this._iconEditor.setIcon(4, "LowerWestToLowerEast", this.getLowerWestToLowerEastIcon());
                if (this.getSingleSlipRoute()) break;
                this._iconEditor.setTurnout("lowerwest", this.namedTurnoutWestLower);
                this._iconEditor.setTurnout("lowereast", this.namedTurnoutEastLower);
                break;
            }
            default: {
                log.error("getTurnoutType() value {} should not have appeared", (Object)this.getTurnoutType());
            }
        }
        this._iconEditor.setIcon(0, "BeanStateInconsistent", this.getInconsistentIcon());
        this._iconEditor.setIcon(1, "BeanStateUnknown", this.getUnknownIcon());
        this._iconEditor.setTurnout("west", this.namedTurnoutWest);
        this._iconEditor.setTurnout("east", this.namedTurnoutEast);
        this._iconEditor.makeIconPanel(true);
        ActionListener addIconAction = a -> this.updateTurnout();
        this._iconEditor.complete(addIconAction, true, true, true);
    }

    void updateTurnout() {
        this.setTurnoutType(this._iconEditor.getTurnoutType());
        switch (this._iconEditor.getTurnoutType()) {
            case 0: {
                this.setLowerWestToUpperEastIcon(this._iconEditor.getIcon("LowerWestToUpperEast"));
                this.setUpperWestToLowerEastIcon(this._iconEditor.getIcon("UpperWestToLowerEast"));
                this.setLowerWestToLowerEastIcon(this._iconEditor.getIcon("LowerWestToLowerEast"));
                this.setUpperWestToUpperEastIcon(this._iconEditor.getIcon("UpperWestToUpperEast"));
                break;
            }
            case 2: {
                this.setLowerWestToUpperEastIcon(this._iconEditor.getIcon("LowerWestToUpperEast"));
                this.setUpperWestToLowerEastIcon(this._iconEditor.getIcon("UpperWestToLowerEast"));
                this.setSingleSlipRoute(this._iconEditor.getSingleSlipRoute());
                this.setLowerWestToLowerEastIcon(this._iconEditor.getIcon("Slip"));
                break;
            }
            case 4: {
                this.setSingleSlipRoute(this._iconEditor.getSingleSlipRoute());
                this.setLowerWestToUpperEastIcon(this._iconEditor.getIcon("Upper"));
                this.setUpperWestToLowerEastIcon(this._iconEditor.getIcon("Middle"));
                this.setLowerWestToLowerEastIcon(this._iconEditor.getIcon("Lower"));
                break;
            }
            case 8: {
                this.setLowerWestToUpperEastIcon(this._iconEditor.getIcon("LowerWestToUpperEast"));
                this.setUpperWestToLowerEastIcon(this._iconEditor.getIcon("UpperWestToLowerEast"));
                this.setLowerWestToLowerEastIcon(this._iconEditor.getIcon("LowerWestToLowerEast"));
                this.setSingleSlipRoute(this._iconEditor.getSingleSlipRoute());
                if (this.getSingleSlipRoute()) break;
                this.setTurnout(this._iconEditor.getTurnout("lowerwest"), 4);
                this.setTurnout(this._iconEditor.getTurnout("lowereast"), 6);
                break;
            }
            default: {
                log.error("_iconEditor.getTurnoutType() value {} should not have appeared", (Object)this._iconEditor.getTurnoutType());
            }
        }
        this.setInconsistentIcon(this._iconEditor.getIcon("BeanStateInconsistent"));
        this.setUnknownIcon(this._iconEditor.getIcon("BeanStateUnknown"));
        this.setTurnout(this._iconEditor.getTurnout("west"), 1);
        this.setTurnout(this._iconEditor.getTurnout("east"), 2);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    @Override
    public void doMouseClicked(MouseEvent e) {
        if (!this._editor.getFlag(2, this.isControlling())) {
            return;
        }
        if (e.isMetaDown() || e.isAltDown()) {
            return;
        }
        if (this.namedTurnoutWest == null || this.namedTurnoutEast == null) {
            log.error("No turnout connection, can't process click");
            return;
        }
        switch (this.turnoutType) {
            case 0: {
                this.doDoubleSlipMouseClick();
                break;
            }
            case 2: {
                this.doSingleSlipMouseClick();
                break;
            }
            case 4: {
                this.do3WayMouseClick();
                break;
            }
            case 8: {
                this.doScissorMouseClick();
                break;
            }
            default: {
                log.error("turnoutType value {} should not have appeared", (Object)this.turnoutType);
            }
        }
    }

    private void doDoubleSlipMouseClick() {
        switch (this.turnoutState()) {
            case 5: {
                this.setUpperWestToUpperEast();
                break;
            }
            case 7: {
                this.setLowerWestToUpperEast();
                break;
            }
            case 11: {
                this.setLowerWestToLowerEast();
                break;
            }
            default: {
                this.setUpperWestToLowerEast();
            }
        }
    }

    private void doSingleSlipMouseClick() {
        switch (this.turnoutState()) {
            case 5: {
                if (this.singleSlipRoute) {
                    this.setLowerWestToUpperEast();
                    break;
                }
                this.setLowerWestToLowerEast();
                break;
            }
            case 7: 
            case 9: {
                if (this.singleSlipRoute) {
                    this.setUpperWestToLowerEast();
                    break;
                }
                this.setLowerWestToUpperEast();
                break;
            }
            case 11: {
                if (this.singleSlipRoute) {
                    this.setUpperWestToUpperEast();
                    break;
                }
                this.setUpperWestToLowerEast();
                break;
            }
            default: {
                this.setUpperWestToLowerEast();
            }
        }
    }

    private void do3WayMouseClick() {
        switch (this.turnoutState()) {
            case 5: {
                if (this.singleSlipRoute) {
                    this.setLowerWestToLowerEast();
                    break;
                }
                this.setUpperWestToUpperEast();
                break;
            }
            case 7: {
                if (this.singleSlipRoute) {
                    this.setLowerWestToUpperEast();
                    break;
                }
                this.setLowerWestToLowerEast();
                break;
            }
            case 9: {
                if (this.singleSlipRoute) {
                    this.setLowerWestToUpperEast();
                    break;
                }
                this.setUpperWestToLowerEast();
                break;
            }
            case 11: {
                if (this.singleSlipRoute) {
                    this.setUpperWestToLowerEast();
                    break;
                }
                this.setLowerWestToLowerEast();
                break;
            }
            default: {
                this.setLowerWestToUpperEast();
            }
        }
    }

    private void doScissorMouseClick() {
        if (this.turnoutState() == 5) {
            if (this.firstStraight) {
                this.setUpperWestToLowerEast();
                this.firstStraight = false;
            } else {
                this.setLowerWestToUpperEast();
                this.firstStraight = true;
            }
        } else {
            this.setLowerWestToLowerEast();
        }
    }

    protected HashMap<Turnout, Integer> getTurnoutSettings() {
        return this._turnoutSetting;
    }

    protected void reset() {
        this._turnoutSetting = new HashMap();
    }

    private void setUpperWestToLowerEast() {
        this.reset();
        if (this.getTurnoutType() == 8) {
            this._turnoutSetting.put(this.getTurnout(1), 4);
            this._turnoutSetting.put(this.getTurnout(2), 2);
            if (!this.singleSlipRoute) {
                this._turnoutSetting.put(this.namedTurnoutWestLower.getBean(), 2);
                this._turnoutSetting.put(this.namedTurnoutEastLower.getBean(), 4);
            }
        } else {
            this._turnoutSetting.put(this.getTurnout(1), 2);
            this._turnoutSetting.put(this.getTurnout(2), 2);
        }
        this.setSlip();
    }

    private void setLowerWestToUpperEast() {
        this.reset();
        if (this.getTurnoutType() == 8) {
            this._turnoutSetting.put(this.getTurnout(2), 4);
            this._turnoutSetting.put(this.getTurnout(1), 2);
            if (!this.singleSlipRoute) {
                this._turnoutSetting.put(this.namedTurnoutWestLower.getBean(), 4);
                this._turnoutSetting.put(this.namedTurnoutEastLower.getBean(), 2);
            }
        } else {
            this._turnoutSetting.put(this.getTurnout(2), 4);
            this._turnoutSetting.put(this.getTurnout(1), 4);
        }
        this.setSlip();
    }

    private void setUpperWestToUpperEast() {
        this.reset();
        if (this.getTurnoutType() == 8) {
            this._turnoutSetting.put(this.getTurnout(1), 2);
            this._turnoutSetting.put(this.getTurnout(2), 2);
            if (!this.singleSlipRoute) {
                this._turnoutSetting.put(this.namedTurnoutWestLower.getBean(), 2);
                this._turnoutSetting.put(this.namedTurnoutEastLower.getBean(), 2);
            }
        } else {
            this._turnoutSetting.put(this.getTurnout(1), 4);
            this._turnoutSetting.put(this.getTurnout(2), 2);
        }
        this.setSlip();
    }

    private void setLowerWestToLowerEast() {
        this.reset();
        if (this.getTurnoutType() == 8) {
            this._turnoutSetting.put(this.getTurnout(1), 2);
            this._turnoutSetting.put(this.getTurnout(2), 2);
            if (!this.singleSlipRoute) {
                this._turnoutSetting.put(this.namedTurnoutWestLower.getBean(), 2);
                this._turnoutSetting.put(this.namedTurnoutEastLower.getBean(), 2);
            }
        } else {
            this._turnoutSetting.put(this.getTurnout(1), 2);
            this._turnoutSetting.put(this.getTurnout(2), 4);
        }
        this.setSlip();
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        JMenuItem LWLE;
        if (this.isEditable()) {
            boolean returnstate = false;
            if (this.namedTurnoutWest != null && this.getTurnout(1).getFeedbackMode() != 1) {
                this.addTristateEntry(popup);
                returnstate = true;
            }
            if (this.namedTurnoutEast != null && this.getTurnout(2).getFeedbackMode() != 1) {
                this.addTristateEntry(popup);
                returnstate = true;
            }
            return returnstate;
        }
        JMenuItem LWUE = new JMenuItem(this.lowerWestToUpperEastText);
        if (this.turnoutType == 4 && !this.singleSlipRoute) {
            LWUE.addActionListener(e -> this.setLowerWestToLowerEast());
        } else {
            LWUE.addActionListener(e -> this.setLowerWestToUpperEast());
        }
        popup.add(LWUE);
        JMenuItem UWLE = new JMenuItem(this.upperWestToLowerEastText);
        UWLE.addActionListener(e -> this.setUpperWestToLowerEast());
        popup.add(UWLE);
        if (this.turnoutType == 0 || this.turnoutType == 2 && !this.singleSlipRoute) {
            LWLE = new JMenuItem(this.lowerWestToLowerEastText);
            LWLE.addActionListener(e -> this.setLowerWestToLowerEast());
            popup.add(LWLE);
        }
        if (this.turnoutType == 0 || this.turnoutType == 2 && this.singleSlipRoute) {
            JMenuItem UWUE = new JMenuItem(this.upperWestToUpperEastText);
            UWUE.addActionListener(e -> this.setUpperWestToUpperEast());
            popup.add(UWUE);
        }
        if (this.turnoutType == 4) {
            LWLE = new JMenuItem(this.lowerWestToLowerEastText);
            if (!this.singleSlipRoute) {
                LWLE.addActionListener(e -> this.setLowerWestToUpperEast());
            } else {
                LWLE.addActionListener(e -> this.setLowerWestToLowerEast());
            }
            popup.add(LWLE);
        }
        if (this.turnoutType == 8) {
            LWLE = new JMenuItem(this.lowerWestToLowerEastText);
            LWLE.addActionListener(e -> this.setLowerWestToLowerEast());
            popup.add(LWLE);
        }
        return true;
    }

    @Override
    public boolean setTextEditMenu(JPopupMenu popup) {
        String popuptext = Bundle.getMessage("SetSlipText");
        if (this.turnoutType == 4) {
            popuptext = Bundle.getMessage("Set3WayText");
        } else if (this.turnoutType == 8) {
            popuptext = Bundle.getMessage("SetScissorText");
        }
        popup.add(new AbstractAction(popuptext){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = SlipTurnoutIcon.this.getNameString();
                SlipTurnoutIcon.this.slipTurnoutTextEdit(name);
            }
        });
        return true;
    }

    public void slipTurnoutTextEdit(String name) {
        log.debug("make text edit menu");
        SlipTurnoutTextEdit f = new SlipTurnoutTextEdit();
        f.addHelpMenu("package.jmri.jmrit.display.SlipTurnoutTextEdit", true);
        try {
            f.initComponents(this, name);
        }
        catch (Exception ex) {
            log.error("Exception: {}", (Object)ex.toString());
        }
        f.setVisible(true);
    }

    @Override
    public void dispose() {
        if (this.namedTurnoutWest != null) {
            this.getTurnout(1).removePropertyChangeListener(this);
        }
        this.namedTurnoutWest = null;
        if (this.namedTurnoutEast != null) {
            this.getTurnout(2).removePropertyChangeListener(this);
        }
        this.namedTurnoutEast = null;
        if (this.namedTurnoutWestLower != null) {
            this.getTurnout(1).removePropertyChangeListener(this);
        }
        this.namedTurnoutWestLower = null;
        if (this.namedTurnoutEastLower != null) {
            this.getTurnout(2).removePropertyChangeListener(this);
        }
        this.namedTurnoutEastLower = null;
        this.lowerWestToUpperEast = null;
        this.upperWestToLowerEast = null;
        this.lowerWestToLowerEast = null;
        this.upperWestToUpperEast = null;
        this.inconsistent = null;
        this.unknown = null;
        super.dispose();
    }

    protected void setSlipBusy() {
        this.busy = true;
    }

    protected void setSlipNotBusy() {
        this.busy = false;
    }

    protected boolean isSlipBusy() {
        return this.busy;
    }

    private void setSlip() {
        if (!this.busy) {
            this.setSlipBusy();
            SetSlipThread thread = new SetSlipThread(this);
            thread.start();
        }
    }

    static class SetSlipThread
    extends Thread {
        private final SlipTurnoutIcon s;

        public SetSlipThread(SlipTurnoutIcon aSlip) {
            this.s = aSlip;
        }

        @Override
        public void run() {
            HashMap<Turnout, Integer> _turnoutSetting = this.s.getTurnoutSettings();
            _turnoutSetting.forEach((turnout, state) -> {
                ThreadingUtil.runOnLayout(() -> turnout.setCommandedState((int)state));
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            });
            this.s.setSlipNotBusy();
        }
    }
}

