/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.IconAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlipIconAdder
extends IconAdder {
    HashMap<String, NamedBeanHandle<Turnout>> _turnoutMap = new HashMap();
    int _lastIndex = 0;
    public static final String NamedBeanFlavorMime = "application/x-java-jvm-local-objectref;class=jmri.NamedBean";
    int doubleSlip = 0;
    JRadioButton doubleSlipButton = new JRadioButton(Bundle.getMessage("DoubleSlip"));
    JRadioButton singleSlipButton = new JRadioButton(Bundle.getMessage("SingleSlip"));
    JRadioButton threeWayButton = new JRadioButton(Bundle.getMessage("ThreeWay"));
    JRadioButton scissorButton = new JRadioButton(Bundle.getMessage("Scissor"));
    JRadioButton singleDirection = new JRadioButton(Bundle.getMessage("SingleSlipRoute"));
    JRadioButton lowerWestToLowerEastButton = new JRadioButton(Bundle.getMessage("LowerWestToLowerEast"));
    JRadioButton upperWestToUpperEastButton = new JRadioButton(Bundle.getMessage("UpperWestToUpperEast"));
    private static final Logger log = LoggerFactory.getLogger(SlipIconAdder.class);

    public SlipIconAdder() {
    }

    public SlipIconAdder(String type) {
        super(type);
    }

    public void setTurnoutType(int dblSlip) {
        this.doubleSlip = dblSlip;
        this.doubleSlipButton.setSelected(false);
        this.singleSlipButton.setSelected(false);
        this.threeWayButton.setSelected(false);
        this.scissorButton.setSelected(false);
        switch (dblSlip) {
            case 0: {
                this.doubleSlipButton.setSelected(true);
                break;
            }
            case 2: {
                this.singleSlipButton.setSelected(true);
                break;
            }
            case 4: {
                this.threeWayButton.setSelected(true);
                break;
            }
            case 8: {
                this.scissorButton.setSelected(true);
                break;
            }
            default: {
                log.warn("Unhandled dbslip code: {}", (Object)dblSlip);
            }
        }
    }

    public int getTurnoutType() {
        return this.doubleSlip;
    }

    @Override
    public void reset() {
        this._turnoutMap = new HashMap();
        this._lastIndex = 0;
        super.reset();
    }

    @Override
    public void makeIconPanel(boolean useDefaults) {
        JPanel _buttonSlipPanel;
        ButtonGroup group;
        if (this._iconPanel != null) {
            this.remove(this._iconPanel);
        }
        Dimension dim = null;
        this._iconPanel = new JPanel();
        this._iconPanel.setLayout(new BoxLayout(this._iconPanel, 1));
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.doubleSlipButton);
        typeGroup.add(this.singleSlipButton);
        typeGroup.add(this.threeWayButton);
        typeGroup.add(this.scissorButton);
        JPanel _typePanel = new JPanel();
        _typePanel.add(this.doubleSlipButton);
        _typePanel.add(this.singleSlipButton);
        _typePanel.add(this.threeWayButton);
        _typePanel.add(this.scissorButton);
        this._iconPanel.add(_typePanel);
        this.doubleSlipButton.addActionListener(actionEvent -> this.slipUpdate(0));
        this.singleSlipButton.addActionListener(actionEvent -> this.slipUpdate(2));
        this.threeWayButton.addActionListener(actionEvent -> this.slipUpdate(4));
        this.scissorButton.addActionListener(actionEvent -> this.slipUpdate(8));
        if (this.lowerWestToLowerEastButton.getActionListeners().length > 0) {
            this.lowerWestToLowerEastButton.removeActionListener(this.lowerWestToLowerEastButton.getActionListeners()[0]);
        }
        if (this.upperWestToUpperEastButton.getActionListeners().length > 0) {
            this.upperWestToUpperEastButton.removeActionListener(this.upperWestToUpperEastButton.getActionListeners()[0]);
        }
        if (this.getTurnoutType() == 2) {
            group = new ButtonGroup();
            group.add(this.lowerWestToLowerEastButton);
            group.add(this.upperWestToUpperEastButton);
            this.lowerWestToLowerEastButton.setText(Bundle.getMessage("LowerWestToLowerEast"));
            this.upperWestToUpperEastButton.setText(Bundle.getMessage("UpperWestToUpperEast"));
            _buttonSlipPanel = new JPanel();
            _buttonSlipPanel.add(this.lowerWestToLowerEastButton);
            _buttonSlipPanel.add(this.upperWestToUpperEastButton);
            this._iconPanel.add(_buttonSlipPanel);
            this.lowerWestToLowerEastButton.addActionListener(actionEvent -> this.updateSingleSlipRoute(false));
            this.upperWestToUpperEastButton.addActionListener(actionEvent -> this.updateSingleSlipRoute(true));
        } else if (this.getTurnoutType() == 4) {
            group = new ButtonGroup();
            this.lowerWestToLowerEastButton.setText(Bundle.getMessage("ToLower"));
            this.upperWestToUpperEastButton.setText(Bundle.getMessage("ToUpper"));
            group.add(this.lowerWestToLowerEastButton);
            group.add(this.upperWestToUpperEastButton);
            _buttonSlipPanel = new JPanel();
            _buttonSlipPanel.add(this.lowerWestToLowerEastButton);
            _buttonSlipPanel.add(this.upperWestToUpperEastButton);
            this._iconPanel.add(_buttonSlipPanel);
        } else if (this.getTurnoutType() == 8) {
            group = new ButtonGroup();
            this.lowerWestToLowerEastButton.setText("4 Turnouts");
            this.upperWestToUpperEastButton.setText("2 Turnouts");
            group.add(this.lowerWestToLowerEastButton);
            group.add(this.upperWestToUpperEastButton);
            _buttonSlipPanel = new JPanel();
            _buttonSlipPanel.add(this.lowerWestToLowerEastButton);
            _buttonSlipPanel.add(this.upperWestToUpperEastButton);
            this._iconPanel.add(_buttonSlipPanel);
            this.lowerWestToLowerEastButton.addActionListener(actionEvent -> this.changeNumScissorTurnouts());
            this.upperWestToUpperEastButton.addActionListener(actionEvent -> this.changeNumScissorTurnouts());
        }
        JPanel rowPanel = null;
        int cnt = 0;
        int numTurnoutPanels = 2;
        if (this.doubleSlip == 8 && this.lowerWestToLowerEastButton.isSelected()) {
            numTurnoutPanels = 4;
        }
        int i = 0;
        while (i < numTurnoutPanels) {
            String key;
            String label;
            if (rowPanel == null) {
                rowPanel = new JPanel();
                rowPanel.setLayout(new BoxLayout(rowPanel, 0));
                rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            }
            DropPanel p3 = new DropPanel();
            p3.setLayout(new BoxLayout(p3, 1));
            JPanel p4 = new JPanel();
            if (i == 0) {
                label = this.doubleSlip == 4 ? Bundle.getMessage("FirstTurnout") : (this.doubleSlip == 8 ? (this.lowerWestToLowerEastButton.isSelected() ? Bundle.getMessage("UpperWestTurnout") : Bundle.getMessage("RHCrossing")) : Bundle.getMessage("WestTurnout"));
                key = "west";
            } else if (i == 1) {
                key = "east";
                label = this.doubleSlip == 4 ? Bundle.getMessage("SecondTurnout") : (this.doubleSlip == 8 ? (this.lowerWestToLowerEastButton.isSelected() ? Bundle.getMessage("UpperEastTurnout") : Bundle.getMessage("LHCrossing")) : Bundle.getMessage("EastTurnout"));
            } else if (i == 2) {
                key = "lowerwest";
                label = Bundle.getMessage("LowerWestTurnout");
            } else {
                key = "lowereast";
                label = Bundle.getMessage("LowerEastTurnout");
            }
            NamedBeanHandle<Turnout> turnout = this._turnoutMap.get(key);
            JLabel k = new JLabel(key);
            k.setName(key);
            k.setVisible(false);
            p3.add(k);
            p4.add(new JLabel(label));
            p3.add(p4);
            p4 = new JPanel();
            String name = Bundle.getMessage("notSet");
            Color color = Color.RED;
            if (turnout != null) {
                name = turnout.getName();
                color = Color.BLACK;
            }
            p4.setBorder(BorderFactory.createLineBorder(color));
            p4.add(new JLabel(name));
            p4.setMaximumSize(p4.getPreferredSize());
            p3.add(p4);
            JPanel p13 = new JPanel();
            p13.setLayout(new BoxLayout(p13, 0));
            p13.add(p3);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(p13);
            panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            rowPanel.add(panel);
            rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
            if (++cnt % 2 == 0) {
                this._iconPanel.add(rowPanel);
                rowPanel = null;
            }
            dim = panel.getPreferredSize();
            ++i;
        }
        while (cnt % 2 != 0) {
            Objects.requireNonNull(rowPanel, "rowPanel should have been non-null in this case");
            rowPanel.add(Box.createRigidArea(dim));
            ++cnt;
        }
        if (rowPanel != null) {
            this._iconPanel.add(rowPanel);
            this._iconPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        }
        rowPanel = new JPanel();
        rowPanel.setLayout(new BoxLayout(rowPanel, 0));
        rowPanel.add(Box.createHorizontalStrut(STRUT_SIZE));
        JPanel panel = null;
        cnt = 0;
        int i2 = this._iconOrderList.size() - 1;
        while (i2 >= 0) {
            if (panel == null) {
                panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.add(Box.createHorizontalStrut(STRUT_SIZE));
            }
            String key = (String)this._iconOrderList.get(i2);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(new JLabel(Bundle.getMessage(key)));
            p.add((Component)this._iconMap.get(key));
            panel.add(p);
            panel.add(Box.createHorizontalStrut(STRUT_SIZE));
            if ((cnt & 1) != 0) {
                this._iconPanel.add(panel);
                this._iconPanel.add(Box.createVerticalStrut(STRUT_SIZE));
                panel = null;
            }
            ++cnt;
            --i2;
        }
        if (panel != null) {
            this._iconPanel.add(panel);
            this._iconPanel.add(Box.createVerticalStrut(STRUT_SIZE));
        }
        this.add((Component)this._iconPanel, 0);
        this.valueChanged(null);
        this.pack();
    }

    void changeNumScissorTurnouts() {
        if (this.upperWestToUpperEastButton.isSelected()) {
            this._turnoutMap.remove("lowerwest");
            this._turnoutMap.remove("lowereast");
        }
        this.makeIconPanel(true);
    }

    void slipUpdate(int slip) {
        if (slip == this.doubleSlip) {
            return;
        }
        if (this.doubleSlip == 4 || this.doubleSlip == 8) {
            this.delete(4);
            this.delete(3);
            this.delete(2);
            this._turnoutMap.remove("lowerwest");
            this._turnoutMap.remove("lowereast");
            this.setIcon(3, "LowerWestToUpperEast", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-upper-east.gif");
            this.setIcon(2, "UpperWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-slip-upper-west-lower-east.gif");
            this.setIcon(4, "LowerWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-lower-east.gif");
            this.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/os-slip-error-full.gif");
            this.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/os-slip-unknown-full.gif");
        }
        if (slip == 4) {
            this.delete(5);
            this.delete(4);
            this.delete(3);
            this.delete(2);
            this.setIcon(3, "Upper", "resources/icons/smallschematics/tracksegments/os-3way-upper.gif");
            this.setIcon(2, "Middle", "resources/icons/smallschematics/tracksegments/os-3way-middle.gif");
            this.setIcon(4, "Lower", "resources/icons/smallschematics/tracksegments/os-3way-lower.gif");
            this.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/os-3way-error.gif");
            this.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/os-3way-unknown.gif");
            this.upperWestToUpperEastButton.setSelected(true);
        } else if (slip == 8) {
            this.delete(5);
            this.setIcon(3, "LowerWestToUpperEast", "resources/icons/smallschematics/tracksegments/os-double-crossover-lower-west-upper-east.gif");
            this.setIcon(2, "UpperWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-double-crossover-upper-west-lower-east.gif");
            this.setIcon(4, "LowerWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-double-crossover-closed.gif");
            this.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/os-double-crossover-error.gif");
            this.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/os-double-crossover-unknown.gif");
            this.upperWestToUpperEastButton.setSelected(true);
        }
        switch (slip) {
            case 0: {
                this.delete(4);
                this.setIcon(4, "LowerWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-lower-east.gif");
                this.setIcon(5, "UpperWestToUpperEast", "resources/icons/smallschematics/tracksegments/os-slip-upper-west-upper-east.gif");
                break;
            }
            case 2: {
                this.delete(5);
                this.updateSingleSlipRoute(false);
                break;
            }
            default: {
                log.warn("Unhandled slip code: {}", (Object)slip);
            }
        }
        this.doubleSlip = slip;
        this.makeIconPanel(true);
    }

    @Override
    public void complete(ActionListener addIconAction, boolean changeIconAction, boolean addToTable, boolean update) {
        super.complete(addIconAction, changeIconAction, addToTable, update);
        this._table.setDragEnabled(true);
        this._table.setTransferHandler(new ExportHandler());
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this._addButton == null) {
            return;
        }
        int numTurnouts = 2;
        if (this.doubleSlip == 8 && this.lowerWestToLowerEastButton.isSelected()) {
            numTurnouts = 4;
        }
        if (this._turnoutMap.size() == numTurnouts) {
            this._addButton.setEnabled(true);
            this._addButton.setToolTipText(null);
        } else {
            this._addButton.setEnabled(false);
            this._addButton.setToolTipText(Bundle.getMessage("ToolTipAssignTurnouts"));
        }
    }

    void delete(int index) {
        if (index >= this._iconOrderList.size()) {
            return;
        }
        String key = (String)this._iconOrderList.get(index);
        if (log.isDebugEnabled()) {
            log.debug("delete({}) Sizes: _iconMap= {}, _iconOrderList= {}", new Object[]{index, this._iconMap.size(), this._iconOrderList.size()});
        }
        this._iconMap.remove(key);
        this._iconOrderList.remove(index);
    }

    public NamedIcon getIcon(int index) {
        return (NamedIcon)((JToggleButton)this._iconMap.get(this._iconOrderList.get(index))).getIcon();
    }

    public NamedBeanHandle<Turnout> getTurnout(String index) {
        return this._turnoutMap.get(index);
    }

    public void setTurnout(String key, NamedBeanHandle<Turnout> turnout) {
        this._turnoutMap.put(key, turnout);
    }

    void updateSingleSlipRoute(boolean single) {
        this.delete(4);
        if (single) {
            this.upperWestToUpperEastButton.setSelected(true);
            this.setIcon(4, "Slip", "resources/icons/smallschematics/tracksegments/os-slip-upper-west-upper-east.gif");
        } else {
            this.lowerWestToLowerEastButton.setSelected(true);
            this.setIcon(4, "Slip", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-lower-east.gif");
        }
        this.makeIconPanel(true);
    }

    public void setSingleSlipRoute(boolean single) {
        if (single) {
            this.upperWestToUpperEastButton.setSelected(true);
        } else {
            this.lowerWestToLowerEastButton.setSelected(true);
        }
    }

    public boolean getSingleSlipRoute() {
        return this.upperWestToUpperEastButton.isSelected();
    }

    private boolean putTurnout(String key, Turnout turnout) {
        String name = turnout.getUserName();
        if (name == null) {
            name = turnout.getSystemName();
        }
        for (NamedBeanHandle<Turnout> turnoutNamedBeanHandle : this._turnoutMap.values()) {
            if (!name.equals(turnoutNamedBeanHandle.getName())) continue;
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("DupTurnoutName"), name), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        this._turnoutMap.put(key, InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, turnout));
        return true;
    }

    class DropPanel
    extends JPanel
    implements DropTargetListener {
        DataFlavor dataFlavor;

        DropPanel() {
            try {
                this.dataFlavor = new DataFlavor(SlipIconAdder.NamedBeanFlavorMime);
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Unable to find class supporting {}", (Object)SlipIconAdder.NamedBeanFlavorMime, (Object)cnfe);
            }
            new DropTarget(this, 3, this);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                Transferable tr = e.getTransferable();
                if (e.isDataFlavorSupported(this.dataFlavor)) {
                    Turnout turnout = (Turnout)tr.getTransferData(this.dataFlavor);
                    if (turnout != null) {
                        e.acceptDrop(3);
                        DropTarget target = (DropTarget)e.getSource();
                        JPanel panel = (JPanel)target.getComponent();
                        JLabel comp = (JLabel)panel.getComponent(0);
                        if (SlipIconAdder.this.putTurnout(comp.getName(), turnout)) {
                            SlipIconAdder.this.makeIconPanel(true);
                        }
                        e.dropComplete(true);
                        if (log.isDebugEnabled()) {
                            log.debug("DropPanel.drop COMPLETED for {}", (Object)comp.getName());
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("DropPanel.drop REJECTED!");
                        }
                        e.rejectDrop();
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                if (log.isDebugEnabled()) {
                    log.debug("DropPanel.drop REJECTED!");
                }
                e.rejectDrop();
            }
        }
    }

    class ExportHandler
    extends TransferHandler {
        ExportHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new TransferableNamedBean();
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
        }
    }

    class TransferableNamedBean
    implements Transferable {
        DataFlavor dataFlavor;

        TransferableNamedBean() {
            try {
                this.dataFlavor = new DataFlavor(SlipIconAdder.NamedBeanFlavorMime);
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Unable to find class supporting {}", (Object)SlipIconAdder.NamedBeanFlavorMime, (Object)cnfe);
            }
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.dataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.dataFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (log.isDebugEnabled()) {
                log.debug("TransferableNamedBean.getTransferData ");
            }
            if (this.isDataFlavorSupported(flavor)) {
                return SlipIconAdder.this.getTableSelection();
            }
            return null;
        }
    }
}

