/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SectionManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Transit;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.TransitCreationTool;
import jmri.jmrit.display.palette.SignalMastItemPanel;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.signalling.SignallingSourceAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastIcon
extends PositionableIcon
implements PropertyChangeListener {
    private NamedBeanHandle<SignalMast> namedMast;
    ButtonGroup litButtonGroup = null;
    static TransitCreationTool tct;
    SignalMastItemPanel _itemPanel;
    String useIconSet = "default";
    protected int clickMode = 0;
    protected boolean litMode = false;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(SignalMastIcon.class);
    }

    public SignalMastIcon(Editor editor) {
        super(editor);
        this._control = true;
    }

    public void setShowAutoText(boolean state) {
        this._text = state;
        this._icon = !this._text;
    }

    @Override
    public Positionable deepClone() {
        SignalMastIcon pos = new SignalMastIcon(this._editor);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(SignalMastIcon pos) {
        pos.setSignalMast(this.getNamedSignalMast());
        pos._iconMap = SignalMastIcon.cloneMap(this._iconMap, pos);
        pos.setClickMode(this.getClickMode());
        pos.setLitMode(this.getLitMode());
        pos.useIconSet(this.useIconSet());
        return super.finishClone(pos);
    }

    public void setSignalMast(NamedBeanHandle<SignalMast> sh) {
        if (this.namedMast != null) {
            this.getSignalMast().removePropertyChangeListener(this);
        }
        this.namedMast = sh;
        if (this.namedMast != null) {
            this.getIcons();
            this.displayState(this.mastState());
            this.getSignalMast().addPropertyChangeListener(this, this.namedMast.getName(), "SignalMast Icon");
        }
    }

    public void setSignalMast(String pName) {
        SignalMast mMast = (SignalMast)InstanceManager.getDefault(SignalMastManager.class).getNamedBean(pName);
        if (mMast == null) {
            log.warn("did not find a SignalMast named {}", (Object)pName);
        } else {
            this.setSignalMast(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, mMast));
        }
    }

    private void getIcons() {
        this._iconMap = new HashMap();
        Enumeration<String> e = this.getSignalMast().getAppearanceMap().getAspects();
        boolean error = false;
        while (e.hasMoreElements()) {
            String aspect = e.nextElement();
            error = this.loadIcons(aspect);
        }
        if (error) {
            JOptionPane.showMessageDialog(this._editor.getTargetFrame(), MessageFormat.format(Bundle.getMessage("SignalMastIconLoadError"), this.getSignalMast().getDisplayName()), Bundle.getMessage("SignalMastIconLoadErrorTitle"), 0);
        }
        this.loadIcons("$dark");
        this.loadIcons("$held");
    }

    private boolean loadIcons(String aspect) {
        NamedIcon n;
        String s = this.getSignalMast().getAppearanceMap().getImageLink(aspect, this.useIconSet);
        if (s.equals("")) {
            if (aspect.startsWith("$")) {
                log.debug("No icon found for specific appearance {}", (Object)aspect);
            } else {
                log.error("No icon found for appearance {}", (Object)aspect);
            }
            return true;
        }
        if (!s.contains("preference:")) {
            s = s.substring(s.indexOf("resources"));
        }
        try {
            n = new NamedIcon(s, s);
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("SignalMastIconLoadError2", aspect, s, this.getNameString()), Bundle.getMessage("SignalMastIconLoadErrorTitle"), 0);
            log.error(Bundle.getMessage("SignalMastIconLoadError2", aspect, s, this.getNameString()));
            return true;
        }
        this._iconMap.put(s, n);
        if (this._rotate != 0) {
            n.rotate(this._rotate, this);
        }
        if (this._scale != 1.0) {
            n.scale(this._scale, this);
        }
        return false;
    }

    public NamedBeanHandle<SignalMast> getNamedSignalMast() {
        return this.namedMast;
    }

    public SignalMast getSignalMast() {
        if (this.namedMast == null) {
            return null;
        }
        return this.namedMast.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getSignalMast();
    }

    public String mastState() {
        if (this.getSignalMast() == null) {
            return "<empty>";
        }
        return this.getSignalMast().getAspect();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("property change: {} current state: {}", (Object)e.getPropertyName(), (Object)this.mastState());
        this.displayState(this.mastState());
        this._editor.getTargetPanel().repaint();
    }

    @Override
    public String getNameString() {
        String name = this.getSignalMast() == null ? Bundle.getMessage("NotConnected") : this.getSignalMast().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            JMenu clickMenu = new JMenu(Bundle.getMessage("WhenClicked"));
            ButtonGroup clickButtonGroup = new ButtonGroup();
            JRadioButtonMenuItem r = new JRadioButtonMenuItem(Bundle.getMessage("ChangeAspect"));
            r.addActionListener(e -> this.setClickMode(0));
            clickButtonGroup.add(r);
            if (this.clickMode == 0) {
                r.setSelected(true);
            } else {
                r.setSelected(false);
            }
            clickMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("AlternateLit"));
            r.addActionListener(e -> this.setClickMode(1));
            clickButtonGroup.add(r);
            if (this.clickMode == 1) {
                r.setSelected(true);
            } else {
                r.setSelected(false);
            }
            clickMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("AlternateHeld"));
            r.addActionListener(e -> this.setClickMode(2));
            clickButtonGroup.add(r);
            if (this.clickMode == 2) {
                r.setSelected(true);
            } else {
                r.setSelected(false);
            }
            clickMenu.add(r);
            popup.add(clickMenu);
            JMenu litMenu = new JMenu(Bundle.getMessage("WhenNotLit"));
            this.litButtonGroup = new ButtonGroup();
            r = new JRadioButtonMenuItem(Bundle.getMessage("ShowAppearance"));
            r.setIconTextGap(10);
            r.addActionListener(e -> {
                this.setLitMode(false);
                this.displayState(this.mastState());
            });
            this.litButtonGroup.add(r);
            if (!this.litMode) {
                r.setSelected(true);
            } else {
                r.setSelected(false);
            }
            litMenu.add(r);
            r = new JRadioButtonMenuItem(Bundle.getMessage("ShowDarkIcon"));
            r.setIconTextGap(10);
            r.addActionListener(e -> {
                this.setLitMode(true);
                this.displayState(this.mastState());
            });
            this.litButtonGroup.add(r);
            if (this.litMode) {
                r.setSelected(true);
            } else {
                r.setSelected(false);
            }
            litMenu.add(r);
            popup.add(litMenu);
            if (this.namedMast != null) {
                Enumeration<String> en = this.getSignalMast().getSignalSystem().getImageTypeList();
                if (en.hasMoreElements()) {
                    JMenu iconSetMenu = new JMenu(Bundle.getMessage("SignalMastIconSet"));
                    ButtonGroup iconTypeGroup = new ButtonGroup();
                    this.setImageTypeList(iconTypeGroup, iconSetMenu, "default");
                    while (en.hasMoreElements()) {
                        this.setImageTypeList(iconTypeGroup, iconSetMenu, en.nextElement());
                    }
                    popup.add(iconSetMenu);
                }
                popup.add(new SignallingSourceAction(Bundle.getMessage("SignalMastLogic"), this.getSignalMast()));
                JMenu aspect = new JMenu(Bundle.getMessage("ChangeAspect"));
                final Vector<String> aspects = this.getSignalMast().getValidAspects();
                int i = 0;
                while (i < aspects.size()) {
                    final int index = i++;
                    aspect.add(new AbstractAction(aspects.elementAt(index)){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SignalMastIcon.this.getSignalMast().setAspect((String)aspects.elementAt(index));
                        }
                    });
                }
                popup.add(aspect);
            }
            this.addTransitPopup(popup);
        } else {
            final Vector<String> aspects = this.getSignalMast().getValidAspects();
            int i = 0;
            while (i < aspects.size()) {
                final int index = i++;
                popup.add(new AbstractAction(aspects.elementAt(index)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SignalMastIcon.this.getSignalMast().setAspect((String)aspects.elementAt(index));
                    }
                });
            }
        }
        return true;
    }

    private void addTransitPopup(JPopupMenu popup) {
        if (InstanceManager.getDefault(SectionManager.class).getNamedBeanSet().size() > 0 && InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            if (tct == null) {
                tct = new TransitCreationTool();
            }
            popup.addSeparator();
            String addString = Bundle.getMessage("MenuTransitCreate");
            if (tct.isToolInUse()) {
                addString = Bundle.getMessage("MenuTransitAddTo");
            }
            popup.add(new AbstractAction(addString){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        tct.addNamedBean(SignalMastIcon.this.getSignalMast());
                    }
                    catch (JmriException ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), Bundle.getMessage("TransitErrorTitle"), 0);
                    }
                }
            });
            if (tct.isToolInUse()) {
                popup.add(new AbstractAction(Bundle.getMessage("MenuTransitAddComplete")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            tct.addNamedBean(SignalMastIcon.this.getSignalMast());
                            Transit created = tct.createTransit();
                            JOptionPane.showMessageDialog(null, Bundle.getMessage("TransitCreatedMessage", created.getDisplayName()), Bundle.getMessage("TransitCreatedTitle"), 1);
                        }
                        catch (JmriException ex) {
                            JOptionPane.showMessageDialog(null, ex.getMessage(), Bundle.getMessage("TransitErrorTitle"), 0);
                            return;
                        }
                    }
                });
                popup.add(new AbstractAction(Bundle.getMessage("MenuTransitCancel")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        tct.cancelTransitCreate();
                    }
                });
            }
            popup.addSeparator();
        }
    }

    private void setImageTypeList(ButtonGroup iconTypeGroup, JMenu iconSetMenu, String item) {
        JRadioButtonMenuItem im = new JRadioButtonMenuItem(item);
        im.addActionListener(e -> this.useIconSet(item));
        iconTypeGroup.add(im);
        if (this.useIconSet.equals(item)) {
            im.setSelected(true);
        } else {
            im.setSelected(false);
        }
        iconSetMenu.add(im);
    }

    @Override
    public boolean setRotateOrthogonalMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean setEditItemMenu(JPopupMenu popup) {
        String txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameSignalMast"));
        popup.add(new AbstractAction(txt){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalMastIcon.this.editItem();
            }
        });
        return true;
    }

    protected void editItem() {
        this._paletteFrame = this.makePaletteFrame(MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage("BeanNameSignalMast")));
        this._itemPanel = new SignalMastItemPanel(this._paletteFrame, "SignalMast", this.getFamily(), PickListModel.signalMastPickModelInstance());
        ActionListener updateAction = a -> this.updateItem();
        this._itemPanel.init(updateAction, this._iconMap);
        this._itemPanel.setSelection(this.getSignalMast());
        this.initPaletteFrame(this._paletteFrame, this._itemPanel);
    }

    void updateItem() {
        this.setSignalMast(((SignalMast)this._itemPanel.getTableSelection()).getSystemName());
        this.setFamily(this._itemPanel.getFamilyName());
        this.finishItemUpdate(this._paletteFrame, this._itemPanel);
    }

    @Override
    public void doMouseClicked(MouseEvent e) {
        if (!this._editor.getFlag(2, this.isControlling())) {
            return;
        }
        this.performMouseClicked(e);
    }

    public void performMouseClicked(MouseEvent e) {
        if (e.isMetaDown() || e.isAltDown()) {
            return;
        }
        if (this.getSignalMast() == null) {
            log.error("No turnout connection, can't process click");
            return;
        }
        switch (this.clickMode) {
            case 0: {
                Vector<String> aspects = this.getSignalMast().getValidAspects();
                int idx = aspects.indexOf(this.getSignalMast().getAspect()) + 1;
                if (idx >= aspects.size()) {
                    idx = 0;
                }
                this.getSignalMast().setAspect(aspects.elementAt(idx));
                return;
            }
            case 1: {
                this.getSignalMast().setLit(!this.getSignalMast().getLit());
                return;
            }
            case 2: {
                this.getSignalMast().setHeld(!this.getSignalMast().getHeld());
                return;
            }
        }
        log.error("Click in mode {}", (Object)this.clickMode);
    }

    public void useIconSet(String icon) {
        if (icon == null) {
            icon = "default";
        }
        if (this.useIconSet.equals(icon)) {
            return;
        }
        this._iconMap = null;
        this.useIconSet = icon;
        this.getIcons();
        this.displayState(this.mastState());
        this._editor.getTargetPanel().repaint();
    }

    public String useIconSet() {
        return this.useIconSet;
    }

    @Override
    public void displayState(int s) {
        this.displayState(this.mastState());
    }

    public void displayState(String state) {
        this.updateSize();
        if (log.isDebugEnabled()) {
            if (this.getSignalMast() == null) {
                log.debug("Display state {}, disconnected", (Object)state);
            } else {
                log.debug("Display state {} for {}", (Object)state, (Object)this.getSignalMast().getSystemName());
            }
        }
        if (this.isText()) {
            if (this.getSignalMast().getHeld()) {
                if (this.isText()) {
                    super.setText(Bundle.getMessage("Held"));
                }
                return;
            }
            if (this.getLitMode() && !this.getSignalMast().getLit()) {
                super.setText(Bundle.getMessage("Dark"));
                return;
            }
            super.setText(state);
        }
        if (this.isIcon()) {
            if (state != null && this.getSignalMast() != null) {
                String s = this.getSignalMast().getAppearanceMap().getImageLink(state, this.useIconSet);
                if (this.getSignalMast().getHeld() && this.getSignalMast().getAppearanceMap().getSpecificAppearance(0) != null) {
                    s = this.getSignalMast().getAppearanceMap().getImageLink("$held", this.useIconSet);
                } else if (this.getLitMode() && !this.getSignalMast().getLit() && this.getSignalMast().getAppearanceMap().getImageLink("$dark", this.useIconSet) != null) {
                    s = this.getSignalMast().getAppearanceMap().getImageLink("$dark", this.useIconSet);
                }
                if (s.equals("")) {
                    return;
                }
                if (!s.contains("preference:")) {
                    s = s.substring(s.indexOf("resources"));
                }
                if (this._iconMap == null) {
                    this.getIcons();
                }
                NamedIcon n = (NamedIcon)this._iconMap.get(s);
                super.setIcon(n);
                this.updateSize();
                this.setSize(n.getIconWidth(), n.getIconHeight());
            }
        } else {
            super.setIcon(null);
        }
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    protected void rotateOrthogonal() {
        super.rotateOrthogonal();
        this.displayState(this.mastState());
        this.repaint();
    }

    @Override
    public void rotate(int deg) {
        super.rotate(deg);
        if (this.getSignalMast() != null) {
            this.displayState(this.mastState());
        }
    }

    @Override
    public void setScale(double s) {
        super.setScale(s);
        if (this.getSignalMast() != null) {
            this.displayState(this.mastState());
        }
    }

    public void setClickMode(int mode) {
        this.clickMode = mode;
    }

    public int getClickMode() {
        return this.clickMode;
    }

    public void setLitMode(boolean mode) {
        this.litMode = mode;
    }

    public boolean getLitMode() {
        return this.litMode;
    }

    @Override
    public void dispose() {
        if (this.namedMast != null) {
            this.getSignalMast().removePropertyChangeListener(this);
        }
        super.dispose();
    }
}

