/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.MeasurementListener;
import jmri.util.HelpUtil;

public class RpsPositionIcon
extends PositionableLabel
implements MeasurementListener {
    String activeName = "resources/icons/smallschematics/tracksegments/circuit-occupied.gif";
    NamedIcon active = new NamedIcon(this.activeName, this.activeName);
    String errorName = "resources/icons/smallschematics/tracksegments/circuit-error.gif";
    NamedIcon error = new NamedIcon(this.errorName, this.errorName);
    JCheckBoxMenuItem showIdItem = null;
    Notifier notify;
    JCheckBoxMenuItem momentaryItem;
    boolean state = false;
    boolean momentary = false;
    String filterNumber = null;
    Measurement lastMeasurement;
    double sxScale;
    double syScale;
    int sxOrigin;
    int syOrigin;

    public RpsPositionIcon(Editor editor) {
        super(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), editor);
        this._control = true;
        this.displayState();
        this.setFont(this.getFont().deriveFont(24.0f));
        Distributor.instance().addMeasurementListener(this);
    }

    public NamedIcon getActiveIcon() {
        return this.active;
    }

    public void setActiveIcon(NamedIcon i) {
        this.active = i;
        this.displayState();
    }

    public NamedIcon getErrorIcon() {
        return this.error;
    }

    public void setErrorIcon(NamedIcon i) {
        this.error = i;
        this.displayState();
    }

    @Override
    public String getNameString() {
        return "RPS Position Readout";
    }

    @Override
    public boolean setEditIconMenu(JPopupMenu popup) {
        return false;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.showIdItem == null) {
            this.showIdItem = new JCheckBoxMenuItem("Show ID");
            this.showIdItem.setSelected(false);
            this.showIdItem.addActionListener(e -> this.toggleID(this.showIdItem.isSelected()));
        }
        popup.add(this.showIdItem);
        popup.add(new AbstractAction("Set Origin"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RpsPositionIcon.this.setRpsOrigin();
            }
        });
        popup.add(new AbstractAction("Set Current Location"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RpsPositionIcon.this.setRpsCurrentLocation();
            }
        });
        this.notify = new Notifier();
        popup.add(this.notify);
        popup.add(new AbstractAction("Set Filter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RpsPositionIcon.this.setFilterPopup();
            }
        });
        JMenuItem item = new JMenuItem("Help");
        HelpUtil.addHelpToComponent(item, "package.jmri.jmrit.display.RpsIcon");
        popup.add(item);
        this.notify.setPosition(this.getX(), this.getY());
        return false;
    }

    @Override
    protected void rotateOrthogonal() {
        this.active.setRotation(this.active.getRotation() + 1, this);
        this.error.setRotation(this.error.getRotation() + 1, this);
        this.displayState();
        this.repaint();
    }

    @Override
    public void setScale(double s) {
        this.active.scale(s, this);
        this.error.scale(s, this);
        this.displayState();
    }

    @Override
    public void rotate(int deg) {
        this.active.rotate(deg, this);
        this.error.rotate(deg, this);
        this.displayState();
    }

    void displayState() {
        if (this.state) {
            if (this.isIcon()) {
                super.setIcon(this.active);
            }
        } else if (this.isIcon()) {
            super.setIcon(this.error);
        }
        this.updateSize();
        this.revalidate();
    }

    @Override
    public int maxHeight() {
        return this.getPreferredSize().height;
    }

    @Override
    public int maxWidth() {
        return this.getPreferredSize().width;
    }

    public boolean getMomentary() {
        return this.momentary;
    }

    public void setMomentary(boolean m) {
        this.momentary = m;
    }

    void toggleID(boolean value) {
        if (value) {
            this._text = true;
        } else {
            this._text = false;
            this.setText(null);
        }
        this.displayState();
    }

    public boolean isShowID() {
        return this._text;
    }

    public void setShowID(boolean mode) {
        this._text = mode;
        this.displayState();
    }

    @Override
    public void notify(Measurement m) {
        if (this.filterNumber != null && m.getReading() != null && !this.filterNumber.equals(m.getReading().getId())) {
            return;
        }
        this.lastMeasurement = m;
        this.state = m.isOkPoint() && !(m.getZ() < -20.0) && !(m.getZ() > 20.0);
        if (this._text) {
            super.setText(m.getReading().getId());
        }
        this.displayState();
        if (!this.state) {
            return;
        }
        double xn = m.getX();
        double yn = m.getY();
        int x = this.sxOrigin + (int)(this.sxScale * xn);
        int y = this.syOrigin + (int)(this.syScale * yn);
        this.setLocation(x, y);
    }

    public void setFilterPopup() {
        String inputValue = JOptionPane.showInputDialog("Please enter a filter value");
        if (inputValue == null) {
            return;
        }
        this.setFilter(inputValue);
    }

    public void setFilter(String val) {
        this.filterNumber = val;
    }

    public String getFilter() {
        return this.filterNumber;
    }

    @Override
    public void dispose() {
        Distributor.instance().removeMeasurementListener(this);
        this.active = null;
        this.error = null;
        super.dispose();
    }

    public void setRpsOrigin() {
        this.sxOrigin = this.getX();
        this.syOrigin = this.getY();
    }

    public double getXScale() {
        return this.sxScale;
    }

    public double getYScale() {
        return this.syScale;
    }

    public int getXOrigin() {
        return this.sxOrigin;
    }

    public int getYOrigin() {
        return this.syOrigin;
    }

    public void setTransform(double sxScale, double syScale, int sxOrigin, int syOrigin) {
        this.sxScale = sxScale;
        this.syScale = syScale;
        this.sxOrigin = sxOrigin;
        this.syOrigin = syOrigin;
    }

    public void setRpsCurrentLocation() {
        if (this.lastMeasurement == null) {
            return;
        }
        if (this.sxOrigin == this.getX()) {
            return;
        }
        if (this.syOrigin == this.getY()) {
            return;
        }
        this.sxScale = (double)(this.getX() - this.sxOrigin) / this.lastMeasurement.getX();
        this.syScale = (double)(this.getY() - this.syOrigin) / this.lastMeasurement.getY();
    }

    class Notifier
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
        }

        void setPosition(int x, int y) {
            double epsilon = 1.0E-5;
            if (RpsPositionIcon.this.sxScale > -epsilon && RpsPositionIcon.this.sxScale < epsilon || RpsPositionIcon.this.syScale > -epsilon && RpsPositionIcon.this.syScale < epsilon) {
                this.putValue("Name", "Not Calibrated");
                return;
            }
            double xn = (double)(x - RpsPositionIcon.this.sxOrigin) / RpsPositionIcon.this.sxScale;
            double yn = (double)(y - RpsPositionIcon.this.syOrigin) / RpsPositionIcon.this.syScale;
            this.putValue("Name", "At: " + xn + "," + yn);
        }
    }
}

