/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeListener;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.MemoryIcon;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.SensorIcon;
import jmri.util.swing.SplitButtonColorChooserPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionablePropertiesUtil {
    Frame mFrame = null;
    protected Positionable _parent;
    JPanel detailpanel = new JPanel();
    JTabbedPane propertiesPanel;
    JComponent _textPanel;
    JTextField fontSizeField;
    String[] _justification = new String[]{Bundle.getMessage("left"), Bundle.getMessage("right"), Bundle.getMessage("center")};
    JComboBox<String> _justificationCombo;
    ActionListener previewActionListener = actionEvent -> this.preview();
    ChangeListener spinnerChangeListener = actionEvent -> this.preview();
    FocusListener textFieldFocus = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField tmp = (JTextField)e.getSource();
            if (tmp.getText().equals("")) {
                tmp.setText("0");
                PositionablePropertiesUtil.this.preview();
            }
        }
    };
    KeyListener previewKeyActionListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent E) {
        }

        @Override
        public void keyPressed(KeyEvent E) {
        }

        @Override
        public void keyReleased(KeyEvent E) {
            JTextField tmp = (JTextField)E.getSource();
            if (!tmp.getText().equals("")) {
                PositionablePropertiesUtil.this.preview();
            }
        }
    };
    ChangeListener previewChangeListener = ce -> this.preview();
    private JColorChooser borderColorChooser = null;
    JSpinner borderSizeTextSpin;
    JSpinner marginSizeTextSpin;
    JSpinner xPositionTextSpin;
    JSpinner yPositionTextSpin;
    JSpinner widthSizeTextSpin;
    JSpinner heightSizeTextSpin;
    JCheckBox autoWidth;
    PositionablePopupUtil pop;
    private int fontStyle;
    private Color defaultForeground = Color.black;
    private Color defaultBackground;
    private Color defaultBorderColor = Color.black;
    private int fixedWidth = 0;
    private int fixedHeight = 0;
    private int marginSize = 0;
    private int borderSize = 0;
    private int justification;
    private int fontSize;
    private int xPos;
    private int yPos;
    private ArrayList<TextDetails> txtList = null;
    private final JCheckBox italic = new JCheckBox(Bundle.getMessage("Italic"), false);
    private final JCheckBox bold = new JCheckBox(Bundle.getMessage("Bold"), false);
    protected JList<String> fontSizeChoice;
    protected String[] fontSizes = new String[]{"6", "8", "10", "11", "12", "14", "16", "20", "24", "28", "32", "36"};
    private static final Logger log = LoggerFactory.getLogger(PositionablePropertiesUtil.class);

    PositionablePropertiesUtil(Positionable p) {
        this._parent = p;
    }

    public void display() {
        this.propertiesPanel = new JTabbedPane();
        this.getCurrentValues();
        JPanel exampleHolder = new JPanel();
        for (TextDetails textDetails : this.txtList) {
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createTitledBorder(textDetails.getDescription()));
            p.add(textDetails.getLabel());
            exampleHolder.add(p);
        }
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 1));
        tmp.add(this.propertiesPanel);
        tmp.add(this.detailpanel);
        tmp.add(exampleHolder);
        this.textPanel();
        this.editText();
        this.borderPanel();
        this.sizePosition();
        JPanel _buttonArea = new JPanel();
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        _buttonArea.add(cancel);
        cancel.addActionListener(e -> {
            this.undoChanges();
            this.mFrame.dispose();
        });
        JButton applyButton = new JButton(Bundle.getMessage("ButtonApply"));
        _buttonArea.add(applyButton);
        applyButton.addActionListener(e -> this.fontApply());
        JButton okButton = new JButton(Bundle.getMessage("ButtonOK"));
        _buttonArea.add(okButton);
        okButton.addActionListener(e -> {
            this.fontApply();
            this.mFrame.dispose();
        });
        tmp.add(_buttonArea);
        exampleHolder.setBackground(this._parent.getParent().getBackground());
        this.mFrame = new JFrame(this._parent.getNameString());
        this.mFrame.add(tmp);
        this.mFrame.pack();
        this.mFrame.setVisible(true);
        this.preview();
    }

    void textPanel() {
        this._textPanel = new JPanel();
        this._textPanel.setLayout(new BoxLayout(this._textPanel, 1));
        JPanel fontColorPanel = new JPanel();
        fontColorPanel.add(new JLabel(String.valueOf(Bundle.getMessage("FontColor")) + ": "));
        JPanel fontSizePanel = new JPanel();
        fontSizePanel.setLayout(new BoxLayout(fontSizePanel, 1));
        this.fontSizeChoice = new JList<String>(this.fontSizes);
        this.fontSizeChoice.setSelectedValue("" + this.fontSize, true);
        this.fontSizeChoice.setSelectionMode(0);
        JScrollPane listScroller = new JScrollPane(this.fontSizeChoice);
        listScroller.setPreferredSize(new Dimension(60, 80));
        JPanel FontPanel2 = new JPanel();
        this.fontSizeField = new JTextField("" + this.fontSize, this.fontSizeChoice.getWidth());
        this.fontSizeField.addKeyListener(this.previewKeyActionListener);
        fontSizePanel.add(this.fontSizeField);
        fontSizePanel.add(listScroller);
        FontPanel2.add(fontSizePanel);
        JPanel Style2 = new JPanel();
        Style2.setLayout(new BoxLayout(Style2, 1));
        Style2.add(this.bold);
        Style2.add(this.italic);
        FontPanel2.add(Style2);
        this._textPanel.add(FontPanel2);
        JPanel justificationPanel = new JPanel();
        this._justificationCombo = new JComboBox<String>(this._justification);
        switch (this.justification) {
            case 0: {
                this._justificationCombo.setSelectedIndex(0);
                break;
            }
            case 2: {
                this._justificationCombo.setSelectedIndex(1);
                break;
            }
            default: {
                this._justificationCombo.setSelectedIndex(2);
            }
        }
        justificationPanel.add(new JLabel(String.valueOf(Bundle.getMessage("Justification")) + ": "));
        justificationPanel.add(this._justificationCombo);
        this._textPanel.add(justificationPanel);
        this._justificationCombo.addActionListener(this.previewActionListener);
        this.bold.addActionListener(this.previewActionListener);
        this.italic.addActionListener(this.previewActionListener);
        this.fontSizeChoice.getSelectionModel().addListSelectionListener(e -> {
            this.fontSizeField.setText(this.fontSizeChoice.getSelectedValue());
            this.preview();
        });
        int i = 0;
        while (i < this.txtList.size()) {
            int x = i;
            JPanel txtPanel = new JPanel();
            JColorChooser txtColorChooser = new JColorChooser(this.defaultForeground);
            txtColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] txtColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            txtColorChooser.setChooserPanels(txtColorPanels);
            txtColorChooser.getSelectionModel().addChangeListener(this.previewChangeListener);
            txtPanel.add(txtColorChooser);
            txtColorChooser.getSelectionModel().addChangeListener(ce -> this.txtList.get(x).setForeground(txtColorChooser.getColor()));
            JPanel p = new JPanel();
            p.add(new JLabel(String.valueOf(Bundle.getMessage("FontColor")) + ": "));
            p.add(txtColorChooser);
            txtPanel.add(p);
            this.defaultBackground = this._parent.getBackground();
            JColorChooser txtBackColorChooser = new JColorChooser(this.defaultBackground);
            txtBackColorChooser.setPreviewPanel(new JPanel());
            AbstractColorChooserPanel[] txtBackColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
            txtBackColorChooser.setChooserPanels(txtBackColorPanels);
            txtBackColorChooser.getSelectionModel().addChangeListener(this.previewChangeListener);
            txtPanel.add(txtBackColorChooser);
            txtBackColorChooser.getSelectionModel().addChangeListener(ce -> this.txtList.get(x).setBackground(txtBackColorChooser.getColor()));
            p = new JPanel();
            p.add(new JLabel(String.valueOf(Bundle.getMessage("FontBackgroundColor")) + ": "));
            p.add(txtBackColorChooser);
            String _borderTitle = this.txtList.get(i).getDescription();
            if (_borderTitle.equals(Bundle.getMessage("TextExampleLabel"))) {
                _borderTitle = Bundle.getMessage("TextDecoLabel");
            }
            txtPanel.setBorder(BorderFactory.createTitledBorder(_borderTitle));
            txtPanel.add(p);
            this._textPanel.add(txtPanel);
            ++i;
        }
        this.propertiesPanel.addTab(Bundle.getMessage("FontTabTitle"), null, this._textPanel, Bundle.getMessage("FontTabTooltip"));
    }

    void borderPanel() {
        JPanel borderPanel = new JPanel();
        this.borderColorChooser = new JColorChooser(this.defaultBorderColor);
        AbstractColorChooserPanel[] borderColorPanels = new AbstractColorChooserPanel[]{new SplitButtonColorChooserPanel()};
        this.borderColorChooser.setChooserPanels(borderColorPanels);
        this.borderColorChooser.setPreviewPanel(new JPanel());
        this.borderColorChooser.getSelectionModel().addChangeListener(this.previewChangeListener);
        JPanel borderColorPanel = new JPanel();
        borderColorPanel.add(new JLabel(String.valueOf(Bundle.getMessage("borderColor")) + ": "));
        borderColorPanel.add(this.borderColorChooser);
        JPanel borderSizePanel = new JPanel();
        this.borderSizeTextSpin = this.getSpinner(this.borderSize, Bundle.getMessage("borderSize"));
        this.borderSizeTextSpin.addChangeListener(this.spinnerChangeListener);
        borderSizePanel.add(new JLabel(String.valueOf(Bundle.getMessage("borderSize")) + ": "));
        borderSizePanel.add(this.borderSizeTextSpin);
        JPanel marginSizePanel = new JPanel();
        this.marginSizeTextSpin = this.getSpinner(this.marginSize, Bundle.getMessage("marginSize"));
        this.marginSizeTextSpin.addChangeListener(this.spinnerChangeListener);
        marginSizePanel.add(new JLabel(String.valueOf(Bundle.getMessage("marginSize")) + ": "));
        marginSizePanel.add(this.marginSizeTextSpin);
        borderPanel.setLayout(new BoxLayout(borderPanel, 1));
        borderPanel.add(borderColorPanel);
        borderPanel.add(borderSizePanel);
        borderPanel.add(marginSizePanel);
        this.propertiesPanel.addTab(Bundle.getMessage("Border"), null, borderPanel, Bundle.getMessage("BorderTabTooltip"));
    }

    void editText() {
        JPanel editText = new JPanel();
        editText.setLayout(new BoxLayout(editText, 1));
        int i = 0;
        while (i < this.txtList.size()) {
            final int x = i;
            JPanel p = new JPanel();
            String _borderTitle = this.txtList.get(i).getDescription();
            if (_borderTitle.equals(Bundle.getMessage("TextExampleLabel"))) {
                _borderTitle = Bundle.getMessage("TextBorderLabel");
            }
            p.setBorder(BorderFactory.createTitledBorder(_borderTitle));
            JLabel txt = new JLabel(String.valueOf(Bundle.getMessage("TextValueLabel")) + ": ");
            JTextField textField = new JTextField(this.txtList.get(i).getText(), 20);
            textField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent E) {
                }

                @Override
                public void keyPressed(KeyEvent E) {
                }

                @Override
                public void keyReleased(KeyEvent E) {
                    JTextField tmp = (JTextField)E.getSource();
                    ((TextDetails)PositionablePropertiesUtil.this.txtList.get(x)).setText(tmp.getText());
                    PositionablePropertiesUtil.this.preview();
                }
            });
            p.add(txt);
            p.add(textField);
            editText.add(p);
            ++i;
        }
        this.propertiesPanel.addTab(Bundle.getMessage("EditTextLabel"), null, editText, Bundle.getMessage("EditTabTooltip"));
    }

    void sizePosition() {
        JPanel posPanel = new JPanel();
        JPanel xyPanel = new JPanel();
        xyPanel.setLayout(new BoxLayout(xyPanel, 1));
        JPanel xPanel = new JPanel();
        JLabel txt = new JLabel(" X: ");
        this.xPositionTextSpin = this.getSpinner(this.xPos, "x position");
        this.xPositionTextSpin.addChangeListener(this.spinnerChangeListener);
        xPanel.add(txt);
        xPanel.add(this.xPositionTextSpin);
        JPanel yPanel = new JPanel();
        txt = new JLabel(" Y: ");
        this.yPositionTextSpin = this.getSpinner(this.yPos, "y position");
        this.yPositionTextSpin.addChangeListener(this.spinnerChangeListener);
        yPanel.add(txt);
        yPanel.add(this.yPositionTextSpin);
        xyPanel.add(xPanel);
        xyPanel.add(yPanel);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 1));
        JPanel widthPanel = new JPanel();
        this.widthSizeTextSpin = this.getSpinner(this.fixedWidth, Bundle.getMessage("width"));
        this.widthSizeTextSpin.addChangeListener(this.spinnerChangeListener);
        txt = new JLabel(String.valueOf(Bundle.getMessage("width")) + ": ");
        widthPanel.add(txt);
        widthPanel.add(this.widthSizeTextSpin);
        JPanel heightPanel = new JPanel();
        this.heightSizeTextSpin = this.getSpinner(this.fixedHeight, Bundle.getMessage("height"));
        this.heightSizeTextSpin.addChangeListener(this.spinnerChangeListener);
        txt = new JLabel(String.valueOf(Bundle.getMessage("height")) + ": ");
        heightPanel.add(txt);
        heightPanel.add(this.heightSizeTextSpin);
        sizePanel.add(widthPanel);
        sizePanel.add(heightPanel);
        posPanel.add(xyPanel);
        posPanel.add(sizePanel);
        posPanel.setLayout(new BoxLayout(posPanel, 1));
        this.propertiesPanel.addTab(Bundle.getMessage("SizeTabTitle"), null, posPanel, Bundle.getMessage("SizeTabTooltip"));
    }

    void fontApply() {
        this.pop.setFontSize(Integer.parseInt(this.fontSizeField.getText()));
        if (this.bold.isSelected()) {
            this.pop.setFontStyle(1, 0);
        } else {
            this.pop.setFontStyle(0, 1);
        }
        if (this.italic.isSelected()) {
            this.pop.setFontStyle(2, 0);
        } else {
            this.pop.setFontStyle(0, 2);
        }
        if (this._parent instanceof SensorIcon) {
            SensorIcon si = (SensorIcon)this._parent;
            if (si.isIcon()) {
                PositionableLabel pp = (PositionableLabel)this._parent;
                pp.setText(this.txtList.get(0).getText());
                this.pop.setForeground(this.txtList.get(0).getForeground());
                this.pop.setBackgroundColor(this.txtList.get(0).getBackground());
            } else {
                si.setActiveText(this.txtList.get(0).getText());
                si.setTextActive(this.txtList.get(0).getForeground());
                si.setBackgroundActive(this.txtList.get(0).getBackground());
                si.setInactiveText(this.txtList.get(1).getText());
                si.setTextInActive(this.txtList.get(1).getForeground());
                si.setBackgroundInActive(this.txtList.get(1).getBackground());
                si.setUnknownText(this.txtList.get(2).getText());
                si.setTextUnknown(this.txtList.get(2).getForeground());
                si.setBackgroundUnknown(this.txtList.get(2).getBackground());
                si.setInconsistentText(this.txtList.get(3).getText());
                si.setTextInconsistent(this.txtList.get(3).getForeground());
                si.setBackgroundInconsistent(this.txtList.get(3).getBackground());
            }
        } else {
            PositionableLabel pp = (PositionableLabel)this._parent;
            pp.setText(this.txtList.get(0).getText());
            this.pop.setForeground(this.txtList.get(0).getForeground());
            this.pop.setBackgroundColor(this.txtList.get(0).getBackground());
        }
        int deg = this._parent.getDegrees();
        if (deg != 0) {
            this._parent.rotate(0);
        }
        Color desiredColor = this.borderColorChooser.getColor();
        this.pop.setBorderColor(desiredColor);
        this.pop.setBorderSize(((Number)this.borderSizeTextSpin.getValue()).intValue());
        this.pop.setMargin(((Number)this.marginSizeTextSpin.getValue()).intValue());
        this._parent.setLocation(((Number)this.xPositionTextSpin.getValue()).intValue(), ((Number)this.yPositionTextSpin.getValue()).intValue());
        this.pop.setFixedWidth(((Number)this.widthSizeTextSpin.getValue()).intValue());
        this.pop.setFixedHeight(((Number)this.heightSizeTextSpin.getValue()).intValue());
        switch (this._justificationCombo.getSelectedIndex()) {
            case 0: {
                this.pop.setJustification(0);
                break;
            }
            case 1: {
                this.pop.setJustification(2);
                break;
            }
            case 2: {
                this.pop.setJustification(4);
                break;
            }
            default: {
                log.warn("Unhandled combo index: {}", (Object)this._justificationCombo.getSelectedIndex());
            }
        }
        this._parent.rotate(deg);
    }

    void cancelButton() {
        this.mFrame.dispose();
    }

    void preview() {
        int attrs = 0;
        if (this.bold.isSelected()) {
            attrs = 1;
        }
        if (this.italic.isSelected()) {
            attrs |= 2;
        }
        Font newFont = new Font(this._parent.getFont().getName(), attrs, Integer.parseInt(this.fontSizeField.getText()));
        Color desiredColor = this.borderColorChooser.getColor();
        int margin = ((Number)this.marginSizeTextSpin.getValue()).intValue();
        Border outlineBorder = desiredColor != null ? new LineBorder(desiredColor, ((Number)this.borderSizeTextSpin.getValue()).intValue()) : BorderFactory.createEmptyBorder(0, 0, 0, 0);
        int hoz = 0;
        switch (this._justificationCombo.getSelectedIndex()) {
            case 0: {
                hoz = 2;
                break;
            }
            case 1: {
                hoz = 4;
                break;
            }
            case 2: {
                hoz = 0;
                break;
            }
            default: {
                log.warn("Unhandled combo index: {}", (Object)this._justificationCombo.getSelectedIndex());
            }
        }
        for (TextDetails textDetails : this.txtList) {
            JLabel tmp = textDetails.getLabel();
            Border borderMargin = tmp.isOpaque() ? new LineBorder(tmp.getBackground(), margin) : BorderFactory.createEmptyBorder(margin, margin, margin, margin);
            tmp.setFont(newFont);
            tmp.setHorizontalAlignment(hoz);
            tmp.setBorder(new CompoundBorder(outlineBorder, borderMargin));
            tmp.setSize(new Dimension(this.maxWidth(tmp), this.maxHeight(tmp)));
            tmp.setPreferredSize(new Dimension(this.maxWidth(tmp), this.maxHeight(tmp)));
        }
        this.mFrame.pack();
    }

    int maxWidth(JLabel tmp) {
        int max = 0;
        if (((Number)this.widthSizeTextSpin.getValue()).intValue() != 0) {
            max = ((Number)this.widthSizeTextSpin.getValue()).intValue();
            max += ((Number)this.borderSizeTextSpin.getValue()).intValue() * 2;
        } else {
            if (tmp.getText().trim().length() > 0) {
                max = tmp.getFontMetrics(tmp.getFont()).stringWidth(tmp.getText());
            }
            if (this.pop != null) {
                max += ((Number)this.marginSizeTextSpin.getValue()).intValue() * 2;
                max += ((Number)this.borderSizeTextSpin.getValue()).intValue() * 2;
            }
        }
        return max;
    }

    public int maxHeight(JLabel tmp) {
        int max = 0;
        if (((Number)this.heightSizeTextSpin.getValue()).intValue() != 0) {
            max = ((Number)this.heightSizeTextSpin.getValue()).intValue();
            max += ((Number)this.borderSizeTextSpin.getValue()).intValue() * 2;
        } else {
            if (tmp.getText().trim().length() > 0) {
                max = tmp.getFontMetrics(tmp.getFont()).getHeight();
            }
            if (this.pop != null) {
                max += ((Number)this.marginSizeTextSpin.getValue()).intValue() * 2;
                max += ((Number)this.borderSizeTextSpin.getValue()).intValue() * 2;
            }
        }
        return max;
    }

    private void undoChanges() {
        if (this._parent instanceof SensorIcon) {
            SensorIcon si = (SensorIcon)this._parent;
            if (si.isIcon()) {
                PositionableLabel pp = (PositionableLabel)this._parent;
                pp.setText(this.txtList.get(0).getOrigText());
                this.pop.setForeground(this.txtList.get(0).getOrigForeground());
                this.pop.setBackgroundColor(this.txtList.get(0).getOrigBackground());
            } else {
                si.setActiveText(this.txtList.get(0).getOrigText());
                si.setTextActive(this.txtList.get(0).getOrigForeground());
                si.setBackgroundActive(this.txtList.get(0).getOrigBackground());
                si.setInactiveText(this.txtList.get(1).getOrigText());
                si.setTextInActive(this.txtList.get(1).getOrigForeground());
                si.setBackgroundInActive(this.txtList.get(1).getOrigBackground());
                si.setUnknownText(this.txtList.get(2).getOrigText());
                si.setTextUnknown(this.txtList.get(2).getOrigForeground());
                si.setBackgroundUnknown(this.txtList.get(2).getOrigBackground());
                si.setInconsistentText(this.txtList.get(3).getOrigText());
                si.setTextInconsistent(this.txtList.get(3).getOrigForeground());
                si.setBackgroundInconsistent(this.txtList.get(3).getOrigBackground());
            }
        } else {
            PositionableLabel pp = (PositionableLabel)this._parent;
            pp.setText(this.txtList.get(0).getOrigText());
            this.pop.setForeground(this.txtList.get(0).getOrigForeground());
            this.pop.setBackgroundColor(this.txtList.get(0).getOrigBackground());
        }
        int deg = this._parent.getDegrees();
        if (deg != 0) {
            this._parent.rotate(0);
        }
        this.pop.setJustification(this.justification);
        this.pop.setFixedWidth(this.fixedWidth);
        this.pop.setFixedHeight(this.fixedHeight);
        this.pop.setMargin(this.marginSize);
        this.pop.setBorderSize(this.borderSize);
        this.pop.setFontStyle(0, this.fontStyle);
        this.pop.setFontSize(this.fontSize);
        this.pop.setBorderColor(this.defaultBorderColor);
        this._parent.setLocation(this.xPos, this.yPos);
        this._parent.rotate(deg);
    }

    private void getCurrentValues() {
        this.pop = this._parent.getPopupUtility();
        this.txtList = new ArrayList();
        if (this._parent instanceof SensorIcon) {
            SensorIcon si = (SensorIcon)this._parent;
            if (si.isIcon()) {
                this.txtList.add(new TextDetails(Bundle.getMessage("TextExampleLabel"), this.pop.getText(), this.pop.getForeground(), this.pop.getBackground()));
            } else {
                this.txtList.add(new TextDetails(Bundle.getMessage("SensorStateActive"), si.getActiveText(), si.getTextActive(), si.getBackgroundActive()));
                this.txtList.add(new TextDetails(Bundle.getMessage("SensorStateInactive"), si.getInactiveText(), si.getTextInActive(), si.getBackgroundInActive()));
                this.txtList.add(new TextDetails(Bundle.getMessage("BeanStateUnknown"), si.getUnknownText(), si.getTextUnknown(), si.getBackgroundUnknown()));
                this.txtList.add(new TextDetails(Bundle.getMessage("BeanStateInconsistent"), si.getInconsistentText(), si.getTextInconsistent(), si.getBackgroundInconsistent()));
            }
        } else {
            this.txtList.add(new TextDetails(Bundle.getMessage("TextExampleLabel"), this.pop.getText(), this.pop.getForeground(), this.pop.getBackground()));
        }
        this.fixedWidth = this.pop.getFixedWidth();
        this.fixedHeight = this.pop.getFixedHeight();
        this.marginSize = this.pop.getMargin();
        this.borderSize = this.pop.getBorderSize();
        this.justification = this.pop.getJustification();
        this.fontStyle = this.pop.getFontStyle();
        this.fontSize = this.pop.getFontSize();
        if ((1 & this.fontStyle) == 1) {
            this.bold.setSelected(true);
        }
        if ((2 & this.fontStyle) == 2) {
            this.italic.setSelected(true);
        }
        if (this._parent.isOpaque()) {
            this.defaultBackground = this._parent.getBackground();
        }
        this.defaultForeground = this.pop.getForeground();
        this.defaultBorderColor = this.pop.getBorderColor();
        if (this._parent instanceof MemoryIcon) {
            MemoryIcon pm = (MemoryIcon)this._parent;
            this.xPos = pm.getOriginalX();
            this.yPos = pm.getOriginalY();
        } else {
            this.xPos = this._parent.getX();
            this.yPos = this._parent.getY();
        }
    }

    JSpinner getSpinner(int value, String tooltip) {
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1000, 1);
        JSpinner spinX = new JSpinner(model);
        spinX.setValue(value);
        spinX.setToolTipText(tooltip);
        spinX.setMaximumSize(new Dimension(spinX.getMaximumSize().width, spinX.getPreferredSize().height));
        return spinX;
    }

    static class TextDetails {
        Color foreground;
        Color background;
        Color origForeground;
        Color origBackground;
        String origText;
        String text;
        JLabel example;
        String description;

        TextDetails(String desc, String txt, Color fore, Color back) {
            this.text = txt == null ? "" : txt;
            this.description = desc;
            this.example = new JLabel(this.text);
            this.setForeground(fore);
            this.setBackground(back);
            this.origForeground = fore;
            this.origBackground = back;
            this.origText = txt;
        }

        Color getForeground() {
            return this.foreground;
        }

        Color getBackground() {
            return this.background;
        }

        String getText() {
            return this.text;
        }

        Color getOrigForeground() {
            return this.origForeground;
        }

        Color getOrigBackground() {
            return this.origBackground;
        }

        String getOrigText() {
            return this.origText;
        }

        String getDescription() {
            return this.description;
        }

        void setForeground(Color fore) {
            this.foreground = fore;
            this.example.setForeground(fore);
        }

        void setBackground(Color back) {
            this.background = back;
            if (back != null) {
                this.example.setOpaque(true);
                this.example.setBackground(back);
            } else {
                this.example.setOpaque(false);
            }
        }

        void setText(String txt) {
            this.text = txt;
            this.example.setText(txt);
        }

        JLabel getLabel() {
            return this.example;
        }
    }
}

